/*
 * Copyright (c) 2009, 2010, 2011, 2012, 2013, 2014, B3log Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.b3log.solo.model;


/**
 * This class defines all link model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.2, Oct 31, 2011
 * @since  0.3.1
 */
public final class Link {

    /**
     * Link.
     */
    public static final String LINK = "link";

    /**
     * Links.
     */
    public static final String LINKS = "links";

    /**
     * Key of title.
     */
    public static final String LINK_TITLE = "linkTitle";

    /**
     * Key of address.
     */
    public static final String LINK_ADDRESS = "linkAddress";

    /**
     * Key of description.
     */
    public static final String LINK_DESCRIPTION = "linkDescription";

    /**
     * Key of order.
     */
    public static final String LINK_ORDER = "linkOrder";

    /**
     * Private default constructor.
     */
    private Link() {}
}
