/*
 * Copyright (c) 2010-2016, b3log.org & hacpai.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.b3log.solo.model;


/**
 * This class defines all comment model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.7, Jan 18, 2013
 * @since 0.3.1
 */
public final class Comment {

    /**
     * Comment.
     */
    public static final String COMMENT = "comment";

    /**
     * Comments.
     */
    public static final String COMMENTS = "comments";

    /**
     * Key of comment.
     */
    public static final String COMMENT_CONTENT = "commentContent";

    /**
     * Key of comment name.
     */
    public static final String COMMENT_NAME = "commentName";

    /**
     * Key of comment email.
     */
    public static final String COMMENT_EMAIL = "commentEmail";

    /**
     * Key of comment URL.
     */
    public static final String COMMENT_URL = "commentURL";

    /**
     * Key of comment sharp URL.
     */
    public static final String COMMENT_SHARP_URL = "commentSharpURL";

    /**
     * Key of comment date.
     */
    public static final String COMMENT_DATE = "commentDate";

    /**
     * Key of comment time.
     */
    public static final String COMMENT_TIME = "commentTime";

    /**
     * Key of comment thumbnail URL.
     */
    public static final String COMMENT_THUMBNAIL_URL = "commentThumbnailURL";

    /**
     * Key of original comment id.
     */
    public static final String COMMENT_ORIGINAL_COMMENT_ID = "commentOriginalCommentId";

    /**
     * Key of original comment user name.
     */
    public static final String COMMENT_ORIGINAL_COMMENT_NAME = "commentOriginalCommentName";

    /**
     * Key of comment on type.
     */
    public static final String COMMENT_ON_TYPE = "commentOnType";

    /**
     * Key of comment on id.
     */
    public static final String COMMENT_ON_ID = "commentOnId";

    /**
     * Private default constructor.
     */
    private Comment() {}
}
