<p align = "center">
<img alt="Solo" src="https://user-images.githubusercontent.com/873584/52320401-2593e600-2a0a-11e9-9ba1-db79ee71d1af.png">
<br><br>
小而美的博客系统，专为程序员设计
<br><br>
<a title="Build Status" target="_blank" href="https://travis-ci.org/88250/solo"><img src="https://img.shields.io/travis/88250/solo.svg?style=flat-square"></a>
<a title="Docker Image CI" target="_blank" href="https://github.com/88250/solo/actions"><img src="https://img.shields.io/github/workflow/status/88250/solo/Docker%20Image%20CI?color=blue&label=Actions&logo=github&style=flat-square"></a>
<a title="Coverage Status" target="_blank" href="https://coveralls.io/github/88250/solo"><img src="https://img.shields.io/coveralls/github/88250/solo.svg?style=flat-square&color=CC9933"></a>
<a title="Code Size" target="_blank" href="https://github.com/88250/solo"><img src="https://img.shields.io/github/languages/code-size/88250/solo.svg?style=flat-square&color=6699FF"></a>
<a title="AGPLv3" target="_blank" href="https://www.gnu.org/licenses/agpl-3.0.txt"><img src="http://img.shields.io/badge/license-AGPLv3-orange.svg?style=flat-square"></a>
<br>
<a title="Releases" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/release/88250/solo.svg?style=flat-square&color=CC6666"></a>
<a title="Release Date" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/release-date/88250/solo.svg?style=flat-square&color=99CCFF"></a>
<a title="Downloads" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/downloads/88250/solo/total.svg?style=flat-square&color=99CC99"></a>
<a title="Docker Pulls" target="_blank" href="https://hub.docker.com/r/88250/solo"><img src="https://img.shields.io/docker/pulls/88250/solo.svg?style=flat-square&color=blueviolet"></a>
<br>
<a title="GitHub Commits" target="_blank" href="https://github.com/88250/solo/commits/master"><img src="https://img.shields.io/github/commit-activity/m/88250/solo.svg?style=flat-square"></a>
<a title="Last Commit" target="_blank" href="https://github.com/88250/solo/commits/master"><img src="https://img.shields.io/github/last-commit/88250/solo.svg?style=flat-square&color=FF9900"></a>
<a title="GitHub Pull Requests" target="_blank" href="https://github.com/88250/solo/pulls"><img src="https://img.shields.io/github/issues-pr-closed/88250/solo.svg?style=flat-square&color=FF9966"></a>
<a title="Hits" target="_blank" href="https://github.com/88250/hits"><img src="https://hits.b3log.org/88250/solo.svg"></a>
<br><br>
<a title="GitHub Watchers" target="_blank" href="https://github.com/88250/solo/watchers"><img src="https://img.shields.io/github/watchers/88250/solo.svg?label=Watchers&style=social"></a>  
<a title="GitHub Stars" target="_blank" href="https://github.com/88250/solo/stargazers"><img src="https://img.shields.io/github/stars/88250/solo.svg?label=Stars&style=social"></a>  
<a title="GitHub Forks" target="_blank" href="https://github.com/88250/solo/network/members"><img src="https://img.shields.io/github/forks/88250/solo.svg?label=Forks&style=social"></a>  
<a title="Author GitHub Followers" target="_blank" href="https://github.com/88250"><img src="https://img.shields.io/github/followers/88250.svg?label=Followers&style=social"></a>
</p>

## 💡 简介

[Solo](https://solo.b3log.org) 是一款小而美的开源博客系统，专为程序员设计。Solo 有着非常活跃的[社区](https://hacpai.com)，可将文章作为帖子推送到社区，来自社区的回帖将作为博客评论进行联动（具体细节请浏览 [B3log 构思 - 分布式社区网络](https://hacpai.com/article/1546941897596)）。

> 这是一种全新的网络社区体验，让热爱记录和分享的你不再感到孤单！

欢迎到 [Solo 官方讨论区](https://hacpai.com/tag/sym)了解更多。同时也欢迎关注 B3log 开源社区微信公众号 `B3log开源`：

![b3logos.png](https://img.hacpai.com/file/2019/10/image-d3c00d78.png)

## 🗃 案例

https://hacpai.com/top/solo

## ✨ 功能

* Markdown / Emoji
* [标签聚合分类](https://hacpai.com/article/1558320086126)
* 自定义导航链接
* 随机文章 / 相关文章 / 置顶 / 更新提醒
* 自定义文章永久链接 / 签名档
* 配置站点 SEO 参数 / 公告 / 页脚
* 代码高亮 / 数学公式 / 流程图 / 五线谱
* [多皮肤，多端适配](https://github.com/88250/solo-skins) / [社区皮肤](https://github.com/88250/solo-third-skins)
* 多语言 / 国际化
* 友情链接管理
* 多用户写作，团队博客
* [Hexo / Jekyll / Markdown 导入](https://hacpai.com/article/1498490209748)
* SQL / JSON / Markdown 导出
* Atom / RSS / Sitemap
* CDN 静态资源分离
* [拉取 GitHub 仓库和自动备份](https://hacpai.com/article/1557238327458)
* [内置 HTTPS+CDN 文件存储](https://hacpai.com/article/1559928188793)
* [支持生成导出静态站点](https://hacpai.com/article/1579053576274)，用于发布 GitHub Pages

## 🎨 界面

### 开始使用

![start.png](https://img.hacpai.com/file/2020/03/start-6fec3c72.png)

### 后台首页

![console.png](https://img.hacpai.com/file/2020/03/console-ff45ec74.png)

### 编辑文章

![post.png](https://img.hacpai.com/file/2020/03/post-acb91edb.png)

### 选择皮肤

![skins.png](https://img.hacpai.com/file/2019/08/61179517afd61b00a63611e987d5ddea6d6a0fc9-0d368d02.png)

### 前台界面

![pinghsu.png](https://img.hacpai.com/file/2020/03/pinghsu-91c48743.png)

![Bubble.png](https://img.hacpai.com/file/2020/03/Bubble-84bee365.png)

![nijigen.png](https://img.hacpai.com/file/2020/03/nijigen-30de3aaa.png)

![timeline.png](https://img.hacpai.com/file/2020/03/timeline-094af4c3.png)

![Casper.png](https://img.hacpai.com/file/2020/03/Casper-2d5ed59d.png)

![Jane.png](https://img.hacpai.com/file/2020/03/Jane-55b0414c.png)

## 🍱 皮肤

目前内置的皮肤如下，可点击进行预览：

* [Bubble](https://88250.b3log.org/?skin=Bubble)
* [Casper](https://88250.b3log.org/?skin=Casper)
* [Pinghsu](https://88250.b3log.org/?skin=Pinghsu)
* [Jane](https://88250.b3log.org/?skin=Jane)
* [nijigen](https://88250.b3log.org/?skin=nijigen)
* [Medium](https://88250.b3log.org/?skin=Medium)
* [9IPHP](https://88250.b3log.org/?skin=9IPHP)
* [Andrea](https://88250.b3log.org/?skin=Andrea)
* [Bruce](https://88250.b3log.org/?skin=Bruce)
* [Community](https://88250.b3log.org/?skin=Community)
* [favourite](https://88250.b3log.org/?skin=favourite)
* [Finding](https://88250.b3log.org/?skin=Finding)
* [i-nove](https://88250.b3log.org/?skin=i-nove)
* [metro-hot](https://88250.b3log.org/?skin=metro-hot)
* [NeoEase](https://88250.b3log.org/?skin=NeoEase)
* [next](https://88250.b3log.org/?skin=next)
* [owmx-3.0](https://88250.b3log.org/?skin=owmx-3.0)
* [timeline](https://88250.b3log.org/?skin=timeline)
* [tree-house](https://88250.b3log.org/?skin=tree-house)
* [yilia](https://88250.b3log.org/?skin=yilia)

欢迎在[该 issue](https://github.com/88250/solo/issues/12449) 下推荐好看的皮肤，我们会尽量进行制作。

## 🛠️ 安装

Solo 支持“动静两用”：

* 动态博客：在服务器上搭建，进程常驻内存运行，在线使用
* 静态博客：在本地电脑运行，写作完成后生成导出静态站点

### 本地运行

本地运行主要用于试用或者生成静态站点，生成静态站点的用法请参考[这里](https://hacpai.com/article/1579053576274)。

[下载](https://github.com/88250/solo/releases)最新的 Solo 包解压，进入解压目录执行：

* Windows: `java -cp "lib/*;." org.b3log.solo.Server`
* Unix-like： `java -cp "lib/*:." org.b3log.solo.Server`

如果你有 Java 开发环境，可参考[这里](https://hacpai.com/article/1493822943172)通过源码构建运行。

本地运行

### Docker 部署

Docker 方式部署是动态博客用法，主要用于在服务器上部署动态博客。

#### 获取最新镜像

```shell
docker pull b3log/solo
```

#### 启动容器

* 使用 MySQL
  先手动建库（库名 `solo` ，字符集使用 `utf8mb4` ，排序规则 `utf8mb4_general_ci` ），然后启动容器：
  ```shell
  docker run --detach --name solo --network=host \
      --env RUNTIME_DB="MYSQL" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="com.mysql.cj.jdbc.Driver" \
      --env JDBC_URL="jdbc:mysql://127.0.0.1:3306/solo?useUnicode=yes&characterEncoding=UTF-8&useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```

  为了简单，使用了主机网络模式来连接主机上的 MySQL。
* 使用 H2 Database
  ```shell
  docker run --detach --name solo --volume ~/solo_h2/:/opt/solo/h2/ --publish 8080:8080 \
      --env RUNTIME_DB="H2" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="org.h2.Driver" \
      --env JDBC_URL="jdbc:h2:/opt/solo/h2/db;MODE=MYSQL" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```

启动参数说明：

* `--listen_port` ：进程监听端口
* `--server_scheme` ：最终访问协议，如果反代服务启用了 HTTPS 这里也需要改为 `https`
* `--server_host` ：最终访问域名或公网 IP，不要带端口
* `--server_port` ：最终访问端口，使用浏览器默认的 80 或者 443 的话值留空即可

完整启动参数的说明可以使用 `-h` 来查看。

#### 日志配置

默认通过 log4j2 将日志打印到标准输出流，可以通过 `docker logs solo` 进行查看。如果需要覆盖 log4j 配置，可通过挂载文件实现：

```shell
--volume ~/log4j2.xml:/opt/solo/log4j2.xml
```

#### 皮肤配置

如果要使用其他皮肤，可以挂载目录 skins（里面需要包含所需使用的所有皮肤）：

```shell
--volume ~/skins/:/opt/solo/skins/
```

#### 版本升级

1. 拉取最新镜像
2. 重启容器

可参考[这里](https://github.com/88250/solo/blob/master/scripts/docker-restart.sh)编写一个重启脚本，并通过 crontab 每日凌晨运行来实现自动更新。

#### Docker Compose

请参考[这里](https://github.com/liumapp/solo-in-docker)，感谢 [@liumapp](https://github.com/liumapp) 提供。

### NGINX 反代

```nginx
upstream backend {
    server localhost:8080; # Solo 监听端口
}

server {
    listen       80;
    server_name  88250.b3log.org; # 博客域名

    access_log off;

    location / {
        proxy_pass http://backend$request_uri;
        proxy_set_header  Host $http_host;
        proxy_set_header  X-Real-IP $remote_addr;
        client_max_body_size  10m;
    }
}
```

**请务必配置**：

```nginx
proxy_set_header  Host $http_host;
proxy_set_header  X-Real-IP $remote_addr;
```

否则访问页面可能会出现“Latke 配置错误”；统计在线访客功能会不正常。

## 📜 文档

* [《提问的智慧》精读注解版](https://hacpai.com/article/1536377163156)
* [从零开始安装 Solo 博客](https://hacpai.com/article/1565021959471)（感谢 @InkDP 分享）
* [用户指南](https://hacpai.com/article/1492881378588)
* [Solo 从设计到实现](https://hacpai.com/article/1537690756242)
* [皮肤开发指南](https://hacpai.com/article/1493814851007)
* [插件开发](https://docs.google.com/document/pub?id=15H7Q3EBo-44v61Xp_epiYY7vK_gPJLkQaT7T1gkE64w&pli=1)

## 🏘️ 社区

* [讨论区](https://hacpai.com/tag/solo)
* [报告问题](https://github.com/88250/solo/issues/new/choose)

## 📄 授权

Solo 使用 [GNU Affero General Public License, Version 3](https://www.gnu.org/licenses/agpl-3.0.txt) 开源协议。

## 🙏 鸣谢

* [jQuery](https://github.com/jquery/jquery)：前端 JavaScript 工具库
* [Vditor](https://github.com/88250/vditor)： 浏览器端的 Markdown 编辑器
* [Highlight.js](https://github.com/isagalaev/highlight.js)：前端代码高亮库
* [pjax](https://github.com/defunkt/jquery-pjax)：pushState + AJAX = pjax
* [jsoup](https://github.com/jhy/jsoup)：Java HTML 解析器
* [flexmark](https://github.com/vsch/flexmark-java)：Java Markdown 处理库
* [Apache Commons](http://commons.apache.org)：Java 工具库集
* [Latke](https://github.com/88250/latke)：以 JSON 为主的 Java Web 框架

---

## 初始化后

初始化成功后请务必查看自动发布的第一篇文章，里面有一些**必要的操作**，请务必完成。然后请到管理后台 -> 工具 -> 偏好设定中进行一下博客的细节配置。

### 信息配置

* 博客基本信息：标题、子标题、SEO 信息
* HTML head：可以配置脚本，比如百度统计
* 公告：可以使用 HTML 和脚本进行配置
* 页脚：主要用来放备案信息，也可以使用 HTML 和脚本进行配置

### 签名档

最多可以配置 3 个签名档，发布文章的时候选择一个使用，可以使用 HTML 和脚本进行配置。

### 参数设置

下面是一些比较有特色或重要的参数：

* 列表显示方式：仅标题/标题 + 摘要/标题 + 正文
* 各种分页参数
* 文章更新提示：启用后一旦某篇文章更新过，则会在文章标题处显示“有更新”的提示，并且排序靠前
* 允许同步 GitHub 仓库：将文章数据自动导出到 GitHub 仓库，用于展示和备份

## 导入 Markdown

请参考 [Solo 支持 Hexo/Jekyll 数据导入](https://hacpai.com/article/1498490209748)。

## 备份

安全第一，血泪的教训 😢

* H2：备份用户 home 目录下的 solo\_h2 文件夹
* MySQL：使用 MySQL 相关备份工具

另外，如果开启了自动备份社区功能，则会定时 24 小时自动备份所有文章到社区，请参考 [Solo 拉取 GitHub 仓库和自动备份](https://hacpai.com/article/1557238327458)。

## 其他一些特性

### 多用户

可以几个用户同时使用一个博客发布文章，主要用在团队博客这个场景。权限方面做了简单隔离，非管理员用户可以看到其他用户的博文/评论列表，但是不能进行操作。

### RSS/Atom/Sitemap

提供两种订阅供稿：Atom 1.0、RSS 2.0：

* Atom: /rss.xml
* RSS: /atom.xml

不要用浏览器直接打开，请通过阅读器查看。另外，Solo 也能生成全站文章的 sitemap.xml。

### 前台皮肤切换

通过 URL 带参（比如 `http://88250.b3log.org/?skin=Finding` ）来确定渲染使用的皮肤。

使用场景举例：

* 在不安装 Solo 的情况下可以方便预览各个皮肤（在 Demo 上）
* 方便二次开发时集成切换皮肤
* 博主可以让访客体验到不同的效果，比如：[这个](http://88250.b3log.org/?skin=Finding)皮肤好看？还是[这个](http://88250.b3log.org/?skin=9IPHP)好看？

1. 只有在首页（ `/` ）会取参数 `skin=xxx`
2. 如果带有就记录到 Cookie 里面，如果带有 `skin=default` 或皮肤不存在则清空 Cookie
3. 如果要切换成后台默认的皮肤，在首页带参 `skin=default`

### 站外相关文章

“站外相关文章”指的是其他人使用 Solo 发布的文章，该文章含有与你的文章相同的标签。该功能主要是为了加强各个 Solo 博客之间的互动性，让博客访问者可以更有效地访问到相关的内容。

这是 [B3log 构思](https://hacpai.com/b3log)的一部分实现，请大家积极参与进来 🙏

## FAQ

### 服务器内存太小？

可考虑使用 Solo 的静态站点支持，本地写作完成后导出静态站点，发布 GitHub Pages 等服务。

如果还是想使用动态博客的话，可使用内嵌的 H2 数据库代替 MySQL。但建议还是进行内存升级，然后使用 Docker 和 MySQL 部署，这样不仅可以通过更新镜像进行平滑升级，还能使用 MySQL 相关工具更方便地进行数据库运维。

### 获取社区文件存储服务上传凭证异常？

请参考[这里](https://hacpai.com/article/1550393688505)进行配置。

### 如何引入自定义静态资源，比如 .mp3？

请通过 NGINX 反代静态资源实现。

### 如何获得更好的 Markdown 渲染效果？

Solo 默认是使用内建的 [flexmark](https://github.com/vsch/flexmark-java) 进行 md 渲染，可能对有的场景下的渲染效果不是很好。如果你想要获得更好的 md 渲染效果请参考[这里](https://hacpai.com/article/1569240189601)。

### 为什么在线访问计数一直都是 1？

在线访问计数是通过访问者 IP 去重的，每 10 分钟定时刷新一次。如果用了反向代理，请在代理配置部分加入客户端地址标头。比如 NGINX 需要加入如下配置：

```
proxy_set_header  X-Real-IP  $remote_addr;
```

### 如何插入广告展位？

可通过签名档、公告栏中插入 HTML、JS 代码来实现。

### 如何放置备案信息？

可通过在页脚配置中插入 HTML、JS 代码来实现。

### 如何使用 jsDelivr CDN 来加速？

启动时加入命令行参数：

```shell
--static_server_scheme=https
--static_server_host=cdn.jsdelivr.net
--static_server_port=
--static_path=/gh/88250/solo/src/main/resources
```

请注意，以上配置仅支持内置皮肤，如果挂载了第三方皮肤的话请按需调整。

### Solo 会一直维护下去么？

Solo 的第一个版本发布于 `2010` 年，永不断更 😼

Solo 从第一版开始就支持平滑升级，从 v3.0.0 开始支持跨版本升级。在程序升级、数据兼容迁移方面我们做了很多工作。另外，Solo 还支持将数据导出成多种格式，所有的这些努力为的就是让大家能够免去后顾之忧，将精力更多放在创作和分享上。

## 结语

如果你在使用 Solo 过程中碰到问题或者有需求要提，欢迎跟帖，我们会在第一时间回复；如果你对 Solo 开发方面感兴趣，请参考 [Solo 从设计到实现](https://hacpai.com/article/1537690756242)。