/*
 * Solo - A small and beautiful blogging system written in Java.
 * Copyright (c) 2010-present, b3log.org
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.b3log.solo.processor.console;

import org.apache.commons.lang.StringUtils;
import org.b3log.solo.AbstractTestCase;
import org.b3log.solo.MockRequest;
import org.b3log.solo.MockResponse;
import org.b3log.solo.model.Option;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.Test;

/**
 * {@link PreferenceConsole} test case.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.1, Dec 23, 2018
 * @since 2.9.8
 */
@Test(suiteName = "processor")
public class PreferenceConsoleTestCase extends AbstractTestCase {

    /**
     * Init.
     */
    @Test
    public void init() {
        super.init();
    }

    /**
     * getSigns.
     */
    @Test(dependsOnMethods = "init")
    public void getSigns() {
        final MockRequest request = mockRequest();
        request.setRequestURI("/console/signs/");

        mockAdminLogin(request);

        final MockResponse response = mockResponse();
        mockDispatcher(request, response);

        final String content = response.getContentStr();
        Assert.assertTrue(StringUtils.contains(content, "sc\":true"));
    }

    /**
     * getPreference.
     *
     * @throws Exception exception
     */
    @Test(dependsOnMethods = "init")
    public void getPreference() throws Exception {
        final MockRequest request = mockRequest();
        request.setRequestURI("/console/preference/");

        mockAdminLogin(request);

        final MockResponse response = mockResponse();
        mockDispatcher(request, response);

        final String content = response.getContentStr();
        Assert.assertTrue(StringUtils.contains(content, "sc\":true"));
    }

    /**
     * updatePreference.
     */
    @Test(dependsOnMethods = "init")
    public void updatePreference() {
        final JSONObject p = getOptionQueryService().getPreference();

        final MockRequest request = mockRequest();
        request.setRequestURI("/console/preference/");
        request.setMethod("PUT");
        final JSONObject requestJSON = new JSONObject();
        requestJSON.put(Option.CATEGORY_C_PREFERENCE, p);
        request.setJSON(requestJSON);

        mockAdminLogin(request);

        final MockResponse response = mockResponse();
        mockDispatcher(request, response);

        final String content = response.getContentStr();
        Assert.assertTrue(StringUtils.contains(content, "sc\":true"));
    }
}
