<p align = "center">
<img alt="Solo" src="https://user-images.githubusercontent.com/873584/52320401-2593e600-2a0a-11e9-9ba1-db79ee71d1af.png">
<br><br>
小而美的博客系统，为未来而构建
<br><br>
<a title="Build Status" target="_blank" href="https://travis-ci.org/b3log/solo"><img src="https://img.shields.io/travis/b3log/solo.svg?style=flat-square"></a>
<a title="Coverage Status" target="_blank" href="https://coveralls.io/github/b3log/solo"><img src="https://img.shields.io/coveralls/github/b3log/solo.svg?style=flat-square&color=CC9933"></a>
<a title="Code Size" target="_blank" href="https://github.com/b3log/solo"><img src="https://img.shields.io/github/languages/code-size/b3log/solo.svg?style=flat-square&color=6699FF"></a>
<a title="AGPLv3" target="_blank" href="https://www.gnu.org/licenses/agpl-3.0.txt"><img src="http://img.shields.io/badge/license-AGPLv3-orange.svg?style=flat-square"></a>
<br>
<a title="Releases" target="_blank" href="https://github.com/b3log/solo/releases"><img src="https://img.shields.io/github/release/b3log/solo.svg?style=flat-square&color=CC6666"></a>
<a title="Release Date" target="_blank" href="https://github.com/b3log/solo/releases"><img src="https://img.shields.io/github/release-date/b3log/solo.svg?style=flat-square&color=99CCFF"></a>
<a title="Downloads" target="_blank" href="https://github.com/b3log/solo/releases"><img src="https://img.shields.io/github/downloads/b3log/solo/total.svg?style=flat-square&color=99CC99"></a>
<a title="Docker Pulls" target="_blank" href="https://hub.docker.com/r/b3log/solo"><img src="https://img.shields.io/docker/pulls/b3log/solo.svg?style=flat-square&color=blueviolet"></a>
<a title="Docker Image Size" target="_blank" href="https://hub.docker.com/r/b3log/solo"><img src="https://img.shields.io/microbadger/image-size/b3log/solo.svg?style=flat-square&color=ff96b4"></a>
<br>
<a title="GitHub Commits" target="_blank" href="https://github.com/b3log/solo/commits/master"><img src="https://img.shields.io/github/commit-activity/m/b3log/solo.svg?style=flat-square"></a>
<a title="Last Commit" target="_blank" href="https://github.com/b3log/solo/commits/master"><img src="https://img.shields.io/github/last-commit/b3log/solo.svg?style=flat-square&color=FF9900"></a>
<a title="GitHub Pull Requests" target="_blank" href="https://github.com/b3log/solo/pulls"><img src="https://img.shields.io/github/issues-pr-closed/b3log/solo.svg?style=flat-square&color=FF9966"></a>
<a title="Hits" target="_blank" href="https://github.com/b3log/hits"><img src="https://hits.b3log.org/b3log/solo.svg"></a>
<br><br>
<a title="GitHub Watchers" target="_blank" href="https://github.com/b3log/solo/watchers"><img src="https://img.shields.io/github/watchers/b3log/solo.svg?label=Watchers&style=social"></a>&nbsp;&nbsp;
<a title="GitHub Stars" target="_blank" href="https://github.com/b3log/solo/stargazers"><img src="https://img.shields.io/github/stars/b3log/solo.svg?label=Stars&style=social"></a>&nbsp;&nbsp;
<a title="GitHub Forks" target="_blank" href="https://github.com/b3log/solo/network/members"><img src="https://img.shields.io/github/forks/b3log/solo.svg?label=Forks&style=social"></a>&nbsp;&nbsp;
<a title="Author GitHub Followers" target="_blank" href="https://github.com/88250"><img src="https://img.shields.io/github/followers/88250.svg?label=Followers&style=social"></a>
</p>

## 💡 简介

[Solo](https://github.com/b3log/solo) 是一款小而美的开源博客系统，专为程序员设计。

Solo 有着非常活跃的[社区](https://hacpai.com)，可将文章作为帖子推送到社区，来自社区的回帖将作为博客评论进行联动。

> 这是一种全新的网络社区体验，让热爱记录和分享的你不再感到孤单！\
> 具体细节请浏览 [B3log 构思](https://hacpai.com/article/1546941897596)

## 🗃 案例

* [D 的个人博客](https://88250.b3log.org)
* [Jiahao.Zhang's Blog](https://blog.hduzplus.xyz)
* [子兮子兮](https://zixizixi.cn)
* [铅笔的个人博客](https://pencilso.cn)
* [洗澡狂魔的技术阵地](https://blog.washmoretech.com)
* [liumapp 的个人博客](http://www.liumapp.com)
* [水星的随笔](https://note.abeffect.com)
* [1992 社区](https://1992.cool)
* [DevHyxo](https://blog.devhyxo.top)
* [EchoCow](https://echocow.cn)
* [贼拉正经的技术博客](http://blog.stackoverflow.wiki)
* [记录改变生活](https://www.tuhaoxin.cn)
* [程序员小吴](https://cxyxiaowu.com)

## ✨  功能

* Markdown / Emoji
* [标签聚合分类](https://hacpai.com/article/1558320086126)
* 自定义导航链接
* 随机文章 / 相关文章 / 置顶 / 更新提醒
* 自定义文章永久链接 / 签名档
* 配置站点 SEO 参数 / 公告 / 页脚
* 代码高亮 / 数学公式 / 流程图
* [多皮肤，多端适配](https://github.com/b3log/solo-skins) / [社区皮肤](https://github.com/b3log/solo-third-skins)
* 多语言 / 国际化
* 友情链接管理
* 多用户写作，团队博客
* [Hexo / Jekyll / Markdown 导入](https://hacpai.com/article/1498490209748)
* SQL / JSON / Markdown 导出
* Atom / RSS / Sitemap
* CDN 静态资源分离
* [自动同步 GitHub 仓库](https://hacpai.com/article/1557238327458)
* [内置 HTTPS+CDN 文件存储](https://hacpai.com/article/1559928188793)

## 🎨 界面

### 开始使用

![start](https://user-images.githubusercontent.com/970828/56885783-df49a280-6a9f-11e9-8f52-bc37fcb03bc5.png)

### 后台首页

![console](https://user-images.githubusercontent.com/970828/56886176-f210a700-6aa0-11e9-894f-75eda5cf3317.png)

### 编辑文章

![post](https://user-images.githubusercontent.com/970828/56886177-f2a93d80-6aa0-11e9-8a87-14731bdf59e7.png)

### 选择皮肤

![skins](https://user-images.githubusercontent.com/970828/56886476-ad394000-6aa1-11e9-8a27-abaa22b9996b.png)

### 前台界面

![pinghsu](https://user-images.githubusercontent.com/970828/56885233-875e6c00-6a9e-11e9-88de-4551d955e8b6.png)

## 🍱 皮肤

* [9IPHP](https://88250.b3log.org/?skin=9IPHP)
* [Andrea](https://88250.b3log.org/?skin=Andrea)
* [Bruce](https://88250.b3log.org/?skin=Bruce)
* [Casper](https://88250.b3log.org/?skin=Casper)
* [Community](https://88250.b3log.org/?skin=Community)
* [favourite](https://88250.b3log.org/?skin=favourite)
* [Finding](https://88250.b3log.org/?skin=Finding)
* [i-nove](https://88250.b3log.org/?skin=i-nove)
* [Jane](https://88250.b3log.org/?skin=Jane)
* [Medium](https://88250.b3log.org/?skin=Medium)
* [metro-hot](https://88250.b3log.org/?skin=metro-hot)
* [NeoEase](https://88250.b3log.org/?skin=NeoEase)
* [next](https://88250.b3log.org/?skin=next)
* [nijigen](https://88250.b3log.org/?skin=nijigen)
* [owmx-3.0](https://88250.b3log.org/?skin=owmx-3.0)
* [Pinghsu](https://88250.b3log.org/?skin=Pinghsu)
* [timeline](https://88250.b3log.org/?skin=timeline)
* [tree-house](https://88250.b3log.org/?skin=tree-house)
* [yilia](https://88250.b3log.org/?skin=yilia)

## 🛠️ 安装

### 本地试用

[下载](https://github.com/b3log/solo/releases)最新的 Solo 包解压，进入解压目录执行：

* Windows: `java -cp "WEB-INF/lib/*;WEB-INF/classes" org.b3log.solo.Starter`
* Unix-like: `java -cp "WEB-INF/lib/*:WEB-INF/classes" org.b3log.solo.Starter`

如果你有 Java 开发环境，可参考[这里](https://hacpai.com/article/1493822943172)通过源码构建运行。

**请注意**：我们不建议通过 war 发布包或者源码构建部署，因为这样的部署方式在将来有新版本发布时升级会比较麻烦。
这两种方式请仅用于本地试用，线上生产环境建议通过 Docker 部署。

### Docker 部署（推荐方案）

#### 获取最新镜像

```shell
docker pull b3log/solo
```

#### 启动容器

* 使用 MySQL

  先手动建库（库名 `solo`，字符集使用 `utf8mb4`，排序规则 `utf8mb4_general_ci`），然后启动容器：
  
  ```shell
  docker run --detach --name solo --network=host \
      --env RUNTIME_DB="MYSQL" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="com.mysql.cj.jdbc.Driver" \
      --env JDBC_URL="jdbc:mysql://127.0.0.1:3306/solo?useUnicode=yes&characterEncoding=UTF-8&useSSL=false&serverTimezone=UTC" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```
  为了简单，使用了主机网络模式来连接主机上的 MySQL。
  
* 使用 H2 Database

  ```shell
  docker run --detach --name solo --volume ~/solo_h2/:/opt/solo/h2/ --publish 8080:8080 \
      --env RUNTIME_DB="H2" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="org.h2.Driver" \
      --env JDBC_URL="jdbc:h2:/opt/solo/h2/db;MODE=MYSQL" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```

启动参数说明：

* `--listen_port`：进程监听端口
* `--server_scheme`：最终访问协议，如果反代服务启用了 HTTPS 这里也需要改为 `https`
* `--server_host`：最终访问域名或公网 IP，不要带端口
* `--server_port`：最终访问端口，使用浏览器默认的 80 或者 443 的话值留空即可

完整启动参数的说明可以使用 `-h` 来查看。

#### 日志配置

默认通过 log4j 将日志打印到标准输出流，可以通过 `docker logs solo` 进行查看。如果需要覆盖 log4j 配置，可通过挂载文件实现：

```shell
--volume log4j.properties:/opt/solo/WEB-INF/classes/log4j.properties
```

#### 皮肤配置

如果要使用其他皮肤，可挂载目录 skins（里面需要包含所需使用的所有皮肤，官方所有皮肤可从[这里](https://github.com/b3log/solo-skins)下载）：
 
```shell
--volume skins/:/opt/solo/skins/
``` 

#### 版本升级

1. 拉取最新镜像
2. 重启容器

可参考[这里](https://github.com/b3log/solo/blob/master/scripts/docker-restart.sh)编写一个重启脚本，并通过 crontab 每日凌晨运行来实现自动更新。

#### Docker Compose

请参考[这里](https://github.com/liumapp/solo-in-docker)，感谢 [@liumapp](https://github.com/liumapp) 提供 :heart:

## 📜 文档

* [《提问的智慧》精读注解版](https://hacpai.com/article/1536377163156)
* [用户指南](https://hacpai.com/article/1492881378588)
* [Solo 从设计到实现](https://hacpai.com/article/1537690756242)
  * [项目简介](https://hacpai.com/article/1537691255769)
  * [搭建开发环境](https://hacpai.com/article/1537694179006)
  * [架构理念和约定](https://hacpai.com/article/1537695161321)
  * [表结构](https://hacpai.com/article/1537694566175)
  * [功能实现](https://hacpai.com/article/1538711714296)
     * [实现规范和约定](https://hacpai.com/article/1538711714296)
     * [登录验证 GitHub OAuth](https://hacpai.com/article/1554262218912)
     * [登录状态和会话](https://hacpai.com/article/1538708370634)
     * [发布文章](https://hacpai.com/article/1538893576597)
     * [自定义链接路由](https://hacpai.com/article/1543582332567)
     * [标签聚合分类](https://hacpai.com/article/1558320086126)
     * [发布评论](https://hacpai.com/article/1543642913006)
     * [Markdown 渲染](https://hacpai.com/article/1544880962218)
     * [导入 Markdown 文章](https://hacpai.com/article/1547643961141)
     * 皮肤切换
     * [自动同步 GitHub 仓库](https://hacpai.com/article/1557238327458)
     * [内置 HTTPS + CDN 文件存储](https://hacpai.com/article/1559928188793)
     * [跨版本升级](https://hacpai.com/article/1560169064267)
  * [安全相关](https://hacpai.com/article/1538896576775)
  * [错误处理](https://hacpai.com/article/1538901266090)
  * 性能相关
     * 数据库设计
     * 查询 SQL
     * MySQL 调优
     * 程序缓存
     * Docker 镜像优化
  * 运维相关
     * 开发、生产环境
     * NGINX 反代
     * 动静分离
     * 更好的 Markdown
     * 数据备份和迁移
     * 启用 HTTPS
     * 通过 Docker 部署实现自动升级
  * 后记
     * 轮子理论
     * 关于开源
     * 现实和理想
     * 博客的未来
* [皮肤开发指南](https://hacpai.com/article/1493814851007)
* [插件开发](https://docs.google.com/document/pub?id=15H7Q3EBo-44v61Xp_epiYY7vK_gPJLkQaT7T1gkE64w&pli=1)

## 🏘️ 社区

* [讨论区](https://hacpai.com/tag/solo)
* [报告问题](https://github.com/b3log/solo/issues/new/choose)

## 📄 授权

Solo 使用 [GNU Affero General Public License, Version 3](https://www.gnu.org/licenses/agpl-3.0.txt) 开源协议。

## 🙏 鸣谢

* [jQuery](https://github.com/jquery/jquery)：前端 JavaScript 工具库
* [Vditor](https://github.com/b3log/vditor)： 浏览器端的 Markdown 编辑器
* [Highlight.js](https://github.com/isagalaev/highlight.js)：前端代码高亮库
* [pjax](https://github.com/defunkt/jquery-pjax)：pushState + ajax = pjax
* [jsoup](https://github.com/jhy/jsoup)：Java HTML 解析器
* [flexmark](https://github.com/vsch/flexmark-java)：Java Markdown 处理库
* [Apache Commons](http://commons.apache.org)：Java 工具库集
* [Latke](https://github.com/b3log/latke)：以 JSON 为主的 Java Web 框架

---

## 👍 开源项目推荐

* 如果你需要搭建一个多用户博客平台，可以考虑使用 [Pipe](https://github.com/b3log/pipe)
* 如果你需要搭建一个社区平台，可以考虑使用 [Sym](https://github.com/b3log/symphony)
* 欢迎加入我们的小众开源社区，详情请看[这里](https://hacpai.com/article/1463025124998)
