/*
 * Copyright (c) 2010-2018, b3log.org & hacpai.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.b3log.solo.model;


/**
 * This class defines all skin model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.1, Aug 22, 2010
 */
public final class Skin {

    /**
     * Skin.
     */
    public static final String SKIN = "skin";

    /**
     * Skins.
     */
    public static final String SKINS = "skins";

    /**
     * Key of skin name, current selected skin name.
     */
    public static final String SKIN_NAME = "skinName";

    /**
     * Key of skin names.
     */
    public static final String SKIN_NAMES = "skinNames";

    /**
     * Key of skin directory name.
     */
    public static final String SKIN_DIR_NAME = "skinDirName";

    /**
     * Private default constructor.
     */
    private Skin() {}
}
