/*
 * Copyright (c) 2010-2017, b3log.org & hacpai.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.b3log.solo.model;


/**
 * This class defines all archive date model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @version 1.0.0.4, Jan 18, 2013
 */
public final class ArchiveDate {

    /**
     * Archive date.
     */
    public static final String ARCHIVE_DATE = "archiveDate";

    /**
     * Archive dates.
     */
    public static final String ARCHIVE_DATES = "archiveDates";

    /**
     * Archive time.
     */
    public static final String ARCHIVE_TIME = "archiveTime";

    /**
     * Key of archive date article count.
     */
    public static final String ARCHIVE_DATE_ARTICLE_COUNT = "archiveDateArticleCount";

    /**
     * Key of archive date article count.
     */
    public static final String ARCHIVE_DATE_PUBLISHED_ARTICLE_COUNT = "archiveDatePublishedArticleCount";

    /**
     * Archive date year.
     */
    public static final String ARCHIVE_DATE_YEAR = "archiveDateYear";

    /**
     * Archive date month.
     */
    public static final String ARCHIVE_DATE_MONTH = "archiveDateMonth";

    /**
     * Private default constructor.
     */
    private ArchiveDate() {}
}
