<p align = "center">
<img alt="Solo" src="https://static.b3log.org/images/brand/solo-128.png">
<br><br>
Small and beautiful blog system, designed for programmers
<br><br>
<a title="Build Status" target="_blank" href="https://travis-ci.org/88250/solo"><img src="https://img.shields.io/travis/88250/solo.svg?style=flat-square"></a>
<a title="Docker Image CI" target="_blank" href="https://github.com/88250/solo/actions"><img src="https://img.shields.io/github/workflow/status/88250/solo/Docker%20Image%20CI?color=blue&label=Actions&logo=github&style=flat-square"></a>
<a title="Coverage Status" target="_blank" href="https://coveralls.io/github/88250/solo"><img src="https://img.shields.io/coveralls/github/88250/solo.svg?style=flat-square&color=CC9933"></a>
<a title="Code Size" target="_blank" href="https://github.com/88250/solo"><img src="https://img.shields.io/github/languages/code-size/88250/solo.svg?style=flat-square&color=6699FF"></a>
<a title="MulanPSL2" target="_blank" href="https://license.coscl.org.cn/MulanPSL2"><img src="http://img.shields.io/badge/license-MulanPSL2-orange.svg?style=flat-square"></a>
<br>
<a title="Releases" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/release/88250/solo.svg?style=flat-square&color=CC6666"></a>
<a title="Release Date" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/release-date/88250/solo.svg?style=flat-square&color=99CCFF"></a>
<a title="Downloads" target="_blank" href="https://github.com/88250/solo/releases"><img src="https://img.shields.io/github/downloads/88250/solo/total.svg?style=flat-square&color=99CC99"></a>
<a title="Docker Pulls" target="_blank" href="https://hub.docker.com/r/88250/solo"><img src="https://img.shields.io/docker/pulls/88250/solo.svg?style=flat-square&color=blueviolet"></a>
<br>
<a title="GitHub Commits" target="_blank" href="https://github.com/88250/solo/commits/master"><img src="https://img.shields.io/github/commit-activity/m/88250/solo.svg?style=flat-square"></a>
<a title="Last Commit" target="_blank" href="https://github.com/88250/solo/commits/master"><img src="https://img.shields.io/github/last-commit/88250/solo.svg?style=flat-square&color=FF9900"></a>
<a title="GitHub Pull Requests" target="_blank" href="https://github.com/88250/solo/pulls"><img src="https://img.shields.io/github/issues-pr-closed/88250/solo.svg?style=flat-square&color=FF9966"></a>
<a title="Hits" target="_blank" href="https://github.com/88250/hits"><img src="https://hits.b3log.org/88250/solo.svg"></a>
<br><br>
<a title="GitHub Watchers" target="_blank" href="https://github.com/88250/solo/watchers"><img src="https://img.shields.io/github/watchers/88250/solo.svg?label=Watchers&style=social"></a>  
<a title="GitHub Stars" target="_blank" href="https://github.com/88250/solo/stargazers"><img src="https://img.shields.io/github/stars/88250/solo.svg?label=Stars&style=social"></a>  
<a title="GitHub Forks" target="_blank" href="https://github.com/88250/solo/network/members"><img src="https://img.shields.io/github/forks/88250/solo.svg?label=Forks&style=social"></a>  
<a title="Author GitHub Followers" target="_blank" href="https://github.com/88250"><img src="https://img.shields.io/github/followers/88250.svg?label=Followers&style=social"></a>
</p>

<p align="center">
<a href="https://hacpai.com/article/1492881378588">中文</a>
</p>

## 💡 Introduction

[Solo](https://solo.b3log.org) is a small and beautiful open source blog system, designed for programmers. Solo has a very active [community](https://hacpai.com), which can push articles as posts to the community, and replies from the community will be linked as blog comments (for details, please visit [B3log Ideas - Distributed Community Network](https://hacpai.com/article/1546941897596)).

> This is a brand new online community experience, so that you who love recording and sharing no longer feel lonely!

Welcome to [Solo Official Discussion Forum](https://hacpai.com/tag/solo) to learn more.

## 🗃 Showcases

https://hacpai.com/top/solo

## ✨ Features

* [Markdown Editor](https://github.com/Vanessa219/vditor) supports three editing modes: WYSIWYG/Instant Rendering/Split View
* [Tag aggregation classification](https://hacpai.com/article/1558320086126)
* Custom navigation links
* Random articles / Related articles / Pin articles / Update reminder
* Custom article permanent link / Signature column
* Configure site SEO parameters / Announcement / Footer
* Code syntax highlighting / Mathematical formulas / Flow charts / Staves
* [Multi-skin, multi-end adaptation](https://solo.b3log.org/#themes)
* Multilingual / International
* Friendly Link Management
* Multi-user writing, team blog
* [Hexo / Jekyll / Markdown import](https://hacpai.com/article/1498490209748)
* SQL / JSON / Markdown export
* Atom / RSS / Sitemap
* CDN static resource separation, configurable jsDelivr CDN distribution
* [Pull GitHub repository and automatic backup](https://hacpai.com/article/1557238327458)
* [Built-in HTTPS + CDN file storage](https://hacpai.com/article/1559928188793)
* [Support to generate and export static sites](https://hacpai.com/article/1579053576274) for publishing GitHub Pages

## 🎨 Screenshots

### Start

![start.png](https://img.hacpai.com/file/2020/03/start-6fec3c72.png)

### Console

![console.png](https://img.hacpai.com/file/2020/03/console-ff45ec74.png)

### Post

![post.png](https://img.hacpai.com/file/2020/03/post-acb91edb.png)

### Skin

![skins.png](https://img.hacpai.com/file/2019/08/61179517afd61b00a63611e987d5ddea6d6a0fc9-0d368d02.png)

### Front

![pinghsu.png](https://img.hacpai.com/file/2020/03/pinghsu-91c48743.png)

![Bubble.png](https://img.hacpai.com/file/2020/03/Bubble-84bee365.png)

![nijigen.png](https://img.hacpai.com/file/2020/03/nijigen-30de3aaa.png)

![timeline.png](https://img.hacpai.com/file/2020/03/timeline-094af4c3.png)

![Casper.png](https://img.hacpai.com/file/2020/03/Casper-2d5ed59d.png)

![Jane.png](https://img.hacpai.com/file/2020/03/Jane-55b0414c.png)

## 🍱 Skins

The current built-in skins are as follows, you can click to preview:

* [Bubble](https://88250.b3log.org/?skin=Bubble)
* [Casper](https://88250.b3log.org/?skin=Casper)
* [Pinghsu](https://88250.b3log.org/?skin=Pinghsu)
* [Jane](https://88250.b3log.org/?skin=Jane)
* [nijigen](https://88250.b3log.org/?skin=nijigen)
* [Medium](https://88250.b3log.org/?skin=Medium)
* [9IPHP](https://88250.b3log.org/?skin=9IPHP)
* [Andrea](https://88250.b3log.org/?skin=Andrea)
* [Bruce](https://88250.b3log.org/?skin=Bruce)
* [Community](https://88250.b3log.org/?skin=Community)
* [favourite](https://88250.b3log.org/?skin=favourite)
* [Finding](https://88250.b3log.org/?skin=Finding)
* [i-nove](https://88250.b3log.org/?skin=i-nove)
* [metro-hot](https://88250.b3log.org/?skin=metro-hot)
* [NeoEase](https://88250.b3log.org/?skin=NeoEase)
* [next](https://88250.b3log.org/?skin=next)
* [owmx-3.0](https://88250.b3log.org/?skin=owmx-3.0)
* [timeline](https://88250.b3log.org/?skin=timeline)
* [tree-house](https://88250.b3log.org/?skin=tree-house)
* [yilia](https://88250.b3log.org/?skin=yilia)

Welcome to [here](https://github.com/88250/solo/issues/2) recommend good-looking skin, we will try to make it.

## 🛠️ Setup

Solo supports "dynamic and static":

* Dynamic blog: built on the server, the process runs in resident memory, and is used online
* Static blog: run on local computer, generate and export static site after writing

### Run locally

Local operation is mainly used for trial or static site generation, please refer to [here](https://hacpai.com/article/1579053576274) for usage of static site generation.

[Download](https://github.com/88250/solo/releases) and unzip the latest Solo package, enter the decompression directory and execute:

* Windows: `java -cp "lib/*;." org.b3log.solo.Server`
* Unix-like: `java -cp "lib/*:." org.b3log.solo.Server`

If you have a Java development environment, you can refer to [here](https://hacpai.com/article/1493822943172) to build and run through the source code.

### Docker

Docker deployment is a dynamic blog usage, mainly used to deploy dynamic blogs on the server.

#### Get the latest image

```shell
docker pull b3log/solo
```

#### Start the container

* Use MySQL
  First create database schema manually (schema name `solo`, character set use` utf8mb4`, sorting rule `utf8mb4_general_ci`), and then start the container:
  ```shell
  docker run --detach --name solo --network=host \
      --env RUNTIME_DB="MYSQL" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="com.mysql.cj.jdbc.Driver" \
      --env JDBC_URL="jdbc:mysql://127.0.0.1:3306/solo?useUnicode=yes&characterEncoding=UTF-8&useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```

  For simplicity, the host network mode is used to connect to MySQL on the host.
* Use H2 Database
  ```shell
  docker run --detach --name solo --volume ~/solo_h2/:/opt/solo/h2/ --publish 8080:8080 \
      --env RUNTIME_DB="H2" \
      --env JDBC_USERNAME="root" \
      --env JDBC_PASSWORD="123456" \
      --env JDBC_DRIVER="org.h2.Driver" \
      --env JDBC_URL="jdbc:h2:/opt/solo/h2/db;MODE=MYSQL" \
      b3log/solo --listen_port=8080 --server_scheme=http --server_host=localhost --server_port=
  ```

Start command line arguments description:

* `--listen_port`: the process listen port
* `--server_scheme`: the protocol for the final visiting, if the anti-generation service is enabled with HTTPS, it also needs to be changed to `https`
* `--server_host`: the domain name or public IP for the final visiting, do not bring port
* `--server_port`: the port for the final visiting, use the default 80 or 443 of the browser to leave the value blank

The description of the complete startup arguments can be viewed using `-h`.

#### Logging configuration

By default, logs are printed to the standard output stream through log4j2, which can be viewed through `docker logs solo`. If you need to override the log4j configuration, you can mount the file to achieve:

```shell
--volume ~/log4j2.xml:/opt/solo/log4j2.xml
```

#### Skin configuration

If you want to use other skins, you can mount the directory skins (it needs to contain all the skins you want to use):

```shell
--volume ~/skins/:/opt/solo/skins/
```

#### Version upgrade

1. Pull the latest image
2. Restart the container

You can refer to [here](https://github.com/88250/solo/blob/master/scripts/docker-restart.sh) to write a restart script and run it through crontab every morning to achieve automatic update.

#### Docker Compose

Please refer to [here](https://github.com/liumapp/solo-in-docker), thanks to [@liumapp](https://github.com/liumapp) for providing it.

### NGINX reverse proxy

```nginx
upstream backend {
    server localhost:8080; # Solo listen port
}

server {
    listen       80;
    server_name  88250.b3log.org; # blog domain

    access_log off;

    location / {
        proxy_pass http://backend$request_uri;
        proxy_set_header  Host $http_host;
        proxy_set_header  X-Real-IP $remote_addr;
        client_max_body_size  10m;
    }
}
```

**Be sure to configure**: 

```nginx
proxy_set_header  Host $http_host;
proxy_set_header  X-Real-IP $remote_addr;
```

Otherwise, "Latke configuration error" or abnormal style may appear on the access page; the function of counting online visitors will be abnormal.

## 📜 Documentation

* [Install Solo Blog from scratch](https://hacpai.com/article/1565021959471) (thanks @InkDP for sharing)
* [Solo User Guide](https://hacpai.com/article/1492881378588)
* [Solo from design to implementation](https://hacpai.com/article/1537690756242)
* [Solo Skin Development Guide](https://hacpai.com/article/1493814851007)
* [Plugin development](https://docs.google.com/document/pub?id=15H7Q3EBo-44v61Xp_epiYY7vK_gPJLkQaT7T1gkE64w&pli=1)

## 🏘️ Community

* [Forum](https://hacpai.com/tag/solo)
* [Issues](https://github.com/88250/solo/issues/new/choose)

## 📄 License

Solo uses the [Mulan Permissive Software License，Version 2](http://license.coscl.org.cn/MulanPSL2) open source license.

## 🙏 Acknowledgement

* [jQuery](https://github.com/jquery/jquery): Front-end JavaScript tool library
* [Vditor](https://github.com/88250/vditor): In-browser Markdown editor
* [Highlight.js](https://github.com/isagalaev/highlight.js): Front-end code syntax highlighting library
* [pjax](https://github.com/defunkt/jquery-pjax): pushState + AJAX = pjax
* [jsoup](https://github.com/jhy/jsoup): Java HTML parser
* [flexmark](https://github.com/vsch/flexmark-java): Java Markdown processor
* [Apache Commons](http://commons.apache.org): Java commons library
* [Latke](https://github.com/88250/latke): Java Web framework based on JSON
