/*
 * Solo - A beautiful, simple, stable, fast Java blogging system.
 * Copyright (c) 2010-2018, b3log.org & hacpai.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */
package org.b3log.solo.model;

/**
 * This class defines all common model relevant keys.
 *
 * @author <a href="http://88250.b3log.org">Liang Ding</a>
 * @author <a href="mailto:dongxu.wang@acm.org">Dongxu Wang</a>
 * @version 1.6.0.0, Sep 12, 2017
 * @since 0.3.1
 */
public final class Common {

    /**
     * Key of keyword.
     */
    public static final String KEYWORD = "keyword";

    /**
     * Key of data.
     */
    public static final String DATA = "data";

    /**
     * Key of direction.
     */
    public static final String DIRECTION = "direction";

    /**
     * Most used tags.
     */
    public static final String MOST_USED_TAGS = "mostUsedTags";

    /**
     * Most used categories.
     */
    public static final String MOST_USED_CATEGORIES = "mostUsedCategories";

    /**
     * Most comment count articles.
     */
    public static final String MOST_COMMENT_ARTICLES = "mostCommentArticles";

    /**
     * Most view count articles.
     */
    public static final String MOST_VIEW_COUNT_ARTICLES = "mostViewCountArticles";

    /**
     * Recent articles.
     */
    public static final String RECENT_ARTICLES = "recentArticles";

    /**
     * Recent comments.
     */
    public static final String RECENT_COMMENTS = "recentComments";

    /**
     * Previous article permalink.
     */
    public static final String PREVIOUS_ARTICLE_PERMALINK = "previousArticlePermalink";

    /**
     * Next article permalink.
     */
    public static final String NEXT_ARTICLE_PERMALINK = "nextArticlePermalink";

    /**
     * Previous article title.
     */
    public static final String PREVIOUS_ARTICLE_TITLE = "previousArticleTitle";

    /**
     * Previous article abstract.
     */
    public static final String PREVIOUS_ARTICLE_ABSTRACT = "previousArticleAbstract";

    /**
     * Next article title.
     */
    public static final String NEXT_ARTICLE_TITLE = "nextArticleTitle";

    /**
     * Next article abstract.
     */
    public static final String NEXT_ARTICLE_ABSTRACT = "nextArticleAbstract";

    /**
     * Is index.
     */
    public static final String IS_INDEX = "isIndex";

    /**
     * tag-articles.
     */
    public static final String TAG_ARTICLES = "tag-articles";

    /**
     * archive-date-articles.
     */
    public static final String ARCHIVED_DATE_ARTICLES = "archive-date-articles";

    /**
     * author-articles.
     */
    public static final String AUTHOR_ARTICLES = "author-articles";

    /**
     * Key of path.
     */
    public static final String PATH = "path";

    /**
     * Version.
     */
    public static final String VERSION = "version";

    /**
     * Static resource version.
     */
    public static final String STATIC_RESOURCE_VERSION = "staticResourceVersion";

    /**
     * Year.
     */
    public static final String YEAR = "year";

    /**
     * Key of flag a comment is an reply or not.
     */
    public static final String IS_REPLY = "isReply";

    /**
     * Key of page navigations.
     */
    public static final String PAGE_NAVIGATIONS = "pageNavigations";

    /**
     * Key of relevant articles.
     */
    public static final String RELEVANT_ARTICLES = "relevantArticles";

    /**
     * Key of random articles.
     */
    public static final String RANDOM_ARTICLES = "randomArticles";

    /**
     * Key of has updated.
     */
    public static final String HAS_UPDATED = "hasUpdated";

    /**
     * Author name.
     */
    public static final String AUTHOR_NAME = "authorName";

    /**
     * Author thumbnail URL.
     */
    public static final String AUTHOR_THUMBNAIL_URL = "authorThumbnailURL";

    /**
     * Author id.
     */
    public static final String AUTHOR_ID = "authorId";

    /**
     * Author role.
     */
    public static final String AUTHOR_ROLE = "authorRole";

    /**
     * Key of current user.
     */
    public static final String CURRENT_USER = "currentUser";

    /**
     * Key of admin user.
     */
    public static final String ADMIN_USER = "adminUser";

    /**
     * Key of enabled multiple user support.
     */
    public static final String ENABLED_MULTIPLE_USER_SUPPORT = "enabledMultipleUserSupport";

    /**
     * Key of is logged in.
     */
    public static final String IS_LOGGED_IN = "isLoggedIn";

    /**
     * Key of favicon API.
     */
    public static final String FAVICON_API = "faviconAPI";

    /**
     * Key of is mobile request.
     */
    public static final String IS_MOBILE_REQUEST = "isMobileRequest";

    /**
     * Key of login URL.
     */
    public static final String LOGIN_URL = "loginURL";

    /**
     * Key of logout URL.
     */
    public static final String LOGOUT_URL = "logoutURL";

    /**
     * Key of is administrator.
     */
    public static final String IS_ADMIN = "isAdmin";

    /**
     * Key of is visitor.
     */
    public static final String IS_VISITOR = "isVisitor";

    /**
     * Key of URI.
     */
    public static final String URI = "URI";

    /**
     * Key of blog.
     */
    public static final String BLOG = "blog";

    /**
     * Key of blog version.
     */
    public static final String BLOG_VERSION = "blogVersion";

    /**
     * Key of post to community.
     */
    public static final String POST_TO_COMMUNITY = "postToCommunity";

    /**
     * Key of mini postfix.
     */
    public static final String MINI_POSTFIX = "miniPostfix";

    /**
     * Value of mini postfix.
     */
    public static final String MINI_POSTFIX_VALUE = ".min";

    /**
     * Key of month name.
     */
    public static final String MONTH_NAME = "monthName";

    /**
     * Key of comment title (article/page).
     */
    public static final String COMMENT_TITLE = "commentTitle";

    /**
     * /admin-index.do#main.
     */
    public static final String ADMIN_INDEX_URI = "/admin-index.do#main";

    /**
     * Key of type.
     */
    public static final String TYPE = "type";

    /**
     * Article comment type.
     */
    public static final String ARTICLE_COMMENT_TYPE = "articleComment";

    /**
     * Page comment type.
     */
    public static final String PAGE_COMMENT_TYPE = "pageComment";

    /**
     * Key of top bar replacement flag.
     */
    public static final String TOP_BAR = "topBarReplacement";

    /**
     * Key of unused tags.
     */
    public static final String UNUSED_TAGS = "unusedTags";

    /**
     * Key of go to.
     */
    public static final String GOTO = "goto";

    /**
     * Key of online visitor count.
     */
    public static final String ONLINE_VISITOR_CNT = "onlineVisitorCnt";

    /**
     * Key of article sign.
     */
    public static final String ARTICLE_SIGN = "articleSign";

    /**
     * Key of permalink.
     */
    public static final String PERMALINK = "permalink";

    /**
     * Key of commentable.
     */
    public static final String COMMENTABLE = "commentable";

    /**
     * Key of articles view password.
     */
    public static final String ARTICLES_VIEW_PWD = "articlesViewPwd";

    /**
     * Key of Gravatar.
     */
    public static final String GRAVATAR = "gravatar";

    /**
     * Private default constructor.
     */
    private Common() {
    }
}
