/*
 * Decompiled with CFR 0.152.
 */
package com.bea.jvm;

import com.bea.jvm.JVM;
import com.bea.jvm.NotAvailableException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JVMFactory {
    private static JVM m_jvm;

    public static JVM getJVM() throws NotAvailableException {
        if (m_jvm == null) {
            m_jvm = JVMFactory.createJVM();
        }
        return m_jvm;
    }

    private static JVM createJVM() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("com.bea.jvm.JVM.Impl", "COM.jrockit.management.jvm.JVMImpl");
                }
            });
            return (JVM)Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NotAvailableException("JVM implementation " + string + " not found!");
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NotAvailableException("JVM implementation " + string + " could not be created!");
        }
    }
}

