/**
 * Popup(alert,confirm,prompt)  
 * @param {Object} $
 * @param {Object} window
 * @param {Object} document
 */
(function($, window, document) {
	var CLASS_POPUP = $.className('popup');
	var CLASS_POPUP_BACKDROP = $.className('popup-backdrop');
	var CLASS_POPUP_IN = $.className('popup-in');
	var CLASS_POPUP_OUT = $.className('popup-out');
	var CLASS_POPUP_INNER = $.className('popup-inner');
	var CLASS_POPUP_TITLE = $.className('popup-title');
	var CLASS_POPUP_TEXT = $.className('popup-text');
	var CLASS_POPUP_INPUT = $.className('popup-input');
	var CLASS_POPUP_BUTTONS = $.className('popup-buttons');
	var CLASS_POPUP_BUTTON = $.className('popup-button');
	var CLASS_POPUP_BUTTON_BOLD = $.className('popup-button-bold');
	var CLASS_POPUP_BACKDROP = $.className('popup-backdrop');
	var CLASS_ACTIVE = $.className('active');

	var popupStack = [];
	var backdrop = (function() {
		var element = document.createElement('div');
		element.classList.add(CLASS_POPUP_BACKDROP);
		element.addEventListener('webkitTransitionEnd', function() {
			if (!this.classList.contains(CLASS_ACTIVE)) {
				element.parentNode && element.parentNode.removeChild(element);
			}
		});
		return element;
	}());

	var createInput = function(placeholder) {
		return '<div class="' + CLASS_POPUP_INPUT + '"><input type="text" autofocus placeholder="' + (placeholder || '') + '"/></div>';
	};
	var createInner = function(message, title, extra) {
		return '<div class="' + CLASS_POPUP_INNER + '"><div class="' + CLASS_POPUP_TITLE + '">' + title + '</div><div class="' + CLASS_POPUP_TEXT + '">' + message + '</div>' + (extra || '') + '</div>';
	};
	var createButtons = function(btnArray) {
		var length = btnArray.length;
		var btns = [];
		for (var i = 0; i < length; i++) {
			btns.push('<span class="' + CLASS_POPUP_BUTTON + (i === length - 1 ? (' ' + CLASS_POPUP_BUTTON_BOLD) : '') + '">' + btnArray[i] + '</span>');
		}
		return '<div class="' + CLASS_POPUP_BUTTONS + '">' + btns.join('') + '</div>';
	};

	var createPopup = function(html, callback) {
		var popupElement = document.createElement('div');
		popupElement.className = CLASS_POPUP;
		popupElement.innerHTML = html;
		var removePopupElement = function() {
			popupElement.parentNode && popupElement.parentNode.removeChild(popupElement);
			popupElement = null;
		};

		popupElement.addEventListener('webkitTransitionEnd', function(e) {
			if (popupElement && e.target === popupElement && popupElement.classList.contains(CLASS_POPUP_OUT)) {
				removePopupElement();
			}
		});
		popupElement.style.display = 'block';
		document.body.appendChild(popupElement);
		popupElement.offsetHeight;
		popupElement.classList.add(CLASS_POPUP_IN);

		if (!backdrop.classList.contains(CLASS_ACTIVE)) {
			backdrop.style.display = 'block';
			document.body.appendChild(backdrop);
			backdrop.offsetHeight;
			backdrop.classList.add(CLASS_ACTIVE);
		}
		var btns = $.qsa('.' + CLASS_POPUP_BUTTON, popupElement);
		var input = popupElement.querySelector('.' + CLASS_POPUP_INPUT + ' input');
		var popup = {
			element: popupElement,
			close: function(index, animate) {
				if (popupElement) {
					callback && callback({
						index: index || 0,
						value: input && input.value || ''
					});
					if (animate !== false) {
						popupElement.classList.remove(CLASS_POPUP_IN);
						popupElement.classList.add(CLASS_POPUP_OUT);
					} else {
						removePopupElement();
					}
					popupStack.pop();
					//如果还有其他popup，则不remove backdrop
					if (popupStack.length) {
						popupStack[popupStack.length - 1]['show'](animate);
					} else {
						backdrop.classList.remove(CLASS_ACTIVE);
					}
				}
			}
		};
		var handleEvent = function(e) {
			popup.close(btns.indexOf(e.target));
		};
		$(popupElement).on('tap', '.' + CLASS_POPUP_BUTTON, handleEvent);
		if (popupStack.length) {
			popupStack[popupStack.length - 1]['hide']();
		}
		popupStack.push({
			close: popup.close,
			show: function(animate) {
				popupElement.style.display = 'block';
				popupElement.offsetHeight;
				popupElement.classList.add(CLASS_POPUP_IN);
			},
			hide: function() {
				popupElement.style.display = 'none';
				popupElement.classList.remove(CLASS_POPUP_IN);
			}
		});
		return popup;
	};
	var createAlert = function(message, title, btnValue, callback, type) {
		if (typeof message === 'undefined') {
			return;
		} else {
			if (typeof title === 'function') {
				callback = title;
				title = null;
				btnValue = null;
			} else if (typeof btnValue === 'function') {
				callback = btnValue;
				btnValue = null;
			}
		}
		if (!$.os.plus || type === 'div') {
			return createPopup(createInner(message, title || '提示') + createButtons([btnValue || '确定']), callback);
		}
		return plus.nativeUI.alert(message, callback, title || '提示', btnValue || '确定');
	};
	var createConfirm = function(message, title, btnArray, callback, type) {
		if (typeof message === 'undefined') {
			return;
		} else {
			if (typeof title === 'function') {
				callback = title;
				title = null;
				btnArray = null;
			} else if (typeof btnArray === 'function') {
				callback = btnArray;
				btnArray = null;
			}
		}
		if (!$.os.plus || type === 'div') {
			return createPopup(createInner(message, title || '提示') + createButtons(btnArray || ['取消', '确认']), callback);
		}
		return plus.nativeUI.confirm(message, callback, title, btnArray || ['取消', '确认']);
	};
	var createPrompt = function(message, placeholder, title, btnArray, callback, type) {
		if (typeof message === 'undefined') {
			return;
		} else {
			if (typeof placeholder === 'function') {
				callback = placeholder;
				placeholder = null;
				title = null;
				btnArray = null;
			} else if (typeof title === 'function') {
				callback = title;
				title = null;
				btnArray = null;
			} else if (typeof btnArray === 'function') {
				callback = btnArray;
				btnArray = null;
			}
		}
		if (!$.os.plus || type === 'div') {
			return createPopup(createInner(message, title || '提示', createInput(placeholder)) + createButtons(btnArray || ['取消', '确认']), callback);
		}
		return plus.nativeUI.prompt(message, callback, title || '提示', placeholder, btnArray || ['取消', '确认']);
	};
	var closePopup = function() {
		if (popupStack.length) {
			popupStack[popupStack.length - 1]['close']();
			return true;
		} else {
			return false;
		}
	};
	var closePopups = function() {
		while (popupStack.length) {
			popupStack[popupStack.length - 1]['close']();
		}
	};

	$.closePopup = closePopup;
	$.closePopups = closePopups;
	$.alert = createAlert;
	$.confirm = createConfirm;
	$.prompt = createPrompt;
})(mui, window, document);