---
layout: page
title: Examples
---

Build on the basic template above with Bootstrap's many components. We encourage you to customize and adapt Bootstrap to suit your individual project's needs.

### Framework

<div class="row bs-examples">
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/starter-template/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/starter-template.jpg" alt="">
    </a>
    <h4>Starter template</h4>
    <p>Nothing but the basics: compiled CSS and JavaScript.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/theme/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/theme.jpg" alt="">
    </a>
    <h4>Bootstrap theme</h4>
    <p>Load the optional Bootstrap theme for a visually enhanced experience.</p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/grid/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/grid.jpg" alt="">
    </a>
    <h4>Grids</h4>
    <p>Multiple examples of grid layouts with all four tiers, nesting, and more.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/jumbotron/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/jumbotron.jpg" alt="">
    </a>
    <h4>Jumbotron</h4>
    <p>Build around the jumbotron with a navbar and some basic grid columns.</p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/jumbotron-narrow/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/jumbotron-narrow.jpg" alt="">
    </a>
    <h4>Narrow jumbotron</h4>
    <p>Build a more custom page by narrowing the default container and jumbotron.</p>
  </div>
</div>

### Navbars

<div class="row bs-examples">
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/navbar/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/navbar.jpg" alt="">
    </a>
    <h4>Navbar</h4>
    <p>Super basic template that includes the navbar along with some additional content.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/navbar-static-top/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/navbar-static.jpg" alt="">
    </a>
    <h4>Static top navbar</h4>
    <p>Super basic template with a static top navbar along with some additional content.</p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/navbar-fixed-top/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/navbar-fixed.jpg" alt="">
    </a>
    <h4>Fixed navbar</h4>
    <p>Super basic template with a fixed top navbar along with some additional content.</p>
  </div>
</div>

<h3 id="examples-custom">Custom components</h3>
<div class="row bs-examples">
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/cover/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/cover.jpg" alt="">
    </a>
    <h4>Cover</h4>
    <p>A one-page template for building simple and beautiful home pages.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/carousel/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/carousel.jpg" alt="">
    </a>
    <h4>Carousel</h4>
    <p>Customize the navbar and carousel, then add some new components.</p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/blog/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/blog.jpg" alt="">
    </a>
    <h4>Blog</h4>
    <p>Simple two-column blog layout with custom navigation, header, and type.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/dashboard/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/dashboard.jpg" alt="">
    </a>
    <h4>Dashboard</h4>
    <p>Basic structure for a admin dashboard with fixed sidebar and navbar.</p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/signin/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/sign-in.jpg" alt="">
    </a>
    <h4>Sign-in page</h4>
    <p>Custom form layout and design for a simple sign in form.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/justified-nav/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/justified-nav.jpg" alt="">
    </a>
    <h4>Justified nav</h4>
    <p>Create a custom navbar with justified links. Heads up! <a href="{{ site.baseurl }}components/#nav-justified">Not too Safari friendly.</a></p>
  </div>
  <div class="clearfix visible-xs-block"></div>

  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/sticky-footer/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/sticky-footer.jpg" alt="">
    </a>
    <h4>Sticky footer</h4>
    <p>Attach a footer to the bottom of the viewport when the content is shorter than it.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/sticky-footer-navbar/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/sticky-footer-navbar.jpg" alt="">
    </a>
    <h4>Sticky footer with navbar</h4>
    <p>Attach a footer to the bottom of the viewport with a fixed navbar at the top.</p>
  </div>
</div>

### Experiments

<div class="row bs-examples">
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/non-responsive/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/non-responsive.jpg" alt="">
    </a>
    <h4>Non-responsive Bootstrap</h4>
    <p>Easily disable the responsiveness of Bootstrap <a href="#disable-responsive">per our docs</a>.</p>
  </div>
  <div class="col-xs-6 col-md-4">
    <a href="{{ site.baseurl }}examples/offcanvas/">
      <img class="img-thumbnail" src="{{ site.baseurl }}examples/screenshots/offcanvas.jpg" alt="">
    </a>
    <h4>Offcanvas</h4>
    <p>Build a toggleable off-canvas navigation menu for use with Bootstrap.</p>
  </div>
</div>
