---
layout: page
title: Brand guidelines
---

Have a need for Bootstrap's brand resources? Great! We have only a few guidelines we follow, and in turn ask you to follow as well. These guidelines were inspired by MailChimp's [Brand Assets](http://mailchimp.com/about/brand-assets/).

## Mark and logo

Use either the Bootstrap mark (a capital **B**) or the standard logo (just **Bootstrap**). It should always appear in Helvetica Neue Bold. **Do not use the Twitter bird** in association with Bootstrap.

<div class="bs-brand-logos">
  <div class="bs-brand-item">
    <div class="bs-docs-booticon bs-docs-booticon-lg">B</div>
  </div>
  <div class="bs-brand-item inverse">
    <div class="bs-docs-booticon bs-docs-booticon-lg bs-docs-booticon-inverse">B</div>
  </div>
</div>
<div class="bs-brand-logos">
  <div class="bs-brand-item">
    <h1>Bootstrap</h1>
  </div>
  <div class="bs-brand-item inverse">
    <h1>Bootstrap</h1>
  </div>
</div>

## Download mark

Download the Bootstrap mark in one of three styles, each available as an SVG file. Right click, Save as.

<div class="bs-brand-logos">
  <div class="bs-brand-item">
    <img class="svg" src="{{ site.baseurl }}assets/brand/bootstrap-solid.svg" alt="Bootstrap">
  </div>
  <div class="bs-brand-item inverse">
    <img class="svg" src="{{ site.baseurl }}assets/brand/bootstrap-outline.svg" alt="Bootstrap">
  </div>
  <div class="bs-brand-item inverse">
    <img class="svg" src="{{ site.baseurl }}assets/brand/bootstrap-punchout.svg" alt="Bootstrap">
  </div>
</div>

## Name

The project and framework should always be referred to as **Bootstrap**. No Twitter before it, no capital _s_, and no abbreviations except for one, a capital **B**.

<div class="bs-brand-logos">
  <div class="bs-brand-item">
    <h3>Bootstrap</h3>
    <span class="glyphicon glyphicon-ok"></span>
  </div>
  <div class="bs-brand-item">
    <h3 class="text-muted">BootStrap</h3>
    <span class="glyphicon glyphicon-remove"></span>
  </div>
  <div class="bs-brand-item">
    <h3 class="text-muted">Twitter Bootstrap</h3>
    <span class="glyphicon glyphicon-remove"></span>
  </div>
</div>

## Colors

Our docs and branding use a handful of primary colors to differentiate what *is* Bootstrap from what *is in* Bootstrap. In other words, if it's purple, it's representative of Bootstrap.

<div class="bs-brand">
  <div class="color-swatches">
    <div class="color-swatch bs-purple"></div>
    <div class="color-swatch bs-purple-light"></div>
    <div class="color-swatch bs-purple-lighter"></div>
    <div class="color-swatch bs-gray"></div>
  </div>
</div>
