/*!
 * Bootstrap v3.1.1 (http://getbootstrap.com)
 * Copyright 2011-2014 Twitter, Inc.
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)
 */
var __js = {"affix.js":"/* ========================================================================\n * Bootstrap: affix.js v3.1.1\n * http://getbootstrap.com/javascript/#affix\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // AFFIX CLASS DEFINITION\n  // ======================\n\n  var Affix = function (element, options) {\n    this.options = $.extend({}, Affix.DEFAULTS, options)\n    this.$window = $(window)\n      .on('scroll.bs.affix.data-api', $.proxy(this.checkPosition, this))\n      .on('click.bs.affix.data-api',  $.proxy(this.checkPositionWithEventLoop, this))\n\n    this.$element     = $(element)\n    this.affixed      =\n    this.unpin        =\n    this.pinnedOffset = null\n\n    this.checkPosition()\n  }\n\n  Affix.RESET = 'affix affix-top affix-bottom'\n\n  Affix.DEFAULTS = {\n    offset: 0\n  }\n\n  Affix.prototype.getPinnedOffset = function () {\n    if (this.pinnedOffset) return this.pinnedOffset\n    this.$element.removeClass(Affix.RESET).addClass('affix')\n    var scrollTop = this.$window.scrollTop()\n    var position  = this.$element.offset()\n    return (this.pinnedOffset = position.top - scrollTop)\n  }\n\n  Affix.prototype.checkPositionWithEventLoop = function () {\n    setTimeout($.proxy(this.checkPosition, this), 1)\n  }\n\n  Affix.prototype.checkPosition = function () {\n    if (!this.$element.is(':visible')) return\n\n    var scrollHeight = $(document).height()\n    var scrollTop    = this.$window.scrollTop()\n    var position     = this.$element.offset()\n    var offset       = this.options.offset\n    var offsetTop    = offset.top\n    var offsetBottom = offset.bottom\n\n    if (this.affixed == 'top') position.top += scrollTop\n\n    if (typeof offset != 'object')         offsetBottom = offsetTop = offset\n    if (typeof offsetTop == 'function')    offsetTop    = offset.top(this.$element)\n    if (typeof offsetBottom == 'function') offsetBottom = offset.bottom(this.$element)\n\n    var affix = this.unpin   != null && (scrollTop + this.unpin <= position.top) ? false :\n                offsetBottom != null && (position.top + this.$element.height() >= scrollHeight - offsetBottom) ? 'bottom' :\n                offsetTop    != null && (scrollTop <= offsetTop) ? 'top' : false\n\n    if (this.affixed === affix) return\n    if (this.unpin) this.$element.css('top', '')\n\n    var affixType = 'affix' + (affix ? '-' + affix : '')\n    var e         = $.Event(affixType + '.bs.affix')\n\n    this.$element.trigger(e)\n\n    if (e.isDefaultPrevented()) return\n\n    this.affixed = affix\n    this.unpin = affix == 'bottom' ? this.getPinnedOffset() : null\n\n    this.$element\n      .removeClass(Affix.RESET)\n      .addClass(affixType)\n      .trigger($.Event(affixType.replace('affix', 'affixed')))\n\n    if (affix == 'bottom') {\n      this.$element.offset({ top: scrollHeight - offsetBottom - this.$element.height() })\n    }\n  }\n\n\n  // AFFIX PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.affix\n\n  $.fn.affix = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.affix')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.affix', (data = new Affix(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.affix.Constructor = Affix\n\n\n  // AFFIX NO CONFLICT\n  // =================\n\n  $.fn.affix.noConflict = function () {\n    $.fn.affix = old\n    return this\n  }\n\n\n  // AFFIX DATA-API\n  // ==============\n\n  $(window).on('load', function () {\n    $('[data-spy=\"affix\"]').each(function () {\n      var $spy = $(this)\n      var data = $spy.data()\n\n      data.offset = data.offset || {}\n\n      if (data.offsetBottom) data.offset.bottom = data.offsetBottom\n      if (data.offsetTop)    data.offset.top    = data.offsetTop\n\n      $spy.affix(data)\n    })\n  })\n\n}(jQuery);\n","alert.js":"/* ========================================================================\n * Bootstrap: alert.js v3.1.1\n * http://getbootstrap.com/javascript/#alerts\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // ALERT CLASS DEFINITION\n  // ======================\n\n  var dismiss = '[data-dismiss=\"alert\"]'\n  var Alert   = function (el) {\n    $(el).on('click', dismiss, this.close)\n  }\n\n  Alert.prototype.close = function (e) {\n    var $this    = $(this)\n    var selector = $this.attr('data-target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, '') // strip for ie7\n    }\n\n    var $parent = $(selector)\n\n    if (e) e.preventDefault()\n\n    if (!$parent.length) {\n      $parent = $this.hasClass('alert') ? $this : $this.parent()\n    }\n\n    $parent.trigger(e = $.Event('close.bs.alert'))\n\n    if (e.isDefaultPrevented()) return\n\n    $parent.removeClass('in')\n\n    function removeElement() {\n      $parent.trigger('closed.bs.alert').remove()\n    }\n\n    $.support.transition && $parent.hasClass('fade') ?\n      $parent\n        .one($.support.transition.end, removeElement)\n        .emulateTransitionEnd(150) :\n      removeElement()\n  }\n\n\n  // ALERT PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.alert\n\n  $.fn.alert = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('bs.alert')\n\n      if (!data) $this.data('bs.alert', (data = new Alert(this)))\n      if (typeof option == 'string') data[option].call($this)\n    })\n  }\n\n  $.fn.alert.Constructor = Alert\n\n\n  // ALERT NO CONFLICT\n  // =================\n\n  $.fn.alert.noConflict = function () {\n    $.fn.alert = old\n    return this\n  }\n\n\n  // ALERT DATA-API\n  // ==============\n\n  $(document).on('click.bs.alert.data-api', dismiss, Alert.prototype.close)\n\n}(jQuery);\n","button.js":"/* ========================================================================\n * Bootstrap: button.js v3.1.1\n * http://getbootstrap.com/javascript/#buttons\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // BUTTON PUBLIC CLASS DEFINITION\n  // ==============================\n\n  var Button = function (element, options) {\n    this.$element  = $(element)\n    this.options   = $.extend({}, Button.DEFAULTS, options)\n    this.isLoading = false\n  }\n\n  Button.DEFAULTS = {\n    loadingText: 'loading...'\n  }\n\n  Button.prototype.setState = function (state) {\n    var d    = 'disabled'\n    var $el  = this.$element\n    var val  = $el.is('input') ? 'val' : 'html'\n    var data = $el.data()\n\n    state = state + 'Text'\n\n    if (!data.resetText) $el.data('resetText', $el[val]())\n\n    $el[val](data[state] || this.options[state])\n\n    // push to event loop to allow forms to submit\n    setTimeout($.proxy(function () {\n      if (state == 'loadingText') {\n        this.isLoading = true\n        $el.addClass(d).attr(d, d)\n      } else if (this.isLoading) {\n        this.isLoading = false\n        $el.removeClass(d).removeAttr(d)\n      }\n    }, this), 0)\n  }\n\n  Button.prototype.toggle = function () {\n    var changed = true\n    var $parent = this.$element.closest('[data-toggle=\"buttons\"]')\n\n    if ($parent.length) {\n      var $input = this.$element.find('input')\n      if ($input.prop('type') == 'radio') {\n        if ($input.prop('checked') && this.$element.hasClass('active')) changed = false\n        else $parent.find('.active').removeClass('active')\n      }\n      if (changed) $input.prop('checked', !this.$element.hasClass('active')).trigger('change')\n    }\n\n    if (changed) this.$element.toggleClass('active')\n  }\n\n\n  // BUTTON PLUGIN DEFINITION\n  // ========================\n\n  var old = $.fn.button\n\n  $.fn.button = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.button')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.button', (data = new Button(this, options)))\n\n      if (option == 'toggle') data.toggle()\n      else if (option) data.setState(option)\n    })\n  }\n\n  $.fn.button.Constructor = Button\n\n\n  // BUTTON NO CONFLICT\n  // ==================\n\n  $.fn.button.noConflict = function () {\n    $.fn.button = old\n    return this\n  }\n\n\n  // BUTTON DATA-API\n  // ===============\n\n  $(document).on('click.bs.button.data-api', '[data-toggle^=button]', function (e) {\n    var $btn = $(e.target)\n    if (!$btn.hasClass('btn')) $btn = $btn.closest('.btn')\n    $btn.button('toggle')\n    e.preventDefault()\n  })\n\n}(jQuery);\n","carousel.js":"/* ========================================================================\n * Bootstrap: carousel.js v3.1.1\n * http://getbootstrap.com/javascript/#carousel\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // CAROUSEL CLASS DEFINITION\n  // =========================\n\n  var Carousel = function (element, options) {\n    this.$element    = $(element)\n    this.$indicators = this.$element.find('.carousel-indicators')\n    this.options     = options\n    this.paused      =\n    this.sliding     =\n    this.interval    =\n    this.$active     =\n    this.$items      = null\n\n    this.options.pause == 'hover' && this.$element\n      .on('mouseenter', $.proxy(this.pause, this))\n      .on('mouseleave', $.proxy(this.cycle, this))\n  }\n\n  Carousel.DEFAULTS = {\n    interval: 5000,\n    pause: 'hover',\n    wrap: true\n  }\n\n  Carousel.prototype.cycle =  function (e) {\n    e || (this.paused = false)\n\n    this.interval && clearInterval(this.interval)\n\n    this.options.interval\n      && !this.paused\n      && (this.interval = setInterval($.proxy(this.next, this), this.options.interval))\n\n    return this\n  }\n\n  Carousel.prototype.getActiveIndex = function () {\n    this.$active = this.$element.find('.item.active')\n    this.$items  = this.$active.parent().children()\n\n    return this.$items.index(this.$active)\n  }\n\n  Carousel.prototype.to = function (pos) {\n    var that        = this\n    var activeIndex = this.getActiveIndex()\n\n    if (pos > (this.$items.length - 1) || pos < 0) return\n\n    if (this.sliding)       return this.$element.one('slid.bs.carousel', function () { that.to(pos) })\n    if (activeIndex == pos) return this.pause().cycle()\n\n    return this.slide(pos > activeIndex ? 'next' : 'prev', $(this.$items[pos]))\n  }\n\n  Carousel.prototype.pause = function (e) {\n    e || (this.paused = true)\n\n    if (this.$element.find('.next, .prev').length && $.support.transition) {\n      this.$element.trigger($.support.transition.end)\n      this.cycle(true)\n    }\n\n    this.interval = clearInterval(this.interval)\n\n    return this\n  }\n\n  Carousel.prototype.next = function () {\n    if (this.sliding) return\n    return this.slide('next')\n  }\n\n  Carousel.prototype.prev = function () {\n    if (this.sliding) return\n    return this.slide('prev')\n  }\n\n  Carousel.prototype.slide = function (type, next) {\n    var $active   = this.$element.find('.item.active')\n    var $next     = next || $active[type]()\n    var isCycling = this.interval\n    var direction = type == 'next' ? 'left' : 'right'\n    var fallback  = type == 'next' ? 'first' : 'last'\n    var that      = this\n\n    if (!$next.length) {\n      if (!this.options.wrap) return\n      $next = this.$element.find('.item')[fallback]()\n    }\n\n    if ($next.hasClass('active')) return this.sliding = false\n\n    var e = $.Event('slide.bs.carousel', { relatedTarget: $next[0], direction: direction })\n    this.$element.trigger(e)\n    if (e.isDefaultPrevented()) return\n\n    this.sliding = true\n\n    isCycling && this.pause()\n\n    if (this.$indicators.length) {\n      this.$indicators.find('.active').removeClass('active')\n      this.$element.one('slid.bs.carousel', function () {\n        var $nextIndicator = $(that.$indicators.children()[that.getActiveIndex()])\n        $nextIndicator && $nextIndicator.addClass('active')\n      })\n    }\n\n    if ($.support.transition && this.$element.hasClass('slide')) {\n      $next.addClass(type)\n      $next[0].offsetWidth // force reflow\n      $active.addClass(direction)\n      $next.addClass(direction)\n      $active\n        .one($.support.transition.end, function () {\n          $next.removeClass([type, direction].join(' ')).addClass('active')\n          $active.removeClass(['active', direction].join(' '))\n          that.sliding = false\n          setTimeout(function () { that.$element.trigger('slid.bs.carousel') }, 0)\n        })\n        .emulateTransitionEnd($active.css('transition-duration').slice(0, -1) * 1000)\n    } else {\n      $active.removeClass('active')\n      $next.addClass('active')\n      this.sliding = false\n      this.$element.trigger('slid.bs.carousel')\n    }\n\n    isCycling && this.cycle()\n\n    return this\n  }\n\n\n  // CAROUSEL PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.carousel\n\n  $.fn.carousel = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.carousel')\n      var options = $.extend({}, Carousel.DEFAULTS, $this.data(), typeof option == 'object' && option)\n      var action  = typeof option == 'string' ? option : options.slide\n\n      if (!data) $this.data('bs.carousel', (data = new Carousel(this, options)))\n      if (typeof option == 'number') data.to(option)\n      else if (action) data[action]()\n      else if (options.interval) data.pause().cycle()\n    })\n  }\n\n  $.fn.carousel.Constructor = Carousel\n\n\n  // CAROUSEL NO CONFLICT\n  // ====================\n\n  $.fn.carousel.noConflict = function () {\n    $.fn.carousel = old\n    return this\n  }\n\n\n  // CAROUSEL DATA-API\n  // =================\n\n  $(document).on('click.bs.carousel.data-api', '[data-slide], [data-slide-to]', function (e) {\n    var $this   = $(this), href\n    var $target = $($this.attr('data-target') || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '')) //strip for ie7\n    var options = $.extend({}, $target.data(), $this.data())\n    var slideIndex = $this.attr('data-slide-to')\n    if (slideIndex) options.interval = false\n\n    $target.carousel(options)\n\n    if (slideIndex = $this.attr('data-slide-to')) {\n      $target.data('bs.carousel').to(slideIndex)\n    }\n\n    e.preventDefault()\n  })\n\n  $(window).on('load', function () {\n    $('[data-ride=\"carousel\"]').each(function () {\n      var $carousel = $(this)\n      $carousel.carousel($carousel.data())\n    })\n  })\n\n}(jQuery);\n","collapse.js":"/* ========================================================================\n * Bootstrap: collapse.js v3.1.1\n * http://getbootstrap.com/javascript/#collapse\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // COLLAPSE PUBLIC CLASS DEFINITION\n  // ================================\n\n  var Collapse = function (element, options) {\n    this.$element      = $(element)\n    this.options       = $.extend({}, Collapse.DEFAULTS, options)\n    this.transitioning = null\n\n    if (this.options.parent) this.$parent = $(this.options.parent)\n    if (this.options.toggle) this.toggle()\n  }\n\n  Collapse.DEFAULTS = {\n    toggle: true\n  }\n\n  Collapse.prototype.dimension = function () {\n    var hasWidth = this.$element.hasClass('width')\n    return hasWidth ? 'width' : 'height'\n  }\n\n  Collapse.prototype.show = function () {\n    if (this.transitioning || this.$element.hasClass('in')) return\n\n    var startEvent = $.Event('show.bs.collapse')\n    this.$element.trigger(startEvent)\n    if (startEvent.isDefaultPrevented()) return\n\n    var actives = this.$parent && this.$parent.find('> .panel > .in')\n\n    if (actives && actives.length) {\n      var hasData = actives.data('bs.collapse')\n      if (hasData && hasData.transitioning) return\n      actives.collapse('hide')\n      hasData || actives.data('bs.collapse', null)\n    }\n\n    var dimension = this.dimension()\n\n    this.$element\n      .removeClass('collapse')\n      .addClass('collapsing')\n      [dimension](0)\n\n    this.transitioning = 1\n\n    var complete = function () {\n      this.$element\n        .removeClass('collapsing')\n        .addClass('collapse in')\n        [dimension]('auto')\n      this.transitioning = 0\n      this.$element.trigger('shown.bs.collapse')\n    }\n\n    if (!$.support.transition) return complete.call(this)\n\n    var scrollSize = $.camelCase(['scroll', dimension].join('-'))\n\n    this.$element\n      .one($.support.transition.end, $.proxy(complete, this))\n      .emulateTransitionEnd(350)\n      [dimension](this.$element[0][scrollSize])\n  }\n\n  Collapse.prototype.hide = function () {\n    if (this.transitioning || !this.$element.hasClass('in')) return\n\n    var startEvent = $.Event('hide.bs.collapse')\n    this.$element.trigger(startEvent)\n    if (startEvent.isDefaultPrevented()) return\n\n    var dimension = this.dimension()\n\n    this.$element\n      [dimension](this.$element[dimension]())\n      [0].offsetHeight\n\n    this.$element\n      .addClass('collapsing')\n      .removeClass('collapse')\n      .removeClass('in')\n\n    this.transitioning = 1\n\n    var complete = function () {\n      this.transitioning = 0\n      this.$element\n        .trigger('hidden.bs.collapse')\n        .removeClass('collapsing')\n        .addClass('collapse')\n    }\n\n    if (!$.support.transition) return complete.call(this)\n\n    this.$element\n      [dimension](0)\n      .one($.support.transition.end, $.proxy(complete, this))\n      .emulateTransitionEnd(350)\n  }\n\n  Collapse.prototype.toggle = function () {\n    this[this.$element.hasClass('in') ? 'hide' : 'show']()\n  }\n\n\n  // COLLAPSE PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.collapse\n\n  $.fn.collapse = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.collapse')\n      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)\n\n      if (!data && options.toggle && option == 'show') option = !option\n      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.collapse.Constructor = Collapse\n\n\n  // COLLAPSE NO CONFLICT\n  // ====================\n\n  $.fn.collapse.noConflict = function () {\n    $.fn.collapse = old\n    return this\n  }\n\n\n  // COLLAPSE DATA-API\n  // =================\n\n  $(document).on('click.bs.collapse.data-api', '[data-toggle=collapse]', function (e) {\n    var $this   = $(this), href\n    var target  = $this.attr('data-target')\n        || e.preventDefault()\n        || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '') //strip for ie7\n    var $target = $(target)\n    var data    = $target.data('bs.collapse')\n    var option  = data ? 'toggle' : $this.data()\n    var parent  = $this.attr('data-parent')\n    var $parent = parent && $(parent)\n\n    if (!data || !data.transitioning) {\n      if ($parent) $parent.find('[data-toggle=collapse][data-parent=\"' + parent + '\"]').not($this).addClass('collapsed')\n      $this[$target.hasClass('in') ? 'addClass' : 'removeClass']('collapsed')\n    }\n\n    $target.collapse(option)\n  })\n\n}(jQuery);\n","dropdown.js":"/* ========================================================================\n * Bootstrap: dropdown.js v3.1.1\n * http://getbootstrap.com/javascript/#dropdowns\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // DROPDOWN CLASS DEFINITION\n  // =========================\n\n  var backdrop = '.dropdown-backdrop'\n  var toggle   = '[data-toggle=dropdown]'\n  var Dropdown = function (element) {\n    $(element).on('click.bs.dropdown', this.toggle)\n  }\n\n  Dropdown.prototype.toggle = function (e) {\n    var $this = $(this)\n\n    if ($this.is('.disabled, :disabled')) return\n\n    var $parent  = getParent($this)\n    var isActive = $parent.hasClass('open')\n\n    clearMenus()\n\n    if (!isActive) {\n      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {\n        // if mobile we use a backdrop because click events don't delegate\n        $('<div class=\"dropdown-backdrop\"/>').insertAfter($(this)).on('click', clearMenus)\n      }\n\n      var relatedTarget = { relatedTarget: this }\n      $parent.trigger(e = $.Event('show.bs.dropdown', relatedTarget))\n\n      if (e.isDefaultPrevented()) return\n\n      $parent\n        .toggleClass('open')\n        .trigger('shown.bs.dropdown', relatedTarget)\n\n      $this.trigger('focus')\n    }\n\n    return false\n  }\n\n  Dropdown.prototype.keydown = function (e) {\n    if (!/(38|40|27)/.test(e.keyCode)) return\n\n    var $this = $(this)\n\n    e.preventDefault()\n    e.stopPropagation()\n\n    if ($this.is('.disabled, :disabled')) return\n\n    var $parent  = getParent($this)\n    var isActive = $parent.hasClass('open')\n\n    if (!isActive || (isActive && e.keyCode == 27)) {\n      if (e.which == 27) $parent.find(toggle).trigger('focus')\n      return $this.trigger('click')\n    }\n\n    var desc = ' li:not(.divider):visible a'\n    var $items = $parent.find('[role=menu]' + desc + ', [role=listbox]' + desc)\n\n    if (!$items.length) return\n\n    var index = $items.index($items.filter(':focus'))\n\n    if (e.keyCode == 38 && index > 0)                 index--                        // up\n    if (e.keyCode == 40 && index < $items.length - 1) index++                        // down\n    if (!~index)                                      index = 0\n\n    $items.eq(index).trigger('focus')\n  }\n\n  function clearMenus(e) {\n    $(backdrop).remove()\n    $(toggle).each(function () {\n      var $parent = getParent($(this))\n      var relatedTarget = { relatedTarget: this }\n      if (!$parent.hasClass('open')) return\n      $parent.trigger(e = $.Event('hide.bs.dropdown', relatedTarget))\n      if (e.isDefaultPrevented()) return\n      $parent.removeClass('open').trigger('hidden.bs.dropdown', relatedTarget)\n    })\n  }\n\n  function getParent($this) {\n    var selector = $this.attr('data-target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && /#[A-Za-z]/.test(selector) && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\n    }\n\n    var $parent = selector && $(selector)\n\n    return $parent && $parent.length ? $parent : $this.parent()\n  }\n\n\n  // DROPDOWN PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.dropdown\n\n  $.fn.dropdown = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('bs.dropdown')\n\n      if (!data) $this.data('bs.dropdown', (data = new Dropdown(this)))\n      if (typeof option == 'string') data[option].call($this)\n    })\n  }\n\n  $.fn.dropdown.Constructor = Dropdown\n\n\n  // DROPDOWN NO CONFLICT\n  // ====================\n\n  $.fn.dropdown.noConflict = function () {\n    $.fn.dropdown = old\n    return this\n  }\n\n\n  // APPLY TO STANDARD DROPDOWN ELEMENTS\n  // ===================================\n\n  $(document)\n    .on('click.bs.dropdown.data-api', clearMenus)\n    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })\n    .on('click.bs.dropdown.data-api', toggle, Dropdown.prototype.toggle)\n    .on('keydown.bs.dropdown.data-api', toggle + ', [role=menu], [role=listbox]', Dropdown.prototype.keydown)\n\n}(jQuery);\n","modal.js":"/* ========================================================================\n * Bootstrap: modal.js v3.1.1\n * http://getbootstrap.com/javascript/#modals\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // MODAL CLASS DEFINITION\n  // ======================\n\n  var Modal = function (element, options) {\n    this.options   = options\n    this.$element  = $(element)\n    this.$backdrop =\n    this.isShown   = null\n\n    if (this.options.remote) {\n      this.$element\n        .find('.modal-content')\n        .load(this.options.remote, $.proxy(function () {\n          this.$element.trigger('loaded.bs.modal')\n        }, this))\n    }\n  }\n\n  Modal.DEFAULTS = {\n    backdrop: true,\n    keyboard: true,\n    show: true\n  }\n\n  Modal.prototype.toggle = function (_relatedTarget) {\n    return this[!this.isShown ? 'show' : 'hide'](_relatedTarget)\n  }\n\n  Modal.prototype.show = function (_relatedTarget) {\n    var that = this\n    var e    = $.Event('show.bs.modal', { relatedTarget: _relatedTarget })\n\n    this.$element.trigger(e)\n\n    if (this.isShown || e.isDefaultPrevented()) return\n\n    this.isShown = true\n\n    this.escape()\n\n    this.$element.on('click.dismiss.bs.modal', '[data-dismiss=\"modal\"]', $.proxy(this.hide, this))\n\n    this.backdrop(function () {\n      var transition = $.support.transition && that.$element.hasClass('fade')\n\n      if (!that.$element.parent().length) {\n        that.$element.appendTo(document.body) // don't move modals dom position\n      }\n\n      that.$element\n        .show()\n        .scrollTop(0)\n\n      if (transition) {\n        that.$element[0].offsetWidth // force reflow\n      }\n\n      that.$element\n        .addClass('in')\n        .attr('aria-hidden', false)\n\n      that.enforceFocus()\n\n      var e = $.Event('shown.bs.modal', { relatedTarget: _relatedTarget })\n\n      transition ?\n        that.$element.find('.modal-dialog') // wait for modal to slide in\n          .one($.support.transition.end, function () {\n            that.$element.trigger('focus').trigger(e)\n          })\n          .emulateTransitionEnd(300) :\n        that.$element.trigger('focus').trigger(e)\n    })\n  }\n\n  Modal.prototype.hide = function (e) {\n    if (e) e.preventDefault()\n\n    e = $.Event('hide.bs.modal')\n\n    this.$element.trigger(e)\n\n    if (!this.isShown || e.isDefaultPrevented()) return\n\n    this.isShown = false\n\n    this.escape()\n\n    $(document).off('focusin.bs.modal')\n\n    this.$element\n      .removeClass('in')\n      .attr('aria-hidden', true)\n      .off('click.dismiss.bs.modal')\n\n    $.support.transition && this.$element.hasClass('fade') ?\n      this.$element\n        .one($.support.transition.end, $.proxy(this.hideModal, this))\n        .emulateTransitionEnd(300) :\n      this.hideModal()\n  }\n\n  Modal.prototype.enforceFocus = function () {\n    $(document)\n      .off('focusin.bs.modal') // guard against infinite focus loop\n      .on('focusin.bs.modal', $.proxy(function (e) {\n        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {\n          this.$element.trigger('focus')\n        }\n      }, this))\n  }\n\n  Modal.prototype.escape = function () {\n    if (this.isShown && this.options.keyboard) {\n      this.$element.on('keyup.dismiss.bs.modal', $.proxy(function (e) {\n        e.which == 27 && this.hide()\n      }, this))\n    } else if (!this.isShown) {\n      this.$element.off('keyup.dismiss.bs.modal')\n    }\n  }\n\n  Modal.prototype.hideModal = function () {\n    var that = this\n    this.$element.hide()\n    this.backdrop(function () {\n      that.removeBackdrop()\n      that.$element.trigger('hidden.bs.modal')\n    })\n  }\n\n  Modal.prototype.removeBackdrop = function () {\n    this.$backdrop && this.$backdrop.remove()\n    this.$backdrop = null\n  }\n\n  Modal.prototype.backdrop = function (callback) {\n    var animate = this.$element.hasClass('fade') ? 'fade' : ''\n\n    if (this.isShown && this.options.backdrop) {\n      var doAnimate = $.support.transition && animate\n\n      this.$backdrop = $('<div class=\"modal-backdrop ' + animate + '\" />')\n        .appendTo(document.body)\n\n      this.$element.on('click.dismiss.bs.modal', $.proxy(function (e) {\n        if (e.target !== e.currentTarget) return\n        this.options.backdrop == 'static'\n          ? this.$element[0].focus.call(this.$element[0])\n          : this.hide.call(this)\n      }, this))\n\n      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow\n\n      this.$backdrop.addClass('in')\n\n      if (!callback) return\n\n      doAnimate ?\n        this.$backdrop\n          .one($.support.transition.end, callback)\n          .emulateTransitionEnd(150) :\n        callback()\n\n    } else if (!this.isShown && this.$backdrop) {\n      this.$backdrop.removeClass('in')\n\n      $.support.transition && this.$element.hasClass('fade') ?\n        this.$backdrop\n          .one($.support.transition.end, callback)\n          .emulateTransitionEnd(150) :\n        callback()\n\n    } else if (callback) {\n      callback()\n    }\n  }\n\n\n  // MODAL PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.modal\n\n  $.fn.modal = function (option, _relatedTarget) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.modal')\n      var options = $.extend({}, Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)\n\n      if (!data) $this.data('bs.modal', (data = new Modal(this, options)))\n      if (typeof option == 'string') data[option](_relatedTarget)\n      else if (options.show) data.show(_relatedTarget)\n    })\n  }\n\n  $.fn.modal.Constructor = Modal\n\n\n  // MODAL NO CONFLICT\n  // =================\n\n  $.fn.modal.noConflict = function () {\n    $.fn.modal = old\n    return this\n  }\n\n\n  // MODAL DATA-API\n  // ==============\n\n  $(document).on('click.bs.modal.data-api', '[data-toggle=\"modal\"]', function (e) {\n    var $this   = $(this)\n    var href    = $this.attr('href')\n    var $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\\s]+$)/, ''))) //strip for ie7\n    var option  = $target.data('bs.modal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())\n\n    if ($this.is('a')) e.preventDefault()\n\n    $target\n      .modal(option, this)\n      .one('hide', function () {\n        $this.is(':visible') && $this.trigger('focus')\n      })\n  })\n\n  $(document)\n    .on('show.bs.modal', '.modal', function () { $(document.body).addClass('modal-open') })\n    .on('hidden.bs.modal', '.modal', function () { $(document.body).removeClass('modal-open') })\n\n}(jQuery);\n","popover.js":"/* ========================================================================\n * Bootstrap: popover.js v3.1.1\n * http://getbootstrap.com/javascript/#popovers\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // POPOVER PUBLIC CLASS DEFINITION\n  // ===============================\n\n  var Popover = function (element, options) {\n    this.init('popover', element, options)\n  }\n\n  if (!$.fn.tooltip) throw new Error('Popover requires tooltip.js')\n\n  Popover.DEFAULTS = $.extend({}, $.fn.tooltip.Constructor.DEFAULTS, {\n    placement: 'right',\n    trigger: 'click',\n    content: '',\n    template: '<div class=\"popover\"><div class=\"arrow\"></div><h3 class=\"popover-title\"></h3><div class=\"popover-content\"></div></div>'\n  })\n\n\n  // NOTE: POPOVER EXTENDS tooltip.js\n  // ================================\n\n  Popover.prototype = $.extend({}, $.fn.tooltip.Constructor.prototype)\n\n  Popover.prototype.constructor = Popover\n\n  Popover.prototype.getDefaults = function () {\n    return Popover.DEFAULTS\n  }\n\n  Popover.prototype.setContent = function () {\n    var $tip    = this.tip()\n    var title   = this.getTitle()\n    var content = this.getContent()\n\n    $tip.find('.popover-title')[this.options.html ? 'html' : 'text'](title)\n    $tip.find('.popover-content')[ // we use append for html objects to maintain js events\n      this.options.html ? (typeof content == 'string' ? 'html' : 'append') : 'text'\n    ](content)\n\n    $tip.removeClass('fade top bottom left right in')\n\n    // IE8 doesn't accept hiding via the `:empty` pseudo selector, we have to do\n    // this manually by checking the contents.\n    if (!$tip.find('.popover-title').html()) $tip.find('.popover-title').hide()\n  }\n\n  Popover.prototype.hasContent = function () {\n    return this.getTitle() || this.getContent()\n  }\n\n  Popover.prototype.getContent = function () {\n    var $e = this.$element\n    var o  = this.options\n\n    return $e.attr('data-content')\n      || (typeof o.content == 'function' ?\n            o.content.call($e[0]) :\n            o.content)\n  }\n\n  Popover.prototype.arrow = function () {\n    return this.$arrow = this.$arrow || this.tip().find('.arrow')\n  }\n\n  Popover.prototype.tip = function () {\n    if (!this.$tip) this.$tip = $(this.options.template)\n    return this.$tip\n  }\n\n\n  // POPOVER PLUGIN DEFINITION\n  // =========================\n\n  var old = $.fn.popover\n\n  $.fn.popover = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.popover')\n      var options = typeof option == 'object' && option\n\n      if (!data && option == 'destroy') return\n      if (!data) $this.data('bs.popover', (data = new Popover(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.popover.Constructor = Popover\n\n\n  // POPOVER NO CONFLICT\n  // ===================\n\n  $.fn.popover.noConflict = function () {\n    $.fn.popover = old\n    return this\n  }\n\n}(jQuery);\n","scrollspy.js":"/* ========================================================================\n * Bootstrap: scrollspy.js v3.1.1\n * http://getbootstrap.com/javascript/#scrollspy\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // SCROLLSPY CLASS DEFINITION\n  // ==========================\n\n  function ScrollSpy(element, options) {\n    var href\n    var process  = $.proxy(this.process, this)\n\n    this.$element       = $(element).is('body') ? $(window) : $(element)\n    this.$body          = $('body')\n    this.$scrollElement = this.$element.on('scroll.bs.scroll-spy.data-api', process)\n    this.options        = $.extend({}, ScrollSpy.DEFAULTS, options)\n    this.selector       = (this.options.target\n      || ((href = $(element).attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '')) //strip for ie7\n      || '') + ' .nav li > a'\n    this.offsets        = $([])\n    this.targets        = $([])\n    this.activeTarget   = null\n\n    this.refresh()\n    this.process()\n  }\n\n  ScrollSpy.DEFAULTS = {\n    offset: 10\n  }\n\n  ScrollSpy.prototype.refresh = function () {\n    var offsetMethod = this.$element[0] == window ? 'offset' : 'position'\n\n    this.offsets = $([])\n    this.targets = $([])\n\n    var self     = this\n    var $targets = this.$body\n      .find(this.selector)\n      .map(function () {\n        var $el   = $(this)\n        var href  = $el.data('target') || $el.attr('href')\n        var $href = /^#./.test(href) && $(href)\n\n        return ($href\n          && $href.length\n          && $href.is(':visible')\n          && [[ $href[offsetMethod]().top + (!$.isWindow(self.$scrollElement.get(0)) && self.$scrollElement.scrollTop()), href ]]) || null\n      })\n      .sort(function (a, b) { return a[0] - b[0] })\n      .each(function () {\n        self.offsets.push(this[0])\n        self.targets.push(this[1])\n      })\n  }\n\n  ScrollSpy.prototype.process = function () {\n    var scrollTop    = this.$scrollElement.scrollTop() + this.options.offset\n    var scrollHeight = this.$scrollElement[0].scrollHeight || this.$body[0].scrollHeight\n    var maxScroll    = scrollHeight - this.$scrollElement.height()\n    var offsets      = this.offsets\n    var targets      = this.targets\n    var activeTarget = this.activeTarget\n    var i\n\n    if (scrollTop >= maxScroll) {\n      return activeTarget != (i = targets.last()[0]) && this.activate(i)\n    }\n\n    if (activeTarget && scrollTop <= offsets[0]) {\n      return activeTarget != (i = targets[0]) && this.activate(i)\n    }\n\n    for (i = offsets.length; i--;) {\n      activeTarget != targets[i]\n        && scrollTop >= offsets[i]\n        && (!offsets[i + 1] || scrollTop <= offsets[i + 1])\n        && this.activate( targets[i] )\n    }\n  }\n\n  ScrollSpy.prototype.activate = function (target) {\n    this.activeTarget = target\n\n    $(this.selector)\n      .parentsUntil(this.options.target, '.active')\n      .removeClass('active')\n\n    var selector = this.selector +\n        '[data-target=\"' + target + '\"],' +\n        this.selector + '[href=\"' + target + '\"]'\n\n    var active = $(selector)\n      .parents('li')\n      .addClass('active')\n\n    if (active.parent('.dropdown-menu').length) {\n      active = active\n        .closest('li.dropdown')\n        .addClass('active')\n    }\n\n    active.trigger('activate.bs.scrollspy')\n  }\n\n\n  // SCROLLSPY PLUGIN DEFINITION\n  // ===========================\n\n  var old = $.fn.scrollspy\n\n  $.fn.scrollspy = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.scrollspy')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.scrollspy', (data = new ScrollSpy(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.scrollspy.Constructor = ScrollSpy\n\n\n  // SCROLLSPY NO CONFLICT\n  // =====================\n\n  $.fn.scrollspy.noConflict = function () {\n    $.fn.scrollspy = old\n    return this\n  }\n\n\n  // SCROLLSPY DATA-API\n  // ==================\n\n  $(window).on('load', function () {\n    $('[data-spy=\"scroll\"]').each(function () {\n      var $spy = $(this)\n      $spy.scrollspy($spy.data())\n    })\n  })\n\n}(jQuery);\n","tab.js":"/* ========================================================================\n * Bootstrap: tab.js v3.1.1\n * http://getbootstrap.com/javascript/#tabs\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // TAB CLASS DEFINITION\n  // ====================\n\n  var Tab = function (element) {\n    this.element = $(element)\n  }\n\n  Tab.prototype.show = function () {\n    var $this    = this.element\n    var $ul      = $this.closest('ul:not(.dropdown-menu)')\n    var selector = $this.data('target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\n    }\n\n    if ($this.parent('li').hasClass('active')) return\n\n    var previous = $ul.find('.active:last a')[0]\n    var e        = $.Event('show.bs.tab', {\n      relatedTarget: previous\n    })\n\n    $this.trigger(e)\n\n    if (e.isDefaultPrevented()) return\n\n    var $target = $(selector)\n\n    this.activate($this.parent('li'), $ul)\n    this.activate($target, $target.parent(), function () {\n      $this.trigger({\n        type: 'shown.bs.tab',\n        relatedTarget: previous\n      })\n    })\n  }\n\n  Tab.prototype.activate = function (element, container, callback) {\n    var $active    = container.find('> .active')\n    var transition = callback\n      && $.support.transition\n      && $active.hasClass('fade')\n\n    function next() {\n      $active\n        .removeClass('active')\n        .find('> .dropdown-menu > .active')\n        .removeClass('active')\n\n      element.addClass('active')\n\n      if (transition) {\n        element[0].offsetWidth // reflow for transition\n        element.addClass('in')\n      } else {\n        element.removeClass('fade')\n      }\n\n      if (element.parent('.dropdown-menu')) {\n        element.closest('li.dropdown').addClass('active')\n      }\n\n      callback && callback()\n    }\n\n    transition ?\n      $active\n        .one($.support.transition.end, next)\n        .emulateTransitionEnd(150) :\n      next()\n\n    $active.removeClass('in')\n  }\n\n\n  // TAB PLUGIN DEFINITION\n  // =====================\n\n  var old = $.fn.tab\n\n  $.fn.tab = function ( option ) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('bs.tab')\n\n      if (!data) $this.data('bs.tab', (data = new Tab(this)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.tab.Constructor = Tab\n\n\n  // TAB NO CONFLICT\n  // ===============\n\n  $.fn.tab.noConflict = function () {\n    $.fn.tab = old\n    return this\n  }\n\n\n  // TAB DATA-API\n  // ============\n\n  $(document).on('click.bs.tab.data-api', '[data-toggle=\"tab\"], [data-toggle=\"pill\"]', function (e) {\n    e.preventDefault()\n    $(this).tab('show')\n  })\n\n}(jQuery);\n","tooltip.js":"/* ========================================================================\n * Bootstrap: tooltip.js v3.1.1\n * http://getbootstrap.com/javascript/#tooltip\n * Inspired by the original jQuery.tipsy by Jason Frame\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // TOOLTIP PUBLIC CLASS DEFINITION\n  // ===============================\n\n  var Tooltip = function (element, options) {\n    this.type       =\n    this.options    =\n    this.enabled    =\n    this.timeout    =\n    this.hoverState =\n    this.$element   = null\n\n    this.init('tooltip', element, options)\n  }\n\n  Tooltip.DEFAULTS = {\n    animation: true,\n    placement: 'top',\n    selector: false,\n    template: '<div class=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div></div>',\n    trigger: 'hover focus',\n    title: '',\n    delay: 0,\n    html: false,\n    container: false\n  }\n\n  Tooltip.prototype.init = function (type, element, options) {\n    this.enabled  = true\n    this.type     = type\n    this.$element = $(element)\n    this.options  = this.getOptions(options)\n\n    var triggers = this.options.trigger.split(' ')\n\n    for (var i = triggers.length; i--;) {\n      var trigger = triggers[i]\n\n      if (trigger == 'click') {\n        this.$element.on('click.' + this.type, this.options.selector, $.proxy(this.toggle, this))\n      } else if (trigger != 'manual') {\n        var eventIn  = trigger == 'hover' ? 'mouseenter' : 'focusin'\n        var eventOut = trigger == 'hover' ? 'mouseleave' : 'focusout'\n\n        this.$element.on(eventIn  + '.' + this.type, this.options.selector, $.proxy(this.enter, this))\n        this.$element.on(eventOut + '.' + this.type, this.options.selector, $.proxy(this.leave, this))\n      }\n    }\n\n    this.options.selector ?\n      (this._options = $.extend({}, this.options, { trigger: 'manual', selector: '' })) :\n      this.fixTitle()\n  }\n\n  Tooltip.prototype.getDefaults = function () {\n    return Tooltip.DEFAULTS\n  }\n\n  Tooltip.prototype.getOptions = function (options) {\n    options = $.extend({}, this.getDefaults(), this.$element.data(), options)\n\n    if (options.delay && typeof options.delay == 'number') {\n      options.delay = {\n        show: options.delay,\n        hide: options.delay\n      }\n    }\n\n    return options\n  }\n\n  Tooltip.prototype.getDelegateOptions = function () {\n    var options  = {}\n    var defaults = this.getDefaults()\n\n    this._options && $.each(this._options, function (key, value) {\n      if (defaults[key] != value) options[key] = value\n    })\n\n    return options\n  }\n\n  Tooltip.prototype.enter = function (obj) {\n    var self = obj instanceof this.constructor ?\n      obj : $(obj.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type)\n\n    clearTimeout(self.timeout)\n\n    self.hoverState = 'in'\n\n    if (!self.options.delay || !self.options.delay.show) return self.show()\n\n    self.timeout = setTimeout(function () {\n      if (self.hoverState == 'in') self.show()\n    }, self.options.delay.show)\n  }\n\n  Tooltip.prototype.leave = function (obj) {\n    var self = obj instanceof this.constructor ?\n      obj : $(obj.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type)\n\n    clearTimeout(self.timeout)\n\n    self.hoverState = 'out'\n\n    if (!self.options.delay || !self.options.delay.hide) return self.hide()\n\n    self.timeout = setTimeout(function () {\n      if (self.hoverState == 'out') self.hide()\n    }, self.options.delay.hide)\n  }\n\n  Tooltip.prototype.show = function () {\n    var e = $.Event('show.bs.' + this.type)\n\n    if (this.hasContent() && this.enabled) {\n      this.$element.trigger(e)\n\n      if (e.isDefaultPrevented()) return\n      var that = this;\n\n      var $tip = this.tip()\n\n      this.setContent()\n\n      if (this.options.animation) $tip.addClass('fade')\n\n      var placement = typeof this.options.placement == 'function' ?\n        this.options.placement.call(this, $tip[0], this.$element[0]) :\n        this.options.placement\n\n      var autoToken = /\\s?auto?\\s?/i\n      var autoPlace = autoToken.test(placement)\n      if (autoPlace) placement = placement.replace(autoToken, '') || 'top'\n\n      $tip\n        .detach()\n        .css({ top: 0, left: 0, display: 'block' })\n        .addClass(placement)\n\n      this.options.container ? $tip.appendTo(this.options.container) : $tip.insertAfter(this.$element)\n\n      var pos          = this.getPosition()\n      var actualWidth  = $tip[0].offsetWidth\n      var actualHeight = $tip[0].offsetHeight\n\n      if (autoPlace) {\n        var $parent = this.$element.parent()\n\n        var orgPlacement = placement\n        var docScroll    = document.documentElement.scrollTop || document.body.scrollTop\n        var parentWidth  = this.options.container == 'body' ? window.innerWidth  : $parent.outerWidth()\n        var parentHeight = this.options.container == 'body' ? window.innerHeight : $parent.outerHeight()\n        var parentLeft   = this.options.container == 'body' ? 0 : $parent.offset().left\n\n        placement = placement == 'bottom' && pos.top   + pos.height  + actualHeight - docScroll > parentHeight  ? 'top'    :\n                    placement == 'top'    && pos.top   - docScroll   - actualHeight < 0                         ? 'bottom' :\n                    placement == 'right'  && pos.right + actualWidth > parentWidth                              ? 'left'   :\n                    placement == 'left'   && pos.left  - actualWidth < parentLeft                               ? 'right'  :\n                    placement\n\n        $tip\n          .removeClass(orgPlacement)\n          .addClass(placement)\n      }\n\n      var calculatedOffset = this.getCalculatedOffset(placement, pos, actualWidth, actualHeight)\n\n      this.applyPlacement(calculatedOffset, placement)\n      this.hoverState = null\n\n      var complete = function() {\n        that.$element.trigger('shown.bs.' + that.type)\n      }\n\n      $.support.transition && this.$tip.hasClass('fade') ?\n        $tip\n          .one($.support.transition.end, complete)\n          .emulateTransitionEnd(150) :\n        complete()\n    }\n  }\n\n  Tooltip.prototype.applyPlacement = function (offset, placement) {\n    var replace\n    var $tip   = this.tip()\n    var width  = $tip[0].offsetWidth\n    var height = $tip[0].offsetHeight\n\n    // manually read margins because getBoundingClientRect includes difference\n    var marginTop = parseInt($tip.css('margin-top'), 10)\n    var marginLeft = parseInt($tip.css('margin-left'), 10)\n\n    // we must check for NaN for ie 8/9\n    if (isNaN(marginTop))  marginTop  = 0\n    if (isNaN(marginLeft)) marginLeft = 0\n\n    offset.top  = offset.top  + marginTop\n    offset.left = offset.left + marginLeft\n\n    // $.fn.offset doesn't round pixel values\n    // so we use setOffset directly with our own function B-0\n    $.offset.setOffset($tip[0], $.extend({\n      using: function (props) {\n        $tip.css({\n          top: Math.round(props.top),\n          left: Math.round(props.left)\n        })\n      }\n    }, offset), 0)\n\n    $tip.addClass('in')\n\n    // check to see if placing tip in new offset caused the tip to resize itself\n    var actualWidth  = $tip[0].offsetWidth\n    var actualHeight = $tip[0].offsetHeight\n\n    if (placement == 'top' && actualHeight != height) {\n      replace = true\n      offset.top = offset.top + height - actualHeight\n    }\n\n    if (/bottom|top/.test(placement)) {\n      var delta = 0\n\n      if (offset.left < 0) {\n        delta       = offset.left * -2\n        offset.left = 0\n\n        $tip.offset(offset)\n\n        actualWidth  = $tip[0].offsetWidth\n        actualHeight = $tip[0].offsetHeight\n      }\n\n      this.replaceArrow(delta - width + actualWidth, actualWidth, 'left')\n    } else {\n      this.replaceArrow(actualHeight - height, actualHeight, 'top')\n    }\n\n    if (replace) $tip.offset(offset)\n  }\n\n  Tooltip.prototype.replaceArrow = function (delta, dimension, position) {\n    this.arrow().css(position, delta ? (50 * (1 - delta / dimension) + '%') : '')\n  }\n\n  Tooltip.prototype.setContent = function () {\n    var $tip  = this.tip()\n    var title = this.getTitle()\n\n    $tip.find('.tooltip-inner')[this.options.html ? 'html' : 'text'](title)\n    $tip.removeClass('fade in top bottom left right')\n  }\n\n  Tooltip.prototype.hide = function () {\n    var that = this\n    var $tip = this.tip()\n    var e    = $.Event('hide.bs.' + this.type)\n\n    function complete() {\n      if (that.hoverState != 'in') $tip.detach()\n      that.$element.trigger('hidden.bs.' + that.type)\n    }\n\n    this.$element.trigger(e)\n\n    if (e.isDefaultPrevented()) return\n\n    $tip.removeClass('in')\n\n    $.support.transition && this.$tip.hasClass('fade') ?\n      $tip\n        .one($.support.transition.end, complete)\n        .emulateTransitionEnd(150) :\n      complete()\n\n    this.hoverState = null\n\n    return this\n  }\n\n  Tooltip.prototype.fixTitle = function () {\n    var $e = this.$element\n    if ($e.attr('title') || typeof($e.attr('data-original-title')) != 'string') {\n      $e.attr('data-original-title', $e.attr('title') || '').attr('title', '')\n    }\n  }\n\n  Tooltip.prototype.hasContent = function () {\n    return this.getTitle()\n  }\n\n  Tooltip.prototype.getPosition = function () {\n    var el = this.$element[0]\n    return $.extend({}, (typeof el.getBoundingClientRect == 'function') ? el.getBoundingClientRect() : {\n      width: el.offsetWidth,\n      height: el.offsetHeight\n    }, this.$element.offset())\n  }\n\n  Tooltip.prototype.getCalculatedOffset = function (placement, pos, actualWidth, actualHeight) {\n    return placement == 'bottom' ? { top: pos.top + pos.height,   left: pos.left + pos.width / 2 - actualWidth / 2  } :\n           placement == 'top'    ? { top: pos.top - actualHeight, left: pos.left + pos.width / 2 - actualWidth / 2  } :\n           placement == 'left'   ? { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth } :\n        /* placement == 'right' */ { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width   }\n  }\n\n  Tooltip.prototype.getTitle = function () {\n    var title\n    var $e = this.$element\n    var o  = this.options\n\n    title = $e.attr('data-original-title')\n      || (typeof o.title == 'function' ? o.title.call($e[0]) :  o.title)\n\n    return title\n  }\n\n  Tooltip.prototype.tip = function () {\n    return this.$tip = this.$tip || $(this.options.template)\n  }\n\n  Tooltip.prototype.arrow = function () {\n    return this.$arrow = this.$arrow || this.tip().find('.tooltip-arrow')\n  }\n\n  Tooltip.prototype.validate = function () {\n    if (!this.$element[0].parentNode) {\n      this.hide()\n      this.$element = null\n      this.options  = null\n    }\n  }\n\n  Tooltip.prototype.enable = function () {\n    this.enabled = true\n  }\n\n  Tooltip.prototype.disable = function () {\n    this.enabled = false\n  }\n\n  Tooltip.prototype.toggleEnabled = function () {\n    this.enabled = !this.enabled\n  }\n\n  Tooltip.prototype.toggle = function (e) {\n    var self = e ? $(e.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type) : this\n    self.tip().hasClass('in') ? self.leave(self) : self.enter(self)\n  }\n\n  Tooltip.prototype.destroy = function () {\n    clearTimeout(this.timeout)\n    this.hide().$element.off('.' + this.type).removeData('bs.' + this.type)\n  }\n\n\n  // TOOLTIP PLUGIN DEFINITION\n  // =========================\n\n  var old = $.fn.tooltip\n\n  $.fn.tooltip = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.tooltip')\n      var options = typeof option == 'object' && option\n\n      if (!data && option == 'destroy') return\n      if (!data) $this.data('bs.tooltip', (data = new Tooltip(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.tooltip.Constructor = Tooltip\n\n\n  // TOOLTIP NO CONFLICT\n  // ===================\n\n  $.fn.tooltip.noConflict = function () {\n    $.fn.tooltip = old\n    return this\n  }\n\n}(jQuery);\n","transition.js":"/* ========================================================================\n * Bootstrap: transition.js v3.1.1\n * http://getbootstrap.com/javascript/#transitions\n * ========================================================================\n * Copyright 2011-2014 Twitter, Inc.\n * Licensed under MIT (https://github.com/twbs/bootstrap/blob/master/LICENSE)\n * ======================================================================== */\n\n\n+function ($) {\n  'use strict';\n\n  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)\n  // ============================================================\n\n  function transitionEnd() {\n    var el = document.createElement('bootstrap')\n\n    var transEndEventNames = {\n      'WebkitTransition' : 'webkitTransitionEnd',\n      'MozTransition'    : 'transitionend',\n      'OTransition'      : 'oTransitionEnd otransitionend',\n      'transition'       : 'transitionend'\n    }\n\n    for (var name in transEndEventNames) {\n      if (el.style[name] !== undefined) {\n        return { end: transEndEventNames[name] }\n      }\n    }\n\n    return false // explicit for ie8 (  ._.)\n  }\n\n  // http://blog.alexmaccaw.com/css-transitions\n  $.fn.emulateTransitionEnd = function (duration) {\n    var called = false, $el = this\n    $(this).one($.support.transition.end, function () { called = true })\n    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }\n    setTimeout(callback, duration)\n    return this\n  }\n\n  $(function () {\n    $.support.transition = transitionEnd()\n  })\n\n}(jQuery);\n"}
var __less = {"alerts.less":"//\n// Alerts\n// --------------------------------------------------\n\n\n// Base styles\n// -------------------------\n\n.alert {\n  padding: @alert-padding;\n  margin-bottom: @line-height-computed;\n  border: 1px solid transparent;\n  border-radius: @alert-border-radius;\n\n  // Headings for larger alerts\n  h4 {\n    margin-top: 0;\n    // Specified for the h4 to prevent conflicts of changing @headings-color\n    color: inherit;\n  }\n  // Provide class for links that match alerts\n  .alert-link {\n    font-weight: @alert-link-font-weight;\n  }\n\n  // Improve alignment and spacing of inner content\n  > p,\n  > ul {\n    margin-bottom: 0;\n  }\n  > p + p {\n    margin-top: 5px;\n  }\n}\n\n// Dismissable alerts\n//\n// Expand the right padding and account for the close button's positioning.\n\n.alert-dismissable {\n padding-right: (@alert-padding + 20);\n\n  // Adjust close link position\n  .close {\n    position: relative;\n    top: -2px;\n    right: -21px;\n    color: inherit;\n  }\n}\n\n// Alternate styles\n//\n// Generate contextual modifier classes for colorizing the alert.\n\n.alert-success {\n  .alert-variant(@alert-success-bg; @alert-success-border; @alert-success-text);\n}\n.alert-info {\n  .alert-variant(@alert-info-bg; @alert-info-border; @alert-info-text);\n}\n.alert-warning {\n  .alert-variant(@alert-warning-bg; @alert-warning-border; @alert-warning-text);\n}\n.alert-danger {\n  .alert-variant(@alert-danger-bg; @alert-danger-border; @alert-danger-text);\n}\n","badges.less":"//\n// Badges\n// --------------------------------------------------\n\n\n// Base classes\n.badge {\n  display: inline-block;\n  min-width: 10px;\n  padding: 3px 7px;\n  font-size: @font-size-small;\n  font-weight: @badge-font-weight;\n  color: @badge-color;\n  line-height: @badge-line-height;\n  vertical-align: baseline;\n  white-space: nowrap;\n  text-align: center;\n  background-color: @badge-bg;\n  border-radius: @badge-border-radius;\n\n  // Empty badges collapse automatically (not available in IE8)\n  &:empty {\n    display: none;\n  }\n\n  // Quick fix for badges in buttons\n  .btn & {\n    position: relative;\n    top: -1px;\n  }\n  .btn-xs & {\n    top: 0;\n    padding: 1px 5px;\n  }\n}\n\n// Hover state, but only for links\na.badge {\n  &:hover,\n  &:focus {\n    color: @badge-link-hover-color;\n    text-decoration: none;\n    cursor: pointer;\n  }\n}\n\n// Account for counters in navs\na.list-group-item.active > .badge,\n.nav-pills > .active > a > .badge {\n  color: @badge-active-color;\n  background-color: @badge-active-bg;\n}\n.nav-pills > li > a > .badge {\n  margin-left: 3px;\n}\n","bootstrap.less":"// Core variables and mixins\n@import \"variables.less\";\n@import \"mixins.less\";\n\n// Reset\n@import \"normalize.less\";\n@import \"print.less\";\n\n// Core CSS\n@import \"scaffolding.less\";\n@import \"type.less\";\n@import \"code.less\";\n@import \"grid.less\";\n@import \"tables.less\";\n@import \"forms.less\";\n@import \"buttons.less\";\n\n// Components\n@import \"component-animations.less\";\n@import \"glyphicons.less\";\n@import \"dropdowns.less\";\n@import \"button-groups.less\";\n@import \"input-groups.less\";\n@import \"navs.less\";\n@import \"navbar.less\";\n@import \"breadcrumbs.less\";\n@import \"pagination.less\";\n@import \"pager.less\";\n@import \"labels.less\";\n@import \"badges.less\";\n@import \"jumbotron.less\";\n@import \"thumbnails.less\";\n@import \"alerts.less\";\n@import \"progress-bars.less\";\n@import \"media.less\";\n@import \"list-group.less\";\n@import \"panels.less\";\n@import \"wells.less\";\n@import \"close.less\";\n\n// Components w/ JavaScript\n@import \"modals.less\";\n@import \"tooltip.less\";\n@import \"popovers.less\";\n@import \"carousel.less\";\n\n// Utility classes\n@import \"utilities.less\";\n@import \"responsive-utilities.less\";\n","breadcrumbs.less":"//\n// Breadcrumbs\n// --------------------------------------------------\n\n\n.breadcrumb {\n  padding: @breadcrumb-padding-vertical @breadcrumb-padding-horizontal;\n  margin-bottom: @line-height-computed;\n  list-style: none;\n  background-color: @breadcrumb-bg;\n  border-radius: @border-radius-base;\n\n  > li {\n    display: inline-block;\n\n    + li:before {\n      content: \"@{breadcrumb-separator}\\00a0\"; // Unicode space added since inline-block means non-collapsing white-space\n      padding: 0 5px;\n      color: @breadcrumb-color;\n    }\n  }\n\n  > .active {\n    color: @breadcrumb-active-color;\n  }\n}\n","button-groups.less":"//\n// Button groups\n// --------------------------------------------------\n\n// Make the div behave like a button\n.btn-group,\n.btn-group-vertical {\n  position: relative;\n  display: inline-block;\n  vertical-align: middle; // match .btn alignment given font-size hack above\n  > .btn {\n    position: relative;\n    float: left;\n    // Bring the \"active\" button to the front\n    &:hover,\n    &:focus,\n    &:active,\n    &.active {\n      z-index: 2;\n    }\n    &:focus {\n      // Remove focus outline when dropdown JS adds it after closing the menu\n      outline: none;\n    }\n  }\n}\n\n// Prevent double borders when buttons are next to each other\n.btn-group {\n  .btn + .btn,\n  .btn + .btn-group,\n  .btn-group + .btn,\n  .btn-group + .btn-group {\n    margin-left: -1px;\n  }\n}\n\n// Optional: Group multiple button groups together for a toolbar\n.btn-toolbar {\n  margin-left: -5px; // Offset the first child's margin\n  &:extend(.clearfix all);\n\n  .btn-group,\n  .input-group {\n    float: left;\n  }\n  > .btn,\n  > .btn-group,\n  > .input-group {\n    margin-left: 5px;\n  }\n}\n\n.btn-group > .btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {\n  border-radius: 0;\n}\n\n// Set corners individual because sometimes a single button can be in a .btn-group and we need :first-child and :last-child to both match\n.btn-group > .btn:first-child {\n  margin-left: 0;\n  &:not(:last-child):not(.dropdown-toggle) {\n    .border-right-radius(0);\n  }\n}\n// Need .dropdown-toggle since :last-child doesn't apply given a .dropdown-menu immediately after it\n.btn-group > .btn:last-child:not(:first-child),\n.btn-group > .dropdown-toggle:not(:first-child) {\n  .border-left-radius(0);\n}\n\n// Custom edits for including btn-groups within btn-groups (useful for including dropdown buttons within a btn-group)\n.btn-group > .btn-group {\n  float: left;\n}\n.btn-group > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group > .btn-group:first-child {\n  > .btn:last-child,\n  > .dropdown-toggle {\n    .border-right-radius(0);\n  }\n}\n.btn-group > .btn-group:last-child > .btn:first-child {\n  .border-left-radius(0);\n}\n\n// On active and open, don't show outline\n.btn-group .dropdown-toggle:active,\n.btn-group.open .dropdown-toggle {\n  outline: 0;\n}\n\n\n// Sizing\n//\n// Remix the default button sizing classes into new ones for easier manipulation.\n\n.btn-group-xs > .btn { &:extend(.btn-xs); }\n.btn-group-sm > .btn { &:extend(.btn-sm); }\n.btn-group-lg > .btn { &:extend(.btn-lg); }\n\n\n// Split button dropdowns\n// ----------------------\n\n// Give the line between buttons some depth\n.btn-group > .btn + .dropdown-toggle {\n  padding-left: 8px;\n  padding-right: 8px;\n}\n.btn-group > .btn-lg + .dropdown-toggle {\n  padding-left: 12px;\n  padding-right: 12px;\n}\n\n// The clickable button for toggling the menu\n// Remove the gradient and set the same inset shadow as the :active state\n.btn-group.open .dropdown-toggle {\n  .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n\n  // Show no shadow for `.btn-link` since it has no other button styles.\n  &.btn-link {\n    .box-shadow(none);\n  }\n}\n\n\n// Reposition the caret\n.btn .caret {\n  margin-left: 0;\n}\n// Carets in other button sizes\n.btn-lg .caret {\n  border-width: @caret-width-large @caret-width-large 0;\n  border-bottom-width: 0;\n}\n// Upside down carets for .dropup\n.dropup .btn-lg .caret {\n  border-width: 0 @caret-width-large @caret-width-large;\n}\n\n\n// Vertical button groups\n// ----------------------\n\n.btn-group-vertical {\n  > .btn,\n  > .btn-group,\n  > .btn-group > .btn {\n    display: block;\n    float: none;\n    width: 100%;\n    max-width: 100%;\n  }\n\n  // Clear floats so dropdown menus can be properly placed\n  > .btn-group {\n    &:extend(.clearfix all);\n    > .btn {\n      float: none;\n    }\n  }\n\n  > .btn + .btn,\n  > .btn + .btn-group,\n  > .btn-group + .btn,\n  > .btn-group + .btn-group {\n    margin-top: -1px;\n    margin-left: 0;\n  }\n}\n\n.btn-group-vertical > .btn {\n  &:not(:first-child):not(:last-child) {\n    border-radius: 0;\n  }\n  &:first-child:not(:last-child) {\n    border-top-right-radius: @border-radius-base;\n    .border-bottom-radius(0);\n  }\n  &:last-child:not(:first-child) {\n    border-bottom-left-radius: @border-radius-base;\n    .border-top-radius(0);\n  }\n}\n.btn-group-vertical > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group-vertical > .btn-group:first-child:not(:last-child) {\n  > .btn:last-child,\n  > .dropdown-toggle {\n    .border-bottom-radius(0);\n  }\n}\n.btn-group-vertical > .btn-group:last-child:not(:first-child) > .btn:first-child {\n  .border-top-radius(0);\n}\n\n\n\n// Justified button groups\n// ----------------------\n\n.btn-group-justified {\n  display: table;\n  width: 100%;\n  table-layout: fixed;\n  border-collapse: separate;\n  > .btn,\n  > .btn-group {\n    float: none;\n    display: table-cell;\n    width: 1%;\n  }\n  > .btn-group .btn {\n    width: 100%;\n  }\n}\n\n\n// Checkbox and radio options\n[data-toggle=\"buttons\"] > .btn > input[type=\"radio\"],\n[data-toggle=\"buttons\"] > .btn > input[type=\"checkbox\"] {\n  display: none;\n}\n","buttons.less":"//\n// Buttons\n// --------------------------------------------------\n\n\n// Base styles\n// --------------------------------------------------\n\n.btn {\n  display: inline-block;\n  margin-bottom: 0; // For input.btn\n  font-weight: @btn-font-weight;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid transparent;\n  white-space: nowrap;\n  .button-size(@padding-base-vertical; @padding-base-horizontal; @font-size-base; @line-height-base; @border-radius-base);\n  .user-select(none);\n\n  &,\n  &:active,\n  &.active {\n    &:focus {\n      .tab-focus();\n    }\n  }\n\n  &:hover,\n  &:focus {\n    color: @btn-default-color;\n    text-decoration: none;\n  }\n\n  &:active,\n  &.active {\n    outline: 0;\n    background-image: none;\n    .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n  }\n\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n    pointer-events: none; // Future-proof disabling of clicks\n    .opacity(.65);\n    .box-shadow(none);\n  }\n}\n\n\n// Alternate buttons\n// --------------------------------------------------\n\n.btn-default {\n  .button-variant(@btn-default-color; @btn-default-bg; @btn-default-border);\n}\n.btn-primary {\n  .button-variant(@btn-primary-color; @btn-primary-bg; @btn-primary-border);\n}\n// Success appears as green\n.btn-success {\n  .button-variant(@btn-success-color; @btn-success-bg; @btn-success-border);\n}\n// Info appears as blue-green\n.btn-info {\n  .button-variant(@btn-info-color; @btn-info-bg; @btn-info-border);\n}\n// Warning appears as orange\n.btn-warning {\n  .button-variant(@btn-warning-color; @btn-warning-bg; @btn-warning-border);\n}\n// Danger and error appear as red\n.btn-danger {\n  .button-variant(@btn-danger-color; @btn-danger-bg; @btn-danger-border);\n}\n\n\n// Link buttons\n// -------------------------\n\n// Make a button look and behave like a link\n.btn-link {\n  color: @link-color;\n  font-weight: normal;\n  cursor: pointer;\n  border-radius: 0;\n\n  &,\n  &:active,\n  &[disabled],\n  fieldset[disabled] & {\n    background-color: transparent;\n    .box-shadow(none);\n  }\n  &,\n  &:hover,\n  &:focus,\n  &:active {\n    border-color: transparent;\n  }\n  &:hover,\n  &:focus {\n    color: @link-hover-color;\n    text-decoration: underline;\n    background-color: transparent;\n  }\n  &[disabled],\n  fieldset[disabled] & {\n    &:hover,\n    &:focus {\n      color: @btn-link-disabled-color;\n      text-decoration: none;\n    }\n  }\n}\n\n\n// Button Sizes\n// --------------------------------------------------\n\n.btn-lg {\n  // line-height: ensure even-numbered height of button next to large input\n  .button-size(@padding-large-vertical; @padding-large-horizontal; @font-size-large; @line-height-large; @border-radius-large);\n}\n.btn-sm {\n  // line-height: ensure proper height of button next to small input\n  .button-size(@padding-small-vertical; @padding-small-horizontal; @font-size-small; @line-height-small; @border-radius-small);\n}\n.btn-xs {\n  .button-size(@padding-xs-vertical; @padding-xs-horizontal; @font-size-small; @line-height-small; @border-radius-small);\n}\n\n\n// Block button\n// --------------------------------------------------\n\n.btn-block {\n  display: block;\n  width: 100%;\n  padding-left: 0;\n  padding-right: 0;\n}\n\n// Vertically space out multiple block buttons\n.btn-block + .btn-block {\n  margin-top: 5px;\n}\n\n// Specificity overrides\ninput[type=\"submit\"],\ninput[type=\"reset\"],\ninput[type=\"button\"] {\n  &.btn-block {\n    width: 100%;\n  }\n}\n","carousel.less":"//\n// Carousel\n// --------------------------------------------------\n\n\n// Wrapper for the slide container and indicators\n.carousel {\n  position: relative;\n}\n\n.carousel-inner {\n  position: relative;\n  overflow: hidden;\n  width: 100%;\n\n  > .item {\n    display: none;\n    position: relative;\n    .transition(.6s ease-in-out left);\n\n    // Account for jankitude on images\n    > img,\n    > a > img {\n      &:extend(.img-responsive);\n      line-height: 1;\n    }\n  }\n\n  > .active,\n  > .next,\n  > .prev { display: block; }\n\n  > .active {\n    left: 0;\n  }\n\n  > .next,\n  > .prev {\n    position: absolute;\n    top: 0;\n    width: 100%;\n  }\n\n  > .next {\n    left: 100%;\n  }\n  > .prev {\n    left: -100%;\n  }\n  > .next.left,\n  > .prev.right {\n    left: 0;\n  }\n\n  > .active.left {\n    left: -100%;\n  }\n  > .active.right {\n    left: 100%;\n  }\n\n}\n\n// Left/right controls for nav\n// ---------------------------\n\n.carousel-control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  width: @carousel-control-width;\n  .opacity(@carousel-control-opacity);\n  font-size: @carousel-control-font-size;\n  color: @carousel-control-color;\n  text-align: center;\n  text-shadow: @carousel-text-shadow;\n  // We can't have this transition here because WebKit cancels the carousel\n  // animation if you trip this while in the middle of another animation.\n\n  // Set gradients for backgrounds\n  &.left {\n    #gradient > .horizontal(@start-color: rgba(0,0,0,.5); @end-color: rgba(0,0,0,.0001));\n  }\n  &.right {\n    left: auto;\n    right: 0;\n    #gradient > .horizontal(@start-color: rgba(0,0,0,.0001); @end-color: rgba(0,0,0,.5));\n  }\n\n  // Hover/focus state\n  &:hover,\n  &:focus {\n    outline: none;\n    color: @carousel-control-color;\n    text-decoration: none;\n    .opacity(.9);\n  }\n\n  // Toggles\n  .icon-prev,\n  .icon-next,\n  .glyphicon-chevron-left,\n  .glyphicon-chevron-right {\n    position: absolute;\n    top: 50%;\n    z-index: 5;\n    display: inline-block;\n  }\n  .icon-prev,\n  .glyphicon-chevron-left {\n    left: 50%;\n  }\n  .icon-next,\n  .glyphicon-chevron-right {\n    right: 50%;\n  }\n  .icon-prev,\n  .icon-next {\n    width:  20px;\n    height: 20px;\n    margin-top: -10px;\n    margin-left: -10px;\n    font-family: serif;\n  }\n\n  .icon-prev {\n    &:before {\n      content: '\\2039';// SINGLE LEFT-POINTING ANGLE QUOTATION MARK (U+2039)\n    }\n  }\n  .icon-next {\n    &:before {\n      content: '\\203a';// SINGLE RIGHT-POINTING ANGLE QUOTATION MARK (U+203A)\n    }\n  }\n}\n\n// Optional indicator pips\n//\n// Add an unordered list with the following class and add a list item for each\n// slide your carousel holds.\n\n.carousel-indicators {\n  position: absolute;\n  bottom: 10px;\n  left: 50%;\n  z-index: 15;\n  width: 60%;\n  margin-left: -30%;\n  padding-left: 0;\n  list-style: none;\n  text-align: center;\n\n  li {\n    display: inline-block;\n    width:  10px;\n    height: 10px;\n    margin: 1px;\n    text-indent: -999px;\n    border: 1px solid @carousel-indicator-border-color;\n    border-radius: 10px;\n    cursor: pointer;\n\n    // IE8-9 hack for event handling\n    //\n    // Internet Explorer 8-9 does not support clicks on elements without a set\n    // `background-color`. We cannot use `filter` since that's not viewed as a\n    // background color by the browser. Thus, a hack is needed.\n    //\n    // For IE8, we set solid black as it doesn't support `rgba()`. For IE9, we\n    // set alpha transparency for the best results possible.\n    background-color: #000 \\9; // IE8\n    background-color: rgba(0,0,0,0); // IE9\n  }\n  .active {\n    margin: 0;\n    width:  12px;\n    height: 12px;\n    background-color: @carousel-indicator-active-bg;\n  }\n}\n\n// Optional captions\n// -----------------------------\n// Hidden by default for smaller viewports\n.carousel-caption {\n  position: absolute;\n  left: 15%;\n  right: 15%;\n  bottom: 20px;\n  z-index: 10;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  color: @carousel-caption-color;\n  text-align: center;\n  text-shadow: @carousel-text-shadow;\n  & .btn {\n    text-shadow: none; // No shadow for button elements in carousel-caption\n  }\n}\n\n\n// Scale up controls for tablets and up\n@media screen and (min-width: @screen-sm-min) {\n\n  // Scale up the controls a smidge\n  .carousel-control {\n    .glyphicon-chevron-left,\n    .glyphicon-chevron-right,\n    .icon-prev,\n    .icon-next {\n      width: 30px;\n      height: 30px;\n      margin-top: -15px;\n      margin-left: -15px;\n      font-size: 30px;\n    }\n  }\n\n  // Show and left align the captions\n  .carousel-caption {\n    left: 20%;\n    right: 20%;\n    padding-bottom: 30px;\n  }\n\n  // Move up the indicators\n  .carousel-indicators {\n    bottom: 20px;\n  }\n}\n","close.less":"//\n// Close icons\n// --------------------------------------------------\n\n\n.close {\n  float: right;\n  font-size: (@font-size-base * 1.5);\n  font-weight: @close-font-weight;\n  line-height: 1;\n  color: @close-color;\n  text-shadow: @close-text-shadow;\n  .opacity(.2);\n\n  &:hover,\n  &:focus {\n    color: @close-color;\n    text-decoration: none;\n    cursor: pointer;\n    .opacity(.5);\n  }\n\n  // Additional properties for button version\n  // iOS requires the button element instead of an anchor tag.\n  // If you want the anchor version, it requires `href=\"#\"`.\n  button& {\n    padding: 0;\n    cursor: pointer;\n    background: transparent;\n    border: 0;\n    -webkit-appearance: none;\n  }\n}\n","code.less":"//\n// Code (inline and block)\n// --------------------------------------------------\n\n\n// Inline and block code styles\ncode,\nkbd,\npre,\nsamp {\n  font-family: @font-family-monospace;\n}\n\n// Inline code\ncode {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: @code-color;\n  background-color: @code-bg;\n  white-space: nowrap;\n  border-radius: @border-radius-base;\n}\n\n// User input typically entered via keyboard\nkbd {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: @kbd-color;\n  background-color: @kbd-bg;\n  border-radius: @border-radius-small;\n  box-shadow: inset 0 -1px 0 rgba(0,0,0,.25);\n}\n\n// Blocks of code\npre {\n  display: block;\n  padding: ((@line-height-computed - 1) / 2);\n  margin: 0 0 (@line-height-computed / 2);\n  font-size: (@font-size-base - 1); // 14px to 13px\n  line-height: @line-height-base;\n  word-break: break-all;\n  word-wrap: break-word;\n  color: @pre-color;\n  background-color: @pre-bg;\n  border: 1px solid @pre-border-color;\n  border-radius: @border-radius-base;\n\n  // Account for some code outputs that place code tags in pre tags\n  code {\n    padding: 0;\n    font-size: inherit;\n    color: inherit;\n    white-space: pre-wrap;\n    background-color: transparent;\n    border-radius: 0;\n  }\n}\n\n// Enable scrollable blocks of code\n.pre-scrollable {\n  max-height: @pre-scrollable-max-height;\n  overflow-y: scroll;\n}\n","component-animations.less":"//\n// Component animations\n// --------------------------------------------------\n\n// Heads up!\n//\n// We don't use the `.opacity()` mixin here since it causes a bug with text\n// fields in IE7-8. Source: https://github.com/twitter/bootstrap/pull/3552.\n\n.fade {\n  opacity: 0;\n  .transition(opacity .15s linear);\n  &.in {\n    opacity: 1;\n  }\n}\n\n.collapse {\n  display: none;\n  &.in {\n    display: block;\n  }\n}\n.collapsing {\n  position: relative;\n  height: 0;\n  overflow: hidden;\n  .transition(height .35s ease);\n}\n","dropdowns.less":"//\n// Dropdown menus\n// --------------------------------------------------\n\n\n// Dropdown arrow/caret\n.caret {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 2px;\n  vertical-align: middle;\n  border-top:   @caret-width-base solid;\n  border-right: @caret-width-base solid transparent;\n  border-left:  @caret-width-base solid transparent;\n}\n\n// The dropdown wrapper (div)\n.dropdown {\n  position: relative;\n}\n\n// Prevent the focus on the dropdown toggle when closing dropdowns\n.dropdown-toggle:focus {\n  outline: 0;\n}\n\n// The dropdown menu (ul)\n.dropdown-menu {\n  position: absolute;\n  top: 100%;\n  left: 0;\n  z-index: @zindex-dropdown;\n  display: none; // none by default, but block on \"open\" of the menu\n  float: left;\n  min-width: 160px;\n  padding: 5px 0;\n  margin: 2px 0 0; // override default ul\n  list-style: none;\n  font-size: @font-size-base;\n  background-color: @dropdown-bg;\n  border: 1px solid @dropdown-fallback-border; // IE8 fallback\n  border: 1px solid @dropdown-border;\n  border-radius: @border-radius-base;\n  .box-shadow(0 6px 12px rgba(0,0,0,.175));\n  background-clip: padding-box;\n\n  // Aligns the dropdown menu to right\n  //\n  // Deprecated as of 3.1.0 in favor of `.dropdown-menu-[dir]`\n  &.pull-right {\n    right: 0;\n    left: auto;\n  }\n\n  // Dividers (basically an hr) within the dropdown\n  .divider {\n    .nav-divider(@dropdown-divider-bg);\n  }\n\n  // Links within the dropdown menu\n  > li > a {\n    display: block;\n    padding: 3px 20px;\n    clear: both;\n    font-weight: normal;\n    line-height: @line-height-base;\n    color: @dropdown-link-color;\n    white-space: nowrap; // prevent links from randomly breaking onto new lines\n  }\n}\n\n// Hover/Focus state\n.dropdown-menu > li > a {\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    color: @dropdown-link-hover-color;\n    background-color: @dropdown-link-hover-bg;\n  }\n}\n\n// Active state\n.dropdown-menu > .active > a {\n  &,\n  &:hover,\n  &:focus {\n    color: @dropdown-link-active-color;\n    text-decoration: none;\n    outline: 0;\n    background-color: @dropdown-link-active-bg;\n  }\n}\n\n// Disabled state\n//\n// Gray out text and ensure the hover/focus state remains gray\n\n.dropdown-menu > .disabled > a {\n  &,\n  &:hover,\n  &:focus {\n    color: @dropdown-link-disabled-color;\n  }\n}\n// Nuke hover/focus effects\n.dropdown-menu > .disabled > a {\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    background-color: transparent;\n    background-image: none; // Remove CSS gradient\n    .reset-filter();\n    cursor: not-allowed;\n  }\n}\n\n// Open state for the dropdown\n.open {\n  // Show the menu\n  > .dropdown-menu {\n    display: block;\n  }\n\n  // Remove the outline when :focus is triggered\n  > a {\n    outline: 0;\n  }\n}\n\n// Menu positioning\n//\n// Add extra class to `.dropdown-menu` to flip the alignment of the dropdown\n// menu with the parent.\n.dropdown-menu-right {\n  left: auto; // Reset the default from `.dropdown-menu`\n  right: 0;\n}\n// With v3, we enabled auto-flipping if you have a dropdown within a right\n// aligned nav component. To enable the undoing of that, we provide an override\n// to restore the default dropdown menu alignment.\n//\n// This is only for left-aligning a dropdown menu within a `.navbar-right` or\n// `.pull-right` nav component.\n.dropdown-menu-left {\n  left: 0;\n  right: auto;\n}\n\n// Dropdown section headers\n.dropdown-header {\n  display: block;\n  padding: 3px 20px;\n  font-size: @font-size-small;\n  line-height: @line-height-base;\n  color: @dropdown-header-color;\n}\n\n// Backdrop to catch body clicks on mobile, etc.\n.dropdown-backdrop {\n  position: fixed;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  z-index: (@zindex-dropdown - 10);\n}\n\n// Right aligned dropdowns\n.pull-right > .dropdown-menu {\n  right: 0;\n  left: auto;\n}\n\n// Allow for dropdowns to go bottom up (aka, dropup-menu)\n//\n// Just add .dropup after the standard .dropdown class and you're set, bro.\n// TODO: abstract this so that the navbar fixed styles are not placed here?\n\n.dropup,\n.navbar-fixed-bottom .dropdown {\n  // Reverse the caret\n  .caret {\n    border-top: 0;\n    border-bottom: @caret-width-base solid;\n    content: \"\";\n  }\n  // Different positioning for bottom up menu\n  .dropdown-menu {\n    top: auto;\n    bottom: 100%;\n    margin-bottom: 1px;\n  }\n}\n\n\n// Component alignment\n//\n// Reiterate per navbar.less and the modified component alignment there.\n\n@media (min-width: @grid-float-breakpoint) {\n  .navbar-right {\n    .dropdown-menu {\n      .dropdown-menu-right();\n    }\n    // Necessary for overrides of the default right aligned menu.\n    // Will remove come v4 in all likelihood.\n    .dropdown-menu-left {\n      .dropdown-menu-left();\n    }\n  }\n}\n\n","forms.less":"//\n// Forms\n// --------------------------------------------------\n\n\n// Normalize non-controls\n//\n// Restyle and baseline non-control form elements.\n\nfieldset {\n  padding: 0;\n  margin: 0;\n  border: 0;\n  // Chrome and Firefox set a `min-width: -webkit-min-content;` on fieldsets,\n  // so we reset that to ensure it behaves more like a standard block element.\n  // See https://github.com/twbs/bootstrap/issues/12359.\n  min-width: 0;\n}\n\nlegend {\n  display: block;\n  width: 100%;\n  padding: 0;\n  margin-bottom: @line-height-computed;\n  font-size: (@font-size-base * 1.5);\n  line-height: inherit;\n  color: @legend-color;\n  border: 0;\n  border-bottom: 1px solid @legend-border-color;\n}\n\nlabel {\n  display: inline-block;\n  margin-bottom: 5px;\n  font-weight: bold;\n}\n\n\n// Normalize form controls\n//\n// While most of our form styles require extra classes, some basic normalization\n// is required to ensure optimum display with or without those classes to better\n// address browser inconsistencies.\n\n// Override content-box in Normalize (* isn't specific enough)\ninput[type=\"search\"] {\n  .box-sizing(border-box);\n}\n\n// Position radios and checkboxes better\ninput[type=\"radio\"],\ninput[type=\"checkbox\"] {\n  margin: 4px 0 0;\n  margin-top: 1px \\9; /* IE8-9 */\n  line-height: normal;\n}\n\n// Set the height of file controls to match text inputs\ninput[type=\"file\"] {\n  display: block;\n}\n\n// Make range inputs behave like textual form controls\ninput[type=\"range\"] {\n  display: block;\n  width: 100%;\n}\n\n// Make multiple select elements height not fixed\nselect[multiple],\nselect[size] {\n  height: auto;\n}\n\n// Focus for file, radio, and checkbox\ninput[type=\"file\"]:focus,\ninput[type=\"radio\"]:focus,\ninput[type=\"checkbox\"]:focus {\n  .tab-focus();\n}\n\n// Adjust output element\noutput {\n  display: block;\n  padding-top: (@padding-base-vertical + 1);\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n}\n\n\n// Common form controls\n//\n// Shared size and type resets for form controls. Apply `.form-control` to any\n// of the following form controls:\n//\n// select\n// textarea\n// input[type=\"text\"]\n// input[type=\"password\"]\n// input[type=\"datetime\"]\n// input[type=\"datetime-local\"]\n// input[type=\"date\"]\n// input[type=\"month\"]\n// input[type=\"time\"]\n// input[type=\"week\"]\n// input[type=\"number\"]\n// input[type=\"email\"]\n// input[type=\"url\"]\n// input[type=\"search\"]\n// input[type=\"tel\"]\n// input[type=\"color\"]\n\n.form-control {\n  display: block;\n  width: 100%;\n  height: @input-height-base; // Make inputs at least the height of their button counterpart (base line-height + padding + border)\n  padding: @padding-base-vertical @padding-base-horizontal;\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n  background-color: @input-bg;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid @input-border;\n  border-radius: @input-border-radius;\n  .box-shadow(inset 0 1px 1px rgba(0,0,0,.075));\n  .transition(~\"border-color ease-in-out .15s, box-shadow ease-in-out .15s\");\n\n  // Customize the `:focus` state to imitate native WebKit styles.\n  .form-control-focus();\n\n  // Placeholder\n  .placeholder();\n\n  // Disabled and read-only inputs\n  //\n  // HTML5 says that controls under a fieldset > legend:first-child won't be\n  // disabled if the fieldset is disabled. Due to implementation difficulty, we\n  // don't honor that edge case; we style them as disabled anyway.\n  &[disabled],\n  &[readonly],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n    background-color: @input-bg-disabled;\n    opacity: 1; // iOS fix for unreadable disabled content\n  }\n\n  // Reset height for `textarea`s\n  textarea& {\n    height: auto;\n  }\n}\n\n\n// Search inputs in iOS\n//\n// This overrides the extra rounded corners on search inputs in iOS so that our\n// `.form-control` class can properly style them. Note that this cannot simply\n// be added to `.form-control` as it's not specific enough. For details, see\n// https://github.com/twbs/bootstrap/issues/11586.\n\ninput[type=\"search\"] {\n  -webkit-appearance: none;\n}\n\n\n// Special styles for iOS date input\n//\n// In Mobile Safari, date inputs require a pixel line-height that matches the\n// given height of the input.\n\ninput[type=\"date\"] {\n  line-height: @input-height-base;\n}\n\n\n// Form groups\n//\n// Designed to help with the organization and spacing of vertical forms. For\n// horizontal forms, use the predefined grid classes.\n\n.form-group {\n  margin-bottom: 15px;\n}\n\n\n// Checkboxes and radios\n//\n// Indent the labels to position radios/checkboxes as hanging controls.\n\n.radio,\n.checkbox {\n  display: block;\n  min-height: @line-height-computed; // clear the floating input if there is no label text\n  margin-top: 10px;\n  margin-bottom: 10px;\n  padding-left: 20px;\n  label {\n    display: inline;\n    font-weight: normal;\n    cursor: pointer;\n  }\n}\n.radio input[type=\"radio\"],\n.radio-inline input[type=\"radio\"],\n.checkbox input[type=\"checkbox\"],\n.checkbox-inline input[type=\"checkbox\"] {\n  float: left;\n  margin-left: -20px;\n}\n.radio + .radio,\n.checkbox + .checkbox {\n  margin-top: -5px; // Move up sibling radios or checkboxes for tighter spacing\n}\n\n// Radios and checkboxes on same line\n.radio-inline,\n.checkbox-inline {\n  display: inline-block;\n  padding-left: 20px;\n  margin-bottom: 0;\n  vertical-align: middle;\n  font-weight: normal;\n  cursor: pointer;\n}\n.radio-inline + .radio-inline,\n.checkbox-inline + .checkbox-inline {\n  margin-top: 0;\n  margin-left: 10px; // space out consecutive inline controls\n}\n\n// Apply same disabled cursor tweak as for inputs\n//\n// Note: Neither radios nor checkboxes can be readonly.\ninput[type=\"radio\"],\ninput[type=\"checkbox\"],\n.radio,\n.radio-inline,\n.checkbox,\n.checkbox-inline {\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n  }\n}\n\n\n// Form control sizing\n//\n// Build on `.form-control` with modifier classes to decrease or increase the\n// height and font-size of form controls.\n\n.input-sm {\n  .input-size(@input-height-small; @padding-small-vertical; @padding-small-horizontal; @font-size-small; @line-height-small; @border-radius-small);\n}\n\n.input-lg {\n  .input-size(@input-height-large; @padding-large-vertical; @padding-large-horizontal; @font-size-large; @line-height-large; @border-radius-large);\n}\n\n\n// Form control feedback states\n//\n// Apply contextual and semantic states to individual form controls.\n\n.has-feedback {\n  // Enable absolute positioning\n  position: relative;\n\n  // Ensure icons don't overlap text\n  .form-control {\n    padding-right: (@input-height-base * 1.25);\n  }\n\n  // Feedback icon (requires .glyphicon classes)\n  .form-control-feedback {\n    position: absolute;\n    top: (@line-height-computed + 5); // Height of the `label` and its margin\n    right: 0;\n    display: block;\n    width: @input-height-base;\n    height: @input-height-base;\n    line-height: @input-height-base;\n    text-align: center;\n  }\n}\n\n// Feedback states\n.has-success {\n  .form-control-validation(@state-success-text; @state-success-text; @state-success-bg);\n}\n.has-warning {\n  .form-control-validation(@state-warning-text; @state-warning-text; @state-warning-bg);\n}\n.has-error {\n  .form-control-validation(@state-danger-text; @state-danger-text; @state-danger-bg);\n}\n\n\n// Static form control text\n//\n// Apply class to a `p` element to make any string of text align with labels in\n// a horizontal form layout.\n\n.form-control-static {\n  margin-bottom: 0; // Remove default margin from `p`\n}\n\n\n// Help text\n//\n// Apply to any element you wish to create light text for placement immediately\n// below a form control. Use for general help, formatting, or instructional text.\n\n.help-block {\n  display: block; // account for any element using help-block\n  margin-top: 5px;\n  margin-bottom: 10px;\n  color: lighten(@text-color, 25%); // lighten the text some for contrast\n}\n\n\n\n// Inline forms\n//\n// Make forms appear inline(-block) by adding the `.form-inline` class. Inline\n// forms begin stacked on extra small (mobile) devices and then go inline when\n// viewports reach <768px.\n//\n// Requires wrapping inputs and labels with `.form-group` for proper display of\n// default HTML form controls and our custom form controls (e.g., input groups).\n//\n// Heads up! This is mixin-ed into `.navbar-form` in navbars.less.\n\n.form-inline {\n\n  // Kick in the inline\n  @media (min-width: @screen-sm-min) {\n    // Inline-block all the things for \"inline\"\n    .form-group {\n      display: inline-block;\n      margin-bottom: 0;\n      vertical-align: middle;\n    }\n\n    // In navbar-form, allow folks to *not* use `.form-group`\n    .form-control {\n      display: inline-block;\n      width: auto; // Prevent labels from stacking above inputs in `.form-group`\n      vertical-align: middle;\n    }\n    // Input groups need that 100% width though\n    .input-group > .form-control {\n      width: 100%;\n    }\n\n    .control-label {\n      margin-bottom: 0;\n      vertical-align: middle;\n    }\n\n    // Remove default margin on radios/checkboxes that were used for stacking, and\n    // then undo the floating of radios and checkboxes to match (which also avoids\n    // a bug in WebKit: https://github.com/twbs/bootstrap/issues/1969).\n    .radio,\n    .checkbox {\n      display: inline-block;\n      margin-top: 0;\n      margin-bottom: 0;\n      padding-left: 0;\n      vertical-align: middle;\n    }\n    .radio input[type=\"radio\"],\n    .checkbox input[type=\"checkbox\"] {\n      float: none;\n      margin-left: 0;\n    }\n\n    // Validation states\n    //\n    // Reposition the icon because it's now within a grid column and columns have\n    // `position: relative;` on them. Also accounts for the grid gutter padding.\n    .has-feedback .form-control-feedback {\n      top: 0;\n    }\n  }\n}\n\n\n// Horizontal forms\n//\n// Horizontal forms are built on grid classes and allow you to create forms with\n// labels on the left and inputs on the right.\n\n.form-horizontal {\n\n  // Consistent vertical alignment of labels, radios, and checkboxes\n  .control-label,\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline {\n    margin-top: 0;\n    margin-bottom: 0;\n    padding-top: (@padding-base-vertical + 1); // Default padding plus a border\n  }\n  // Account for padding we're adding to ensure the alignment and of help text\n  // and other content below items\n  .radio,\n  .checkbox {\n    min-height: (@line-height-computed + (@padding-base-vertical + 1));\n  }\n\n  // Make form groups behave like rows\n  .form-group {\n    .make-row();\n  }\n\n  .form-control-static {\n    padding-top: (@padding-base-vertical + 1);\n  }\n\n  // Only right align form labels here when the columns stop stacking\n  @media (min-width: @screen-sm-min) {\n    .control-label {\n      text-align: right;\n    }\n  }\n\n  // Validation states\n  //\n  // Reposition the icon because it's now within a grid column and columns have\n  // `position: relative;` on them. Also accounts for the grid gutter padding.\n  .has-feedback .form-control-feedback {\n    top: 0;\n    right: (@grid-gutter-width / 2);\n  }\n}\n","glyphicons.less":"//\n// Glyphicons for Bootstrap\n//\n// Since icons are fonts, they can be placed anywhere text is placed and are\n// thus automatically sized to match the surrounding child. To use, create an\n// inline element with the appropriate classes, like so:\n//\n// <a href=\"#\"><span class=\"glyphicon glyphicon-star\"></span> Star</a>\n\n// Import the fonts\n@font-face {\n  font-family: 'Glyphicons Halflings';\n  src: ~\"url('@{icon-font-path}@{icon-font-name}.eot')\";\n  src: ~\"url('@{icon-font-path}@{icon-font-name}.eot?#iefix') format('embedded-opentype')\",\n       ~\"url('@{icon-font-path}@{icon-font-name}.woff') format('woff')\",\n       ~\"url('@{icon-font-path}@{icon-font-name}.ttf') format('truetype')\",\n       ~\"url('@{icon-font-path}@{icon-font-name}.svg#@{icon-font-svg-id}') format('svg')\";\n}\n\n// Catchall baseclass\n.glyphicon {\n  position: relative;\n  top: 1px;\n  display: inline-block;\n  font-family: 'Glyphicons Halflings';\n  font-style: normal;\n  font-weight: normal;\n  line-height: 1;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n// Individual icons\n.glyphicon-asterisk               { &:before { content: \"\\2a\"; } }\n.glyphicon-plus                   { &:before { content: \"\\2b\"; } }\n.glyphicon-euro                   { &:before { content: \"\\20ac\"; } }\n.glyphicon-minus                  { &:before { content: \"\\2212\"; } }\n.glyphicon-cloud                  { &:before { content: \"\\2601\"; } }\n.glyphicon-envelope               { &:before { content: \"\\2709\"; } }\n.glyphicon-pencil                 { &:before { content: \"\\270f\"; } }\n.glyphicon-glass                  { &:before { content: \"\\e001\"; } }\n.glyphicon-music                  { &:before { content: \"\\e002\"; } }\n.glyphicon-search                 { &:before { content: \"\\e003\"; } }\n.glyphicon-heart                  { &:before { content: \"\\e005\"; } }\n.glyphicon-star                   { &:before { content: \"\\e006\"; } }\n.glyphicon-star-empty             { &:before { content: \"\\e007\"; } }\n.glyphicon-user                   { &:before { content: \"\\e008\"; } }\n.glyphicon-film                   { &:before { content: \"\\e009\"; } }\n.glyphicon-th-large               { &:before { content: \"\\e010\"; } }\n.glyphicon-th                     { &:before { content: \"\\e011\"; } }\n.glyphicon-th-list                { &:before { content: \"\\e012\"; } }\n.glyphicon-ok                     { &:before { content: \"\\e013\"; } }\n.glyphicon-remove                 { &:before { content: \"\\e014\"; } }\n.glyphicon-zoom-in                { &:before { content: \"\\e015\"; } }\n.glyphicon-zoom-out               { &:before { content: \"\\e016\"; } }\n.glyphicon-off                    { &:before { content: \"\\e017\"; } }\n.glyphicon-signal                 { &:before { content: \"\\e018\"; } }\n.glyphicon-cog                    { &:before { content: \"\\e019\"; } }\n.glyphicon-trash                  { &:before { content: \"\\e020\"; } }\n.glyphicon-home                   { &:before { content: \"\\e021\"; } }\n.glyphicon-file                   { &:before { content: \"\\e022\"; } }\n.glyphicon-time                   { &:before { content: \"\\e023\"; } }\n.glyphicon-road                   { &:before { content: \"\\e024\"; } }\n.glyphicon-download-alt           { &:before { content: \"\\e025\"; } }\n.glyphicon-download               { &:before { content: \"\\e026\"; } }\n.glyphicon-upload                 { &:before { content: \"\\e027\"; } }\n.glyphicon-inbox                  { &:before { content: \"\\e028\"; } }\n.glyphicon-play-circle            { &:before { content: \"\\e029\"; } }\n.glyphicon-repeat                 { &:before { content: \"\\e030\"; } }\n.glyphicon-refresh                { &:before { content: \"\\e031\"; } }\n.glyphicon-list-alt               { &:before { content: \"\\e032\"; } }\n.glyphicon-lock                   { &:before { content: \"\\e033\"; } }\n.glyphicon-flag                   { &:before { content: \"\\e034\"; } }\n.glyphicon-headphones             { &:before { content: \"\\e035\"; } }\n.glyphicon-volume-off             { &:before { content: \"\\e036\"; } }\n.glyphicon-volume-down            { &:before { content: \"\\e037\"; } }\n.glyphicon-volume-up              { &:before { content: \"\\e038\"; } }\n.glyphicon-qrcode                 { &:before { content: \"\\e039\"; } }\n.glyphicon-barcode                { &:before { content: \"\\e040\"; } }\n.glyphicon-tag                    { &:before { content: \"\\e041\"; } }\n.glyphicon-tags                   { &:before { content: \"\\e042\"; } }\n.glyphicon-book                   { &:before { content: \"\\e043\"; } }\n.glyphicon-bookmark               { &:before { content: \"\\e044\"; } }\n.glyphicon-print                  { &:before { content: \"\\e045\"; } }\n.glyphicon-camera                 { &:before { content: \"\\e046\"; } }\n.glyphicon-font                   { &:before { content: \"\\e047\"; } }\n.glyphicon-bold                   { &:before { content: \"\\e048\"; } }\n.glyphicon-italic                 { &:before { content: \"\\e049\"; } }\n.glyphicon-text-height            { &:before { content: \"\\e050\"; } }\n.glyphicon-text-width             { &:before { content: \"\\e051\"; } }\n.glyphicon-align-left             { &:before { content: \"\\e052\"; } }\n.glyphicon-align-center           { &:before { content: \"\\e053\"; } }\n.glyphicon-align-right            { &:before { content: \"\\e054\"; } }\n.glyphicon-align-justify          { &:before { content: \"\\e055\"; } }\n.glyphicon-list                   { &:before { content: \"\\e056\"; } }\n.glyphicon-indent-left            { &:before { content: \"\\e057\"; } }\n.glyphicon-indent-right           { &:before { content: \"\\e058\"; } }\n.glyphicon-facetime-video         { &:before { content: \"\\e059\"; } }\n.glyphicon-picture                { &:before { content: \"\\e060\"; } }\n.glyphicon-map-marker             { &:before { content: \"\\e062\"; } }\n.glyphicon-adjust                 { &:before { content: \"\\e063\"; } }\n.glyphicon-tint                   { &:before { content: \"\\e064\"; } }\n.glyphicon-edit                   { &:before { content: \"\\e065\"; } }\n.glyphicon-share                  { &:before { content: \"\\e066\"; } }\n.glyphicon-check                  { &:before { content: \"\\e067\"; } }\n.glyphicon-move                   { &:before { content: \"\\e068\"; } }\n.glyphicon-step-backward          { &:before { content: \"\\e069\"; } }\n.glyphicon-fast-backward          { &:before { content: \"\\e070\"; } }\n.glyphicon-backward               { &:before { content: \"\\e071\"; } }\n.glyphicon-play                   { &:before { content: \"\\e072\"; } }\n.glyphicon-pause                  { &:before { content: \"\\e073\"; } }\n.glyphicon-stop                   { &:before { content: \"\\e074\"; } }\n.glyphicon-forward                { &:before { content: \"\\e075\"; } }\n.glyphicon-fast-forward           { &:before { content: \"\\e076\"; } }\n.glyphicon-step-forward           { &:before { content: \"\\e077\"; } }\n.glyphicon-eject                  { &:before { content: \"\\e078\"; } }\n.glyphicon-chevron-left           { &:before { content: \"\\e079\"; } }\n.glyphicon-chevron-right          { &:before { content: \"\\e080\"; } }\n.glyphicon-plus-sign              { &:before { content: \"\\e081\"; } }\n.glyphicon-minus-sign             { &:before { content: \"\\e082\"; } }\n.glyphicon-remove-sign            { &:before { content: \"\\e083\"; } }\n.glyphicon-ok-sign                { &:before { content: \"\\e084\"; } }\n.glyphicon-question-sign          { &:before { content: \"\\e085\"; } }\n.glyphicon-info-sign              { &:before { content: \"\\e086\"; } }\n.glyphicon-screenshot             { &:before { content: \"\\e087\"; } }\n.glyphicon-remove-circle          { &:before { content: \"\\e088\"; } }\n.glyphicon-ok-circle              { &:before { content: \"\\e089\"; } }\n.glyphicon-ban-circle             { &:before { content: \"\\e090\"; } }\n.glyphicon-arrow-left             { &:before { content: \"\\e091\"; } }\n.glyphicon-arrow-right            { &:before { content: \"\\e092\"; } }\n.glyphicon-arrow-up               { &:before { content: \"\\e093\"; } }\n.glyphicon-arrow-down             { &:before { content: \"\\e094\"; } }\n.glyphicon-share-alt              { &:before { content: \"\\e095\"; } }\n.glyphicon-resize-full            { &:before { content: \"\\e096\"; } }\n.glyphicon-resize-small           { &:before { content: \"\\e097\"; } }\n.glyphicon-exclamation-sign       { &:before { content: \"\\e101\"; } }\n.glyphicon-gift                   { &:before { content: \"\\e102\"; } }\n.glyphicon-leaf                   { &:before { content: \"\\e103\"; } }\n.glyphicon-fire                   { &:before { content: \"\\e104\"; } }\n.glyphicon-eye-open               { &:before { content: \"\\e105\"; } }\n.glyphicon-eye-close              { &:before { content: \"\\e106\"; } }\n.glyphicon-warning-sign           { &:before { content: \"\\e107\"; } }\n.glyphicon-plane                  { &:before { content: \"\\e108\"; } }\n.glyphicon-calendar               { &:before { content: \"\\e109\"; } }\n.glyphicon-random                 { &:before { content: \"\\e110\"; } }\n.glyphicon-comment                { &:before { content: \"\\e111\"; } }\n.glyphicon-magnet                 { &:before { content: \"\\e112\"; } }\n.glyphicon-chevron-up             { &:before { content: \"\\e113\"; } }\n.glyphicon-chevron-down           { &:before { content: \"\\e114\"; } }\n.glyphicon-retweet                { &:before { content: \"\\e115\"; } }\n.glyphicon-shopping-cart          { &:before { content: \"\\e116\"; } }\n.glyphicon-folder-close           { &:before { content: \"\\e117\"; } }\n.glyphicon-folder-open            { &:before { content: \"\\e118\"; } }\n.glyphicon-resize-vertical        { &:before { content: \"\\e119\"; } }\n.glyphicon-resize-horizontal      { &:before { content: \"\\e120\"; } }\n.glyphicon-hdd                    { &:before { content: \"\\e121\"; } }\n.glyphicon-bullhorn               { &:before { content: \"\\e122\"; } }\n.glyphicon-bell                   { &:before { content: \"\\e123\"; } }\n.glyphicon-certificate            { &:before { content: \"\\e124\"; } }\n.glyphicon-thumbs-up              { &:before { content: \"\\e125\"; } }\n.glyphicon-thumbs-down            { &:before { content: \"\\e126\"; } }\n.glyphicon-hand-right             { &:before { content: \"\\e127\"; } }\n.glyphicon-hand-left              { &:before { content: \"\\e128\"; } }\n.glyphicon-hand-up                { &:before { content: \"\\e129\"; } }\n.glyphicon-hand-down              { &:before { content: \"\\e130\"; } }\n.glyphicon-circle-arrow-right     { &:before { content: \"\\e131\"; } }\n.glyphicon-circle-arrow-left      { &:before { content: \"\\e132\"; } }\n.glyphicon-circle-arrow-up        { &:before { content: \"\\e133\"; } }\n.glyphicon-circle-arrow-down      { &:before { content: \"\\e134\"; } }\n.glyphicon-globe                  { &:before { content: \"\\e135\"; } }\n.glyphicon-wrench                 { &:before { content: \"\\e136\"; } }\n.glyphicon-tasks                  { &:before { content: \"\\e137\"; } }\n.glyphicon-filter                 { &:before { content: \"\\e138\"; } }\n.glyphicon-briefcase              { &:before { content: \"\\e139\"; } }\n.glyphicon-fullscreen             { &:before { content: \"\\e140\"; } }\n.glyphicon-dashboard              { &:before { content: \"\\e141\"; } }\n.glyphicon-paperclip              { &:before { content: \"\\e142\"; } }\n.glyphicon-heart-empty            { &:before { content: \"\\e143\"; } }\n.glyphicon-link                   { &:before { content: \"\\e144\"; } }\n.glyphicon-phone                  { &:before { content: \"\\e145\"; } }\n.glyphicon-pushpin                { &:before { content: \"\\e146\"; } }\n.glyphicon-usd                    { &:before { content: \"\\e148\"; } }\n.glyphicon-gbp                    { &:before { content: \"\\e149\"; } }\n.glyphicon-sort                   { &:before { content: \"\\e150\"; } }\n.glyphicon-sort-by-alphabet       { &:before { content: \"\\e151\"; } }\n.glyphicon-sort-by-alphabet-alt   { &:before { content: \"\\e152\"; } }\n.glyphicon-sort-by-order          { &:before { content: \"\\e153\"; } }\n.glyphicon-sort-by-order-alt      { &:before { content: \"\\e154\"; } }\n.glyphicon-sort-by-attributes     { &:before { content: \"\\e155\"; } }\n.glyphicon-sort-by-attributes-alt { &:before { content: \"\\e156\"; } }\n.glyphicon-unchecked              { &:before { content: \"\\e157\"; } }\n.glyphicon-expand                 { &:before { content: \"\\e158\"; } }\n.glyphicon-collapse-down          { &:before { content: \"\\e159\"; } }\n.glyphicon-collapse-up            { &:before { content: \"\\e160\"; } }\n.glyphicon-log-in                 { &:before { content: \"\\e161\"; } }\n.glyphicon-flash                  { &:before { content: \"\\e162\"; } }\n.glyphicon-log-out                { &:before { content: \"\\e163\"; } }\n.glyphicon-new-window             { &:before { content: \"\\e164\"; } }\n.glyphicon-record                 { &:before { content: \"\\e165\"; } }\n.glyphicon-save                   { &:before { content: \"\\e166\"; } }\n.glyphicon-open                   { &:before { content: \"\\e167\"; } }\n.glyphicon-saved                  { &:before { content: \"\\e168\"; } }\n.glyphicon-import                 { &:before { content: \"\\e169\"; } }\n.glyphicon-export                 { &:before { content: \"\\e170\"; } }\n.glyphicon-send                   { &:before { content: \"\\e171\"; } }\n.glyphicon-floppy-disk            { &:before { content: \"\\e172\"; } }\n.glyphicon-floppy-saved           { &:before { content: \"\\e173\"; } }\n.glyphicon-floppy-remove          { &:before { content: \"\\e174\"; } }\n.glyphicon-floppy-save            { &:before { content: \"\\e175\"; } }\n.glyphicon-floppy-open            { &:before { content: \"\\e176\"; } }\n.glyphicon-credit-card            { &:before { content: \"\\e177\"; } }\n.glyphicon-transfer               { &:before { content: \"\\e178\"; } }\n.glyphicon-cutlery                { &:before { content: \"\\e179\"; } }\n.glyphicon-header                 { &:before { content: \"\\e180\"; } }\n.glyphicon-compressed             { &:before { content: \"\\e181\"; } }\n.glyphicon-earphone               { &:before { content: \"\\e182\"; } }\n.glyphicon-phone-alt              { &:before { content: \"\\e183\"; } }\n.glyphicon-tower                  { &:before { content: \"\\e184\"; } }\n.glyphicon-stats                  { &:before { content: \"\\e185\"; } }\n.glyphicon-sd-video               { &:before { content: \"\\e186\"; } }\n.glyphicon-hd-video               { &:before { content: \"\\e187\"; } }\n.glyphicon-subtitles              { &:before { content: \"\\e188\"; } }\n.glyphicon-sound-stereo           { &:before { content: \"\\e189\"; } }\n.glyphicon-sound-dolby            { &:before { content: \"\\e190\"; } }\n.glyphicon-sound-5-1              { &:before { content: \"\\e191\"; } }\n.glyphicon-sound-6-1              { &:before { content: \"\\e192\"; } }\n.glyphicon-sound-7-1              { &:before { content: \"\\e193\"; } }\n.glyphicon-copyright-mark         { &:before { content: \"\\e194\"; } }\n.glyphicon-registration-mark      { &:before { content: \"\\e195\"; } }\n.glyphicon-cloud-download         { &:before { content: \"\\e197\"; } }\n.glyphicon-cloud-upload           { &:before { content: \"\\e198\"; } }\n.glyphicon-tree-conifer           { &:before { content: \"\\e199\"; } }\n.glyphicon-tree-deciduous         { &:before { content: \"\\e200\"; } }\n","grid.less":"//\n// Grid system\n// --------------------------------------------------\n\n\n// Container widths\n//\n// Set the container width, and override it for fixed navbars in media queries.\n\n.container {\n  .container-fixed();\n\n  @media (min-width: @screen-sm-min) {\n    width: @container-sm;\n  }\n  @media (min-width: @screen-md-min) {\n    width: @container-md;\n  }\n  @media (min-width: @screen-lg-min) {\n    width: @container-lg;\n  }\n}\n\n\n// Fluid container\n//\n// Utilizes the mixin meant for fixed width containers, but without any defined\n// width for fluid, full width layouts.\n\n.container-fluid {\n  .container-fixed();\n}\n\n\n// Row\n//\n// Rows contain and clear the floats of your columns.\n\n.row {\n  .make-row();\n}\n\n\n// Columns\n//\n// Common styles for small and large grid columns\n\n.make-grid-columns();\n\n\n// Extra small grid\n//\n// Columns, offsets, pushes, and pulls for extra small devices like\n// smartphones.\n\n.make-grid(xs);\n\n\n// Small grid\n//\n// Columns, offsets, pushes, and pulls for the small device range, from phones\n// to tablets.\n\n@media (min-width: @screen-sm-min) {\n  .make-grid(sm);\n}\n\n\n// Medium grid\n//\n// Columns, offsets, pushes, and pulls for the desktop device range.\n\n@media (min-width: @screen-md-min) {\n  .make-grid(md);\n}\n\n\n// Large grid\n//\n// Columns, offsets, pushes, and pulls for the large desktop device range.\n\n@media (min-width: @screen-lg-min) {\n  .make-grid(lg);\n}\n","input-groups.less":"//\n// Input groups\n// --------------------------------------------------\n\n// Base styles\n// -------------------------\n.input-group {\n  position: relative; // For dropdowns\n  display: table;\n  border-collapse: separate; // prevent input groups from inheriting border styles from table cells when placed within a table\n\n  // Undo padding and float of grid classes\n  &[class*=\"col-\"] {\n    float: none;\n    padding-left: 0;\n    padding-right: 0;\n  }\n\n  .form-control {\n    // Ensure that the input is always above the *appended* addon button for\n    // proper border colors.\n    position: relative;\n    z-index: 2;\n\n    // IE9 fubars the placeholder attribute in text inputs and the arrows on\n    // select elements in input groups. To fix it, we float the input. Details:\n    // https://github.com/twbs/bootstrap/issues/11561#issuecomment-28936855\n    float: left;\n\n    width: 100%;\n    margin-bottom: 0;\n  }\n}\n\n// Sizing options\n//\n// Remix the default form control sizing classes into new ones for easier\n// manipulation.\n\n.input-group-lg > .form-control,\n.input-group-lg > .input-group-addon,\n.input-group-lg > .input-group-btn > .btn { .input-lg(); }\n.input-group-sm > .form-control,\n.input-group-sm > .input-group-addon,\n.input-group-sm > .input-group-btn > .btn { .input-sm(); }\n\n\n// Display as table-cell\n// -------------------------\n.input-group-addon,\n.input-group-btn,\n.input-group .form-control {\n  display: table-cell;\n\n  &:not(:first-child):not(:last-child) {\n    border-radius: 0;\n  }\n}\n// Addon and addon wrapper for buttons\n.input-group-addon,\n.input-group-btn {\n  width: 1%;\n  white-space: nowrap;\n  vertical-align: middle; // Match the inputs\n}\n\n// Text input groups\n// -------------------------\n.input-group-addon {\n  padding: @padding-base-vertical @padding-base-horizontal;\n  font-size: @font-size-base;\n  font-weight: normal;\n  line-height: 1;\n  color: @input-color;\n  text-align: center;\n  background-color: @input-group-addon-bg;\n  border: 1px solid @input-group-addon-border-color;\n  border-radius: @border-radius-base;\n\n  // Sizing\n  &.input-sm {\n    padding: @padding-small-vertical @padding-small-horizontal;\n    font-size: @font-size-small;\n    border-radius: @border-radius-small;\n  }\n  &.input-lg {\n    padding: @padding-large-vertical @padding-large-horizontal;\n    font-size: @font-size-large;\n    border-radius: @border-radius-large;\n  }\n\n  // Nuke default margins from checkboxes and radios to vertically center within.\n  input[type=\"radio\"],\n  input[type=\"checkbox\"] {\n    margin-top: 0;\n  }\n}\n\n// Reset rounded corners\n.input-group .form-control:first-child,\n.input-group-addon:first-child,\n.input-group-btn:first-child > .btn,\n.input-group-btn:first-child > .btn-group > .btn,\n.input-group-btn:first-child > .dropdown-toggle,\n.input-group-btn:last-child > .btn:not(:last-child):not(.dropdown-toggle),\n.input-group-btn:last-child > .btn-group:not(:last-child) > .btn {\n  .border-right-radius(0);\n}\n.input-group-addon:first-child {\n  border-right: 0;\n}\n.input-group .form-control:last-child,\n.input-group-addon:last-child,\n.input-group-btn:last-child > .btn,\n.input-group-btn:last-child > .btn-group > .btn,\n.input-group-btn:last-child > .dropdown-toggle,\n.input-group-btn:first-child > .btn:not(:first-child),\n.input-group-btn:first-child > .btn-group:not(:first-child) > .btn {\n  .border-left-radius(0);\n}\n.input-group-addon:last-child {\n  border-left: 0;\n}\n\n// Button input groups\n// -------------------------\n.input-group-btn {\n  position: relative;\n  // Jankily prevent input button groups from wrapping with `white-space` and\n  // `font-size` in combination with `inline-block` on buttons.\n  font-size: 0;\n  white-space: nowrap;\n\n  // Negative margin for spacing, position for bringing hovered/focused/actived\n  // element above the siblings.\n  > .btn {\n    position: relative;\n    + .btn {\n      margin-left: -1px;\n    }\n    // Bring the \"active\" button to the front\n    &:hover,\n    &:focus,\n    &:active {\n      z-index: 2;\n    }\n  }\n\n  // Negative margin to only have a 1px border between the two\n  &:first-child {\n    > .btn,\n    > .btn-group {\n      margin-right: -1px;\n    }\n  }\n  &:last-child {\n    > .btn,\n    > .btn-group {\n      margin-left: -1px;\n    }\n  }\n}\n","jumbotron.less":"//\n// Jumbotron\n// --------------------------------------------------\n\n\n.jumbotron {\n  padding: @jumbotron-padding;\n  margin-bottom: @jumbotron-padding;\n  color: @jumbotron-color;\n  background-color: @jumbotron-bg;\n\n  h1,\n  .h1 {\n    color: @jumbotron-heading-color;\n  }\n  p {\n    margin-bottom: (@jumbotron-padding / 2);\n    font-size: @jumbotron-font-size;\n    font-weight: 200;\n  }\n\n  .container & {\n    border-radius: @border-radius-large; // Only round corners at higher resolutions if contained in a container\n  }\n\n  .container {\n    max-width: 100%;\n  }\n\n  @media screen and (min-width: @screen-sm-min) {\n    padding-top:    (@jumbotron-padding * 1.6);\n    padding-bottom: (@jumbotron-padding * 1.6);\n\n    .container & {\n      padding-left:  (@jumbotron-padding * 2);\n      padding-right: (@jumbotron-padding * 2);\n    }\n\n    h1,\n    .h1 {\n      font-size: (@font-size-base * 4.5);\n    }\n  }\n}\n","labels.less":"//\n// Labels\n// --------------------------------------------------\n\n.label {\n  display: inline;\n  padding: .2em .6em .3em;\n  font-size: 75%;\n  font-weight: bold;\n  line-height: 1;\n  color: @label-color;\n  text-align: center;\n  white-space: nowrap;\n  vertical-align: baseline;\n  border-radius: .25em;\n\n  // Add hover effects, but only for links\n  &[href] {\n    &:hover,\n    &:focus {\n      color: @label-link-hover-color;\n      text-decoration: none;\n      cursor: pointer;\n    }\n  }\n\n  // Empty labels collapse automatically (not available in IE8)\n  &:empty {\n    display: none;\n  }\n\n  // Quick fix for labels in buttons\n  .btn & {\n    position: relative;\n    top: -1px;\n  }\n}\n\n// Colors\n// Contextual variations (linked labels get darker on :hover)\n\n.label-default {\n  .label-variant(@label-default-bg);\n}\n\n.label-primary {\n  .label-variant(@label-primary-bg);\n}\n\n.label-success {\n  .label-variant(@label-success-bg);\n}\n\n.label-info {\n  .label-variant(@label-info-bg);\n}\n\n.label-warning {\n  .label-variant(@label-warning-bg);\n}\n\n.label-danger {\n  .label-variant(@label-danger-bg);\n}\n","list-group.less":"//\n// List groups\n// --------------------------------------------------\n\n\n// Base class\n//\n// Easily usable on <ul>, <ol>, or <div>.\n\n.list-group {\n  // No need to set list-style: none; since .list-group-item is block level\n  margin-bottom: 20px;\n  padding-left: 0; // reset padding because ul and ol\n}\n\n\n// Individual list items\n//\n// Use on `li`s or `div`s within the `.list-group` parent.\n\n.list-group-item {\n  position: relative;\n  display: block;\n  padding: 10px 15px;\n  // Place the border on the list items and negative margin up for better styling\n  margin-bottom: -1px;\n  background-color: @list-group-bg;\n  border: 1px solid @list-group-border;\n\n  // Round the first and last items\n  &:first-child {\n    .border-top-radius(@list-group-border-radius);\n  }\n  &:last-child {\n    margin-bottom: 0;\n    .border-bottom-radius(@list-group-border-radius);\n  }\n\n  // Align badges within list items\n  > .badge {\n    float: right;\n  }\n  > .badge + .badge {\n    margin-right: 5px;\n  }\n}\n\n\n// Linked list items\n//\n// Use anchor elements instead of `li`s or `div`s to create linked list items.\n// Includes an extra `.active` modifier class for showing selected items.\n\na.list-group-item {\n  color: @list-group-link-color;\n\n  .list-group-item-heading {\n    color: @list-group-link-heading-color;\n  }\n\n  // Hover state\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    background-color: @list-group-hover-bg;\n  }\n\n  // Active class on item itself, not parent\n  &.active,\n  &.active:hover,\n  &.active:focus {\n    z-index: 2; // Place active items above their siblings for proper border styling\n    color: @list-group-active-color;\n    background-color: @list-group-active-bg;\n    border-color: @list-group-active-border;\n\n    // Force color to inherit for custom content\n    .list-group-item-heading {\n      color: inherit;\n    }\n    .list-group-item-text {\n      color: @list-group-active-text-color;\n    }\n  }\n}\n\n\n// Contextual variants\n//\n// Add modifier classes to change text and background color on individual items.\n// Organizationally, this must come after the `:hover` states.\n\n.list-group-item-variant(success; @state-success-bg; @state-success-text);\n.list-group-item-variant(info; @state-info-bg; @state-info-text);\n.list-group-item-variant(warning; @state-warning-bg; @state-warning-text);\n.list-group-item-variant(danger; @state-danger-bg; @state-danger-text);\n\n\n// Custom content options\n//\n// Extra classes for creating well-formatted content within `.list-group-item`s.\n\n.list-group-item-heading {\n  margin-top: 0;\n  margin-bottom: 5px;\n}\n.list-group-item-text {\n  margin-bottom: 0;\n  line-height: 1.3;\n}\n","media.less":"// Media objects\n// Source: http://stubbornella.org/content/?p=497\n// --------------------------------------------------\n\n\n// Common styles\n// -------------------------\n\n// Clear the floats\n.media,\n.media-body {\n  overflow: hidden;\n  zoom: 1;\n}\n\n// Proper spacing between instances of .media\n.media,\n.media .media {\n  margin-top: 15px;\n}\n.media:first-child {\n  margin-top: 0;\n}\n\n// For images and videos, set to block\n.media-object {\n  display: block;\n}\n\n// Reset margins on headings for tighter default spacing\n.media-heading {\n  margin: 0 0 5px;\n}\n\n\n// Media image alignment\n// -------------------------\n\n.media {\n  > .pull-left {\n    margin-right: 10px;\n  }\n  > .pull-right {\n    margin-left: 10px;\n  }\n}\n\n\n// Media list variation\n// -------------------------\n\n// Undo default ul/ol styles\n.media-list {\n  padding-left: 0;\n  list-style: none;\n}\n","mixins.less":"//\n// Mixins\n// --------------------------------------------------\n\n\n// Utilities\n// -------------------------\n\n// Clearfix\n// Source: http://nicolasgallagher.com/micro-clearfix-hack/\n//\n// For modern browsers\n// 1. The space content is one way to avoid an Opera bug when the\n//    contenteditable attribute is included anywhere else in the document.\n//    Otherwise it causes space to appear at the top and bottom of elements\n//    that are clearfixed.\n// 2. The use of `table` rather than `block` is only necessary if using\n//    `:before` to contain the top-margins of child elements.\n.clearfix() {\n  &:before,\n  &:after {\n    content: \" \"; // 1\n    display: table; // 2\n  }\n  &:after {\n    clear: both;\n  }\n}\n\n// WebKit-style focus\n.tab-focus() {\n  // Default\n  outline: thin dotted;\n  // WebKit\n  outline: 5px auto -webkit-focus-ring-color;\n  outline-offset: -2px;\n}\n\n// Center-align a block level element\n.center-block() {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n\n// Sizing shortcuts\n.size(@width; @height) {\n  width: @width;\n  height: @height;\n}\n.square(@size) {\n  .size(@size; @size);\n}\n\n// Placeholder text\n.placeholder(@color: @input-color-placeholder) {\n  &::-moz-placeholder           { color: @color;   // Firefox\n                                  opacity: 1; } // See https://github.com/twbs/bootstrap/pull/11526\n  &:-ms-input-placeholder       { color: @color; } // Internet Explorer 10+\n  &::-webkit-input-placeholder  { color: @color; } // Safari and Chrome\n}\n\n// Text overflow\n// Requires inline-block or block for proper styling\n.text-overflow() {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n// CSS image replacement\n//\n// Heads up! v3 launched with with only `.hide-text()`, but per our pattern for\n// mixins being reused as classes with the same name, this doesn't hold up. As\n// of v3.0.1 we have added `.text-hide()` and deprecated `.hide-text()`. Note\n// that we cannot chain the mixins together in Less, so they are repeated.\n//\n// Source: https://github.com/h5bp/html5-boilerplate/commit/aa0396eae757\n\n// Deprecated as of v3.0.1 (will be removed in v4)\n.hide-text() {\n  font: ~\"0/0\" a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0;\n}\n// New mixin to use as of v3.0.1\n.text-hide() {\n  .hide-text();\n}\n\n\n\n// CSS3 PROPERTIES\n// --------------------------------------------------\n\n// Single side border-radius\n.border-top-radius(@radius) {\n  border-top-right-radius: @radius;\n   border-top-left-radius: @radius;\n}\n.border-right-radius(@radius) {\n  border-bottom-right-radius: @radius;\n     border-top-right-radius: @radius;\n}\n.border-bottom-radius(@radius) {\n  border-bottom-right-radius: @radius;\n   border-bottom-left-radius: @radius;\n}\n.border-left-radius(@radius) {\n  border-bottom-left-radius: @radius;\n     border-top-left-radius: @radius;\n}\n\n// Drop shadows\n//\n// Note: Deprecated `.box-shadow()` as of v3.1.0 since all of Bootstrap's\n//   supported browsers that have box shadow capabilities now support the\n//   standard `box-shadow` property.\n.box-shadow(@shadow) {\n  -webkit-box-shadow: @shadow; // iOS <4.3 & Android <4.1\n          box-shadow: @shadow;\n}\n\n// Transitions\n.transition(@transition) {\n  -webkit-transition: @transition;\n          transition: @transition;\n}\n.transition-property(@transition-property) {\n  -webkit-transition-property: @transition-property;\n          transition-property: @transition-property;\n}\n.transition-delay(@transition-delay) {\n  -webkit-transition-delay: @transition-delay;\n          transition-delay: @transition-delay;\n}\n.transition-duration(@transition-duration) {\n  -webkit-transition-duration: @transition-duration;\n          transition-duration: @transition-duration;\n}\n.transition-transform(@transition) {\n  -webkit-transition: -webkit-transform @transition;\n     -moz-transition: -moz-transform @transition;\n       -o-transition: -o-transform @transition;\n          transition: transform @transition;\n}\n\n// Transformations\n.scale(@ratio) {\n  -webkit-transform: scale(@ratio);\n      -ms-transform: scale(@ratio); // IE9 only\n          transform: scale(@ratio);\n}\n.scale(@ratioX; @ratioY) {\n  -webkit-transform: scale(@ratioX, @ratioY);\n      -ms-transform: scale(@ratioX, @ratioY); // IE9 only\n          transform: scale(@ratioX, @ratioY);\n}\n.scaleX(@ratio) {\n  -webkit-transform: scaleX(@ratio);\n      -ms-transform: scaleX(@ratio); // IE9 only\n          transform: scaleX(@ratio);\n}\n.scaleY(@ratio) {\n  -webkit-transform: scaleY(@ratio);\n      -ms-transform: scaleY(@ratio); // IE9 only\n          transform: scaleY(@ratio);\n}\n.skew(@x; @y) {\n  -webkit-transform: skew(@x, @y);\n      -ms-transform: skewX(@x) skewY(@y); // See https://github.com/twbs/bootstrap/issues/4885; IE9+\n          transform: skew(@x, @y);\n}\n.translate(@x; @y) {\n  -webkit-transform: translate(@x, @y);\n      -ms-transform: translate(@x, @y); // IE9 only\n          transform: translate(@x, @y);\n}\n.translate3d(@x; @y; @z) {\n  -webkit-transform: translate3d(@x, @y, @z);\n          transform: translate3d(@x, @y, @z);\n}\n.rotate(@degrees) {\n  -webkit-transform: rotate(@degrees);\n      -ms-transform: rotate(@degrees); // IE9 only\n          transform: rotate(@degrees);\n}\n.rotateX(@degrees) {\n  -webkit-transform: rotateX(@degrees);\n      -ms-transform: rotateX(@degrees); // IE9 only\n          transform: rotateX(@degrees);\n}\n.rotateY(@degrees) {\n  -webkit-transform: rotateY(@degrees);\n      -ms-transform: rotateY(@degrees); // IE9 only\n          transform: rotateY(@degrees);\n}\n.perspective(@perspective) {\n  -webkit-perspective: @perspective;\n     -moz-perspective: @perspective;\n          perspective: @perspective;\n}\n.perspective-origin(@perspective) {\n  -webkit-perspective-origin: @perspective;\n     -moz-perspective-origin: @perspective;\n          perspective-origin: @perspective;\n}\n.transform-origin(@origin) {\n  -webkit-transform-origin: @origin;\n     -moz-transform-origin: @origin;\n      -ms-transform-origin: @origin; // IE9 only\n          transform-origin: @origin;\n}\n\n// Animations\n.animation(@animation) {\n  -webkit-animation: @animation;\n          animation: @animation;\n}\n.animation-name(@name) {\n  -webkit-animation-name: @name;\n          animation-name: @name;\n}\n.animation-duration(@duration) {\n  -webkit-animation-duration: @duration;\n          animation-duration: @duration;\n}\n.animation-timing-function(@timing-function) {\n  -webkit-animation-timing-function: @timing-function;\n          animation-timing-function: @timing-function;\n}\n.animation-delay(@delay) {\n  -webkit-animation-delay: @delay;\n          animation-delay: @delay;\n}\n.animation-iteration-count(@iteration-count) {\n  -webkit-animation-iteration-count: @iteration-count;\n          animation-iteration-count: @iteration-count;\n}\n.animation-direction(@direction) {\n  -webkit-animation-direction: @direction;\n          animation-direction: @direction;\n}\n\n// Backface visibility\n// Prevent browsers from flickering when using CSS 3D transforms.\n// Default value is `visible`, but can be changed to `hidden`\n.backface-visibility(@visibility){\n  -webkit-backface-visibility: @visibility;\n     -moz-backface-visibility: @visibility;\n          backface-visibility: @visibility;\n}\n\n// Box sizing\n.box-sizing(@boxmodel) {\n  -webkit-box-sizing: @boxmodel;\n     -moz-box-sizing: @boxmodel;\n          box-sizing: @boxmodel;\n}\n\n// User select\n// For selecting text on the page\n.user-select(@select) {\n  -webkit-user-select: @select;\n     -moz-user-select: @select;\n      -ms-user-select: @select; // IE10+\n          user-select: @select;\n}\n\n// Resize anything\n.resizable(@direction) {\n  resize: @direction; // Options: horizontal, vertical, both\n  overflow: auto; // Safari fix\n}\n\n// CSS3 Content Columns\n.content-columns(@column-count; @column-gap: @grid-gutter-width) {\n  -webkit-column-count: @column-count;\n     -moz-column-count: @column-count;\n          column-count: @column-count;\n  -webkit-column-gap: @column-gap;\n     -moz-column-gap: @column-gap;\n          column-gap: @column-gap;\n}\n\n// Optional hyphenation\n.hyphens(@mode: auto) {\n  word-wrap: break-word;\n  -webkit-hyphens: @mode;\n     -moz-hyphens: @mode;\n      -ms-hyphens: @mode; // IE10+\n       -o-hyphens: @mode;\n          hyphens: @mode;\n}\n\n// Opacity\n.opacity(@opacity) {\n  opacity: @opacity;\n  // IE8 filter\n  @opacity-ie: (@opacity * 100);\n  filter: ~\"alpha(opacity=@{opacity-ie})\";\n}\n\n\n\n// GRADIENTS\n// --------------------------------------------------\n\n#gradient {\n\n  // Horizontal gradient, from left to right\n  //\n  // Creates two color stops, start and end, by specifying a color and position for each color stop.\n  // Color stops are not available in IE9 and below.\n  .horizontal(@start-color: #555; @end-color: #333; @start-percent: 0%; @end-percent: 100%) {\n    background-image: -webkit-linear-gradient(left, color-stop(@start-color @start-percent), color-stop(@end-color @end-percent)); // Safari 5.1-6, Chrome 10+\n    background-image:  linear-gradient(to right, @start-color @start-percent, @end-color @end-percent); // Standard, IE10, Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+\n    background-repeat: repeat-x;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=1)\",argb(@start-color),argb(@end-color))); // IE9 and down\n  }\n\n  // Vertical gradient, from top to bottom\n  //\n  // Creates two color stops, start and end, by specifying a color and position for each color stop.\n  // Color stops are not available in IE9 and below.\n  .vertical(@start-color: #555; @end-color: #333; @start-percent: 0%; @end-percent: 100%) {\n    background-image: -webkit-linear-gradient(top, @start-color @start-percent, @end-color @end-percent);  // Safari 5.1-6, Chrome 10+\n    background-image: linear-gradient(to bottom, @start-color @start-percent, @end-color @end-percent); // Standard, IE10, Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+\n    background-repeat: repeat-x;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=0)\",argb(@start-color),argb(@end-color))); // IE9 and down\n  }\n\n  .directional(@start-color: #555; @end-color: #333; @deg: 45deg) {\n    background-repeat: repeat-x;\n    background-image: -webkit-linear-gradient(@deg, @start-color, @end-color); // Safari 5.1-6, Chrome 10+\n    background-image: linear-gradient(@deg, @start-color, @end-color); // Standard, IE10, Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+\n  }\n  .horizontal-three-colors(@start-color: #00b3ee; @mid-color: #7a43b6; @color-stop: 50%; @end-color: #c3325f) {\n    background-image: -webkit-linear-gradient(left, @start-color, @mid-color @color-stop, @end-color);\n    background-image: linear-gradient(to right, @start-color, @mid-color @color-stop, @end-color);\n    background-repeat: no-repeat;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=1)\",argb(@start-color),argb(@end-color))); // IE9 and down, gets no color-stop at all for proper fallback\n  }\n  .vertical-three-colors(@start-color: #00b3ee; @mid-color: #7a43b6; @color-stop: 50%; @end-color: #c3325f) {\n    background-image: -webkit-linear-gradient(@start-color, @mid-color @color-stop, @end-color);\n    background-image: linear-gradient(@start-color, @mid-color @color-stop, @end-color);\n    background-repeat: no-repeat;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=0)\",argb(@start-color),argb(@end-color))); // IE9 and down, gets no color-stop at all for proper fallback\n  }\n  .radial(@inner-color: #555; @outer-color: #333) {\n    background-image: -webkit-radial-gradient(circle, @inner-color, @outer-color);\n    background-image: radial-gradient(circle, @inner-color, @outer-color);\n    background-repeat: no-repeat;\n  }\n  .striped(@color: rgba(255,255,255,.15); @angle: 45deg) {\n    background-image: -webkit-linear-gradient(@angle, @color 25%, transparent 25%, transparent 50%, @color 50%, @color 75%, transparent 75%, transparent);\n    background-image: linear-gradient(@angle, @color 25%, transparent 25%, transparent 50%, @color 50%, @color 75%, transparent 75%, transparent);\n  }\n}\n\n// Reset filters for IE\n//\n// When you need to remove a gradient background, do not forget to use this to reset\n// the IE filter for IE9 and below.\n.reset-filter() {\n  filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(enabled = false)\"));\n}\n\n\n\n// Retina images\n//\n// Short retina mixin for setting background-image and -size\n\n.img-retina(@file-1x; @file-2x; @width-1x; @height-1x) {\n  background-image: url(\"@{file-1x}\");\n\n  @media\n  only screen and (-webkit-min-device-pixel-ratio: 2),\n  only screen and (   min--moz-device-pixel-ratio: 2),\n  only screen and (     -o-min-device-pixel-ratio: 2/1),\n  only screen and (        min-device-pixel-ratio: 2),\n  only screen and (                min-resolution: 192dpi),\n  only screen and (                min-resolution: 2dppx) {\n    background-image: url(\"@{file-2x}\");\n    background-size: @width-1x @height-1x;\n  }\n}\n\n\n// Responsive image\n//\n// Keep images from scaling beyond the width of their parents.\n\n.img-responsive(@display: block) {\n  display: @display;\n  max-width: 100%; // Part 1: Set a maximum relative to the parent\n  height: auto; // Part 2: Scale the height according to the width, otherwise you get stretching\n}\n\n\n// COMPONENT MIXINS\n// --------------------------------------------------\n\n// Horizontal dividers\n// -------------------------\n// Dividers (basically an hr) within dropdowns and nav lists\n.nav-divider(@color: #e5e5e5) {\n  height: 1px;\n  margin: ((@line-height-computed / 2) - 1) 0;\n  overflow: hidden;\n  background-color: @color;\n}\n\n// Panels\n// -------------------------\n.panel-variant(@border; @heading-text-color; @heading-bg-color; @heading-border) {\n  border-color: @border;\n\n  & > .panel-heading {\n    color: @heading-text-color;\n    background-color: @heading-bg-color;\n    border-color: @heading-border;\n\n    + .panel-collapse .panel-body {\n      border-top-color: @border;\n    }\n  }\n  & > .panel-footer {\n    + .panel-collapse .panel-body {\n      border-bottom-color: @border;\n    }\n  }\n}\n\n// Alerts\n// -------------------------\n.alert-variant(@background; @border; @text-color) {\n  background-color: @background;\n  border-color: @border;\n  color: @text-color;\n\n  hr {\n    border-top-color: darken(@border, 5%);\n  }\n  .alert-link {\n    color: darken(@text-color, 10%);\n  }\n}\n\n// Tables\n// -------------------------\n.table-row-variant(@state; @background) {\n  // Exact selectors below required to override `.table-striped` and prevent\n  // inheritance to nested tables.\n  .table > thead > tr,\n  .table > tbody > tr,\n  .table > tfoot > tr {\n    > td.@{state},\n    > th.@{state},\n    &.@{state} > td,\n    &.@{state} > th {\n      background-color: @background;\n    }\n  }\n\n  // Hover states for `.table-hover`\n  // Note: this is not available for cells or rows within `thead` or `tfoot`.\n  .table-hover > tbody > tr {\n    > td.@{state}:hover,\n    > th.@{state}:hover,\n    &.@{state}:hover > td,\n    &.@{state}:hover > th {\n      background-color: darken(@background, 5%);\n    }\n  }\n}\n\n// List Groups\n// -------------------------\n.list-group-item-variant(@state; @background; @color) {\n  .list-group-item-@{state} {\n    color: @color;\n    background-color: @background;\n\n    a& {\n      color: @color;\n\n      .list-group-item-heading { color: inherit; }\n\n      &:hover,\n      &:focus {\n        color: @color;\n        background-color: darken(@background, 5%);\n      }\n      &.active,\n      &.active:hover,\n      &.active:focus {\n        color: #fff;\n        background-color: @color;\n        border-color: @color;\n      }\n    }\n  }\n}\n\n// Button variants\n// -------------------------\n// Easily pump out default styles, as well as :hover, :focus, :active,\n// and disabled options for all buttons\n.button-variant(@color; @background; @border) {\n  color: @color;\n  background-color: @background;\n  border-color: @border;\n\n  &:hover,\n  &:focus,\n  &:active,\n  &.active,\n  .open .dropdown-toggle& {\n    color: @color;\n    background-color: darken(@background, 8%);\n        border-color: darken(@border, 12%);\n  }\n  &:active,\n  &.active,\n  .open .dropdown-toggle& {\n    background-image: none;\n  }\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    &,\n    &:hover,\n    &:focus,\n    &:active,\n    &.active {\n      background-color: @background;\n          border-color: @border;\n    }\n  }\n\n  .badge {\n    color: @background;\n    background-color: @color;\n  }\n}\n\n// Button sizes\n// -------------------------\n.button-size(@padding-vertical; @padding-horizontal; @font-size; @line-height; @border-radius) {\n  padding: @padding-vertical @padding-horizontal;\n  font-size: @font-size;\n  line-height: @line-height;\n  border-radius: @border-radius;\n}\n\n// Pagination\n// -------------------------\n.pagination-size(@padding-vertical; @padding-horizontal; @font-size; @border-radius) {\n  > li {\n    > a,\n    > span {\n      padding: @padding-vertical @padding-horizontal;\n      font-size: @font-size;\n    }\n    &:first-child {\n      > a,\n      > span {\n        .border-left-radius(@border-radius);\n      }\n    }\n    &:last-child {\n      > a,\n      > span {\n        .border-right-radius(@border-radius);\n      }\n    }\n  }\n}\n\n// Labels\n// -------------------------\n.label-variant(@color) {\n  background-color: @color;\n  &[href] {\n    &:hover,\n    &:focus {\n      background-color: darken(@color, 10%);\n    }\n  }\n}\n\n// Contextual backgrounds\n// -------------------------\n.bg-variant(@color) {\n  background-color: @color;\n  a&:hover {\n    background-color: darken(@color, 10%);\n  }\n}\n\n// Typography\n// -------------------------\n.text-emphasis-variant(@color) {\n  color: @color;\n  a&:hover {\n    color: darken(@color, 10%);\n  }\n}\n\n// Navbar vertical align\n// -------------------------\n// Vertically center elements in the navbar.\n// Example: an element has a height of 30px, so write out `.navbar-vertical-align(30px);` to calculate the appropriate top margin.\n.navbar-vertical-align(@element-height) {\n  margin-top: ((@navbar-height - @element-height) / 2);\n  margin-bottom: ((@navbar-height - @element-height) / 2);\n}\n\n// Progress bars\n// -------------------------\n.progress-bar-variant(@color) {\n  background-color: @color;\n  .progress-striped & {\n    #gradient > .striped();\n  }\n}\n\n// Responsive utilities\n// -------------------------\n// More easily include all the states for responsive-utilities.less.\n.responsive-visibility() {\n  display: block !important;\n  table&  { display: table; }\n  tr&     { display: table-row !important; }\n  th&,\n  td&     { display: table-cell !important; }\n}\n\n.responsive-invisibility() {\n  display: none !important;\n}\n\n\n// Grid System\n// -----------\n\n// Centered container element\n.container-fixed() {\n  margin-right: auto;\n  margin-left: auto;\n  padding-left:  (@grid-gutter-width / 2);\n  padding-right: (@grid-gutter-width / 2);\n  &:extend(.clearfix all);\n}\n\n// Creates a wrapper for a series of columns\n.make-row(@gutter: @grid-gutter-width) {\n  margin-left:  (@gutter / -2);\n  margin-right: (@gutter / -2);\n  &:extend(.clearfix all);\n}\n\n// Generate the extra small columns\n.make-xs-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  float: left;\n  width: percentage((@columns / @grid-columns));\n  min-height: 1px;\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n}\n.make-xs-column-offset(@columns) {\n  @media (min-width: @screen-xs-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-xs-column-push(@columns) {\n  @media (min-width: @screen-xs-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-xs-column-pull(@columns) {\n  @media (min-width: @screen-xs-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n\n// Generate the small columns\n.make-sm-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  min-height: 1px;\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  @media (min-width: @screen-sm-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n.make-sm-column-offset(@columns) {\n  @media (min-width: @screen-sm-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-sm-column-push(@columns) {\n  @media (min-width: @screen-sm-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-sm-column-pull(@columns) {\n  @media (min-width: @screen-sm-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n\n// Generate the medium columns\n.make-md-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  min-height: 1px;\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  @media (min-width: @screen-md-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n.make-md-column-offset(@columns) {\n  @media (min-width: @screen-md-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-md-column-push(@columns) {\n  @media (min-width: @screen-md-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-md-column-pull(@columns) {\n  @media (min-width: @screen-md-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n\n// Generate the large columns\n.make-lg-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  min-height: 1px;\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  @media (min-width: @screen-lg-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n.make-lg-column-offset(@columns) {\n  @media (min-width: @screen-lg-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-lg-column-push(@columns) {\n  @media (min-width: @screen-lg-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-lg-column-pull(@columns) {\n  @media (min-width: @screen-lg-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n\n// Framework grid generation\n//\n// Used only by Bootstrap to generate the correct number of grid classes given\n// any value of `@grid-columns`.\n\n.make-grid-columns() {\n  // Common styles for all sizes of grid columns, widths 1-12\n  .col(@index) when (@index = 1) { // initial\n    @item: ~\".col-xs-@{index}, .col-sm-@{index}, .col-md-@{index}, .col-lg-@{index}\";\n    .col((@index + 1), @item);\n  }\n  .col(@index, @list) when (@index =< @grid-columns) { // general; \"=<\" isn't a typo\n    @item: ~\".col-xs-@{index}, .col-sm-@{index}, .col-md-@{index}, .col-lg-@{index}\";\n    .col((@index + 1), ~\"@{list}, @{item}\");\n  }\n  .col(@index, @list) when (@index > @grid-columns) { // terminal\n    @{list} {\n      position: relative;\n      // Prevent columns from collapsing when empty\n      min-height: 1px;\n      // Inner gutter via padding\n      padding-left:  (@grid-gutter-width / 2);\n      padding-right: (@grid-gutter-width / 2);\n    }\n  }\n  .col(1); // kickstart it\n}\n\n.float-grid-columns(@class) {\n  .col(@index) when (@index = 1) { // initial\n    @item: ~\".col-@{class}-@{index}\";\n    .col((@index + 1), @item);\n  }\n  .col(@index, @list) when (@index =< @grid-columns) { // general\n    @item: ~\".col-@{class}-@{index}\";\n    .col((@index + 1), ~\"@{list}, @{item}\");\n  }\n  .col(@index, @list) when (@index > @grid-columns) { // terminal\n    @{list} {\n      float: left;\n    }\n  }\n  .col(1); // kickstart it\n}\n\n.calc-grid-column(@index, @class, @type) when (@type = width) and (@index > 0) {\n  .col-@{class}-@{index} {\n    width: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid-column(@index, @class, @type) when (@type = push) {\n  .col-@{class}-push-@{index} {\n    left: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid-column(@index, @class, @type) when (@type = pull) {\n  .col-@{class}-pull-@{index} {\n    right: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid-column(@index, @class, @type) when (@type = offset) {\n  .col-@{class}-offset-@{index} {\n    margin-left: percentage((@index / @grid-columns));\n  }\n}\n\n// Basic looping in LESS\n.loop-grid-columns(@index, @class, @type) when (@index >= 0) {\n  .calc-grid-column(@index, @class, @type);\n  // next iteration\n  .loop-grid-columns((@index - 1), @class, @type);\n}\n\n// Create grid for specific class\n.make-grid(@class) {\n  .float-grid-columns(@class);\n  .loop-grid-columns(@grid-columns, @class, width);\n  .loop-grid-columns(@grid-columns, @class, pull);\n  .loop-grid-columns(@grid-columns, @class, push);\n  .loop-grid-columns(@grid-columns, @class, offset);\n}\n\n// Form validation states\n//\n// Used in forms.less to generate the form validation CSS for warnings, errors,\n// and successes.\n\n.form-control-validation(@text-color: #555; @border-color: #ccc; @background-color: #f5f5f5) {\n  // Color the label and help text\n  .help-block,\n  .control-label,\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline  {\n    color: @text-color;\n  }\n  // Set the border and box shadow on specific inputs to match\n  .form-control {\n    border-color: @border-color;\n    .box-shadow(inset 0 1px 1px rgba(0,0,0,.075)); // Redeclare so transitions work\n    &:focus {\n      border-color: darken(@border-color, 10%);\n      @shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 6px lighten(@border-color, 20%);\n      .box-shadow(@shadow);\n    }\n  }\n  // Set validation states also for addons\n  .input-group-addon {\n    color: @text-color;\n    border-color: @border-color;\n    background-color: @background-color;\n  }\n  // Optional feedback icon\n  .form-control-feedback {\n    color: @text-color;\n  }\n}\n\n// Form control focus state\n//\n// Generate a customized focus state and for any input with the specified color,\n// which defaults to the `@input-focus-border` variable.\n//\n// We highly encourage you to not customize the default value, but instead use\n// this to tweak colors on an as-needed basis. This aesthetic change is based on\n// WebKit's default styles, but applicable to a wider range of browsers. Its\n// usability and accessibility should be taken into account with any change.\n//\n// Example usage: change the default blue border and shadow to white for better\n// contrast against a dark gray background.\n\n.form-control-focus(@color: @input-border-focus) {\n  @color-rgba: rgba(red(@color), green(@color), blue(@color), .6);\n  &:focus {\n    border-color: @color;\n    outline: 0;\n    .box-shadow(~\"inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px @{color-rgba}\");\n  }\n}\n\n// Form control sizing\n//\n// Relative text size, padding, and border-radii changes for form controls. For\n// horizontal sizing, wrap controls in the predefined grid classes. `<select>`\n// element gets special love because it's special, and that's a fact!\n\n.input-size(@input-height; @padding-vertical; @padding-horizontal; @font-size; @line-height; @border-radius) {\n  height: @input-height;\n  padding: @padding-vertical @padding-horizontal;\n  font-size: @font-size;\n  line-height: @line-height;\n  border-radius: @border-radius;\n\n  select& {\n    height: @input-height;\n    line-height: @input-height;\n  }\n\n  textarea&,\n  select[multiple]& {\n    height: auto;\n  }\n}\n","modals.less":"//\n// Modals\n// --------------------------------------------------\n\n// .modal-open      - body class for killing the scroll\n// .modal           - container to scroll within\n// .modal-dialog    - positioning shell for the actual modal\n// .modal-content   - actual modal w/ bg and corners and shit\n\n// Kill the scroll on the body\n.modal-open {\n  overflow: hidden;\n}\n\n// Container that the modal scrolls within\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: @zindex-modal;\n  -webkit-overflow-scrolling: touch;\n\n  // Prevent Chrome on Windows from adding a focus outline. For details, see\n  // https://github.com/twbs/bootstrap/pull/10951.\n  outline: 0;\n\n  // When fading in the modal, animate it to slide down\n  &.fade .modal-dialog {\n    .translate(0, -25%);\n    .transition-transform(~\"0.3s ease-out\");\n  }\n  &.in .modal-dialog { .translate(0, 0)}\n}\n\n// Shell div to position the modal with bottom padding\n.modal-dialog {\n  position: relative;\n  width: auto;\n  margin: 10px;\n}\n\n// Actual modal\n.modal-content {\n  position: relative;\n  background-color: @modal-content-bg;\n  border: 1px solid @modal-content-fallback-border-color; //old browsers fallback (ie8 etc)\n  border: 1px solid @modal-content-border-color;\n  border-radius: @border-radius-large;\n  .box-shadow(0 3px 9px rgba(0,0,0,.5));\n  background-clip: padding-box;\n  // Remove focus outline from opened modal\n  outline: none;\n}\n\n// Modal background\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: @zindex-modal-background;\n  background-color: @modal-backdrop-bg;\n  // Fade for backdrop\n  &.fade { .opacity(0); }\n  &.in { .opacity(@modal-backdrop-opacity); }\n}\n\n// Modal header\n// Top section of the modal w/ title and dismiss\n.modal-header {\n  padding: @modal-title-padding;\n  border-bottom: 1px solid @modal-header-border-color;\n  min-height: (@modal-title-padding + @modal-title-line-height);\n}\n// Close icon\n.modal-header .close {\n  margin-top: -2px;\n}\n\n// Title text within header\n.modal-title {\n  margin: 0;\n  line-height: @modal-title-line-height;\n}\n\n// Modal body\n// Where all modal content resides (sibling of .modal-header and .modal-footer)\n.modal-body {\n  position: relative;\n  padding: @modal-inner-padding;\n}\n\n// Footer (for actions)\n.modal-footer {\n  padding: (@modal-inner-padding - 1) @modal-inner-padding @modal-inner-padding;\n  text-align: right; // right align buttons\n  border-top: 1px solid @modal-footer-border-color;\n  &:extend(.clearfix all); // clear it in case folks use .pull-* classes on buttons\n\n  // Properly space out buttons\n  .btn + .btn {\n    margin-left: 5px;\n    margin-bottom: 0; // account for input[type=\"submit\"] which gets the bottom margin like all other inputs\n  }\n  // but override that for button groups\n  .btn-group .btn + .btn {\n    margin-left: -1px;\n  }\n  // and override it for block buttons as well\n  .btn-block + .btn-block {\n    margin-left: 0;\n  }\n}\n\n// Scale up the modal\n@media (min-width: @screen-sm-min) {\n  // Automatically set modal's width for larger viewports\n  .modal-dialog {\n    width: @modal-md;\n    margin: 30px auto;\n  }\n  .modal-content {\n    .box-shadow(0 5px 15px rgba(0,0,0,.5));\n  }\n\n  // Modal sizes\n  .modal-sm { width: @modal-sm; }\n}\n\n@media (min-width: @screen-md-min) {\n  .modal-lg { width: @modal-lg; }\n}\n","navbar.less":"//\n// Navbars\n// --------------------------------------------------\n\n\n// Wrapper and base class\n//\n// Provide a static navbar from which we expand to create full-width, fixed, and\n// other navbar variations.\n\n.navbar {\n  position: relative;\n  min-height: @navbar-height; // Ensure a navbar always shows (e.g., without a .navbar-brand in collapsed mode)\n  margin-bottom: @navbar-margin-bottom;\n  border: 1px solid transparent;\n\n  // Prevent floats from breaking the navbar\n  &:extend(.clearfix all);\n\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: @navbar-border-radius;\n  }\n}\n\n\n// Navbar heading\n//\n// Groups `.navbar-brand` and `.navbar-toggle` into a single component for easy\n// styling of responsive aspects.\n\n.navbar-header {\n  &:extend(.clearfix all);\n\n  @media (min-width: @grid-float-breakpoint) {\n    float: left;\n  }\n}\n\n\n// Navbar collapse (body)\n//\n// Group your navbar content into this for easy collapsing and expanding across\n// various device sizes. By default, this content is collapsed when <768px, but\n// will expand past that for a horizontal display.\n//\n// To start (on mobile devices) the navbar links, forms, and buttons are stacked\n// vertically and include a `max-height` to overflow in case you have too much\n// content for the user's viewport.\n\n.navbar-collapse {\n  max-height: @navbar-collapse-max-height;\n  overflow-x: visible;\n  padding-right: @navbar-padding-horizontal;\n  padding-left:  @navbar-padding-horizontal;\n  border-top: 1px solid transparent;\n  box-shadow: inset 0 1px 0 rgba(255,255,255,.1);\n  &:extend(.clearfix all);\n  -webkit-overflow-scrolling: touch;\n\n  &.in {\n    overflow-y: auto;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    width: auto;\n    border-top: 0;\n    box-shadow: none;\n\n    &.collapse {\n      display: block !important;\n      height: auto !important;\n      padding-bottom: 0; // Override default setting\n      overflow: visible !important;\n    }\n\n    &.in {\n      overflow-y: visible;\n    }\n\n    // Undo the collapse side padding for navbars with containers to ensure\n    // alignment of right-aligned contents.\n    .navbar-fixed-top &,\n    .navbar-static-top &,\n    .navbar-fixed-bottom & {\n      padding-left: 0;\n      padding-right: 0;\n    }\n  }\n}\n\n\n// Both navbar header and collapse\n//\n// When a container is present, change the behavior of the header and collapse.\n\n.container,\n.container-fluid {\n  > .navbar-header,\n  > .navbar-collapse {\n    margin-right: -@navbar-padding-horizontal;\n    margin-left:  -@navbar-padding-horizontal;\n\n    @media (min-width: @grid-float-breakpoint) {\n      margin-right: 0;\n      margin-left:  0;\n    }\n  }\n}\n\n\n//\n// Navbar alignment options\n//\n// Display the navbar across the entirety of the page or fixed it to the top or\n// bottom of the page.\n\n// Static top (unfixed, but 100% wide) navbar\n.navbar-static-top {\n  z-index: @zindex-navbar;\n  border-width: 0 0 1px;\n\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: 0;\n  }\n}\n\n// Fix the top/bottom navbars when screen real estate supports it\n.navbar-fixed-top,\n.navbar-fixed-bottom {\n  position: fixed;\n  right: 0;\n  left: 0;\n  z-index: @zindex-navbar-fixed;\n\n  // Undo the rounded corners\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: 0;\n  }\n}\n.navbar-fixed-top {\n  top: 0;\n  border-width: 0 0 1px;\n}\n.navbar-fixed-bottom {\n  bottom: 0;\n  margin-bottom: 0; // override .navbar defaults\n  border-width: 1px 0 0;\n}\n\n\n// Brand/project name\n\n.navbar-brand {\n  float: left;\n  padding: @navbar-padding-vertical @navbar-padding-horizontal;\n  font-size: @font-size-large;\n  line-height: @line-height-computed;\n  height: @navbar-height;\n\n  &:hover,\n  &:focus {\n    text-decoration: none;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    .navbar > .container &,\n    .navbar > .container-fluid & {\n      margin-left: -@navbar-padding-horizontal;\n    }\n  }\n}\n\n\n// Navbar toggle\n//\n// Custom button for toggling the `.navbar-collapse`, powered by the collapse\n// JavaScript plugin.\n\n.navbar-toggle {\n  position: relative;\n  float: right;\n  margin-right: @navbar-padding-horizontal;\n  padding: 9px 10px;\n  .navbar-vertical-align(34px);\n  background-color: transparent;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid transparent;\n  border-radius: @border-radius-base;\n\n  // We remove the `outline` here, but later compensate by attaching `:hover`\n  // styles to `:focus`.\n  &:focus {\n    outline: none;\n  }\n\n  // Bars\n  .icon-bar {\n    display: block;\n    width: 22px;\n    height: 2px;\n    border-radius: 1px;\n  }\n  .icon-bar + .icon-bar {\n    margin-top: 4px;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    display: none;\n  }\n}\n\n\n// Navbar nav links\n//\n// Builds on top of the `.nav` components with its own modifier class to make\n// the nav the full height of the horizontal nav (above 768px).\n\n.navbar-nav {\n  margin: (@navbar-padding-vertical / 2) -@navbar-padding-horizontal;\n\n  > li > a {\n    padding-top:    10px;\n    padding-bottom: 10px;\n    line-height: @line-height-computed;\n  }\n\n  @media (max-width: @grid-float-breakpoint-max) {\n    // Dropdowns get custom display when collapsed\n    .open .dropdown-menu {\n      position: static;\n      float: none;\n      width: auto;\n      margin-top: 0;\n      background-color: transparent;\n      border: 0;\n      box-shadow: none;\n      > li > a,\n      .dropdown-header {\n        padding: 5px 15px 5px 25px;\n      }\n      > li > a {\n        line-height: @line-height-computed;\n        &:hover,\n        &:focus {\n          background-image: none;\n        }\n      }\n    }\n  }\n\n  // Uncollapse the nav\n  @media (min-width: @grid-float-breakpoint) {\n    float: left;\n    margin: 0;\n\n    > li {\n      float: left;\n      > a {\n        padding-top:    @navbar-padding-vertical;\n        padding-bottom: @navbar-padding-vertical;\n      }\n    }\n\n    &.navbar-right:last-child {\n      margin-right: -@navbar-padding-horizontal;\n    }\n  }\n}\n\n\n// Component alignment\n//\n// Repurpose the pull utilities as their own navbar utilities to avoid specificity\n// issues with parents and chaining. Only do this when the navbar is uncollapsed\n// though so that navbar contents properly stack and align in mobile.\n\n@media (min-width: @grid-float-breakpoint) {\n  .navbar-left  { .pull-left(); }\n  .navbar-right { .pull-right(); }\n}\n\n\n// Navbar form\n//\n// Extension of the `.form-inline` with some extra flavor for optimum display in\n// our navbars.\n\n.navbar-form {\n  margin-left: -@navbar-padding-horizontal;\n  margin-right: -@navbar-padding-horizontal;\n  padding: 10px @navbar-padding-horizontal;\n  border-top: 1px solid transparent;\n  border-bottom: 1px solid transparent;\n  @shadow: inset 0 1px 0 rgba(255,255,255,.1), 0 1px 0 rgba(255,255,255,.1);\n  .box-shadow(@shadow);\n\n  // Mixin behavior for optimum display\n  .form-inline();\n\n  .form-group {\n    @media (max-width: @grid-float-breakpoint-max) {\n      margin-bottom: 5px;\n    }\n  }\n\n  // Vertically center in expanded, horizontal navbar\n  .navbar-vertical-align(@input-height-base);\n\n  // Undo 100% width for pull classes\n  @media (min-width: @grid-float-breakpoint) {\n    width: auto;\n    border: 0;\n    margin-left: 0;\n    margin-right: 0;\n    padding-top: 0;\n    padding-bottom: 0;\n    .box-shadow(none);\n\n    // Outdent the form if last child to line up with content down the page\n    &.navbar-right:last-child {\n      margin-right: -@navbar-padding-horizontal;\n    }\n  }\n}\n\n\n// Dropdown menus\n\n// Menu position and menu carets\n.navbar-nav > li > .dropdown-menu {\n  margin-top: 0;\n  .border-top-radius(0);\n}\n// Menu position and menu caret support for dropups via extra dropup class\n.navbar-fixed-bottom .navbar-nav > li > .dropdown-menu {\n  .border-bottom-radius(0);\n}\n\n\n// Buttons in navbars\n//\n// Vertically center a button within a navbar (when *not* in a form).\n\n.navbar-btn {\n  .navbar-vertical-align(@input-height-base);\n\n  &.btn-sm {\n    .navbar-vertical-align(@input-height-small);\n  }\n  &.btn-xs {\n    .navbar-vertical-align(22);\n  }\n}\n\n\n// Text in navbars\n//\n// Add a class to make any element properly align itself vertically within the navbars.\n\n.navbar-text {\n  .navbar-vertical-align(@line-height-computed);\n\n  @media (min-width: @grid-float-breakpoint) {\n    float: left;\n    margin-left: @navbar-padding-horizontal;\n    margin-right: @navbar-padding-horizontal;\n\n    // Outdent the form if last child to line up with content down the page\n    &.navbar-right:last-child {\n      margin-right: 0;\n    }\n  }\n}\n\n// Alternate navbars\n// --------------------------------------------------\n\n// Default navbar\n.navbar-default {\n  background-color: @navbar-default-bg;\n  border-color: @navbar-default-border;\n\n  .navbar-brand {\n    color: @navbar-default-brand-color;\n    &:hover,\n    &:focus {\n      color: @navbar-default-brand-hover-color;\n      background-color: @navbar-default-brand-hover-bg;\n    }\n  }\n\n  .navbar-text {\n    color: @navbar-default-color;\n  }\n\n  .navbar-nav {\n    > li > a {\n      color: @navbar-default-link-color;\n\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-hover-color;\n        background-color: @navbar-default-link-hover-bg;\n      }\n    }\n    > .active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-active-color;\n        background-color: @navbar-default-link-active-bg;\n      }\n    }\n    > .disabled > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-disabled-color;\n        background-color: @navbar-default-link-disabled-bg;\n      }\n    }\n  }\n\n  .navbar-toggle {\n    border-color: @navbar-default-toggle-border-color;\n    &:hover,\n    &:focus {\n      background-color: @navbar-default-toggle-hover-bg;\n    }\n    .icon-bar {\n      background-color: @navbar-default-toggle-icon-bar-bg;\n    }\n  }\n\n  .navbar-collapse,\n  .navbar-form {\n    border-color: @navbar-default-border;\n  }\n\n  // Dropdown menu items\n  .navbar-nav {\n    // Remove background color from open dropdown\n    > .open > a {\n      &,\n      &:hover,\n      &:focus {\n        background-color: @navbar-default-link-active-bg;\n        color: @navbar-default-link-active-color;\n      }\n    }\n\n    @media (max-width: @grid-float-breakpoint-max) {\n      // Dropdowns get custom display when collapsed\n      .open .dropdown-menu {\n        > li > a {\n          color: @navbar-default-link-color;\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-hover-color;\n            background-color: @navbar-default-link-hover-bg;\n          }\n        }\n        > .active > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-active-color;\n            background-color: @navbar-default-link-active-bg;\n          }\n        }\n        > .disabled > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-disabled-color;\n            background-color: @navbar-default-link-disabled-bg;\n          }\n        }\n      }\n    }\n  }\n\n\n  // Links in navbars\n  //\n  // Add a class to ensure links outside the navbar nav are colored correctly.\n\n  .navbar-link {\n    color: @navbar-default-link-color;\n    &:hover {\n      color: @navbar-default-link-hover-color;\n    }\n  }\n\n  .btn-link {\n    color: @navbar-default-link-color;\n    &:hover,\n    &:focus {\n      color: @navbar-default-link-hover-color;\n    }\n    &[disabled],\n    fieldset[disabled] & {\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-disabled-color;\n      }\n    }\n  }\n}\n\n// Inverse navbar\n\n.navbar-inverse {\n  background-color: @navbar-inverse-bg;\n  border-color: @navbar-inverse-border;\n\n  .navbar-brand {\n    color: @navbar-inverse-brand-color;\n    &:hover,\n    &:focus {\n      color: @navbar-inverse-brand-hover-color;\n      background-color: @navbar-inverse-brand-hover-bg;\n    }\n  }\n\n  .navbar-text {\n    color: @navbar-inverse-color;\n  }\n\n  .navbar-nav {\n    > li > a {\n      color: @navbar-inverse-link-color;\n\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-hover-color;\n        background-color: @navbar-inverse-link-hover-bg;\n      }\n    }\n    > .active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-active-color;\n        background-color: @navbar-inverse-link-active-bg;\n      }\n    }\n    > .disabled > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-disabled-color;\n        background-color: @navbar-inverse-link-disabled-bg;\n      }\n    }\n  }\n\n  // Darken the responsive nav toggle\n  .navbar-toggle {\n    border-color: @navbar-inverse-toggle-border-color;\n    &:hover,\n    &:focus {\n      background-color: @navbar-inverse-toggle-hover-bg;\n    }\n    .icon-bar {\n      background-color: @navbar-inverse-toggle-icon-bar-bg;\n    }\n  }\n\n  .navbar-collapse,\n  .navbar-form {\n    border-color: darken(@navbar-inverse-bg, 7%);\n  }\n\n  // Dropdowns\n  .navbar-nav {\n    > .open > a {\n      &,\n      &:hover,\n      &:focus {\n        background-color: @navbar-inverse-link-active-bg;\n        color: @navbar-inverse-link-active-color;\n      }\n    }\n\n    @media (max-width: @grid-float-breakpoint-max) {\n      // Dropdowns get custom display\n      .open .dropdown-menu {\n        > .dropdown-header {\n          border-color: @navbar-inverse-border;\n        }\n        .divider {\n          background-color: @navbar-inverse-border;\n        }\n        > li > a {\n          color: @navbar-inverse-link-color;\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-hover-color;\n            background-color: @navbar-inverse-link-hover-bg;\n          }\n        }\n        > .active > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-active-color;\n            background-color: @navbar-inverse-link-active-bg;\n          }\n        }\n        > .disabled > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-disabled-color;\n            background-color: @navbar-inverse-link-disabled-bg;\n          }\n        }\n      }\n    }\n  }\n\n  .navbar-link {\n    color: @navbar-inverse-link-color;\n    &:hover {\n      color: @navbar-inverse-link-hover-color;\n    }\n  }\n\n  .btn-link {\n    color: @navbar-inverse-link-color;\n    &:hover,\n    &:focus {\n      color: @navbar-inverse-link-hover-color;\n    }\n    &[disabled],\n    fieldset[disabled] & {\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-disabled-color;\n      }\n    }\n  }\n}\n","navs.less":"//\n// Navs\n// --------------------------------------------------\n\n\n// Base class\n// --------------------------------------------------\n\n.nav {\n  margin-bottom: 0;\n  padding-left: 0; // Override default ul/ol\n  list-style: none;\n  &:extend(.clearfix all);\n\n  > li {\n    position: relative;\n    display: block;\n\n    > a {\n      position: relative;\n      display: block;\n      padding: @nav-link-padding;\n      &:hover,\n      &:focus {\n        text-decoration: none;\n        background-color: @nav-link-hover-bg;\n      }\n    }\n\n    // Disabled state sets text to gray and nukes hover/tab effects\n    &.disabled > a {\n      color: @nav-disabled-link-color;\n\n      &:hover,\n      &:focus {\n        color: @nav-disabled-link-hover-color;\n        text-decoration: none;\n        background-color: transparent;\n        cursor: not-allowed;\n      }\n    }\n  }\n\n  // Open dropdowns\n  .open > a {\n    &,\n    &:hover,\n    &:focus {\n      background-color: @nav-link-hover-bg;\n      border-color: @link-color;\n    }\n  }\n\n  // Nav dividers (deprecated with v3.0.1)\n  //\n  // This should have been removed in v3 with the dropping of `.nav-list`, but\n  // we missed it. We don't currently support this anywhere, but in the interest\n  // of maintaining backward compatibility in case you use it, it's deprecated.\n  .nav-divider {\n    .nav-divider();\n  }\n\n  // Prevent IE8 from misplacing imgs\n  //\n  // See https://github.com/h5bp/html5-boilerplate/issues/984#issuecomment-3985989\n  > li > a > img {\n    max-width: none;\n  }\n}\n\n\n// Tabs\n// -------------------------\n\n// Give the tabs something to sit on\n.nav-tabs {\n  border-bottom: 1px solid @nav-tabs-border-color;\n  > li {\n    float: left;\n    // Make the list-items overlay the bottom border\n    margin-bottom: -1px;\n\n    // Actual tabs (as links)\n    > a {\n      margin-right: 2px;\n      line-height: @line-height-base;\n      border: 1px solid transparent;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n      &:hover {\n        border-color: @nav-tabs-link-hover-border-color @nav-tabs-link-hover-border-color @nav-tabs-border-color;\n      }\n    }\n\n    // Active state, and its :hover to override normal :hover\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-tabs-active-link-hover-color;\n        background-color: @nav-tabs-active-link-hover-bg;\n        border: 1px solid @nav-tabs-active-link-hover-border-color;\n        border-bottom-color: transparent;\n        cursor: default;\n      }\n    }\n  }\n  // pulling this in mainly for less shorthand\n  &.nav-justified {\n    .nav-justified();\n    .nav-tabs-justified();\n  }\n}\n\n\n// Pills\n// -------------------------\n.nav-pills {\n  > li {\n    float: left;\n\n    // Links rendered as pills\n    > a {\n      border-radius: @nav-pills-border-radius;\n    }\n    + li {\n      margin-left: 2px;\n    }\n\n    // Active state\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-pills-active-link-hover-color;\n        background-color: @nav-pills-active-link-hover-bg;\n      }\n    }\n  }\n}\n\n\n// Stacked pills\n.nav-stacked {\n  > li {\n    float: none;\n    + li {\n      margin-top: 2px;\n      margin-left: 0; // no need for this gap between nav items\n    }\n  }\n}\n\n\n// Nav variations\n// --------------------------------------------------\n\n// Justified nav links\n// -------------------------\n\n.nav-justified {\n  width: 100%;\n\n  > li {\n    float: none;\n     > a {\n      text-align: center;\n      margin-bottom: 5px;\n    }\n  }\n\n  > .dropdown .dropdown-menu {\n    top: auto;\n    left: auto;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li {\n      display: table-cell;\n      width: 1%;\n      > a {\n        margin-bottom: 0;\n      }\n    }\n  }\n}\n\n// Move borders to anchors instead of bottom of list\n//\n// Mixin for adding on top the shared `.nav-justified` styles for our tabs\n.nav-tabs-justified {\n  border-bottom: 0;\n\n  > li > a {\n    // Override margin from .nav-tabs\n    margin-right: 0;\n    border-radius: @border-radius-base;\n  }\n\n  > .active > a,\n  > .active > a:hover,\n  > .active > a:focus {\n    border: 1px solid @nav-tabs-justified-link-border-color;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li > a {\n      border-bottom: 1px solid @nav-tabs-justified-link-border-color;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n    }\n    > .active > a,\n    > .active > a:hover,\n    > .active > a:focus {\n      border-bottom-color: @nav-tabs-justified-active-link-border-color;\n    }\n  }\n}\n\n\n// Tabbable tabs\n// -------------------------\n\n// Hide tabbable panes to start, show them when `.active`\n.tab-content {\n  > .tab-pane {\n    display: none;\n  }\n  > .active {\n    display: block;\n  }\n}\n\n\n// Dropdowns\n// -------------------------\n\n// Specific dropdowns\n.nav-tabs .dropdown-menu {\n  // make dropdown border overlap tab border\n  margin-top: -1px;\n  // Remove the top rounded corners here since there is a hard edge above the menu\n  .border-top-radius(0);\n}\n","normalize.less":"/*! normalize.css v3.0.0 | MIT License | git.io/normalize */\n\n//\n// 1. Set default font family to sans-serif.\n// 2. Prevent iOS text size adjust after orientation change, without disabling\n//    user zoom.\n//\n\nhtml {\n  font-family: sans-serif; // 1\n  -ms-text-size-adjust: 100%; // 2\n  -webkit-text-size-adjust: 100%; // 2\n}\n\n//\n// Remove default margin.\n//\n\nbody {\n  margin: 0;\n}\n\n// HTML5 display definitions\n// ==========================================================================\n\n//\n// Correct `block` display not defined in IE 8/9.\n//\n\narticle,\naside,\ndetails,\nfigcaption,\nfigure,\nfooter,\nheader,\nhgroup,\nmain,\nnav,\nsection,\nsummary {\n  display: block;\n}\n\n//\n// 1. Correct `inline-block` display not defined in IE 8/9.\n// 2. Normalize vertical alignment of `progress` in Chrome, Firefox, and Opera.\n//\n\naudio,\ncanvas,\nprogress,\nvideo {\n  display: inline-block; // 1\n  vertical-align: baseline; // 2\n}\n\n//\n// Prevent modern browsers from displaying `audio` without controls.\n// Remove excess height in iOS 5 devices.\n//\n\naudio:not([controls]) {\n  display: none;\n  height: 0;\n}\n\n//\n// Address `[hidden]` styling not present in IE 8/9.\n// Hide the `template` element in IE, Safari, and Firefox < 22.\n//\n\n[hidden],\ntemplate {\n  display: none;\n}\n\n// Links\n// ==========================================================================\n\n//\n// Remove the gray background color from active links in IE 10.\n//\n\na {\n  background: transparent;\n}\n\n//\n// Improve readability when focused and also mouse hovered in all browsers.\n//\n\na:active,\na:hover {\n  outline: 0;\n}\n\n// Text-level semantics\n// ==========================================================================\n\n//\n// Address styling not present in IE 8/9, Safari 5, and Chrome.\n//\n\nabbr[title] {\n  border-bottom: 1px dotted;\n}\n\n//\n// Address style set to `bolder` in Firefox 4+, Safari 5, and Chrome.\n//\n\nb,\nstrong {\n  font-weight: bold;\n}\n\n//\n// Address styling not present in Safari 5 and Chrome.\n//\n\ndfn {\n  font-style: italic;\n}\n\n//\n// Address variable `h1` font-size and margin within `section` and `article`\n// contexts in Firefox 4+, Safari 5, and Chrome.\n//\n\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}\n\n//\n// Address styling not present in IE 8/9.\n//\n\nmark {\n  background: #ff0;\n  color: #000;\n}\n\n//\n// Address inconsistent and variable font size in all browsers.\n//\n\nsmall {\n  font-size: 80%;\n}\n\n//\n// Prevent `sub` and `sup` affecting `line-height` in all browsers.\n//\n\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsup {\n  top: -0.5em;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\n// Embedded content\n// ==========================================================================\n\n//\n// Remove border when inside `a` element in IE 8/9.\n//\n\nimg {\n  border: 0;\n}\n\n//\n// Correct overflow displayed oddly in IE 9.\n//\n\nsvg:not(:root) {\n  overflow: hidden;\n}\n\n// Grouping content\n// ==========================================================================\n\n//\n// Address margin not present in IE 8/9 and Safari 5.\n//\n\nfigure {\n  margin: 1em 40px;\n}\n\n//\n// Address differences between Firefox and other browsers.\n//\n\nhr {\n  -moz-box-sizing: content-box;\n  box-sizing: content-box;\n  height: 0;\n}\n\n//\n// Contain overflow in all browsers.\n//\n\npre {\n  overflow: auto;\n}\n\n//\n// Address odd `em`-unit font size rendering in all browsers.\n//\n\ncode,\nkbd,\npre,\nsamp {\n  font-family: monospace, monospace;\n  font-size: 1em;\n}\n\n// Forms\n// ==========================================================================\n\n//\n// Known limitation: by default, Chrome and Safari on OS X allow very limited\n// styling of `select`, unless a `border` property is set.\n//\n\n//\n// 1. Correct color not being inherited.\n//    Known issue: affects color of disabled elements.\n// 2. Correct font properties not being inherited.\n// 3. Address margins set differently in Firefox 4+, Safari 5, and Chrome.\n//\n\nbutton,\ninput,\noptgroup,\nselect,\ntextarea {\n  color: inherit; // 1\n  font: inherit; // 2\n  margin: 0; // 3\n}\n\n//\n// Address `overflow` set to `hidden` in IE 8/9/10.\n//\n\nbutton {\n  overflow: visible;\n}\n\n//\n// Address inconsistent `text-transform` inheritance for `button` and `select`.\n// All other form control elements do not inherit `text-transform` values.\n// Correct `button` style inheritance in Firefox, IE 8+, and Opera\n// Correct `select` style inheritance in Firefox.\n//\n\nbutton,\nselect {\n  text-transform: none;\n}\n\n//\n// 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`\n//    and `video` controls.\n// 2. Correct inability to style clickable `input` types in iOS.\n// 3. Improve usability and consistency of cursor style between image-type\n//    `input` and others.\n//\n\nbutton,\nhtml input[type=\"button\"], // 1\ninput[type=\"reset\"],\ninput[type=\"submit\"] {\n  -webkit-appearance: button; // 2\n  cursor: pointer; // 3\n}\n\n//\n// Re-set default cursor for disabled elements.\n//\n\nbutton[disabled],\nhtml input[disabled] {\n  cursor: default;\n}\n\n//\n// Remove inner padding and border in Firefox 4+.\n//\n\nbutton::-moz-focus-inner,\ninput::-moz-focus-inner {\n  border: 0;\n  padding: 0;\n}\n\n//\n// Address Firefox 4+ setting `line-height` on `input` using `!important` in\n// the UA stylesheet.\n//\n\ninput {\n  line-height: normal;\n}\n\n//\n// It's recommended that you don't attempt to style these elements.\n// Firefox's implementation doesn't respect box-sizing, padding, or width.\n//\n// 1. Address box sizing set to `content-box` in IE 8/9/10.\n// 2. Remove excess padding in IE 8/9/10.\n//\n\ninput[type=\"checkbox\"],\ninput[type=\"radio\"] {\n  box-sizing: border-box; // 1\n  padding: 0; // 2\n}\n\n//\n// Fix the cursor style for Chrome's increment/decrement buttons. For certain\n// `font-size` values of the `input`, it causes the cursor style of the\n// decrement button to change from `default` to `text`.\n//\n\ninput[type=\"number\"]::-webkit-inner-spin-button,\ninput[type=\"number\"]::-webkit-outer-spin-button {\n  height: auto;\n}\n\n//\n// 1. Address `appearance` set to `searchfield` in Safari 5 and Chrome.\n// 2. Address `box-sizing` set to `border-box` in Safari 5 and Chrome\n//    (include `-moz` to future-proof).\n//\n\ninput[type=\"search\"] {\n  -webkit-appearance: textfield; // 1\n  -moz-box-sizing: content-box;\n  -webkit-box-sizing: content-box; // 2\n  box-sizing: content-box;\n}\n\n//\n// Remove inner padding and search cancel button in Safari and Chrome on OS X.\n// Safari (but not Chrome) clips the cancel button when the search input has\n// padding (and `textfield` appearance).\n//\n\ninput[type=\"search\"]::-webkit-search-cancel-button,\ninput[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n//\n// Define consistent border, margin, and padding.\n//\n\nfieldset {\n  border: 1px solid #c0c0c0;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n}\n\n//\n// 1. Correct `color` not being inherited in IE 8/9.\n// 2. Remove padding so people aren't caught out if they zero out fieldsets.\n//\n\nlegend {\n  border: 0; // 1\n  padding: 0; // 2\n}\n\n//\n// Remove default vertical scrollbar in IE 8/9.\n//\n\ntextarea {\n  overflow: auto;\n}\n\n//\n// Don't inherit the `font-weight` (applied by a rule above).\n// NOTE: the default cannot safely be changed in Chrome and Safari on OS X.\n//\n\noptgroup {\n  font-weight: bold;\n}\n\n// Tables\n// ==========================================================================\n\n//\n// Remove most spacing between table cells.\n//\n\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\n\ntd,\nth {\n  padding: 0;\n}","pager.less":"//\n// Pager pagination\n// --------------------------------------------------\n\n\n.pager {\n  padding-left: 0;\n  margin: @line-height-computed 0;\n  list-style: none;\n  text-align: center;\n  &:extend(.clearfix all);\n  li {\n    display: inline;\n    > a,\n    > span {\n      display: inline-block;\n      padding: 5px 14px;\n      background-color: @pager-bg;\n      border: 1px solid @pager-border;\n      border-radius: @pager-border-radius;\n    }\n\n    > a:hover,\n    > a:focus {\n      text-decoration: none;\n      background-color: @pager-hover-bg;\n    }\n  }\n\n  .next {\n    > a,\n    > span {\n      float: right;\n    }\n  }\n\n  .previous {\n    > a,\n    > span {\n      float: left;\n    }\n  }\n\n  .disabled {\n    > a,\n    > a:hover,\n    > a:focus,\n    > span {\n      color: @pager-disabled-color;\n      background-color: @pager-bg;\n      cursor: not-allowed;\n    }\n  }\n\n}\n","pagination.less":"//\n// Pagination (multiple pages)\n// --------------------------------------------------\n.pagination {\n  display: inline-block;\n  padding-left: 0;\n  margin: @line-height-computed 0;\n  border-radius: @border-radius-base;\n\n  > li {\n    display: inline; // Remove list-style and block-level defaults\n    > a,\n    > span {\n      position: relative;\n      float: left; // Collapse white-space\n      padding: @padding-base-vertical @padding-base-horizontal;\n      line-height: @line-height-base;\n      text-decoration: none;\n      color: @pagination-color;\n      background-color: @pagination-bg;\n      border: 1px solid @pagination-border;\n      margin-left: -1px;\n    }\n    &:first-child {\n      > a,\n      > span {\n        margin-left: 0;\n        .border-left-radius(@border-radius-base);\n      }\n    }\n    &:last-child {\n      > a,\n      > span {\n        .border-right-radius(@border-radius-base);\n      }\n    }\n  }\n\n  > li > a,\n  > li > span {\n    &:hover,\n    &:focus {\n      color: @pagination-hover-color;\n      background-color: @pagination-hover-bg;\n      border-color: @pagination-hover-border;\n    }\n  }\n\n  > .active > a,\n  > .active > span {\n    &,\n    &:hover,\n    &:focus {\n      z-index: 2;\n      color: @pagination-active-color;\n      background-color: @pagination-active-bg;\n      border-color: @pagination-active-border;\n      cursor: default;\n    }\n  }\n\n  > .disabled {\n    > span,\n    > span:hover,\n    > span:focus,\n    > a,\n    > a:hover,\n    > a:focus {\n      color: @pagination-disabled-color;\n      background-color: @pagination-disabled-bg;\n      border-color: @pagination-disabled-border;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Sizing\n// --------------------------------------------------\n\n// Large\n.pagination-lg {\n  .pagination-size(@padding-large-vertical; @padding-large-horizontal; @font-size-large; @border-radius-large);\n}\n\n// Small\n.pagination-sm {\n  .pagination-size(@padding-small-vertical; @padding-small-horizontal; @font-size-small; @border-radius-small);\n}\n","panels.less":"//\n// Panels\n// --------------------------------------------------\n\n\n// Base class\n.panel {\n  margin-bottom: @line-height-computed;\n  background-color: @panel-bg;\n  border: 1px solid transparent;\n  border-radius: @panel-border-radius;\n  .box-shadow(0 1px 1px rgba(0,0,0,.05));\n}\n\n// Panel contents\n.panel-body {\n  padding: @panel-body-padding;\n  &:extend(.clearfix all);\n}\n\n// Optional heading\n.panel-heading {\n  padding: 10px 15px;\n  border-bottom: 1px solid transparent;\n  .border-top-radius((@panel-border-radius - 1));\n\n  > .dropdown .dropdown-toggle {\n    color: inherit;\n  }\n}\n\n// Within heading, strip any `h*` tag of its default margins for spacing.\n.panel-title {\n  margin-top: 0;\n  margin-bottom: 0;\n  font-size: ceil((@font-size-base * 1.125));\n  color: inherit;\n\n  > a {\n    color: inherit;\n  }\n}\n\n// Optional footer (stays gray in every modifier class)\n.panel-footer {\n  padding: 10px 15px;\n  background-color: @panel-footer-bg;\n  border-top: 1px solid @panel-inner-border;\n  .border-bottom-radius((@panel-border-radius - 1));\n}\n\n\n// List groups in panels\n//\n// By default, space out list group content from panel headings to account for\n// any kind of custom content between the two.\n\n.panel {\n  > .list-group {\n    margin-bottom: 0;\n\n    .list-group-item {\n      border-width: 1px 0;\n      border-radius: 0;\n    }\n\n    // Add border top radius for first one\n    &:first-child {\n      .list-group-item:first-child {\n        border-top: 0;\n        .border-top-radius((@panel-border-radius - 1));\n      }\n    }\n    // Add border bottom radius for last one\n    &:last-child {\n      .list-group-item:last-child {\n        border-bottom: 0;\n        .border-bottom-radius((@panel-border-radius - 1));\n      }\n    }\n  }\n}\n// Collapse space between when there's no additional content.\n.panel-heading + .list-group {\n  .list-group-item:first-child {\n    border-top-width: 0;\n  }\n}\n\n\n// Tables in panels\n//\n// Place a non-bordered `.table` within a panel (not within a `.panel-body`) and\n// watch it go full width.\n\n.panel {\n  > .table,\n  > .table-responsive > .table {\n    margin-bottom: 0;\n  }\n  // Add border top radius for first one\n  > .table:first-child,\n  > .table-responsive:first-child > .table:first-child {\n    .border-top-radius((@panel-border-radius - 1));\n\n    > thead:first-child,\n    > tbody:first-child {\n      > tr:first-child {\n        td:first-child,\n        th:first-child {\n          border-top-left-radius: (@panel-border-radius - 1);\n        }\n        td:last-child,\n        th:last-child {\n          border-top-right-radius: (@panel-border-radius - 1);\n        }\n      }\n    }\n  }\n  // Add border bottom radius for last one\n  > .table:last-child,\n  > .table-responsive:last-child > .table:last-child {\n    .border-bottom-radius((@panel-border-radius - 1));\n\n    > tbody:last-child,\n    > tfoot:last-child {\n      > tr:last-child {\n        td:first-child,\n        th:first-child {\n          border-bottom-left-radius: (@panel-border-radius - 1);\n        }\n        td:last-child,\n        th:last-child {\n          border-bottom-right-radius: (@panel-border-radius - 1);\n        }\n      }\n    }\n  }\n  > .panel-body + .table,\n  > .panel-body + .table-responsive {\n    border-top: 1px solid @table-border-color;\n  }\n  > .table > tbody:first-child > tr:first-child th,\n  > .table > tbody:first-child > tr:first-child td {\n    border-top: 0;\n  }\n  > .table-bordered,\n  > .table-responsive > .table-bordered {\n    border: 0;\n    > thead,\n    > tbody,\n    > tfoot {\n      > tr {\n        > th:first-child,\n        > td:first-child {\n          border-left: 0;\n        }\n        > th:last-child,\n        > td:last-child {\n          border-right: 0;\n        }\n      }\n    }\n    > thead,\n    > tbody {\n      > tr:first-child {\n        > td,\n        > th {\n          border-bottom: 0;\n        }\n      }\n    }\n    > tbody,\n    > tfoot {\n      > tr:last-child {\n        > td,\n        > th {\n          border-bottom: 0;\n        }\n      }\n    }\n  }\n  > .table-responsive {\n    border: 0;\n    margin-bottom: 0;\n  }\n}\n\n\n// Collapsable panels (aka, accordion)\n//\n// Wrap a series of panels in `.panel-group` to turn them into an accordion with\n// the help of our collapse JavaScript plugin.\n\n.panel-group {\n  margin-bottom: @line-height-computed;\n\n  // Tighten up margin so it's only between panels\n  .panel {\n    margin-bottom: 0;\n    border-radius: @panel-border-radius;\n    overflow: hidden; // crop contents when collapsed\n    + .panel {\n      margin-top: 5px;\n    }\n  }\n\n  .panel-heading {\n    border-bottom: 0;\n    + .panel-collapse .panel-body {\n      border-top: 1px solid @panel-inner-border;\n    }\n  }\n  .panel-footer {\n    border-top: 0;\n    + .panel-collapse .panel-body {\n      border-bottom: 1px solid @panel-inner-border;\n    }\n  }\n}\n\n\n// Contextual variations\n.panel-default {\n  .panel-variant(@panel-default-border; @panel-default-text; @panel-default-heading-bg; @panel-default-border);\n}\n.panel-primary {\n  .panel-variant(@panel-primary-border; @panel-primary-text; @panel-primary-heading-bg; @panel-primary-border);\n}\n.panel-success {\n  .panel-variant(@panel-success-border; @panel-success-text; @panel-success-heading-bg; @panel-success-border);\n}\n.panel-info {\n  .panel-variant(@panel-info-border; @panel-info-text; @panel-info-heading-bg; @panel-info-border);\n}\n.panel-warning {\n  .panel-variant(@panel-warning-border; @panel-warning-text; @panel-warning-heading-bg; @panel-warning-border);\n}\n.panel-danger {\n  .panel-variant(@panel-danger-border; @panel-danger-text; @panel-danger-heading-bg; @panel-danger-border);\n}\n","popovers.less":"//\n// Popovers\n// --------------------------------------------------\n\n\n.popover {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: @zindex-popover;\n  display: none;\n  max-width: @popover-max-width;\n  padding: 1px;\n  text-align: left; // Reset given new insertion method\n  background-color: @popover-bg;\n  background-clip: padding-box;\n  border: 1px solid @popover-fallback-border-color;\n  border: 1px solid @popover-border-color;\n  border-radius: @border-radius-large;\n  .box-shadow(0 5px 10px rgba(0,0,0,.2));\n\n  // Overrides for proper insertion\n  white-space: normal;\n\n  // Offset the popover to account for the popover arrow\n  &.top     { margin-top: -@popover-arrow-width; }\n  &.right   { margin-left: @popover-arrow-width; }\n  &.bottom  { margin-top: @popover-arrow-width; }\n  &.left    { margin-left: -@popover-arrow-width; }\n}\n\n.popover-title {\n  margin: 0; // reset heading margin\n  padding: 8px 14px;\n  font-size: @font-size-base;\n  font-weight: normal;\n  line-height: 18px;\n  background-color: @popover-title-bg;\n  border-bottom: 1px solid darken(@popover-title-bg, 5%);\n  border-radius: 5px 5px 0 0;\n}\n\n.popover-content {\n  padding: 9px 14px;\n}\n\n// Arrows\n//\n// .arrow is outer, .arrow:after is inner\n\n.popover > .arrow {\n  &,\n  &:after {\n    position: absolute;\n    display: block;\n    width: 0;\n    height: 0;\n    border-color: transparent;\n    border-style: solid;\n  }\n}\n.popover > .arrow {\n  border-width: @popover-arrow-outer-width;\n}\n.popover > .arrow:after {\n  border-width: @popover-arrow-width;\n  content: \"\";\n}\n\n.popover {\n  &.top > .arrow {\n    left: 50%;\n    margin-left: -@popover-arrow-outer-width;\n    border-bottom-width: 0;\n    border-top-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-top-color: @popover-arrow-outer-color;\n    bottom: -@popover-arrow-outer-width;\n    &:after {\n      content: \" \";\n      bottom: 1px;\n      margin-left: -@popover-arrow-width;\n      border-bottom-width: 0;\n      border-top-color: @popover-arrow-color;\n    }\n  }\n  &.right > .arrow {\n    top: 50%;\n    left: -@popover-arrow-outer-width;\n    margin-top: -@popover-arrow-outer-width;\n    border-left-width: 0;\n    border-right-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-right-color: @popover-arrow-outer-color;\n    &:after {\n      content: \" \";\n      left: 1px;\n      bottom: -@popover-arrow-width;\n      border-left-width: 0;\n      border-right-color: @popover-arrow-color;\n    }\n  }\n  &.bottom > .arrow {\n    left: 50%;\n    margin-left: -@popover-arrow-outer-width;\n    border-top-width: 0;\n    border-bottom-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-bottom-color: @popover-arrow-outer-color;\n    top: -@popover-arrow-outer-width;\n    &:after {\n      content: \" \";\n      top: 1px;\n      margin-left: -@popover-arrow-width;\n      border-top-width: 0;\n      border-bottom-color: @popover-arrow-color;\n    }\n  }\n\n  &.left > .arrow {\n    top: 50%;\n    right: -@popover-arrow-outer-width;\n    margin-top: -@popover-arrow-outer-width;\n    border-right-width: 0;\n    border-left-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-left-color: @popover-arrow-outer-color;\n    &:after {\n      content: \" \";\n      right: 1px;\n      border-right-width: 0;\n      border-left-color: @popover-arrow-color;\n      bottom: -@popover-arrow-width;\n    }\n  }\n\n}\n","print.less":"//\n// Basic print styles\n// --------------------------------------------------\n// Source: https://github.com/h5bp/html5-boilerplate/blob/master/css/main.css\n\n@media print {\n\n  * {\n    text-shadow: none !important;\n    color: #000 !important; // Black prints faster: h5bp.com/s\n    background: transparent !important;\n    box-shadow: none !important;\n  }\n\n  a,\n  a:visited {\n    text-decoration: underline;\n  }\n\n  a[href]:after {\n    content: \" (\" attr(href) \")\";\n  }\n\n  abbr[title]:after {\n    content: \" (\" attr(title) \")\";\n  }\n\n  // Don't show links for images, or javascript/internal links\n  a[href^=\"javascript:\"]:after,\n  a[href^=\"#\"]:after {\n    content: \"\";\n  }\n\n  pre,\n  blockquote {\n    border: 1px solid #999;\n    page-break-inside: avoid;\n  }\n\n  thead {\n    display: table-header-group; // h5bp.com/t\n  }\n\n  tr,\n  img {\n    page-break-inside: avoid;\n  }\n\n  img {\n    max-width: 100% !important;\n  }\n\n  p,\n  h2,\n  h3 {\n    orphans: 3;\n    widows: 3;\n  }\n\n  h2,\n  h3 {\n    page-break-after: avoid;\n  }\n\n  // Chrome (OSX) fix for https://github.com/twbs/bootstrap/issues/11245\n  // Once fixed, we can just straight up remove this.\n  select {\n    background: #fff !important;\n  }\n\n  // Bootstrap components\n  .navbar {\n    display: none;\n  }\n  .table {\n    td,\n    th {\n      background-color: #fff !important;\n    }\n  }\n  .btn,\n  .dropup > .btn {\n    > .caret {\n      border-top-color: #000 !important;\n    }\n  }\n  .label {\n    border: 1px solid #000;\n  }\n\n  .table {\n    border-collapse: collapse !important;\n  }\n  .table-bordered {\n    th,\n    td {\n      border: 1px solid #ddd !important;\n    }\n  }\n\n}\n","progress-bars.less":"//\n// Progress bars\n// --------------------------------------------------\n\n\n// Bar animations\n// -------------------------\n\n// WebKit\n@-webkit-keyframes progress-bar-stripes {\n  from  { background-position: 40px 0; }\n  to    { background-position: 0 0; }\n}\n\n// Spec and IE10+\n@keyframes progress-bar-stripes {\n  from  { background-position: 40px 0; }\n  to    { background-position: 0 0; }\n}\n\n\n\n// Bar itself\n// -------------------------\n\n// Outer container\n.progress {\n  overflow: hidden;\n  height: @line-height-computed;\n  margin-bottom: @line-height-computed;\n  background-color: @progress-bg;\n  border-radius: @border-radius-base;\n  .box-shadow(inset 0 1px 2px rgba(0,0,0,.1));\n}\n\n// Bar of progress\n.progress-bar {\n  float: left;\n  width: 0%;\n  height: 100%;\n  font-size: @font-size-small;\n  line-height: @line-height-computed;\n  color: @progress-bar-color;\n  text-align: center;\n  background-color: @progress-bar-bg;\n  .box-shadow(inset 0 -1px 0 rgba(0,0,0,.15));\n  .transition(width .6s ease);\n}\n\n// Striped bars\n.progress-striped .progress-bar {\n  #gradient > .striped();\n  background-size: 40px 40px;\n}\n\n// Call animation for the active one\n.progress.active .progress-bar {\n  .animation(progress-bar-stripes 2s linear infinite);\n}\n\n\n\n// Variations\n// -------------------------\n\n.progress-bar-success {\n  .progress-bar-variant(@progress-bar-success-bg);\n}\n\n.progress-bar-info {\n  .progress-bar-variant(@progress-bar-info-bg);\n}\n\n.progress-bar-warning {\n  .progress-bar-variant(@progress-bar-warning-bg);\n}\n\n.progress-bar-danger {\n  .progress-bar-variant(@progress-bar-danger-bg);\n}\n","responsive-utilities.less":"//\n// Responsive: Utility classes\n// --------------------------------------------------\n\n\n// IE10 in Windows (Phone) 8\n//\n// Support for responsive views via media queries is kind of borked in IE10, for\n// Surface/desktop in split view and for Windows Phone 8. This particular fix\n// must be accompanied by a snippet of JavaScript to sniff the user agent and\n// apply some conditional CSS to *only* the Surface/desktop Windows 8. Look at\n// our Getting Started page for more information on this bug.\n//\n// For more information, see the following:\n//\n// Issue: https://github.com/twbs/bootstrap/issues/10497\n// Docs: http://getbootstrap.com/getting-started/#browsers\n// Source: http://timkadlec.com/2012/10/ie10-snap-mode-and-responsive-design/\n\n@-ms-viewport {\n  width: device-width;\n}\n\n\n// Visibility utilities\n.visible-xs,\n.visible-sm,\n.visible-md,\n.visible-lg {\n  .responsive-invisibility();\n}\n\n.visible-xs {\n  @media (max-width: @screen-xs-max) {\n    .responsive-visibility();\n  }\n}\n.visible-sm {\n  @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n    .responsive-visibility();\n  }\n}\n.visible-md {\n  @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n    .responsive-visibility();\n  }\n}\n.visible-lg {\n  @media (min-width: @screen-lg-min) {\n    .responsive-visibility();\n  }\n}\n\n.hidden-xs {\n  @media (max-width: @screen-xs-max) {\n    .responsive-invisibility();\n  }\n}\n.hidden-sm {\n  @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n    .responsive-invisibility();\n  }\n}\n.hidden-md {\n  @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n    .responsive-invisibility();\n  }\n}\n.hidden-lg {\n  @media (min-width: @screen-lg-min) {\n    .responsive-invisibility();\n  }\n}\n\n\n// Print utilities\n//\n// Media queries are placed on the inside to be mixin-friendly.\n\n.visible-print {\n  .responsive-invisibility();\n\n  @media print {\n    .responsive-visibility();\n  }\n}\n\n.hidden-print {\n  @media print {\n    .responsive-invisibility();\n  }\n}\n","scaffolding.less":"//\n// Scaffolding\n// --------------------------------------------------\n\n\n// Reset the box-sizing\n//\n// Heads up! This reset may cause conflicts with some third-party widgets.\n// For recommendations on resolving such conflicts, see\n// http://getbootstrap.com/getting-started/#third-box-sizing\n* {\n  .box-sizing(border-box);\n}\n*:before,\n*:after {\n  .box-sizing(border-box);\n}\n\n\n// Body reset\n\nhtml {\n  font-size: 62.5%;\n  -webkit-tap-highlight-color: rgba(0,0,0,0);\n}\n\nbody {\n  font-family: @font-family-base;\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @text-color;\n  background-color: @body-bg;\n}\n\n// Reset fonts for relevant elements\ninput,\nbutton,\nselect,\ntextarea {\n  font-family: inherit;\n  font-size: inherit;\n  line-height: inherit;\n}\n\n\n// Links\n\na {\n  color: @link-color;\n  text-decoration: none;\n\n  &:hover,\n  &:focus {\n    color: @link-hover-color;\n    text-decoration: underline;\n  }\n\n  &:focus {\n    .tab-focus();\n  }\n}\n\n\n// Figures\n//\n// We reset this here because previously Normalize had no `figure` margins. This\n// ensures we don't break anyone's use of the element.\n\nfigure {\n  margin: 0;\n}\n\n\n// Images\n\nimg {\n  vertical-align: middle;\n}\n\n// Responsive images (ensure images don't scale beyond their parents)\n.img-responsive {\n  .img-responsive();\n}\n\n// Rounded corners\n.img-rounded {\n  border-radius: @border-radius-large;\n}\n\n// Image thumbnails\n//\n// Heads up! This is mixin-ed into thumbnails.less for `.thumbnail`.\n.img-thumbnail {\n  padding: @thumbnail-padding;\n  line-height: @line-height-base;\n  background-color: @thumbnail-bg;\n  border: 1px solid @thumbnail-border;\n  border-radius: @thumbnail-border-radius;\n  .transition(all .2s ease-in-out);\n\n  // Keep them at most 100% wide\n  .img-responsive(inline-block);\n}\n\n// Perfect circle\n.img-circle {\n  border-radius: 50%; // set radius in percents\n}\n\n\n// Horizontal rules\n\nhr {\n  margin-top:    @line-height-computed;\n  margin-bottom: @line-height-computed;\n  border: 0;\n  border-top: 1px solid @hr-border;\n}\n\n\n// Only display content to screen readers\n//\n// See: http://a11yproject.com/posts/how-to-hide-content/\n\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  margin: -1px;\n  padding: 0;\n  overflow: hidden;\n  clip: rect(0,0,0,0);\n  border: 0;\n}\n","tables.less":"//\n// Tables\n// --------------------------------------------------\n\n\ntable {\n  max-width: 100%;\n  background-color: @table-bg;\n}\nth {\n  text-align: left;\n}\n\n\n// Baseline styles\n\n.table {\n  width: 100%;\n  margin-bottom: @line-height-computed;\n  // Cells\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-cell-padding;\n        line-height: @line-height-base;\n        vertical-align: top;\n        border-top: 1px solid @table-border-color;\n      }\n    }\n  }\n  // Bottom align for column headings\n  > thead > tr > th {\n    vertical-align: bottom;\n    border-bottom: 2px solid @table-border-color;\n  }\n  // Remove top border from thead by default\n  > caption + thead,\n  > colgroup + thead,\n  > thead:first-child {\n    > tr:first-child {\n      > th,\n      > td {\n        border-top: 0;\n      }\n    }\n  }\n  // Account for multiple tbody instances\n  > tbody + tbody {\n    border-top: 2px solid @table-border-color;\n  }\n\n  // Nesting\n  .table {\n    background-color: @body-bg;\n  }\n}\n\n\n// Condensed table w/ half padding\n\n.table-condensed {\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-condensed-cell-padding;\n      }\n    }\n  }\n}\n\n\n// Bordered version\n//\n// Add borders all around the table and between all the columns.\n\n.table-bordered {\n  border: 1px solid @table-border-color;\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        border: 1px solid @table-border-color;\n      }\n    }\n  }\n  > thead > tr {\n    > th,\n    > td {\n      border-bottom-width: 2px;\n    }\n  }\n}\n\n\n// Zebra-striping\n//\n// Default zebra-stripe styles (alternating gray and transparent backgrounds)\n\n.table-striped {\n  > tbody > tr:nth-child(odd) {\n    > td,\n    > th {\n      background-color: @table-bg-accent;\n    }\n  }\n}\n\n\n// Hover effect\n//\n// Placed here since it has to come after the potential zebra striping\n\n.table-hover {\n  > tbody > tr:hover {\n    > td,\n    > th {\n      background-color: @table-bg-hover;\n    }\n  }\n}\n\n\n// Table cell sizing\n//\n// Reset default table behavior\n\ntable col[class*=\"col-\"] {\n  position: static; // Prevent border hiding in Firefox and IE9/10 (see https://github.com/twbs/bootstrap/issues/11623)\n  float: none;\n  display: table-column;\n}\ntable {\n  td,\n  th {\n    &[class*=\"col-\"] {\n      position: static; // Prevent border hiding in Firefox and IE9/10 (see https://github.com/twbs/bootstrap/issues/11623)\n      float: none;\n      display: table-cell;\n    }\n  }\n}\n\n\n// Table backgrounds\n//\n// Exact selectors below required to override `.table-striped` and prevent\n// inheritance to nested tables.\n\n// Generate the contextual variants\n.table-row-variant(active; @table-bg-active);\n.table-row-variant(success; @state-success-bg);\n.table-row-variant(info; @state-info-bg);\n.table-row-variant(warning; @state-warning-bg);\n.table-row-variant(danger; @state-danger-bg);\n\n\n// Responsive tables\n//\n// Wrap your tables in `.table-responsive` and we'll make them mobile friendly\n// by enabling horizontal scrolling. Only applies <768px. Everything above that\n// will display normally.\n\n.table-responsive {\n  @media (max-width: @screen-xs-max) {\n    width: 100%;\n    margin-bottom: (@line-height-computed * 0.75);\n    overflow-y: hidden;\n    overflow-x: scroll;\n    -ms-overflow-style: -ms-autohiding-scrollbar;\n    border: 1px solid @table-border-color;\n    -webkit-overflow-scrolling: touch;\n\n    // Tighten up spacing\n    > .table {\n      margin-bottom: 0;\n\n      // Ensure the content doesn't wrap\n      > thead,\n      > tbody,\n      > tfoot {\n        > tr {\n          > th,\n          > td {\n            white-space: nowrap;\n          }\n        }\n      }\n    }\n\n    // Special overrides for the bordered tables\n    > .table-bordered {\n      border: 0;\n\n      // Nuke the appropriate borders so that the parent can handle them\n      > thead,\n      > tbody,\n      > tfoot {\n        > tr {\n          > th:first-child,\n          > td:first-child {\n            border-left: 0;\n          }\n          > th:last-child,\n          > td:last-child {\n            border-right: 0;\n          }\n        }\n      }\n\n      // Only nuke the last row's bottom-border in `tbody` and `tfoot` since\n      // chances are there will be only one `tr` in a `thead` and that would\n      // remove the border altogether.\n      > tbody,\n      > tfoot {\n        > tr:last-child {\n          > th,\n          > td {\n            border-bottom: 0;\n          }\n        }\n      }\n\n    }\n  }\n}\n","theme.less":"\n//\n// Load core variables and mixins\n// --------------------------------------------------\n\n@import \"variables.less\";\n@import \"mixins.less\";\n\n\n\n//\n// Buttons\n// --------------------------------------------------\n\n// Common styles\n.btn-default,\n.btn-primary,\n.btn-success,\n.btn-info,\n.btn-warning,\n.btn-danger {\n  text-shadow: 0 -1px 0 rgba(0,0,0,.2);\n  @shadow: inset 0 1px 0 rgba(255,255,255,.15), 0 1px 1px rgba(0,0,0,.075);\n  .box-shadow(@shadow);\n\n  // Reset the shadow\n  &:active,\n  &.active {\n    .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n  }\n}\n\n// Mixin for generating new styles\n.btn-styles(@btn-color: #555) {\n  #gradient > .vertical(@start-color: @btn-color; @end-color: darken(@btn-color, 12%));\n  .reset-filter(); // Disable gradients for IE9 because filter bleeds through rounded corners\n  background-repeat: repeat-x;\n  border-color: darken(@btn-color, 14%);\n\n  &:hover,\n  &:focus  {\n    background-color: darken(@btn-color, 12%);\n    background-position: 0 -15px;\n  }\n\n  &:active,\n  &.active {\n    background-color: darken(@btn-color, 12%);\n    border-color: darken(@btn-color, 14%);\n  }\n}\n\n// Common styles\n.btn {\n  // Remove the gradient for the pressed/active state\n  &:active,\n  &.active {\n    background-image: none;\n  }\n}\n\n// Apply the mixin to the buttons\n.btn-default { .btn-styles(@btn-default-bg); text-shadow: 0 1px 0 #fff; border-color: #ccc; }\n.btn-primary { .btn-styles(@btn-primary-bg); }\n.btn-success { .btn-styles(@btn-success-bg); }\n.btn-info    { .btn-styles(@btn-info-bg); }\n.btn-warning { .btn-styles(@btn-warning-bg); }\n.btn-danger  { .btn-styles(@btn-danger-bg); }\n\n\n\n//\n// Images\n// --------------------------------------------------\n\n.thumbnail,\n.img-thumbnail {\n  .box-shadow(0 1px 2px rgba(0,0,0,.075));\n}\n\n\n\n//\n// Dropdowns\n// --------------------------------------------------\n\n.dropdown-menu > li > a:hover,\n.dropdown-menu > li > a:focus {\n  #gradient > .vertical(@start-color: @dropdown-link-hover-bg; @end-color: darken(@dropdown-link-hover-bg, 5%));\n  background-color: darken(@dropdown-link-hover-bg, 5%);\n}\n.dropdown-menu > .active > a,\n.dropdown-menu > .active > a:hover,\n.dropdown-menu > .active > a:focus {\n  #gradient > .vertical(@start-color: @dropdown-link-active-bg; @end-color: darken(@dropdown-link-active-bg, 5%));\n  background-color: darken(@dropdown-link-active-bg, 5%);\n}\n\n\n\n//\n// Navbar\n// --------------------------------------------------\n\n// Default navbar\n.navbar-default {\n  #gradient > .vertical(@start-color: lighten(@navbar-default-bg, 10%); @end-color: @navbar-default-bg);\n  .reset-filter(); // Remove gradient in IE<10 to fix bug where dropdowns don't get triggered\n  border-radius: @navbar-border-radius;\n  @shadow: inset 0 1px 0 rgba(255,255,255,.15), 0 1px 5px rgba(0,0,0,.075);\n  .box-shadow(@shadow);\n\n  .navbar-nav > .active > a {\n    #gradient > .vertical(@start-color: darken(@navbar-default-bg, 5%); @end-color: darken(@navbar-default-bg, 2%));\n    .box-shadow(inset 0 3px 9px rgba(0,0,0,.075));\n  }\n}\n.navbar-brand,\n.navbar-nav > li > a {\n  text-shadow: 0 1px 0 rgba(255,255,255,.25);\n}\n\n// Inverted navbar\n.navbar-inverse {\n  #gradient > .vertical(@start-color: lighten(@navbar-inverse-bg, 10%); @end-color: @navbar-inverse-bg);\n  .reset-filter(); // Remove gradient in IE<10 to fix bug where dropdowns don't get triggered\n\n  .navbar-nav > .active > a {\n    #gradient > .vertical(@start-color: @navbar-inverse-bg; @end-color: lighten(@navbar-inverse-bg, 2.5%));\n    .box-shadow(inset 0 3px 9px rgba(0,0,0,.25));\n  }\n\n  .navbar-brand,\n  .navbar-nav > li > a {\n    text-shadow: 0 -1px 0 rgba(0,0,0,.25);\n  }\n}\n\n// Undo rounded corners in static and fixed navbars\n.navbar-static-top,\n.navbar-fixed-top,\n.navbar-fixed-bottom {\n  border-radius: 0;\n}\n\n\n\n//\n// Alerts\n// --------------------------------------------------\n\n// Common styles\n.alert {\n  text-shadow: 0 1px 0 rgba(255,255,255,.2);\n  @shadow: inset 0 1px 0 rgba(255,255,255,.25), 0 1px 2px rgba(0,0,0,.05);\n  .box-shadow(@shadow);\n}\n\n// Mixin for generating new styles\n.alert-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 7.5%));\n  border-color: darken(@color, 15%);\n}\n\n// Apply the mixin to the alerts\n.alert-success    { .alert-styles(@alert-success-bg); }\n.alert-info       { .alert-styles(@alert-info-bg); }\n.alert-warning    { .alert-styles(@alert-warning-bg); }\n.alert-danger     { .alert-styles(@alert-danger-bg); }\n\n\n\n//\n// Progress bars\n// --------------------------------------------------\n\n// Give the progress background some depth\n.progress {\n  #gradient > .vertical(@start-color: darken(@progress-bg, 4%); @end-color: @progress-bg)\n}\n\n// Mixin for generating new styles\n.progress-bar-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 10%));\n}\n\n// Apply the mixin to the progress bars\n.progress-bar            { .progress-bar-styles(@progress-bar-bg); }\n.progress-bar-success    { .progress-bar-styles(@progress-bar-success-bg); }\n.progress-bar-info       { .progress-bar-styles(@progress-bar-info-bg); }\n.progress-bar-warning    { .progress-bar-styles(@progress-bar-warning-bg); }\n.progress-bar-danger     { .progress-bar-styles(@progress-bar-danger-bg); }\n\n\n\n//\n// List groups\n// --------------------------------------------------\n\n.list-group {\n  border-radius: @border-radius-base;\n  .box-shadow(0 1px 2px rgba(0,0,0,.075));\n}\n.list-group-item.active,\n.list-group-item.active:hover,\n.list-group-item.active:focus {\n  text-shadow: 0 -1px 0 darken(@list-group-active-bg, 10%);\n  #gradient > .vertical(@start-color: @list-group-active-bg; @end-color: darken(@list-group-active-bg, 7.5%));\n  border-color: darken(@list-group-active-border, 7.5%);\n}\n\n\n\n//\n// Panels\n// --------------------------------------------------\n\n// Common styles\n.panel {\n  .box-shadow(0 1px 2px rgba(0,0,0,.05));\n}\n\n// Mixin for generating new styles\n.panel-heading-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 5%));\n}\n\n// Apply the mixin to the panel headings only\n.panel-default > .panel-heading   { .panel-heading-styles(@panel-default-heading-bg); }\n.panel-primary > .panel-heading   { .panel-heading-styles(@panel-primary-heading-bg); }\n.panel-success > .panel-heading   { .panel-heading-styles(@panel-success-heading-bg); }\n.panel-info > .panel-heading      { .panel-heading-styles(@panel-info-heading-bg); }\n.panel-warning > .panel-heading   { .panel-heading-styles(@panel-warning-heading-bg); }\n.panel-danger > .panel-heading    { .panel-heading-styles(@panel-danger-heading-bg); }\n\n\n\n//\n// Wells\n// --------------------------------------------------\n\n.well {\n  #gradient > .vertical(@start-color: darken(@well-bg, 5%); @end-color: @well-bg);\n  border-color: darken(@well-bg, 10%);\n  @shadow: inset 0 1px 3px rgba(0,0,0,.05), 0 1px 0 rgba(255,255,255,.1);\n  .box-shadow(@shadow);\n}\n","thumbnails.less":"//\n// Thumbnails\n// --------------------------------------------------\n\n\n// Mixin and adjust the regular image class\n.thumbnail {\n  display: block;\n  padding: @thumbnail-padding;\n  margin-bottom: @line-height-computed;\n  line-height: @line-height-base;\n  background-color: @thumbnail-bg;\n  border: 1px solid @thumbnail-border;\n  border-radius: @thumbnail-border-radius;\n  .transition(all .2s ease-in-out);\n\n  > img,\n  a > img {\n    &:extend(.img-responsive);\n    margin-left: auto;\n    margin-right: auto;\n  }\n\n  // Add a hover state for linked versions only\n  a&:hover,\n  a&:focus,\n  a&.active {\n    border-color: @link-color;\n  }\n\n  // Image captions\n  .caption {\n    padding: @thumbnail-caption-padding;\n    color: @thumbnail-caption-color;\n  }\n}\n","tooltip.less":"//\n// Tooltips\n// --------------------------------------------------\n\n\n// Base class\n.tooltip {\n  position: absolute;\n  z-index: @zindex-tooltip;\n  display: block;\n  visibility: visible;\n  font-size: @font-size-small;\n  line-height: 1.4;\n  .opacity(0);\n\n  &.in     { .opacity(@tooltip-opacity); }\n  &.top    { margin-top:  -3px; padding: @tooltip-arrow-width 0; }\n  &.right  { margin-left:  3px; padding: 0 @tooltip-arrow-width; }\n  &.bottom { margin-top:   3px; padding: @tooltip-arrow-width 0; }\n  &.left   { margin-left: -3px; padding: 0 @tooltip-arrow-width; }\n}\n\n// Wrapper for the tooltip content\n.tooltip-inner {\n  max-width: @tooltip-max-width;\n  padding: 3px 8px;\n  color: @tooltip-color;\n  text-align: center;\n  text-decoration: none;\n  background-color: @tooltip-bg;\n  border-radius: @border-radius-base;\n}\n\n// Arrows\n.tooltip-arrow {\n  position: absolute;\n  width: 0;\n  height: 0;\n  border-color: transparent;\n  border-style: solid;\n}\n.tooltip {\n  &.top .tooltip-arrow {\n    bottom: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-left .tooltip-arrow {\n    bottom: 0;\n    left: @tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-right .tooltip-arrow {\n    bottom: 0;\n    right: @tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.right .tooltip-arrow {\n    top: 50%;\n    left: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-right-color: @tooltip-arrow-color;\n  }\n  &.left .tooltip-arrow {\n    top: 50%;\n    right: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-left-color: @tooltip-arrow-color;\n  }\n  &.bottom .tooltip-arrow {\n    top: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    top: 0;\n    left: @tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    top: 0;\n    right: @tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n}\n","type.less":"//\n// Typography\n// --------------------------------------------------\n\n\n// Headings\n// -------------------------\n\nh1, h2, h3, h4, h5, h6,\n.h1, .h2, .h3, .h4, .h5, .h6 {\n  font-family: @headings-font-family;\n  font-weight: @headings-font-weight;\n  line-height: @headings-line-height;\n  color: @headings-color;\n\n  small,\n  .small {\n    font-weight: normal;\n    line-height: 1;\n    color: @headings-small-color;\n  }\n}\n\nh1, .h1,\nh2, .h2,\nh3, .h3 {\n  margin-top: @line-height-computed;\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 65%;\n  }\n}\nh4, .h4,\nh5, .h5,\nh6, .h6 {\n  margin-top: (@line-height-computed / 2);\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 75%;\n  }\n}\n\nh1, .h1 { font-size: @font-size-h1; }\nh2, .h2 { font-size: @font-size-h2; }\nh3, .h3 { font-size: @font-size-h3; }\nh4, .h4 { font-size: @font-size-h4; }\nh5, .h5 { font-size: @font-size-h5; }\nh6, .h6 { font-size: @font-size-h6; }\n\n\n// Body text\n// -------------------------\n\np {\n  margin: 0 0 (@line-height-computed / 2);\n}\n\n.lead {\n  margin-bottom: @line-height-computed;\n  font-size: floor((@font-size-base * 1.15));\n  font-weight: 200;\n  line-height: 1.4;\n\n  @media (min-width: @screen-sm-min) {\n    font-size: (@font-size-base * 1.5);\n  }\n}\n\n\n// Emphasis & misc\n// -------------------------\n\n// Ex: 14px base font * 85% = about 12px\nsmall,\n.small  { font-size: 85%; }\n\n// Undo browser default styling\ncite    { font-style: normal; }\n\n// Alignment\n.text-left           { text-align: left; }\n.text-right          { text-align: right; }\n.text-center         { text-align: center; }\n.text-justify        { text-align: justify; }\n\n// Contextual colors\n.text-muted {\n  color: @text-muted;\n}\n.text-primary {\n  .text-emphasis-variant(@brand-primary);\n}\n.text-success {\n  .text-emphasis-variant(@state-success-text);\n}\n.text-info {\n  .text-emphasis-variant(@state-info-text);\n}\n.text-warning {\n  .text-emphasis-variant(@state-warning-text);\n}\n.text-danger {\n  .text-emphasis-variant(@state-danger-text);\n}\n\n// Contextual backgrounds\n// For now we'll leave these alongside the text classes until v4 when we can\n// safely shift things around (per SemVer rules).\n.bg-primary {\n  // Given the contrast here, this is the only class to have its color inverted\n  // automatically.\n  color: #fff;\n  .bg-variant(@brand-primary);\n}\n.bg-success {\n  .bg-variant(@state-success-bg);\n}\n.bg-info {\n  .bg-variant(@state-info-bg);\n}\n.bg-warning {\n  .bg-variant(@state-warning-bg);\n}\n.bg-danger {\n  .bg-variant(@state-danger-bg);\n}\n\n\n// Page header\n// -------------------------\n\n.page-header {\n  padding-bottom: ((@line-height-computed / 2) - 1);\n  margin: (@line-height-computed * 2) 0 @line-height-computed;\n  border-bottom: 1px solid @page-header-border-color;\n}\n\n\n// Lists\n// --------------------------------------------------\n\n// Unordered and Ordered lists\nul,\nol {\n  margin-top: 0;\n  margin-bottom: (@line-height-computed / 2);\n  ul,\n  ol {\n    margin-bottom: 0;\n  }\n}\n\n// List options\n\n// Unstyled keeps list items block level, just removes default browser padding and list-style\n.list-unstyled {\n  padding-left: 0;\n  list-style: none;\n}\n\n// Inline turns list items into inline-block\n.list-inline {\n  .list-unstyled();\n  margin-left: -5px;\n\n  > li {\n    display: inline-block;\n    padding-left: 5px;\n    padding-right: 5px;\n  }\n}\n\n// Description Lists\ndl {\n  margin-top: 0; // Remove browser default\n  margin-bottom: @line-height-computed;\n}\ndt,\ndd {\n  line-height: @line-height-base;\n}\ndt {\n  font-weight: bold;\n}\ndd {\n  margin-left: 0; // Undo browser default\n}\n\n// Horizontal description lists\n//\n// Defaults to being stacked without any of the below styles applied, until the\n// grid breakpoint is reached (default of ~768px).\n\n@media (min-width: @grid-float-breakpoint) {\n  .dl-horizontal {\n    dt {\n      float: left;\n      width: (@component-offset-horizontal - 20);\n      clear: left;\n      text-align: right;\n      .text-overflow();\n    }\n    dd {\n      margin-left: @component-offset-horizontal;\n      &:extend(.clearfix all); // Clear the floated `dt` if an empty `dd` is present\n    }\n  }\n}\n\n// MISC\n// ----\n\n// Abbreviations and acronyms\nabbr[title],\n// Add data-* attribute to help out our tooltip plugin, per https://github.com/twbs/bootstrap/issues/5257\nabbr[data-original-title] {\n  cursor: help;\n  border-bottom: 1px dotted @abbr-border-color;\n}\n.initialism {\n  font-size: 90%;\n  text-transform: uppercase;\n}\n\n// Blockquotes\nblockquote {\n  padding: (@line-height-computed / 2) @line-height-computed;\n  margin: 0 0 @line-height-computed;\n  font-size: @blockquote-font-size;\n  border-left: 5px solid @blockquote-border-color;\n\n  p,\n  ul,\n  ol {\n    &:last-child {\n      margin-bottom: 0;\n    }\n  }\n\n  // Note: Deprecated small and .small as of v3.1.0\n  // Context: https://github.com/twbs/bootstrap/issues/11660\n  footer,\n  small,\n  .small {\n    display: block;\n    font-size: 80%; // back to default font-size\n    line-height: @line-height-base;\n    color: @blockquote-small-color;\n\n    &:before {\n      content: '\\2014 \\00A0'; // em dash, nbsp\n    }\n  }\n}\n\n// Opposite alignment of blockquote\n//\n// Heads up: `blockquote.pull-right` has been deprecated as of v3.1.0.\n.blockquote-reverse,\nblockquote.pull-right {\n  padding-right: 15px;\n  padding-left: 0;\n  border-right: 5px solid @blockquote-border-color;\n  border-left: 0;\n  text-align: right;\n\n  // Account for citation\n  footer,\n  small,\n  .small {\n    &:before { content: ''; }\n    &:after {\n      content: '\\00A0 \\2014'; // nbsp, em dash\n    }\n  }\n}\n\n// Quotes\nblockquote:before,\nblockquote:after {\n  content: \"\";\n}\n\n// Addresses\naddress {\n  margin-bottom: @line-height-computed;\n  font-style: normal;\n  line-height: @line-height-base;\n}\n","utilities.less":"//\n// Utility classes\n// --------------------------------------------------\n\n\n// Floats\n// -------------------------\n\n.clearfix {\n  .clearfix();\n}\n.center-block {\n  .center-block();\n}\n.pull-right {\n  float: right !important;\n}\n.pull-left {\n  float: left !important;\n}\n\n\n// Toggling content\n// -------------------------\n\n// Note: Deprecated .hide in favor of .hidden or .sr-only (as appropriate) in v3.0.1\n.hide {\n  display: none !important;\n}\n.show {\n  display: block !important;\n}\n.invisible {\n  visibility: hidden;\n}\n.text-hide {\n  .text-hide();\n}\n\n\n// Hide from screenreaders and browsers\n//\n// Credit: HTML5 Boilerplate\n\n.hidden {\n  display: none !important;\n  visibility: hidden !important;\n}\n\n\n// For Affix plugin\n// -------------------------\n\n.affix {\n  position: fixed;\n}\n","variables.less":"//\n// Variables\n// --------------------------------------------------\n\n\n//== Colors\n//\n//## Gray and brand colors for use across Bootstrap.\n\n@gray-darker:            lighten(#000, 13.5%); // #222\n@gray-dark:              lighten(#000, 20%);   // #333\n@gray:                   lighten(#000, 33.5%); // #555\n@gray-light:             lighten(#000, 60%);   // #999\n@gray-lighter:           lighten(#000, 93.5%); // #eee\n\n@brand-primary:         #428bca;\n@brand-success:         #5cb85c;\n@brand-info:            #5bc0de;\n@brand-warning:         #f0ad4e;\n@brand-danger:          #d9534f;\n\n\n//== Scaffolding\n//\n// ## Settings for some of the most global styles.\n\n//** Background color for `<body>`.\n@body-bg:               #fff;\n//** Global text color on `<body>`.\n@text-color:            @gray-dark;\n\n//** Global textual link color.\n@link-color:            @brand-primary;\n//** Link hover color set via `darken()` function.\n@link-hover-color:      darken(@link-color, 15%);\n\n\n//== Typography\n//\n//## Font, line-height, and color for body text, headings, and more.\n\n@font-family-sans-serif:  \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n@font-family-serif:       Georgia, \"Times New Roman\", Times, serif;\n//** Default monospace fonts for `<code>`, `<kbd>`, and `<pre>`.\n@font-family-monospace:   Menlo, Monaco, Consolas, \"Courier New\", monospace;\n@font-family-base:        @font-family-sans-serif;\n\n@font-size-base:          14px;\n@font-size-large:         ceil((@font-size-base * 1.25)); // ~18px\n@font-size-small:         ceil((@font-size-base * 0.85)); // ~12px\n\n@font-size-h1:            floor((@font-size-base * 2.6)); // ~36px\n@font-size-h2:            floor((@font-size-base * 2.15)); // ~30px\n@font-size-h3:            ceil((@font-size-base * 1.7)); // ~24px\n@font-size-h4:            ceil((@font-size-base * 1.25)); // ~18px\n@font-size-h5:            @font-size-base;\n@font-size-h6:            ceil((@font-size-base * 0.85)); // ~12px\n\n//** Unit-less `line-height` for use in components like buttons.\n@line-height-base:        1.428571429; // 20/14\n//** Computed \"line-height\" (`font-size` * `line-height`) for use with `margin`, `padding`, etc.\n@line-height-computed:    floor((@font-size-base * @line-height-base)); // ~20px\n\n//** By default, this inherits from the `<body>`.\n@headings-font-family:    inherit;\n@headings-font-weight:    500;\n@headings-line-height:    1.1;\n@headings-color:          inherit;\n\n\n//-- Iconography\n//\n//## Specify custom locations of the include Glyphicons icon font. Useful for those including Bootstrap via Bower.\n\n@icon-font-path:          \"../fonts/\";\n@icon-font-name:          \"glyphicons-halflings-regular\";\n@icon-font-svg-id:        \"glyphicons_halflingsregular\";\n\n//== Components\n//\n//## Define common padding and border radius sizes and more. Values based on 14px text and 1.428 line-height (~20px to start).\n\n@padding-base-vertical:     6px;\n@padding-base-horizontal:   12px;\n\n@padding-large-vertical:    10px;\n@padding-large-horizontal:  16px;\n\n@padding-small-vertical:    5px;\n@padding-small-horizontal:  10px;\n\n@padding-xs-vertical:       1px;\n@padding-xs-horizontal:     5px;\n\n@line-height-large:         1.33;\n@line-height-small:         1.5;\n\n@border-radius-base:        4px;\n@border-radius-large:       6px;\n@border-radius-small:       3px;\n\n//** Global color for active items (e.g., navs or dropdowns).\n@component-active-color:    #fff;\n//** Global background color for active items (e.g., navs or dropdowns).\n@component-active-bg:       @brand-primary;\n\n//** Width of the `border` for generating carets that indicator dropdowns.\n@caret-width-base:          4px;\n//** Carets increase slightly in size for larger components.\n@caret-width-large:         5px;\n\n\n//== Tables\n//\n//## Customizes the `.table` component with basic values, each used across all table variations.\n\n//** Padding for `<th>`s and `<td>`s.\n@table-cell-padding:            8px;\n//** Padding for cells in `.table-condensed`.\n@table-condensed-cell-padding:  5px;\n\n//** Default background color used for all tables.\n@table-bg:                      transparent;\n//** Background color used for `.table-striped`.\n@table-bg-accent:               #f9f9f9;\n//** Background color used for `.table-hover`.\n@table-bg-hover:                #f5f5f5;\n@table-bg-active:               @table-bg-hover;\n\n//** Border color for table and cell borders.\n@table-border-color:            #ddd;\n\n\n//== Buttons\n//\n//## For each of Bootstrap's buttons, define text, background and border color.\n\n@btn-font-weight:                normal;\n\n@btn-default-color:              #333;\n@btn-default-bg:                 #fff;\n@btn-default-border:             #ccc;\n\n@btn-primary-color:              #fff;\n@btn-primary-bg:                 @brand-primary;\n@btn-primary-border:             darken(@btn-primary-bg, 5%);\n\n@btn-success-color:              #fff;\n@btn-success-bg:                 @brand-success;\n@btn-success-border:             darken(@btn-success-bg, 5%);\n\n@btn-info-color:                 #fff;\n@btn-info-bg:                    @brand-info;\n@btn-info-border:                darken(@btn-info-bg, 5%);\n\n@btn-warning-color:              #fff;\n@btn-warning-bg:                 @brand-warning;\n@btn-warning-border:             darken(@btn-warning-bg, 5%);\n\n@btn-danger-color:               #fff;\n@btn-danger-bg:                  @brand-danger;\n@btn-danger-border:              darken(@btn-danger-bg, 5%);\n\n@btn-link-disabled-color:        @gray-light;\n\n\n//== Forms\n//\n//##\n\n//** `<input>` background color\n@input-bg:                       #fff;\n//** `<input disabled>` background color\n@input-bg-disabled:              @gray-lighter;\n\n//** Text color for `<input>`s\n@input-color:                    @gray;\n//** `<input>` border color\n@input-border:                   #ccc;\n//** `<input>` border radius\n@input-border-radius:            @border-radius-base;\n//** Border color for inputs on focus\n@input-border-focus:             #66afe9;\n\n//** Placeholder text color\n@input-color-placeholder:        @gray-light;\n\n//** Default `.form-control` height\n@input-height-base:              (@line-height-computed + (@padding-base-vertical * 2) + 2);\n//** Large `.form-control` height\n@input-height-large:             (ceil(@font-size-large * @line-height-large) + (@padding-large-vertical * 2) + 2);\n//** Small `.form-control` height\n@input-height-small:             (floor(@font-size-small * @line-height-small) + (@padding-small-vertical * 2) + 2);\n\n@legend-color:                   @gray-dark;\n@legend-border-color:            #e5e5e5;\n\n//** Background color for textual input addons\n@input-group-addon-bg:           @gray-lighter;\n//** Border color for textual input addons\n@input-group-addon-border-color: @input-border;\n\n\n//== Dropdowns\n//\n//## Dropdown menu container and contents.\n\n//** Background for the dropdown menu.\n@dropdown-bg:                    #fff;\n//** Dropdown menu `border-color`.\n@dropdown-border:                rgba(0,0,0,.15);\n//** Dropdown menu `border-color` **for IE8**.\n@dropdown-fallback-border:       #ccc;\n//** Divider color for between dropdown items.\n@dropdown-divider-bg:            #e5e5e5;\n\n//** Dropdown link text color.\n@dropdown-link-color:            @gray-dark;\n//** Hover color for dropdown links.\n@dropdown-link-hover-color:      darken(@gray-dark, 5%);\n//** Hover background for dropdown links.\n@dropdown-link-hover-bg:         #f5f5f5;\n\n//** Active dropdown menu item text color.\n@dropdown-link-active-color:     @component-active-color;\n//** Active dropdown menu item background color.\n@dropdown-link-active-bg:        @component-active-bg;\n\n//** Disabled dropdown menu item background color.\n@dropdown-link-disabled-color:   @gray-light;\n\n//** Text color for headers within dropdown menus.\n@dropdown-header-color:          @gray-light;\n\n// Note: Deprecated @dropdown-caret-color as of v3.1.0\n@dropdown-caret-color:           #000;\n\n\n//-- Z-index master list\n//\n// Warning: Avoid customizing these values. They're used for a bird's eye view\n// of components dependent on the z-axis and are designed to all work together.\n//\n// Note: These variables are not generated into the Customizer.\n\n@zindex-navbar:            1000;\n@zindex-dropdown:          1000;\n@zindex-popover:           1010;\n@zindex-tooltip:           1030;\n@zindex-navbar-fixed:      1030;\n@zindex-modal-background:  1040;\n@zindex-modal:             1050;\n\n\n//== Media queries breakpoints\n//\n//## Define the breakpoints at which your layout will change, adapting to different screen sizes.\n\n// Extra small screen / phone\n// Note: Deprecated @screen-xs and @screen-phone as of v3.0.1\n@screen-xs:                  480px;\n@screen-xs-min:              @screen-xs;\n@screen-phone:               @screen-xs-min;\n\n// Small screen / tablet\n// Note: Deprecated @screen-sm and @screen-tablet as of v3.0.1\n@screen-sm:                  768px;\n@screen-sm-min:              @screen-sm;\n@screen-tablet:              @screen-sm-min;\n\n// Medium screen / desktop\n// Note: Deprecated @screen-md and @screen-desktop as of v3.0.1\n@screen-md:                  992px;\n@screen-md-min:              @screen-md;\n@screen-desktop:             @screen-md-min;\n\n// Large screen / wide desktop\n// Note: Deprecated @screen-lg and @screen-lg-desktop as of v3.0.1\n@screen-lg:                  1200px;\n@screen-lg-min:              @screen-lg;\n@screen-lg-desktop:          @screen-lg-min;\n\n// So media queries don't overlap when required, provide a maximum\n@screen-xs-max:              (@screen-sm-min - 1);\n@screen-sm-max:              (@screen-md-min - 1);\n@screen-md-max:              (@screen-lg-min - 1);\n\n\n//== Grid system\n//\n//## Define your custom responsive grid.\n\n//** Number of columns in the grid.\n@grid-columns:              12;\n//** Padding between columns. Gets divided in half for the left and right.\n@grid-gutter-width:         30px;\n// Navbar collapse\n//** Point at which the navbar becomes uncollapsed.\n@grid-float-breakpoint:     @screen-sm-min;\n//** Point at which the navbar begins collapsing.\n@grid-float-breakpoint-max: (@grid-float-breakpoint - 1);\n\n\n//== Container sizes\n//\n//## Define the maximum width of `.container` for different screen sizes.\n\n// Small screen / tablet\n@container-tablet:             ((720px + @grid-gutter-width));\n//** For `@screen-sm-min` and up.\n@container-sm:                 @container-tablet;\n\n// Medium screen / desktop\n@container-desktop:            ((940px + @grid-gutter-width));\n//** For `@screen-md-min` and up.\n@container-md:                 @container-desktop;\n\n// Large screen / wide desktop\n@container-large-desktop:      ((1140px + @grid-gutter-width));\n//** For `@screen-lg-min` and up.\n@container-lg:                 @container-large-desktop;\n\n\n//== Navbar\n//\n//##\n\n// Basics of a navbar\n@navbar-height:                    50px;\n@navbar-margin-bottom:             @line-height-computed;\n@navbar-border-radius:             @border-radius-base;\n@navbar-padding-horizontal:        floor((@grid-gutter-width / 2));\n@navbar-padding-vertical:          ((@navbar-height - @line-height-computed) / 2);\n@navbar-collapse-max-height:       340px;\n\n@navbar-default-color:             #777;\n@navbar-default-bg:                #f8f8f8;\n@navbar-default-border:            darken(@navbar-default-bg, 6.5%);\n\n// Navbar links\n@navbar-default-link-color:                #777;\n@navbar-default-link-hover-color:          #333;\n@navbar-default-link-hover-bg:             transparent;\n@navbar-default-link-active-color:         #555;\n@navbar-default-link-active-bg:            darken(@navbar-default-bg, 6.5%);\n@navbar-default-link-disabled-color:       #ccc;\n@navbar-default-link-disabled-bg:          transparent;\n\n// Navbar brand label\n@navbar-default-brand-color:               @navbar-default-link-color;\n@navbar-default-brand-hover-color:         darken(@navbar-default-brand-color, 10%);\n@navbar-default-brand-hover-bg:            transparent;\n\n// Navbar toggle\n@navbar-default-toggle-hover-bg:           #ddd;\n@navbar-default-toggle-icon-bar-bg:        #888;\n@navbar-default-toggle-border-color:       #ddd;\n\n\n// Inverted navbar\n// Reset inverted navbar basics\n@navbar-inverse-color:                      @gray-light;\n@navbar-inverse-bg:                         #222;\n@navbar-inverse-border:                     darken(@navbar-inverse-bg, 10%);\n\n// Inverted navbar links\n@navbar-inverse-link-color:                 @gray-light;\n@navbar-inverse-link-hover-color:           #fff;\n@navbar-inverse-link-hover-bg:              transparent;\n@navbar-inverse-link-active-color:          @navbar-inverse-link-hover-color;\n@navbar-inverse-link-active-bg:             darken(@navbar-inverse-bg, 10%);\n@navbar-inverse-link-disabled-color:        #444;\n@navbar-inverse-link-disabled-bg:           transparent;\n\n// Inverted navbar brand label\n@navbar-inverse-brand-color:                @navbar-inverse-link-color;\n@navbar-inverse-brand-hover-color:          #fff;\n@navbar-inverse-brand-hover-bg:             transparent;\n\n// Inverted navbar toggle\n@navbar-inverse-toggle-hover-bg:            #333;\n@navbar-inverse-toggle-icon-bar-bg:         #fff;\n@navbar-inverse-toggle-border-color:        #333;\n\n\n//== Navs\n//\n//##\n\n//=== Shared nav styles\n@nav-link-padding:                          10px 15px;\n@nav-link-hover-bg:                         @gray-lighter;\n\n@nav-disabled-link-color:                   @gray-light;\n@nav-disabled-link-hover-color:             @gray-light;\n\n@nav-open-link-hover-color:                 #fff;\n\n//== Tabs\n@nav-tabs-border-color:                     #ddd;\n\n@nav-tabs-link-hover-border-color:          @gray-lighter;\n\n@nav-tabs-active-link-hover-bg:             @body-bg;\n@nav-tabs-active-link-hover-color:          @gray;\n@nav-tabs-active-link-hover-border-color:   #ddd;\n\n@nav-tabs-justified-link-border-color:            #ddd;\n@nav-tabs-justified-active-link-border-color:     @body-bg;\n\n//== Pills\n@nav-pills-border-radius:                   @border-radius-base;\n@nav-pills-active-link-hover-bg:            @component-active-bg;\n@nav-pills-active-link-hover-color:         @component-active-color;\n\n\n//== Pagination\n//\n//##\n\n@pagination-color:                     @link-color;\n@pagination-bg:                        #fff;\n@pagination-border:                    #ddd;\n\n@pagination-hover-color:               @link-hover-color;\n@pagination-hover-bg:                  @gray-lighter;\n@pagination-hover-border:              #ddd;\n\n@pagination-active-color:              #fff;\n@pagination-active-bg:                 @brand-primary;\n@pagination-active-border:             @brand-primary;\n\n@pagination-disabled-color:            @gray-light;\n@pagination-disabled-bg:               #fff;\n@pagination-disabled-border:           #ddd;\n\n\n//== Pager\n//\n//##\n\n@pager-bg:                             @pagination-bg;\n@pager-border:                         @pagination-border;\n@pager-border-radius:                  15px;\n\n@pager-hover-bg:                       @pagination-hover-bg;\n\n@pager-active-bg:                      @pagination-active-bg;\n@pager-active-color:                   @pagination-active-color;\n\n@pager-disabled-color:                 @pagination-disabled-color;\n\n\n//== Jumbotron\n//\n//##\n\n@jumbotron-padding:              30px;\n@jumbotron-color:                inherit;\n@jumbotron-bg:                   @gray-lighter;\n@jumbotron-heading-color:        inherit;\n@jumbotron-font-size:            ceil((@font-size-base * 1.5));\n\n\n//== Form states and alerts\n//\n//## Define colors for form feedback states and, by default, alerts.\n\n@state-success-text:             #3c763d;\n@state-success-bg:               #dff0d8;\n@state-success-border:           darken(spin(@state-success-bg, -10), 5%);\n\n@state-info-text:                #31708f;\n@state-info-bg:                  #d9edf7;\n@state-info-border:              darken(spin(@state-info-bg, -10), 7%);\n\n@state-warning-text:             #8a6d3b;\n@state-warning-bg:               #fcf8e3;\n@state-warning-border:           darken(spin(@state-warning-bg, -10), 5%);\n\n@state-danger-text:              #a94442;\n@state-danger-bg:                #f2dede;\n@state-danger-border:            darken(spin(@state-danger-bg, -10), 5%);\n\n\n//== Tooltips\n//\n//##\n\n//** Tooltip max width\n@tooltip-max-width:           200px;\n//** Tooltip text color\n@tooltip-color:               #fff;\n//** Tooltip background color\n@tooltip-bg:                  #000;\n@tooltip-opacity:             .9;\n\n//** Tooltip arrow width\n@tooltip-arrow-width:         5px;\n//** Tooltip arrow color\n@tooltip-arrow-color:         @tooltip-bg;\n\n\n//== Popovers\n//\n//##\n\n//** Popover body background color\n@popover-bg:                          #fff;\n//** Popover maximum width\n@popover-max-width:                   276px;\n//** Popover border color\n@popover-border-color:                rgba(0,0,0,.2);\n//** Popover fallback border color\n@popover-fallback-border-color:       #ccc;\n\n//** Popover title background color\n@popover-title-bg:                    darken(@popover-bg, 3%);\n\n//** Popover arrow width\n@popover-arrow-width:                 10px;\n//** Popover arrow color\n@popover-arrow-color:                 #fff;\n\n//** Popover outer arrow width\n@popover-arrow-outer-width:           (@popover-arrow-width + 1);\n//** Popover outer arrow color\n@popover-arrow-outer-color:           fadein(@popover-border-color, 5%);\n//** Popover outer arrow fallback color\n@popover-arrow-outer-fallback-color:  darken(@popover-fallback-border-color, 20%);\n\n\n//== Labels\n//\n//##\n\n//** Default label background color\n@label-default-bg:            @gray-light;\n//** Primary label background color\n@label-primary-bg:            @brand-primary;\n//** Success label background color\n@label-success-bg:            @brand-success;\n//** Info label background color\n@label-info-bg:               @brand-info;\n//** Warning label background color\n@label-warning-bg:            @brand-warning;\n//** Danger label background color\n@label-danger-bg:             @brand-danger;\n\n//** Default label text color\n@label-color:                 #fff;\n//** Default text color of a linked label\n@label-link-hover-color:      #fff;\n\n\n//== Modals\n//\n//##\n\n//** Padding applied to the modal body\n@modal-inner-padding:         20px;\n\n//** Padding applied to the modal title\n@modal-title-padding:         15px;\n//** Modal title line-height\n@modal-title-line-height:     @line-height-base;\n\n//** Background color of modal content area\n@modal-content-bg:                             #fff;\n//** Modal content border color\n@modal-content-border-color:                   rgba(0,0,0,.2);\n//** Modal content border color **for IE8**\n@modal-content-fallback-border-color:          #999;\n\n//** Modal backdrop background color\n@modal-backdrop-bg:           #000;\n//** Modal backdrop opacity\n@modal-backdrop-opacity:      .5;\n//** Modal header border color\n@modal-header-border-color:   #e5e5e5;\n//** Modal footer border color\n@modal-footer-border-color:   @modal-header-border-color;\n\n@modal-lg:                    900px;\n@modal-md:                    600px;\n@modal-sm:                    300px;\n\n\n//== Alerts\n//\n//## Define alert colors, border radius, and padding.\n\n@alert-padding:               15px;\n@alert-border-radius:         @border-radius-base;\n@alert-link-font-weight:      bold;\n\n@alert-success-bg:            @state-success-bg;\n@alert-success-text:          @state-success-text;\n@alert-success-border:        @state-success-border;\n\n@alert-info-bg:               @state-info-bg;\n@alert-info-text:             @state-info-text;\n@alert-info-border:           @state-info-border;\n\n@alert-warning-bg:            @state-warning-bg;\n@alert-warning-text:          @state-warning-text;\n@alert-warning-border:        @state-warning-border;\n\n@alert-danger-bg:             @state-danger-bg;\n@alert-danger-text:           @state-danger-text;\n@alert-danger-border:         @state-danger-border;\n\n\n//== Progress bars\n//\n//##\n\n//** Background color of the whole progress component\n@progress-bg:                 #f5f5f5;\n//** Progress bar text color\n@progress-bar-color:          #fff;\n\n//** Default progress bar color\n@progress-bar-bg:             @brand-primary;\n//** Success progress bar color\n@progress-bar-success-bg:     @brand-success;\n//** Warning progress bar color\n@progress-bar-warning-bg:     @brand-warning;\n//** Danger progress bar color\n@progress-bar-danger-bg:      @brand-danger;\n//** Info progress bar color\n@progress-bar-info-bg:        @brand-info;\n\n\n//== List group\n//\n//##\n\n//** Background color on `.list-group-item`\n@list-group-bg:                 #fff;\n//** `.list-group-item` border color\n@list-group-border:             #ddd;\n//** List group border radius\n@list-group-border-radius:      @border-radius-base;\n\n//** Background color of single list elements on hover\n@list-group-hover-bg:           #f5f5f5;\n//** Text color of active list elements\n@list-group-active-color:       @component-active-color;\n//** Background color of active list elements\n@list-group-active-bg:          @component-active-bg;\n//** Border color of active list elements\n@list-group-active-border:      @list-group-active-bg;\n@list-group-active-text-color:  lighten(@list-group-active-bg, 40%);\n\n@list-group-link-color:         #555;\n@list-group-link-heading-color: #333;\n\n\n//== Panels\n//\n//##\n\n@panel-bg:                    #fff;\n@panel-body-padding:          15px;\n@panel-border-radius:         @border-radius-base;\n\n//** Border color for elements within panels\n@panel-inner-border:          #ddd;\n@panel-footer-bg:             #f5f5f5;\n\n@panel-default-text:          @gray-dark;\n@panel-default-border:        #ddd;\n@panel-default-heading-bg:    #f5f5f5;\n\n@panel-primary-text:          #fff;\n@panel-primary-border:        @brand-primary;\n@panel-primary-heading-bg:    @brand-primary;\n\n@panel-success-text:          @state-success-text;\n@panel-success-border:        @state-success-border;\n@panel-success-heading-bg:    @state-success-bg;\n\n@panel-info-text:             @state-info-text;\n@panel-info-border:           @state-info-border;\n@panel-info-heading-bg:       @state-info-bg;\n\n@panel-warning-text:          @state-warning-text;\n@panel-warning-border:        @state-warning-border;\n@panel-warning-heading-bg:    @state-warning-bg;\n\n@panel-danger-text:           @state-danger-text;\n@panel-danger-border:         @state-danger-border;\n@panel-danger-heading-bg:     @state-danger-bg;\n\n\n//== Thumbnails\n//\n//##\n\n//** Padding around the thumbnail image\n@thumbnail-padding:           4px;\n//** Thumbnail background color\n@thumbnail-bg:                @body-bg;\n//** Thumbnail border color\n@thumbnail-border:            #ddd;\n//** Thumbnail border radius\n@thumbnail-border-radius:     @border-radius-base;\n\n//** Custom text color for thumbnail captions\n@thumbnail-caption-color:     @text-color;\n//** Padding around the thumbnail caption\n@thumbnail-caption-padding:   9px;\n\n\n//== Wells\n//\n//##\n\n@well-bg:                     #f5f5f5;\n@well-border:                 darken(@well-bg, 7%);\n\n\n//== Badges\n//\n//##\n\n@badge-color:                 #fff;\n//** Linked badge text color on hover\n@badge-link-hover-color:      #fff;\n@badge-bg:                    @gray-light;\n\n//** Badge text color in active nav link\n@badge-active-color:          @link-color;\n//** Badge background color in active nav link\n@badge-active-bg:             #fff;\n\n@badge-font-weight:           bold;\n@badge-line-height:           1;\n@badge-border-radius:         10px;\n\n\n//== Breadcrumbs\n//\n//##\n\n@breadcrumb-padding-vertical:   8px;\n@breadcrumb-padding-horizontal: 15px;\n//** Breadcrumb background color\n@breadcrumb-bg:                 #f5f5f5;\n//** Breadcrumb text color\n@breadcrumb-color:              #ccc;\n//** Text color of current page in the breadcrumb\n@breadcrumb-active-color:       @gray-light;\n//** Textual separator for between breadcrumb elements\n@breadcrumb-separator:          \"/\";\n\n\n//== Carousel\n//\n//##\n\n@carousel-text-shadow:                        0 1px 2px rgba(0,0,0,.6);\n\n@carousel-control-color:                      #fff;\n@carousel-control-width:                      15%;\n@carousel-control-opacity:                    .5;\n@carousel-control-font-size:                  20px;\n\n@carousel-indicator-active-bg:                #fff;\n@carousel-indicator-border-color:             #fff;\n\n@carousel-caption-color:                      #fff;\n\n\n//== Close\n//\n//##\n\n@close-font-weight:           bold;\n@close-color:                 #000;\n@close-text-shadow:           0 1px 0 #fff;\n\n\n//== Code\n//\n//##\n\n@code-color:                  #c7254e;\n@code-bg:                     #f9f2f4;\n\n@kbd-color:                   #fff;\n@kbd-bg:                      #333;\n\n@pre-bg:                      #f5f5f5;\n@pre-color:                   @gray-dark;\n@pre-border-color:            #ccc;\n@pre-scrollable-max-height:   340px;\n\n\n//== Type\n//\n//##\n\n//** Text muted color\n@text-muted:                  @gray-light;\n//** Abbreviations and acronyms border color\n@abbr-border-color:           @gray-light;\n//** Headings small color\n@headings-small-color:        @gray-light;\n//** Blockquote small color\n@blockquote-small-color:      @gray-light;\n//** Blockquote font size\n@blockquote-font-size:        (@font-size-base * 1.25);\n//** Blockquote border color\n@blockquote-border-color:     @gray-lighter;\n//** Page header border color\n@page-header-border-color:    @gray-lighter;\n\n\n//== Miscellaneous\n//\n//##\n\n//** Horizontal line color.\n@hr-border:                   @gray-lighter;\n\n//** Horizontal offset for forms and lists.\n@component-offset-horizontal: 180px;\n","wells.less":"//\n// Wells\n// --------------------------------------------------\n\n\n// Base class\n.well {\n  min-height: 20px;\n  padding: 19px;\n  margin-bottom: 20px;\n  background-color: @well-bg;\n  border: 1px solid @well-border;\n  border-radius: @border-radius-base;\n  .box-shadow(inset 0 1px 1px rgba(0,0,0,.05));\n  blockquote {\n    border-color: #ddd;\n    border-color: rgba(0,0,0,.15);\n  }\n}\n\n// Sizes\n.well-lg {\n  padding: 24px;\n  border-radius: @border-radius-large;\n}\n.well-sm {\n  padding: 9px;\n  border-radius: @border-radius-small;\n}\n"}
var __fonts = {"glyphicons-halflings-regular.eot":"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","glyphicons-halflings-regular.svg":"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","glyphicons-halflings-regular.ttf":"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","glyphicons-halflings-regular.woff":"d09GRgABAAAAAFsYABEAAAAAoUAAAQAAAAAAAAAAAAAAAAAAAAAAAAAAAABGRlRNAAABgAAAABwAAAAcalXC8EdERUYAAAGcAAAAHgAAACABCAAET1MvMgAAAbwAAABDAAAAYGenS4RjbWFwAAACAAAAARsAAAJySvAJmmN2dCAAAAMcAAAACAAAAAgAKAOHZnBnbQAAAyQAAAGxAAACZVO0L6dnYXNwAAAE2AAAAAgAAAAIAAAAEGdseWYAAATgAABODAAAiTweHjMhaGVhZAAAUuwAAAA0AAAANgJiWP5oaGVhAABTIAAAABwAAAAkCjIED2htdHgAAFM8AAABFAAAAvTBwRGObG9jYQAAVFAAAAGrAAABuDSPVk5tYXhwAABV/AAAACAAAAAgAgQBoG5hbWUAAFYcAAABggAAA3zUr5ntcG9zdAAAV6AAAANAAAAIhLlGpmlwcmVwAABa4AAAAC4AAAAusPIrFHdlYmYAAFsQAAAABgAAAAZYr1LmAAAAAQAAAADMPaLPAAAAAM8MFvIAAAAAzwwJLnjaY2BkYGDgA2IJBhBgYmAEwltAzALmMQAADagBDQAAeNpjYGZpZJzAwMrAwszDdIGBgSEKQjMuYTBi2gHkA6Wwg1DvcD8GBwbeRwzMB/4LANVJMNQAhRmRlCgwMAIAC2EJ1gB42s2RP0vDYBDG723aSIrSUESsiHcIWqqDXbvFRe0gBJw6tTgUCx2Kk926dusixc0P4OiXaQZzjx2cnNRFhPiagENdHBx84P693P0O7iUihzLbJGM9mb6tTFrnTWhjSAEVyLfZCgnt060U5UDacrdd3vnYNVWvWlJHPa1oTRva1JZ2tKdDHesUHiqooYEjNNFCD0OMcY2bR0qSr10pcc8S6QfRaEF9Fa1roKElnutARzqBgQ9BHQFOEKKDAUaYYJoSTfKWzJMo6epSPI/v44sHJ9qI1malWVEqsi5lWRZXiN/5lV/4mZ8YfMWX3Ocud7jNLT7jUz7mQw62ouwafyvj0jfW5KzLLTZkX5EpX6B/LXfxYfU3U5+Pg2iWAAAAAI8AKAL4eNpdUbtOW0EQ3Q0PA4HE2CA52hSzmZDGe6EFCcTVjWJkO4XlCGk3cpGLcQEfQIFEDdqvGaChpEibBiEXSHxCPiESM2uIojQ7O7NzzpkzS8qRqnfpa89T5ySQwt0GzTb9Tki1swD3pOvrjYy0gwdabGb0ynX7/gsGm9GUO2oA5T1vKQ8ZTTuBWrSn/tH8Cob7/B/zOxi0NNP01DoJ6SEE5ptxS4PvGc26yw/6gtXhYjAwpJim4i4/plL+tzTnasuwtZHRvIMzEfnJNEBTa20Emv7UIdXzcRRLkMumsTaYmLL+JBPBhcl0VVO1zPjawV2ys+hggyrNgQfYw1Z5DB4ODyYU0rckyiwNEfZiq8QIEZMcCjnl3Mn+pED5SBLGvElKO+OGtQbGkdfAoDZPs/88m01tbx3C+FkcwXe/GUs6+MiG2hgRYjtiKYAJREJGVfmGGs+9LAbkUvvPQJSA5fGPf50ItO7YRDyXtXUOMVYIen7b3PLLirtWuc6LQndvqmqo0inN+17OvscDnh4Lw0FjwZvP+/5Kgfo8LK40aA4EQ3o3ev+iteqIq7wXPrIn07+xWgAAAAABAAH//wAPeNq9vQlgG+WVADzfzEijWxpJo5FkS7IkS/IpxZJlxfGR4Nx3yM2dgIBCOMIVrhAghXK0CYZCKA0tKSyQco6UUNpu2G3pwoq26hnSQrcsvVhajm0hu90m8fC/981Ilu0Eyu7//3EkzSXNe+973/vePQzLtDEM+QzXwnCMwKRLhMkMlgWefS9bMhr+bbDMsbDJlDg8bMDDZcHIHRssEzyeE6NiIifG28gs9e0//5lrOfZmG/sThjBFpsgv4ZcwMtPKKExGsecUUlWsWaL4M4rnkGLIKu6qImRLAdLJTOvx5KOpgizmxIIsRKWoLKTEuCikCkXCPb/j+Qq8CKeO1TYPTzqgjtHLAA0G/tH7WplFTNnCMJ14c4He3JAtE8bSuW8W4cydRLFlFMshhc0q5qrCZ8tmC54yC+bOssWMmxbG3FmyU+gCJCrW/sgo6SKj6mb14PiWupmMUpwN/Bf4Z5gCs4VRshmlrVpuy+JPtaXNFI4ohSOSVQwZpTmnGKtKMKtIGcVaLUtWvFByIWTTM0qBQharlkKRLHy6St2kU3FllXRVcWZL/aSzFCuIbkXoV7rFsrUl29/fj1Qs5HoL8UKur9CXy8o+Od6bZuMxBytEhahRgrcwn8sOs/mcUTDGY6k0SRWLlxleL96WWHzV/g82Dxqfyy1ZFPb3z5npIdcX1YNGsgvezdP6Z+ek0KIluWciGzc9Xr26dcRGDhcz+eLjp+544fwLC+unBbxdpw4X033FRVeOdDqD09bln7rwqq+mn7yGwTGpkFF+CXsA+MtNeYGrEoXPlAzayANRK9wtx7YiORlGH8Pavx7Y/+gD0sW/yJ/ESEyEUbiM4qjCmBHFlynJ8BMlMye6S1axv39aD+f15aLZvt5kPCakSTxmlLyygzguW86+f80TT1yT7up67pIv/ZIdWUPeX3H50x885dh49S8eCNgcm5Bt4FXkFeAdHuaBhbEzTJ7IBZIQzQYY9QpgcXQF6VIPsuvZ9TD6XUU8qG6u0L3DY4+yp6k20jW2F36H++jDjz7kX+BfYFjGyLgYRkgAexN4Ffp6MyQZE+xk6b+feog979DaQ+fY7Q84W532zf9+snbgdHvK8YDdXqMFwKQwZibHlI3Iz0JV4WAaWTKK6RCQssyZkHM4AzCuicNNkxEY10qJK0aJCNMpHxV5BYE79iaQUhl7fez1YpFN4u87GBPMl2eZFoZJhklhmOTFhJgUHETW93qTgsFBJDhm5FtvX34SID9r0fJ1bvfty+etcljGXBYH7H/+kvagtKGDPXP32F9dcvDyvkJ7QD65wF1msXLf5TyWseWiP8AANeSP3uX/hX+A8TBNzClM2YEYuTOKXFWaNMZozijkkCJVFcmFskExwBwAdg9Ionsfx7rcrXK/YhCB85mS2wFTwNyvyKLi6lea3PsIIxjg/LQetwsQkrwC8XmdxBhLEWB31uVr6XMlW2TSDKzWvIx0CcLFJq9JPXj1zspnXyTu735XfZ+8h+fU31d2Xq0ehJMXCwLpWsZepP75xe/CFRp/Fpn1/LP8HCYAHEmUYEZhDiFPOqqlJo2le4fZMJHhjZW8Dk5I88Xpp1599bVd066/5qr1fbOvvWXv8PDjt1w7m3PN2rKqm184Z+4CvnvVlln91950Y3nNmvKNN10LtProm8x8/j4YewtjA5aKenKeKPGYiYcrLCD/fg97D/mluv1u9SZ1+z33slwLFUV/UmcSj/oe+Wf4pHzY+Bs+xs8odhC/VAzxwERypuSnIE/4dY8sFORUIZ4Spt5n9r8s/M73Fn33naXLjnNH9sqdv/3Cjj984ec/n8C7HpjHeZKPJYdIb1/WFyJeY1wiEhlNzFT+R5mZIKN3EVK8L1fZqihbK7n7iupHdzE4/+j3l9B1yco44Xdk4JoIE2dSTCeTgRmhMGUGOYivlvwtICiFjBLLKaaq0ppVrBklmVNsVaUtqzgzSkdOcVWVrqziySjpnOKtKtOyiH84m0NyEKWXjiNf3WeyubytclbhXSii9pntooS7/qrSDO8aV4aySkt1X2tb1zQ81eIqReHKRHt3D+5y1VIeBZPNCoIp2NTfrzjFUnMIBVQPXS/z8fykF0pBmKVRcpxzvHJ0f7H+D8TN2F76OjB+kF/SeAnKUhBOx7bWjzC6fNPWRifQMMPMZEaYsh2p15UDtJFkoYwySEnTC7wxi9LDRddHP7y7Si2AOBCtvapMz5ZOonwD8qEPJK5PEmFMo7FkgEzcJ59wPgRcIIVCkroZ38e32fUnOpNtOMxe3LAz9sKJzjAgPSfjvpw5i7mUuZG5C9ZqSoXS4EU5pEOpt5hFSpSWbM0hLUpzroT97kzp9C/Afmu1tPqWLFBnFKlTciHTmYH52rKUQtNAUs1aAdv91dKC9fjpKm2AY5tvgu0LqqVrbs9mS3dTyuFcGCDabOgksaSY//h9kv//9vqQVEGCneCNjP7fzmfre+TR420e+6//6wWwztbkReMYr9V5fJDyeC+d/ktySnNVmYOjqpyOY6qshhHdMGFE5ROMaGnj8UfP64PdPjichF2jNPk8jgbyPZV9UY36H7f/ydRmD+DO2Bx8P/52I83Hv/0pKIoyPMTE+A/4DsbAMLA4pEgqRB7hsgfHvvYj8rJ6OtcLWz/G6y5kLuTn8fNATuN1BTORzUQwkwtJUH3rIAmS4EH1LfoGH8MT9w/iNbBWTdANUszzE7QDUAviOSVUVaLZcnMI1ZzmJGg8oWbcDEVAv9b1h7YG/SEJAiucVRJVpSVbTiTx0kQcvpVM4GayGb6VqGsZ7TDSSdAyyqwPRHa/khAVd78SAK1DdgUbtA7ZDVqHq78UAu1jH2OQ/HiuSSx7A6S//xN0Dw7keU7KSXEpnv9YPWResQKi/hO0EfUUvAile412X6a0izBnHE+zapmqWUV1zeo51KyaQx+jWz2HulVz+BO1Kw6WsY/HDLUG8r6O2I5r1VcFH1xlqiH2InG9CIhRXZGR+QdAf2iC1X4ug4ajBdDoouuSUC0L1JgTwJhTBFfJBhh5qmWbBw/awI5Ck6lkE2CQZH9zHACnmpm7IIE26wVg873JVN7nBg2NjaVZok1g1HfpBJZ/9vj5W4+Qs49sPf/xn522+9V3X919Gvl1SCri7CjiAvU8aRt+rFC5pnTkSOmaSuGxYfWXz2+Bq+BiYhtfs2DdLTIE5FKprsdMY8o8rjgmWy5HFFdG4REfRMIESFjBTNbQcVZLIpU2BbCwCRjHtb8iGCNdFRj6CkGDhBxWbWh5g6KwAukWZJr4XfwuZj5zMnM2g0ywoqoszih9QL2VlHoLqsoCV2kp3AMWtFVApwUM2lBDwPZLxX1OKdePrNDqLgUyYFiWVgDLlwRQYJTF4j4umpqLZ/vcpc6TkOE93gjrixDBJxdkH2zmsjPZvplE7iukCn2wme/NsMkMKSRTQioJm/GYkzU6ScooyIIRNg2oFEpeYywZNN7POvzciu7BWw3dPYZkW6wpkzSmM4bPTZ+2gvM7yZcMhi8Rl8yt6Br8nKF7mlG7wpDtMtw6kF7BBezs/UZy/rbyNvjPnhJtTxp7ugyfG0ifzAXhlMFwP2sPcid3DX3O0NWDX27uThpzHYbPzciczAUc2s87AtzJmRmfM2TSxuS0wPpt29afsm0byEKBKX70Ea8YvKD3j2ugBeYOphzFudYK1v603iwsFalMuSPblwN1oakKKiYqFY4uOJ7JULsVzPvgIVx1Wl2lBM7DrNKGmmk50UYlFAMM3eZCeaRMAy3VVeqBre6s0ltV7Nlybw9e1OuBi3pdqGeCUESHAHWi4CJSX0kalhMPqJ3aFrKSB16obnr07aLTQjwD7aSrfYB4LE6H9ehbVkeRu2WgfWxO+0CRyhjkM03a8CRrcRbbBwba4XtZq8Nx7BJkvvbBwXb2wNgc9gBYxkf3a5uavQR/Bon/NdggXUzZTPV14HvQz82HUFc3UT0bqQRMXzKYQPAQOlnNJF5zurCj7C0V9SD+saewt4xtHduLcoRdj/yOAvBtkBMORmRiTBmMpU6CXA/SzlgtGwkSzGgCieDRZhPVSesUISIpOqzkV2TUYT32jNXBriddAX6b1aHaxs4A9Dg34o4ylmd4/in+KZjDHuCB7Qza4M6q4kUhW5a9eBtZgnHx4JBTwxAgsMOouUpeQHD8ogBcJLtwcsO8R6Ox5LWDnLJwDg/MrJIow46Zd6Kty5S8TtgTGLsLT3nwlJGINl0Qu1tbeLeL5Vta3boA9qCEkPg9xE3mEPeePer76gH1fd+HZO2HH6pPzAeR8Y3GE3v2sGepT3yIp8dUIOlBaiuwHz3IMAYv0BTlVVq3soQcYgwWlTNDHQ9O6nggZmRhlGO6tIqTHAd/JMrFOU+OixfJsz+VHvb+hDw79lb7B209bzY9wSvoQDm6gq4FhzW/D6vr6No9FzFlK95TuxuYICQ7LirLvIC35hlN9NuBjhYqK0sCD5KKNYOksosgX6lXDL0g6KcEiKjtRf6kvoHyU30Dtn7z7LPUjwciFP14lSKMM/Ar2PfPAhQyE2bO0TVID53LBhjYCB1YsaqI2kIKymSzqyTBFiiOLbikiqJ7v513y1Q3aBaVcL8iuffbDB5fiI6p7IE1l5jMTFBfUXuH2WyYpUsRqY0kR4U9R87a88bhN/acpX2c/gFZ/cEH6lMrdlV2HSENJ+CDZdWnPsDzKp2uwLQTeTbIbKzxrM6iTQ0sipiAjeuv82UzYgJ8uR/50ouY+EVF6lfgCDKnj2LicSImRoGhetDxWZJrgokcF0/Ek8uPHNl1Yq5Uz9ZwoUzC1n0KiE+7Lk2AR1xUsWcBJW8GRwKMbzOocjxxUJ0sL3qiTTVZmJOjhRwXrXAt/0pA1m23OiqVLOnKVjaOPRwgv0LJpSZg4pO3YJk9PIGGEuNn5jXMe6RhgNIQYLDVKRcEyok2IAxvtnA+f30aU0L55CmE8uj6SAvMbMOJyPQhmUHaJ5OJ7IcRf+pJOH8nubsCnFvTmZqZVQy6mWFsxYwSADhDFE6A2+kqWTReDQOcFoTLwHu8cgCH2CyWJB+u+SKOPGHMXgkPB0SFAu0Ns+hAjnuNLUkXOpmFqCjAiu4gsq4k7TqifhU0otsvuYeM3v2Vl0EjYn/0rqYWbQFVCTSqk/HMdaftZjQdj6Hwupgocx1TFnE8YX75qmVfBOe4Lwhz3I7zrmw34AE7gy7ymOacgIHXGDdYLcUBGReqMaK7HwF+XjBYLaCbRBH+oLtkNiFavggsL1EqHsx4nQGd6JrLDrApiNFCEt3GnBgVQJHpy+dgTsZjKcRuy8tfuVvd/MXNt5WOLCSj9HOXdphdj4rfdXh2xZESLk34SY8xsOoVdZ49nh9rBaOYMoo/hyIumMWgRHMOBy2URWnXkkMxE80ir7XmUHdPZKmJYzpUtrm8qGxYq2WH2wdbqDCAtMOVDZf7BBgaqYaXBxb8IRKVEnntpfmMuFuOvVlzEqEMHH+h1wnd8tryr/0f21us7zbIa9SHQF7LOHYtmo7TCiN2CEalbAjioBlQUgdduNQpDgC4CQ86QIdBBYgpteCqxjsMQToz0Kc0MG4w5xq8SaDcaOo5KB9bVpKulVuoInJsK2guIMWp3Vpk17cPVFZu2bKyAgrMXjjP/mEX1cR1XYH6gTiYy7K2rmEkAbmJq9J4ApAQ5K5nmITZYVIQHSTNGQVAe/C2a7ZefmGxve36W0Zvu/JUL9KPjA5Os0ebDMtPJodPnmtpa7PMPRnJwuly6n7g6h7mJOZ8ppxB6gznlGRV6aPjHAIyjei2DK5iMaBNZ1XpdJWysDVQVQZcJRdVG0qzgbWznUAjmzXUTKVJMgOzU3B5vBxytw3WOifKObFuxQyTljCRxvfTbMzBSh5Rc0sgQdEtkZi077CCQrfj98T4+x1085xH3nj7jUfOqdhMe0w2+sauH98mHpCSVtJ1408vv/ynN6oHtb0r4QvwvSvHXiU/xAvVXnxv2NbleIVfz73NGEBnY8SoQTRESQHjIzJYBSkwczWpzyo7dsyv/SejILMr6pMNh2q/xW2mv+Vk3AxVExyHUL6JehAEfz1RABtDSIGYrf/2gbmXXjh7rfar/fnbnv36rX2X3HlPbfy+zZ/N/ZX+ZogZpHEr9BKH9d9G35BHEzwRGB0PrDb7XD5ZW94Jgwqcw6Pxc4BEE2KC1O8PVpIEhrNcQMuIaNCQeygsZwrXXy2cbNw5aiR3A1zH3qyQVwCwJ24tXHLn3VXT/d99YZdpxFT+3VtlU90/roBUEYGbAwBnlNokM5nZYPstZpYTonF4adocMEbc1XJ7z1yUGcFMOdW5RDNQyonupXgslimxRjgSB4U8C2iWHAtgL1ot9S5Ef+cKNFpKhjD6RqslDqOSIc07ZkfTJldV8vDuKqWtnUoHdbnMypbT1M+Sjpk7y8TqxLskXKUCfGfOAtgeqJaSi/DTVVoClBzJKsur5f6heSjLToaLpoVgZfJK/kDvTFR9CwlY0Nvap2OosxRrAgp7vNOpnRoXy/yMAfTZhN2zzAZfoK8wODRrNiV+T1SM59HdkstH0ZmuCUcCLw6EIofqYB5UQ+qRwYu0oyAAorirXc2BuCQoQuFFDqPdTUaLRdVGtSw0xFF4dmkWueajh+3K2F78wEuobNVlbBcIDYwhHsB3lKfsAfwlelGxAltF7m1kzgqK4814EQpo7hYQvnM0P765Pu5T15PNmvVT5r3NOLr2akkKZbP0GNVcW2nQUPMwoGyxZVGtRX0QTBQryhq0S/ywBZZrk+bxj1dRSJdcGMwQjP39pSaQ1jScgf5/NCGBPCmgmIwrDXxK8JnXP3Gfol2pryKVCvf20RWwxb19zF857bTjfk7Q9QRN1xN0jxZPtTxUZmCKU13PLQBrMEYr1fVED64cZsJ4ZV+20NebSsYEAhbu6+wBsOh+GQqvCofwDYbgVxYn6Ho27nerQ+FwCN/o3Cdg+/xav28A5Ld2Zzmn3VzxZmu2nVmL+NH774f7+wKU55rIVAgSOfSeElA4dUB+od0Q3lhrEY9kyYsIktUxCSQF9+FkLfao0cQCs1y3yjS910qXEktVsUwwpy0MejQFE501Au4Q3kDplBMLoLuBnhMVi89yXymOuYvs+zx59pgfWLBIhwBj93S9LMH9GMBA7E3COmyUKuRF8mJIOvamFCIH1Ln8Nm847G1Y91A/l0G7OYUpJxBGsJAs1Ga0cLXUCkXIljnLBAuyjaIA3MlmkUFNmm9E0FyzJiuuf85UTPPkAYOhGg+TOyp5YItLE4RM4ArDBPWGCPFRlaEC6gCw3LE3823siuEzWZdFHba42JEk67GQwxYPm2StlrG9FhwDmLNzKhX2ta1byam4lh29+UsWh8OCbxPyA0JMgukGvriUZiOAqGvPKN2gpmVgMhFM/AAsItVyhPonIxnALuIqpejyXsoBKhEYBiXQX+pMAUrR1kQLXTS622EvEoujRahExVK6BwSax73fGghmpmmKkZbdoPko0zws2A7WSbMcGHSheY0x1uvD7IcYKn8D7dzbqBzt4p25wqqOSvvKGWmrbRdoSsXRyuhoxTi8fnh4PQHq4FWoNJma5uY7YUfyDrSDKQzXjJIWvGj4TKrv5enYPgs2cQxeGvfZc0q4WmZtKN2JEs+UWnUtNA+W7EwSlWEYpGg+mUoTWOviYAA5iJMQj+zJk4vbh1s9p5PbVro68+RrsTZ32GhUbzxDvczfbOtwOsmmcvrKEV9f15/e6F43MkI6PGmHnXvrmHtaky0oCORfyStfUL8HPIf+n+8Bz7WAlOhhzmXKLQhZtKp9Ejo+HVWlJ6NZusBhdJT4Q3ANLlZRWLYwvQa065ZDIjArHaVEGkbJBwPTHoWN5n6lQ4RdpQed/4BgniZHpLlU3oDeSxyJMA+fJJ5CuwGHKK9txEFHZc2+1gj5xTXflqMxqw0I3du55bHlla+dctMNZz70+SUX7d19ipBr4waa5ZDdKcwnyhcKZxTaTAJny520Zd7qu5dWNq4+9ebi9UtXbqzPS+5Sqnu36CNBaJgWxIADo94oovR0BAS14OnDIUjlo7KDcxLO6JOlytIrTE9b2uYbzQbydTY6IxYwGG6yTJvfL8zOcCdPb/UQjvT3m+KphM127F97B439DPvRc7pfyAxzYBtTbtLstTJr8OGCYwOut1GudwHXW4AjklRQahouWp0wW0AHCFFfQ9lPAzn+IAZy/DSQ0wRf82trk7OKc6ZkAdlaMlDbLdKkxSRsosLDEKRg9hfkuJgTPGIuCjswGp1ElIHdCiKYpJy0ePHiG26A15Fd7IFdWZeUjsYqRXVzsRKLZrwiqH2PP37szce5c3CZDaUkM3vsmWyxmOVWsmYpFaJrUPSjb/B3gfxDfO9gQO0CfNkqNVEb0bUA3E4NXcuhT49kCHSbfazJTFDRcfnRGgJRRsUCawL8GRDZSkQE2R2ksnsmASRlAWQfdwLUo49r2BU11L2ZcdTTkit3g0YZ7sd11Me2IOrsnTXU9XyBxngqowsgjHLSZeDT7ockfglaYkf34zvXgu+4hsD223TbTyOY62kEcy+oLris0IhL5WO3/h5YxUn7nk84PxHW8e3KCcOtdXDI4fqmuvl4R48Db1L3MoJ+0Z3B4EAog4kYQxmlt4q5GHq+xRCZGCf25D/dfiMmxUayVxrHozJhELSQFwDPXlTfVN8+3tGPx0vDSMPuk/ASP3W8/PijdaLtcaTIrE/YRJRMx80twPyRlTp+S2h+wRyaQ3M6zaFZTfMLLqL5BcUsYrw1hzGcK0FM3IQ6QtnVMi1Lsw3K/rbpaPXc/L/KDDle5sf/jZa1IOfHv6G/ZcIc/sTtT0H1Y6OfZoSMH+3Wx8cImmqQ6WBmMItgZUSrPUmz3dJA9cUZNDQ185yuIBiOBylK42CfXrRNSPg495XHHkPzBmcOznOcOTDnu3BbPTg+/1VbDWoUBWAWohxWbfySo2/9vcIO/hmpjSI18ONswFdmyrOoP2txRpl1SJldpehO6yn8H3HD0LNHpulo5NPhx7UUo49XKn+vHD/6FjrV2OQNi4uLdR+Rwr1NvTrdNHMRphhafx6qYoP15YW108zQfAymxNt15y+6XCammYHl0hVh3490dUXG3JEu7hYw1z3snXR/C7yTopa4yzXMcxkoe4o+u2G5r4VyaR7FBN9zqIquED38gxkVoQBAJPYrkljyuKniApCVXR4JXRRNouLtn5o4N5MYUsQjRt26Jh908+s9gYDn6F53sPhX0rGIJN495r9o2eZlyzZ3cYfdwaD7mA3e3/vGZx8kw+qb5LD6Izy3DOh270cf8s38C4wXtPQhHYOQBnuEwq7lgKAz1qQFrJokIJ2dR1hDCKvA+Kme4ekFayobJl6qtaf5VBJ5iZoYxnuv/el11//k2oUL/7G/3xI754wrOme+eP+Fm+6//9Au9o9bf3Hztlf/+77L/3tkxBzbdOmexZ/fRc/cjzrVeHxNYhaOR9e8WnTN1xBd82hEldHDJuogYojCgJG9ktcDihJG0Y4bQ8uJsYmhs6VHFWVyxMysfvUItxZguorhuX83OBkf6HkMoM0VwkbU6oU0WwgTuZBmU8m+mcRBrppz8RVXhKWFy9ctnZlYtu3Lyy//3k3bHKed5hJ8aYuTNZtPL5BdZ37za195acP8u7ZcfcVVn5t7ygPFAd545je3rbwoeLbRt6ht4Y7e3CW76vbyS/xnmGYmCmvlOqYcRGo4qxgVwAFL0QHToktIDV+11IbUsGEcOBRG01HxiaVIDAliwlCxFNJCHry4ryUWT+guSOA2XhYmKDoFSWO9RIGkzIBihrzzKLkk8m31FTQIyeH2gco7j6oHH32H7P8aefBydRP522WXSaejo/3Rd4ymb4ORaMMrb6j85tF33rkwSx68DK75n8suW9M8Hs+9D+ZSM5NmFuiYwbSJZZRUVTFrs9mlGAHLDMXSXkWHIlOKuYAFpVArsGDJHIS5lOgv8Ub4TNantmwU4uO45GuokGEuQiQzkWIOAyBjYG9dc/dkZB4Pn3/+WeEQ+Yz6gOBfMHvt7H4NoxUt62sYPZAHhEg02esxE/JTMocM/5J1yLnZF4/jtZf6AeK4/jfpeJm1EWvVcRkP+1P/GY3wC+EI+i8wqyoK42UGRPf5wObXxqvUEm0QXicYLTObIinArWtopKw+Mhm5taSJLdyhrrxHw0ku1VCaW/k64rRD/T2eP/mLWn62lpckM3OZshux8FHrEewbs1ao4z2kcFnEzUQLdUouL0xCI5VpPswJssswH1mxxNio541IsEaYSRw+zCQPH2bMZ5bQGwoCN/U96g2tfE99Dd4r7Gmk7WXtyMvqL9WDL1eoM/Xlcfv2FqCxB6isRQWtOer202gL8Ej1ZA4tgkHgT1OAKpp6cli10Y2spuWqi8l/HN1P3lYX1XIba7IeJX1ZQj+53YkZWX56F7GGNVMLSdXuMn4n/UY0e2DKzdSAfkN//aaEub2up3j1eg7MhREy6O3CnBft129ne/E32SSbHP+VBn/cEuRCoC4tnMGrKF9WmCJ3C10vIwxTmJTQNjnBrXL85N1dx9fe9HsX+SX095nCuCtKcwg2fmkXLugN30M6t9Vwpr4KQyPOwDciLNDkMNs79kN+CSKMFSrk7SljRGMZINlzNebksyg0AvWfIZPiWXk8BsMzrrSiqoV3gNdz4yYn+QYOEtwPswy4t2t8R2F1aHznphVZ1qrOd9Hj3aur8U70PhPuocUfQafh26hO49Z1GlRoUFQgO0/WzaNkgpnGLxl7/UhdCydOthdo9C1G4P7Gf53m6GLqbepb7Io/qw+RjX9m140pfyYbYQtxc330M34lfyVaMwkzKRBZkOAg2ag+9Bd2UCJjyov00rGXfISMlTRZxzEc/zT/NPXnjtDMB0cVS9YQav/UzIeAnvmwDzMfqP9CwjRZzHuYmvWQAzmBSmVcinN7iAfkrGfPHvU99YD63h0V+o+mO9QP7tlDTqaHJ8DlBB1iPC8J4XI1wGXX4MLcIPsEuGwWjGcwsMTwsGqWiLF/MnjRfHQKWFh4cRygptIqS2HS9VV/3QmmUUggcEebC8Uoj2DYpSk3lwtyIVVICSlBngzEqld37Hh15054P7hjCixttTPwPhEmcSJM7gaYPHWYHOMwOafABJwlpCZDs4l4ye5n3z1vCiS3qO+Q3c+8e54WTx2HYzozyFxEIemvKoNUF4hS9bpXG70hOtfCVSWsuWUBvmGAL4zrTbQX1pu0uN/Mt80YoMOYGtSHUYmKSgdmKpdtzjQq2r1iyUim4JDLood82DCD5hV4jYKDl3PDfL43zWGlpAf4cTKGr9zFOwUja2DNvIP3cB6fSTY4UyE/qRjc3bHmeM+cnqbsyXOTt0/lVzbAGm0WwcCxxOvy2VyElyNDSc7Snl2fzS1p8xv9+Q1qujiBPhjJHahxtEQXZDdN4vFVMdeIH3ftltxSjYd9qB1PRbcQxYgnJpwfD7H3yKgWeJwK+B1gEBUrcL4xDucHS/MCpuzV43ARWhDFZMqOQDRHi6jKtng3jQNMQ+lcNjS3o3/DUy0L4RT6N3pQcwUVYl8sns7Q4XPDniL1lxhMywn1K0Qsh9vatThePjdMCvmcFGZlQMBBBCmeT5NUDtRxONpXiOdzsAsH4VRO+l7kts9X+rZscv/gB4HnT6l84fbwBv+liyv39b5SCZy7qLL4Ev9PyeHKDfcFKxXvis/OrZy3N/rSS03337DwYv+PfjTtq5VFF/p/+AP5ogUVjV8b8+Yi4zlfnroJWM+b0yUfGn6YM0VzvrzBiclxNC/gBMlxDVkPJ0r9WnjbbRfX/p84ffNXDVcxU/NVJ+MQnIpD0wQc/JNwCHwMDoABORH0m3as++FO9bETZ/jFd6yr7lQfnwJzkw6zj7I/Xy8O1SR7QIOZFofWcu2cXgqz6NNhdjQdJ9dOJpji5aHpXb2pKVAPs9OLVz75YXXj5ic/HJiab3dFkS0Mfzj2wcCHT27eWKtXPof6KYxMkObcYThW125KrAEYm6HKMc1kxuLhsb1snLxEs5l/PuX7ep5J7ft1XxXWoIOWpH2fpqx2qQPqLNKtwfBDmKOLYI4aUU8yUC+QQHOw+Cr+UIk3NKRVIyA/JC+SA+ohrZx5bC/WFOLvfAYG4a3a7xhrv0PGfweWCcXYrxdug3ryGdIGsHSoM2u/U6PJv1K9DauowZhG0B2ccd4d//EgXnWW8g/bK7e8+vT5JuLUsGBb51zVKGuM8E2xlp/lyJScuo4nE/jzwEuMyjeT5E719Zvf2UmSN6ubbyaj+gHOjEdgF34vxsT5nfxO+nsMGLpREWxd7VdiJIUXqa+RvTeT1E71tZsVOKJu3q6+xubxx1I71Ne2Y20Nzal8gOrVcWY51dpaqkqc+rNDmVpmBWl0Cpk1qy/gwuxKm52PxrUs0DjIaTMuVyER6Nk/2W9BPGGCajrG61BNR7Fdy6zUPsjaGXzc2+eN8zN4v/fHkn8aSO/fjp+HD3ae+jNvKOQlaXgfewlkuKFO1yTTwUxjemGF6WXKKZTkPTkMjqLUhsW4h3Zm6KWdGYYA/t4e0b3favPkZ2hhdzEnRWlyDMDV15vMEKyyd8JUg02cVU7iIF6JlrN6YlgEQrNtCmHMAh/F9eRSwrEx61CqJfSfPrdHej8aSg1Z4ix7aRFzwYtczON+9Vewedf3DY4WN8u1aBZikVg9pqdS08RRu89vG3WnkyWT10Jo14DDG6Zl/hm31M3cLS/Z2tf1Ix999Cf+WVo7lB3P88uBtoEpsKVeyk1SvpDGHL9hQ8HLOvg0Gxf6fIW+xDAmEaSSMS1WzQu/NJs4aXo6c8G5X77j7c90LfrMZZ+95vrTVznPcadmF8j0eRs3ndbu402CNyrGvzI0pN51iu+u7+YHbzp7+8Dgmlx3uD/8gvrDn+xekzMbPc7CjfZVI3uTM8+6aXXWazaEArkrWlpe+iHOmUsZGz+H/w9mAXAZURZSjppbVea6SoMwFIvgNTgX2GdGH029cXtlWAl9GrBhArCCLhMmiA9f6GNTPtmXSqbSbAE0nDDn4AUjbpNLDeZ58yIjM6a3OVsc3uVrRUPEZzE7Oc7kCLT6++dsmj3LmXz0H3xSar7TvXyVIWfvOH9R2snaeBMhVlfQnZwhC47emeRbI+HpN3ZLlsTwUHjkvdSKvcXowi6Pt8Upm6yEN3qbh2ZfMvspsurirjUPGVgh+rnX7jNFzrv48VW2gabepjY54OIt6aVrW9KXYJ3695gb+Pf4HBNlZjLzmdkMLk/tVWWGlk66IKMMHlIK1dJCIEIBVL5ZFnMgaGpvyw/TPC+mZJ4hup9nxNZ0fnhkPhX6QBdjNmyIAFmMsbQhVQgbskCZNJ/Sio3yvQWj7JMLmJgwFDQ2z1t+xZYvjn5xyxXL5zUbg5MP7BZmd5+2+rqbrl55StcCKymEZvSHe5T/UdLn3dpzwQWJJR4vu77N0rZu9Yb5mcz8DavXtWE26MR9y4ahM6d3tuVOH/iMgyxMzJ0RWHQKlryvWbjuiq2zL/BvaG3FaQq0YIAWCuOjGQ0nMV9jys6aJTqSwWxQpS/47aH//M9fM1KnRXGmHYrtO4aSg/zNodi/ozhd+6xOm6dzn4u+B+h7kL630vcEvpfhbMudLXfGjWCg9SuBfiXYr7T2K4l+xdrPPG+12V2BYGsirf8jsyxwyOGccDCdVmYFCaPRGtOncySOBC64kaw6gWcSmvoBVxSSMAgsDghfJ/iCocHEverL9yZWPnb5BSnL7p89n9h0FyVqRg7PcDpIW9LXnYlN82TIxs7U7JvT9mBQSJx67hfHyS3uPLriLunc86+d7mxT3+rb4X78Eo2imXXNK5uCY4/f7UxmkzP9s9gbp93Td9csb1ubrXfT2efR/ghfBeHopvqGG3PRk9StkQKQBbSkQX2WxCaSj1/alDA4Ek3S2DbvdO/Ytv8iL5AX1Mcx4DNnzvwWviVmaDl6qMj+fKy7iIIMu4PU8rUkKnfbYVZj8ihyc0dGSVA568OOOGUfzZL0+c2d5YSvVqNa6gRO9yVguofCaJOZw7DpS1CnfL63r4DeB+qPChP0FaQSIvUZZEhcMGKfhYJoMCaLPifZtH7rerLJ6fOL6gPFoOfMN870BIvqA6KfGNu9PQ4yl6waXr9+WH1a/UdHj7fda7f9Tf3bab5ZXtG8bJlZ9M7ynUaEv9lwNa7le5sndWEowGpSzzllVjHr6tH3PJaZabkwmAUEhj5G3huz0j/ltuYLObqfXxKSdmHi5C4pVPzYfzT2xL5fuzAkHVtUS2GH9ebv2tL89JzhGv4ZxsK4QJc+ieppfhpZ9NCkGxNtL8Flx40zQmsRfLDUW8V9gt1N6yhcYKU5cBCHCPZ6QC8pcBmY+lFSkLV9WCDX/wUXvYfG9qpPEu66Hc+pT7KP7bjuITz4l0qFXf8yelBfQpXtup37x+7beb12oNFf5gZdUqsBdoEhmZvoZZoYHiNiPJasZYuNPaX+pIjZ9JgQpuXPIzcPMFqeFR3/BHBzN7OBKUfw983VspmWapgxj0/KYg5MRw7N+k6gRpr6UpPYFAMbcXCukpvQDGEZSx5LGeByDlVckDxusRSOALlkTI7TekJJXhAgoKgPG1O9WLzgdRhAlNfaMYGNahTXpPKJgfaIaAUbG/b9qaXnfuU7Xzl3acpvxPZMpItdXzlyWcvpAavV2xxv60r7RdORSsfKbRdetiKXW3HZhdtWkrVaIi9W+WG/od8y3+Q/w72BWhMno6Ms/DuygWz87dg/kd2/Q3fZ79jZSOt5zOv8D3mmVhtvJvPYOezIb9WH1D1caOwFdvbv0Amn1dPNYIqGLaDjm2AetTGoU+tOGIGq1uiB4QVNRdc2HLiE0QpIGTQoeKFjXXyZdJKuH5Cbf3HsTXLvL8gNuN9ZYQ+QJvUPtBUR1rVtVv9AmlCdBxjdMGZPwJhlAdpyDMcrkFO6gPYuJallB2Pwha8im6BsAhWpFbMXMWWxWYtegLJUkpsBpG46KskC8A7oHOj7RM8n52A7CV1R6QjRzzgur3hZNJZMuQ1OR4C7KWloEs/Eydj3CmsKuyOhjpB6EN6yNI1GnjZ2W0u3gXvS7/Y8LEpw/NhM3u6jszervYe9UqjS4WMacoOxjsPZmAHHozau2LMUl3pFInZdIfmczvRRCQulK3rB62EsXuVu0Qpatd/W8n/xt10wVvXfdtL8QYP222IGGbnBPsuRKBgW4/eIEmy1pB5suNMxP9aW1aYWOhoISQOPbacyNapVs9HOTtQzhz2cNLccb6YaH8lpTJCDr738MukgHS+/rB5CDteSyXX+hf8ZsCe3w2820+oitEctGdoSajydjIZroihxotL4T8An/VH1Fy+91JADpgCVtfqChVqGuRKsYmeFEC1RMlDu8VZpWVZTzXcXoVZQOUKbqUWwmRpWaJkjoj69J6f8NBEtc1f2YNAIhGG8JpOO+dsHIk8ZWr3sHk/C8JR6V1FLtKdDBm9kDfs7X6pbHmul3iy6ru/Wc3WtIKsKYPXQsmsGC4IVo6vUAbBladl0qcOIfs8gJTAHTDuTSGlezg9yw4YBkhATcY/PAfyMHv4US9vZ6HIzljw3GwjwjljQ9wphWd4g8BX2kbEzkhnWYnMauFXeEF/g3g5JyLzYMCDrz9rtR1hB8kXXHAF92sILnIElR449U1HftVlJs0ROVn/LraS+/mdoXgvLLAL6nwf074R1Nq9XEeVoRmskhzLVny2305zq9gTWxfVmtNZD7TnAqqtHi+H3DZCCB+yCVJIGLASjFEYbuu4ABVTQkDOE0fA0xhY1ed1XzXRet8ptdHvP9ML7quucM7eI3qag2xQuXvjQ8hv+MmOGO0get02fN9067SJyphR6msxfus3b4glKnlbiuXGp+q2nAfM2gbOGJHe71yu0/1vP0FCPEflTAp3oQf5B1Ldoqyn8S6G3uyCgwzslC7L0x2Vvdu/e3f3msj/t3/+n2vYf95EX6Mc+evrBrt8s++P+/X9c9puuB7U1uqjXRcSYNKx/NK7cdghj5lio4msD1vPWqhaId4BgRAwsbS3xpZ7v4mRBRxFnkpwkRCUunsLgZXFoq/NIOvF+aCilfrN5KJVtmubYcLe3uKsIhvOLRw7djm2ZPlxc7CfrI53FrpO3CLu6Tm5rfvlfggn1DnL1qwef/c0N6h3FxtqwJTqcm5lyM45qgnp7mRw2A4BVU8CSZ2x2YanHx2G4Yf3kaU2GEtfam2gVu9grQNSwTMZFd9nU1oUucK1et92tdMKqkkYR3kE9STmxIPYOEOQG2aNPwHr6WIZNFiIwBVPRPBcX4jDTPgn3Ioq0sb03kFEggLp3MgEOvgrIk6vpvIT1r2iQ+DUU95OYaxl0pbbSFiXtNEPbi2iXe2idfA8t9Rw5Lu7dWnJtN82o7R4E6YJFct2A/H6b2OSdSY3CplZAOQ4UEBV/f8nbA5SRB0+i3uWCSIkA0z0BMzpCaElWtLaiEdoqQY566DJHk7ijHSzmv+TB8k0ZTJVis8NBLnRYRdvFDusakl6z6eLVm7YLTU71SeExsAESnzU2OX/gcrtdaoFYeTMn8DxrsHxxrfo07eC1mLWLCYv5LaNts8Prdly7ZHSZ+rQv9XDTKWSV1BaWvCFCWM7A2UwO+/Or3tVl2rnAN2uZMI2hXEs7omiZorBeT8f6CmVGtjydioPp/Ui7IbqUYC0CbYIQ6dJqEZBxgNBeF0pAZVALsCQjWFJoa+bbKe1CrTThQomICtNf4qZj5Uiqi9KOBSFo0EiBJcCGMFvLYkpx8VgqhzI8WhATAha6CQ5DB0ElMyeeexESyuq42O6yOsjFgjf6lEl90tVk3L5pteUNZ5PxsySxSf36urstBmIAgpl5K1FbuT9W2NmjS8i1Lpdkv8xmfIu3p8SxD+xfa5PIqmK7V336FPLf7636ptVpNXMYaSGqDSmszbWNqLMaHGCx9DEzwEIpF3CuTYc5NZBRpENKAfuZldslKkJnAHlycMCFein280O/SzsGWdx9/f0lR4bmdTFY4RNma/HvVCKP6VCSmEoancSITVAKw4ZBrA7ow0nlkw2iEMUaso0UdNZuf7hNUp9eNrrkWmfCsdl32qrnfQEN8mwWkTpFNZvY9eyP1fuMnshjAlmLpLlw9SWb1qg/W20j9kt81rX3uO11GpEKutK+j4RUXwe7paLHMFjGwr1n8MO63QscM5dR8loPmH6apJ7PKp3VcictwemcDphHs1h8mtKy0mcA5p0YB7SBSl5ypgBzO1X/jBEwOWeCrJCw1mSIJLQmkZgF4CScJyqLBgc1SZN5cRBWlVTSSVCTZ12+zfak81qydHQZWeVtf9g+9iHMAMuX3yV/PUV9ytuWzXKC0e/75j2A+sKI7xI7sa7JVdOrL7pk9YU4mcha4bFmh1PdDqOuvr7d2Oz8vs/t9pGKVXCZOLv7HvYyijiL+jjMkycZB6w0M3R9xUX1Nz2/jKbvac1DXTZ0yLq1Hn2Mh1aEl0ze/npNuB42YEEFF8xEMpy159fXPVwPlb27hyRYUJ/IPeol7Jrrfr3nrD3qu3oA1EMsr7xIkqTjJV1ffRJgcsGqN123zGAK+jSYtGwGi5bKUPJi7yU35nWVLYzYr1Wpo0tLpBBhV0kKErqzC9E8QHRt450r5B4EST2oAUQB1gB6VH39xVdemkKjYZ1GYp06Wvadezz7TkRj1ubsp1aaQcIsPHfJ6tW6zk6gU4J2rSBT6QTraKUGUwORHkXLi4xOhmmpDpO3cdC0vMUGsKQJYLl0sESaHGjDdZBx9U8dyoSZ9qM4Doi0irNyHBg3oyWp6dd8HU4XczvzJebLzFZ9PDuqyvKM8oUMUXZTcDURu17rTvIg5oAx2sCuF2c5HAZPNN46uGjNNbfcese96BuwuGdZ7LHktIFTz9/ywJepEF7eIbqf903rG5y3YM06vOYL4iyzhfGuv+jWHTvvpW5Oz0Se8Bh9gtcnZNE1LIfZgg9dcF4HQaHEFmA6wn/sCGwEZRCjqX1pgtuFvkKYlcMkAko5nCkMc4VkAUPlhTSX6kvhjIcrU8aUAyYptocV4D4OnPwFXxbevD4pzRVylKTXUuJpJP2bqckYIzaf3+Rf7RvuD5nSXEe3kRg+c1U4Fuccabtjnmgeakm7si6eGNt51hQIyh6P1egytjUZbW0Oh4fnE7zBIvh9Rpcp4pbNlvb4TJvVHOmzWYXMSqfH7ewMDpucQ05pmOM8hOshHBfkLKLVLcTMXc2tD5Mp84CcEr262TwvYPXwtrApE+bdi7zzzUaPxcZdEWodjpiJILishLVa4zKbYe0mzpd0hwKh5rDLSIhg8STMJm6hJHdaHB3egNnt4cxWOSW1CCmDnTPwrXGfjeNsbqOFALWElNMqC7HLLrO1ChabyPvXENbI286qxclY/ln+VsbLMIOkQID0fbJBLoCSniLGWIY42fXRZRv+Yac6dvdR+z9cv33sKWen89K7Ol3sunNf6Tv93Dvf3vbs6fMyY0+5XJcwtAfiBuDNp/S8cM03t4LBfgO9VaVArePmDPaVAkMfphPol9OruBQmqjT+kz9U6ukf72lZzlPrLY/WG3ZGxJjQ/6Jag2CzKdpwaqJRd6JtsEIPqzatdrpS+ZdxQ+9bx9tUH0BHIHugON7fAW0ArNjS6rX0kKrWMVmzq5kSY9INd1ycDKCfCGKRe/vYIu4W9eEKv6SIBd7qQWwAwzTaFminJ5gN1INDaFVrKIeagj+G1e1aBWgyozgPKTHaddAZQwKCagJg0Ebeca0nIRaGxWlhGHYhZLO47jIlB6y4SkRzD0qNHVPrJR7Ua0fd0rQzbI12pGugvdI+gH4GIBz9Rw1jMto+oBEKSzppHTozwa7HuKgXtKNaZp47h1F2jKpr4VbMTCA0Fwk9lNgfhStgEFW4ubKzglFX7YN9Td+rYEi1gi84wLXQj2MPaCfZt7RrGL1X515+L813iYCNPsIsYX6md2x3VtFTviinBKrK3CyWBffTvgS92XIbpVnbSebOWvudpQ0pAbAk6IXrUWsndtpIaqb+cFUZdtG4yYLqvsKC2aZOpYdaGwXaB0/PfliGSjD2FbA4aFuN0jBI31L3IOg/BTAdnjM7PXxGyzoKaz25bKLWG2dfR/fgMG62aUk4SlwsZQZw4fGT43X58ekd7+KxPupPwC0ZbBGWes20/ZSghakSWkEA2Ogn6gt0cSTd0iL7lsKrpcUnr2yPXEfM2o7DCXbOghwJt6QjcKqFlE/QPug27fzvu6It6ZZvt/QYthGHw4c7lrt9odZcbqWvBW9D/aO/ZAb4bwPvLAftCvMdUlW04kCa9MGoVbFXBPZvYEopzDmY2a+0iPutzmBTD1JIcpeyOWpEGGG5yWVxVeorEIy3pjCALBDgN71/vYCNJeGwfgk26AnDwgNqZoTgN1C5jMdAwpKm4LT4lnkzp0dntafaRHJn3O9sOtVrTp8UV68X5pJrvR65Kel0tY79undh4VSzwTmtNen3ktN7hzb1BeSztpiE046NCXNZw+zpouu85XNXbTq1bb7KkEP/tKx/VrOrp6OzC3/17Mw6kY3G1SuF2eQqn0tuTeEvjsyMD89qbZXw9wp5Xtx99rmn/e0jRhgkH83ef8a6z7VGC374Mc23uILp47/Hr4cZl2eGGJTC3dSPI2QJkg+0Bq2bWIemNWCzjI5mbH0uOLV8HC4HRDVofh0gCHVHYZ0CdlRMsylYhb24jPtkMG2HWbRcY05KJ+OKl2656+zz77r5xfi62fNf2iC6Oi+fNzJ/9rr4E0PDs3xnbFx5mW3W7OEN/YtmbLk8t2DwHM712Zduvvmlz6ZPvWj+vH/+rCzPuHneSfPmX3RqumntScO+Uy89/VLb8Lz1zfM3rnrymRXnaPj1f/QBfzX/T4wf1h7G4wVAYIwJbXqfErADPoyzYKQnQKgQkC7wCSZEL80fgBHvH9kx57QzRkjTyMgOk/WCg+r1fz3LnQ4VRg6O7BBsFxwkt8J+JhyKF0Z2jJxx1iz1DyNk41mzdo7gV749ssNswu/8z1nu7umFEcKfAd+y0G9tEHtyofiFnXBkZET9wyxNrlf03oHYQSWEefA00hqgVrWbemSMWtcXGBnYd2tVGLSDBhU1Gdr+pckNyqbR4NMew1AQtZSOmlVciIpRt16ZXxk878EnvlycoYVWimio/svQ2qGhtUXuW1I2HQ6ns9Kx+SCx/8IeOPYanhia0EvdP54VE8hgozEU0wTjR6lkb6EvKxOfV0DFgYCMJpkf/wxUWmvc6XR0OEgT/WhV/3jwJ2TrTw4SuRV2nU71LSd+xNX/Ug/+7McMR1KMG+zK3zA9wKGzmfsZrGPsoPWNw9lyN089LuhJGKBOSHe17B7AY24Puhzm0AY5sNZlq7hAZl2lLtJZ5t0zMBUQDE5vZJhuuUqzgJAgOpqx5r6pWpqLTY4wu4jtV7pExYyBkG7Ybe9XBsRvMI6m1Awa61fcmDGI3nDQccU0iaf5fK+eKcjLcRAKooyV+EbMF8Sid483zAGXiQ7ioU1fSerzhnWLjB42PbIsE12/fXkxOXflYCf3kKlv0azY4IpCW3l38Utr2gJ7XWKHt1nghxb+6Yn1K0lp6TlOspwYHYFM//rC6bfNFpYt5z1dMy8YWbDYrlYdgqdr8Nzhzz9hXbpMXNe2iQ2HuvySUQCz3m0aGOt03zprfkCPCZ/H3cs/DbTdweAqBHYDqChhGk1spo3srNWyhz4QxOPQaSocUvppD/rWbNlPux/6w+bOskD9XwKjVZQ7Na8FUtKPjW/Z6SOUYk7xOWukpaMnhzsOt9IFtO3owcUNjUtGLHUNaoHlHNILaEmlSryXPkJDAEsfKJ2T4j7YFoZJrg/ntIx90ZI0QyY1bMAclOJjfq/FzGW6Nz528/cfmLOiNbHa2x6Vw395ySRJ7TPiZ0vRL0SXDGbbl6c65J9lU2tlf8EoWUSbaJ5ma2XXF3sKwYG1Z7atL1/du7g5JHX1N6/qyBWz20MDfVYHiYW/GJC5EZ4P2qx38w6j3SpaCnfNB5kD1jX/jK7LRGr9Px0ZxYbNRJAoJSsYg4qp3lQ0LppZfGdpDAXsZf2TRgFpSQUNhxzbyt2C0T1WlxFG+gwF7H7xmN4TxpgDIa1tmmhipbdaYnhgbzvNk6eeuXKIRkdDMrZAwz5LOIosbZah5dXhgwYwtc4uwxct+iNfLLSisNSE7chdoLIGstl9bpdkopVyHpRN2Gmjlo6nmERYE8DoNdFaSMUuKiIOqGaLR2nPaQz0aI2QOFFrilQAFZJ9uYIxpNEirb45p3gOOruLBFv2ICFo01c8q7U4OowNiiqVCTRx0DrDGLNHyxcsCRbsPER9koCrifpdQHK6qJO3mYpU31QCCICMUwJkgX9FJIDDReNfoRaNKB4gzr6gxWrSNLwMNt5qJICgESAWwWoD3oDVBqVmF5zzYx2mEmigho49N5kqDdRAGhTrJDlnnBoaBdgD41Q5thVLcigPLtF5xA1csqnWvxRNAnRfACEoU5TtDtrGUMSJLWcUEX1R+zwu0UQf7SLQRyV5aB4hdmSyUuzxIR20A85+huWMtEuEA6tdDTydt7o/gyLGYXBDREtL527kZRgzbUxrDA4aOiDCvQ1GDj4oosJ8HA4Chd6NmJTdtL+2G9t7YLFYleJgRd/VPg8dHTvFU6A4WDQcRMrCFAfPRBx8k3FIUOg1Bk014kBbEBfPacShSIHHP8qVuERSvtTtGgtwJmKxktERsNZqRFz6VKWwOw+VBasHlyRgUmw7Sbva+ixmfAfpq8FtNaE45YxaFUuN4LQvWO2Vk2rihNaD0da2mLrYQHTatrv++t/BawV4nRReEDAgfCx0nbC4EV6L7xPgzUlcA8x1eCsakHoz3hODW+/5qNWdd4zX7jZPLY2W6wXRzNSC7Mn1Y1jQ+PD77z2CRYwVraRRq1zU6hi1E++cVCt3HGivxdFqsMTQizkJmvhUaFBkyCAWaKklU2r24GbseCXjkyH0dJP3H0ZYsNLykfcmAFkhS9V9COkj72l1mI2QqrYjR8bjfv9reGPj8Eb/HnjlJiznrUM0Ad7ikSMatO8/PBnaIiCy9P932kY5hLU2zhNhJYePaEyAiACPzGwg7WaAlfKkwUvrC4PMIFNfjqnbBysH3FqnY1AHZNrVGESpQI2oWvaGIooKp+XYY0KEJ18HLl+DWnvUW6UGFxlFeBCuivqw+jA+BmxCIS7V814DQXeI/yoTxYwfh+YbgiWxmUakMRnC16wlQ5Q86PF34kwFwoAtF0HLuI/J9YHhZuhzF/oyoImBrsUIxtdMMknvNhjMZrPDZmWdxGE2yerPyZdZVjCbnRb+gPrhYhcreNRFXslqctrZCzyiSHjyrM1pM7uMP1d/utZTn8uUbn4Y45lMmdPpZsKabCw1CtK8DhCL3vrUtmoTuhTk9MxExSUqzVrnURjSQj6KhZDUY4VZn7R5BKUpjm8mr9Uik8OOyhlnPPoOrkxU6AAxnd/S6PctXmDZd2hQQKNsQ01AiGllVutwOumiGgTAEg22mVXz5CRR5QOT7Dl/IBxpaUWtF/SDOFYtYzWLyRyOxenRoEi9bfUi65Sge920gt9CCvMVE7RqQJ9Ny66rVVQ/uGVR8dF3yJ/JxvvI4fvUJzSWOHvh9ffWGPS6Ze88aiZr71Nt96kPTaltObVWj9NEH9Lhaaxw0apysKUEWKKBuoeq9iC053mzxeF0e7RKRrkJjhCjYLO7ROaENTqs3ljiRFU68uV7Lr98z4mLdNx4+vIGOYa+UBfofmm9C7eod3CgD3mUaBGfCfQF+nQ6NzqQfbpPsSYLzCxt7Q+rvMPK+62uY37yAnkRMxmxWyY2l3Va1Pe4FuxGjGwytiXLHOf+nZPu//fdXEshNE+4excWqauzyZnjd2cP0PDU4aNvTbj3jXBv7LtZw11boQ1aY0rQ6GxZvL1Iby/i7aUpuIMZOuHmPezqL6vzdrG3Ntz8u+qP2dW71Xn3j83I1p/fhXijz9Zfx1yqYgDRoPUi91HMffTWPrx1cDLmciHFJTxYWdoIwMaDGzez3+KO3HfwPvKjBvL/29mvbjz2JmH/8T/hjGo/HhzpE8Dhyf4doHhkQS7I1gZQth48+1UO7/Y3ck4DMYoHNx4k7wB8977HfuvoH7OaDJPxmRz8s6BJmbDOg6e2n5lWPhmr2HFOK6rHmh8zkfkH1IT6/eXsnrEN5CHOdfQV4lKvJnuq3BNj02sysUhxwyrMpQyuHkYYSCMdSHzmhiNbNor0gRI87Jmytef/gfwxUhHkpO4hWkrnNIrustkna14hTaTgcwhkWjGOOm4siXiHpCPA8ZWwd9fYnF2YKVYs7uLe9oapEDz2DBboq5tD3PkVyn/DtP+eh+bjzWJQPwQInRRCJxgVZaNzAnjh2kJtpJ2KmZIRRGDZKvv1xvh1oCSQfhSkRAHLo7hxwNR3r9mmfg4hm3v9NWTj9WriN40Qvq6+d82NAGAJTm64Xm3lnqjU5orR4KCwykycPiuxtQGYRENnBY0qQorUaeJpKIvUwTj/CfWQ+rxOoOITT9xY+z8OivohvYgS6+ir9ORNX8f3Cb1J3ZR2F9E1GWjnoLRzoEljdKHKHcRy5BJvytbJ5wQKM+OBHLpAOl3Iz9j9x5alTsAgtijxYGk5rOYlJLB2yDKRzvhATkpmTSnnaFa7RufNqo2ip4WhKw00BjsCsHqSCiPaPrhSYY6D02nHwel42EyAvxF4JSRinkcJi0LKVlsA/UOwSE5GQR8oLdZvJuMoVID6l1AcaLRfPdiIwyUVOjY6Fvj01BoOFZoPZ6acMrl2QNMQwVzR+rcdXcErev86MnqE5g4ni7RrxZib/iDGls6D33tGt6m0ztg3Y6Si5AvmsL1JSW6mD4ssWZ05fFxkyebSqSPUWuhaqSsNvRA+ugpTIlktaFUZNOPVh40NeM7p0mNAbq8kah0btZJPUDlKxAv0MyFhtXRb+KNuB/qiehHuDmDWv6Zf0h7Ro3rTaLoJBtrL7LdpRA/zcg+9TON79V72tbrsGVpdNi29ZmpOFdmKS9M+s0s2Yf9njNWYqcZusVJHYY8mHkX9ycvam1DvZ5HwYrXOeA957UmwxWxW/08bhtBGgVYL3W4Nqu8GEuwB2h4ba2Bq75t/oJ5Ee2D8czGUj/qNBvUK2o9vZcQjXinOjTT2Nl7C5DBDhkYjbTklVy2zVgfau22Zsr85gZXmKXxWwniyaxsmuxpbaFPjaB4hp8/2kbAHLZenSX7APjRwiksPboc51OqdBCi8OEAOBxaTUZrJmw0E1M2LA6otsFjdXDsy3ZYkd6pbkrbp04nBLDm4a3wBwk6Hw+oWcmf98LHb8bAe29RsJz/TzLSAnZxmskzZr2sKvgz1mdNSH7cX3UCZjNb4yO2iLBVoplqcOMVKKuQS2K+5bsNHZSkB6KSiJJ+QtCxz0E4PotE0WrkAdJl1RfWOYq24AQswUxfQY6hQaVdrBs3YnMrZ6qFi3dwfrZx9dqU4Nu+RWx+BcXExLv4h/iF8RrA7zMlhLjeT9GHBJxAwTVKFYYLpw07iIpHhe847/6f3Xx+JPCIKnu94el1bdh47d4todHze0e1+mPt95x13HTzv/HuGouRhd9pxu4MXt5x7bOcWscf7oscoPjwxtx/Xt4zeXwmf45qheXsnZUoj9AEvTWhfZmCCtYn7ku3ZWZRomJpQIPneYS6LzCvp9VE0K8Hrm0mGyRDpa5ElL3aIBo0/zcdjDt5JJAe5mPUlV25emfQRQi52SChkvOGQ9/ve0A4yvINuGIPFra9vO/2xq4ozu8zm7EFvzkEyWd7eEpC8Tc0WS1b9qSPnxXZ47JNSgI/yMekev/8eKQabAaliCpzU0y5F29qiVkt9/mIecKAefycTO/dGpUQ0hT1dJa2LPX2JMn16x0fcN26gj+PQus5Xdh2hT6TGf+rmou5zqN3DTDvatOoRdm+OSjvLIepN1vpUaQuB9gSReuO/WoubXH2riKkGtEKIfhT1Hc0cr6VwsAc0rqImJj5LSu+ph70UsGpsge5PcNXtnq4Gf4Ko+RPw+X2iiz4DoCXe1qF1I6D7wZZkW7tW5DmpjR6G2jzoPMxpXf0NOXQogjqBfeiVrewBrLccm7NVoZ2TKMNjLyqgm/6UM3IYr1Bt8I7VGns1IUa930XNoff/Ek6BT4cTXTI0NiAfj5P+oIETYlShDj/69II6RvwEfJpAW5szBZvWqdgkdGz2eaXmUB2Xfd5gc+xjRgcYGEaH6J8nHBXqXKlo5tdEDCjkFH4qKibA7oO5NBX24FTYm8Zhl/3jsEs+vc/FcWE3iJ5uclyIdSk7EVT14V14eNeuqTwjU645dRxSL40LxbPYojFBH/Wjw97WALu3nvGPtVnRKrYubyW15zbomGnPATou/PTp0xiH7iQ8LuugxB0HG6Tx9va+/uR24ulr3749eZxpgXGQ1dvXrt2+GltmTZ4PcVrvOnkUOqaOQmfDHI+2pibMh1iy7e+d43Ea24l/3Ay/u4jRg8rHznD0fzPGCbhoVU8pZskUbNqmYtOuY/O8Vwo2hyOxRB2f573+YFO4pTX58RjFsdZV/gR8iufixD4BMqM0/7uODOrDE/AJ0fy1Tmb3OD7hTCnWDlpVhLIfNReQG5OUCVPZ40mzMBYQZHUG1MoE9wXkZhOtCwvi88aQH2P1fu+YzdJeVdpdNCkrgxn24wKRKTVhURho0V6s0zg+eWQYaz1OBySK0kgGhoqOS6Jziuf8K52TlSnyr0LHGhdIKiRpCGly35kQ1lZovrkQ9YIGaMhSp0N40mMdEeO6h46aUl7gX4vDw9GH/Smi+JzZybvlJsoMwRBWWdhdjFd/rJrUr/jc+4w2kZy4vU6+EKW2Q/REzrvQuJJ34qc70gVBy/3j+b06ri2gE+ypYRvNgGaAiYtNmQYBlJiEcAucz5ZbaIlOSxgszBYXOoWVQBarUeQsPtdUHHfEtnhpSh11VmKTLh8+WHaf2enmKUFiUZ0gYf05yrI/glan1ECUxiy6OlGAJ6hChM/uwdXxBKQJ4PxGnah4YtJ8GQ0W7R/W6n7w0YP8i/xJ9NkKl9MMN+pdVuyYqWLSqryjDWYWNtLVah4FzfkTw8A0PmtFkrFffymMqqobDJSSFZ9m4IxgfAQfdLqPsWhPXbaL+6xOSXsyIEclM4g2FNTxmECzMCSv7CBEi2A7Llv+Bhm96Zonnrgm3dX13CVf+iU7sobMoBY3eX/F5cgHT3/wlGPj1b94IGBzbFLv0x8H2YAb+vzDDHXrhw+h7kcbF4cBZjFo0BxWFA4zweSsiWBoyRMAhYl8lXzxzGsngqE5LygcX1UvDn6leM3TUyDBNYPouboXg33BAIMLoOhGSY5g01CSQ8OMnAlmmfrBE/gfvoSfld3d3bup92Cpuq9W73ot/E6B3w1rDuPx+mSsTMllCyL8oKg3eaI4pHQMfBJmw13bn+EvWDS9C++S7lt0gTk7cP0pwS+eeeUjrMO86AL2QH695PItuiCs/qi7m2TDFyzyR1rOGzr1s8ZTLnvkSt7Jsxcw/w8un4kSeNpjYGRgYGBkcFz6/1NPPL/NVwZ5lg1AEYbzPJx6MPq/1f85rHdZJYBcDgYmkCgAaDML2XjaY2BkYGCV+N8CJq3+XWa9ywAUQQHzAYk7Bkt42mPcwaDBsoGBAQmnwNhMPQwMrBIImnETELsxMDDchOLFQD4LkPaA0CA5qP4TjF9A7P+fIGb9/ww1kw+IxSFq/u+AYBS7YVgWiLOgasURehikoDQjlGYBmjEHqocRwgezWdD0ofgLB4aZeQJJzBQh9n8rkFbErvf/bKh+mNgUKL8Ui3qY+R1Q9glUOxl1oHbuBLIFgDQzDgzzJwuSv0H4DBBnIPGVoOEA4+cD3XsYiudjCRdQ3DwC0m5A2gpICyHCh1EPzc9eQCyKpJcDKp4IxExAzAoVZ0XCDCxHIPYwgMH/GwwBDJYMJ4DpRx0oxoQCEeAmmGRBEhFnQAUpYBMFIKz/c1AhSOf/T/8/AeUqAVIarnx42mNgYNCCwjSGJfggowGjB2MAYwvjKsZzjP+YzJhmMJ1hesesw+zD/IWliDWFjY9Nic2F7RG7D/sG9hccUzgNOBM4p3BxcblwdXC94w7jnsD9jMeOZwOvDG8Z7yo+K74Evi6+O/w3BHwEOgSuCfIJqglOERIRShC6JSwm3CfCI5IksktUTXSSWJLYLXEf8TbxFxIWEk0S+yR1JGdI/pHykqqR2iZ1TeqJtIi0gbSfdJv0NukH0l9k+GSiZJbIvJM1kj0kJyDXJfdG3k1+gfwB+UcKbApaCm4KeQoTFD4pZikeUXJSOqFcp7xORURlksozVRHVDtU5qptU36lFqXWo7VN7oc6nnqV+TsNCI0Vjh6aZ5hWtPK032hnam7R/6bjozNDdp/tML01vkt4vfSsDCYNthmqGdYaXjDiMdhgnGE8wkTJZZMpimma6z0zMLMZsizmXeYL5GvM/FgEWWywlLCMsp1lesZKwirNqs7pmrWNdYn3PxsEmw+aOrYvtCjsBOw+7PXbv7A3sZzkwOSQ4bHFUcuxw/ODU5PTDucP5m4uNS4LLPABRwojtAAABAAAA2wCbABEAAAAAAAIAAQACABYAAAEAAQEAAAAAeNqtUs1OwkAYnBY0Eo0aSTj34MGLDSAiwsl4EP+JRtGjVCiVQomtVBKfwmfw4sWDR59A38On8GCcXRYkyMEYaXZ39ut8s7NTAMzhBRrEL44FzhFo0RjXK+56WMMS7hTWMYsHhSPYw7PCUeTwqfAEbrWswpPIak8KTyGhvSscI/5QeBqL+rzCM8QZhePEZwq/IqH3Pbwhqd+HYWjabrdddyyv5ZuW18QmPLTRxTUc2KgjgIFHjjSSSGGFqMK3BnZwgRbXXfI7xILfgMnKBlw+xpCCL3dVrlWuHc6XZG7x5ucooYhtnnqIAxyTV6SWixqHQ32bPUfk27hhRZySYmdSeinghKeX2VcYq/VTaXlE67cOjJG+U3kPn+89mcGwp5LU6O2+q3UyA1iS3xl0mFjjXECTqg1qCk6NVXFyhYmbWJUjx9zTWP/jLcd/qfHVUD4mu11+5TZ9O8q1z6pAzX/jlOmyQueiGgwy2VeZ9v2lmZHIM4e8zDLPLDKD/2PmC43JiIUAAHjabdVV15RlAEbh2YBggd3drXO/89bYCPPZ3d0CioAoKnZ3d3d3YXd3x4E/wp+g+M32zPfkXjNrZj/PwTVrOmM6o8/fCzpF5/+ePzsdxjC2M7YzsTOJcSzCeCawKIuxOEuwJBOZxFIszTIs2/mL5VieFViRlViZVViV1VidNViTtVibdViX9VifDdiQjdiYTdiUzdicLdiSregSCnqUVNQ0tPTZmm3Ylu3Ynh3YkcnsxBSmMmCEndmFXdmN3dmDPdmLvdmHfdmP/TmAAzmIgzmEQzmMwzmCIzmKozmGYzmO4zmBEzmJaUxnBidzCjM5lVnMZg6nMZfTOYN5nMlZnM18zuFczuN8LuBCLuJiLuFSLuNyruBKruJqruFaruN6buBGbuJmbuFWbuN27uBO7uJu7uFe7uN+HuBBHuJhHuFRHuNxnuBJnuJpnuFZnuN5XuBFXuJlXuFVXmMBr/MGb/IWb/MO7/Ie7/MBH/IRH/MJn/IZn/MFX/IVX/MN3/Id3/MDP/ITP/MLv/Ibv/PH+Gkz58+ZngnzZs3odrtThzu5++8WC99w4xZuzy3dyq3dxm3dvjt5uMXIcKuRcYN5c2ePvqhGpoxu7WGNX2q6ox8eeImBlxh4iYGHDzx84OEDDx94+KCbrmsndmInpWsv9mIv9mKvsFfYK+wV9gp7hb3CXmGvsFfY69nr2evZ69nr2evZ69nr2evZ69kr7ZX2SnulvdJeaa+0V9or7ZX2KnuVvcpeZa+yV9mr7FX2KnuVvdpebae2U9up7dR2aju1ndpOY6fxXo29xl5jr7HX2GvsNfYae6291l5rr7XX2mvttfZae6291l7fXt9e317fXt9e317fXn/Yi+6j++g+wx/fwq3c2v3ve607vEf0H/1H/9F/9B/9R//Rf/Qf/Uf/0X/0H/1H/9F/9B/9R//Rf/Qf/Uf/0X/0H/1H/9F/9B/9R//Rf/Qf/Uf/0X/0H91H99F9dB/dR/fRfXQf3Uf30X10H92ntqf/6D/6j/6j/+g/+o/+o//oP/qP/qP/6D/6j/6j/+g/+o/+o//oP/qP/qP/6D/6j/6j/+g/+o/+o//oP/+579vpDzsL/z3+AcxdM0C4Af+FsAGNAEuwCFBYsQEBjlmxRgYrWCGwEFlLsBRSWCGwgFkdsAYrXFhZsBQrAAAAAVLmWK4AAA=="}
