var __js = {"affix.js":"/* ========================================================================\n * Bootstrap: affix.js v3.0.2\n * http://getbootstrap.com/javascript/#affix\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // AFFIX CLASS DEFINITION\n  // ======================\n\n  var Affix = function (element, options) {\n    this.options = $.extend({}, Affix.DEFAULTS, options)\n    this.$window = $(window)\n      .on('scroll.bs.affix.data-api', $.proxy(this.checkPosition, this))\n      .on('click.bs.affix.data-api',  $.proxy(this.checkPositionWithEventLoop, this))\n\n    this.$element = $(element)\n    this.affixed  =\n    this.unpin    = null\n\n    this.checkPosition()\n  }\n\n  Affix.RESET = 'affix affix-top affix-bottom'\n\n  Affix.DEFAULTS = {\n    offset: 0\n  }\n\n  Affix.prototype.checkPositionWithEventLoop = function () {\n    setTimeout($.proxy(this.checkPosition, this), 1)\n  }\n\n  Affix.prototype.checkPosition = function () {\n    if (!this.$element.is(':visible')) return\n\n    var scrollHeight = $(document).height()\n    var scrollTop    = this.$window.scrollTop()\n    var position     = this.$element.offset()\n    var offset       = this.options.offset\n    var offsetTop    = offset.top\n    var offsetBottom = offset.bottom\n\n    if (typeof offset != 'object')         offsetBottom = offsetTop = offset\n    if (typeof offsetTop == 'function')    offsetTop    = offset.top()\n    if (typeof offsetBottom == 'function') offsetBottom = offset.bottom()\n\n    var affix = this.unpin   != null && (scrollTop + this.unpin <= position.top) ? false :\n                offsetBottom != null && (position.top + this.$element.height() >= scrollHeight - offsetBottom) ? 'bottom' :\n                offsetTop    != null && (scrollTop <= offsetTop) ? 'top' : false\n\n    if (this.affixed === affix) return\n    if (this.unpin) this.$element.css('top', '')\n\n    this.affixed = affix\n    this.unpin   = affix == 'bottom' ? position.top - scrollTop : null\n\n    this.$element.removeClass(Affix.RESET).addClass('affix' + (affix ? '-' + affix : ''))\n\n    if (affix == 'bottom') {\n      this.$element.offset({ top: document.body.offsetHeight - offsetBottom - this.$element.height() })\n    }\n  }\n\n\n  // AFFIX PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.affix\n\n  $.fn.affix = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.affix')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.affix', (data = new Affix(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.affix.Constructor = Affix\n\n\n  // AFFIX NO CONFLICT\n  // =================\n\n  $.fn.affix.noConflict = function () {\n    $.fn.affix = old\n    return this\n  }\n\n\n  // AFFIX DATA-API\n  // ==============\n\n  $(window).on('load', function () {\n    $('[data-spy=\"affix\"]').each(function () {\n      var $spy = $(this)\n      var data = $spy.data()\n\n      data.offset = data.offset || {}\n\n      if (data.offsetBottom) data.offset.bottom = data.offsetBottom\n      if (data.offsetTop)    data.offset.top    = data.offsetTop\n\n      $spy.affix(data)\n    })\n  })\n\n}(jQuery);\n","alert.js":"/* ========================================================================\n * Bootstrap: alert.js v3.0.2\n * http://getbootstrap.com/javascript/#alerts\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // ALERT CLASS DEFINITION\n  // ======================\n\n  var dismiss = '[data-dismiss=\"alert\"]'\n  var Alert   = function (el) {\n    $(el).on('click', dismiss, this.close)\n  }\n\n  Alert.prototype.close = function (e) {\n    var $this    = $(this)\n    var selector = $this.attr('data-target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, '') // strip for ie7\n    }\n\n    var $parent = $(selector)\n\n    if (e) e.preventDefault()\n\n    if (!$parent.length) {\n      $parent = $this.hasClass('alert') ? $this : $this.parent()\n    }\n\n    $parent.trigger(e = $.Event('close.bs.alert'))\n\n    if (e.isDefaultPrevented()) return\n\n    $parent.removeClass('in')\n\n    function removeElement() {\n      $parent.trigger('closed.bs.alert').remove()\n    }\n\n    $.support.transition && $parent.hasClass('fade') ?\n      $parent\n        .one($.support.transition.end, removeElement)\n        .emulateTransitionEnd(150) :\n      removeElement()\n  }\n\n\n  // ALERT PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.alert\n\n  $.fn.alert = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('bs.alert')\n\n      if (!data) $this.data('bs.alert', (data = new Alert(this)))\n      if (typeof option == 'string') data[option].call($this)\n    })\n  }\n\n  $.fn.alert.Constructor = Alert\n\n\n  // ALERT NO CONFLICT\n  // =================\n\n  $.fn.alert.noConflict = function () {\n    $.fn.alert = old\n    return this\n  }\n\n\n  // ALERT DATA-API\n  // ==============\n\n  $(document).on('click.bs.alert.data-api', dismiss, Alert.prototype.close)\n\n}(jQuery);\n","button.js":"/* ========================================================================\n * Bootstrap: button.js v3.0.2\n * http://getbootstrap.com/javascript/#buttons\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // BUTTON PUBLIC CLASS DEFINITION\n  // ==============================\n\n  var Button = function (element, options) {\n    this.$element = $(element)\n    this.options  = $.extend({}, Button.DEFAULTS, options)\n  }\n\n  Button.DEFAULTS = {\n    loadingText: 'loading...'\n  }\n\n  Button.prototype.setState = function (state) {\n    var d    = 'disabled'\n    var $el  = this.$element\n    var val  = $el.is('input') ? 'val' : 'html'\n    var data = $el.data()\n\n    state = state + 'Text'\n\n    if (!data.resetText) $el.data('resetText', $el[val]())\n\n    $el[val](data[state] || this.options[state])\n\n    // push to event loop to allow forms to submit\n    setTimeout(function () {\n      state == 'loadingText' ?\n        $el.addClass(d).attr(d, d) :\n        $el.removeClass(d).removeAttr(d);\n    }, 0)\n  }\n\n  Button.prototype.toggle = function () {\n    var $parent = this.$element.closest('[data-toggle=\"buttons\"]')\n    var changed = true\n\n    if ($parent.length) {\n      var $input = this.$element.find('input')\n      if ($input.prop('type') === 'radio') {\n        // see if clicking on current one\n        if ($input.prop('checked') && this.$element.hasClass('active'))\n          changed = false\n        else\n          $parent.find('.active').removeClass('active')\n      }\n      if (changed) $input.prop('checked', !this.$element.hasClass('active')).trigger('change')\n    }\n\n    if (changed) this.$element.toggleClass('active')\n  }\n\n\n  // BUTTON PLUGIN DEFINITION\n  // ========================\n\n  var old = $.fn.button\n\n  $.fn.button = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.button')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.button', (data = new Button(this, options)))\n\n      if (option == 'toggle') data.toggle()\n      else if (option) data.setState(option)\n    })\n  }\n\n  $.fn.button.Constructor = Button\n\n\n  // BUTTON NO CONFLICT\n  // ==================\n\n  $.fn.button.noConflict = function () {\n    $.fn.button = old\n    return this\n  }\n\n\n  // BUTTON DATA-API\n  // ===============\n\n  $(document).on('click.bs.button.data-api', '[data-toggle^=button]', function (e) {\n    var $btn = $(e.target)\n    if (!$btn.hasClass('btn')) $btn = $btn.closest('.btn')\n    $btn.button('toggle')\n    e.preventDefault()\n  })\n\n}(jQuery);\n","carousel.js":"/* ========================================================================\n * Bootstrap: carousel.js v3.0.2\n * http://getbootstrap.com/javascript/#carousel\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // CAROUSEL CLASS DEFINITION\n  // =========================\n\n  var Carousel = function (element, options) {\n    this.$element    = $(element)\n    this.$indicators = this.$element.find('.carousel-indicators')\n    this.options     = options\n    this.paused      =\n    this.sliding     =\n    this.interval    =\n    this.$active     =\n    this.$items      = null\n\n    this.options.pause == 'hover' && this.$element\n      .on('mouseenter', $.proxy(this.pause, this))\n      .on('mouseleave', $.proxy(this.cycle, this))\n  }\n\n  Carousel.DEFAULTS = {\n    interval: 5000\n  , pause: 'hover'\n  , wrap: true\n  }\n\n  Carousel.prototype.cycle =  function (e) {\n    e || (this.paused = false)\n\n    this.interval && clearInterval(this.interval)\n\n    this.options.interval\n      && !this.paused\n      && (this.interval = setInterval($.proxy(this.next, this), this.options.interval))\n\n    return this\n  }\n\n  Carousel.prototype.getActiveIndex = function () {\n    this.$active = this.$element.find('.item.active')\n    this.$items  = this.$active.parent().children()\n\n    return this.$items.index(this.$active)\n  }\n\n  Carousel.prototype.to = function (pos) {\n    var that        = this\n    var activeIndex = this.getActiveIndex()\n\n    if (pos > (this.$items.length - 1) || pos < 0) return\n\n    if (this.sliding)       return this.$element.one('slid', function () { that.to(pos) })\n    if (activeIndex == pos) return this.pause().cycle()\n\n    return this.slide(pos > activeIndex ? 'next' : 'prev', $(this.$items[pos]))\n  }\n\n  Carousel.prototype.pause = function (e) {\n    e || (this.paused = true)\n\n    if (this.$element.find('.next, .prev').length && $.support.transition.end) {\n      this.$element.trigger($.support.transition.end)\n      this.cycle(true)\n    }\n\n    this.interval = clearInterval(this.interval)\n\n    return this\n  }\n\n  Carousel.prototype.next = function () {\n    if (this.sliding) return\n    return this.slide('next')\n  }\n\n  Carousel.prototype.prev = function () {\n    if (this.sliding) return\n    return this.slide('prev')\n  }\n\n  Carousel.prototype.slide = function (type, next) {\n    var $active   = this.$element.find('.item.active')\n    var $next     = next || $active[type]()\n    var isCycling = this.interval\n    var direction = type == 'next' ? 'left' : 'right'\n    var fallback  = type == 'next' ? 'first' : 'last'\n    var that      = this\n\n    if (!$next.length) {\n      if (!this.options.wrap) return\n      $next = this.$element.find('.item')[fallback]()\n    }\n\n    this.sliding = true\n\n    isCycling && this.pause()\n\n    var e = $.Event('slide.bs.carousel', { relatedTarget: $next[0], direction: direction })\n\n    if ($next.hasClass('active')) return\n\n    if (this.$indicators.length) {\n      this.$indicators.find('.active').removeClass('active')\n      this.$element.one('slid', function () {\n        var $nextIndicator = $(that.$indicators.children()[that.getActiveIndex()])\n        $nextIndicator && $nextIndicator.addClass('active')\n      })\n    }\n\n    if ($.support.transition && this.$element.hasClass('slide')) {\n      this.$element.trigger(e)\n      if (e.isDefaultPrevented()) return\n      $next.addClass(type)\n      $next[0].offsetWidth // force reflow\n      $active.addClass(direction)\n      $next.addClass(direction)\n      $active\n        .one($.support.transition.end, function () {\n          $next.removeClass([type, direction].join(' ')).addClass('active')\n          $active.removeClass(['active', direction].join(' '))\n          that.sliding = false\n          setTimeout(function () { that.$element.trigger('slid') }, 0)\n        })\n        .emulateTransitionEnd(600)\n    } else {\n      this.$element.trigger(e)\n      if (e.isDefaultPrevented()) return\n      $active.removeClass('active')\n      $next.addClass('active')\n      this.sliding = false\n      this.$element.trigger('slid')\n    }\n\n    isCycling && this.cycle()\n\n    return this\n  }\n\n\n  // CAROUSEL PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.carousel\n\n  $.fn.carousel = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.carousel')\n      var options = $.extend({}, Carousel.DEFAULTS, $this.data(), typeof option == 'object' && option)\n      var action  = typeof option == 'string' ? option : options.slide\n\n      if (!data) $this.data('bs.carousel', (data = new Carousel(this, options)))\n      if (typeof option == 'number') data.to(option)\n      else if (action) data[action]()\n      else if (options.interval) data.pause().cycle()\n    })\n  }\n\n  $.fn.carousel.Constructor = Carousel\n\n\n  // CAROUSEL NO CONFLICT\n  // ====================\n\n  $.fn.carousel.noConflict = function () {\n    $.fn.carousel = old\n    return this\n  }\n\n\n  // CAROUSEL DATA-API\n  // =================\n\n  $(document).on('click.bs.carousel.data-api', '[data-slide], [data-slide-to]', function (e) {\n    var $this   = $(this), href\n    var $target = $($this.attr('data-target') || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '')) //strip for ie7\n    var options = $.extend({}, $target.data(), $this.data())\n    var slideIndex = $this.attr('data-slide-to')\n    if (slideIndex) options.interval = false\n\n    $target.carousel(options)\n\n    if (slideIndex = $this.attr('data-slide-to')) {\n      $target.data('bs.carousel').to(slideIndex)\n    }\n\n    e.preventDefault()\n  })\n\n  $(window).on('load', function () {\n    $('[data-ride=\"carousel\"]').each(function () {\n      var $carousel = $(this)\n      $carousel.carousel($carousel.data())\n    })\n  })\n\n}(jQuery);\n","collapse.js":"/* ========================================================================\n * Bootstrap: collapse.js v3.0.2\n * http://getbootstrap.com/javascript/#collapse\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // COLLAPSE PUBLIC CLASS DEFINITION\n  // ================================\n\n  var Collapse = function (element, options) {\n    this.$element      = $(element)\n    this.options       = $.extend({}, Collapse.DEFAULTS, options)\n    this.transitioning = null\n\n    if (this.options.parent) this.$parent = $(this.options.parent)\n    if (this.options.toggle) this.toggle()\n  }\n\n  Collapse.DEFAULTS = {\n    toggle: true\n  }\n\n  Collapse.prototype.dimension = function () {\n    var hasWidth = this.$element.hasClass('width')\n    return hasWidth ? 'width' : 'height'\n  }\n\n  Collapse.prototype.show = function () {\n    if (this.transitioning || this.$element.hasClass('in')) return\n\n    var startEvent = $.Event('show.bs.collapse')\n    this.$element.trigger(startEvent)\n    if (startEvent.isDefaultPrevented()) return\n\n    var actives = this.$parent && this.$parent.find('> .panel > .in')\n\n    if (actives && actives.length) {\n      var hasData = actives.data('bs.collapse')\n      if (hasData && hasData.transitioning) return\n      actives.collapse('hide')\n      hasData || actives.data('bs.collapse', null)\n    }\n\n    var dimension = this.dimension()\n\n    this.$element\n      .removeClass('collapse')\n      .addClass('collapsing')\n      [dimension](0)\n\n    this.transitioning = 1\n\n    var complete = function () {\n      this.$element\n        .removeClass('collapsing')\n        .addClass('in')\n        [dimension]('auto')\n      this.transitioning = 0\n      this.$element.trigger('shown.bs.collapse')\n    }\n\n    if (!$.support.transition) return complete.call(this)\n\n    var scrollSize = $.camelCase(['scroll', dimension].join('-'))\n\n    this.$element\n      .one($.support.transition.end, $.proxy(complete, this))\n      .emulateTransitionEnd(350)\n      [dimension](this.$element[0][scrollSize])\n  }\n\n  Collapse.prototype.hide = function () {\n    if (this.transitioning || !this.$element.hasClass('in')) return\n\n    var startEvent = $.Event('hide.bs.collapse')\n    this.$element.trigger(startEvent)\n    if (startEvent.isDefaultPrevented()) return\n\n    var dimension = this.dimension()\n\n    this.$element\n      [dimension](this.$element[dimension]())\n      [0].offsetHeight\n\n    this.$element\n      .addClass('collapsing')\n      .removeClass('collapse')\n      .removeClass('in')\n\n    this.transitioning = 1\n\n    var complete = function () {\n      this.transitioning = 0\n      this.$element\n        .trigger('hidden.bs.collapse')\n        .removeClass('collapsing')\n        .addClass('collapse')\n    }\n\n    if (!$.support.transition) return complete.call(this)\n\n    this.$element\n      [dimension](0)\n      .one($.support.transition.end, $.proxy(complete, this))\n      .emulateTransitionEnd(350)\n  }\n\n  Collapse.prototype.toggle = function () {\n    this[this.$element.hasClass('in') ? 'hide' : 'show']()\n  }\n\n\n  // COLLAPSE PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.collapse\n\n  $.fn.collapse = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.collapse')\n      var options = $.extend({}, Collapse.DEFAULTS, $this.data(), typeof option == 'object' && option)\n\n      if (!data) $this.data('bs.collapse', (data = new Collapse(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.collapse.Constructor = Collapse\n\n\n  // COLLAPSE NO CONFLICT\n  // ====================\n\n  $.fn.collapse.noConflict = function () {\n    $.fn.collapse = old\n    return this\n  }\n\n\n  // COLLAPSE DATA-API\n  // =================\n\n  $(document).on('click.bs.collapse.data-api', '[data-toggle=collapse]', function (e) {\n    var $this   = $(this), href\n    var target  = $this.attr('data-target')\n        || e.preventDefault()\n        || (href = $this.attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '') //strip for ie7\n    var $target = $(target)\n    var data    = $target.data('bs.collapse')\n    var option  = data ? 'toggle' : $this.data()\n    var parent  = $this.attr('data-parent')\n    var $parent = parent && $(parent)\n\n    if (!data || !data.transitioning) {\n      if ($parent) $parent.find('[data-toggle=collapse][data-parent=\"' + parent + '\"]').not($this).addClass('collapsed')\n      $this[$target.hasClass('in') ? 'addClass' : 'removeClass']('collapsed')\n    }\n\n    $target.collapse(option)\n  })\n\n}(jQuery);\n","dropdown.js":"/* ========================================================================\n * Bootstrap: dropdown.js v3.0.2\n * http://getbootstrap.com/javascript/#dropdowns\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // DROPDOWN CLASS DEFINITION\n  // =========================\n\n  var backdrop = '.dropdown-backdrop'\n  var toggle   = '[data-toggle=dropdown]'\n  var Dropdown = function (element) {\n    var $el = $(element).on('click.bs.dropdown', this.toggle)\n  }\n\n  Dropdown.prototype.toggle = function (e) {\n    var $this = $(this)\n\n    if ($this.is('.disabled, :disabled')) return\n\n    var $parent  = getParent($this)\n    var isActive = $parent.hasClass('open')\n\n    clearMenus()\n\n    if (!isActive) {\n      if ('ontouchstart' in document.documentElement && !$parent.closest('.navbar-nav').length) {\n        // if mobile we we use a backdrop because click events don't delegate\n        $('<div class=\"dropdown-backdrop\"/>').insertAfter($(this)).on('click', clearMenus)\n      }\n\n      $parent.trigger(e = $.Event('show.bs.dropdown'))\n\n      if (e.isDefaultPrevented()) return\n\n      $parent\n        .toggleClass('open')\n        .trigger('shown.bs.dropdown')\n\n      $this.focus()\n    }\n\n    return false\n  }\n\n  Dropdown.prototype.keydown = function (e) {\n    if (!/(38|40|27)/.test(e.keyCode)) return\n\n    var $this = $(this)\n\n    e.preventDefault()\n    e.stopPropagation()\n\n    if ($this.is('.disabled, :disabled')) return\n\n    var $parent  = getParent($this)\n    var isActive = $parent.hasClass('open')\n\n    if (!isActive || (isActive && e.keyCode == 27)) {\n      if (e.which == 27) $parent.find(toggle).focus()\n      return $this.click()\n    }\n\n    var $items = $('[role=menu] li:not(.divider):visible a', $parent)\n\n    if (!$items.length) return\n\n    var index = $items.index($items.filter(':focus'))\n\n    if (e.keyCode == 38 && index > 0)                 index--                        // up\n    if (e.keyCode == 40 && index < $items.length - 1) index++                        // down\n    if (!~index)                                      index=0\n\n    $items.eq(index).focus()\n  }\n\n  function clearMenus() {\n    $(backdrop).remove()\n    $(toggle).each(function (e) {\n      var $parent = getParent($(this))\n      if (!$parent.hasClass('open')) return\n      $parent.trigger(e = $.Event('hide.bs.dropdown'))\n      if (e.isDefaultPrevented()) return\n      $parent.removeClass('open').trigger('hidden.bs.dropdown')\n    })\n  }\n\n  function getParent($this) {\n    var selector = $this.attr('data-target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && /#/.test(selector) && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\n    }\n\n    var $parent = selector && $(selector)\n\n    return $parent && $parent.length ? $parent : $this.parent()\n  }\n\n\n  // DROPDOWN PLUGIN DEFINITION\n  // ==========================\n\n  var old = $.fn.dropdown\n\n  $.fn.dropdown = function (option) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('dropdown')\n\n      if (!data) $this.data('dropdown', (data = new Dropdown(this)))\n      if (typeof option == 'string') data[option].call($this)\n    })\n  }\n\n  $.fn.dropdown.Constructor = Dropdown\n\n\n  // DROPDOWN NO CONFLICT\n  // ====================\n\n  $.fn.dropdown.noConflict = function () {\n    $.fn.dropdown = old\n    return this\n  }\n\n\n  // APPLY TO STANDARD DROPDOWN ELEMENTS\n  // ===================================\n\n  $(document)\n    .on('click.bs.dropdown.data-api', clearMenus)\n    .on('click.bs.dropdown.data-api', '.dropdown form', function (e) { e.stopPropagation() })\n    .on('click.bs.dropdown.data-api'  , toggle, Dropdown.prototype.toggle)\n    .on('keydown.bs.dropdown.data-api', toggle + ', [role=menu]' , Dropdown.prototype.keydown)\n\n}(jQuery);\n","modal.js":"/* ========================================================================\n * Bootstrap: modal.js v3.0.2\n * http://getbootstrap.com/javascript/#modals\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // MODAL CLASS DEFINITION\n  // ======================\n\n  var Modal = function (element, options) {\n    this.options   = options\n    this.$element  = $(element)\n    this.$backdrop =\n    this.isShown   = null\n\n    if (this.options.remote) this.$element.load(this.options.remote)\n  }\n\n  Modal.DEFAULTS = {\n      backdrop: true\n    , keyboard: true\n    , show: true\n  }\n\n  Modal.prototype.toggle = function (_relatedTarget) {\n    return this[!this.isShown ? 'show' : 'hide'](_relatedTarget)\n  }\n\n  Modal.prototype.show = function (_relatedTarget) {\n    var that = this\n    var e    = $.Event('show.bs.modal', { relatedTarget: _relatedTarget })\n\n    this.$element.trigger(e)\n\n    if (this.isShown || e.isDefaultPrevented()) return\n\n    this.isShown = true\n\n    this.escape()\n\n    this.$element.on('click.dismiss.modal', '[data-dismiss=\"modal\"]', $.proxy(this.hide, this))\n\n    this.backdrop(function () {\n      var transition = $.support.transition && that.$element.hasClass('fade')\n\n      if (!that.$element.parent().length) {\n        that.$element.appendTo(document.body) // don't move modals dom position\n      }\n\n      that.$element.show()\n\n      if (transition) {\n        that.$element[0].offsetWidth // force reflow\n      }\n\n      that.$element\n        .addClass('in')\n        .attr('aria-hidden', false)\n\n      that.enforceFocus()\n\n      var e = $.Event('shown.bs.modal', { relatedTarget: _relatedTarget })\n\n      transition ?\n        that.$element.find('.modal-dialog') // wait for modal to slide in\n          .one($.support.transition.end, function () {\n            that.$element.focus().trigger(e)\n          })\n          .emulateTransitionEnd(300) :\n        that.$element.focus().trigger(e)\n    })\n  }\n\n  Modal.prototype.hide = function (e) {\n    if (e) e.preventDefault()\n\n    e = $.Event('hide.bs.modal')\n\n    this.$element.trigger(e)\n\n    if (!this.isShown || e.isDefaultPrevented()) return\n\n    this.isShown = false\n\n    this.escape()\n\n    $(document).off('focusin.bs.modal')\n\n    this.$element\n      .removeClass('in')\n      .attr('aria-hidden', true)\n      .off('click.dismiss.modal')\n\n    $.support.transition && this.$element.hasClass('fade') ?\n      this.$element\n        .one($.support.transition.end, $.proxy(this.hideModal, this))\n        .emulateTransitionEnd(300) :\n      this.hideModal()\n  }\n\n  Modal.prototype.enforceFocus = function () {\n    $(document)\n      .off('focusin.bs.modal') // guard against infinite focus loop\n      .on('focusin.bs.modal', $.proxy(function (e) {\n        if (this.$element[0] !== e.target && !this.$element.has(e.target).length) {\n          this.$element.focus()\n        }\n      }, this))\n  }\n\n  Modal.prototype.escape = function () {\n    if (this.isShown && this.options.keyboard) {\n      this.$element.on('keyup.dismiss.bs.modal', $.proxy(function (e) {\n        e.which == 27 && this.hide()\n      }, this))\n    } else if (!this.isShown) {\n      this.$element.off('keyup.dismiss.bs.modal')\n    }\n  }\n\n  Modal.prototype.hideModal = function () {\n    var that = this\n    this.$element.hide()\n    this.backdrop(function () {\n      that.removeBackdrop()\n      that.$element.trigger('hidden.bs.modal')\n    })\n  }\n\n  Modal.prototype.removeBackdrop = function () {\n    this.$backdrop && this.$backdrop.remove()\n    this.$backdrop = null\n  }\n\n  Modal.prototype.backdrop = function (callback) {\n    var that    = this\n    var animate = this.$element.hasClass('fade') ? 'fade' : ''\n\n    if (this.isShown && this.options.backdrop) {\n      var doAnimate = $.support.transition && animate\n\n      this.$backdrop = $('<div class=\"modal-backdrop ' + animate + '\" />')\n        .appendTo(document.body)\n\n      this.$element.on('click.dismiss.modal', $.proxy(function (e) {\n        if (e.target !== e.currentTarget) return\n        this.options.backdrop == 'static'\n          ? this.$element[0].focus.call(this.$element[0])\n          : this.hide.call(this)\n      }, this))\n\n      if (doAnimate) this.$backdrop[0].offsetWidth // force reflow\n\n      this.$backdrop.addClass('in')\n\n      if (!callback) return\n\n      doAnimate ?\n        this.$backdrop\n          .one($.support.transition.end, callback)\n          .emulateTransitionEnd(150) :\n        callback()\n\n    } else if (!this.isShown && this.$backdrop) {\n      this.$backdrop.removeClass('in')\n\n      $.support.transition && this.$element.hasClass('fade')?\n        this.$backdrop\n          .one($.support.transition.end, callback)\n          .emulateTransitionEnd(150) :\n        callback()\n\n    } else if (callback) {\n      callback()\n    }\n  }\n\n\n  // MODAL PLUGIN DEFINITION\n  // =======================\n\n  var old = $.fn.modal\n\n  $.fn.modal = function (option, _relatedTarget) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.modal')\n      var options = $.extend({}, Modal.DEFAULTS, $this.data(), typeof option == 'object' && option)\n\n      if (!data) $this.data('bs.modal', (data = new Modal(this, options)))\n      if (typeof option == 'string') data[option](_relatedTarget)\n      else if (options.show) data.show(_relatedTarget)\n    })\n  }\n\n  $.fn.modal.Constructor = Modal\n\n\n  // MODAL NO CONFLICT\n  // =================\n\n  $.fn.modal.noConflict = function () {\n    $.fn.modal = old\n    return this\n  }\n\n\n  // MODAL DATA-API\n  // ==============\n\n  $(document).on('click.bs.modal.data-api', '[data-toggle=\"modal\"]', function (e) {\n    var $this   = $(this)\n    var href    = $this.attr('href')\n    var $target = $($this.attr('data-target') || (href && href.replace(/.*(?=#[^\\s]+$)/, ''))) //strip for ie7\n    var option  = $target.data('modal') ? 'toggle' : $.extend({ remote: !/#/.test(href) && href }, $target.data(), $this.data())\n\n    e.preventDefault()\n\n    $target\n      .modal(option, this)\n      .one('hide', function () {\n        $this.is(':visible') && $this.focus()\n      })\n  })\n\n  $(document)\n    .on('show.bs.modal',  '.modal', function () { $(document.body).addClass('modal-open') })\n    .on('hidden.bs.modal', '.modal', function () { $(document.body).removeClass('modal-open') })\n\n}(jQuery);\n","popover.js":"/* ========================================================================\n * Bootstrap: popover.js v3.0.2\n * http://getbootstrap.com/javascript/#popovers\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // POPOVER PUBLIC CLASS DEFINITION\n  // ===============================\n\n  var Popover = function (element, options) {\n    this.init('popover', element, options)\n  }\n\n  if (!$.fn.tooltip) throw new Error('Popover requires tooltip.js')\n\n  Popover.DEFAULTS = $.extend({} , $.fn.tooltip.Constructor.DEFAULTS, {\n    placement: 'right'\n  , trigger: 'click'\n  , content: ''\n  , template: '<div class=\"popover\"><div class=\"arrow\"></div><h3 class=\"popover-title\"></h3><div class=\"popover-content\"></div></div>'\n  })\n\n\n  // NOTE: POPOVER EXTENDS tooltip.js\n  // ================================\n\n  Popover.prototype = $.extend({}, $.fn.tooltip.Constructor.prototype)\n\n  Popover.prototype.constructor = Popover\n\n  Popover.prototype.getDefaults = function () {\n    return Popover.DEFAULTS\n  }\n\n  Popover.prototype.setContent = function () {\n    var $tip    = this.tip()\n    var title   = this.getTitle()\n    var content = this.getContent()\n\n    $tip.find('.popover-title')[this.options.html ? 'html' : 'text'](title)\n    $tip.find('.popover-content')[this.options.html ? 'html' : 'text'](content)\n\n    $tip.removeClass('fade top bottom left right in')\n\n    // IE8 doesn't accept hiding via the `:empty` pseudo selector, we have to do\n    // this manually by checking the contents.\n    if (!$tip.find('.popover-title').html()) $tip.find('.popover-title').hide()\n  }\n\n  Popover.prototype.hasContent = function () {\n    return this.getTitle() || this.getContent()\n  }\n\n  Popover.prototype.getContent = function () {\n    var $e = this.$element\n    var o  = this.options\n\n    return $e.attr('data-content')\n      || (typeof o.content == 'function' ?\n            o.content.call($e[0]) :\n            o.content)\n  }\n\n  Popover.prototype.arrow = function () {\n    return this.$arrow = this.$arrow || this.tip().find('.arrow')\n  }\n\n  Popover.prototype.tip = function () {\n    if (!this.$tip) this.$tip = $(this.options.template)\n    return this.$tip\n  }\n\n\n  // POPOVER PLUGIN DEFINITION\n  // =========================\n\n  var old = $.fn.popover\n\n  $.fn.popover = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.popover')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.popover', (data = new Popover(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.popover.Constructor = Popover\n\n\n  // POPOVER NO CONFLICT\n  // ===================\n\n  $.fn.popover.noConflict = function () {\n    $.fn.popover = old\n    return this\n  }\n\n}(jQuery);\n","scrollspy.js":"/* ========================================================================\n * Bootstrap: scrollspy.js v3.0.2\n * http://getbootstrap.com/javascript/#scrollspy\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // SCROLLSPY CLASS DEFINITION\n  // ==========================\n\n  function ScrollSpy(element, options) {\n    var href\n    var process  = $.proxy(this.process, this)\n\n    this.$element       = $(element).is('body') ? $(window) : $(element)\n    this.$body          = $('body')\n    this.$scrollElement = this.$element.on('scroll.bs.scroll-spy.data-api', process)\n    this.options        = $.extend({}, ScrollSpy.DEFAULTS, options)\n    this.selector       = (this.options.target\n      || ((href = $(element).attr('href')) && href.replace(/.*(?=#[^\\s]+$)/, '')) //strip for ie7\n      || '') + ' .nav li > a'\n    this.offsets        = $([])\n    this.targets        = $([])\n    this.activeTarget   = null\n\n    this.refresh()\n    this.process()\n  }\n\n  ScrollSpy.DEFAULTS = {\n    offset: 10\n  }\n\n  ScrollSpy.prototype.refresh = function () {\n    var offsetMethod = this.$element[0] == window ? 'offset' : 'position'\n\n    this.offsets = $([])\n    this.targets = $([])\n\n    var self     = this\n    var $targets = this.$body\n      .find(this.selector)\n      .map(function () {\n        var $el   = $(this)\n        var href  = $el.data('target') || $el.attr('href')\n        var $href = /^#\\w/.test(href) && $(href)\n\n        return ($href\n          && $href.length\n          && [[ $href[offsetMethod]().top + (!$.isWindow(self.$scrollElement.get(0)) && self.$scrollElement.scrollTop()), href ]]) || null\n      })\n      .sort(function (a, b) { return a[0] - b[0] })\n      .each(function () {\n        self.offsets.push(this[0])\n        self.targets.push(this[1])\n      })\n  }\n\n  ScrollSpy.prototype.process = function () {\n    var scrollTop    = this.$scrollElement.scrollTop() + this.options.offset\n    var scrollHeight = this.$scrollElement[0].scrollHeight || this.$body[0].scrollHeight\n    var maxScroll    = scrollHeight - this.$scrollElement.height()\n    var offsets      = this.offsets\n    var targets      = this.targets\n    var activeTarget = this.activeTarget\n    var i\n\n    if (scrollTop >= maxScroll) {\n      return activeTarget != (i = targets.last()[0]) && this.activate(i)\n    }\n\n    for (i = offsets.length; i--;) {\n      activeTarget != targets[i]\n        && scrollTop >= offsets[i]\n        && (!offsets[i + 1] || scrollTop <= offsets[i + 1])\n        && this.activate( targets[i] )\n    }\n  }\n\n  ScrollSpy.prototype.activate = function (target) {\n    this.activeTarget = target\n\n    $(this.selector)\n      .parents('.active')\n      .removeClass('active')\n\n    var selector = this.selector\n      + '[data-target=\"' + target + '\"],'\n      + this.selector + '[href=\"' + target + '\"]'\n\n    var active = $(selector)\n      .parents('li')\n      .addClass('active')\n\n    if (active.parent('.dropdown-menu').length)  {\n      active = active\n        .closest('li.dropdown')\n        .addClass('active')\n    }\n\n    active.trigger('activate')\n  }\n\n\n  // SCROLLSPY PLUGIN DEFINITION\n  // ===========================\n\n  var old = $.fn.scrollspy\n\n  $.fn.scrollspy = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.scrollspy')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.scrollspy', (data = new ScrollSpy(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.scrollspy.Constructor = ScrollSpy\n\n\n  // SCROLLSPY NO CONFLICT\n  // =====================\n\n  $.fn.scrollspy.noConflict = function () {\n    $.fn.scrollspy = old\n    return this\n  }\n\n\n  // SCROLLSPY DATA-API\n  // ==================\n\n  $(window).on('load', function () {\n    $('[data-spy=\"scroll\"]').each(function () {\n      var $spy = $(this)\n      $spy.scrollspy($spy.data())\n    })\n  })\n\n}(jQuery);\n","tab.js":"/* ========================================================================\n * Bootstrap: tab.js v3.0.2\n * http://getbootstrap.com/javascript/#tabs\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // TAB CLASS DEFINITION\n  // ====================\n\n  var Tab = function (element) {\n    this.element = $(element)\n  }\n\n  Tab.prototype.show = function () {\n    var $this    = this.element\n    var $ul      = $this.closest('ul:not(.dropdown-menu)')\n    var selector = $this.data('target')\n\n    if (!selector) {\n      selector = $this.attr('href')\n      selector = selector && selector.replace(/.*(?=#[^\\s]*$)/, '') //strip for ie7\n    }\n\n    if ($this.parent('li').hasClass('active')) return\n\n    var previous = $ul.find('.active:last a')[0]\n    var e        = $.Event('show.bs.tab', {\n      relatedTarget: previous\n    })\n\n    $this.trigger(e)\n\n    if (e.isDefaultPrevented()) return\n\n    var $target = $(selector)\n\n    this.activate($this.parent('li'), $ul)\n    this.activate($target, $target.parent(), function () {\n      $this.trigger({\n        type: 'shown.bs.tab'\n      , relatedTarget: previous\n      })\n    })\n  }\n\n  Tab.prototype.activate = function (element, container, callback) {\n    var $active    = container.find('> .active')\n    var transition = callback\n      && $.support.transition\n      && $active.hasClass('fade')\n\n    function next() {\n      $active\n        .removeClass('active')\n        .find('> .dropdown-menu > .active')\n        .removeClass('active')\n\n      element.addClass('active')\n\n      if (transition) {\n        element[0].offsetWidth // reflow for transition\n        element.addClass('in')\n      } else {\n        element.removeClass('fade')\n      }\n\n      if (element.parent('.dropdown-menu')) {\n        element.closest('li.dropdown').addClass('active')\n      }\n\n      callback && callback()\n    }\n\n    transition ?\n      $active\n        .one($.support.transition.end, next)\n        .emulateTransitionEnd(150) :\n      next()\n\n    $active.removeClass('in')\n  }\n\n\n  // TAB PLUGIN DEFINITION\n  // =====================\n\n  var old = $.fn.tab\n\n  $.fn.tab = function ( option ) {\n    return this.each(function () {\n      var $this = $(this)\n      var data  = $this.data('bs.tab')\n\n      if (!data) $this.data('bs.tab', (data = new Tab(this)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.tab.Constructor = Tab\n\n\n  // TAB NO CONFLICT\n  // ===============\n\n  $.fn.tab.noConflict = function () {\n    $.fn.tab = old\n    return this\n  }\n\n\n  // TAB DATA-API\n  // ============\n\n  $(document).on('click.bs.tab.data-api', '[data-toggle=\"tab\"], [data-toggle=\"pill\"]', function (e) {\n    e.preventDefault()\n    $(this).tab('show')\n  })\n\n}(jQuery);\n","tooltip.js":"/* ========================================================================\n * Bootstrap: tooltip.js v3.0.2\n * http://getbootstrap.com/javascript/#tooltip\n * Inspired by the original jQuery.tipsy by Jason Frame\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // TOOLTIP PUBLIC CLASS DEFINITION\n  // ===============================\n\n  var Tooltip = function (element, options) {\n    this.type       =\n    this.options    =\n    this.enabled    =\n    this.timeout    =\n    this.hoverState =\n    this.$element   = null\n\n    this.init('tooltip', element, options)\n  }\n\n  Tooltip.DEFAULTS = {\n    animation: true\n  , placement: 'top'\n  , selector: false\n  , template: '<div class=\"tooltip\"><div class=\"tooltip-arrow\"></div><div class=\"tooltip-inner\"></div></div>'\n  , trigger: 'hover focus'\n  , title: ''\n  , delay: 0\n  , html: false\n  , container: false\n  }\n\n  Tooltip.prototype.init = function (type, element, options) {\n    this.enabled  = true\n    this.type     = type\n    this.$element = $(element)\n    this.options  = this.getOptions(options)\n\n    var triggers = this.options.trigger.split(' ')\n\n    for (var i = triggers.length; i--;) {\n      var trigger = triggers[i]\n\n      if (trigger == 'click') {\n        this.$element.on('click.' + this.type, this.options.selector, $.proxy(this.toggle, this))\n      } else if (trigger != 'manual') {\n        var eventIn  = trigger == 'hover' ? 'mouseenter' : 'focus'\n        var eventOut = trigger == 'hover' ? 'mouseleave' : 'blur'\n\n        this.$element.on(eventIn  + '.' + this.type, this.options.selector, $.proxy(this.enter, this))\n        this.$element.on(eventOut + '.' + this.type, this.options.selector, $.proxy(this.leave, this))\n      }\n    }\n\n    this.options.selector ?\n      (this._options = $.extend({}, this.options, { trigger: 'manual', selector: '' })) :\n      this.fixTitle()\n  }\n\n  Tooltip.prototype.getDefaults = function () {\n    return Tooltip.DEFAULTS\n  }\n\n  Tooltip.prototype.getOptions = function (options) {\n    options = $.extend({}, this.getDefaults(), this.$element.data(), options)\n\n    if (options.delay && typeof options.delay == 'number') {\n      options.delay = {\n        show: options.delay\n      , hide: options.delay\n      }\n    }\n\n    return options\n  }\n\n  Tooltip.prototype.getDelegateOptions = function () {\n    var options  = {}\n    var defaults = this.getDefaults()\n\n    this._options && $.each(this._options, function (key, value) {\n      if (defaults[key] != value) options[key] = value\n    })\n\n    return options\n  }\n\n  Tooltip.prototype.enter = function (obj) {\n    var self = obj instanceof this.constructor ?\n      obj : $(obj.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type)\n\n    clearTimeout(self.timeout)\n\n    self.hoverState = 'in'\n\n    if (!self.options.delay || !self.options.delay.show) return self.show()\n\n    self.timeout = setTimeout(function () {\n      if (self.hoverState == 'in') self.show()\n    }, self.options.delay.show)\n  }\n\n  Tooltip.prototype.leave = function (obj) {\n    var self = obj instanceof this.constructor ?\n      obj : $(obj.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type)\n\n    clearTimeout(self.timeout)\n\n    self.hoverState = 'out'\n\n    if (!self.options.delay || !self.options.delay.hide) return self.hide()\n\n    self.timeout = setTimeout(function () {\n      if (self.hoverState == 'out') self.hide()\n    }, self.options.delay.hide)\n  }\n\n  Tooltip.prototype.show = function () {\n    var e = $.Event('show.bs.'+ this.type)\n\n    if (this.hasContent() && this.enabled) {\n      this.$element.trigger(e)\n\n      if (e.isDefaultPrevented()) return\n\n      var $tip = this.tip()\n\n      this.setContent()\n\n      if (this.options.animation) $tip.addClass('fade')\n\n      var placement = typeof this.options.placement == 'function' ?\n        this.options.placement.call(this, $tip[0], this.$element[0]) :\n        this.options.placement\n\n      var autoToken = /\\s?auto?\\s?/i\n      var autoPlace = autoToken.test(placement)\n      if (autoPlace) placement = placement.replace(autoToken, '') || 'top'\n\n      $tip\n        .detach()\n        .css({ top: 0, left: 0, display: 'block' })\n        .addClass(placement)\n\n      this.options.container ? $tip.appendTo(this.options.container) : $tip.insertAfter(this.$element)\n\n      var pos          = this.getPosition()\n      var actualWidth  = $tip[0].offsetWidth\n      var actualHeight = $tip[0].offsetHeight\n\n      if (autoPlace) {\n        var $parent = this.$element.parent()\n\n        var orgPlacement = placement\n        var docScroll    = document.documentElement.scrollTop || document.body.scrollTop\n        var parentWidth  = this.options.container == 'body' ? window.innerWidth  : $parent.outerWidth()\n        var parentHeight = this.options.container == 'body' ? window.innerHeight : $parent.outerHeight()\n        var parentLeft   = this.options.container == 'body' ? 0 : $parent.offset().left\n\n        placement = placement == 'bottom' && pos.top   + pos.height  + actualHeight - docScroll > parentHeight  ? 'top'    :\n                    placement == 'top'    && pos.top   - docScroll   - actualHeight < 0                         ? 'bottom' :\n                    placement == 'right'  && pos.right + actualWidth > parentWidth                              ? 'left'   :\n                    placement == 'left'   && pos.left  - actualWidth < parentLeft                               ? 'right'  :\n                    placement\n\n        $tip\n          .removeClass(orgPlacement)\n          .addClass(placement)\n      }\n\n      var calculatedOffset = this.getCalculatedOffset(placement, pos, actualWidth, actualHeight)\n\n      this.applyPlacement(calculatedOffset, placement)\n      this.$element.trigger('shown.bs.' + this.type)\n    }\n  }\n\n  Tooltip.prototype.applyPlacement = function(offset, placement) {\n    var replace\n    var $tip   = this.tip()\n    var width  = $tip[0].offsetWidth\n    var height = $tip[0].offsetHeight\n\n    // manually read margins because getBoundingClientRect includes difference\n    var marginTop = parseInt($tip.css('margin-top'), 10)\n    var marginLeft = parseInt($tip.css('margin-left'), 10)\n\n    // we must check for NaN for ie 8/9\n    if (isNaN(marginTop))  marginTop  = 0\n    if (isNaN(marginLeft)) marginLeft = 0\n\n    offset.top  = offset.top  + marginTop\n    offset.left = offset.left + marginLeft\n\n    $tip\n      .offset(offset)\n      .addClass('in')\n\n    // check to see if placing tip in new offset caused the tip to resize itself\n    var actualWidth  = $tip[0].offsetWidth\n    var actualHeight = $tip[0].offsetHeight\n\n    if (placement == 'top' && actualHeight != height) {\n      replace = true\n      offset.top = offset.top + height - actualHeight\n    }\n\n    if (/bottom|top/.test(placement)) {\n      var delta = 0\n\n      if (offset.left < 0) {\n        delta       = offset.left * -2\n        offset.left = 0\n\n        $tip.offset(offset)\n\n        actualWidth  = $tip[0].offsetWidth\n        actualHeight = $tip[0].offsetHeight\n      }\n\n      this.replaceArrow(delta - width + actualWidth, actualWidth, 'left')\n    } else {\n      this.replaceArrow(actualHeight - height, actualHeight, 'top')\n    }\n\n    if (replace) $tip.offset(offset)\n  }\n\n  Tooltip.prototype.replaceArrow = function(delta, dimension, position) {\n    this.arrow().css(position, delta ? (50 * (1 - delta / dimension) + \"%\") : '')\n  }\n\n  Tooltip.prototype.setContent = function () {\n    var $tip  = this.tip()\n    var title = this.getTitle()\n\n    $tip.find('.tooltip-inner')[this.options.html ? 'html' : 'text'](title)\n    $tip.removeClass('fade in top bottom left right')\n  }\n\n  Tooltip.prototype.hide = function () {\n    var that = this\n    var $tip = this.tip()\n    var e    = $.Event('hide.bs.' + this.type)\n\n    function complete() {\n      if (that.hoverState != 'in') $tip.detach()\n    }\n\n    this.$element.trigger(e)\n\n    if (e.isDefaultPrevented()) return\n\n    $tip.removeClass('in')\n\n    $.support.transition && this.$tip.hasClass('fade') ?\n      $tip\n        .one($.support.transition.end, complete)\n        .emulateTransitionEnd(150) :\n      complete()\n\n    this.$element.trigger('hidden.bs.' + this.type)\n\n    return this\n  }\n\n  Tooltip.prototype.fixTitle = function () {\n    var $e = this.$element\n    if ($e.attr('title') || typeof($e.attr('data-original-title')) != 'string') {\n      $e.attr('data-original-title', $e.attr('title') || '').attr('title', '')\n    }\n  }\n\n  Tooltip.prototype.hasContent = function () {\n    return this.getTitle()\n  }\n\n  Tooltip.prototype.getPosition = function () {\n    var el = this.$element[0]\n    return $.extend({}, (typeof el.getBoundingClientRect == 'function') ? el.getBoundingClientRect() : {\n      width: el.offsetWidth\n    , height: el.offsetHeight\n    }, this.$element.offset())\n  }\n\n  Tooltip.prototype.getCalculatedOffset = function (placement, pos, actualWidth, actualHeight) {\n    return placement == 'bottom' ? { top: pos.top + pos.height,   left: pos.left + pos.width / 2 - actualWidth / 2  } :\n           placement == 'top'    ? { top: pos.top - actualHeight, left: pos.left + pos.width / 2 - actualWidth / 2  } :\n           placement == 'left'   ? { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth } :\n        /* placement == 'right' */ { top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width   }\n  }\n\n  Tooltip.prototype.getTitle = function () {\n    var title\n    var $e = this.$element\n    var o  = this.options\n\n    title = $e.attr('data-original-title')\n      || (typeof o.title == 'function' ? o.title.call($e[0]) :  o.title)\n\n    return title\n  }\n\n  Tooltip.prototype.tip = function () {\n    return this.$tip = this.$tip || $(this.options.template)\n  }\n\n  Tooltip.prototype.arrow = function () {\n    return this.$arrow = this.$arrow || this.tip().find('.tooltip-arrow')\n  }\n\n  Tooltip.prototype.validate = function () {\n    if (!this.$element[0].parentNode) {\n      this.hide()\n      this.$element = null\n      this.options  = null\n    }\n  }\n\n  Tooltip.prototype.enable = function () {\n    this.enabled = true\n  }\n\n  Tooltip.prototype.disable = function () {\n    this.enabled = false\n  }\n\n  Tooltip.prototype.toggleEnabled = function () {\n    this.enabled = !this.enabled\n  }\n\n  Tooltip.prototype.toggle = function (e) {\n    var self = e ? $(e.currentTarget)[this.type](this.getDelegateOptions()).data('bs.' + this.type) : this\n    self.tip().hasClass('in') ? self.leave(self) : self.enter(self)\n  }\n\n  Tooltip.prototype.destroy = function () {\n    this.hide().$element.off('.' + this.type).removeData('bs.' + this.type)\n  }\n\n\n  // TOOLTIP PLUGIN DEFINITION\n  // =========================\n\n  var old = $.fn.tooltip\n\n  $.fn.tooltip = function (option) {\n    return this.each(function () {\n      var $this   = $(this)\n      var data    = $this.data('bs.tooltip')\n      var options = typeof option == 'object' && option\n\n      if (!data) $this.data('bs.tooltip', (data = new Tooltip(this, options)))\n      if (typeof option == 'string') data[option]()\n    })\n  }\n\n  $.fn.tooltip.Constructor = Tooltip\n\n\n  // TOOLTIP NO CONFLICT\n  // ===================\n\n  $.fn.tooltip.noConflict = function () {\n    $.fn.tooltip = old\n    return this\n  }\n\n}(jQuery);\n","transition.js":"/* ========================================================================\n * Bootstrap: transition.js v3.0.2\n * http://getbootstrap.com/javascript/#transitions\n * ========================================================================\n * Copyright 2013 Twitter, Inc.\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n * http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n * ======================================================================== */\n\n\n+function ($) { \"use strict\";\n\n  // CSS TRANSITION SUPPORT (Shoutout: http://www.modernizr.com/)\n  // ============================================================\n\n  function transitionEnd() {\n    var el = document.createElement('bootstrap')\n\n    var transEndEventNames = {\n      'WebkitTransition' : 'webkitTransitionEnd'\n    , 'MozTransition'    : 'transitionend'\n    , 'OTransition'      : 'oTransitionEnd otransitionend'\n    , 'transition'       : 'transitionend'\n    }\n\n    for (var name in transEndEventNames) {\n      if (el.style[name] !== undefined) {\n        return { end: transEndEventNames[name] }\n      }\n    }\n  }\n\n  // http://blog.alexmaccaw.com/css-transitions\n  $.fn.emulateTransitionEnd = function (duration) {\n    var called = false, $el = this\n    $(this).one($.support.transition.end, function () { called = true })\n    var callback = function () { if (!called) $($el).trigger($.support.transition.end) }\n    setTimeout(callback, duration)\n    return this\n  }\n\n  $(function () {\n    $.support.transition = transitionEnd()\n  })\n\n}(jQuery);\n"}
var __less = {"alerts.less":"//\n// Alerts\n// --------------------------------------------------\n\n\n// Base styles\n// -------------------------\n\n.alert {\n  padding: @alert-padding;\n  margin-bottom: @line-height-computed;\n  border: 1px solid transparent;\n  border-radius: @alert-border-radius;\n\n  // Headings for larger alerts\n  h4 {\n    margin-top: 0;\n    // Specified for the h4 to prevent conflicts of changing @headings-color\n    color: inherit;\n  }\n  // Provide class for links that match alerts\n  .alert-link {\n    font-weight: @alert-link-font-weight;\n  }\n\n  // Improve alignment and spacing of inner content\n  > p,\n  > ul {\n    margin-bottom: 0;\n  }\n  > p + p {\n    margin-top: 5px;\n  }\n}\n\n// Dismissable alerts\n//\n// Expand the right padding and account for the close button's positioning.\n\n.alert-dismissable {\n padding-right: (@alert-padding + 20);\n\n  // Adjust close link position\n  .close {\n    position: relative;\n    top: -2px;\n    right: -21px;\n    color: inherit;\n  }\n}\n\n// Alternate styles\n//\n// Generate contextual modifier classes for colorizing the alert.\n\n.alert-success {\n  .alert-variant(@alert-success-bg; @alert-success-border; @alert-success-text);\n}\n.alert-info {\n  .alert-variant(@alert-info-bg; @alert-info-border; @alert-info-text);\n}\n.alert-warning {\n  .alert-variant(@alert-warning-bg; @alert-warning-border; @alert-warning-text);\n}\n.alert-danger {\n  .alert-variant(@alert-danger-bg; @alert-danger-border; @alert-danger-text);\n}\n","badges.less":"//\n// Badges\n// --------------------------------------------------\n\n\n// Base classes\n.badge {\n  display: inline-block;\n  min-width: 10px;\n  padding: 3px 7px;\n  font-size: @font-size-small;\n  font-weight: @badge-font-weight;\n  color: @badge-color;\n  line-height: @badge-line-height;\n  vertical-align: baseline;\n  white-space: nowrap;\n  text-align: center;\n  background-color: @badge-bg;\n  border-radius: @badge-border-radius;\n\n  // Empty badges collapse automatically (not available in IE8)\n  &:empty {\n    display: none;\n  }\n}\n\n// Hover state, but only for links\na.badge {\n  &:hover,\n  &:focus {\n    color: @badge-link-hover-color;\n    text-decoration: none;\n    cursor: pointer;\n  }\n}\n\n// Quick fix for labels/badges in buttons\n.btn .badge {\n  position: relative;\n  top: -1px;\n}\n\n// Account for counters in navs\na.list-group-item.active > .badge,\n.nav-pills > .active > a > .badge {\n  color: @badge-active-color;\n  background-color: @badge-active-bg;\n}\n.nav-pills > li > a > .badge {\n  margin-left: 3px;\n}\n","bootstrap.less":"// Core variables and mixins\n@import \"variables.less\";\n@import \"mixins.less\";\n\n// Reset\n@import \"normalize.less\";\n@import \"print.less\";\n\n// Core CSS\n@import \"scaffolding.less\";\n@import \"type.less\";\n@import \"code.less\";\n@import \"grid.less\";\n@import \"tables.less\";\n@import \"forms.less\";\n@import \"buttons.less\";\n\n// Components\n@import \"component-animations.less\";\n@import \"glyphicons.less\";\n@import \"dropdowns.less\";\n@import \"button-groups.less\";\n@import \"input-groups.less\";\n@import \"navs.less\";\n@import \"navbar.less\";\n@import \"breadcrumbs.less\";\n@import \"pagination.less\";\n@import \"pager.less\";\n@import \"labels.less\";\n@import \"badges.less\";\n@import \"jumbotron.less\";\n@import \"thumbnails.less\";\n@import \"alerts.less\";\n@import \"progress-bars.less\";\n@import \"media.less\";\n@import \"list-group.less\";\n@import \"panels.less\";\n@import \"wells.less\";\n@import \"close.less\";\n\n// Components w/ JavaScript\n@import \"modals.less\";\n@import \"tooltip.less\";\n@import \"popovers.less\";\n@import \"carousel.less\";\n\n// Utility classes\n@import \"utilities.less\";\n@import \"responsive-utilities.less\";\n","breadcrumbs.less":"//\n// Breadcrumbs\n// --------------------------------------------------\n\n\n.breadcrumb {\n  padding: 8px 15px;\n  margin-bottom: @line-height-computed;\n  list-style: none;\n  background-color: @breadcrumb-bg;\n  border-radius: @border-radius-base;\n  > li {\n    display: inline-block;\n    + li:before {\n      content: \"@{breadcrumb-separator}\\00a0\"; // Unicode space added since inline-block means non-collapsing white-space\n      padding: 0 5px;\n      color: @breadcrumb-color;\n    }\n  }\n  > .active {\n    color: @breadcrumb-active-color;\n  }\n}\n","button-groups.less":"//\n// Button groups\n// --------------------------------------------------\n\n// Button carets\n//\n// Match the button text color to the arrow/caret for indicating dropdown-ness.\n\n.caret {\n  .btn-default & {\n    border-top-color: @btn-default-color;\n  }\n  .btn-primary &,\n  .btn-success &,\n  .btn-warning &,\n  .btn-danger &,\n  .btn-info & {\n    border-top-color: #fff;\n  }\n}\n.dropup {\n  .btn-default .caret {\n    border-bottom-color: @btn-default-color;\n  }\n  .btn-primary,\n  .btn-success,\n  .btn-warning,\n  .btn-danger,\n  .btn-info {\n   .caret {\n      border-bottom-color: #fff;\n    }\n  }\n}\n\n// Make the div behave like a button\n.btn-group,\n.btn-group-vertical {\n  position: relative;\n  display: inline-block;\n  vertical-align: middle; // match .btn alignment given font-size hack above\n  > .btn {\n    position: relative;\n    float: left;\n    // Bring the \"active\" button to the front\n    &:hover,\n    &:focus,\n    &:active,\n    &.active {\n      z-index: 2;\n    }\n    &:focus {\n      // Remove focus outline when dropdown JS adds it after closing the menu\n      outline: none;\n    }\n  }\n}\n\n// Prevent double borders when buttons are next to each other\n.btn-group {\n  .btn + .btn,\n  .btn + .btn-group,\n  .btn-group + .btn,\n  .btn-group + .btn-group {\n    margin-left: -1px;\n  }\n}\n\n// Optional: Group multiple button groups together for a toolbar\n.btn-toolbar {\n  .clearfix();\n\n  .btn-group {\n    float: left;\n  }\n  // Space out series of button groups\n  > .btn,\n  > .btn-group {\n    + .btn,\n    + .btn-group {\n      margin-left: 5px;\n    }\n  }\n}\n\n.btn-group > .btn:not(:first-child):not(:last-child):not(.dropdown-toggle) {\n  border-radius: 0;\n}\n\n// Set corners individual because sometimes a single button can be in a .btn-group and we need :first-child and :last-child to both match\n.btn-group > .btn:first-child {\n  margin-left: 0;\n  &:not(:last-child):not(.dropdown-toggle) {\n    .border-right-radius(0);\n  }\n}\n// Need .dropdown-toggle since :last-child doesn't apply given a .dropdown-menu immediately after it\n.btn-group > .btn:last-child:not(:first-child),\n.btn-group > .dropdown-toggle:not(:first-child) {\n  .border-left-radius(0);\n}\n\n// Custom edits for including btn-groups within btn-groups (useful for including dropdown buttons within a btn-group)\n.btn-group > .btn-group {\n  float: left;\n}\n.btn-group > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group > .btn-group:first-child {\n  > .btn:last-child,\n  > .dropdown-toggle {\n    .border-right-radius(0);\n  }\n}\n.btn-group > .btn-group:last-child > .btn:first-child {\n  .border-left-radius(0);\n}\n\n// On active and open, don't show outline\n.btn-group .dropdown-toggle:active,\n.btn-group.open .dropdown-toggle {\n  outline: 0;\n}\n\n\n// Sizing\n//\n// Remix the default button sizing classes into new ones for easier manipulation.\n\n.btn-group-xs > .btn { .btn-xs(); }\n.btn-group-sm > .btn { .btn-sm(); }\n.btn-group-lg > .btn { .btn-lg(); }\n\n\n// Split button dropdowns\n// ----------------------\n\n// Give the line between buttons some depth\n.btn-group > .btn + .dropdown-toggle {\n  padding-left: 8px;\n  padding-right: 8px;\n}\n.btn-group > .btn-lg + .dropdown-toggle {\n  padding-left: 12px;\n  padding-right: 12px;\n}\n\n// The clickable button for toggling the menu\n// Remove the gradient and set the same inset shadow as the :active state\n.btn-group.open .dropdown-toggle {\n  .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n\n  // Show no shadow for `.btn-link` since it has no other button styles.\n  &.btn-link {\n    .box-shadow(none);\n  }\n}\n\n\n// Reposition the caret\n.btn .caret {\n  margin-left: 0;\n}\n// Carets in other button sizes\n.btn-lg .caret {\n  border-width: @caret-width-large @caret-width-large 0;\n  border-bottom-width: 0;\n}\n// Upside down carets for .dropup\n.dropup .btn-lg .caret {\n  border-width: 0 @caret-width-large @caret-width-large;\n}\n\n\n// Vertical button groups\n// ----------------------\n\n.btn-group-vertical {\n  > .btn,\n  > .btn-group {\n    display: block;\n    float: none;\n    width: 100%;\n    max-width: 100%;\n  }\n\n  // Clear floats so dropdown menus can be properly placed\n  > .btn-group {\n    .clearfix();\n    > .btn {\n      float: none;\n    }\n  }\n\n  > .btn + .btn,\n  > .btn + .btn-group,\n  > .btn-group + .btn,\n  > .btn-group + .btn-group {\n    margin-top: -1px;\n    margin-left: 0;\n  }\n}\n\n.btn-group-vertical > .btn {\n  &:not(:first-child):not(:last-child) {\n    border-radius: 0;\n  }\n  &:first-child:not(:last-child) {\n    border-top-right-radius: @border-radius-base;\n    .border-bottom-radius(0);\n  }\n  &:last-child:not(:first-child) {\n    border-bottom-left-radius: @border-radius-base;\n    .border-top-radius(0);\n  }\n}\n.btn-group-vertical > .btn-group:not(:first-child):not(:last-child) > .btn {\n  border-radius: 0;\n}\n.btn-group-vertical > .btn-group:first-child {\n  > .btn:last-child,\n  > .dropdown-toggle {\n    .border-bottom-radius(0);\n  }\n}\n.btn-group-vertical > .btn-group:last-child > .btn:first-child {\n  .border-top-radius(0);\n}\n\n\n\n// Justified button groups\n// ----------------------\n\n.btn-group-justified {\n  display: table;\n  width: 100%;\n  table-layout: fixed;\n  border-collapse: separate;\n  .btn {\n    float: none;\n    display: table-cell;\n    width: 1%;\n  }\n}\n\n\n// Checkbox and radio options\n[data-toggle=\"buttons\"] > .btn > input[type=\"radio\"],\n[data-toggle=\"buttons\"] > .btn > input[type=\"checkbox\"] {\n  display: none;\n}\n","buttons.less":"//\n// Buttons\n// --------------------------------------------------\n\n\n// Base styles\n// --------------------------------------------------\n\n// Core styles\n.btn {\n  display: inline-block;\n  margin-bottom: 0; // For input.btn\n  font-weight: @btn-font-weight;\n  text-align: center;\n  vertical-align: middle;\n  cursor: pointer;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid transparent;\n  white-space: nowrap;\n  .button-size(@padding-base-vertical; @padding-base-horizontal; @font-size-base; @line-height-base; @border-radius-base);\n  .user-select(none);\n\n  &:focus {\n    .tab-focus();\n  }\n\n  &:hover,\n  &:focus {\n    color: @btn-default-color;\n    text-decoration: none;\n  }\n\n  &:active,\n  &.active {\n    outline: 0;\n    background-image: none;\n    .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n  }\n\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n    pointer-events: none; // Future-proof disabling of clicks\n    .opacity(.65);\n    .box-shadow(none);\n  }\n\n}\n\n\n// Alternate buttons\n// --------------------------------------------------\n\n.btn-default {\n  .button-variant(@btn-default-color; @btn-default-bg; @btn-default-border);\n}\n.btn-primary {\n  .button-variant(@btn-primary-color; @btn-primary-bg; @btn-primary-border);\n}\n// Warning appears as orange\n.btn-warning {\n  .button-variant(@btn-warning-color; @btn-warning-bg; @btn-warning-border);\n}\n// Danger and error appear as red\n.btn-danger {\n  .button-variant(@btn-danger-color; @btn-danger-bg; @btn-danger-border);\n}\n// Success appears as green\n.btn-success {\n  .button-variant(@btn-success-color; @btn-success-bg; @btn-success-border);\n}\n// Info appears as blue-green\n.btn-info {\n  .button-variant(@btn-info-color; @btn-info-bg; @btn-info-border);\n}\n\n\n// Link buttons\n// -------------------------\n\n// Make a button look and behave like a link\n.btn-link {\n  color: @link-color;\n  font-weight: normal;\n  cursor: pointer;\n  border-radius: 0;\n\n  &,\n  &:active,\n  &[disabled],\n  fieldset[disabled] & {\n    background-color: transparent;\n    .box-shadow(none);\n  }\n  &,\n  &:hover,\n  &:focus,\n  &:active {\n    border-color: transparent;\n  }\n  &:hover,\n  &:focus {\n    color: @link-hover-color;\n    text-decoration: underline;\n    background-color: transparent;\n  }\n  &[disabled],\n  fieldset[disabled] & {\n    &:hover,\n    &:focus {\n      color: @btn-link-disabled-color;\n      text-decoration: none;\n    }\n  }\n}\n\n\n// Button Sizes\n// --------------------------------------------------\n\n.btn-lg {\n  // line-height: ensure even-numbered height of button next to large input\n  .button-size(@padding-large-vertical; @padding-large-horizontal; @font-size-large; @line-height-large; @border-radius-large);\n}\n.btn-sm,\n.btn-xs {\n  // line-height: ensure proper height of button next to small input\n  .button-size(@padding-small-vertical; @padding-small-horizontal; @font-size-small; @line-height-small; @border-radius-small);\n}\n.btn-xs {\n  padding: 1px 5px;\n}\n\n\n// Block button\n// --------------------------------------------------\n\n.btn-block {\n  display: block;\n  width: 100%;\n  padding-left: 0;\n  padding-right: 0;\n}\n\n// Vertically space out multiple block buttons\n.btn-block + .btn-block {\n  margin-top: 5px;\n}\n\n// Specificity overrides\ninput[type=\"submit\"],\ninput[type=\"reset\"],\ninput[type=\"button\"] {\n  &.btn-block {\n    width: 100%;\n  }\n}\n","carousel.less":"//\n// Carousel\n// --------------------------------------------------\n\n\n// Wrapper for the slide container and indicators\n.carousel {\n  position: relative;\n}\n\n.carousel-inner {\n  position: relative;\n  overflow: hidden;\n  width: 100%;\n\n  > .item {\n    display: none;\n    position: relative;\n    .transition(.6s ease-in-out left);\n\n    // Account for jankitude on images\n    > img,\n    > a > img {\n      .img-responsive();\n      line-height: 1;\n    }\n  }\n\n  > .active,\n  > .next,\n  > .prev { display: block; }\n\n  > .active {\n    left: 0;\n  }\n\n  > .next,\n  > .prev {\n    position: absolute;\n    top: 0;\n    width: 100%;\n  }\n\n  > .next {\n    left: 100%;\n  }\n  > .prev {\n    left: -100%;\n  }\n  > .next.left,\n  > .prev.right {\n    left: 0;\n  }\n\n  > .active.left {\n    left: -100%;\n  }\n  > .active.right {\n    left: 100%;\n  }\n\n}\n\n// Left/right controls for nav\n// ---------------------------\n\n.carousel-control {\n  position: absolute;\n  top: 0;\n  left: 0;\n  bottom: 0;\n  width: @carousel-control-width;\n  .opacity(@carousel-control-opacity);\n  font-size: @carousel-control-font-size;\n  color: @carousel-control-color;\n  text-align: center;\n  text-shadow: @carousel-text-shadow;\n  // We can't have this transition here because WebKit cancels the carousel\n  // animation if you trip this while in the middle of another animation.\n\n  // Set gradients for backgrounds\n  &.left {\n    #gradient > .horizontal(@start-color: rgba(0,0,0,.5); @end-color: rgba(0,0,0,.0001));\n  }\n  &.right {\n    left: auto;\n    right: 0;\n    #gradient > .horizontal(@start-color: rgba(0,0,0,.0001); @end-color: rgba(0,0,0,.5));\n  }\n\n  // Hover/focus state\n  &:hover,\n  &:focus {\n    color: @carousel-control-color;\n    text-decoration: none;\n    .opacity(.9);\n  }\n\n  // Toggles\n  .icon-prev,\n  .icon-next,\n  .glyphicon-chevron-left,\n  .glyphicon-chevron-right {\n    position: absolute;\n    top: 50%;\n    z-index: 5;\n    display: inline-block;\n  }\n  .icon-prev,\n  .glyphicon-chevron-left {\n    left: 50%;\n  }\n  .icon-next,\n  .glyphicon-chevron-right {\n    right: 50%;\n  }\n  .icon-prev,\n  .icon-next {\n    width:  20px;\n    height: 20px;\n    margin-top: -10px;\n    margin-left: -10px;\n    font-family: serif;\n  }\n\n  .icon-prev {\n    &:before {\n      content: '\\2039';// SINGLE LEFT-POINTING ANGLE QUOTATION MARK (U+2039)\n    }\n  }\n  .icon-next {\n    &:before {\n      content: '\\203a';// SINGLE RIGHT-POINTING ANGLE QUOTATION MARK (U+203A)\n    }\n  }\n}\n\n// Optional indicator pips\n//\n// Add an unordered list with the following class and add a list item for each\n// slide your carousel holds.\n\n.carousel-indicators {\n  position: absolute;\n  bottom: 10px;\n  left: 50%;\n  z-index: 15;\n  width: 60%;\n  margin-left: -30%;\n  padding-left: 0;\n  list-style: none;\n  text-align: center;\n\n  li {\n    display: inline-block;\n    width:  10px;\n    height: 10px;\n    margin: 1px;\n    text-indent: -999px;\n    border: 1px solid @carousel-indicator-border-color;\n    border-radius: 10px;\n    cursor: pointer;\n\n    // IE8-9 hack for event handling\n    //\n    // Internet Explorer 8-9 does not support clicks on elements without a set\n    // `background-color`. We cannot use `filter` since that's not viewed as a\n    // background color by the browser. Thus, a hack is needed.\n    //\n    // For IE8, we set solid black as it doesn't support `rgba()`. For IE9, we\n    // set alpha transparency for the best results possible.\n    background-color: #000 \\9; // IE8\n    background-color: rgba(0,0,0,0); // IE9\n  }\n  .active {\n    margin: 0;\n    width:  12px;\n    height: 12px;\n    background-color: @carousel-indicator-active-bg;\n  }\n}\n\n// Optional captions\n// -----------------------------\n// Hidden by default for smaller viewports\n.carousel-caption {\n  position: absolute;\n  left: 15%;\n  right: 15%;\n  bottom: 20px;\n  z-index: 10;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  color: @carousel-caption-color;\n  text-align: center;\n  text-shadow: @carousel-text-shadow;\n  & .btn {\n    text-shadow: none; // No shadow for button elements in carousel-caption\n  }\n}\n\n\n// Scale up controls for tablets and up\n@media screen and (min-width: @screen-sm-min) {\n\n  // Scale up the controls a smidge\n  .carousel-control {\n    .glyphicons-chevron-left,\n    .glyphicons-chevron-right,\n    .icon-prev,\n    .icon-next {\n      width: 30px;\n      height: 30px;\n      margin-top: -15px;\n      margin-left: -15px;\n      font-size: 30px;\n    }\n  }\n\n  // Show and left align the captions\n  .carousel-caption {\n    left: 20%;\n    right: 20%;\n    padding-bottom: 30px;\n  }\n\n  // Move up the indicators\n  .carousel-indicators {\n    bottom: 20px;\n  }\n}\n","close.less":"//\n// Close icons\n// --------------------------------------------------\n\n\n.close {\n  float: right;\n  font-size: (@font-size-base * 1.5);\n  font-weight: @close-font-weight;\n  line-height: 1;\n  color: @close-color;\n  text-shadow: @close-text-shadow;\n  .opacity(.2);\n\n  &:hover,\n  &:focus {\n    color: @close-color;\n    text-decoration: none;\n    cursor: pointer;\n    .opacity(.5);\n  }\n\n  // Additional properties for button version\n  // iOS requires the button element instead of an anchor tag.\n  // If you want the anchor version, it requires `href=\"#\"`.\n  button& {\n    padding: 0;\n    cursor: pointer;\n    background: transparent;\n    border: 0;\n    -webkit-appearance: none;\n  }\n}\n","code.less":"//\n// Code (inline and block)\n// --------------------------------------------------\n\n\n// Inline and block code styles\ncode,\nkbd,\npre,\nsamp {\n  font-family: @font-family-monospace;\n}\n\n// Inline code\ncode {\n  padding: 2px 4px;\n  font-size: 90%;\n  color: @code-color;\n  background-color: @code-bg;\n  white-space: nowrap;\n  border-radius: @border-radius-base;\n}\n\n// Blocks of code\npre {\n  display: block;\n  padding: ((@line-height-computed - 1) / 2);\n  margin: 0 0 (@line-height-computed / 2);\n  font-size: (@font-size-base - 1); // 14px to 13px\n  line-height: @line-height-base;\n  word-break: break-all;\n  word-wrap: break-word;\n  color: @pre-color;\n  background-color: @pre-bg;\n  border: 1px solid @pre-border-color;\n  border-radius: @border-radius-base;\n\n  // Account for some code outputs that place code tags in pre tags\n  code {\n    padding: 0;\n    font-size: inherit;\n    color: inherit;\n    white-space: pre-wrap;\n    background-color: transparent;\n    border-radius: 0;\n  }\n}\n\n// Enable scrollable blocks of code\n.pre-scrollable {\n  max-height: @pre-scrollable-max-height;\n  overflow-y: scroll;\n}\n","component-animations.less":"//\n// Component animations\n// --------------------------------------------------\n\n// Heads up!\n//\n// We don't use the `.opacity()` mixin here since it causes a bug with text\n// fields in IE7-8. Source: https://github.com/twitter/bootstrap/pull/3552.\n\n.fade {\n  opacity: 0;\n  .transition(opacity .15s linear);\n  &.in {\n    opacity: 1;\n  }\n}\n\n.collapse {\n  display: none;\n  &.in {\n    display: block;\n  }\n}\n.collapsing {\n  position: relative;\n  height: 0;\n  overflow: hidden;\n  .transition(height .35s ease);\n}\n","dropdowns.less":"//\n// Dropdown menus\n// --------------------------------------------------\n\n\n// Dropdown arrow/caret\n.caret {\n  display: inline-block;\n  width: 0;\n  height: 0;\n  margin-left: 2px;\n  vertical-align: middle;\n  border-top:   @caret-width-base solid @dropdown-caret-color;\n  border-right: @caret-width-base solid transparent;\n  border-left:  @caret-width-base solid transparent;\n  // Firefox fix for https://github.com/twbs/bootstrap/issues/9538. Once fixed,\n  // we can just straight up remove this.\n  border-bottom: 0 dotted;\n}\n\n// The dropdown wrapper (div)\n.dropdown {\n  position: relative;\n}\n\n// Prevent the focus on the dropdown toggle when closing dropdowns\n.dropdown-toggle:focus {\n  outline: 0;\n}\n\n// The dropdown menu (ul)\n.dropdown-menu {\n  position: absolute;\n  top: 100%;\n  left: 0;\n  z-index: @zindex-dropdown;\n  display: none; // none by default, but block on \"open\" of the menu\n  float: left;\n  min-width: 160px;\n  padding: 5px 0;\n  margin: 2px 0 0; // override default ul\n  list-style: none;\n  font-size: @font-size-base;\n  background-color: @dropdown-bg;\n  border: 1px solid @dropdown-fallback-border; // IE8 fallback\n  border: 1px solid @dropdown-border;\n  border-radius: @border-radius-base;\n  .box-shadow(0 6px 12px rgba(0,0,0,.175));\n  background-clip: padding-box;\n\n  // Aligns the dropdown menu to right\n  &.pull-right {\n    right: 0;\n    left: auto;\n  }\n\n  // Dividers (basically an hr) within the dropdown\n  .divider {\n    .nav-divider(@dropdown-divider-bg);\n  }\n\n  // Links within the dropdown menu\n  > li > a {\n    display: block;\n    padding: 3px 20px;\n    clear: both;\n    font-weight: normal;\n    line-height: @line-height-base;\n    color: @dropdown-link-color;\n    white-space: nowrap; // prevent links from randomly breaking onto new lines\n  }\n}\n\n// Hover/Focus state\n.dropdown-menu > li > a {\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    color: @dropdown-link-hover-color;\n    background-color: @dropdown-link-hover-bg;\n  }\n}\n\n// Active state\n.dropdown-menu > .active > a {\n  &,\n  &:hover,\n  &:focus {\n    color: @dropdown-link-active-color;\n    text-decoration: none;\n    outline: 0;\n    background-color: @dropdown-link-active-bg;\n  }\n}\n\n// Disabled state\n//\n// Gray out text and ensure the hover/focus state remains gray\n\n.dropdown-menu > .disabled > a {\n  &,\n  &:hover,\n  &:focus {\n    color: @dropdown-link-disabled-color;\n  }\n}\n// Nuke hover/focus effects\n.dropdown-menu > .disabled > a {\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    background-color: transparent;\n    background-image: none; // Remove CSS gradient\n    .reset-filter();\n    cursor: not-allowed;\n  }\n}\n\n// Open state for the dropdown\n.open {\n  // Show the menu\n  > .dropdown-menu {\n    display: block;\n  }\n\n  // Remove the outline when :focus is triggered\n  > a {\n    outline: 0;\n  }\n}\n\n// Dropdown section headers\n.dropdown-header {\n  display: block;\n  padding: 3px 20px;\n  font-size: @font-size-small;\n  line-height: @line-height-base;\n  color: @dropdown-header-color;\n}\n\n// Backdrop to catch body clicks on mobile, etc.\n.dropdown-backdrop {\n  position: fixed;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  z-index: @zindex-dropdown - 10;\n}\n\n// Right aligned dropdowns\n.pull-right > .dropdown-menu {\n  right: 0;\n  left: auto;\n}\n\n// Allow for dropdowns to go bottom up (aka, dropup-menu)\n//\n// Just add .dropup after the standard .dropdown class and you're set, bro.\n// TODO: abstract this so that the navbar fixed styles are not placed here?\n\n.dropup,\n.navbar-fixed-bottom .dropdown {\n  // Reverse the caret\n  .caret {\n    // Firefox fix for https://github.com/twbs/bootstrap/issues/9538. Once this\n    // gets fixed, restore `border-top: 0;`.\n    border-top: 0 dotted;\n    border-bottom: @caret-width-base solid @dropdown-caret-color;\n    content: \"\";\n  }\n  // Different positioning for bottom up menu\n  .dropdown-menu {\n    top: auto;\n    bottom: 100%;\n    margin-bottom: 1px;\n  }\n}\n\n\n// Component alignment\n//\n// Reiterate per navbar.less and the modified component alignment there.\n\n@media (min-width: @grid-float-breakpoint) {\n  .navbar-right {\n    .dropdown-menu {\n      .pull-right > .dropdown-menu();\n    }\n  }\n}\n\n","forms.less":"//\n// Forms\n// --------------------------------------------------\n\n\n// Normalize non-controls\n//\n// Restyle and baseline non-control form elements.\n\nfieldset {\n  padding: 0;\n  margin: 0;\n  border: 0;\n}\n\nlegend {\n  display: block;\n  width: 100%;\n  padding: 0;\n  margin-bottom: @line-height-computed;\n  font-size: (@font-size-base * 1.5);\n  line-height: inherit;\n  color: @legend-color;\n  border: 0;\n  border-bottom: 1px solid @legend-border-color;\n}\n\nlabel {\n  display: inline-block;\n  margin-bottom: 5px;\n  font-weight: bold;\n}\n\n\n// Normalize form controls\n\n// Override content-box in Normalize (* isn't specific enough)\ninput[type=\"search\"] {\n  .box-sizing(border-box);\n}\n\n// Position radios and checkboxes better\ninput[type=\"radio\"],\ninput[type=\"checkbox\"] {\n  margin: 4px 0 0;\n  margin-top: 1px \\9; /* IE8-9 */\n  line-height: normal;\n}\n\n// Set the height of select and file controls to match text inputs\ninput[type=\"file\"] {\n  display: block;\n}\n\n// Make multiple select elements height not fixed\nselect[multiple],\nselect[size] {\n  height: auto;\n}\n\n// Fix optgroup Firefox bug per https://github.com/twbs/bootstrap/issues/7611\nselect optgroup {\n  font-size: inherit;\n  font-style: inherit;\n  font-family: inherit;\n}\n\n// Focus for select, file, radio, and checkbox\ninput[type=\"file\"]:focus,\ninput[type=\"radio\"]:focus,\ninput[type=\"checkbox\"]:focus {\n  .tab-focus();\n}\n\n// Fix for Chrome number input\n// Setting certain font-sizes causes the `I` bar to appear on hover of the bottom increment button.\n// See https://github.com/twbs/bootstrap/issues/8350 for more.\ninput[type=\"number\"] {\n  &::-webkit-outer-spin-button,\n  &::-webkit-inner-spin-button {\n    height: auto;\n  }\n}\n\n// Adjust output element\noutput {\n  display: block;\n  padding-top: (@padding-base-vertical + 1);\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n  vertical-align: middle;\n}\n\n\n// Common form controls\n//\n// Shared size and type resets for form controls. Apply `.form-control` to any\n// of the following form controls:\n//\n// select\n// textarea\n// input[type=\"text\"]\n// input[type=\"password\"]\n// input[type=\"datetime\"]\n// input[type=\"datetime-local\"]\n// input[type=\"date\"]\n// input[type=\"month\"]\n// input[type=\"time\"]\n// input[type=\"week\"]\n// input[type=\"number\"]\n// input[type=\"email\"]\n// input[type=\"url\"]\n// input[type=\"search\"]\n// input[type=\"tel\"]\n// input[type=\"color\"]\n\n.form-control {\n  display: block;\n  width: 100%;\n  height: @input-height-base; // Make inputs at least the height of their button counterpart (base line-height + padding + border)\n  padding: @padding-base-vertical @padding-base-horizontal;\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @input-color;\n  vertical-align: middle;\n  background-color: @input-bg;\n  background-image: none; // Reset unusual Firefox-on-Android default style; see https://github.com/necolas/normalize.css/issues/214\n  border: 1px solid @input-border;\n  border-radius: @input-border-radius;\n  .box-shadow(inset 0 1px 1px rgba(0,0,0,.075));\n  .transition(~\"border-color ease-in-out .15s, box-shadow ease-in-out .15s\");\n\n  // Customize the `:focus` state to imitate native WebKit styles.\n  .form-control-focus();\n\n  // Placeholder\n  //\n  // Placeholder text gets special styles because when browsers invalidate entire\n  // lines if it doesn't understand a selector/\n  .placeholder();\n\n  // Disabled and read-only inputs\n  // Note: HTML5 says that controls under a fieldset > legend:first-child won't\n  // be disabled if the fieldset is disabled. Due to implementation difficulty,\n  // we don't honor that edge case; we style them as disabled anyway.\n  &[disabled],\n  &[readonly],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n    background-color: @input-bg-disabled;\n  }\n\n  // Reset height for `textarea`s\n  textarea& {\n    height: auto;\n  }\n}\n\n\n// Form groups\n//\n// Designed to help with the organization and spacing of vertical forms. For\n// horizontal forms, use the predefined grid classes.\n\n.form-group {\n  margin-bottom: 15px;\n}\n\n\n// Checkboxes and radios\n//\n// Indent the labels to position radios/checkboxes as hanging controls.\n\n.radio,\n.checkbox {\n  display: block;\n  min-height: @line-height-computed; // clear the floating input if there is no label text\n  margin-top: 10px;\n  margin-bottom: 10px;\n  padding-left: 20px;\n  vertical-align: middle;\n  label {\n    display: inline;\n    margin-bottom: 0;\n    font-weight: normal;\n    cursor: pointer;\n  }\n}\n.radio input[type=\"radio\"],\n.radio-inline input[type=\"radio\"],\n.checkbox input[type=\"checkbox\"],\n.checkbox-inline input[type=\"checkbox\"] {\n  float: left;\n  margin-left: -20px;\n}\n.radio + .radio,\n.checkbox + .checkbox {\n  margin-top: -5px; // Move up sibling radios or checkboxes for tighter spacing\n}\n\n// Radios and checkboxes on same line\n.radio-inline,\n.checkbox-inline {\n  display: inline-block;\n  padding-left: 20px;\n  margin-bottom: 0;\n  vertical-align: middle;\n  font-weight: normal;\n  cursor: pointer;\n}\n.radio-inline + .radio-inline,\n.checkbox-inline + .checkbox-inline {\n  margin-top: 0;\n  margin-left: 10px; // space out consecutive inline controls\n}\n\n// Apply same disabled cursor tweak as for inputs\n//\n// Note: Neither radios nor checkboxes can be readonly.\ninput[type=\"radio\"],\ninput[type=\"checkbox\"],\n.radio,\n.radio-inline,\n.checkbox,\n.checkbox-inline {\n  &[disabled],\n  fieldset[disabled] & {\n    cursor: not-allowed;\n  }\n}\n\n// Form control sizing\n.input-sm {\n  .input-size(@input-height-small; @padding-small-vertical; @padding-small-horizontal; @font-size-small; @line-height-small; @border-radius-small);\n}\n\n.input-lg {\n  .input-size(@input-height-large; @padding-large-vertical; @padding-large-horizontal; @font-size-large; @line-height-large; @border-radius-large);\n}\n\n\n// Form control feedback states\n//\n// Apply contextual and semantic states to individual form controls.\n\n// Warning\n.has-warning {\n  .form-control-validation(@state-warning-text; @state-warning-text; @state-warning-bg);\n}\n// Error\n.has-error {\n  .form-control-validation(@state-danger-text; @state-danger-text; @state-danger-bg);\n}\n// Success\n.has-success {\n  .form-control-validation(@state-success-text; @state-success-text; @state-success-bg);\n}\n\n\n// Static form control text\n//\n// Apply class to a `p` element to make any string of text align with labels in\n// a horizontal form layout.\n\n.form-control-static {\n  margin-bottom: 0; // Remove default margin from `p`\n}\n\n\n// Help text\n//\n// Apply to any element you wish to create light text for placement immediately\n// below a form control. Use for general help, formatting, or instructional text.\n\n.help-block {\n  display: block; // account for any element using help-block\n  margin-top: 5px;\n  margin-bottom: 10px;\n  color: lighten(@text-color, 25%); // lighten the text some for contrast\n}\n\n\n\n// Inline forms\n//\n// Make forms appear inline(-block) by adding the `.form-inline` class. Inline\n// forms begin stacked on extra small (mobile) devices and then go inline when\n// viewports reach <768px.\n//\n// Requires wrapping inputs and labels with `.form-group` for proper display of\n// default HTML form controls and our custom form controls (e.g., input groups).\n//\n// Heads up! This is mixin-ed into `.navbar-form` in navbars.less.\n\n.form-inline {\n\n  // Kick in the inline\n  @media (min-width: @screen-sm) {\n    // Inline-block all the things for \"inline\"\n    .form-group  {\n      display: inline-block;\n      margin-bottom: 0;\n      vertical-align: middle;\n    }\n\n    // In navbar-form, allow folks to *not* use `.form-group`\n    .form-control {\n      display: inline-block;\n    }\n\n    // Remove default margin on radios/checkboxes that were used for stacking, and\n    // then undo the floating of radios and checkboxes to match (which also avoids\n    // a bug in WebKit: https://github.com/twbs/bootstrap/issues/1969).\n    .radio,\n    .checkbox {\n      display: inline-block;\n      margin-top: 0;\n      margin-bottom: 0;\n      padding-left: 0;\n    }\n    .radio input[type=\"radio\"],\n    .checkbox input[type=\"checkbox\"] {\n      float: none;\n      margin-left: 0;\n    }\n  }\n}\n\n\n// Horizontal forms\n//\n// Horizontal forms are built on grid classes and allow you to create forms with\n// labels on the left and inputs on the right.\n\n.form-horizontal {\n\n  // Consistent vertical alignment of labels, radios, and checkboxes\n  .control-label,\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline {\n    margin-top: 0;\n    margin-bottom: 0;\n    padding-top: (@padding-base-vertical + 1); // Default padding plus a border\n  }\n\n  // Make form groups behave like rows\n  .form-group {\n    .make-row();\n  }\n\n  .form-control-static {\n    padding-top: (@padding-base-vertical + 1);\n  }\n\n  // Only right align form labels here when the columns stop stacking\n  @media (min-width: @screen-sm-min) {\n    .control-label {\n      text-align: right;\n    }\n  }\n}\n","glyphicons.less":"//\n// Glyphicons for Bootstrap\n//\n// Since icons are fonts, they can be placed anywhere text is placed and are\n// thus automatically sized to match the surrounding child. To use, create an\n// inline element with the appropriate classes, like so:\n//\n// <a href=\"#\"><span class=\"glyphicon glyphicon-star\"></span> Star</a>\n\n// Import the fonts\n@font-face {\n  font-family: 'Glyphicons Halflings';\n  src: url('@{icon-font-path}@{icon-font-name}.eot');\n  src: url('@{icon-font-path}@{icon-font-name}.eot?#iefix') format('embedded-opentype'),\n       url('@{icon-font-path}@{icon-font-name}.woff') format('woff'),\n       url('@{icon-font-path}@{icon-font-name}.ttf') format('truetype'),\n       url('@{icon-font-path}@{icon-font-name}.svg#glyphicons_halflingsregular') format('svg');\n}\n\n// Catchall baseclass\n.glyphicon {\n  position: relative;\n  top: 1px;\n  display: inline-block;\n  font-family: 'Glyphicons Halflings';\n  font-style: normal;\n  font-weight: normal;\n  line-height: 1;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n\n  &:empty {\n    width: 1em;\n  }\n}\n\n// Individual icons\n.glyphicon-asterisk               { &:before { content: \"\\2a\"; } }\n.glyphicon-plus                   { &:before { content: \"\\2b\"; } }\n.glyphicon-euro                   { &:before { content: \"\\20ac\"; } }\n.glyphicon-minus                  { &:before { content: \"\\2212\"; } }\n.glyphicon-cloud                  { &:before { content: \"\\2601\"; } }\n.glyphicon-envelope               { &:before { content: \"\\2709\"; } }\n.glyphicon-pencil                 { &:before { content: \"\\270f\"; } }\n.glyphicon-glass                  { &:before { content: \"\\e001\"; } }\n.glyphicon-music                  { &:before { content: \"\\e002\"; } }\n.glyphicon-search                 { &:before { content: \"\\e003\"; } }\n.glyphicon-heart                  { &:before { content: \"\\e005\"; } }\n.glyphicon-star                   { &:before { content: \"\\e006\"; } }\n.glyphicon-star-empty             { &:before { content: \"\\e007\"; } }\n.glyphicon-user                   { &:before { content: \"\\e008\"; } }\n.glyphicon-film                   { &:before { content: \"\\e009\"; } }\n.glyphicon-th-large               { &:before { content: \"\\e010\"; } }\n.glyphicon-th                     { &:before { content: \"\\e011\"; } }\n.glyphicon-th-list                { &:before { content: \"\\e012\"; } }\n.glyphicon-ok                     { &:before { content: \"\\e013\"; } }\n.glyphicon-remove                 { &:before { content: \"\\e014\"; } }\n.glyphicon-zoom-in                { &:before { content: \"\\e015\"; } }\n.glyphicon-zoom-out               { &:before { content: \"\\e016\"; } }\n.glyphicon-off                    { &:before { content: \"\\e017\"; } }\n.glyphicon-signal                 { &:before { content: \"\\e018\"; } }\n.glyphicon-cog                    { &:before { content: \"\\e019\"; } }\n.glyphicon-trash                  { &:before { content: \"\\e020\"; } }\n.glyphicon-home                   { &:before { content: \"\\e021\"; } }\n.glyphicon-file                   { &:before { content: \"\\e022\"; } }\n.glyphicon-time                   { &:before { content: \"\\e023\"; } }\n.glyphicon-road                   { &:before { content: \"\\e024\"; } }\n.glyphicon-download-alt           { &:before { content: \"\\e025\"; } }\n.glyphicon-download               { &:before { content: \"\\e026\"; } }\n.glyphicon-upload                 { &:before { content: \"\\e027\"; } }\n.glyphicon-inbox                  { &:before { content: \"\\e028\"; } }\n.glyphicon-play-circle            { &:before { content: \"\\e029\"; } }\n.glyphicon-repeat                 { &:before { content: \"\\e030\"; } }\n.glyphicon-refresh                { &:before { content: \"\\e031\"; } }\n.glyphicon-list-alt               { &:before { content: \"\\e032\"; } }\n.glyphicon-lock                   { &:before { content: \"\\e033\"; } }\n.glyphicon-flag                   { &:before { content: \"\\e034\"; } }\n.glyphicon-headphones             { &:before { content: \"\\e035\"; } }\n.glyphicon-volume-off             { &:before { content: \"\\e036\"; } }\n.glyphicon-volume-down            { &:before { content: \"\\e037\"; } }\n.glyphicon-volume-up              { &:before { content: \"\\e038\"; } }\n.glyphicon-qrcode                 { &:before { content: \"\\e039\"; } }\n.glyphicon-barcode                { &:before { content: \"\\e040\"; } }\n.glyphicon-tag                    { &:before { content: \"\\e041\"; } }\n.glyphicon-tags                   { &:before { content: \"\\e042\"; } }\n.glyphicon-book                   { &:before { content: \"\\e043\"; } }\n.glyphicon-bookmark               { &:before { content: \"\\e044\"; } }\n.glyphicon-print                  { &:before { content: \"\\e045\"; } }\n.glyphicon-camera                 { &:before { content: \"\\e046\"; } }\n.glyphicon-font                   { &:before { content: \"\\e047\"; } }\n.glyphicon-bold                   { &:before { content: \"\\e048\"; } }\n.glyphicon-italic                 { &:before { content: \"\\e049\"; } }\n.glyphicon-text-height            { &:before { content: \"\\e050\"; } }\n.glyphicon-text-width             { &:before { content: \"\\e051\"; } }\n.glyphicon-align-left             { &:before { content: \"\\e052\"; } }\n.glyphicon-align-center           { &:before { content: \"\\e053\"; } }\n.glyphicon-align-right            { &:before { content: \"\\e054\"; } }\n.glyphicon-align-justify          { &:before { content: \"\\e055\"; } }\n.glyphicon-list                   { &:before { content: \"\\e056\"; } }\n.glyphicon-indent-left            { &:before { content: \"\\e057\"; } }\n.glyphicon-indent-right           { &:before { content: \"\\e058\"; } }\n.glyphicon-facetime-video         { &:before { content: \"\\e059\"; } }\n.glyphicon-picture                { &:before { content: \"\\e060\"; } }\n.glyphicon-map-marker             { &:before { content: \"\\e062\"; } }\n.glyphicon-adjust                 { &:before { content: \"\\e063\"; } }\n.glyphicon-tint                   { &:before { content: \"\\e064\"; } }\n.glyphicon-edit                   { &:before { content: \"\\e065\"; } }\n.glyphicon-share                  { &:before { content: \"\\e066\"; } }\n.glyphicon-check                  { &:before { content: \"\\e067\"; } }\n.glyphicon-move                   { &:before { content: \"\\e068\"; } }\n.glyphicon-step-backward          { &:before { content: \"\\e069\"; } }\n.glyphicon-fast-backward          { &:before { content: \"\\e070\"; } }\n.glyphicon-backward               { &:before { content: \"\\e071\"; } }\n.glyphicon-play                   { &:before { content: \"\\e072\"; } }\n.glyphicon-pause                  { &:before { content: \"\\e073\"; } }\n.glyphicon-stop                   { &:before { content: \"\\e074\"; } }\n.glyphicon-forward                { &:before { content: \"\\e075\"; } }\n.glyphicon-fast-forward           { &:before { content: \"\\e076\"; } }\n.glyphicon-step-forward           { &:before { content: \"\\e077\"; } }\n.glyphicon-eject                  { &:before { content: \"\\e078\"; } }\n.glyphicon-chevron-left           { &:before { content: \"\\e079\"; } }\n.glyphicon-chevron-right          { &:before { content: \"\\e080\"; } }\n.glyphicon-plus-sign              { &:before { content: \"\\e081\"; } }\n.glyphicon-minus-sign             { &:before { content: \"\\e082\"; } }\n.glyphicon-remove-sign            { &:before { content: \"\\e083\"; } }\n.glyphicon-ok-sign                { &:before { content: \"\\e084\"; } }\n.glyphicon-question-sign          { &:before { content: \"\\e085\"; } }\n.glyphicon-info-sign              { &:before { content: \"\\e086\"; } }\n.glyphicon-screenshot             { &:before { content: \"\\e087\"; } }\n.glyphicon-remove-circle          { &:before { content: \"\\e088\"; } }\n.glyphicon-ok-circle              { &:before { content: \"\\e089\"; } }\n.glyphicon-ban-circle             { &:before { content: \"\\e090\"; } }\n.glyphicon-arrow-left             { &:before { content: \"\\e091\"; } }\n.glyphicon-arrow-right            { &:before { content: \"\\e092\"; } }\n.glyphicon-arrow-up               { &:before { content: \"\\e093\"; } }\n.glyphicon-arrow-down             { &:before { content: \"\\e094\"; } }\n.glyphicon-share-alt              { &:before { content: \"\\e095\"; } }\n.glyphicon-resize-full            { &:before { content: \"\\e096\"; } }\n.glyphicon-resize-small           { &:before { content: \"\\e097\"; } }\n.glyphicon-exclamation-sign       { &:before { content: \"\\e101\"; } }\n.glyphicon-gift                   { &:before { content: \"\\e102\"; } }\n.glyphicon-leaf                   { &:before { content: \"\\e103\"; } }\n.glyphicon-fire                   { &:before { content: \"\\e104\"; } }\n.glyphicon-eye-open               { &:before { content: \"\\e105\"; } }\n.glyphicon-eye-close              { &:before { content: \"\\e106\"; } }\n.glyphicon-warning-sign           { &:before { content: \"\\e107\"; } }\n.glyphicon-plane                  { &:before { content: \"\\e108\"; } }\n.glyphicon-calendar               { &:before { content: \"\\e109\"; } }\n.glyphicon-random                 { &:before { content: \"\\e110\"; } }\n.glyphicon-comment                { &:before { content: \"\\e111\"; } }\n.glyphicon-magnet                 { &:before { content: \"\\e112\"; } }\n.glyphicon-chevron-up             { &:before { content: \"\\e113\"; } }\n.glyphicon-chevron-down           { &:before { content: \"\\e114\"; } }\n.glyphicon-retweet                { &:before { content: \"\\e115\"; } }\n.glyphicon-shopping-cart          { &:before { content: \"\\e116\"; } }\n.glyphicon-folder-close           { &:before { content: \"\\e117\"; } }\n.glyphicon-folder-open            { &:before { content: \"\\e118\"; } }\n.glyphicon-resize-vertical        { &:before { content: \"\\e119\"; } }\n.glyphicon-resize-horizontal      { &:before { content: \"\\e120\"; } }\n.glyphicon-hdd                    { &:before { content: \"\\e121\"; } }\n.glyphicon-bullhorn               { &:before { content: \"\\e122\"; } }\n.glyphicon-bell                   { &:before { content: \"\\e123\"; } }\n.glyphicon-certificate            { &:before { content: \"\\e124\"; } }\n.glyphicon-thumbs-up              { &:before { content: \"\\e125\"; } }\n.glyphicon-thumbs-down            { &:before { content: \"\\e126\"; } }\n.glyphicon-hand-right             { &:before { content: \"\\e127\"; } }\n.glyphicon-hand-left              { &:before { content: \"\\e128\"; } }\n.glyphicon-hand-up                { &:before { content: \"\\e129\"; } }\n.glyphicon-hand-down              { &:before { content: \"\\e130\"; } }\n.glyphicon-circle-arrow-right     { &:before { content: \"\\e131\"; } }\n.glyphicon-circle-arrow-left      { &:before { content: \"\\e132\"; } }\n.glyphicon-circle-arrow-up        { &:before { content: \"\\e133\"; } }\n.glyphicon-circle-arrow-down      { &:before { content: \"\\e134\"; } }\n.glyphicon-globe                  { &:before { content: \"\\e135\"; } }\n.glyphicon-wrench                 { &:before { content: \"\\e136\"; } }\n.glyphicon-tasks                  { &:before { content: \"\\e137\"; } }\n.glyphicon-filter                 { &:before { content: \"\\e138\"; } }\n.glyphicon-briefcase              { &:before { content: \"\\e139\"; } }\n.glyphicon-fullscreen             { &:before { content: \"\\e140\"; } }\n.glyphicon-dashboard              { &:before { content: \"\\e141\"; } }\n.glyphicon-paperclip              { &:before { content: \"\\e142\"; } }\n.glyphicon-heart-empty            { &:before { content: \"\\e143\"; } }\n.glyphicon-link                   { &:before { content: \"\\e144\"; } }\n.glyphicon-phone                  { &:before { content: \"\\e145\"; } }\n.glyphicon-pushpin                { &:before { content: \"\\e146\"; } }\n.glyphicon-usd                    { &:before { content: \"\\e148\"; } }\n.glyphicon-gbp                    { &:before { content: \"\\e149\"; } }\n.glyphicon-sort                   { &:before { content: \"\\e150\"; } }\n.glyphicon-sort-by-alphabet       { &:before { content: \"\\e151\"; } }\n.glyphicon-sort-by-alphabet-alt   { &:before { content: \"\\e152\"; } }\n.glyphicon-sort-by-order          { &:before { content: \"\\e153\"; } }\n.glyphicon-sort-by-order-alt      { &:before { content: \"\\e154\"; } }\n.glyphicon-sort-by-attributes     { &:before { content: \"\\e155\"; } }\n.glyphicon-sort-by-attributes-alt { &:before { content: \"\\e156\"; } }\n.glyphicon-unchecked              { &:before { content: \"\\e157\"; } }\n.glyphicon-expand                 { &:before { content: \"\\e158\"; } }\n.glyphicon-collapse-down          { &:before { content: \"\\e159\"; } }\n.glyphicon-collapse-up            { &:before { content: \"\\e160\"; } }\n.glyphicon-log-in                 { &:before { content: \"\\e161\"; } }\n.glyphicon-flash                  { &:before { content: \"\\e162\"; } }\n.glyphicon-log-out                { &:before { content: \"\\e163\"; } }\n.glyphicon-new-window             { &:before { content: \"\\e164\"; } }\n.glyphicon-record                 { &:before { content: \"\\e165\"; } }\n.glyphicon-save                   { &:before { content: \"\\e166\"; } }\n.glyphicon-open                   { &:before { content: \"\\e167\"; } }\n.glyphicon-saved                  { &:before { content: \"\\e168\"; } }\n.glyphicon-import                 { &:before { content: \"\\e169\"; } }\n.glyphicon-export                 { &:before { content: \"\\e170\"; } }\n.glyphicon-send                   { &:before { content: \"\\e171\"; } }\n.glyphicon-floppy-disk            { &:before { content: \"\\e172\"; } }\n.glyphicon-floppy-saved           { &:before { content: \"\\e173\"; } }\n.glyphicon-floppy-remove          { &:before { content: \"\\e174\"; } }\n.glyphicon-floppy-save            { &:before { content: \"\\e175\"; } }\n.glyphicon-floppy-open            { &:before { content: \"\\e176\"; } }\n.glyphicon-credit-card            { &:before { content: \"\\e177\"; } }\n.glyphicon-transfer               { &:before { content: \"\\e178\"; } }\n.glyphicon-cutlery                { &:before { content: \"\\e179\"; } }\n.glyphicon-header                 { &:before { content: \"\\e180\"; } }\n.glyphicon-compressed             { &:before { content: \"\\e181\"; } }\n.glyphicon-earphone               { &:before { content: \"\\e182\"; } }\n.glyphicon-phone-alt              { &:before { content: \"\\e183\"; } }\n.glyphicon-tower                  { &:before { content: \"\\e184\"; } }\n.glyphicon-stats                  { &:before { content: \"\\e185\"; } }\n.glyphicon-sd-video               { &:before { content: \"\\e186\"; } }\n.glyphicon-hd-video               { &:before { content: \"\\e187\"; } }\n.glyphicon-subtitles              { &:before { content: \"\\e188\"; } }\n.glyphicon-sound-stereo           { &:before { content: \"\\e189\"; } }\n.glyphicon-sound-dolby            { &:before { content: \"\\e190\"; } }\n.glyphicon-sound-5-1              { &:before { content: \"\\e191\"; } }\n.glyphicon-sound-6-1              { &:before { content: \"\\e192\"; } }\n.glyphicon-sound-7-1              { &:before { content: \"\\e193\"; } }\n.glyphicon-copyright-mark         { &:before { content: \"\\e194\"; } }\n.glyphicon-registration-mark      { &:before { content: \"\\e195\"; } }\n.glyphicon-cloud-download         { &:before { content: \"\\e197\"; } }\n.glyphicon-cloud-upload           { &:before { content: \"\\e198\"; } }\n.glyphicon-tree-conifer           { &:before { content: \"\\e199\"; } }\n.glyphicon-tree-deciduous         { &:before { content: \"\\e200\"; } }\n","grid.less":"//\n// Grid system\n// --------------------------------------------------\n\n// Set the container width, and override it for fixed navbars in media queries\n.container {\n  .container-fixed();\n}\n\n// mobile first defaults\n.row {\n  .make-row();\n}\n\n// Common styles for small and large grid columns\n.make-grid-columns();\n\n\n// Extra small grid\n//\n// Grid classes for extra small devices like smartphones. No offset, push, or\n// pull classes are present here due to the size of the target.\n//\n// Note that `.col-xs-12` doesn't get floated on purpose--there's no need since\n// it's full-width.\n\n.make-grid-columns-float(xs);\n.make-grid(@grid-columns, xs, width);\n.make-grid(@grid-columns, xs, pull);\n.make-grid(@grid-columns, xs, push);\n.make-grid(@grid-columns, xs, offset);\n\n\n// Small grid\n//\n// Columns, offsets, pushes, and pulls for the small device range, from phones\n// to tablets.\n//\n// Note that `.col-sm-12` doesn't get floated on purpose--there's no need since\n// it's full-width.\n\n@media (min-width: @screen-sm-min) {\n  .container {\n    width: @container-sm;\n  }\n\n  .make-grid-columns-float(sm);\n  .make-grid(@grid-columns, sm, width);\n  .make-grid(@grid-columns, sm, pull);\n  .make-grid(@grid-columns, sm, push);\n  .make-grid(@grid-columns, sm, offset);\n}\n\n\n// Medium grid\n//\n// Columns, offsets, pushes, and pulls for the desktop device range.\n//\n// Note that `.col-md-12` doesn't get floated on purpose--there's no need since\n// it's full-width.\n\n@media (min-width: @screen-md-min) {\n  .container {\n    width: @container-md;\n  }\n\n  .make-grid-columns-float(md);\n  .make-grid(@grid-columns, md, width);\n  .make-grid(@grid-columns, md, pull);\n  .make-grid(@grid-columns, md, push);\n  .make-grid(@grid-columns, md, offset);\n}\n\n\n// Large grid\n//\n// Columns, offsets, pushes, and pulls for the large desktop device range.\n//\n// Note that `.col-lg-12` doesn't get floated on purpose--there's no need since\n// it's full-width.\n\n@media (min-width: @screen-lg-min) {\n  .container {\n    width: @container-lg;\n  }\n\n  .make-grid-columns-float(lg);\n  .make-grid(@grid-columns, lg, width);\n  .make-grid(@grid-columns, lg, pull);\n  .make-grid(@grid-columns, lg, push);\n  .make-grid(@grid-columns, lg, offset);\n}\n\n","input-groups.less":"//\n// Input groups\n// --------------------------------------------------\n\n// Base styles\n// -------------------------\n.input-group {\n  position: relative; // For dropdowns\n  display: table;\n  border-collapse: separate; // prevent input groups from inheriting border styles from table cells when placed within a table\n\n  // Undo padding and float of grid classes\n  &.col {\n    float: none;\n    padding-left: 0;\n    padding-right: 0;\n  }\n\n  .form-control {\n    width: 100%;\n    margin-bottom: 0;\n  }\n}\n\n// Sizing options\n//\n// Remix the default form control sizing classes into new ones for easier\n// manipulation.\n\n.input-group-lg > .form-control,\n.input-group-lg > .input-group-addon,\n.input-group-lg > .input-group-btn > .btn { .input-lg(); }\n.input-group-sm > .form-control,\n.input-group-sm > .input-group-addon,\n.input-group-sm > .input-group-btn > .btn { .input-sm(); }\n\n\n// Display as table-cell\n// -------------------------\n.input-group-addon,\n.input-group-btn,\n.input-group .form-control {\n  display: table-cell;\n\n  &:not(:first-child):not(:last-child) {\n    border-radius: 0;\n  }\n}\n// Addon and addon wrapper for buttons\n.input-group-addon,\n.input-group-btn {\n  width: 1%;\n  white-space: nowrap;\n  vertical-align: middle; // Match the inputs\n}\n\n// Text input groups\n// -------------------------\n.input-group-addon {\n  padding: @padding-base-vertical @padding-base-horizontal;\n  font-size: @font-size-base;\n  font-weight: normal;\n  line-height: 1;\n  color: @input-color;\n  text-align: center;\n  background-color: @input-group-addon-bg;\n  border: 1px solid @input-group-addon-border-color;\n  border-radius: @border-radius-base;\n\n  // Sizing\n  &.input-sm {\n    padding: @padding-small-vertical @padding-small-horizontal;\n    font-size: @font-size-small;\n    border-radius: @border-radius-small;\n  }\n  &.input-lg {\n    padding: @padding-large-vertical @padding-large-horizontal;\n    font-size: @font-size-large;\n    border-radius: @border-radius-large;\n  }\n\n  // Nuke default margins from checkboxes and radios to vertically center within.\n  input[type=\"radio\"],\n  input[type=\"checkbox\"] {\n    margin-top: 0;\n  }\n}\n\n// Reset rounded corners\n.input-group .form-control:first-child,\n.input-group-addon:first-child,\n.input-group-btn:first-child > .btn,\n.input-group-btn:first-child > .dropdown-toggle,\n.input-group-btn:last-child > .btn:not(:last-child):not(.dropdown-toggle) {\n  .border-right-radius(0);\n}\n.input-group-addon:first-child {\n  border-right: 0;\n}\n.input-group .form-control:last-child,\n.input-group-addon:last-child,\n.input-group-btn:last-child > .btn,\n.input-group-btn:last-child > .dropdown-toggle,\n.input-group-btn:first-child > .btn:not(:first-child) {\n  .border-left-radius(0);\n}\n.input-group-addon:last-child {\n  border-left: 0;\n}\n\n// Button input groups\n// -------------------------\n.input-group-btn {\n  position: relative;\n  white-space: nowrap;\n\n  // Negative margin to only have a 1px border between the two\n  &:first-child > .btn {\n    margin-right: -1px;\n  }\n  &:last-child > .btn {\n    margin-left: -1px;\n  }\n}\n.input-group-btn > .btn {\n  position: relative;\n  // Jankily prevent input button groups from wrapping\n  + .btn {\n    margin-left: -4px;\n  }\n  // Bring the \"active\" button to the front\n  &:hover,\n  &:active {\n    z-index: 2;\n  }\n}\n","jumbotron.less":"//\n// Jumbotron\n// --------------------------------------------------\n\n\n.jumbotron {\n  padding: @jumbotron-padding;\n  margin-bottom: @jumbotron-padding;\n  font-size: @jumbotron-font-size;\n  font-weight: 200;\n  line-height: (@line-height-base * 1.5);\n  color: @jumbotron-color;\n  background-color: @jumbotron-bg;\n\n  h1 {\n    line-height: 1;\n    color: @jumbotron-heading-color;\n  }\n  p {\n    line-height: 1.4;\n  }\n\n  .container & {\n    border-radius: @border-radius-large; // Only round corners at higher resolutions if contained in a container\n  }\n\n  @media screen and (min-width: @screen-sm-min) {\n    padding-top:    (@jumbotron-padding * 1.6);\n    padding-bottom: (@jumbotron-padding * 1.6);\n\n    .container & {\n      padding-left:  (@jumbotron-padding * 2);\n      padding-right: (@jumbotron-padding * 2);\n    }\n\n    h1 {\n      font-size: (@font-size-base * 4.5);\n    }\n  }\n}\n","labels.less":"//\n// Labels\n// --------------------------------------------------\n\n.label {\n  display: inline;\n  padding: .2em .6em .3em;\n  font-size: 75%;\n  font-weight: bold;\n  line-height: 1;\n  color: @label-color;\n  text-align: center;\n  white-space: nowrap;\n  vertical-align: baseline;\n  border-radius: .25em;\n\n  // Add hover effects, but only for links\n  &[href] {\n    &:hover,\n    &:focus {\n      color: @label-link-hover-color;\n      text-decoration: none;\n      cursor: pointer;\n    }\n  }\n\n  // Empty labels collapse automatically (not available in IE8)\n  &:empty {\n    display: none;\n  }\n}\n\n// Colors\n// Contextual variations (linked labels get darker on :hover)\n\n.label-default {\n  .label-variant(@label-default-bg);\n}\n\n.label-primary {\n  .label-variant(@label-primary-bg);\n}\n\n.label-success {\n  .label-variant(@label-success-bg);\n}\n\n.label-info {\n  .label-variant(@label-info-bg);\n}\n\n.label-warning {\n  .label-variant(@label-warning-bg);\n}\n\n.label-danger {\n  .label-variant(@label-danger-bg);\n}\n","list-group.less":"//\n// List groups\n// --------------------------------------------------\n\n// Base class\n//\n// Easily usable on <ul>, <ol>, or <div>.\n.list-group {\n  // No need to set list-style: none; since .list-group-item is block level\n  margin-bottom: 20px;\n  padding-left: 0; // reset padding because ul and ol\n}\n\n// Individual list items\n// -------------------------\n\n.list-group-item {\n  position: relative;\n  display: block;\n  padding: 10px 15px;\n  // Place the border on the list items and negative margin up for better styling\n  margin-bottom: -1px;\n  background-color: @list-group-bg;\n  border: 1px solid @list-group-border;\n\n  // Round the first and last items\n  &:first-child {\n    .border-top-radius(@list-group-border-radius);\n  }\n  &:last-child {\n    margin-bottom: 0;\n    .border-bottom-radius(@list-group-border-radius);\n  }\n\n  // Align badges within list items\n  > .badge {\n    float: right;\n  }\n  > .badge + .badge {\n    margin-right: 5px;\n  }\n}\n\n// Linked list items\na.list-group-item {\n  color: @list-group-link-color;\n\n  .list-group-item-heading {\n    color: @list-group-link-heading-color;\n  }\n\n  // Hover state\n  &:hover,\n  &:focus {\n    text-decoration: none;\n    background-color: @list-group-hover-bg;\n  }\n\n  // Active class on item itself, not parent\n  &.active,\n  &.active:hover,\n  &.active:focus {\n    z-index: 2; // Place active items above their siblings for proper border styling\n    color: @list-group-active-color;\n    background-color: @list-group-active-bg;\n    border-color: @list-group-active-border;\n\n    // Force color to inherit for custom content\n    .list-group-item-heading {\n      color: inherit;\n    }\n    .list-group-item-text {\n      color: lighten(@list-group-active-bg, 40%);\n    }\n  }\n}\n\n// Custom content options\n// -------------------------\n\n.list-group-item-heading {\n  margin-top: 0;\n  margin-bottom: 5px;\n}\n.list-group-item-text {\n  margin-bottom: 0;\n  line-height: 1.3;\n}\n","media.less":"// Media objects\n// Source: http://stubbornella.org/content/?p=497\n// --------------------------------------------------\n\n\n// Common styles\n// -------------------------\n\n// Clear the floats\n.media,\n.media-body {\n  overflow: hidden;\n  zoom: 1;\n}\n\n// Proper spacing between instances of .media\n.media,\n.media .media {\n  margin-top: 15px;\n}\n.media:first-child {\n  margin-top: 0;\n}\n\n// For images and videos, set to block\n.media-object {\n  display: block;\n}\n\n// Reset margins on headings for tighter default spacing\n.media-heading {\n  margin: 0 0 5px;\n}\n\n\n// Media image alignment\n// -------------------------\n\n.media {\n  > .pull-left {\n    margin-right: 10px;\n  }\n  > .pull-right {\n    margin-left: 10px;\n  }\n}\n\n\n// Media list variation\n// -------------------------\n\n// Undo default ul/ol styles\n.media-list {\n  padding-left: 0;\n  list-style: none;\n}\n","mixins.less":"//\n// Mixins\n// --------------------------------------------------\n\n\n// Utilities\n// -------------------------\n\n// Clearfix\n// Source: http://nicolasgallagher.com/micro-clearfix-hack/\n//\n// For modern browsers\n// 1. The space content is one way to avoid an Opera bug when the\n//    contenteditable attribute is included anywhere else in the document.\n//    Otherwise it causes space to appear at the top and bottom of elements\n//    that are clearfixed.\n// 2. The use of `table` rather than `block` is only necessary if using\n//    `:before` to contain the top-margins of child elements.\n.clearfix() {\n  &:before,\n  &:after {\n    content: \" \"; /* 1 */\n    display: table; /* 2 */\n  }\n  &:after {\n    clear: both;\n  }\n}\n\n// WebKit-style focus\n.tab-focus() {\n  // Default\n  outline: thin dotted #333;\n  // WebKit\n  outline: 5px auto -webkit-focus-ring-color;\n  outline-offset: -2px;\n}\n\n// Center-align a block level element\n.center-block() {\n  display: block;\n  margin-left: auto;\n  margin-right: auto;\n}\n\n// Sizing shortcuts\n.size(@width; @height) {\n  width: @width;\n  height: @height;\n}\n.square(@size) {\n  .size(@size; @size);\n}\n\n// Placeholder text\n.placeholder(@color: @input-color-placeholder) {\n  &:-moz-placeholder            { color: @color; } // Firefox 4-18\n  &::-moz-placeholder           { color: @color; } // Firefox 19+\n  &:-ms-input-placeholder       { color: @color; } // Internet Explorer 10+\n  &::-webkit-input-placeholder  { color: @color; } // Safari and Chrome\n}\n\n// Text overflow\n// Requires inline-block or block for proper styling\n.text-overflow() {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n// CSS image replacement\n//\n// Heads up! v3 launched with with only `.hide-text()`, but per our pattern for\n// mixins being reused as classes with the same name, this doesn't hold up. As\n// of v3.0.1 we have added `.text-hide()` and deprecated `.hide-text()`. Note\n// that we cannot chain the mixins together in Less, so they are repeated.\n//\n// Source: https://github.com/h5bp/html5-boilerplate/commit/aa0396eae757\n\n// Deprecated as of v3.0.1 (will be removed in v4)\n.hide-text() {\n  font: ~\"0/0\" a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0;\n}\n// New mixin to use as of v3.0.1\n.text-hide() {\n  font: ~\"0/0\" a;\n  color: transparent;\n  text-shadow: none;\n  background-color: transparent;\n  border: 0;\n}\n\n\n\n// CSS3 PROPERTIES\n// --------------------------------------------------\n\n// Single side border-radius\n.border-top-radius(@radius) {\n  border-top-right-radius: @radius;\n   border-top-left-radius: @radius;\n}\n.border-right-radius(@radius) {\n  border-bottom-right-radius: @radius;\n     border-top-right-radius: @radius;\n}\n.border-bottom-radius(@radius) {\n  border-bottom-right-radius: @radius;\n   border-bottom-left-radius: @radius;\n}\n.border-left-radius(@radius) {\n  border-bottom-left-radius: @radius;\n     border-top-left-radius: @radius;\n}\n\n// Drop shadows\n.box-shadow(@shadow) {\n  -webkit-box-shadow: @shadow; // iOS <4.3 & Android <4.1\n          box-shadow: @shadow;\n}\n\n// Transitions\n.transition(@transition) {\n  -webkit-transition: @transition;\n          transition: @transition;\n}\n.transition-property(@transition-property) {\n  -webkit-transition-property: @transition-property;\n          transition-property: @transition-property;\n}\n.transition-delay(@transition-delay) {\n  -webkit-transition-delay: @transition-delay;\n          transition-delay: @transition-delay;\n}\n.transition-duration(@transition-duration) {\n  -webkit-transition-duration: @transition-duration;\n          transition-duration: @transition-duration;\n}\n.transition-transform(@transition) {\n  -webkit-transition: -webkit-transform @transition;\n     -moz-transition: -moz-transform @transition;\n       -o-transition: -o-transform @transition;\n          transition: transform @transition;\n}\n\n// Transformations\n.rotate(@degrees) {\n  -webkit-transform: rotate(@degrees);\n      -ms-transform: rotate(@degrees); // IE9+\n          transform: rotate(@degrees);\n}\n.scale(@ratio) {\n  -webkit-transform: scale(@ratio);\n      -ms-transform: scale(@ratio); // IE9+\n          transform: scale(@ratio);\n}\n.translate(@x; @y) {\n  -webkit-transform: translate(@x, @y);\n      -ms-transform: translate(@x, @y); // IE9+\n          transform: translate(@x, @y);\n}\n.skew(@x; @y) {\n  -webkit-transform: skew(@x, @y);\n      -ms-transform: skewX(@x) skewY(@y); // See https://github.com/twbs/bootstrap/issues/4885; IE9+\n          transform: skew(@x, @y);\n}\n.translate3d(@x; @y; @z) {\n  -webkit-transform: translate3d(@x, @y, @z);\n          transform: translate3d(@x, @y, @z);\n}\n\n.rotateX(@degrees) {\n  -webkit-transform: rotateX(@degrees);\n      -ms-transform: rotateX(@degrees); // IE9+\n          transform: rotateX(@degrees);\n}\n.rotateY(@degrees) {\n  -webkit-transform: rotateY(@degrees);\n      -ms-transform: rotateY(@degrees); // IE9+\n          transform: rotateY(@degrees);\n}\n.perspective(@perspective) {\n  -webkit-perspective: @perspective;\n     -moz-perspective: @perspective;\n          perspective: @perspective;\n}\n.perspective-origin(@perspective) {\n  -webkit-perspective-origin: @perspective;\n     -moz-perspective-origin: @perspective;\n          perspective-origin: @perspective;\n}\n.transform-origin(@origin) {\n  -webkit-transform-origin: @origin;\n     -moz-transform-origin: @origin;\n          transform-origin: @origin;\n}\n\n// Animations\n.animation(@animation) {\n  -webkit-animation: @animation;\n          animation: @animation;\n}\n\n// Backface visibility\n// Prevent browsers from flickering when using CSS 3D transforms.\n// Default value is `visible`, but can be changed to `hidden`\n.backface-visibility(@visibility){\n  -webkit-backface-visibility: @visibility;\n     -moz-backface-visibility: @visibility;\n          backface-visibility: @visibility;\n}\n\n// Box sizing\n.box-sizing(@boxmodel) {\n  -webkit-box-sizing: @boxmodel;\n     -moz-box-sizing: @boxmodel;\n          box-sizing: @boxmodel;\n}\n\n// User select\n// For selecting text on the page\n.user-select(@select) {\n  -webkit-user-select: @select;\n     -moz-user-select: @select;\n      -ms-user-select: @select; // IE10+\n       -o-user-select: @select;\n          user-select: @select;\n}\n\n// Resize anything\n.resizable(@direction) {\n  resize: @direction; // Options: horizontal, vertical, both\n  overflow: auto; // Safari fix\n}\n\n// CSS3 Content Columns\n.content-columns(@column-count; @column-gap: @grid-gutter-width) {\n  -webkit-column-count: @column-count;\n     -moz-column-count: @column-count;\n          column-count: @column-count;\n  -webkit-column-gap: @column-gap;\n     -moz-column-gap: @column-gap;\n          column-gap: @column-gap;\n}\n\n// Optional hyphenation\n.hyphens(@mode: auto) {\n  word-wrap: break-word;\n  -webkit-hyphens: @mode;\n     -moz-hyphens: @mode;\n      -ms-hyphens: @mode; // IE10+\n       -o-hyphens: @mode;\n          hyphens: @mode;\n}\n\n// Opacity\n.opacity(@opacity) {\n  opacity: @opacity;\n  // IE8 filter\n  @opacity-ie: (@opacity * 100);\n  filter: ~\"alpha(opacity=@{opacity-ie})\";\n}\n\n\n\n// GRADIENTS\n// --------------------------------------------------\n\n#gradient {\n\n  // Horizontal gradient, from left to right\n  //\n  // Creates two color stops, start and end, by specifying a color and position for each color stop.\n  // Color stops are not available in IE9 and below.\n  .horizontal(@start-color: #555; @end-color: #333; @start-percent: 0%; @end-percent: 100%) {\n    background-image: -webkit-gradient(linear, @start-percent top, @end-percent top, from(@start-color), to(@end-color)); // Safari 4+, Chrome 2+\n    background-image: -webkit-linear-gradient(left, color-stop(@start-color @start-percent), color-stop(@end-color @end-percent)); // Safari 5.1+, Chrome 10+\n    background-image: -moz-linear-gradient(left, @start-color @start-percent, @end-color @end-percent); // FF 3.6+\n    background-image:  linear-gradient(to right, @start-color @start-percent, @end-color @end-percent); // Standard, IE10\n    background-repeat: repeat-x;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=1)\",argb(@start-color),argb(@end-color))); // IE9 and down\n  }\n\n  // Vertical gradient, from top to bottom\n  //\n  // Creates two color stops, start and end, by specifying a color and position for each color stop.\n  // Color stops are not available in IE9 and below.\n  .vertical(@start-color: #555; @end-color: #333; @start-percent: 0%; @end-percent: 100%) {\n    background-image: -webkit-gradient(linear, left @start-percent, left @end-percent, from(@start-color), to(@end-color)); // Safari 4+, Chrome 2+\n    background-image: -webkit-linear-gradient(top, @start-color @start-percent, @end-color @end-percent); // Safari 5.1+, Chrome 10+\n    background-image:  -moz-linear-gradient(top, @start-color @start-percent, @end-color @end-percent); // FF 3.6+\n    background-image: linear-gradient(to bottom, @start-color @start-percent, @end-color @end-percent); // Standard, IE10\n    background-repeat: repeat-x;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=0)\",argb(@start-color),argb(@end-color))); // IE9 and down\n  }\n\n  .directional(@start-color: #555; @end-color: #333; @deg: 45deg) {\n    background-repeat: repeat-x;\n    background-image: -webkit-linear-gradient(@deg, @start-color, @end-color); // Safari 5.1+, Chrome 10+\n    background-image: -moz-linear-gradient(@deg, @start-color, @end-color); // FF 3.6+\n    background-image: linear-gradient(@deg, @start-color, @end-color); // Standard, IE10\n  }\n  .horizontal-three-colors(@start-color: #00b3ee; @mid-color: #7a43b6; @color-stop: 50%; @end-color: #c3325f) {\n    background-image: -webkit-gradient(left, linear, 0 0, 0 100%, from(@start-color), color-stop(@color-stop, @mid-color), to(@end-color));\n    background-image: -webkit-linear-gradient(left, @start-color, @mid-color @color-stop, @end-color);\n    background-image: -moz-linear-gradient(left, @start-color, @mid-color @color-stop, @end-color);\n    background-image: linear-gradient(to right, @start-color, @mid-color @color-stop, @end-color);\n    background-repeat: no-repeat;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=1)\",argb(@start-color),argb(@end-color))); // IE9 and down, gets no color-stop at all for proper fallback\n  }\n  .vertical-three-colors(@start-color: #00b3ee; @mid-color: #7a43b6; @color-stop: 50%; @end-color: #c3325f) {\n    background-image: -webkit-gradient(linear, 0 0, 0 100%, from(@start-color), color-stop(@color-stop, @mid-color), to(@end-color));\n    background-image: -webkit-linear-gradient(@start-color, @mid-color @color-stop, @end-color);\n    background-image: -moz-linear-gradient(top, @start-color, @mid-color @color-stop, @end-color);\n    background-image: linear-gradient(@start-color, @mid-color @color-stop, @end-color);\n    background-repeat: no-repeat;\n    filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(startColorstr='%d', endColorstr='%d', GradientType=0)\",argb(@start-color),argb(@end-color))); // IE9 and down, gets no color-stop at all for proper fallback\n  }\n  .radial(@inner-color: #555; @outer-color: #333) {\n    background-image: -webkit-gradient(radial, center center, 0, center center, 460, from(@inner-color), to(@outer-color));\n    background-image: -webkit-radial-gradient(circle, @inner-color, @outer-color);\n    background-image: -moz-radial-gradient(circle, @inner-color, @outer-color);\n    background-image: radial-gradient(circle, @inner-color, @outer-color);\n    background-repeat: no-repeat;\n  }\n  .striped(@color: rgba(255,255,255,.15); @angle: 45deg) {\n    background-image: -webkit-gradient(linear, 0 100%, 100% 0, color-stop(.25, @color), color-stop(.25, transparent), color-stop(.5, transparent), color-stop(.5, @color), color-stop(.75, @color), color-stop(.75, transparent), to(transparent));\n    background-image: -webkit-linear-gradient(@angle, @color 25%, transparent 25%, transparent 50%, @color 50%, @color 75%, transparent 75%, transparent);\n    background-image: -moz-linear-gradient(@angle, @color 25%, transparent 25%, transparent 50%, @color 50%, @color 75%, transparent 75%, transparent);\n    background-image: linear-gradient(@angle, @color 25%, transparent 25%, transparent 50%, @color 50%, @color 75%, transparent 75%, transparent);\n  }\n}\n\n// Reset filters for IE\n//\n// When you need to remove a gradient background, do not forget to use this to reset\n// the IE filter for IE9 and below.\n.reset-filter() {\n  filter: e(%(\"progid:DXImageTransform.Microsoft.gradient(enabled = false)\"));\n}\n\n\n\n// Retina images\n//\n// Short retina mixin for setting background-image and -size\n\n.img-retina(@file-1x; @file-2x; @width-1x; @height-1x) {\n  background-image: url(\"@{file-1x}\");\n\n  @media\n  only screen and (-webkit-min-device-pixel-ratio: 2),\n  only screen and (   min--moz-device-pixel-ratio: 2),\n  only screen and (     -o-min-device-pixel-ratio: 2/1),\n  only screen and (        min-device-pixel-ratio: 2),\n  only screen and (                min-resolution: 192dpi),\n  only screen and (                min-resolution: 2dppx) {\n    background-image: url(\"@{file-2x}\");\n    background-size: @width-1x @height-1x;\n  }\n}\n\n\n// Responsive image\n//\n// Keep images from scaling beyond the width of their parents.\n\n.img-responsive(@display: block;) {\n  display: @display;\n  max-width: 100%; // Part 1: Set a maximum relative to the parent\n  height: auto; // Part 2: Scale the height according to the width, otherwise you get stretching\n}\n\n\n// COMPONENT MIXINS\n// --------------------------------------------------\n\n// Horizontal dividers\n// -------------------------\n// Dividers (basically an hr) within dropdowns and nav lists\n.nav-divider(@color: #e5e5e5) {\n  height: 1px;\n  margin: ((@line-height-computed / 2) - 1) 0;\n  overflow: hidden;\n  background-color: @color;\n}\n\n// Panels\n// -------------------------\n.panel-variant(@border; @heading-text-color; @heading-bg-color; @heading-border;) {\n  border-color: @border;\n\n  & > .panel-heading {\n    color: @heading-text-color;\n    background-color: @heading-bg-color;\n    border-color: @heading-border;\n\n    + .panel-collapse .panel-body {\n      border-top-color: @border;\n    }\n    & > .dropdown .caret {\n      border-color: @heading-text-color transparent;\n    }\n  }\n  & > .panel-footer {\n    + .panel-collapse .panel-body {\n      border-bottom-color: @border;\n    }\n  }\n}\n\n// Alerts\n// -------------------------\n.alert-variant(@background; @border; @text-color) {\n  background-color: @background;\n  border-color: @border;\n  color: @text-color;\n\n  hr {\n    border-top-color: darken(@border, 5%);\n  }\n  .alert-link {\n    color: darken(@text-color, 10%);\n  }\n}\n\n// Tables\n// -------------------------\n.table-row-variant(@state; @background; @border) {\n  // Exact selectors below required to override `.table-striped` and prevent\n  // inheritance to nested tables.\n  .table > thead > tr,\n  .table > tbody > tr,\n  .table > tfoot > tr {\n    > td.@{state},\n    > th.@{state},\n    &.@{state} > td,\n    &.@{state} > th {\n      background-color: @background;\n    }\n  }\n\n  // Hover states for `.table-hover`\n  // Note: this is not available for cells or rows within `thead` or `tfoot`.\n  .table-hover > tbody > tr {\n    > td.@{state}:hover,\n    > th.@{state}:hover,\n    &.@{state}:hover > td,\n    &.@{state}:hover > th {\n      background-color: darken(@background, 5%);\n    }\n  }\n}\n\n// Button variants\n// -------------------------\n// Easily pump out default styles, as well as :hover, :focus, :active,\n// and disabled options for all buttons\n.button-variant(@color; @background; @border) {\n  color: @color;\n  background-color: @background;\n  border-color: @border;\n\n  &:hover,\n  &:focus,\n  &:active,\n  &.active,\n  .open .dropdown-toggle& {\n    color: @color;\n    background-color: darken(@background, 8%);\n        border-color: darken(@border, 12%);\n  }\n  &:active,\n  &.active,\n  .open .dropdown-toggle& {\n    background-image: none;\n  }\n  &.disabled,\n  &[disabled],\n  fieldset[disabled] & {\n    &,\n    &:hover,\n    &:focus,\n    &:active,\n    &.active {\n      background-color: @background;\n          border-color: @border;\n    }\n  }\n}\n\n// Button sizes\n// -------------------------\n.button-size(@padding-vertical; @padding-horizontal; @font-size; @line-height; @border-radius) {\n  padding: @padding-vertical @padding-horizontal;\n  font-size: @font-size;\n  line-height: @line-height;\n  border-radius: @border-radius;\n}\n\n// Pagination\n// -------------------------\n.pagination-size(@padding-vertical; @padding-horizontal; @font-size; @border-radius) {\n  > li {\n    > a,\n    > span {\n      padding: @padding-vertical @padding-horizontal;\n      font-size: @font-size;\n    }\n    &:first-child {\n      > a,\n      > span {\n        .border-left-radius(@border-radius);\n      }\n    }\n    &:last-child {\n      > a,\n      > span {\n        .border-right-radius(@border-radius);\n      }\n    }\n  }\n}\n\n// Labels\n// -------------------------\n.label-variant(@color) {\n  background-color: @color;\n  &[href] {\n    &:hover,\n    &:focus {\n      background-color: darken(@color, 10%);\n    }\n  }\n}\n\n// Navbar vertical align\n// -------------------------\n// Vertically center elements in the navbar.\n// Example: an element has a height of 30px, so write out `.navbar-vertical-align(30px);` to calculate the appropriate top margin.\n.navbar-vertical-align(@element-height) {\n  margin-top: ((@navbar-height - @element-height) / 2);\n  margin-bottom: ((@navbar-height - @element-height) / 2);\n}\n\n// Progress bars\n// -------------------------\n.progress-bar-variant(@color) {\n  background-color: @color;\n  .progress-striped & {\n    #gradient > .striped();\n  }\n}\n\n// Responsive utilities\n// -------------------------\n// More easily include all the states for responsive-utilities.less.\n.responsive-visibility() {\n  display: block !important;\n  tr& { display: table-row !important; }\n  th&,\n  td& { display: table-cell !important; }\n}\n\n.responsive-invisibility() {\n    &,\n  tr&,\n  th&,\n  td& { display: none !important; }\n}\n\n\n// Grid System\n// -----------\n\n// Centered container element\n.container-fixed() {\n  margin-right: auto;\n  margin-left: auto;\n  padding-left:  (@grid-gutter-width / 2);\n  padding-right: (@grid-gutter-width / 2);\n  .clearfix();\n}\n\n// Creates a wrapper for a series of columns\n.make-row(@gutter: @grid-gutter-width) {\n  margin-left:  (@gutter / -2);\n  margin-right: (@gutter / -2);\n  .clearfix();\n}\n\n// Generate the extra small columns\n.make-xs-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  float: left;\n  width: percentage((@columns / @grid-columns));\n  // Prevent columns from collapsing when empty\n  min-height: 1px;\n  // Inner gutter via padding\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n}\n\n// Generate the small columns\n.make-sm-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  // Prevent columns from collapsing when empty\n  min-height: 1px;\n  // Inner gutter via padding\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  // Calculate width based on number of columns available\n  @media (min-width: @screen-sm-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n\n// Generate the small column offsets\n.make-sm-column-offset(@columns) {\n  @media (min-width: @screen-sm-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-sm-column-push(@columns) {\n  @media (min-width: @screen-sm-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-sm-column-pull(@columns) {\n  @media (min-width: @screen-sm-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n// Generate the medium columns\n.make-md-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  // Prevent columns from collapsing when empty\n  min-height: 1px;\n  // Inner gutter via padding\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  // Calculate width based on number of columns available\n  @media (min-width: @screen-md-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n\n// Generate the medium column offsets\n.make-md-column-offset(@columns) {\n  @media (min-width: @screen-md-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-md-column-push(@columns) {\n  @media (min-width: @screen-md) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-md-column-pull(@columns) {\n  @media (min-width: @screen-md-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n// Generate the large columns\n.make-lg-column(@columns; @gutter: @grid-gutter-width) {\n  position: relative;\n  // Prevent columns from collapsing when empty\n  min-height: 1px;\n  // Inner gutter via padding\n  padding-left:  (@gutter / 2);\n  padding-right: (@gutter / 2);\n\n  // Calculate width based on number of columns available\n  @media (min-width: @screen-lg-min) {\n    float: left;\n    width: percentage((@columns / @grid-columns));\n  }\n}\n\n// Generate the large column offsets\n.make-lg-column-offset(@columns) {\n  @media (min-width: @screen-lg-min) {\n    margin-left: percentage((@columns / @grid-columns));\n  }\n}\n.make-lg-column-push(@columns) {\n  @media (min-width: @screen-lg-min) {\n    left: percentage((@columns / @grid-columns));\n  }\n}\n.make-lg-column-pull(@columns) {\n  @media (min-width: @screen-lg-min) {\n    right: percentage((@columns / @grid-columns));\n  }\n}\n\n\n// Framework grid generation\n//\n// Used only by Bootstrap to generate the correct number of grid classes given\n// any value of `@grid-columns`.\n\n.make-grid-columns() {\n  // Common styles for all sizes of grid columns, widths 1-12\n  .col(@index) when (@index = 1) { // initial\n    @item: ~\".col-xs-@{index}, .col-sm-@{index}, .col-md-@{index}, .col-lg-@{index}\";\n    .col(@index + 1, @item);\n  }\n  .col(@index, @list) when (@index =< @grid-columns) { // general; \"=<\" isn't a typo\n    @item: ~\".col-xs-@{index}, .col-sm-@{index}, .col-md-@{index}, .col-lg-@{index}\";\n    .col(@index + 1, ~\"@{list}, @{item}\");\n  }\n  .col(@index, @list) when (@index > @grid-columns) { // terminal\n    @{list} {\n      position: relative;\n      // Prevent columns from collapsing when empty\n      min-height: 1px;\n      // Inner gutter via padding\n      padding-left:  (@grid-gutter-width / 2);\n      padding-right: (@grid-gutter-width / 2);\n    }\n  }\n  .col(1); // kickstart it\n}\n\n.make-grid-columns-float(@class) {\n  .col(@index) when (@index = 1) { // initial\n    @item: ~\".col-@{class}-@{index}\";\n    .col(@index + 1, @item);\n  }\n  .col(@index, @list) when (@index < @grid-columns) { // general\n    @item: ~\".col-@{class}-@{index}\";\n    .col(@index + 1, ~\"@{list}, @{item}\");\n  }\n  .col(@index, @list) when (@index = @grid-columns) { // terminal\n    @{list} {\n      float: left;\n    }\n  }\n  .col(1); // kickstart it\n}\n\n.calc-grid(@index, @class, @type) when (@type = width) and (@index > 0) {\n  .col-@{class}-@{index} {\n    width: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid(@index, @class, @type) when (@type = push) {\n  .col-@{class}-push-@{index} {\n    left: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid(@index, @class, @type) when (@type = pull) {\n  .col-@{class}-pull-@{index} {\n    right: percentage((@index / @grid-columns));\n  }\n}\n.calc-grid(@index, @class, @type) when (@type = offset) {\n  .col-@{class}-offset-@{index} {\n    margin-left: percentage((@index / @grid-columns));\n  }\n}\n\n// Basic looping in LESS\n.make-grid(@index, @class, @type) when (@index >= 0) {\n  .calc-grid(@index, @class, @type);\n  // next iteration\n  .make-grid(@index - 1, @class, @type);\n}\n\n\n// Form validation states\n//\n// Used in forms.less to generate the form validation CSS for warnings, errors,\n// and successes.\n\n.form-control-validation(@text-color: #555; @border-color: #ccc; @background-color: #f5f5f5) {\n  // Color the label and help text\n  .help-block,\n  .control-label,\n  .radio,\n  .checkbox,\n  .radio-inline,\n  .checkbox-inline  {\n    color: @text-color;\n  }\n  // Set the border and box shadow on specific inputs to match\n  .form-control {\n    border-color: @border-color;\n    .box-shadow(inset 0 1px 1px rgba(0,0,0,.075)); // Redeclare so transitions work\n    &:focus {\n      border-color: darken(@border-color, 10%);\n      @shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 6px lighten(@border-color, 20%);\n      .box-shadow(@shadow);\n    }\n  }\n  // Set validation states also for addons\n  .input-group-addon {\n    color: @text-color;\n    border-color: @border-color;\n    background-color: @background-color;\n  }\n}\n\n// Form control focus state\n//\n// Generate a customized focus state and for any input with the specified color,\n// which defaults to the `@input-focus-border` variable.\n//\n// We highly encourage you to not customize the default value, but instead use\n// this to tweak colors on an as-needed basis. This aesthetic change is based on\n// WebKit's default styles, but applicable to a wider range of browsers. Its\n// usability and accessibility should be taken into account with any change.\n//\n// Example usage: change the default blue border and shadow to white for better\n// contrast against a dark gray background.\n\n.form-control-focus(@color: @input-border-focus) {\n  @color-rgba: rgba(red(@color), green(@color), blue(@color), .6);\n  &:focus {\n    border-color: @color;\n    outline: 0;\n    .box-shadow(~\"inset 0 1px 1px rgba(0,0,0,.075), 0 0 8px @{color-rgba}\");\n  }\n}\n\n// Form control sizing\n//\n// Relative text size, padding, and border-radii changes for form controls. For\n// horizontal sizing, wrap controls in the predefined grid classes. `<select>`\n// element gets special love because it's special, and that's a fact!\n\n.input-size(@input-height; @padding-vertical; @padding-horizontal; @font-size; @line-height; @border-radius) {\n  height: @input-height;\n  padding: @padding-vertical @padding-horizontal;\n  font-size: @font-size;\n  line-height: @line-height;\n  border-radius: @border-radius;\n\n  select& {\n    height: @input-height;\n    line-height: @input-height;\n  }\n\n  textarea& {\n    height: auto;\n  }\n}\n","modals.less":"//\n// Modals\n// --------------------------------------------------\n\n// .modal-open      - body class for killing the scroll\n// .modal           - container to scroll within\n// .modal-dialog    - positioning shell for the actual modal\n// .modal-content   - actual modal w/ bg and corners and shit\n\n// Kill the scroll on the body\n.modal-open {\n  overflow: hidden;\n}\n\n// Container that the modal scrolls within\n.modal {\n  display: none;\n  overflow: auto;\n  overflow-y: scroll;\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: @zindex-modal-background;\n\n  // When fading in the modal, animate it to slide down\n  &.fade .modal-dialog {\n    .translate(0, -25%);\n    .transition-transform(~\"0.3s ease-out\");\n  }\n  &.in .modal-dialog { .translate(0, 0)}\n}\n\n// Shell div to position the modal with bottom padding\n.modal-dialog {\n  position: relative;\n  margin-left: auto;\n  margin-right: auto;\n  width: auto;\n  padding: 10px;\n  z-index: (@zindex-modal-background + 10);\n}\n\n// Actual modal\n.modal-content {\n  position: relative;\n  background-color: @modal-content-bg;\n  border: 1px solid @modal-content-fallback-border-color; //old browsers fallback (ie8 etc)\n  border: 1px solid @modal-content-border-color;\n  border-radius: @border-radius-large;\n  .box-shadow(0 3px 9px rgba(0,0,0,.5));\n  background-clip: padding-box;\n  // Remove focus outline from opened modal\n  outline: none;\n}\n\n// Modal background\n.modal-backdrop {\n  position: fixed;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  z-index: (@zindex-modal-background - 10);\n  background-color: @modal-backdrop-bg;\n  // Fade for backdrop\n  &.fade { .opacity(0); }\n  &.in { .opacity(.5); }\n}\n\n// Modal header\n// Top section of the modal w/ title and dismiss\n.modal-header {\n  padding: @modal-title-padding;\n  border-bottom: 1px solid @modal-header-border-color;\n  min-height: (@modal-title-padding + @modal-title-line-height);\n}\n// Close icon\n.modal-header .close {\n  margin-top: -2px;\n}\n\n// Title text within header\n.modal-title {\n  margin: 0;\n  line-height: @modal-title-line-height;\n}\n\n// Modal body\n// Where all modal content resides (sibling of .modal-header and .modal-footer)\n.modal-body {\n  position: relative;\n  padding: @modal-inner-padding;\n}\n\n// Footer (for actions)\n.modal-footer {\n  margin-top: 15px;\n  padding: (@modal-inner-padding - 1) @modal-inner-padding @modal-inner-padding;\n  text-align: right; // right align buttons\n  border-top: 1px solid @modal-footer-border-color;\n  .clearfix(); // clear it in case folks use .pull-* classes on buttons\n\n  // Properly space out buttons\n  .btn + .btn {\n    margin-left: 5px;\n    margin-bottom: 0; // account for input[type=\"submit\"] which gets the bottom margin like all other inputs\n  }\n  // but override that for button groups\n  .btn-group .btn + .btn {\n    margin-left: -1px;\n  }\n  // and override it for block buttons as well\n  .btn-block + .btn-block {\n    margin-left: 0;\n  }\n}\n\n// Scale up the modal\n@media screen and (min-width: @screen-sm-min) {\n\n  .modal-dialog {\n    width: 600px;\n    padding-top: 30px;\n    padding-bottom: 30px;\n  }\n  .modal-content {\n    .box-shadow(0 5px 15px rgba(0,0,0,.5));\n  }\n\n}\n","navbar.less":"//\n// Navbars\n// --------------------------------------------------\n\n\n// Wrapper and base class\n//\n// Provide a static navbar from which we expand to create full-width, fixed, and\n// other navbar variations.\n\n.navbar {\n  position: relative;\n  min-height: @navbar-height; // Ensure a navbar always shows (e.g., without a .navbar-brand in collapsed mode)\n  margin-bottom: @navbar-margin-bottom;\n  border: 1px solid transparent;\n\n  // Prevent floats from breaking the navbar\n  .clearfix();\n\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: @navbar-border-radius;\n  }\n}\n\n\n// Navbar heading\n//\n// Groups `.navbar-brand` and `.navbar-toggle` into a single component for easy\n// styling of responsive aspects.\n\n.navbar-header {\n  .clearfix();\n\n  @media (min-width: @grid-float-breakpoint) {\n    float: left;\n  }\n}\n\n\n// Navbar collapse (body)\n//\n// Group your navbar content into this for easy collapsing and expanding across\n// various device sizes. By default, this content is collapsed when <768px, but\n// will expand past that for a horizontal display.\n//\n// To start (on mobile devices) the navbar links, forms, and buttons are stacked\n// vertically and include a `max-height` to overflow in case you have too much\n// content for the user's viewport.\n\n.navbar-collapse {\n  max-height: 340px;\n  overflow-x: visible;\n  padding-right: @navbar-padding-horizontal;\n  padding-left:  @navbar-padding-horizontal;\n  border-top: 1px solid transparent;\n  box-shadow: inset 0 1px 0 rgba(255,255,255,.1);\n  .clearfix();\n  -webkit-overflow-scrolling: touch;\n\n  &.in {\n    overflow-y: auto;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    width: auto;\n    border-top: 0;\n    box-shadow: none;\n\n    &.collapse {\n      display: block !important;\n      height: auto !important;\n      padding-bottom: 0; // Override default setting\n      overflow: visible !important;\n    }\n\n    &.in {\n      overflow-y: auto;\n    }\n\n    // Account for first and last children spacing\n    .navbar-nav.navbar-left:first-child {\n      margin-left: -@navbar-padding-horizontal;\n    }\n    .navbar-nav.navbar-right:last-child {\n      margin-right: -@navbar-padding-horizontal;\n    }\n    .navbar-text:last-child {\n      margin-right: 0;\n    }\n  }\n}\n\n\n// Both navbar header and collapse\n//\n// When a container is present, change the behavior of the header and collapse.\n\n.container > .navbar-header,\n.container > .navbar-collapse {\n  margin-right: -@navbar-padding-horizontal;\n  margin-left:  -@navbar-padding-horizontal;\n\n  @media (min-width: @grid-float-breakpoint) {\n    margin-right: 0;\n    margin-left:  0;\n  }\n}\n\n\n//\n// Navbar alignment options\n//\n// Display the navbar across the entirety of the page or fixed it to the top or\n// bottom of the page.\n\n// Static top (unfixed, but 100% wide) navbar\n.navbar-static-top {\n  z-index: @zindex-navbar;\n  border-width: 0 0 1px;\n\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: 0;\n  }\n}\n\n// Fix the top/bottom navbars when screen real estate supports it\n.navbar-fixed-top,\n.navbar-fixed-bottom {\n  position: fixed;\n  right: 0;\n  left: 0;\n  z-index: @zindex-navbar-fixed;\n\n  // Undo the rounded corners\n  @media (min-width: @grid-float-breakpoint) {\n    border-radius: 0;\n  }\n}\n.navbar-fixed-top {\n  top: 0;\n  border-width: 0 0 1px;\n}\n.navbar-fixed-bottom {\n  bottom: 0;\n  margin-bottom: 0; // override .navbar defaults\n  border-width: 1px 0 0;\n}\n\n\n// Brand/project name\n\n.navbar-brand {\n  float: left;\n  padding: @navbar-padding-vertical @navbar-padding-horizontal;\n  font-size: @font-size-large;\n  line-height: @line-height-computed;\n\n  &:hover,\n  &:focus {\n    text-decoration: none;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    .navbar > .container & {\n      margin-left: -@navbar-padding-horizontal;\n    }\n  }\n}\n\n\n// Navbar toggle\n//\n// Custom button for toggling the `.navbar-collapse`, powered by the collapse\n// JavaScript plugin.\n\n.navbar-toggle {\n  position: relative;\n  float: right;\n  margin-right: @navbar-padding-horizontal;\n  padding: 9px 10px;\n  .navbar-vertical-align(34px);\n  background-color: transparent;\n  border: 1px solid transparent;\n  border-radius: @border-radius-base;\n\n  // Bars\n  .icon-bar {\n    display: block;\n    width: 22px;\n    height: 2px;\n    border-radius: 1px;\n  }\n  .icon-bar + .icon-bar {\n    margin-top: 4px;\n  }\n\n  @media (min-width: @grid-float-breakpoint) {\n    display: none;\n  }\n}\n\n\n// Navbar nav links\n//\n// Builds on top of the `.nav` components with it's own modifier class to make\n// the nav the full height of the horizontal nav (above 768px).\n\n.navbar-nav {\n  margin: (@navbar-padding-vertical / 2) -@navbar-padding-horizontal;\n\n  > li > a {\n    padding-top:    10px;\n    padding-bottom: 10px;\n    line-height: @line-height-computed;\n  }\n\n  @media (max-width: @screen-xs-max) {\n    // Dropdowns get custom display when collapsed\n    .open .dropdown-menu {\n      position: static;\n      float: none;\n      width: auto;\n      margin-top: 0;\n      background-color: transparent;\n      border: 0;\n      box-shadow: none;\n      > li > a,\n      .dropdown-header {\n        padding: 5px 15px 5px 25px;\n      }\n      > li > a {\n        line-height: @line-height-computed;\n        &:hover,\n        &:focus {\n          background-image: none;\n        }\n      }\n    }\n  }\n\n  // Uncollapse the nav\n  @media (min-width: @grid-float-breakpoint) {\n    float: left;\n    margin: 0;\n\n    > li {\n      float: left;\n      > a {\n        padding-top: ((@navbar-height - @line-height-computed) / 2);\n        padding-bottom: ((@navbar-height - @line-height-computed) / 2);\n      }\n    }\n  }\n\n}\n\n\n// Component alignment\n//\n// Repurpose the pull utilities as their own navbar utilities to avoid specificity\n// issues with parents and chaining. Only do this when the navbar is uncollapsed\n// though so that navbar contents properly stack and align in mobile.\n\n@media (min-width: @grid-float-breakpoint) {\n  .navbar-left  { .pull-left(); }\n  .navbar-right { .pull-right(); }\n}\n\n\n// Navbar form\n//\n// Extension of the `.form-inline` with some extra flavor for optimum display in\n// our navbars.\n\n.navbar-form {\n  margin-left: -@navbar-padding-horizontal;\n  margin-right: -@navbar-padding-horizontal;\n  padding: 10px @navbar-padding-horizontal;\n  border-top: 1px solid transparent;\n  border-bottom: 1px solid transparent;\n  @shadow: inset 0 1px 0 rgba(255,255,255,.1), 0 1px 0 rgba(255,255,255,.1);\n  .box-shadow(@shadow);\n\n  // Mixin behavior for optimum display\n  .form-inline();\n\n  .form-group {\n    @media (max-width: @screen-xs-max) {\n      margin-bottom: 5px;\n    }\n  }\n\n  // Vertically center in expanded, horizontal navbar\n  .navbar-vertical-align(@input-height-base);\n\n  // Undo 100% width for pull classes\n  @media (min-width: @grid-float-breakpoint) {\n    width: auto;\n    border: 0;\n    margin-left: 0;\n    margin-right: 0;\n    padding-top: 0;\n    padding-bottom: 0;\n    .box-shadow(none);\n  }\n}\n\n\n// Dropdown menus\n\n// Menu position and menu carets\n.navbar-nav > li > .dropdown-menu {\n  margin-top: 0;\n  .border-top-radius(0);\n}\n// Menu position and menu caret support for dropups via extra dropup class\n.navbar-fixed-bottom .navbar-nav > li > .dropdown-menu {\n  .border-bottom-radius(0);\n}\n\n// Right aligned menus need alt position\n.navbar-nav.pull-right > li > .dropdown-menu,\n.navbar-nav > li > .dropdown-menu.pull-right {\n  left: auto;\n  right: 0;\n}\n\n\n// Buttons in navbars\n//\n// Vertically center a button within a navbar (when *not* in a form).\n\n.navbar-btn {\n  .navbar-vertical-align(@input-height-base);\n}\n\n\n// Text in navbars\n//\n// Add a class to make any element properly align itself vertically within the navbars.\n\n.navbar-text {\n  float: left;\n  .navbar-vertical-align(@line-height-computed);\n\n  @media (min-width: @grid-float-breakpoint) {\n    margin-left: @navbar-padding-horizontal;\n    margin-right: @navbar-padding-horizontal;\n  }\n}\n\n// Alternate navbars\n// --------------------------------------------------\n\n// Default navbar\n.navbar-default {\n  background-color: @navbar-default-bg;\n  border-color: @navbar-default-border;\n\n  .navbar-brand {\n    color: @navbar-default-brand-color;\n    &:hover,\n    &:focus {\n      color: @navbar-default-brand-hover-color;\n      background-color: @navbar-default-brand-hover-bg;\n    }\n  }\n\n  .navbar-text {\n    color: @navbar-default-color;\n  }\n\n  .navbar-nav {\n    > li > a {\n      color: @navbar-default-link-color;\n\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-hover-color;\n        background-color: @navbar-default-link-hover-bg;\n      }\n    }\n    > .active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-active-color;\n        background-color: @navbar-default-link-active-bg;\n      }\n    }\n    > .disabled > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-default-link-disabled-color;\n        background-color: @navbar-default-link-disabled-bg;\n      }\n    }\n  }\n\n  .navbar-toggle {\n    border-color: @navbar-default-toggle-border-color;\n    &:hover,\n    &:focus {\n      background-color: @navbar-default-toggle-hover-bg;\n    }\n    .icon-bar {\n      background-color: @navbar-default-toggle-icon-bar-bg;\n    }\n  }\n\n  .navbar-collapse,\n  .navbar-form {\n    border-color: @navbar-default-border;\n  }\n\n  // Dropdown menu items and carets\n  .navbar-nav {\n    // Caret should match text color on hover\n    > .dropdown > a:hover .caret,\n    > .dropdown > a:focus .caret {\n      border-top-color: @navbar-default-link-hover-color;\n      border-bottom-color: @navbar-default-link-hover-color;\n    }\n\n    // Remove background color from open dropdown\n    > .open > a {\n      &,\n      &:hover,\n      &:focus {\n        background-color: @navbar-default-link-active-bg;\n        color: @navbar-default-link-active-color;\n        .caret {\n          border-top-color: @navbar-default-link-active-color;\n          border-bottom-color: @navbar-default-link-active-color;\n        }\n      }\n    }\n    > .dropdown > a .caret {\n      border-top-color: @navbar-default-link-color;\n      border-bottom-color: @navbar-default-link-color;\n    }\n\n\n    @media (max-width: @screen-xs-max) {\n      // Dropdowns get custom display when collapsed\n      .open .dropdown-menu {\n        > li > a {\n          color: @navbar-default-link-color;\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-hover-color;\n            background-color: @navbar-default-link-hover-bg;\n          }\n        }\n        > .active > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-active-color;\n            background-color: @navbar-default-link-active-bg;\n          }\n        }\n        > .disabled > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-default-link-disabled-color;\n            background-color: @navbar-default-link-disabled-bg;\n          }\n        }\n      }\n    }\n  }\n\n\n  // Links in navbars\n  //\n  // Add a class to ensure links outside the navbar nav are colored correctly.\n\n  .navbar-link {\n    color: @navbar-default-link-color;\n    &:hover {\n      color: @navbar-default-link-hover-color;\n    }\n  }\n\n}\n\n// Inverse navbar\n\n.navbar-inverse {\n  background-color: @navbar-inverse-bg;\n  border-color: @navbar-inverse-border;\n\n  .navbar-brand {\n    color: @navbar-inverse-brand-color;\n    &:hover,\n    &:focus {\n      color: @navbar-inverse-brand-hover-color;\n      background-color: @navbar-inverse-brand-hover-bg;\n    }\n  }\n\n  .navbar-text {\n    color: @navbar-inverse-color;\n  }\n\n  .navbar-nav {\n    > li > a {\n      color: @navbar-inverse-link-color;\n\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-hover-color;\n        background-color: @navbar-inverse-link-hover-bg;\n      }\n    }\n    > .active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-active-color;\n        background-color: @navbar-inverse-link-active-bg;\n      }\n    }\n    > .disabled > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @navbar-inverse-link-disabled-color;\n        background-color: @navbar-inverse-link-disabled-bg;\n      }\n    }\n  }\n\n  // Darken the responsive nav toggle\n  .navbar-toggle {\n    border-color: @navbar-inverse-toggle-border-color;\n    &:hover,\n    &:focus {\n      background-color: @navbar-inverse-toggle-hover-bg;\n    }\n    .icon-bar {\n      background-color: @navbar-inverse-toggle-icon-bar-bg;\n    }\n  }\n\n  .navbar-collapse,\n  .navbar-form {\n    border-color: darken(@navbar-inverse-bg, 7%);\n  }\n\n  // Dropdowns\n  .navbar-nav {\n    > .open > a {\n      &,\n      &:hover,\n      &:focus {\n        background-color: @navbar-inverse-link-active-bg;\n        color: @navbar-inverse-link-active-color;\n      }\n    }\n    > .dropdown > a:hover .caret {\n      border-top-color: @navbar-inverse-link-hover-color;\n      border-bottom-color: @navbar-inverse-link-hover-color;\n    }\n    > .dropdown > a .caret {\n      border-top-color: @navbar-inverse-link-color;\n      border-bottom-color: @navbar-inverse-link-color;\n    }\n    > .open > a {\n      &,\n      &:hover,\n      &:focus {\n        .caret {\n          border-top-color: @navbar-inverse-link-active-color;\n          border-bottom-color: @navbar-inverse-link-active-color;\n        }\n      }\n    }\n\n    @media (max-width: @screen-xs-max) {\n      // Dropdowns get custom display\n      .open .dropdown-menu {\n        > .dropdown-header {\n          border-color: @navbar-inverse-border;\n        }\n        > li > a {\n          color: @navbar-inverse-link-color;\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-hover-color;\n            background-color: @navbar-inverse-link-hover-bg;\n          }\n        }\n        > .active > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-active-color;\n            background-color: @navbar-inverse-link-active-bg;\n          }\n        }\n        > .disabled > a {\n          &,\n          &:hover,\n          &:focus {\n            color: @navbar-inverse-link-disabled-color;\n            background-color: @navbar-inverse-link-disabled-bg;\n          }\n        }\n      }\n    }\n  }\n\n  .navbar-link {\n    color: @navbar-inverse-link-color;\n    &:hover {\n      color: @navbar-inverse-link-hover-color;\n    }\n  }\n\n}\n","navs.less":"//\n// Navs\n// --------------------------------------------------\n\n\n// Base class\n// --------------------------------------------------\n\n.nav {\n  margin-bottom: 0;\n  padding-left: 0; // Override default ul/ol\n  list-style: none;\n  .clearfix();\n\n  > li {\n    position: relative;\n    display: block;\n\n    > a {\n      position: relative;\n      display: block;\n      padding: @nav-link-padding;\n      &:hover,\n      &:focus {\n        text-decoration: none;\n        background-color: @nav-link-hover-bg;\n      }\n    }\n\n    // Disabled state sets text to gray and nukes hover/tab effects\n    &.disabled > a {\n      color: @nav-disabled-link-color;\n\n      &:hover,\n      &:focus {\n        color: @nav-disabled-link-hover-color;\n        text-decoration: none;\n        background-color: transparent;\n        cursor: not-allowed;\n      }\n    }\n  }\n\n  // Open dropdowns\n  .open > a {\n    &,\n    &:hover,\n    &:focus {\n      background-color: @nav-link-hover-bg;\n      border-color: @link-color;\n\n      .caret {\n        border-top-color: @link-hover-color;\n        border-bottom-color: @link-hover-color;\n      }\n    }\n  }\n\n  // Nav dividers (deprecated with v3.0.1)\n  //\n  // This should have been removed in v3 with the dropping of `.nav-list`, but\n  // we missed it. We don't currently support this anywhere, but in the interest\n  // of maintaining backward compatibility in case you use it, it's deprecated.\n  .nav-divider {\n    .nav-divider();\n  }\n\n  // Prevent IE8 from misplacing imgs\n  //\n  // See https://github.com/h5bp/html5-boilerplate/issues/984#issuecomment-3985989\n  > li > a > img {\n    max-width: none;\n  }\n}\n\n\n// Tabs\n// -------------------------\n\n// Give the tabs something to sit on\n.nav-tabs {\n  border-bottom: 1px solid @nav-tabs-border-color;\n  > li {\n    float: left;\n    // Make the list-items overlay the bottom border\n    margin-bottom: -1px;\n\n    // Actual tabs (as links)\n    > a {\n      margin-right: 2px;\n      line-height: @line-height-base;\n      border: 1px solid transparent;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n      &:hover {\n        border-color: @nav-tabs-link-hover-border-color @nav-tabs-link-hover-border-color @nav-tabs-border-color;\n      }\n    }\n\n    // Active state, and it's :hover to override normal :hover\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-tabs-active-link-hover-color;\n        background-color: @nav-tabs-active-link-hover-bg;\n        border: 1px solid @nav-tabs-active-link-hover-border-color;\n        border-bottom-color: transparent;\n        cursor: default;\n      }\n    }\n  }\n  // pulling this in mainly for less shorthand\n  &.nav-justified {\n    .nav-justified();\n    .nav-tabs-justified();\n  }\n}\n\n\n// Pills\n// -------------------------\n.nav-pills {\n  > li {\n    float: left;\n\n    // Links rendered as pills\n    > a {\n      border-radius: @nav-pills-border-radius;\n    }\n    + li {\n      margin-left: 2px;\n    }\n\n    // Active state\n    &.active > a {\n      &,\n      &:hover,\n      &:focus {\n        color: @nav-pills-active-link-hover-color;\n        background-color: @nav-pills-active-link-hover-bg;\n\n        .caret {\n          border-top-color: @nav-pills-active-link-hover-color;\n          border-bottom-color: @nav-pills-active-link-hover-color;\n        }\n      }\n    }\n  }\n}\n\n\n// Stacked pills\n.nav-stacked {\n  > li {\n    float: none;\n    + li {\n      margin-top: 2px;\n      margin-left: 0; // no need for this gap between nav items\n    }\n  }\n}\n\n\n// Nav variations\n// --------------------------------------------------\n\n// Justified nav links\n// -------------------------\n\n.nav-justified {\n  width: 100%;\n\n  > li {\n    float: none;\n     > a {\n      text-align: center;\n      margin-bottom: 5px;\n    }\n  }\n\n  > .dropdown .dropdown-menu {\n    top: auto;\n    left: auto;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li {\n      display: table-cell;\n      width: 1%;\n      > a {\n        margin-bottom: 0;\n      }\n    }\n  }\n}\n\n// Move borders to anchors instead of bottom of list\n//\n// Mixin for adding on top the shared `.nav-justified` styles for our tabs\n.nav-tabs-justified {\n  border-bottom: 0;\n\n  > li > a {\n    // Override margin from .nav-tabs\n    margin-right: 0;\n    border-radius: @border-radius-base;\n  }\n\n  > .active > a,\n  > .active > a:hover,\n  > .active > a:focus {\n    border: 1px solid @nav-tabs-justified-link-border-color;\n  }\n\n  @media (min-width: @screen-sm-min) {\n    > li > a {\n      border-bottom: 1px solid @nav-tabs-justified-link-border-color;\n      border-radius: @border-radius-base @border-radius-base 0 0;\n    }\n    > .active > a,\n    > .active > a:hover,\n    > .active > a:focus {\n      border-bottom-color: @nav-tabs-justified-active-link-border-color;\n    }\n  }\n}\n\n\n// Tabbable tabs\n// -------------------------\n\n// Hide tabbable panes to start, show them when `.active`\n.tab-content {\n  > .tab-pane {\n    display: none;\n  }\n  > .active {\n    display: block;\n  }\n}\n\n\n// Dropdowns\n// -------------------------\n\n// Make dropdown carets use link color in navs\n.nav .caret {\n  border-top-color: @link-color;\n  border-bottom-color: @link-color;\n}\n.nav a:hover .caret {\n  border-top-color: @link-hover-color;\n  border-bottom-color: @link-hover-color;\n}\n\n// Specific dropdowns\n.nav-tabs .dropdown-menu {\n  // make dropdown border overlap tab border\n  margin-top: -1px;\n  // Remove the top rounded corners here since there is a hard edge above the menu\n  .border-top-radius(0);\n}\n","normalize.less":"/*! normalize.css v2.1.3 | MIT License | git.io/normalize */\n\n// ==========================================================================\n// HTML5 display definitions\n// ==========================================================================\n\n//\n// Correct `block` display not defined in IE 8/9.\n//\n\narticle,\naside,\ndetails,\nfigcaption,\nfigure,\nfooter,\nheader,\nhgroup,\nmain,\nnav,\nsection,\nsummary {\n  display: block;\n}\n\n//\n// Correct `inline-block` display not defined in IE 8/9.\n//\n\naudio,\ncanvas,\nvideo {\n  display: inline-block;\n}\n\n//\n// Prevent modern browsers from displaying `audio` without controls.\n// Remove excess height in iOS 5 devices.\n//\n\naudio:not([controls]) {\n  display: none;\n  height: 0;\n}\n\n//\n// Address `[hidden]` styling not present in IE 8/9.\n// Hide the `template` element in IE, Safari, and Firefox < 22.\n//\n\n[hidden],\ntemplate {\n  display: none;\n}\n\n// ==========================================================================\n// Base\n// ==========================================================================\n\n//\n// 1. Set default font family to sans-serif.\n// 2. Prevent iOS text size adjust after orientation change, without disabling\n//    user zoom.\n//\n\nhtml {\n  font-family: sans-serif; // 1\n  -ms-text-size-adjust: 100%; // 2\n  -webkit-text-size-adjust: 100%; // 2\n}\n\n//\n// Remove default margin.\n//\n\nbody {\n  margin: 0;\n}\n\n// ==========================================================================\n// Links\n// ==========================================================================\n\n//\n// Remove the gray background color from active links in IE 10.\n//\n\na {\n  background: transparent;\n}\n\n//\n// Address `outline` inconsistency between Chrome and other browsers.\n//\n\na:focus {\n  outline: thin dotted;\n}\n\n//\n// Improve readability when focused and also mouse hovered in all browsers.\n//\n\na:active,\na:hover {\n  outline: 0;\n}\n\n// ==========================================================================\n// Typography\n// ==========================================================================\n\n//\n// Address variable `h1` font-size and margin within `section` and `article`\n// contexts in Firefox 4+, Safari 5, and Chrome.\n//\n\nh1 {\n  font-size: 2em;\n  margin: 0.67em 0;\n}\n\n//\n// Address styling not present in IE 8/9, Safari 5, and Chrome.\n//\n\nabbr[title] {\n  border-bottom: 1px dotted;\n}\n\n//\n// Address style set to `bolder` in Firefox 4+, Safari 5, and Chrome.\n//\n\nb,\nstrong {\n  font-weight: bold;\n}\n\n//\n// Address styling not present in Safari 5 and Chrome.\n//\n\ndfn {\n  font-style: italic;\n}\n\n//\n// Address differences between Firefox and other browsers.\n//\n\nhr {\n  -moz-box-sizing: content-box;\n  box-sizing: content-box;\n  height: 0;\n}\n\n//\n// Address styling not present in IE 8/9.\n//\n\nmark {\n  background: #ff0;\n  color: #000;\n}\n\n//\n// Correct font family set oddly in Safari 5 and Chrome.\n//\n\ncode,\nkbd,\npre,\nsamp {\n  font-family: monospace, serif;\n  font-size: 1em;\n}\n\n//\n// Improve readability of pre-formatted text in all browsers.\n//\n\npre {\n  white-space: pre-wrap;\n}\n\n//\n// Set consistent quote types.\n//\n\nq {\n  quotes: \"\\201C\" \"\\201D\" \"\\2018\" \"\\2019\";\n}\n\n//\n// Address inconsistent and variable font size in all browsers.\n//\n\nsmall {\n  font-size: 80%;\n}\n\n//\n// Prevent `sub` and `sup` affecting `line-height` in all browsers.\n//\n\nsub,\nsup {\n  font-size: 75%;\n  line-height: 0;\n  position: relative;\n  vertical-align: baseline;\n}\n\nsup {\n  top: -0.5em;\n}\n\nsub {\n  bottom: -0.25em;\n}\n\n// ==========================================================================\n// Embedded content\n// ==========================================================================\n\n//\n// Remove border when inside `a` element in IE 8/9.\n//\n\nimg {\n  border: 0;\n}\n\n//\n// Correct overflow displayed oddly in IE 9.\n//\n\nsvg:not(:root) {\n  overflow: hidden;\n}\n\n// ==========================================================================\n// Figures\n// ==========================================================================\n\n//\n// Address margin not present in IE 8/9 and Safari 5.\n//\n\nfigure {\n  margin: 0;\n}\n\n// ==========================================================================\n// Forms\n// ==========================================================================\n\n//\n// Define consistent border, margin, and padding.\n//\n\nfieldset {\n  border: 1px solid #c0c0c0;\n  margin: 0 2px;\n  padding: 0.35em 0.625em 0.75em;\n}\n\n//\n// 1. Correct `color` not being inherited in IE 8/9.\n// 2. Remove padding so people aren't caught out if they zero out fieldsets.\n//\n\nlegend {\n  border: 0; // 1\n  padding: 0; // 2\n}\n\n//\n// 1. Correct font family not being inherited in all browsers.\n// 2. Correct font size not being inherited in all browsers.\n// 3. Address margins set differently in Firefox 4+, Safari 5, and Chrome.\n//\n\nbutton,\ninput,\nselect,\ntextarea {\n  font-family: inherit; // 1\n  font-size: 100%; // 2\n  margin: 0; // 3\n}\n\n//\n// Address Firefox 4+ setting `line-height` on `input` using `!important` in\n// the UA stylesheet.\n//\n\nbutton,\ninput {\n  line-height: normal;\n}\n\n//\n// Address inconsistent `text-transform` inheritance for `button` and `select`.\n// All other form control elements do not inherit `text-transform` values.\n// Correct `button` style inheritance in Chrome, Safari 5+, and IE 8+.\n// Correct `select` style inheritance in Firefox 4+ and Opera.\n//\n\nbutton,\nselect {\n  text-transform: none;\n}\n\n//\n// 1. Avoid the WebKit bug in Android 4.0.* where (2) destroys native `audio`\n//    and `video` controls.\n// 2. Correct inability to style clickable `input` types in iOS.\n// 3. Improve usability and consistency of cursor style between image-type\n//    `input` and others.\n//\n\nbutton,\nhtml input[type=\"button\"], // 1\ninput[type=\"reset\"],\ninput[type=\"submit\"] {\n  -webkit-appearance: button; // 2\n  cursor: pointer; // 3\n}\n\n//\n// Re-set default cursor for disabled elements.\n//\n\nbutton[disabled],\nhtml input[disabled] {\n  cursor: default;\n}\n\n//\n// 1. Address box sizing set to `content-box` in IE 8/9/10.\n// 2. Remove excess padding in IE 8/9/10.\n//\n\ninput[type=\"checkbox\"],\ninput[type=\"radio\"] {\n  box-sizing: border-box; // 1\n  padding: 0; // 2\n}\n\n//\n// 1. Address `appearance` set to `searchfield` in Safari 5 and Chrome.\n// 2. Address `box-sizing` set to `border-box` in Safari 5 and Chrome\n//    (include `-moz` to future-proof).\n//\n\ninput[type=\"search\"] {\n  -webkit-appearance: textfield; // 1\n  -moz-box-sizing: content-box;\n  -webkit-box-sizing: content-box; // 2\n  box-sizing: content-box;\n}\n\n//\n// Remove inner padding and search cancel button in Safari 5 and Chrome\n// on OS X.\n//\n\ninput[type=\"search\"]::-webkit-search-cancel-button,\ninput[type=\"search\"]::-webkit-search-decoration {\n  -webkit-appearance: none;\n}\n\n//\n// Remove inner padding and border in Firefox 4+.\n//\n\nbutton::-moz-focus-inner,\ninput::-moz-focus-inner {\n  border: 0;\n  padding: 0;\n}\n\n//\n// 1. Remove default vertical scrollbar in IE 8/9.\n// 2. Improve readability and alignment in all browsers.\n//\n\ntextarea {\n  overflow: auto; // 1\n  vertical-align: top; // 2\n}\n\n// ==========================================================================\n// Tables\n// ==========================================================================\n\n//\n// Remove most spacing between table cells.\n//\n\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n}\n","pager.less":"//\n// Pager pagination\n// --------------------------------------------------\n\n\n.pager {\n  padding-left: 0;\n  margin: @line-height-computed 0;\n  list-style: none;\n  text-align: center;\n  .clearfix();\n  li {\n    display: inline;\n    > a,\n    > span {\n      display: inline-block;\n      padding: 5px 14px;\n      background-color: @pagination-bg;\n      border: 1px solid @pagination-border;\n      border-radius: @pager-border-radius;\n    }\n\n    > a:hover,\n    > a:focus {\n      text-decoration: none;\n      background-color: @pagination-hover-bg;\n    }\n  }\n\n  .next {\n    > a,\n    > span {\n      float: right;\n    }\n  }\n\n  .previous {\n    > a,\n    > span {\n      float: left;\n    }\n  }\n\n  .disabled {\n    > a,\n    > a:hover,\n    > a:focus,\n    > span {\n      color: @pager-disabled-color;\n      background-color: @pagination-bg;\n      cursor: not-allowed;\n    }\n  }\n\n}\n","pagination.less":"//\n// Pagination (multiple pages)\n// --------------------------------------------------\n.pagination {\n  display: inline-block;\n  padding-left: 0;\n  margin: @line-height-computed 0;\n  border-radius: @border-radius-base;\n\n  > li {\n    display: inline; // Remove list-style and block-level defaults\n    > a,\n    > span {\n      position: relative;\n      float: left; // Collapse white-space\n      padding: @padding-base-vertical @padding-base-horizontal;\n      line-height: @line-height-base;\n      text-decoration: none;\n      background-color: @pagination-bg;\n      border: 1px solid @pagination-border;\n      margin-left: -1px;\n    }\n    &:first-child {\n      > a,\n      > span {\n        margin-left: 0;\n        .border-left-radius(@border-radius-base);\n      }\n    }\n    &:last-child {\n      > a,\n      > span {\n        .border-right-radius(@border-radius-base);\n      }\n    }\n  }\n\n  > li > a,\n  > li > span {\n    &:hover,\n    &:focus {\n      background-color: @pagination-hover-bg;\n    }\n  }\n\n  > .active > a,\n  > .active > span {\n    &,\n    &:hover,\n    &:focus {\n      z-index: 2;\n      color: @pagination-active-color;\n      background-color: @pagination-active-bg;\n      border-color: @pagination-active-bg;\n      cursor: default;\n    }\n  }\n\n  > .disabled {\n    > span,\n    > span:hover,\n    > span:focus,\n    > a,\n    > a:hover,\n    > a:focus {\n      color: @pagination-disabled-color;\n      background-color: @pagination-bg;\n      border-color: @pagination-border;\n      cursor: not-allowed;\n    }\n  }\n}\n\n// Sizing\n// --------------------------------------------------\n\n// Large\n.pagination-lg {\n  .pagination-size(@padding-large-vertical; @padding-large-horizontal; @font-size-large; @border-radius-large);\n}\n\n// Small\n.pagination-sm {\n  .pagination-size(@padding-small-vertical; @padding-small-horizontal; @font-size-small; @border-radius-small);\n}\n","panels.less":"//\n// Panels\n// --------------------------------------------------\n\n\n// Base class\n.panel {\n  margin-bottom: @line-height-computed;\n  background-color: @panel-bg;\n  border: 1px solid transparent;\n  border-radius: @panel-border-radius;\n  .box-shadow(0 1px 1px rgba(0,0,0,.05));\n}\n\n// Panel contents\n.panel-body {\n  padding: 15px;\n  .clearfix();\n}\n\n\n// List groups in panels\n//\n// By default, space out list group content from panel headings to account for\n// any kind of custom content between the two.\n\n.panel {\n  > .list-group {\n    margin-bottom: 0;\n\n    .list-group-item {\n      border-width: 1px 0;\n\n      // Remove border radius for top one\n      &:first-child {\n        .border-top-radius(0);\n      }\n      // But keep it for the last one\n      &:last-child {\n        border-bottom: 0;\n      }\n    }\n  }\n}\n// Collapse space between when there's no additional content.\n.panel-heading + .list-group {\n  .list-group-item:first-child {\n    border-top-width: 0;\n  }\n}\n\n\n// Tables in panels\n//\n// Place a non-bordered `.table` within a panel (not within a `.panel-body`) and\n// watch it go full width.\n\n.panel {\n  > .table,\n  > .table-responsive {\n    margin-bottom: 0;\n  }\n  > .panel-body + .table,\n  > .panel-body + .table-responsive {\n    border-top: 1px solid @table-border-color;\n  }\n  > .table-bordered,\n  > .table-responsive > .table-bordered {\n    border: 0;\n    > thead,\n    > tbody,\n    > tfoot {\n      > tr {\n        > th:first-child,\n        > td:first-child {\n          border-left: 0;\n        }\n        > th:last-child,\n        > td:last-child {\n          border-right: 0;\n        }\n\n        &:last-child > th,\n        &:last-child > td {\n          border-bottom: 0;\n        }\n      }\n    }\n  }\n}\n\n\n// Optional heading\n.panel-heading {\n  padding: 10px 15px;\n  border-bottom: 1px solid transparent;\n  .border-top-radius(@panel-border-radius - 1);\n\n  > .dropdown .dropdown-toggle {\n    color: inherit;\n  }\n}\n\n// Within heading, strip any `h*` tag of it's default margins for spacing.\n.panel-title {\n  margin-top: 0;\n  margin-bottom: 0;\n  font-size: ceil((@font-size-base * 1.125));\n  > a {\n    color: inherit;\n  }\n}\n\n// Optional footer (stays gray in every modifier class)\n.panel-footer {\n  padding: 10px 15px;\n  background-color: @panel-footer-bg;\n  border-top: 1px solid @panel-inner-border;\n  .border-bottom-radius(@panel-border-radius - 1);\n}\n\n\n// Collapsable panels (aka, accordion)\n//\n// Wrap a series of panels in `.panel-group` to turn them into an accordion with\n// the help of our collapse JavaScript plugin.\n\n.panel-group {\n  // Tighten up margin so it's only between panels\n  .panel {\n    margin-bottom: 0;\n    border-radius: @panel-border-radius;\n    overflow: hidden; // crop contents when collapsed\n    + .panel {\n      margin-top: 5px;\n    }\n  }\n\n  .panel-heading {\n    border-bottom: 0;\n    + .panel-collapse .panel-body {\n      border-top: 1px solid @panel-inner-border;\n    }\n  }\n  .panel-footer {\n    border-top: 0;\n    + .panel-collapse .panel-body {\n      border-bottom: 1px solid @panel-inner-border;\n    }\n  }\n}\n\n\n// Contextual variations\n.panel-default {\n  .panel-variant(@panel-default-border; @panel-default-text; @panel-default-heading-bg; @panel-default-border);\n}\n.panel-primary {\n  .panel-variant(@panel-primary-border; @panel-primary-text; @panel-primary-heading-bg; @panel-primary-border);\n}\n.panel-success {\n  .panel-variant(@panel-success-border; @panel-success-text; @panel-success-heading-bg; @panel-success-border);\n}\n.panel-warning {\n  .panel-variant(@panel-warning-border; @panel-warning-text; @panel-warning-heading-bg; @panel-warning-border);\n}\n.panel-danger {\n  .panel-variant(@panel-danger-border; @panel-danger-text; @panel-danger-heading-bg; @panel-danger-border);\n}\n.panel-info {\n  .panel-variant(@panel-info-border; @panel-info-text; @panel-info-heading-bg; @panel-info-border);\n}\n","popovers.less":"//\n// Popovers\n// --------------------------------------------------\n\n\n.popover {\n  position: absolute;\n  top: 0;\n  left: 0;\n  z-index: @zindex-popover;\n  display: none;\n  max-width: @popover-max-width;\n  padding: 1px;\n  text-align: left; // Reset given new insertion method\n  background-color: @popover-bg;\n  background-clip: padding-box;\n  border: 1px solid @popover-fallback-border-color;\n  border: 1px solid @popover-border-color;\n  border-radius: @border-radius-large;\n  .box-shadow(0 5px 10px rgba(0,0,0,.2));\n\n  // Overrides for proper insertion\n  white-space: normal;\n\n  // Offset the popover to account for the popover arrow\n  &.top     { margin-top: -10px; }\n  &.right   { margin-left: 10px; }\n  &.bottom  { margin-top: 10px; }\n  &.left    { margin-left: -10px; }\n}\n\n.popover-title {\n  margin: 0; // reset heading margin\n  padding: 8px 14px;\n  font-size: @font-size-base;\n  font-weight: normal;\n  line-height: 18px;\n  background-color: @popover-title-bg;\n  border-bottom: 1px solid darken(@popover-title-bg, 5%);\n  border-radius: 5px 5px 0 0;\n}\n\n.popover-content {\n  padding: 9px 14px;\n}\n\n// Arrows\n//\n// .arrow is outer, .arrow:after is inner\n\n.popover .arrow {\n  &,\n  &:after {\n    position: absolute;\n    display: block;\n    width: 0;\n    height: 0;\n    border-color: transparent;\n    border-style: solid;\n  }\n}\n.popover .arrow {\n  border-width: @popover-arrow-outer-width;\n}\n.popover .arrow:after {\n  border-width: @popover-arrow-width;\n  content: \"\";\n}\n\n.popover {\n  &.top .arrow {\n    left: 50%;\n    margin-left: -@popover-arrow-outer-width;\n    border-bottom-width: 0;\n    border-top-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-top-color: @popover-arrow-outer-color;\n    bottom: -@popover-arrow-outer-width;\n    &:after {\n      content: \" \";\n      bottom: 1px;\n      margin-left: -@popover-arrow-width;\n      border-bottom-width: 0;\n      border-top-color: @popover-arrow-color;\n    }\n  }\n  &.right .arrow {\n    top: 50%;\n    left: -@popover-arrow-outer-width;\n    margin-top: -@popover-arrow-outer-width;\n    border-left-width: 0;\n    border-right-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-right-color: @popover-arrow-outer-color;\n    &:after {\n      content: \" \";\n      left: 1px;\n      bottom: -@popover-arrow-width;\n      border-left-width: 0;\n      border-right-color: @popover-arrow-color;\n    }\n  }\n  &.bottom .arrow {\n    left: 50%;\n    margin-left: -@popover-arrow-outer-width;\n    border-top-width: 0;\n    border-bottom-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-bottom-color: @popover-arrow-outer-color;\n    top: -@popover-arrow-outer-width;\n    &:after {\n      content: \" \";\n      top: 1px;\n      margin-left: -@popover-arrow-width;\n      border-top-width: 0;\n      border-bottom-color: @popover-arrow-color;\n    }\n  }\n\n  &.left .arrow {\n    top: 50%;\n    right: -@popover-arrow-outer-width;\n    margin-top: -@popover-arrow-outer-width;\n    border-right-width: 0;\n    border-left-color: @popover-arrow-outer-fallback-color; // IE8 fallback\n    border-left-color: @popover-arrow-outer-color;\n    &:after {\n      content: \" \";\n      right: 1px;\n      border-right-width: 0;\n      border-left-color: @popover-arrow-color;\n      bottom: -@popover-arrow-width;\n    }\n  }\n\n}\n","print.less":"//\n// Basic print styles\n// --------------------------------------------------\n// Source: https://github.com/h5bp/html5-boilerplate/blob/master/css/main.css\n\n@media print {\n\n  * {\n    text-shadow: none !important;\n    color: #000 !important; // Black prints faster: h5bp.com/s\n    background: transparent !important;\n    box-shadow: none !important;\n  }\n\n  a,\n  a:visited {\n    text-decoration: underline;\n  }\n\n  a[href]:after {\n    content: \" (\" attr(href) \")\";\n  }\n\n  abbr[title]:after {\n    content: \" (\" attr(title) \")\";\n  }\n\n  // Don't show links for images, or javascript/internal links\n  a[href^=\"javascript:\"]:after,\n  a[href^=\"#\"]:after {\n    content: \"\";\n  }\n\n  pre,\n  blockquote {\n    border: 1px solid #999;\n    page-break-inside: avoid;\n  }\n\n  thead {\n    display: table-header-group; // h5bp.com/t\n  }\n\n  tr,\n  img {\n    page-break-inside: avoid;\n  }\n\n  img {\n    max-width: 100% !important;\n  }\n\n  @page {\n    margin: 2cm .5cm;\n  }\n\n  p,\n  h2,\n  h3 {\n    orphans: 3;\n    widows: 3;\n  }\n\n  h2,\n  h3 {\n    page-break-after: avoid;\n  }\n\n  // Chrome (OSX) fix for https://github.com/twbs/bootstrap/issues/11245\n  // Once fixed, we can just straight up remove this.\n  select {\n    background: #fff !important;\n  }\n\n  // Bootstrap components\n  .navbar {\n    display: none;\n  }\n  .table {\n    td,\n    th {\n      background-color: #fff !important;\n    }\n  }\n  .btn,\n  .dropup > .btn {\n    > .caret {\n      border-top-color: #000 !important;\n    }\n  }\n  .label {\n    border: 1px solid #000;\n  }\n\n  .table {\n    border-collapse: collapse !important;\n  }\n  .table-bordered {\n    th,\n    td {\n      border: 1px solid #ddd !important;\n    }\n  }\n\n}\n","progress-bars.less":"//\n// Progress bars\n// --------------------------------------------------\n\n\n// Bar animations\n// -------------------------\n\n// WebKit\n@-webkit-keyframes progress-bar-stripes {\n  from  { background-position: 40px 0; }\n  to    { background-position: 0 0; }\n}\n\n// Firefox\n@-moz-keyframes progress-bar-stripes {\n  from  { background-position: 40px 0; }\n  to    { background-position: 0 0; }\n}\n\n// Opera\n@-o-keyframes progress-bar-stripes {\n  from  { background-position: 0 0; }\n  to    { background-position: 40px 0; }\n}\n\n// Spec and IE10+\n@keyframes progress-bar-stripes {\n  from  { background-position: 40px 0; }\n  to    { background-position: 0 0; }\n}\n\n\n\n// Bar itself\n// -------------------------\n\n// Outer container\n.progress {\n  overflow: hidden;\n  height: @line-height-computed;\n  margin-bottom: @line-height-computed;\n  background-color: @progress-bg;\n  border-radius: @border-radius-base;\n  .box-shadow(inset 0 1px 2px rgba(0,0,0,.1));\n}\n\n// Bar of progress\n.progress-bar {\n  float: left;\n  width: 0%;\n  height: 100%;\n  font-size: @font-size-small;\n  line-height: @line-height-computed;\n  color: @progress-bar-color;\n  text-align: center;\n  background-color: @progress-bar-bg;\n  .box-shadow(inset 0 -1px 0 rgba(0,0,0,.15));\n  .transition(width .6s ease);\n}\n\n// Striped bars\n.progress-striped .progress-bar {\n  #gradient > .striped();\n  background-size: 40px 40px;\n}\n\n// Call animation for the active one\n.progress.active .progress-bar {\n  .animation(progress-bar-stripes 2s linear infinite);\n}\n\n\n\n// Variations\n// -------------------------\n\n.progress-bar-success {\n  .progress-bar-variant(@progress-bar-success-bg);\n}\n\n.progress-bar-info {\n  .progress-bar-variant(@progress-bar-info-bg);\n}\n\n.progress-bar-warning {\n  .progress-bar-variant(@progress-bar-warning-bg);\n}\n\n.progress-bar-danger {\n  .progress-bar-variant(@progress-bar-danger-bg);\n}\n","responsive-utilities.less":"//\n// Responsive: Utility classes\n// --------------------------------------------------\n\n\n// IE10 in Windows (Phone) 8\n//\n// Support for responsive views via media queries is kind of borked in IE10, for\n// Surface/desktop in split view and for Windows Phone 8. This particular fix\n// must be accompanied by a snippet of JavaScript to sniff the user agent and\n// apply some conditional CSS to *only* the Surface/desktop Windows 8. Look at\n// our Getting Started page for more information on this bug.\n//\n// For more information, see the following:\n//\n// Issue: https://github.com/twbs/bootstrap/issues/10497\n// Docs: http://getbootstrap.com/getting-started/#browsers\n// Source: http://timkadlec.com/2012/10/ie10-snap-mode-and-responsive-design/\n\n@-ms-viewport {\n  width: device-width;\n}\n\n\n// Visibility utilities\n\n.visible-xs {\n  .responsive-invisibility();\n  @media (max-width: @screen-xs-max) {\n    .responsive-visibility();\n  }\n  &.visible-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-visibility();\n    }\n  }\n}\n.visible-sm {\n  .responsive-invisibility();\n  &.visible-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-visibility();\n    }\n  }\n  @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n    .responsive-visibility();\n  }\n  &.visible-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-visibility();\n    }\n  }\n}\n.visible-md {\n  .responsive-invisibility();\n  &.visible-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-visibility();\n    }\n  }\n  @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n    .responsive-visibility();\n  }\n  &.visible-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-visibility();\n    }\n  }\n}\n.visible-lg {\n  .responsive-invisibility();\n  &.visible-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-visibility();\n    }\n  }\n  &.visible-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-visibility();\n    }\n  }\n  @media (min-width: @screen-lg-min) {\n    .responsive-visibility();\n  }\n}\n\n.hidden-xs {\n  .responsive-visibility();\n  @media (max-width: @screen-xs-max) {\n    .responsive-invisibility();\n  }\n  &.hidden-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-invisibility();\n    }\n  }\n}\n.hidden-sm {\n  .responsive-visibility();\n  &.hidden-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-invisibility();\n    }\n  }\n  @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n    .responsive-invisibility();\n  }\n  &.hidden-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-invisibility();\n    }\n  }\n}\n.hidden-md {\n  .responsive-visibility();\n  &.hidden-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-invisibility();\n    }\n  }\n  @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n    .responsive-invisibility();\n  }\n  &.hidden-lg {\n    @media (min-width: @screen-lg-min) {\n      .responsive-invisibility();\n    }\n  }\n}\n.hidden-lg {\n  .responsive-visibility();\n  &.hidden-xs {\n    @media (max-width: @screen-xs-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-sm {\n    @media (min-width: @screen-sm-min) and (max-width: @screen-sm-max) {\n      .responsive-invisibility();\n    }\n  }\n  &.hidden-md {\n    @media (min-width: @screen-md-min) and (max-width: @screen-md-max) {\n      .responsive-invisibility();\n    }\n  }\n  @media (min-width: @screen-lg-min) {\n    .responsive-invisibility();\n  }\n}\n\n// Print utilities\n.visible-print {\n  .responsive-invisibility();\n}\n\n@media print {\n  .visible-print {\n    .responsive-visibility();\n  }\n  .hidden-print {\n    .responsive-invisibility();\n  }\n}\n","scaffolding.less":"//\n// Scaffolding\n// --------------------------------------------------\n\n\n// Reset the box-sizing\n\n*,\n*:before,\n*:after {\n  .box-sizing(border-box);\n}\n\n\n// Body reset\n\nhtml {\n  font-size: 62.5%;\n  -webkit-tap-highlight-color: rgba(0,0,0,0);\n}\n\nbody {\n  font-family: @font-family-base;\n  font-size: @font-size-base;\n  line-height: @line-height-base;\n  color: @text-color;\n  background-color: @body-bg;\n}\n\n// Reset fonts for relevant elements\ninput,\nbutton,\nselect,\ntextarea {\n  font-family: inherit;\n  font-size: inherit;\n  line-height: inherit;\n}\n\n\n// Links\n\na {\n  color: @link-color;\n  text-decoration: none;\n\n  &:hover,\n  &:focus {\n    color: @link-hover-color;\n    text-decoration: underline;\n  }\n\n  &:focus {\n    .tab-focus();\n  }\n}\n\n\n// Images\n\nimg {\n  vertical-align: middle;\n}\n\n// Responsive images (ensure images don't scale beyond their parents)\n.img-responsive {\n  .img-responsive();\n}\n\n// Rounded corners\n.img-rounded {\n  border-radius: @border-radius-large;\n}\n\n// Image thumbnails\n//\n// Heads up! This is mixin-ed into thumbnails.less for `.thumbnail`.\n.img-thumbnail {\n  padding: @thumbnail-padding;\n  line-height: @line-height-base;\n  background-color: @thumbnail-bg;\n  border: 1px solid @thumbnail-border;\n  border-radius: @thumbnail-border-radius;\n  .transition(all .2s ease-in-out);\n\n  // Keep them at most 100% wide\n  .img-responsive(inline-block);\n}\n\n// Perfect circle\n.img-circle {\n  border-radius: 50%; // set radius in percents\n}\n\n\n// Horizontal rules\n\nhr {\n  margin-top:    @line-height-computed;\n  margin-bottom: @line-height-computed;\n  border: 0;\n  border-top: 1px solid @hr-border;\n}\n\n\n// Only display content to screen readers\n//\n// See: http://a11yproject.com/posts/how-to-hide-content/\n\n.sr-only {\n  position: absolute;\n  width: 1px;\n  height: 1px;\n  margin: -1px;\n  padding: 0;\n  overflow: hidden;\n  clip: rect(0,0,0,0);\n  border: 0;\n}\n","tables.less":"//\n// Tables\n// --------------------------------------------------\n\n\ntable {\n  max-width: 100%;\n  background-color: @table-bg;\n}\nth {\n  text-align: left;\n}\n\n\n// Baseline styles\n\n.table {\n  width: 100%;\n  margin-bottom: @line-height-computed;\n  // Cells\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-cell-padding;\n        line-height: @line-height-base;\n        vertical-align: top;\n        border-top: 1px solid @table-border-color;\n      }\n    }\n  }\n  // Bottom align for column headings\n  > thead > tr > th {\n    vertical-align: bottom;\n    border-bottom: 2px solid @table-border-color;\n  }\n  // Remove top border from thead by default\n  > caption + thead,\n  > colgroup + thead,\n  > thead:first-child {\n    > tr:first-child {\n      > th,\n      > td {\n        border-top: 0;\n      }\n    }\n  }\n  // Account for multiple tbody instances\n  > tbody + tbody {\n    border-top: 2px solid @table-border-color;\n  }\n\n  // Nesting\n  .table {\n    background-color: @body-bg;\n  }\n}\n\n\n// Condensed table w/ half padding\n\n.table-condensed {\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        padding: @table-condensed-cell-padding;\n      }\n    }\n  }\n}\n\n\n// Bordered version\n//\n// Add borders all around the table and between all the columns.\n\n.table-bordered {\n  border: 1px solid @table-border-color;\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > th,\n      > td {\n        border: 1px solid @table-border-color;\n      }\n    }\n  }\n  > thead > tr {\n    > th,\n    > td {\n      border-bottom-width: 2px;\n    }\n  }\n}\n\n\n// Zebra-striping\n//\n// Default zebra-stripe styles (alternating gray and transparent backgrounds)\n\n.table-striped {\n  > tbody > tr:nth-child(odd) {\n    > td,\n    > th {\n      background-color: @table-bg-accent;\n    }\n  }\n}\n\n\n// Hover effect\n//\n// Placed here since it has to come after the potential zebra striping\n\n.table-hover {\n  > tbody > tr:hover {\n    > td,\n    > th {\n      background-color: @table-bg-hover;\n    }\n  }\n}\n\n\n// Table cell sizing\n//\n// Reset default table behavior\n\ntable col[class*=\"col-\"] {\n  float: none;\n  display: table-column;\n}\ntable {\n  td,\n  th {\n    &[class*=\"col-\"] {\n      float: none;\n      display: table-cell;\n    }\n  }\n}\n\n\n// Table backgrounds\n//\n// Exact selectors below required to override `.table-striped` and prevent\n// inheritance to nested tables.\n\n.table {\n  > thead,\n  > tbody,\n  > tfoot {\n    > tr {\n      > td.active,\n      > th.active,\n      &.active > td,\n      &.active > th  {\n        background-color: @table-bg-active;\n      }\n    }\n  }\n}\n\n// Generate the contextual variants\n.table-row-variant(success; @state-success-bg; @state-success-border);\n.table-row-variant(danger; @state-danger-bg; @state-danger-border);\n.table-row-variant(warning; @state-warning-bg; @state-warning-border);\n\n\n// Responsive tables\n//\n// Wrap your tables in `.table-responsive` and we'll make them mobile friendly\n// by enabling horizontal scrolling. Only applies <768px. Everything above that\n// will display normally.\n\n@media (max-width: @screen-xs-max) {\n  .table-responsive {\n    width: 100%;\n    margin-bottom: (@line-height-computed * 0.75);\n    overflow-y: hidden;\n    overflow-x: scroll;\n    -ms-overflow-style: -ms-autohiding-scrollbar;\n    border: 1px solid @table-border-color;\n    -webkit-overflow-scrolling: touch;\n\n    // Tighten up spacing\n    > .table {\n      margin-bottom: 0;\n\n      // Ensure the content doesn't wrap\n      > thead,\n      > tbody,\n      > tfoot {\n        > tr {\n          > th,\n          > td {\n            white-space: nowrap;\n          }\n        }\n      }\n    }\n\n    // Special overrides for the bordered tables\n    > .table-bordered {\n      border: 0;\n\n      // Nuke the appropriate borders so that the parent can handle them\n      > thead,\n      > tbody,\n      > tfoot {\n        > tr {\n          > th:first-child,\n          > td:first-child {\n            border-left: 0;\n          }\n          > th:last-child,\n          > td:last-child {\n            border-right: 0;\n          }\n        }\n      }\n\n      // Only nuke the last row's bottom-border in `tbody` and `tfoot` since\n      // chances are there will be only one `tr` in a `thead` and that would\n      // remove the border altogether.\n      > tbody,\n      > tfoot {\n        > tr:last-child {\n          > th,\n          > td {\n            border-bottom: 0;\n          }\n        }\n      }\n\n    }\n  }\n}\n","theme.less":"\n//\n// Load core variables and mixins\n// --------------------------------------------------\n\n@import \"variables.less\";\n@import \"mixins.less\";\n\n\n\n//\n// Buttons\n// --------------------------------------------------\n\n// Common styles\n.btn-default,\n.btn-primary,\n.btn-success,\n.btn-info,\n.btn-warning,\n.btn-danger {\n  text-shadow: 0 -1px 0 rgba(0,0,0,.2);\n  @shadow: inset 0 1px 0 rgba(255,255,255,.15), 0 1px 1px rgba(0,0,0,.075);\n  .box-shadow(@shadow);\n\n  // Reset the shadow\n  &:active,\n  &.active {\n    .box-shadow(inset 0 3px 5px rgba(0,0,0,.125));\n  }\n}\n\n// Mixin for generating new styles\n.btn-styles(@btn-color: #555) {\n  #gradient > .vertical(@start-color: @btn-color; @end-color: darken(@btn-color, 12%));\n  .reset-filter(); // Disable gradients for IE9 because filter bleeds through rounded corners\n  background-repeat: repeat-x;\n  border-color: darken(@btn-color, 14%);\n\n  &:hover,\n  &:focus  {\n    background-color: darken(@btn-color, 12%);\n    background-position: 0 -15px;\n  }\n\n  &:active,\n  &.active {\n    background-color: darken(@btn-color, 12%);\n    border-color: darken(@btn-color, 14%);\n  }\n}\n\n// Common styles\n.btn {\n  // Remove the gradient for the pressed/active state\n  &:active,\n  &.active {\n    background-image: none;\n  }\n}\n\n// Apply the mixin to the buttons\n.btn-default { .btn-styles(@btn-default-bg); text-shadow: 0 1px 0 #fff; border-color: #ccc; }\n.btn-primary { .btn-styles(@btn-primary-bg); }\n.btn-success { .btn-styles(@btn-success-bg); }\n.btn-warning { .btn-styles(@btn-warning-bg); }\n.btn-danger  { .btn-styles(@btn-danger-bg); }\n.btn-info    { .btn-styles(@btn-info-bg); }\n\n\n\n//\n// Images\n// --------------------------------------------------\n\n.thumbnail,\n.img-thumbnail {\n  .box-shadow(0 1px 2px rgba(0,0,0,.075));\n}\n\n\n\n//\n// Dropdowns\n// --------------------------------------------------\n\n.dropdown-menu > li > a:hover,\n.dropdown-menu > li > a:focus {\n  #gradient > .vertical(@start-color: @dropdown-link-hover-bg; @end-color: darken(@dropdown-link-hover-bg, 5%));\n  background-color: darken(@dropdown-link-hover-bg, 5%);\n}\n.dropdown-menu > .active > a,\n.dropdown-menu > .active > a:hover,\n.dropdown-menu > .active > a:focus {\n  #gradient > .vertical(@start-color: @dropdown-link-active-bg; @end-color: darken(@dropdown-link-active-bg, 5%));\n  background-color: darken(@dropdown-link-active-bg, 5%);\n}\n\n\n\n//\n// Navbar\n// --------------------------------------------------\n\n// Default navbar\n.navbar-default {\n  #gradient > .vertical(@start-color: lighten(@navbar-default-bg, 10%); @end-color: @navbar-default-bg);\n  .reset-filter(); // Remove gradient in IE<10 to fix bug where dropdowns don't get triggered\n  border-radius: @navbar-border-radius;\n  @shadow: inset 0 1px 0 rgba(255,255,255,.15), 0 1px 5px rgba(0,0,0,.075);\n  .box-shadow(@shadow);\n\n  .navbar-nav > .active > a {\n    #gradient > .vertical(@start-color: darken(@navbar-default-bg, 5%); @end-color: darken(@navbar-default-bg, 2%));\n    .box-shadow(inset 0 3px 9px rgba(0,0,0,.075));\n  }\n}\n.navbar-brand,\n.navbar-nav > li > a {\n  text-shadow: 0 1px 0 rgba(255,255,255,.25);\n}\n\n// Inverted navbar\n.navbar-inverse {\n  #gradient > .vertical(@start-color: lighten(@navbar-inverse-bg, 10%); @end-color: @navbar-inverse-bg);\n  .reset-filter(); // Remove gradient in IE<10 to fix bug where dropdowns don't get triggered\n\n  .navbar-nav > .active > a {\n    #gradient > .vertical(@start-color: @navbar-inverse-bg; @end-color: lighten(@navbar-inverse-bg, 2.5%));\n    .box-shadow(inset 0 3px 9px rgba(0,0,0,.25));\n  }\n\n  .navbar-brand,\n  .navbar-nav > li > a {\n    text-shadow: 0 -1px 0 rgba(0,0,0,.25);\n  }\n}\n\n// Undo rounded corners in static and fixed navbars\n.navbar-static-top,\n.navbar-fixed-top,\n.navbar-fixed-bottom {\n  border-radius: 0;\n}\n\n\n\n//\n// Alerts\n// --------------------------------------------------\n\n// Common styles\n.alert {\n  text-shadow: 0 1px 0 rgba(255,255,255,.2);\n  @shadow: inset 0 1px 0 rgba(255,255,255,.25), 0 1px 2px rgba(0,0,0,.05);\n  .box-shadow(@shadow);\n}\n\n// Mixin for generating new styles\n.alert-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 7.5%));\n  border-color: darken(@color, 15%);\n}\n\n// Apply the mixin to the alerts\n.alert-success    { .alert-styles(@alert-success-bg); }\n.alert-info       { .alert-styles(@alert-info-bg); }\n.alert-warning    { .alert-styles(@alert-warning-bg); }\n.alert-danger     { .alert-styles(@alert-danger-bg); }\n\n\n\n//\n// Progress bars\n// --------------------------------------------------\n\n// Give the progress background some depth\n.progress {\n  #gradient > .vertical(@start-color: darken(@progress-bg, 4%); @end-color: @progress-bg)\n}\n\n// Mixin for generating new styles\n.progress-bar-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 10%));\n}\n\n// Apply the mixin to the progress bars\n.progress-bar            { .progress-bar-styles(@progress-bar-bg); }\n.progress-bar-success    { .progress-bar-styles(@progress-bar-success-bg); }\n.progress-bar-info       { .progress-bar-styles(@progress-bar-info-bg); }\n.progress-bar-warning    { .progress-bar-styles(@progress-bar-warning-bg); }\n.progress-bar-danger     { .progress-bar-styles(@progress-bar-danger-bg); }\n\n\n\n//\n// List groups\n// --------------------------------------------------\n\n.list-group {\n  border-radius: @border-radius-base;\n  .box-shadow(0 1px 2px rgba(0,0,0,.075));\n}\n.list-group-item.active,\n.list-group-item.active:hover,\n.list-group-item.active:focus {\n  text-shadow: 0 -1px 0 darken(@list-group-active-bg, 10%);\n  #gradient > .vertical(@start-color: @list-group-active-bg; @end-color: darken(@list-group-active-bg, 7.5%));\n  border-color: darken(@list-group-active-border, 7.5%);\n}\n\n\n\n//\n// Panels\n// --------------------------------------------------\n\n// Common styles\n.panel {\n  .box-shadow(0 1px 2px rgba(0,0,0,.05));\n}\n\n// Mixin for generating new styles\n.panel-heading-styles(@color) {\n  #gradient > .vertical(@start-color: @color; @end-color: darken(@color, 5%));\n}\n\n// Apply the mixin to the panel headings only\n.panel-default > .panel-heading   { .panel-heading-styles(@panel-default-heading-bg); }\n.panel-primary > .panel-heading   { .panel-heading-styles(@panel-primary-heading-bg); }\n.panel-success > .panel-heading   { .panel-heading-styles(@panel-success-heading-bg); }\n.panel-info > .panel-heading      { .panel-heading-styles(@panel-info-heading-bg); }\n.panel-warning > .panel-heading   { .panel-heading-styles(@panel-warning-heading-bg); }\n.panel-danger > .panel-heading    { .panel-heading-styles(@panel-danger-heading-bg); }\n\n\n\n//\n// Wells\n// --------------------------------------------------\n\n.well {\n  #gradient > .vertical(@start-color: darken(@well-bg, 5%); @end-color: @well-bg);\n  border-color: darken(@well-bg, 10%);\n  @shadow: inset 0 1px 3px rgba(0,0,0,.05), 0 1px 0 rgba(255,255,255,.1);\n  .box-shadow(@shadow);\n}\n","thumbnails.less":"//\n// Thumbnails\n// --------------------------------------------------\n\n\n// Mixin and adjust the regular image class\n.thumbnail {\n  .img-thumbnail();\n  display: block; // Override the inline-block from `.img-thumbnail`\n  margin-bottom: @line-height-computed;\n\n  > img {\n    .img-responsive();\n    margin-left: auto;\n    margin-right: auto;\n  }\n\n  // Add a hover state for linked versions only\n  a&:hover,\n  a&:focus,\n  a&.active {\n    border-color: @link-color;\n  }\n\n  // Image captions\n  .caption {\n    padding: @thumbnail-caption-padding;\n    color: @thumbnail-caption-color;\n  }\n}\n","tooltip.less":"//\n// Tooltips\n// --------------------------------------------------\n\n\n// Base class\n.tooltip {\n  position: absolute;\n  z-index: @zindex-tooltip;\n  display: block;\n  visibility: visible;\n  font-size: @font-size-small;\n  line-height: 1.4;\n  .opacity(0);\n\n  &.in     { .opacity(.9); }\n  &.top    { margin-top:  -3px; padding: @tooltip-arrow-width 0; }\n  &.right  { margin-left:  3px; padding: 0 @tooltip-arrow-width; }\n  &.bottom { margin-top:   3px; padding: @tooltip-arrow-width 0; }\n  &.left   { margin-left: -3px; padding: 0 @tooltip-arrow-width; }\n}\n\n// Wrapper for the tooltip content\n.tooltip-inner {\n  max-width: @tooltip-max-width;\n  padding: 3px 8px;\n  color: @tooltip-color;\n  text-align: center;\n  text-decoration: none;\n  background-color: @tooltip-bg;\n  border-radius: @border-radius-base;\n}\n\n// Arrows\n.tooltip-arrow {\n  position: absolute;\n  width: 0;\n  height: 0;\n  border-color: transparent;\n  border-style: solid;\n}\n.tooltip {\n  &.top .tooltip-arrow {\n    bottom: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-left .tooltip-arrow {\n    bottom: 0;\n    left: @tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.top-right .tooltip-arrow {\n    bottom: 0;\n    right: @tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-top-color: @tooltip-arrow-color;\n  }\n  &.right .tooltip-arrow {\n    top: 50%;\n    left: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width @tooltip-arrow-width @tooltip-arrow-width 0;\n    border-right-color: @tooltip-arrow-color;\n  }\n  &.left .tooltip-arrow {\n    top: 50%;\n    right: 0;\n    margin-top: -@tooltip-arrow-width;\n    border-width: @tooltip-arrow-width 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-left-color: @tooltip-arrow-color;\n  }\n  &.bottom .tooltip-arrow {\n    top: 0;\n    left: 50%;\n    margin-left: -@tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-left .tooltip-arrow {\n    top: 0;\n    left: @tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n  &.bottom-right .tooltip-arrow {\n    top: 0;\n    right: @tooltip-arrow-width;\n    border-width: 0 @tooltip-arrow-width @tooltip-arrow-width;\n    border-bottom-color: @tooltip-arrow-color;\n  }\n}\n","type.less":"//\n// Typography\n// --------------------------------------------------\n\n\n// Body text\n// -------------------------\n\np {\n  margin: 0 0 (@line-height-computed / 2);\n}\n.lead {\n  margin-bottom: @line-height-computed;\n  font-size: floor(@font-size-base * 1.15);\n  font-weight: 200;\n  line-height: 1.4;\n\n  @media (min-width: @screen-sm-min) {\n    font-size: (@font-size-base * 1.5);\n  }\n}\n\n\n// Emphasis & misc\n// -------------------------\n\n// Ex: 14px base font * 85% = about 12px\nsmall,\n.small  { font-size: 85%; }\n\n// Undo browser default styling\ncite    { font-style: normal; }\n\n// Contextual emphasis\n.text-muted {\n  color: @text-muted;\n}\n.text-primary {\n  color: @brand-primary;\n  &:hover {\n    color: darken(@brand-primary, 10%);\n  }\n}\n.text-warning {\n  color: @state-warning-text;\n  &:hover {\n    color: darken(@state-warning-text, 10%);\n  }\n}\n.text-danger {\n  color: @state-danger-text;\n  &:hover {\n    color: darken(@state-danger-text, 10%);\n  }\n}\n.text-success {\n  color: @state-success-text;\n  &:hover {\n    color: darken(@state-success-text, 10%);\n  }\n}\n.text-info {\n  color: @state-info-text;\n  &:hover {\n    color: darken(@state-info-text, 10%);\n  }\n}\n\n// Alignment\n.text-left           { text-align: left; }\n.text-right          { text-align: right; }\n.text-center         { text-align: center; }\n\n\n// Headings\n// -------------------------\n\nh1, h2, h3, h4, h5, h6,\n.h1, .h2, .h3, .h4, .h5, .h6 {\n  font-family: @headings-font-family;\n  font-weight: @headings-font-weight;\n  line-height: @headings-line-height;\n  color: @headings-color;\n\n  small,\n  .small {\n    font-weight: normal;\n    line-height: 1;\n    color: @headings-small-color;\n  }\n}\n\nh1,\nh2,\nh3 {\n  margin-top: @line-height-computed;\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 65%;\n  }\n}\nh4,\nh5,\nh6 {\n  margin-top: (@line-height-computed / 2);\n  margin-bottom: (@line-height-computed / 2);\n\n  small,\n  .small {\n    font-size: 75%;\n  }\n}\n\nh1, .h1 { font-size: @font-size-h1; }\nh2, .h2 { font-size: @font-size-h2; }\nh3, .h3 { font-size: @font-size-h3; }\nh4, .h4 { font-size: @font-size-h4; }\nh5, .h5 { font-size: @font-size-h5; }\nh6, .h6 { font-size: @font-size-h6; }\n\n\n// Page header\n// -------------------------\n\n.page-header {\n  padding-bottom: ((@line-height-computed / 2) - 1);\n  margin: (@line-height-computed * 2) 0 @line-height-computed;\n  border-bottom: 1px solid @page-header-border-color;\n}\n\n\n\n// Lists\n// --------------------------------------------------\n\n// Unordered and Ordered lists\nul,\nol {\n  margin-top: 0;\n  margin-bottom: (@line-height-computed / 2);\n  ul,\n  ol {\n    margin-bottom: 0;\n  }\n}\n\n// List options\n\n// Unstyled keeps list items block level, just removes default browser padding and list-style\n.list-unstyled {\n  padding-left: 0;\n  list-style: none;\n}\n\n// Inline turns list items into inline-block\n.list-inline {\n  .list-unstyled();\n\n  > li {\n    display: inline-block;\n    padding-left: 5px;\n    padding-right: 5px;\n\n    &:first-child {\n      padding-left: 0;\n    }\n  }\n}\n\n// Description Lists\ndl {\n  margin-bottom: @line-height-computed;\n}\ndt,\ndd {\n  line-height: @line-height-base;\n}\ndt {\n  font-weight: bold;\n}\ndd {\n  margin-left: 0; // Undo browser default\n}\n\n// Horizontal description lists\n//\n// Defaults to being stacked without any of the below styles applied, until the\n// grid breakpoint is reached (default of ~768px).\n\n@media (min-width: @grid-float-breakpoint) {\n  .dl-horizontal {\n    dt {\n      float: left;\n      width: (@component-offset-horizontal - 20);\n      clear: left;\n      text-align: right;\n      .text-overflow();\n    }\n    dd {\n      margin-left: @component-offset-horizontal;\n      .clearfix(); // Clear the floated `dt` if an empty `dd` is present\n    }\n  }\n}\n\n// MISC\n// ----\n\n// Abbreviations and acronyms\nabbr[title],\n// Add data-* attribute to help out our tooltip plugin, per https://github.com/twbs/bootstrap/issues/5257\nabbr[data-original-title] {\n  cursor: help;\n  border-bottom: 1px dotted @abbr-border-color;\n}\nabbr.initialism {\n  font-size: 90%;\n  text-transform: uppercase;\n}\n\n// Blockquotes\nblockquote {\n  padding: (@line-height-computed / 2) @line-height-computed;\n  margin: 0 0 @line-height-computed;\n  border-left: 5px solid @blockquote-border-color;\n  p {\n    font-size: (@font-size-base * 1.25);\n    font-weight: 300;\n    line-height: 1.25;\n  }\n  p:last-child {\n    margin-bottom: 0;\n  }\n  small {\n    display: block;\n    line-height: @line-height-base;\n    color: @blockquote-small-color;\n    &:before {\n      content: '\\2014 \\00A0'; // EM DASH, NBSP\n    }\n  }\n\n  // Float right with text-align: right\n  &.pull-right {\n    padding-right: 15px;\n    padding-left: 0;\n    border-right: 5px solid @blockquote-border-color;\n    border-left: 0;\n    p,\n    small,\n    .small {\n      text-align: right;\n    }\n    small,\n    .small {\n      &:before {\n        content: '';\n      }\n      &:after {\n        content: '\\00A0 \\2014'; // NBSP, EM DASH\n      }\n    }\n  }\n}\n\n// Quotes\nblockquote:before,\nblockquote:after {\n  content: \"\";\n}\n\n// Addresses\naddress {\n  margin-bottom: @line-height-computed;\n  font-style: normal;\n  line-height: @line-height-base;\n}\n","utilities.less":"//\n// Utility classes\n// --------------------------------------------------\n\n\n// Floats\n// -------------------------\n\n.clearfix {\n  .clearfix();\n}\n.center-block {\n  .center-block();\n}\n.pull-right {\n  float: right !important;\n}\n.pull-left {\n  float: left !important;\n}\n\n\n// Toggling content\n// -------------------------\n\n// Note: Deprecated .hide in favor of .hidden or .sr-only (as appropriate) in v3.0.1\n.hide {\n  display: none !important;\n}\n.show {\n  display: block !important;\n}\n.invisible {\n  visibility: hidden;\n}\n.text-hide {\n  .text-hide();\n}\n\n\n// Hide from screenreaders and browsers\n//\n// Credit: HTML5 Boilerplate\n\n.hidden {\n  display: none !important;\n  visibility: hidden !important;\n}\n\n\n// For Affix plugin\n// -------------------------\n\n.affix {\n  position: fixed;\n}\n","variables.less":"//\n// Variables\n// --------------------------------------------------\n\n\n// Global values\n// --------------------------------------------------\n\n// Grays\n// -------------------------\n\n@gray-darker:            lighten(#000, 13.5%); // #222\n@gray-dark:              lighten(#000, 20%);   // #333\n@gray:                   lighten(#000, 33.5%); // #555\n@gray-light:             lighten(#000, 60%);   // #999\n@gray-lighter:           lighten(#000, 93.5%); // #eee\n\n// Brand colors\n// -------------------------\n\n@brand-primary:         #428bca;\n@brand-success:         #5cb85c;\n@brand-warning:         #f0ad4e;\n@brand-danger:          #d9534f;\n@brand-info:            #5bc0de;\n\n// Scaffolding\n// -------------------------\n\n@body-bg:               #fff;\n@text-color:            @gray-dark;\n\n// Links\n// -------------------------\n\n@link-color:            @brand-primary;\n@link-hover-color:      darken(@link-color, 15%);\n\n// Typography\n// -------------------------\n\n@font-family-sans-serif:  \"Helvetica Neue\", Helvetica, Arial, sans-serif;\n@font-family-serif:       Georgia, \"Times New Roman\", Times, serif;\n@font-family-monospace:   Monaco, Menlo, Consolas, \"Courier New\", monospace;\n@font-family-base:        @font-family-sans-serif;\n\n@font-size-base:          14px;\n@font-size-large:         ceil(@font-size-base * 1.25); // ~18px\n@font-size-small:         ceil(@font-size-base * 0.85); // ~12px\n\n@font-size-h1:            floor(@font-size-base * 2.6); // ~36px\n@font-size-h2:            floor(@font-size-base * 2.15); // ~30px\n@font-size-h3:            ceil(@font-size-base * 1.7); // ~24px\n@font-size-h4:            ceil(@font-size-base * 1.25); // ~18px\n@font-size-h5:            @font-size-base;\n@font-size-h6:            ceil(@font-size-base * 0.85); // ~12px\n\n@line-height-base:        1.428571429; // 20/14\n@line-height-computed:    floor(@font-size-base * @line-height-base); // ~20px\n\n@headings-font-family:    @font-family-base;\n@headings-font-weight:    500;\n@headings-line-height:    1.1;\n@headings-color:          inherit;\n\n\n// Iconography\n// -------------------------\n\n@icon-font-path:          \"../fonts/\";\n@icon-font-name:          \"glyphicons-halflings-regular\";\n\n\n// Components\n// -------------------------\n// Based on 14px font-size and 1.428 line-height (~20px to start)\n\n@padding-base-vertical:          6px;\n@padding-base-horizontal:        12px;\n\n@padding-large-vertical:         10px;\n@padding-large-horizontal:       16px;\n\n@padding-small-vertical:         5px;\n@padding-small-horizontal:       10px;\n\n@line-height-large:              1.33;\n@line-height-small:              1.5;\n\n@border-radius-base:             4px;\n@border-radius-large:            6px;\n@border-radius-small:            3px;\n\n@component-active-color:         #fff;\n@component-active-bg:            @brand-primary;\n\n@caret-width-base:               4px;\n@caret-width-large:              5px;\n\n// Tables\n// -------------------------\n\n@table-cell-padding:                 8px;\n@table-condensed-cell-padding:       5px;\n\n@table-bg:                           transparent; // overall background-color\n@table-bg-accent:                    #f9f9f9; // for striping\n@table-bg-hover:                     #f5f5f5;\n@table-bg-active:                    @table-bg-hover;\n\n@table-border-color:                 #ddd; // table and cell border\n\n\n// Buttons\n// -------------------------\n\n@btn-font-weight:                normal;\n\n@btn-default-color:              #333;\n@btn-default-bg:                 #fff;\n@btn-default-border:             #ccc;\n\n@btn-primary-color:              #fff;\n@btn-primary-bg:                 @brand-primary;\n@btn-primary-border:             darken(@btn-primary-bg, 5%);\n\n@btn-success-color:              #fff;\n@btn-success-bg:                 @brand-success;\n@btn-success-border:             darken(@btn-success-bg, 5%);\n\n@btn-warning-color:              #fff;\n@btn-warning-bg:                 @brand-warning;\n@btn-warning-border:             darken(@btn-warning-bg, 5%);\n\n@btn-danger-color:               #fff;\n@btn-danger-bg:                  @brand-danger;\n@btn-danger-border:              darken(@btn-danger-bg, 5%);\n\n@btn-info-color:                 #fff;\n@btn-info-bg:                    @brand-info;\n@btn-info-border:                darken(@btn-info-bg, 5%);\n\n@btn-link-disabled-color:        @gray-light;\n\n\n// Forms\n// -------------------------\n\n@input-bg:                       #fff;\n@input-bg-disabled:              @gray-lighter;\n\n@input-color:                    @gray;\n@input-border:                   #ccc;\n@input-border-radius:            @border-radius-base;\n@input-border-focus:             #66afe9;\n\n@input-color-placeholder:        @gray-light;\n\n@input-height-base:              (@line-height-computed + (@padding-base-vertical * 2) + 2);\n@input-height-large:             (floor(@font-size-large * @line-height-large) + (@padding-large-vertical * 2) + 2);\n@input-height-small:             (floor(@font-size-small * @line-height-small) + (@padding-small-vertical * 2) + 2);\n\n@legend-color:                   @gray-dark;\n@legend-border-color:            #e5e5e5;\n\n@input-group-addon-bg:           @gray-lighter;\n@input-group-addon-border-color: @input-border;\n\n\n// Dropdowns\n// -------------------------\n\n@dropdown-bg:                    #fff;\n@dropdown-border:                rgba(0,0,0,.15);\n@dropdown-fallback-border:       #ccc;\n@dropdown-divider-bg:            #e5e5e5;\n\n@dropdown-link-color:            @gray-dark;\n@dropdown-link-hover-color:      darken(@gray-dark, 5%);\n@dropdown-link-hover-bg:         #f5f5f5;\n\n@dropdown-link-active-color:     @component-active-color;\n@dropdown-link-active-bg:        @component-active-bg;\n\n@dropdown-link-disabled-color:   @gray-light;\n\n@dropdown-header-color:          @gray-light;\n\n@dropdown-caret-color:           #000;\n\n\n// COMPONENT VARIABLES\n// --------------------------------------------------\n\n\n// Z-index master list\n// -------------------------\n// Used for a bird's eye view of components dependent on the z-axis\n// Try to avoid customizing these :)\n\n@zindex-navbar:            1000;\n@zindex-dropdown:          1000;\n@zindex-popover:           1010;\n@zindex-tooltip:           1030;\n@zindex-navbar-fixed:      1030;\n@zindex-modal-background:  1040;\n@zindex-modal:             1050;\n\n// Media queries breakpoints\n// --------------------------------------------------\n\n// Extra small screen / phone\n// Note: Deprecated @screen-xs and @screen-phone as of v3.0.1\n@screen-xs:                  480px;\n@screen-xs-min:              @screen-xs;\n@screen-phone:               @screen-xs-min;\n\n// Small screen / tablet\n// Note: Deprecated @screen-sm and @screen-tablet as of v3.0.1\n@screen-sm:                  768px;\n@screen-sm-min:              @screen-sm;\n@screen-tablet:              @screen-sm-min;\n\n// Medium screen / desktop\n// Note: Deprecated @screen-md and @screen-desktop as of v3.0.1\n@screen-md:                  992px;\n@screen-md-min:              @screen-md;\n@screen-desktop:             @screen-md-min;\n\n// Large screen / wide desktop\n// Note: Deprecated @screen-lg and @screen-lg-desktop as of v3.0.1\n@screen-lg:                  1200px;\n@screen-lg-min:              @screen-lg;\n@screen-lg-desktop:          @screen-lg-min;\n\n// So media queries don't overlap when required, provide a maximum\n@screen-xs-max:              (@screen-sm-min - 1);\n@screen-sm-max:              (@screen-md-min - 1);\n@screen-md-max:              (@screen-lg-min - 1);\n\n\n// Grid system\n// --------------------------------------------------\n\n// Number of columns in the grid system\n@grid-columns:              12;\n// Padding, to be divided by two and applied to the left and right of all columns\n@grid-gutter-width:         30px;\n// Point at which the navbar stops collapsing\n@grid-float-breakpoint:     @screen-sm-min;\n\n\n// Navbar\n// -------------------------\n\n// Basics of a navbar\n@navbar-height:                    50px;\n@navbar-margin-bottom:             @line-height-computed;\n@navbar-border-radius:             @border-radius-base;\n@navbar-padding-horizontal:        floor(@grid-gutter-width / 2);\n@navbar-padding-vertical:          ((@navbar-height - @line-height-computed) / 2);\n\n@navbar-default-color:             #777;\n@navbar-default-bg:                #f8f8f8;\n@navbar-default-border:            darken(@navbar-default-bg, 6.5%);\n\n// Navbar links\n@navbar-default-link-color:                #777;\n@navbar-default-link-hover-color:          #333;\n@navbar-default-link-hover-bg:             transparent;\n@navbar-default-link-active-color:         #555;\n@navbar-default-link-active-bg:            darken(@navbar-default-bg, 6.5%);\n@navbar-default-link-disabled-color:       #ccc;\n@navbar-default-link-disabled-bg:          transparent;\n\n// Navbar brand label\n@navbar-default-brand-color:               @navbar-default-link-color;\n@navbar-default-brand-hover-color:         darken(@navbar-default-brand-color, 10%);\n@navbar-default-brand-hover-bg:            transparent;\n\n// Navbar toggle\n@navbar-default-toggle-hover-bg:           #ddd;\n@navbar-default-toggle-icon-bar-bg:        #ccc;\n@navbar-default-toggle-border-color:       #ddd;\n\n\n// Inverted navbar\n//\n// Reset inverted navbar basics\n@navbar-inverse-color:                      @gray-light;\n@navbar-inverse-bg:                         #222;\n@navbar-inverse-border:                     darken(@navbar-inverse-bg, 10%);\n\n// Inverted navbar links\n@navbar-inverse-link-color:                 @gray-light;\n@navbar-inverse-link-hover-color:           #fff;\n@navbar-inverse-link-hover-bg:              transparent;\n@navbar-inverse-link-active-color:          @navbar-inverse-link-hover-color;\n@navbar-inverse-link-active-bg:             darken(@navbar-inverse-bg, 10%);\n@navbar-inverse-link-disabled-color:        #444;\n@navbar-inverse-link-disabled-bg:           transparent;\n\n// Inverted navbar brand label\n@navbar-inverse-brand-color:                @navbar-inverse-link-color;\n@navbar-inverse-brand-hover-color:          #fff;\n@navbar-inverse-brand-hover-bg:             transparent;\n\n// Inverted navbar toggle\n@navbar-inverse-toggle-hover-bg:            #333;\n@navbar-inverse-toggle-icon-bar-bg:         #fff;\n@navbar-inverse-toggle-border-color:        #333;\n\n\n// Navs\n// -------------------------\n\n@nav-link-padding:                          10px 15px;\n@nav-link-hover-bg:                         @gray-lighter;\n\n@nav-disabled-link-color:                   @gray-light;\n@nav-disabled-link-hover-color:             @gray-light;\n\n@nav-open-link-hover-color:                 #fff;\n@nav-open-caret-border-color:               #fff;\n\n// Tabs\n@nav-tabs-border-color:                     #ddd;\n\n@nav-tabs-link-hover-border-color:          @gray-lighter;\n\n@nav-tabs-active-link-hover-bg:             @body-bg;\n@nav-tabs-active-link-hover-color:          @gray;\n@nav-tabs-active-link-hover-border-color:   #ddd;\n\n@nav-tabs-justified-link-border-color:            #ddd;\n@nav-tabs-justified-active-link-border-color:     @body-bg;\n\n// Pills\n@nav-pills-border-radius:                   @border-radius-base;\n@nav-pills-active-link-hover-bg:            @component-active-bg;\n@nav-pills-active-link-hover-color:         @component-active-color;\n\n\n// Pagination\n// -------------------------\n\n@pagination-bg:                        #fff;\n@pagination-border:                    #ddd;\n\n@pagination-hover-bg:                  @gray-lighter;\n\n@pagination-active-bg:                 @brand-primary;\n@pagination-active-color:              #fff;\n\n@pagination-disabled-color:            @gray-light;\n\n\n// Pager\n// -------------------------\n\n@pager-border-radius:                  15px;\n@pager-disabled-color:                 @gray-light;\n\n\n// Jumbotron\n// -------------------------\n\n@jumbotron-padding:              30px;\n@jumbotron-color:                inherit;\n@jumbotron-bg:                   @gray-lighter;\n@jumbotron-heading-color:        inherit;\n@jumbotron-font-size:            ceil(@font-size-base * 1.5);\n\n\n// Form states and alerts\n// -------------------------\n\n@state-success-text:             #468847;\n@state-success-bg:               #dff0d8;\n@state-success-border:           darken(spin(@state-success-bg, -10), 5%);\n\n@state-info-text:                #3a87ad;\n@state-info-bg:                  #d9edf7;\n@state-info-border:              darken(spin(@state-info-bg, -10), 7%);\n\n@state-warning-text:             #c09853;\n@state-warning-bg:               #fcf8e3;\n@state-warning-border:           darken(spin(@state-warning-bg, -10), 5%);\n\n@state-danger-text:              #b94a48;\n@state-danger-bg:                #f2dede;\n@state-danger-border:            darken(spin(@state-danger-bg, -10), 5%);\n\n\n// Tooltips\n// -------------------------\n@tooltip-max-width:           200px;\n@tooltip-color:               #fff;\n@tooltip-bg:                  #000;\n\n@tooltip-arrow-width:         5px;\n@tooltip-arrow-color:         @tooltip-bg;\n\n\n// Popovers\n// -------------------------\n@popover-bg:                          #fff;\n@popover-max-width:                   276px;\n@popover-border-color:                rgba(0,0,0,.2);\n@popover-fallback-border-color:       #ccc;\n\n@popover-title-bg:                    darken(@popover-bg, 3%);\n\n@popover-arrow-width:                 10px;\n@popover-arrow-color:                 #fff;\n\n@popover-arrow-outer-width:           (@popover-arrow-width + 1);\n@popover-arrow-outer-color:           rgba(0,0,0,.25);\n@popover-arrow-outer-fallback-color:  #999;\n\n\n// Labels\n// -------------------------\n\n@label-default-bg:            @gray-light;\n@label-primary-bg:            @brand-primary;\n@label-success-bg:            @brand-success;\n@label-info-bg:               @brand-info;\n@label-warning-bg:            @brand-warning;\n@label-danger-bg:             @brand-danger;\n\n@label-color:                 #fff;\n@label-link-hover-color:      #fff;\n\n\n// Modals\n// -------------------------\n@modal-inner-padding:         20px;\n\n@modal-title-padding:         15px;\n@modal-title-line-height:     @line-height-base;\n\n@modal-content-bg:                             #fff;\n@modal-content-border-color:                   rgba(0,0,0,.2);\n@modal-content-fallback-border-color:          #999;\n\n@modal-backdrop-bg:           #000;\n@modal-header-border-color:   #e5e5e5;\n@modal-footer-border-color:   @modal-header-border-color;\n\n\n// Alerts\n// -------------------------\n@alert-padding:               15px;\n@alert-border-radius:         @border-radius-base;\n@alert-link-font-weight:      bold;\n\n@alert-success-bg:            @state-success-bg;\n@alert-success-text:          @state-success-text;\n@alert-success-border:        @state-success-border;\n\n@alert-info-bg:               @state-info-bg;\n@alert-info-text:             @state-info-text;\n@alert-info-border:           @state-info-border;\n\n@alert-warning-bg:            @state-warning-bg;\n@alert-warning-text:          @state-warning-text;\n@alert-warning-border:        @state-warning-border;\n\n@alert-danger-bg:             @state-danger-bg;\n@alert-danger-text:           @state-danger-text;\n@alert-danger-border:         @state-danger-border;\n\n\n// Progress bars\n// -------------------------\n@progress-bg:                 #f5f5f5;\n@progress-bar-color:          #fff;\n\n@progress-bar-bg:             @brand-primary;\n@progress-bar-success-bg:     @brand-success;\n@progress-bar-warning-bg:     @brand-warning;\n@progress-bar-danger-bg:      @brand-danger;\n@progress-bar-info-bg:        @brand-info;\n\n\n// List group\n// -------------------------\n@list-group-bg:               #fff;\n@list-group-border:           #ddd;\n@list-group-border-radius:    @border-radius-base;\n\n@list-group-hover-bg:         #f5f5f5;\n@list-group-active-color:     @component-active-color;\n@list-group-active-bg:        @component-active-bg;\n@list-group-active-border:    @list-group-active-bg;\n\n@list-group-link-color:          #555;\n@list-group-link-heading-color:  #333;\n\n\n// Panels\n// -------------------------\n@panel-bg:                    #fff;\n@panel-inner-border:          #ddd;\n@panel-border-radius:         @border-radius-base;\n@panel-footer-bg:             #f5f5f5;\n\n@panel-default-text:          @gray-dark;\n@panel-default-border:        #ddd;\n@panel-default-heading-bg:    #f5f5f5;\n\n@panel-primary-text:          #fff;\n@panel-primary-border:        @brand-primary;\n@panel-primary-heading-bg:    @brand-primary;\n\n@panel-success-text:          @state-success-text;\n@panel-success-border:        @state-success-border;\n@panel-success-heading-bg:    @state-success-bg;\n\n@panel-warning-text:          @state-warning-text;\n@panel-warning-border:        @state-warning-border;\n@panel-warning-heading-bg:    @state-warning-bg;\n\n@panel-danger-text:           @state-danger-text;\n@panel-danger-border:         @state-danger-border;\n@panel-danger-heading-bg:     @state-danger-bg;\n\n@panel-info-text:             @state-info-text;\n@panel-info-border:           @state-info-border;\n@panel-info-heading-bg:       @state-info-bg;\n\n\n// Thumbnails\n// -------------------------\n@thumbnail-padding:           4px;\n@thumbnail-bg:                @body-bg;\n@thumbnail-border:            #ddd;\n@thumbnail-border-radius:     @border-radius-base;\n\n@thumbnail-caption-color:     @text-color;\n@thumbnail-caption-padding:   9px;\n\n\n// Wells\n// -------------------------\n@well-bg:                     #f5f5f5;\n\n\n// Badges\n// -------------------------\n@badge-color:                 #fff;\n@badge-link-hover-color:      #fff;\n@badge-bg:                    @gray-light;\n\n@badge-active-color:          @link-color;\n@badge-active-bg:             #fff;\n\n@badge-font-weight:           bold;\n@badge-line-height:           1;\n@badge-border-radius:         10px;\n\n\n// Breadcrumbs\n// -------------------------\n@breadcrumb-bg:               #f5f5f5;\n@breadcrumb-color:            #ccc;\n@breadcrumb-active-color:     @gray-light;\n@breadcrumb-separator:        \"/\";\n\n\n// Carousel\n// ------------------------\n\n@carousel-text-shadow:                        0 1px 2px rgba(0,0,0,.6);\n\n@carousel-control-color:                      #fff;\n@carousel-control-width:                      15%;\n@carousel-control-opacity:                    .5;\n@carousel-control-font-size:                  20px;\n\n@carousel-indicator-active-bg:                #fff;\n@carousel-indicator-border-color:             #fff;\n\n@carousel-caption-color:                      #fff;\n\n\n// Close\n// ------------------------\n@close-font-weight:           bold;\n@close-color:                 #000;\n@close-text-shadow:           0 1px 0 #fff;\n\n\n// Code\n// ------------------------\n@code-color:                  #c7254e;\n@code-bg:                     #f9f2f4;\n\n@pre-bg:                      #f5f5f5;\n@pre-color:                   @gray-dark;\n@pre-border-color:            #ccc;\n@pre-scrollable-max-height:   340px;\n\n// Type\n// ------------------------\n@text-muted:                  @gray-light;\n@abbr-border-color:           @gray-light;\n@headings-small-color:        @gray-light;\n@blockquote-small-color:      @gray-light;\n@blockquote-border-color:     @gray-lighter;\n@page-header-border-color:    @gray-lighter;\n\n// Miscellaneous\n// -------------------------\n\n// Hr border color\n@hr-border:                   @gray-lighter;\n\n// Horizontal forms & lists\n@component-offset-horizontal: 180px;\n\n\n// Container sizes\n// --------------------------------------------------\n\n// Small screen / tablet\n@container-tablet:             ((720px + @grid-gutter-width));\n@container-sm:                 @container-tablet;\n\n// Medium screen / desktop\n@container-desktop:            ((940px + @grid-gutter-width));\n@container-md:                 @container-desktop;\n\n// Large screen / wide desktop\n@container-large-desktop:      ((1140px + @grid-gutter-width));\n@container-lg:                 @container-large-desktop;\n","wells.less":"//\n// Wells\n// --------------------------------------------------\n\n\n// Base class\n.well {\n  min-height: 20px;\n  padding: 19px;\n  margin-bottom: 20px;\n  background-color: @well-bg;\n  border: 1px solid darken(@well-bg, 7%);\n  border-radius: @border-radius-base;\n  .box-shadow(inset 0 1px 1px rgba(0,0,0,.05));\n  blockquote {\n    border-color: #ddd;\n    border-color: rgba(0,0,0,.15);\n  }\n}\n\n// Sizes\n.well-lg {\n  padding: 24px;\n  border-radius: @border-radius-large;\n}\n.well-sm {\n  padding: 9px;\n  border-radius: @border-radius-small;\n}\n"}
var __fonts = {"glyphicons-halflings-regular.eot":"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","glyphicons-halflings-regular.svg":"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","glyphicons-halflings-regular.ttf":"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","glyphicons-halflings-regular.woff":"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"}
