package com.ctrip.framework.apollo.configservice.util;

import com.ctrip.framework.apollo.biz.entity.Instance;
import com.ctrip.framework.apollo.biz.entity.InstanceConfig;
import com.ctrip.framework.apollo.biz.service.InstanceService;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.function.ObjDoubleConsumer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Matchers.anyBoolean;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * @author Jason Song(song_s@ctrip.com)
 */
@RunWith(MockitoJUnitRunner.class)
public class InstanceConfigAuditUtilTest {
  private InstanceConfigAuditUtil instanceConfigAuditUtil;

  @Mock
  private InstanceService instanceService;
  private BlockingQueue<InstanceConfigAuditUtil.InstanceConfigAuditModel> audits;

  private String someAppId;
  private String someClusterName;
  private String someDataCenter;
  private String someIp;
  private String someConfigAppId;
  private String someConfigNamespace;
  private String someReleaseKey;

  private InstanceConfigAuditUtil.InstanceConfigAuditModel someAuditModel;

  @Before
  public void setUp() throws Exception {
    instanceConfigAuditUtil = new InstanceConfigAuditUtil();

    ReflectionTestUtils.setField(instanceConfigAuditUtil, "instanceService", instanceService);

    audits = (BlockingQueue<InstanceConfigAuditUtil.InstanceConfigAuditModel>)
        ReflectionTestUtils.getField(instanceConfigAuditUtil, "audits");

    someAppId = "someAppId";
    someClusterName = "someClusterName";
    someDataCenter = "someDataCenter";
    someIp = "someIp";
    someConfigAppId = "someConfigAppId";
    someConfigNamespace = "someConfigNamespace";
    someReleaseKey = "someReleaseKey";

    someAuditModel = new InstanceConfigAuditUtil.InstanceConfigAuditModel(someAppId,
        someClusterName, someDataCenter, someIp, someConfigAppId, someConfigNamespace,
        someReleaseKey);
  }

  @Test
  public void testAudit() throws Exception {
    boolean result = instanceConfigAuditUtil.audit(someAppId, someClusterName, someDataCenter,
        someIp, someConfigAppId, someConfigNamespace, someReleaseKey);

    InstanceConfigAuditUtil.InstanceConfigAuditModel audit = audits.poll();

    assertTrue(result);
    assertTrue(Objects.equals(someAuditModel, audit));
  }

  @Test
  public void testDoAudit() throws Exception {
    long someInstanceId = 1;
    Instance someInstance = mock(Instance.class);

    when(someInstance.getId()).thenReturn(someInstanceId);
    when(instanceService.createInstance(any(Instance.class))).thenReturn(someInstance);

    instanceConfigAuditUtil.doAudit(someAuditModel);

    verify(instanceService, times(1)).findInstance(someAppId, someClusterName, someDataCenter,
        someIp);
    verify(instanceService, times(1)).createInstance(any(Instance.class));
    verify(instanceService, times(1)).findInstanceConfig(someInstanceId, someConfigAppId,
        someConfigNamespace);
    verify(instanceService, times(1)).createInstanceConfig(any(InstanceConfig.class));
  }


}