appUtil.service('AppUtil', ['toastr', function (toastr) {

    return {
        errorMsg: function (response) {
            if (response.status == -1) {
                return "您的登录信息已过期,请刷新页面后重试";
            }
            var msg = "Code:" + response.status;
            if (response.data.message != null) {
                msg += " Msg:" + response.data.message;
            }
            return msg;
        },
        parseParams: function (path) {
            if (!path) {
                return {};
            }
            if (path.indexOf('/') == 0) {
                path = path.substring(1, path.length);
            }
            var params = path.split("&");
            var result = {};
            params.forEach(function (param) {
                var kv = param.split("=");
                result[kv[0]] = kv[1];
            });
            return result;
        },
        collectData: function (response) {
            var data = [];
            response.entities.forEach(function (entity) {
                if (entity.code == 200) {
                    data.push(entity.body);
                } else {
                    toastr.warning(entity.message);
                }
            });
            return data;
        }
    }
}]);
