role_module.controller('NamespaceRoleController',
                       ['$scope', '$location', '$window', 'toastr', 'AppService', 'UserService', 'AppUtil',
                        'PermissionService',
                        function ($scope, $location, $window, toastr, AppService, UserService, AppUtil,
                                  PermissionService) {

                            var params = AppUtil.parseParams($location.$$url);
                            $scope.pageContext = {
                                appId: params.appid,
                                namespaceName: params.namespaceName
                            };
                            
                            $scope.releaseRoleWidgetId = 'releaseRoleWidgetId';
                            $scope.modifyRoleWidgetId = 'modifyRoleWidgetId';

                            PermissionService.has_assign_user_permission($scope.pageContext.appId)
                                .then(function (result) {
                                    $scope.hasAssignUserPermission = result.hasPermission;
                                }, function (reslt) {

                                });

                            PermissionService.get_namespace_role_users($scope.pageContext.appId,
                                                                       $scope.pageContext.namespaceName)
                                .then(function (result) {
                                    $scope.rolesAssignedUsers = result;
                                    console.log(result);
                                }, function (result) {
                                    toastr.error(AppUtil.errorMsg(result), "加载授权用户出错");
                                });


                            $scope.assignRoleToUser = function (roleType) {
                                if ('ReleaseNamespace' == roleType) {
                                    var toAssignReleaseNamespaceRoleUser = $('.' + $scope.releaseRoleWidgetId).select2('data')[0].id;
                                    PermissionService.assign_release_namespace_role($scope.pageContext.appId,
                                                                                    $scope.pageContext.namespaceName,
                                                                                    toAssignReleaseNamespaceRoleUser)
                                        .then(function (result) {
                                            toastr.success("添加成功");
                                            $scope.rolesAssignedUsers.releaseRoleUsers.push(
                                                {userId: toAssignReleaseNamespaceRoleUser});
                                        }, function (result) {
                                            toastr.error(AppUtil.errorMsg(result), "添加失败");
                                        });
                                } else {
                                    var toAssignModifyNamespaceRoleUser = $('.' + $scope.modifyRoleWidgetId).select2('data')[0].id;
                                    PermissionService.assign_modify_namespace_role($scope.pageContext.appId,
                                                                                   $scope.pageContext.namespaceName,
                                                                                   toAssignModifyNamespaceRoleUser)
                                        .then(function (result) {
                                            toastr.success("添加成功");
                                            $scope.rolesAssignedUsers.modifyRoleUsers.push(
                                                {userId: toAssignModifyNamespaceRoleUser});
                                        }, function (result) {
                                            toastr.error(AppUtil.errorMsg(result), "添加失败");
                                        });
                                }
                            };

                            $scope.removeUserRole = function (roleType, user) {
                                if ('ReleaseNamespace' == roleType) {
                                    PermissionService.remove_release_namespace_role($scope.pageContext.appId,
                                                                                    $scope.pageContext.namespaceName,
                                                                                    user)
                                        .then(function (result) {
                                            toastr.success("删除成功");
                                            removeUserFromList($scope.rolesAssignedUsers.releaseRoleUsers, user);
                                        }, function (result) {
                                            toastr.error(AppUtil.errorMsg(result), "删除失败");
                                        });
                                } else {
                                    PermissionService.remove_modify_namespace_role($scope.pageContext.appId,
                                                                                   $scope.pageContext.namespaceName,
                                                                                   user)
                                        .then(function (result) {
                                            toastr.success("删除成功");
                                            removeUserFromList($scope.rolesAssignedUsers.modifyRoleUsers, user);
                                        }, function (result) {
                                            toastr.error(AppUtil.errorMsg(result), "删除失败");
                                        });
                                }
                            };

                            function removeUserFromList(list, user) {
                                var index = 0;
                                for (var i = 0; i < list.length; i++) {
                                    if (list[i].userId == user) {
                                        index = i;
                                        break;
                                    }
                                }
                                list.splice(index, 1);
                            }
                            
                            $scope.modifyRoleUsersId = 'J_modify_role_users';
                            $scope.releaseRoleUsersId = 'J_release_role_users';

                        }]);
