/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50520
Source Host           : localhost:3306
Source Database       : db-mcms-open-4.5.8

Target Server Type    : MYSQL
Target Server Version : 50520
File Encoding         : 65001

Date: 2016-06-28 16:09:01
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `app`
-- ----------------------------
DROP TABLE IF EXISTS `app`;
CREATE TABLE `app` (
  `APP_ID` int(22) NOT NULL AUTO_INCREMENT COMMENT '站点ID，关联基础表BasicId',
  `APP_NAME` varchar(60) NOT NULL COMMENT '站点名称',
  `APP_URL` varchar(200) NOT NULL COMMENT '站点域名，多个回车换行显示',
  `APP_LOGO` varchar(120) DEFAULT NULL COMMENT '网站logo',
  `APP_KEYWORD` varchar(500) DEFAULT NULL COMMENT '站点关键字',
  `APP_COPYRIGHT` varchar(500) DEFAULT NULL COMMENT '站点版权信息',
  `APP_STYLE` varchar(50) DEFAULT NULL COMMENT '站点风格',
  `APP_MANAGERID` int(11) DEFAULT NULL COMMENT '站点对于管理员编号',
  `APP_DESCRIPTION` varchar(500) DEFAULT NULL COMMENT '描述',
  `APP_DATETIME` datetime DEFAULT NULL COMMENT '创建时间',
  `APP_MOBILE_STYLE` varchar(11) DEFAULT NULL COMMENT '移动端风格',
  `APP_PAY_DATE` datetime DEFAULT NULL COMMENT '应用续费时间',
  `APP_PAY` varchar(300) DEFAULT NULL COMMENT '费用清单',
  `APP_STATE` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0运行中 1已停止  ',
  `APP_MOBILE_STATE` int(1) unsigned NOT NULL DEFAULT '0' COMMENT '0启用 1停用',
  PRIMARY KEY (`APP_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=1550 DEFAULT CHARSET=utf8 COMMENT='应用表';

-- ----------------------------
-- Records of app
-- ----------------------------
INSERT INTO `app` VALUES ('1', 'MCMS-OPEN', 'http://localhost:8080/mcms', '', '', '', 'mooc', '50', '', null, 'm', null, '', '0', '0');

-- ----------------------------
-- Table structure for `basic`
-- ----------------------------
DROP TABLE IF EXISTS `basic`;
CREATE TABLE `basic` (
  `BASIC_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `BASIC_TITLE` varchar(300) DEFAULT NULL COMMENT '标题',
  `BASIC_DESCRIPTION` text COMMENT '描述',
  `BASIC_THUMBNAILS` varchar(1000) DEFAULT NULL COMMENT '缩略图',
  `BASIC_HIT` bigint(22) DEFAULT NULL COMMENT '点击次数',
  `BASIC_SORT` int(11) DEFAULT NULL COMMENT '排序',
  `BASIC_DATETIME` datetime DEFAULT NULL COMMENT ' 发布时间',
  `BASIC_UPDATETIME` datetime DEFAULT NULL COMMENT '更新时间',
  `BASIC_PEOPLEID` int(22) DEFAULT NULL COMMENT '用户编号',
  `BASIC_CATEGORYID` int(22) DEFAULT NULL COMMENT '所属分类编号',
  `BASIC_APPID` int(11) DEFAULT NULL COMMENT '应用编号',
  `BASIC_MODELID` int(11) DEFAULT NULL COMMENT '模块编号',
  `BASIC_COMMENT` int(11) DEFAULT NULL COMMENT '评论次数',
  `BASIC_COLLECT` int(11) DEFAULT NULL COMMENT '收藏次数',
  `BASIC_SHARE` int(11) DEFAULT NULL COMMENT '分享次数',
  `BASIC_TYPE` varchar(255) DEFAULT NULL COMMENT '属性',
  PRIMARY KEY (`BASIC_ID`),
  UNIQUE KEY `SYS_C009068` (`BASIC_ID`),
  KEY `BASIC_TITLE` (`BASIC_TITLE`(255)),
  KEY `BASIC_APPID` (`BASIC_APPID`) USING BTREE,
  KEY `BASIC_MODELID` (`BASIC_MODELID`) USING BTREE,
  KEY `BASIC_CATEGORYID` (`BASIC_CATEGORYID`) USING BTREE,
  KEY `BASIC_DATETIME` (`BASIC_DATETIME`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=220 DEFAULT CHARSET=utf8 COMMENT='基础表';

-- ----------------------------
-- Records of basic
-- ----------------------------
INSERT INTO `basic` VALUES ('1', 'sdadsa', 'qwe', '/upload/article/1/1442553027420.jpg', '0', '11', '2015-09-18 13:10:38', '2015-09-18 13:10:38', '0', '15', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('2', '外国工艺美术史', '本课程为清华大学人文素质核心课程。自从地球上有了人类，工艺美术也就开始产生了。\r\n一部工艺美术史，实际上也是人类文明不断发展、演变和进步历程的形象记录。上下百万年，人们创造的分布在世界各地、难以数计的工艺美术作品，无一不是人类文明高容量的载体。\r\n外国工艺美术史研究是人文学科中的重要环节。它对培养国人的文化素质，提高我国综合素质教育质量，完善人文学科，树立学术形象，提升综合学术地位，皆有重要意义。', '/upload/article/1/1442556661232.png', '0', '0', '2015-09-18 14:11:46', '2015-09-18 17:59:57', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('3', '古文字学', '讲授甲骨、金文、战国古文等古代文字的课程。\r\n本课程主要讲授汉字的起源、发展及不同历史时期的文字面貌，涉及甲骨文、金文、小篆、战国古文、早期隶书、《说文》部首等，使学生对于中国文字的形态及文字学历史有一个概貌性的认识，并初步掌握识读古文字的方法。另外，通过讲授古文字学的基本理论（如古文字学的性质、任务，汉字起源，古文字的考释方法，古文字的演变规律等）和各种古文字原材料（如甲骨文、金文、简帛、玺印、货币文字等），开拓学生视野，熟悉古文字遗产，掌握有关古文字的基础知识，具有阅读和钻研古文字原材料的初步能力，为进一步学习和研究古代的语言文字打下基础，进而初步具备整理古籍文献及出土文献的方法及进一步从事古文字研究、比较文字学研究的能力。', '/upload/article/1/1442556728074.png', '0', '0', '2015-09-18 14:13:07', '2015-09-18 18:00:05', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('4', 'Data Analysis and Statistical Inference', '认清数据收集的重要性，认清数据收集方法的局限，认清这些因素是如何影响推断的。使用数据软件（R）来在数字上和在视觉上总结数据，并且呈现对数据的分析。\r\n对统计推断的本质有一个概念上的理解。利用评估和测试方法（置信区间和假说测试）来分析单一变量和两个变量之间的关系，以便于理解自然现象的本质以及做出基于数据的决策。利用回归框架做模型来研究两个或更多数据之间的关系。', '/upload/article/1/1442556817573.png', '0', '0', '2015-09-18 14:15:34', '2015-09-18 17:17:44', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('5', 'Understanding IELTS: Techniques for English Language Tests', '这门课程不仅适合考虑参加英语语言考试的学习者，也适合正在学习英语的学习者。本课程专注于雅思考试。雅思是全球最普及的为出国学习或者生活做准备的语言考试。全世界有9000个包括大学，公司，移民机构，职业机构等组织承认雅思考试。去年全球雅思考试数量超过了2百万。这门关于雅思的课程将引导你进入每一个雅思考试阶段：从阅读，写作，口语到听力。每阶段我们的老师和经验丰富的雅思辅导者都会提供考试指导。本课程开始时间为9月21日。\r\n', '/upload/article/1/1442557011444.png', '0', '0', '2015-09-18 14:18:24', '2015-09-18 18:00:13', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('6', '社会和经济网络：模型和分析 ', '社会网络渗透于我们社会和经济生活的每一个角落。他们在传递就业机会信息中发挥了核心作用，对很多商品和服务的贸易也至关重要。他们在决定我们购买的何种产品、我们讲述何种语言、我们如何投票、我们是否决定犯罪、我们受到多少教育、我们获得专业成功的可能性。网络结构通过无数方式影响我们的生活，因此，理解下述问题就显得至关重要：社会网络结构如何影响行为，何种网络结构更容易在社会中出现，为何我们时常组织起来。借鉴社会学家、经济学家、计算机科学家、物理学家和数学家的研究成果，本门课程提供了社会和经济网络的一个概述和综合性研究。', '/upload/article/1/1442557261924.png', '0', '0', '2015-09-18 14:22:16', '2015-09-18 18:00:21', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('7', 'Internet History, Technology, and Security', '科技和网络给我们生活、文化、社会带来的影响不断增强。最有利的证明就是你可以在世界各地上这门课，你需要的是过去的六十个年头依赖被设计、创造的科技工具，我们应理解网络科技是怎么运作的。这门课在互联网上公开，向你展示它是如何创造，谁创造的，以及它怎样运作。展示的过程中，我们将带领你采访开发互联网和网络技术的领军人物。\r\n', '/upload/article/1/1442557424762.png', '0', '0', '2015-09-18 14:24:18', '2015-09-18 17:59:40', '0', '48', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('8', '婴儿令人惊奇的逻辑思维', '这个课程的目标是帮助你培养一种有价值的思维能力—— 一种我们祖先在这3000年来慢慢培养出来的强大的思维方式。数学思维和做数学题不一样——至少和学校里学的数学不一样。在学校里，学数学主要是学习如何解决一些来自日常生活，科学，或者数学本身的有固定模式的题目。在学校数学中成功的关键是学会用固定的方法思考。与之相反，数学思维的关键之一是创造性思维——现代社会中一个很重要的能力。这个课程帮助学生养成这种重要的思维习惯。课程的主要对象是想以数学或者需要数学的学科为专业的大学一年级学生，和想学这些专业的高中三年级学生（对于美国来说是高中四年级）。这些人需要数学思维来成功的学好他们的专业。但是，数学思维也是一个很有价值的生活技能，任何17岁以上的人都可以从本课程中获益。', '/upload/article/1/1442557545286.png', '0', '0', '2015-09-18 14:26:56', '2015-09-18 15:17:09', '0', '49', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('9', '前所未见，野性自然', '这门课程不仅适合考虑参加英语语言考试的学习者，也适合正在学习英语的学习者。本课程专注于雅思考试。雅思是全球最普及的为出国学习或者生活做准备的语言考试。全世界有9000个包括大学，公司，移民机构，职业机构等组织承认雅思考试。去年全球雅思考试数量超过了2百万。这门关于雅思的课程将引导你进入每一个雅思考试阶段：从阅读，写作，口语到听力。每阶段我们的老师和经验丰富的雅思辅导者都会提供考试指导。本课程开始时间为9月21日。', '/upload/article/1/1442557671339.png', '0', '0', '2015-09-18 14:29:10', '2015-09-18 15:17:02', '0', '49', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('10', '宇宙的设计', '这门课程介绍了起源于硅谷并在全世界出现的高科技企业的基础知识。你将会学习高科技企业家建立公司的过程。内容包括产生创意，寻找商业机会，收集人才资金资源，研究如何推销及策划创意及控制公司快速发展。在学习过程中学生组织成小组并以小组为单位研究创业项目。\r\n这是第二次公开授课，上次有来自全世界的大约40000名学生参与了课程并进行了小组合作。表现优异的小组将会配备硅谷的导师，最好的小组的创意将会被推荐给投资者。上次课程的许多学生都建立了自己的创业公司并被定期指导。', '/upload/article/1/1442557772177.png', '0', '0', '2015-09-18 14:30:09', '2015-09-18 15:16:56', '0', '49', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('11', '水处理工程', '环境工程、市政工程等专业的主干专业课，主要讲述水和废水处理中主要的物化和生物处理方法的基本原理、工艺构成、运行特点、工艺计算方法以及部分工程实例。该课程是从事水处理技术研究、设计以及运行管理人员的必修课。', '/upload/article/1/1442557870059.png', '0', '0', '2015-09-18 14:31:38', '2015-09-18 15:16:45', '0', '49', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('12', '科研不易，研究生新生的11门必修课！ ', '要成为一名出色的科研工作者，你需要从研究生阶段开始培养自己的科研能力和交流能力——两者缺一不可。前者让你能够确定有价值的问题，制定严谨可行的实验计划；后者使你能够把研究成果有效地介绍给其他学者与大众，激发进一步的讨论。此外，高效时间管理与健康的身体也十分重要。MOOC学院与多伦多大学生理学博士@梧桐清声 选出11门课程，让你的科研之路更加顺利！', '/upload/article/1/1442557954327.png', '0', '0', '2015-09-18 14:33:13', '2015-09-18 15:16:38', '0', '37', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('13', '再思考：如何推理与举证', '推理是非常重要的。这门课程将教会你如何正确推理。你将会学到如何理解并评断他人的论据，以及如何基于感兴趣的话题构造自己的论据。\r\n', '/upload/article/1/1442558049812.jpg', '0', '0', '2015-09-18 14:35:41', '2015-09-18 14:35:41', '0', '37', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('14', '如何开始创业 How to Start a Startup', '通过本课程，免费跟随世界级专家那里学习如何开始创业。\r\nCS183B是斯坦福大学的一门课，这是专门为想创业的人设计的一门独立的商业课程，一共有20个课程视频，有的是由一个讲师讲授，有的是两个讲师，还有的是一个小组，所有课程视频总长为1000分钟。\r\n', '/upload/article/1/1442558186693.jpg', '0', '0', '2015-09-18 14:38:08', '2015-09-18 15:16:49', '0', '37', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('15', '数学之旅', '数学的重要特征是它的抽象性，这一特征是令人生畏的。但也正是这一特征可以使人们在繁杂的世界中逐步懂得宇宙深处伟大设计图的语言；可以用理性的思维达到超出人类感官所及的宇宙的根本。而这一切正是数学的魅力所在，也是数学在人类历史上起着其它科学不可替代作用的重要原因。但这也是很多学生畏惧数学或学习数学的困难所在。', '/upload/article/1/1442558351296.jpg', '0', '0', '2015-09-18 14:40:04', '2015-09-18 15:16:26', '0', '37', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('16', 'mooc幻灯一', '对于一个空间来说，设计的生命力不仅体现在当下，更孕育着未来的成长。 筑邦臣把建筑设计看作是体现人类精神的一面镜子。 一个好的设', '/upload/article/1/1442558436452.jpg', '0', '0', '2015-09-18 14:40:53', '2016-04-23 22:55:38', '0', '50', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('17', 'mooch幻灯2', '', '/upload/article/1/1442558480746.jpg', '0', '0', '2015-09-18 14:41:23', '2015-09-18 14:41:23', '0', '51', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('18', '首页幻灯', '', '/upload/article/1/1442558658877.jpg', '0', '0', '2015-09-18 14:43:17', '2015-09-18 14:44:20', '0', '15', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('19', '天体生物学和寻找外星生命', '两千年多以前，古希腊人曾探究过宇宙中是否存在其他世界。现在，人们正通过实验来验证这个问题。这门课程由英国爱丁堡大学的天体生物学中心提供，旨在介绍天体生物学，也是MOOC首次探索此类课题。这门课程将探讨地球上生物的起源和演化，以及地球以外存在生命的可能性。\r\n“天体生物学”解答了人们普遍感兴', '/upload/article/1/1442558964440.jpg', '0', '0', '2015-09-18 14:50:16', '2015-09-18 15:16:19', '0', '22', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('20', '文物精品与文化中国', '中国考古学是以往100年中发展最为迅速的领域之一，大批珍贵文物的出土，不断刷新人们对文化中国的认识。本课程以4-6件（组）精品文物作引子，将学术界探索中华文明的过程作为线索，介绍古代中国在造船、玉器等诸多领域的杰出成就，其中不乏学术前沿的考古发现与研究成果，内容精彩纷呈，雅俗共赏，学生可以藉此获得对文化中国全方位的、直观而深入的认识。', '/upload/article/1/1442559055570.jpg', '0', '0', '2015-09-18 14:51:29', '2015-09-18 15:16:07', '0', '22', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('21', '中国建筑史', '', '/upload/article/1/1442559113247.png', '0', '0', '2015-09-18 14:52:39', '2015-09-18 15:16:01', '0', '22', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('22', '新媒体概论', '本课程主要探讨新媒体与社会之间的互动关系，一方面关注各种社会力量对新媒体的塑造，另一方面讨论新媒体对社会各个层面的影响。课程在探讨新媒体的概念、特征、形式、内容和历史的基础上，同时关注新媒体的采纳、扩散、伦理和法制，以及新媒体在政治、经济、文化和社会结构上对社会的影响。本课程有助于学生掌握新媒体的相关概念和理论，理解新媒体在社会控制和社会变迁中的重要角色，成为新媒体时代具有批判能力和责任意识的现代公民。', '/upload/article/1/1442559199247.jpg', '0', '0', '2015-09-18 14:53:47', '2015-09-18 15:15:55', '0', '22', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('23', '合作代理', '​门槛最低，功能最全最灵活，利润最大，支撑最大！\r\n支撑优势\r\n甩单支撑产品培训销售培训迟训升级\r\n远程咨询地区保护落地支撑奖金激励', '', '0', '0', '2015-09-18 16:30:54', '2015-09-18 16:37:14', '0', '18', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('24', '关于我们', '  公司于2012年3月8日，已正式向《景德镇市工商行政管理局》领取营业   执照。\r\n  公司名称：景德镇铭飞科技有限公司\r\n  经营范围：计算机系统服务及技术开发、咨询服务', '', '0', '0', '2015-09-18 16:31:18', '2016-06-02 11:07:36', '0', '19', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('32', '为远行的人', '', '', '0', '0', '2016-03-16 17:26:37', '2016-05-19 17:50:56', '0', '146', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('33', '一生学做人', '', '', '0', '0', '2016-03-16 17:27:31', '2016-06-02 11:35:20', '0', '146', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('34', '何处惹尘埃', '', '', '0', '0', '2016-03-16 17:29:06', '2016-05-19 17:50:31', '0', '146', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('35', '雨夜，晚归人', '', '', '0', '0', '2016-03-16 17:31:11', '2016-05-19 17:50:10', '0', '146', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('36', '网站建设', '网站设计 网站制作 网站维护 网站改版', '/upload/article/1638/1464868285592.png', '0', '0', '2016-03-16 17:41:27', '2016-06-02 19:51:27', '0', '53', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('37', '人才招聘', '企业内部的竞聘、晋升机制，为员工提供了公平竞争的机会。通过挖掘企业内部的人才，调动内部人员的潜力和积极性，促进了优秀人才脱颖而出，实现人力资源的合理配置，把\"合适的人放在合适的地方\"。', '', '0', '0', '2016-03-16 17:48:38', '2016-06-04 11:08:08', '0', '146', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('38', '你缺的是朋友，而不是朋友圈', '', '', '0', '0', '2016-03-16 17:51:57', '2016-03-17 20:45:05', '0', '55', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('39', '今年初夏，曲终人散', '', '', '0', '0', '2016-03-16 17:53:50', '2016-03-17 20:45:10', '0', '55', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('40', '毕业六月，高三回首', '', '', '0', '0', '2016-03-16 17:54:57', '2016-03-17 20:44:44', '0', '55', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('41', '十七岁的天空', '', '', '0', '0', '2016-03-16 17:56:34', '2016-03-18 15:54:55', '0', '55', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('42', '尘世中的觉悟', 'MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。', '', '0', '0', '2016-03-16 17:57:48', '2016-06-02 18:14:03', '0', '55', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('43', '微创®集团与北京唯迈医疗设备有限公司举行战略合作签约仪式', '', '', '0', '0', '2016-03-21 19:29:17', '2016-03-24 09:42:41', '0', '57', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('44', '微创®电生理亮相第十三届国际死海研讨会（IDSS 2016）', '', '', '0', '0', '2016-03-21 19:48:57', '2016-03-24 09:24:29', '0', '57', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('45', '123', '', '', '0', '0', '2016-03-24 10:01:27', '2016-03-24 10:25:55', '0', '57', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('46', 'jQuery 插件：用于移动项目的响应式音频播放器', '　你是否想要一个响应和触摸友好的音频播放器？Osvaldas Valutis 已经为大家创建了一个取代<audio>元素的 jQuery 插件。通过添加一些 CSS，你就能得到一个全新的音乐播放器。', '/upload/article/1638/1464837851597.png', '0', '0', '2016-03-25 15:24:16', '2016-06-02 15:17:17', '0', '58', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('47', '13个风格独特的关于页面（About Pages）设计', '如何向其他人呈现你自己和你的作品呢？关于页面的设计是非常重要的，以让你的观众更多地了解你，你的工作和你的想法。这是一个很好的方式来获得更加个性化的展示效果。', '/upload/article/1638/1464837810547.png', '0', '0', '2016-03-25 15:53:05', '2016-06-02 15:17:10', '0', '58', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('48', '前端视界：2012年度最独特的网页设计作品展示《上篇》', '2012年对于网页设计领域来说是非常有趣的一年，响应式设计的流行孕育了辉煌的重新设计：巧妙的布局、清晰的排版和强烈的色彩对比。', '/upload/article/1638/1464837745446.png', '0', '0', '2016-03-25 15:54:39', '2016-06-02 15:17:04', '0', '58', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('49', '16个销售单个商品的电子商务网站设计示例', '　有些公司不希望成为一个在线零售商，他们只是想推销自己的发明（通常只有一个单一的产品，拥有不同颜色）。因此，这篇文章挑选了16个单品电子商务设计，你可以从中借鉴和获得启示。', '/upload/article/1638/1464837718472.png', '0', '0', '2016-03-25 15:55:46', '2016-06-02 15:16:59', '0', '58', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('50', '在任何设备上都完美呈现的30个华丽的响应式网站', '一个网站只在桌面屏幕上好看是远远不够的，同时也要在平板电脑和智能手机中能够良好呈现。响应式的网站是指它能够适应客户端的屏幕尺寸，自动响应客户端尺寸变化。在这篇文章中，我将向您展示在任何设备上都完美的30个华丽的响应式网站。', '/upload/article/1638/1464837695859.png', '0', '0', '2016-03-25 15:56:38', '2016-06-02 18:22:46', '0', '58', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('52', '响应式Web设计的9项基本原则', '响应式web设计对于解决多类型屏幕问题来说是个', '/upload/article/1/1458980355125.png', '0', '0', '2016-03-26 14:43:40', '2016-06-02 15:00:26', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('53', '导航设计模式的重要意义', 'Gmai 就 是单页应用的一个很好的例子，其将多项', '/upload/article/1/1458981328236.jpeg', '0', '0', '2016-03-26 14:49:14', '2016-06-02 15:00:32', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('54', '如何进行可用性启发式评估', '用 户体验只有在渗透入从创意到开发测试等产品', '/upload/article/1/1458981122379.png', '0', '0', '2016-03-26 15:47:29', '2016-06-02 15:00:59', '0', '67', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('55', '响应式Web设计的9项基本原则', '想象一下走进一个狭小拥挤，遍地垃圾的商店。店', '/upload/article/1/1458981072779.jpg', '0', '0', '2016-03-26 15:50:20', '2016-06-02 15:00:54', '0', '67', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('56', '原生App切图的那些事儿', '最小的分辨率是320x480，我们把这个尺寸定为基', '/upload/article/1/1458981027610.png', '1', '0', '2016-03-26 15:51:39', '2016-06-02 15:00:48', '0', '66', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('57', '11个小妙招激发你的灵感', '感到自己深陷千篇一律的设计泥潭无法自拔？ Sty', '/upload/article/1/1458980990018.jpeg', '1', '0', '2016-03-26 15:52:27', '2016-06-02 15:00:37', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('58', '5项提高产品设计的交互模式', '在这个简短的移动端设计模式系列文章的前几篇中', '/upload/article/1/1458980956132.jpeg', '1', '0', '2016-03-26 15:53:20', '2016-06-02 15:00:43', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('59', '在网页设计中运用柔和色调', '网页中的柔和色调的使用，不止是近来的趋势，这', '/upload/article/1/1458980935362.jpg', '1', '0', '2016-03-26 15:54:17', '2016-06-02 15:00:19', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('60', '细数那些精彩纷呈的引导页', '随着苹果ios8的发布，可以看到App store货架上', '/upload/article/1/1458980789639.png', '0', '0', '2016-03-26 16:07:08', '2016-06-02 15:00:09', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('61', '从摄影的角度看设计', '一幅好照片要把观众的注意力吸引到趣味中心mdas', '/upload/article/1/1458980625909.jpg', '1', '0', '2016-03-26 16:07:55', '2016-06-02 14:59:55', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('62', '国内java开源商城系统', 'MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。', '/upload/article/1/1458980449738.jpeg', '1', '0', '2016-03-26 16:08:53', '2016-06-02 14:59:46', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('63', '国内java开源 cms系统', 'MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。', '/upload/article/1/1458980395756.jpg', '1', '0', '2016-03-26 16:09:27', '2016-06-02 14:59:39', '0', '65', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('70', '2015年 铭飞MCms获得最热门开源项目第40位', '自 Git@OSC 上线以来受到广大开源作者的喜爱。值此新年之际，开源中国整理出 Git@OSC 最热门开源项目 Top50，对 Git@OSC 的发展至今所取得的成绩进行总结。此榜单主要通过开源项目的 Watch、Star、Fork 数量来评定', '/upload/article/1/1461384072200.jpeg', '1', '0', '2016-03-27 09:34:58', '2016-06-02 19:38:12', '0', '69', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('71', '国内java开源 cms系统', 'MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。', '/upload/article/1638/1464847653084.jpeg', '0', '0', '2016-03-27 09:36:45', '2016-06-03 19:48:52', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('72', '2016年CMS开源系统排行榜', 'CMS（Content Management System),中文叫作整站系统、文章系统。\r\n大概2004以前，如果想进行网站内容管理,基本上都是靠手工维护,但千变万化的信息流，但没有好的程序支持，还继续靠手工完成是不可能的事。', '/upload/article/1/1461384142045.png', '0', '0', '2016-03-27 09:37:07', '2016-06-03 19:49:00', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('73', '国内java开源商城系统', 'MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。', '/upload/article/1/1461384035654.png', '2', '0', '2016-03-27 09:37:46', '2016-06-03 19:49:09', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('74', '国内java开源bbs系统', '当前版本:5.4.2 铭飞MS官网:http://ms.mingsoft.net官网同时提供一键运行版本下载，请步移官网....', '/upload/article/1/1461383961935.png', '1', '0', '2016-03-27 09:38:15', '2016-06-02 19:24:56', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('75', '公司简介', '织梦猫成立于2000年', '', '0', '0', '2016-03-27 17:11:30', '2016-04-01 16:48:16', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('76', ' 发展历程', '2001年织梦猫会员数突破10000人', '', '0', '0', '2016-03-27 17:12:07', '2016-03-27 17:30:28', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('77', '企业荣誉', '2002年织梦猫官网进行了一次大的改版', '', '0', '0', '2016-03-27 17:12:40', '2016-03-27 17:30:15', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('78', '人才招聘', ' 2004年织梦猫全新改版，更关注模板的质量', '', '0', '0', '2016-03-27 17:13:10', '2016-03-27 17:30:03', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('79', '团队介绍', ' 2004年织梦猫已经成为模板行业第一分享平台', '', '0', '0', '2016-03-27 17:13:39', '2016-03-27 17:29:53', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('80', '服务理念', '2005年织梦猫开通网站建设在线培训视频课程', '', '0', '0', '2016-03-27 17:14:13', '2016-03-27 17:29:44', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('81', '网站记事', '我们一直在努力，期待得到大家的支持', '', '0', '0', '2016-03-27 17:14:40', '2016-03-27 17:29:35', '0', '71', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('82', '织梦猫', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源<br/>\r\n我们致力于打造一个优秀的建站资源共享学习平台！', '/upload/article/1/1459088574961.png', '0', '0', '2016-03-27 22:24:37', '2016-03-27 22:29:06', '0', '73', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('83', '织梦猫', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源<br>\r\n我们致力于打造一个优秀的建站资源共享学习平台！', '/upload/article/1/1459089146043.png', '0', '0', '2016-03-27 22:30:55', '2016-03-27 22:40:01', '0', '74', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('84', '织梦猫', '', '/upload/article/1/1459090301841.png', '0', '0', '2016-03-27 22:53:13', '2016-03-27 22:53:13', '0', '75', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('85', 'y', '', '/upload/article/1/1459090489984.png', '0', '0', '2016-03-27 22:54:54', '2016-03-27 23:02:20', '0', '77', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('86', 'x', '', '/upload/article/1/1459090720102.png', '0', '0', '2016-03-27 22:58:45', '2016-03-27 22:58:45', '0', '76', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('87', 'a', '', '/upload/article/1/1459091303582.jpg', '0', '0', '2016-03-27 23:08:35', '2016-03-27 23:08:35', '0', '78', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('88', 'b', '', '/upload/article/1/1459091351194.png', '0', '0', '2016-03-27 23:09:16', '2016-03-27 23:09:16', '0', '78', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('89', 'c', '', '/upload/article/1/1459091372645.png', '0', '0', '2016-03-27 23:09:41', '2016-03-27 23:10:14', '0', '78', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('90', 'd', '', '/upload/article/1/1459091423244.png', '0', '0', '2016-03-27 23:10:33', '2016-03-27 23:41:15', '0', '78', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('91', '织梦猫官网', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源<br>\r\n							我们致力于打造一个优秀的建站资源共享学习平台！ ', '/upload/article/1/1459091831861.png', '0', '0', '2016-03-27 23:18:27', '2016-03-30 23:42:03', '0', '79', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('92', '建站资源共享学习平台', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！从零开始系统全面的教你如何建立一个属于自己的网站。能够自己搭建一个网站，并通过优化推广实现盈利。0基础由浅入深的带您走进的世界。掌握程序的操作和使用，能独立开发模板并能运用进行仿站。专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:39:44', '2016-06-02 10:07:19', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('93', '从零开始系统全面的教你如何建立一个属于自己的网站', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！从零开始系统全面的教你如何建立一个属于自己的网站。能够自己搭建一个网站，并通过优化推广实现盈利。0基础由浅入深的带您走进的世界。掌握程序的操作和使用，能独立开发模板并能运用进行仿站。专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:40:18', '2016-06-02 10:06:14', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('94', '0基础由浅入深的带您走进的世界', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！从零开始系统全面的教你如何建立一个属于自己的网站。能够自己搭建一个网站，并通过优化推广实现盈利。0基础由浅入深的带您走进的世界。掌握程序的操作和使用，能独立开发模板并能运用进行仿站。专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:41:12', '2016-06-02 10:06:32', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('95', '网站模板', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:54:59', '2016-06-02 10:07:56', '0', '84', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('96', '建站培训', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:55:22', '2016-06-02 10:07:51', '0', '84', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('97', '模板', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:55:43', '2016-06-02 10:07:46', '0', '84', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('98', '视频课程', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。', '', '0', '0', '2016-03-28 16:56:27', '2016-06-02 10:07:40', '0', '84', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('99', '网站模板', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '', '0', '0', '2016-03-28 17:07:28', '2016-06-02 10:09:29', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('100', '模板 ', '0基础由浅入深的带您走进的世界。掌握程序的操作和使用，能独立开发模板并能运用进行仿站。', '', '0', '0', '2016-03-28 17:09:59', '2016-06-02 11:34:02', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('101', '模板', '0基础由浅入深的带您走进的世界。掌握织梦程序的操作和使用，能独立开发模板并能运用进行仿站', '', '0', '0', '2016-03-28 17:15:02', '2016-06-02 10:09:11', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('102', '网页模板', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '', '0', '0', '2016-03-28 17:15:32', '2016-06-02 10:08:52', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('103', '视屏', '0基础由浅入深的带您走进的世界。掌握程序的操作和使用，能独立开发模板并能运用进行仿站', '', '0', '0', '2016-03-28 17:16:28', '2016-06-02 11:33:42', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('104', '在线课程', '从零开始系统全面的教你如何建立一个属于自己的网站。能够自己搭建一个网站，并通过优化推广实现盈利。', '', '0', '0', '2016-03-28 17:16:58', '2016-06-02 10:08:21', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('105', '网站素材', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '', '0', '0', '2016-03-28 17:17:21', '2016-06-02 10:08:16', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('106', '建站培训', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '', '0', '0', '2016-03-28 17:17:39', '2016-06-02 10:08:09', '0', '85', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('109', '网站模板', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '/upload/article/1/1459255444040.png', '0', '0', '2016-03-29 20:44:20', '2016-06-02 10:09:59', '0', '86', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('110', '建站培训', '从零开始系统全面的教你如何建立一个属于自己的网站。通过学习之后能够自己搭建一个网站，并能制作各种建站程序模板，通 过优化推广实现盈利', '/upload/article/1/1459255475246.png', '0', '0', '2016-03-29 20:44:54', '2016-06-02 10:09:46', '0', '86', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('111', '模板开发', '提供视频课程，视频课程，div+css视频课程等各类系统全面的网站建设视频课程。 并提供在线培训，技术支持。让网站建设变的简单', '/upload/article/1/1459255509265.png', '0', '0', '2016-03-29 20:45:27', '2016-06-02 11:34:16', '0', '86', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('112', '新科科技', '在网上寻觅了很久很久。终于找到了这里。晃眼一看，好多漂亮的模板。下载了几个都很好用。希望越做越好，多提供些精品资源！找了好久啊，一直想有一个这样的网站，找来找去，老感觉么有合适的。偶然间来到这儿，爽。找到啦！对于网站建设新手来说，是一个最好的平台，你可以随心找到你最喜欢的网站模板，做出你喜欢的网站。\r\n专业提供网站模板，网页模板，模板教程，网页制作，程序插件，网站素材等建站资源，我们致为于打造优秀的建站资源共享平台！ ', '/upload/article/1/1459305011132.png', '0', '0', '2016-03-30 10:28:39', '2016-06-02 15:19:51', '0', '87', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('113', '联娱公司', '找模板找了很久了，于是找到了，觉的这里的模板很不错，下载了两套试试，果然可以用。于是充值了，希望站长以后多多指点啊！站长很友好，为我们这些新手站长提供这么多的模版。大家一起交流，才能成长得更快吧！感谢，感谢网友，你们辛苦了！对于网站建设新手来说，是一个最好的平台，你可以随心找到你最喜欢的网站模板，做出你喜欢的网站。专业提供网站模板，网页模板，模板教程，网页制作，程序插件，网站素材等建站资源，我们致为于打造优秀的建站资源共享平台！ ', '/upload/article/1/1459305021450.png', '0', '0', '2016-03-30 10:29:13', '2016-06-02 15:19:14', '0', '87', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('114', '冷血', '织梦猫专业提供网站模板，网页模板，模板教程，网页制作，程序插件等建站资源，我们致为于打造优秀的建站资源共享平台！', '/upload/article/1/1459306038107.png', '0', '0', '2016-03-30 10:47:55', '2016-04-01 14:05:59', '0', '88', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('115', '神鹰', '织梦猫专业提供网站模板，网页模板，模板教程，网页制作，程序插件等建站资源，我们致为于打造优秀的建站资源共享平台！', '/upload/article/1/1459306097721.png', '0', '0', '2016-03-30 10:48:38', '2016-03-30 11:03:06', '0', '88', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('116', '轻舞风扬', '织梦猫专业提供网站模板，网页模板，网站源码，网站素材，网页特效等网页设计素材免费下载。我们致力于打造一个优秀的建站资源共享学习平台。', '/upload/article/1/1459306211354.png', '0', '0', '2016-03-30 10:49:31', '2016-03-30 21:14:42', '0', '88', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('117', 'Anya Siennadia', '织梦猫专业提供网站模板，网页模板，网站源码，网站素材，网页特效等网页设计素材免费下载。我们致力于打造一个优秀的建站资源共享学习平台。', '/upload/article/1/1459306184095.png', '0', '0', '2016-03-30 10:50:04', '2016-03-30 11:22:55', '0', '88', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('118', '模板开发', '织梦猫专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源', '', '0', '0', '2016-03-30 12:37:47', '2016-03-30 21:02:27', '0', '89', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('119', '程序开发', '织梦猫专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源', '', '0', '0', '2016-03-30 12:38:38', '2016-03-30 21:02:46', '0', '89', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('120', '培训课程', '织梦猫专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源', '', '0', '0', '2016-03-30 12:38:59', '2016-04-05 16:03:44', '0', '89', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('121', '视频课程', '织梦猫专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源', '', '0', '0', '2016-03-30 12:39:22', '2016-03-30 21:02:02', '0', '89', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('122', '意见交流', '', '', '0', '0', '2016-03-30 13:04:46', '2016-03-30 22:53:19', '0', '90', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('123', '支付定金', '', '', '0', '0', '2016-03-30 13:05:11', '2016-03-30 22:53:56', '0', '90', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('124', '开始制作', '', '', '0', '0', '2016-03-30 13:05:27', '2016-03-30 22:54:21', '0', '90', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('125', '开通演示', '', '', '0', '0', '2016-03-30 13:06:17', '2016-03-30 22:54:45', '0', '90', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('126', '支付尾款', '', '', '0', '0', '2016-03-30 13:06:41', '2016-03-30 22:55:13', '0', '90', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('127', '我们的承诺', '制作周期20-30个工作日div+css布局\r\n						响应式设计\r\n						扁平化设计 \r\n						100%原创开发\r\n						后期技术支持维护', '', '0', '0', '2016-03-30 13:12:16', '2016-06-02 10:10:47', '0', '91', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('128', '客户须知', '制作周期20-30个工作日提供公司相关资料 \r\n							积极配合设计师 \r\n							不随意更改制作方案 \r\n							如因客户原因不退还定金\r\n							相关数据录入 ', '', '0', '0', '2016-03-30 13:15:10', '2016-06-02 10:11:18', '0', '92', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('130', '关于我们', '广州城市规划设计有限公司是中欧国际旅游规划设计研究院（Sino-Europe Academy of Tourism Planning and Design）旗下之专业机构，公司专注于城市规...', '/upload/article/1/1460376794567.jpg', '0', '0', '2016-04-11 20:02:32', '2016-06-02 11:27:17', '0', '93', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('131', '主营业务', '互联网时代正在颠覆旅游业传统的商业模式。CEDAR积极应对这种变革，依托中欧国际旅游规划设计研究院（SEATPD）的资源优势，推动文化、地产与旅游业的横向联合发展，以此延伸到移动互联、绿色农业、金融资本、现代物流业等产业领域。', '/upload/article/1638/1464838231122.jpg', '0', '5', '2016-04-11 20:20:42', '2016-06-03 14:29:55', '0', '94', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('132', '合作伙伴', '让设计充满新奇和创造力，同时也饱含着和谐、力量与深意。\r\n\"适度\" 是一种幸福的生活态度。\r\n设计哲学 \"合适的设计\"，设计中最难的环节往往并非创新，而是在精确适配下的创造。\r\n打造令人灵感迸发及纵情享受的情绪空间。\r\n', '/upload/article/1638/1464838215050.jpg', '0', '0', '2016-04-11 20:21:45', '2016-06-02 17:38:19', '0', '95', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('133', '合作伙伴', '某某，中国知名室内设计师，2005年于北京创立筑邦臣设计公司，他擅长用东方哲学思考解决问题，关注各类空间形态对人的影响，同时注重设计的商业化表现。张海涛说：“希望在设计中融入丰富的文化表达，以打造可以令人思考的空间意境。”他一直坚信，中国拥有丰富的文化底蕴，在未来“中国设计”将充满无限可能！', '/upload/article/1569/1461506188829.jpg', '0', '0', '2016-04-11 20:23:48', '2016-06-02 17:59:19', '0', '97', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('134', '亚太旅游规划设计十大影响力品牌', '2009年12月13日由中国民族建筑研究会与中国 房地产 及住宅研究会共同主办，2009第六届中国人居典范建筑规划设计方案竞赛颁奖大会在北京京都信苑饭店隆重召开。经过九个多月来的精...', '/upload/article/1/1460377619458.jpg', '0', '0', '2016-04-11 20:27:43', '2016-04-12 19:56:40', '0', '96', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('135', '2009中国人居典范●最佳设计方案', '2009年12月13日由中国民族建筑研究会与中国 房地产 及住宅研究会共同主办，2009第六届中国人居典范建筑规划...', '/upload/article/1/1460377712056.png', '0', '0', '2016-04-11 20:28:48', '2016-06-02 14:16:45', '0', '96', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('136', '定制化项目金融孵化模式', '广州规划设计以金融资本为支撑，以规划设计为撬动点，协助旅游业开发高潜力项目，推动项目融资..', '/upload/article/1585/1462265098563.jpg', '0', '0', '2016-04-11 20:30:32', '2016-05-03 16:45:00', '0', '98', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('137', '幻灯一', '', '/upload/article/1638/1465808003859.jpg', '0', '0', '2016-04-11 20:59:07', '2016-06-13 16:53:24', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('138', '幻灯二', '', '/upload/article/1638/1465808020382.jpg', '0', '0', '2016-04-11 20:59:25', '2016-06-13 16:53:40', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('139', '幻灯三', '', '/upload/article/1638/1465808030831.jpg', '0', '0', '2016-04-11 21:00:16', '2016-06-13 16:53:51', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('140', '幻灯四', '', '/upload/article/1638/1464858626484.jpg', '0', '0', '2016-04-11 21:00:35', '2016-06-02 17:25:01', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('141', '城市规划', '城市商业综合体规划 -新城（新区）规划 -温城市更新与旧城改造 -小城镇建设规划 -历史文化名城/镇保护研究与规划 -产业园区规划...', '/upload/article/1/1460380106006.jpg', '0', '0', '2016-04-11 21:09:07', '2016-06-03 15:32:34', '0', '101', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('142', '环境艺术设计', 'CEDAR以美学与生态的双重视野开展环境艺术的探索与实践，营造健康、高雅、舒适、美观的现代生态环境，以此提升城市及旅游景区的软环境。...', '/upload/article/1/1460380199624.jpg', '0', '0', '2016-04-11 21:10:38', '2016-06-02 17:57:25', '0', '102', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('143', '旅游形象策划', '在把握好旅游地的地脉（地理根据）、文脉（文化根据）和商脉（市场根据）的基础上，为旅游地做好旅游形象定位，并开展理念基础（MI）、行为准则（BI）、视觉形象（VI）的系统策...', '/upload/article/1/1460380287863.jpg', '0', '0', '2016-04-11 21:11:33', '2016-06-02 17:57:30', '0', '103', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('144', '旅游企业管理', '目的地与景区管理： -发展战略规划 -营销管理体系咨询 -品牌管理体系咨询 -组织架构与流程再造 -投资运营与管理 -资源与环境保护 酒店管理： -酒店运营管理 -酒店物业管理 -酒店产品...', '/upload/article/1/1460380343199.jpg', '0', '0', '2016-04-11 21:12:42', '2016-06-02 17:57:33', '0', '104', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('145', '融资服务', '为旅游企业引进投资机构，代理或协助开展融资商务谈判，推动融资项目签约。...', '/upload/article/1/1460380402370.jpg', '0', '0', '2016-04-11 21:13:34', '2016-06-02 17:58:20', '0', '105', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('146', '广东梅州市雁洋旅游服务区域城市规划', '项目地址：广东梅州市雁洋镇\r\n规划面积：1，281，863平方米\r\n项目委托：广东梅州市人民政府', '/upload/article/1/1460380700438.png', '0', '0', '2016-04-11 21:18:54', '2016-06-02 15:06:21', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('147', '海口湾酒店公寓第二期建筑设计', '项目地址：海南省海口市北部海口湾西部滨海地区\r\n总用地面积：47957.1平方米\r\n总建筑面积：116154.65平方米\r\n总地上建筑面积：94523.55平方米', '/upload/article/1/1460380774867.png', '0', '0', '2016-04-11 21:20:05', '2016-06-02 15:15:07', '0', '108', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('148', '昆山水月周庄旅游地产概念营销策划', '周庄拥有丰富的自然资源、人文资源及极具优势的地理位置，区域发展潜力巨大，古镇旅游品牌价值大，区域发展热点已经形成，旅游经济的发展为房地产市场提供了巨大的想象空间。', '/upload/article/1/1460380829450.jpg', '0', '0', '2016-04-11 21:21:01', '2016-06-02 15:06:16', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('149', '京杭大运河旅游形象研究与策划', '项目地址：浙江杭州、苏州\r\n项目委托：杭州市旅游局、苏州市旅游局\r\n \r\n运河文化，吴地风情', '/upload/article/1/1460380900751.png', '0', '0', '2016-04-11 21:22:08', '2016-06-02 15:14:43', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('150', '佛山某师军史馆设计', '', '/upload/article/1/1460380995728.jpg', '0', '0', '2016-04-11 21:23:19', '2016-06-02 15:14:45', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('151', '刘人岛', '北京师范大学教授、画家、艺术评论家，中国文物学会书画雕塑专业委员会会长，《艺术》杂志社社长。。。。。', '/upload/article/1/1460381163425.jpg', '0', '0', '2016-04-11 21:26:14', '2016-04-12 20:02:40', '0', '113', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('152', '章明', '章明，同济大学建筑与城市规划学院建筑系副主任、教授、博导，国家一级注册建筑师，中欧旅游规划设计研究院研究员、首席建筑设计师。', '/upload/article/1/1460381217943.jpg', '0', '0', '2016-04-11 21:27:03', '2016-04-12 20:02:32', '0', '114', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('153', '彭建军', '', '/upload/article/1/1460381477068.png', '0', '0', '2016-04-11 21:31:18', '2016-04-12 20:03:04', '0', '116', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('154', '刘人岛', '', '/upload/article/1/1460381500111.jpg', '0', '0', '2016-04-11 21:31:41', '2016-04-12 20:02:58', '0', '116', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('155', '民盟湖南省委办公室主任傅小松参观考察中欧研', '近日，民盟湖南省委办公室主任傅小松来穗，兴致勃勃地参观和考察了中欧旅游规划设计研究院。\r\n', '/upload/article/1/1460381791531.jpg', '0', '0', '2016-04-11 21:36:32', '2016-05-05 14:21:19', '0', '121', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('156', '旅游专列：下一个路口在哪儿', '高性价比的旅游专列\r\n旅游专列，是旅行社委派专业人员制定旅游线路、行程及旅游计划，向铁路主管专列审', '/upload/article/1/1460381891188.jpg', '0', '0', '2016-04-11 21:38:13', '2016-05-05 14:21:28', '0', '123', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('157', '旅游规划', '- 区域旅游发展规划\r\n- 历史文化区旅游开发规划\r\n- 风景名胜区旅游开发规划', '/upload/article/1/1460384875034.jpg', '0', '0', '2016-04-11 22:28:02', '2016-06-02 15:06:02', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('158', '旅游规划', '区域旅游发展规划 -历史文化区旅游开发规划 -风景名胜区旅游开发规划 -生态旅游区开发规划 -温泉滨海度假区旅游开发规划 -旅游地产开发规划 -乡村旅游开发', '/upload/article/1/1460385002423.jpg', '0', '0', '2016-04-11 22:30:21', '2016-06-02 17:58:24', '0', '101', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('159', '中欧研究院专家组深入万佛', '2014年5月22日，为对安徽舒城万佛湖景区中的三江景区开展概念性规划，中欧研究院专家组深入万佛湖地区开展实地考察调研。', '/upload/article/1/1460386331997.png', '0', '0', '2016-04-11 22:52:34', '2016-04-11 22:52:34', '0', '126', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('160', '留住古城镇的原味', '近日，中国十大古城镇联盟在山东淄博周村古商城景区成立，周庄、南浔、周村、阆中、呈坎、平遥、襄阳、同里、西塘、洪江等十大古城镇聚首，针对古建筑保护修复、古城镇管理体...', '/upload/article/1/1460449501050.jpg', '0', '0', '2016-04-12 16:25:19', '2016-05-19 11:17:43', '0', '129', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('161', '公司环境', '', '/upload/article/1/1460469387445.jpg', '0', '0', '2016-04-12 21:56:28', '2016-04-12 21:56:28', '0', '127', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('162', '环境', '', '/upload/article/1/1460469427922.jpg', '0', '0', '2016-04-12 21:57:11', '2016-04-13 23:20:10', '0', '127', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('163', '得品牌者得市场', '精益求精的网页制作人员、严谨的应用程序开发人员、尽善尽美的售后服务人员。这一切，是我们为您提供专业网站建设服务，也是让你在同行业中傲视群 雄', '/upload/article/1638/1464746921150.jpg', '0', '0', '2016-04-15 15:29:42', '2016-06-03 20:16:45', '0', '99', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('164', '海派卓越规划设计智业团队', '广州规划设计麾下聚集了众多从美国旧金山艺术大学、奥本大学、香港理工大学毕业的海派旅游规', '/upload/article/1585/1462265091247.jpg', '0', '0', '2016-04-15 15:39:48', '2016-05-03 16:44:52', '0', '98', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('165', '高质量行业交互平台', '广州规划设计创新构建协同式、交互式、大数据及系统式行业服务平台。。。', '/upload/article/1585/1462265083093.jpg', '0', '0', '2016-04-15 15:40:42', '2016-06-02 17:59:22', '0', '98', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('166', '01品牌创建', '品牌命名/品牌文化/品牌识别设计\r\n最初的品牌播种，决定了品牌是要长成野草还是参天大树。所谓三岁看大，品牌风格确立也要从萌芽开始，让品牌自始至终保持活力与竞争力，健康茁长的成长。\r\n服务项目：\r\n品牌文化理念挖掘 / 挖掘一种品牌文化，并力求这种文化与更多目标消费群相关品牌命名 /\r\n创造符合品牌精神的独特名称 / 品牌视觉识别（VIS）设计 /\r\n基于市场与设计角度创造严谨而实用的形象设计 /', '/upload/article/1/1460771365547.jpg', '0', '0', '2016-04-16 09:49:44', '2016-04-29 17:23:22', '0', '62', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('167', '品牌改造设计', '品牌形象的改造与提升设计\r\n品牌发展到一定的阶段，因为企业发展模式及战略目标发生改变，其原有的形象已经不能承载企业未来发展的战略需求时，则需要创造更具生长气质的视觉形象，为未来打算，为未来改变！品牌改造设计正好填补着类客户的发展需求。\r\n服务项目：\r\n品牌形象改造设计 / 令形象更适合品牌定位，提升 / 完善品牌形象\r\n完善并继承优秀基因,为企业注入新鲜的视觉活力\r\n与客户品牌发展模式及战略目标相匹配', '/upload/article/1/1460771447978.jpg', '0', '0', '2016-04-16 09:51:22', '2016-06-02 19:12:58', '0', '138', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('168', '品牌推广设计', '形象画册 / 产品样本 / 招商手册 / 企业年报\r\n印刷品是企业最常用最有效的推广方式，也是挖掘潜在客户的钥匙。好的设计能循序渐进的引导读者，让读者更清楚的了解产品，从而择需购买。一本设计粗糙的画册，不等被翻开便会被丢弃。\r\n服务项目：\r\n印刷品设计 / 具有企业特色的形象画册设计、产品目录及年报设计.\r\n企业内刊策划设计 / 为大型企业策划设计品牌内部刊物', '/upload/article/1/1460771488365.jpg', '0', '0', '2016-04-16 09:52:35', '2016-06-02 15:18:14', '0', '138', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('169', '联系维视', '', '', '0', '0', '2016-04-16 10:31:35', '2016-04-29 15:48:52', '0', '56', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('170', '广州维视', '', '/upload/article/1569/1461509646954.jpg', '0', '0', '2016-04-16 10:32:33', '2016-04-24 22:54:46', '0', '131', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('171', '英德维视', 'MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。\r\n', '/upload/article/1569/1461507203918.jpg', '0', '0', '2016-04-16 10:32:51', '2016-06-02 11:18:34', '0', '132', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('172', '网络优化', '企业网站建设目的何在？如何充分挖掘互联网络的资源和优势，如何合理地组织网站内容与功能从而达到客户的需求？\r\n我们将根据市场分析、客户产品及服务的优势、竞争对手分析等等，有效的确立网站定位。根据相关需求分析获得相应网站运营策略，在网站建立之初我们就网站VI形象、网站营销手段、运营模式、网站发展前景等等进行定位。', '/upload/article/1/1460889312736.jpg', '0', '0', '2016-04-17 18:37:32', '2016-06-04 09:16:24', '0', '133', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('173', '网络营销', '互联网品牌推广有个新鲜名词叫数字营销，数字营销是新发展起来的一种营销模式，是利用互联网特性和技术，更加有效、高性价比地完成整合营销计划，达到传统 的IMC不能达到的高效客户关系管理等，从而精准地实施营销策略，实现企业营销的高效率、低成本、大影响。可以按两种意思来理解：网络整合营销是利用网络 技术和网络特性最大化、最快速、最有效、最精准的进行整合营销；网络整合营销是以为客户提供有价值的信息为基础，由客户创造、传播为主导的整合营销理念进 行的网络营销。', '/upload/article/1/1460889475526.jpg', '0', '0', '2016-04-17 18:38:12', '2016-06-02 17:15:23', '0', '134', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('174', '域名注册', '上网\"已成为不少人的口头禅。但是，要想在网上建立服务器发布信息，则必须首先注册自己的域名，只有有了自己的域名才能让别人访问到自己。所以，域名注册是在互联网上建立任何服务的基础。同时，由于域名的唯一性，尽早注册又是十分必要的。', '/upload/article/1638/1464868329275.png', '0', '0', '2016-04-17 18:39:43', '2016-06-04 09:16:08', '0', '135', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('177', '国内开源 java cms，铭飞MCms', 'MCMS是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。\r\n\r\nMS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极', '/upload/article/1/1461384090357.jpeg', '1', '0', '2016-04-23 11:51:21', '2016-06-02 19:39:13', '0', '70', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('178', '价值源自分享', 'MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。', '/upload/article/1/1461383921888.jpeg', '1', '0', '2016-04-23 11:52:35', '2016-06-02 19:22:20', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('179', '铭飞商城MStore——价值源自分享', 'MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。\r\n', '/upload/article/1/1461383937683.jpeg', '1', '0', '2016-04-23 11:58:24', '2016-06-02 19:20:23', '0', '68', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('180', '国内java开源商城系统', '<ul class=\"project_info clearfix\"><li><ul><li><h5>项目地点：</h5><p>江苏连云港</p></li><li><h5>面积：</h5><p>22000 m²</p></li><li><h5>服务项目：</h5><p>室内设计/照明设计/陈设设计</p></li></ul></li><li><ul><li><h5>设计日期：</h5><p>2013年1月-2013年4月</p>\r\n</li><li><h5>竣工日期：</h5><p>2015</p></li><li><h5>设计师：</h5><p>本公司设计团队</p></li></ul></li><li class=\"item3\"><h5>主要材料：</h5><p>天然大理石/实木/布艺</p></li></ul>', '/upload/article/1569/1461575368361.jpg', '0', '0', '2016-04-25 17:14:06', '2016-05-04 13:55:52', '0', '140', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('181', '国内java开源bbs系统', '<ul class=\"project_info clearfix\"> <li> <ul><li><h5>项目地点：</h5><p>北京中关村银谷大厦</p> </li> <li><h5>面积：</h5><p>650 m² m²</p></li><li><h5>服务项目：</h5> <p>办公室设计</p> </li></ul> </li> <li><ul> <li> <h5>设计日期：</h5><p>2012年10月-2012年12月</p> </li><li><h5>竣工日期：</h5><p>2013年3月</p></li> <li><h5>设计师：</h5><p>某某团队</p> </li> </ul></li> <li class=\"item3\"><h5>主要材料：</h5><p>皮革 / 爵士白石材 / 云多拉石材</p></li></ul>', '/upload/article/1569/1461575691520.jpeg', '0', '0', '2016-04-25 17:19:41', '2016-05-04 13:55:42', '0', '139', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('182', '人才理念', '网络营销是以互联网络为基础，通过数字化的信息和网络媒体的交互性来辅助营销目标实现的一种新型的市场营销方式。', '/upload/article/1584/1462521245856.jpg', '0', '0', '2016-04-29 14:49:03', '2016-06-02 11:17:43', '0', '52', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('183', '联系我们', '这里是一个充满活力和梦想的企业，我们不反对个性，我们不安于现状，我们亲手创造价值，我们永远在进步……如果你也是名有梦想勇于尝试的人，那就赶快加入我们吧！\r\n\r\n我们面向全国招募有志之士，欢迎自荐或向周围的好友推荐。', '', '0', '0', '2016-04-29 14:49:25', '2016-06-02 11:17:55', '0', '136', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('184', '光学镜头接口简介', '', '/upload/article/1584/1462369578091.jpg', '0', '0', '2016-05-04 14:28:07', '2016-05-04 21:46:36', '0', '122', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('185', '联系我们', '这里是一个充满活力和梦想的企业，我们不反对个性，我们不安于现状，我们亲手创造价值，我们永远在进步……如果你也是名有梦想勇于尝试的人，那就赶快加入我们吧！\r\n\r\n我们面向全国招募有志之士，欢迎自荐或向周围的好友推荐。', '/upload/article/1638/1465720290023.jpg', '0', '4', '2016-05-04 14:49:32', '2016-06-12 16:31:31', '0', '141', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('186', '折页机在线错页视觉检测', '品质宝最新折页机检测，采用最新折页机检测软件（字符检测，图文检测，条码检测等混料检测）、德国Balser黑白工业相机、无风扇扇热工业一体机搭配，实现无论在多大灰尘车间仍然不影响检测设备正常使用。', '/upload/article/1584/1462346138326.jpg', '0', '0', '2016-05-04 15:16:55', '2016-05-04 16:10:02', '0', '143', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('187', '糊盒机在线混料视觉检测', '品质宝最新糊盒机检测，采用最新糊盒机检测软件（字符检测，图文检测，条码检测等混料检测）、德国Balser黑白工业相机、无风扇扇热工业一体机搭配，实现无论在多大灰尘车间仍然不影响检测设备正常使用。', '/upload/article/1584/1462367349313.jpg', '0', '0', '2016-05-04 15:37:12', '2016-05-04 21:09:13', '0', '143', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('188', '焊点视觉定位检测方案', '一、可提供解决方案：1、采用相机直接安装在自动焊接上进行检测，提高效率；2、通过合适的视觉工具获取当前焊接点的位置，引导焊枪自动移动到准确位置进行点焊。', '/upload/article/1584/1462348554148.jpg', '0', '0', '2016-05-04 15:38:33', '2016-05-04 15:55:54', '0', '144', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('189', '天上', '', '/upload/article/1615/1463622466259.jpg', '0', '0', '2016-05-19 09:47:57', '2016-05-19 09:47:57', '0', '130', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('190', '在线留言', '', '', '0', '0', '2016-06-02 11:17:01', '2016-06-02 11:17:01', '0', '142', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('191', '“绿色装饰”融入杭州市民中心装饰工程', '此外项目部还非常注重采取新工艺、新方法，不仅提高了工程的整体美观性和实用性，而且加快了施工进度，提升了工作效率。由于本工程是圆型结构的楼层施 工，特别是石材在圆弧和圆柱造型上用量大，大大增加了工程的施工难度。', '/upload/article/1638/1464861354733.jpg', '0', '0', '2016-06-02 14:52:40', '2016-06-02 17:55:55', '0', '84', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('192', '纽约时髦客手中那些让人尖叫的包', '对于时尚达人而言，包袋与衣服的混搭也是一种必杀技。休闲手提包可以搭配不同的造型，而搭配运动裤就是更加直接地表现出时尚休闲风的最佳配搭方案。', '/upload/article/1638/1464861380560.png', '0', '0', '2016-06-02 14:53:33', '2016-06-04 09:55:27', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('193', '宋朝华率队赴贵州招商洽谈推进重大项目', '市委副书记、市长宋朝华率队前往贵州省贵阳市，实地考察由中铁贵旅公司投资开发建设的中铁国际生态城项目，并与公司高层进行了深入友好座谈，洽谈推进重大项目落户我市仁寿县相关事宜。\r\n ', '/upload/article/1638/1464861385314.jpg', '0', '0', '2016-06-02 14:53:59', '2016-06-02 17:56:25', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('194', '红木市场是否低迷 消费者仍在', '内庭中央还展示着一辆豪华轿车，而周边则摆满红木家具，完全没有红木家具应该有的意境。更令人瞠目结舌的是，里面人流熙熙攘攘', '/upload/article/1638/1464861401214.jpg', '0', '0', '2016-06-02 14:54:54', '2016-06-02 17:56:42', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('195', '众多国宝级古典家具悉数亮相', '海南黄花梨圆包脚罗汉床、小叶紫檀云龙纹镶理石圆桌、富贵满堂多宝阁……昨日（12月13日）上午，第三届中国（江门）传统家具精品鉴赏会暨2014中国（江门）红木家具....', '/upload/article/1638/1464861408016.jpg', '0', '0', '2016-06-02 14:55:33', '2016-06-04 09:55:30', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('196', '戴为红木燃情成都，开启幸福之门', '近期，出于对中国传统文化的热爱，以及对红木艺术的执着、深情和追求，戴为红木携带“幸福之家”主题活动礼遇成都，使其鸿儒红木家居艺术馆隆重开业，为已进入寒冬的成都燃起了一把火，掀起了中式红木家具热潮！', '/upload/article/1638/1464861413861.jpg', '0', '0', '2016-06-02 14:56:00', '2016-06-02 17:56:54', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('197', '质检整治电商售假 红木家具市场良莠不齐', '质检总局执法督查司按照网上发现、源头追溯、落地查处的要求，组织开展电子商务产品专项执法打假活动，积极构建适应电子商务执法打假的全国执法协查工作机制...', '/upload/article/1638/1464861373394.png', '0', '0', '2016-06-02 14:56:35', '2016-06-02 17:56:16', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('198', '东西方两大甜妞聚首巴黎时装周头排', '巴黎时装周许晴倾力助阵，当天许晴身着黑色拼接装头排看秀，大秀美腿，加上干净利落的妆容，整体造型简洁率性，绿色的刺绣手包更添俏皮..', '/upload/article/1638/1464861364631.jpg', '0', '0', '2016-06-02 14:57:07', '2016-06-02 17:56:05', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('199', '宋朝华率队赴贵州招商洽谈推进重大项目', '市委副书记、市长宋朝华率队前往贵州省贵阳市，实地考察由中铁贵旅公司投资开发建设的中铁国际生态城项目，并与公司高层进行了深入友好座谈，洽谈推进重大项目落户我市仁寿县相关事宜。', '/upload/article/1638/1464861360036.png', '0', '0', '2016-06-02 14:57:40', '2016-06-02 17:56:01', '0', '83', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('200', '奔驰斯宾特A3 豪华版', '斯宾特系列(Sprinter)系列技术领先，动力强劲。座位数从10座到20座均可选择，跟据配置不同,价格也从95.8万178万可以选择。为您带来不同的商务体验。下面为.', '/upload/article/1638/1464851333470.jpg', '0', '0', '2016-06-02 15:09:12', '2016-06-02 15:14:48', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('201', '福特E350 游艇版', '其实商务车在人们眼里就是普通的客车，没有人会花时间去研究它，欣赏它。商务车给人的印象，就是整体的一箱车，发动机不是在驾驶与副驾驶的座椅下...', '/upload/article/1638/1464851477741.jpg', '0', '0', '2016-06-02 15:09:42', '2016-06-02 15:11:18', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('202', 'GMC3500 平顶舒适版', '对于这样一款外观霸气，承载性高的原装进口商务车和它实在的销售价格，都让这款车的性价比大大提升了不少。对于市场上一些追求个性的客户群来讲，...', '/upload/article/1638/1464851473102.jpg', '0', '0', '2016-06-02 15:10:17', '2016-06-02 15:11:14', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('203', '宾特奔驰斯A系列', '奔驰斯宾特系列礼宾车在豪华商务车系中，一向是高端、舒适的代名词。在秉承了奔驰的贵族气质的同时，其全新定制的奢华内饰让人感觉犹如进入了高档..', '/upload/article/1638/1465808166467.png', '0', '0', '2016-06-02 15:11:08', '2016-06-13 16:56:07', '0', '107', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('204', '1', '', '/upload/article/1638/1464859580381.jpg', '0', '0', '2016-06-02 17:26:21', '2016-06-02 17:26:21', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('205', '2', '', '/upload/article/1638/1464859585818.jpg', '0', '0', '2016-06-02 17:26:26', '2016-06-02 17:26:26', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('206', '3', '', '/upload/article/1638/1464859590366.jpg', '0', '0', '2016-06-02 17:26:31', '2016-06-02 17:26:31', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('207', '4', '', '/upload/article/1638/1464859595151.jpg', '0', '0', '2016-06-02 17:26:36', '2016-06-02 17:26:36', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('208', '5', '', '/upload/article/1638/1464859599849.jpg', '0', '0', '2016-06-02 17:26:40', '2016-06-02 17:26:40', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('209', '6', '高品质景观缔造者\r\nHigh quality landscape architects.', '/upload/article/1638/1464859604208.jpg', '0', '0', '2016-06-02 17:26:45', '2016-06-16 14:24:51', '0', '148', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('210', '幻灯五', '做精品设计、建优良工程、打造精品工程\r\nBoutique design, construction engineering, excellent build quality engineering.', '/upload/article/1638/1464859633594.jpg', '0', '0', '2016-06-02 17:26:55', '2016-06-16 14:24:18', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('211', '幻灯六', '与您一起携手，共同谱写园林绿化事业的新篇章！\r\nWork with you to jointly write a new chapter landscaping business!', '/upload/article/1638/1464859625584.jpg', '0', '0', '2016-06-02 17:27:06', '2016-06-16 14:23:03', '0', '147', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('212', '愿景', '我们拥有稳定的充满创作激情的设计团队，核心人员由公司创立至今伴随我们一个又一个客户的成长，保证了稳定的设计出品质量及熟知我们所合作过的每一个客户的设计需求，现在，团队不断壮大。', '/upload/article/1638/1464940624025.png', '0', '0', '2016-06-02 17:36:54', '2016-06-03 20:52:58', '0', '95', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('213', '价值观', '我们已为数百家企业、政府和社会团体完成品牌的传播与设计，积累了大量丰富的经验，可为您提供大量同类企业和机构的案例进行比较参考。', '/upload/article/1638/1464940619456.jpg', '0', '0', '2016-06-02 17:37:08', '2016-06-03 20:52:55', '0', '95', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('214', '经营理念', '可提供一站式全面服务：品牌的定位——企业文化梳理——企业/品牌形象设计——品牌传播——环境空间设计——宣传物品的落地', '/upload/article/1638/1464940614692.jpg', '0', '0', '2016-06-02 17:37:19', '2016-06-03 20:52:46', '0', '95', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('215', '管理理念', '多年来，我们始终专注于品牌的设计与塑造，坚持站在市场的角度，为客户创作出准确的、极具商业价值的形象设计与品牌传播策略。', '/upload/article/1638/1464940610305.jpg', '0', '0', '2016-06-02 17:37:42', '2016-06-12 17:54:59', '0', '95', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('216', '李镇江', '资深PPT设计师', '/upload/article/1638/1464860436576.png', '0', '0', '2016-06-02 17:40:31', '2016-06-03 15:47:36', '0', '115', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('217', '曹瑛', '锐诚PPT特邀首席技术专家', '/upload/article/1638/1464860564066.png', '0', '0', '2016-06-02 17:41:15', '2016-06-03 15:47:33', '0', '115', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('218', '孙建东', '锐诚PPT培训部总监', '/upload/article/1638/1464860506257.png', '0', '0', '2016-06-02 17:41:47', '2016-06-03 15:47:30', '0', '115', '1', '8', null, null, null, null);
INSERT INTO `basic` VALUES ('219', '梅幸', '锐诚PPT金牌设计师', '/upload/article/1638/1464860570155.png', '0', '0', '2016-06-02 17:42:27', '2016-06-03 15:47:27', '0', '115', '1', '8', null, null, null, null);

-- ----------------------------
-- Table structure for `basic_attention`
-- ----------------------------
DROP TABLE IF EXISTS `basic_attention`;
CREATE TABLE `basic_attention` (
  `ba_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `ba_peopleID` int(11) DEFAULT NULL COMMENT '用户id',
  `ba_appID` int(11) DEFAULT NULL COMMENT '用户应用id',
  `ba_basicID` int(11) DEFAULT NULL COMMENT '用户收藏关联的基础id',
  `ba_type` int(11) DEFAULT NULL COMMENT '收藏类型 1： 收藏  2：顶',
  `ba_datetime` datetime DEFAULT NULL COMMENT '用户收藏文章，帖子或商品时的时间',
  `ba_url` varchar(200) DEFAULT NULL COMMENT '收藏的文章,帖子，商品的链接地址',
  PRIMARY KEY (`ba_id`),
  KEY `BA_PEOPLEID` (`ba_peopleID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户收藏表';

-- ----------------------------
-- Records of basic_attention
-- ----------------------------

-- ----------------------------
-- Table structure for `basic_category`
-- ----------------------------
DROP TABLE IF EXISTS `basic_category`;
CREATE TABLE `basic_category` (
  `bc_basic_id` int(11) NOT NULL COMMENT '文章编号',
  `bc_category_id` int(11) NOT NULL COMMENT '分类编号',
  UNIQUE KEY `bc_basic_id` (`bc_basic_id`,`bc_category_id`),
  KEY `bc_category_id` (`bc_category_id`),
  KEY `bc_category_id_2` (`bc_category_id`),
  KEY `bc_category_id_3` (`bc_category_id`),
  CONSTRAINT `basic_category_ibfk_1` FOREIGN KEY (`bc_basic_id`) REFERENCES `basic` (`BASIC_ID`) ON DELETE CASCADE,
  CONSTRAINT `basic_category_ibfk_2` FOREIGN KEY (`bc_category_id`) REFERENCES `category` (`CATEGORY_ID`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章多分类表';

-- ----------------------------
-- Records of basic_category
-- ----------------------------

-- ----------------------------
-- Table structure for `basic_child`
-- ----------------------------
DROP TABLE IF EXISTS `basic_child`;
CREATE TABLE `basic_child` (
  `bc_basic_Id` int(11) NOT NULL COMMENT '基础basicId',
  `bc_basic_child_Id` int(11) DEFAULT NULL COMMENT '基础basicId关联的子id',
  PRIMARY KEY (`bc_basic_Id`),
  KEY `bc_basic_Id` (`bc_basic_Id`) USING BTREE,
  KEY `bc_basic_child_Id` (`bc_basic_child_Id`) USING BTREE,
  CONSTRAINT `basic_child_ibfk_1` FOREIGN KEY (`bc_basic_Id`) REFERENCES `basic` (`BASIC_ID`),
  CONSTRAINT `basic_child_ibfk_2` FOREIGN KEY (`bc_basic_child_Id`) REFERENCES `basic` (`BASIC_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='基础表之间的子父关联表';

-- ----------------------------
-- Records of basic_child
-- ----------------------------

-- ----------------------------
-- Table structure for `basic_log`
-- ----------------------------
DROP TABLE IF EXISTS `basic_log`;
CREATE TABLE `basic_log` (
  `bl_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `bl_basic_id` int(11) NOT NULL COMMENT '引用编号',
  `bl_ip` varchar(20) NOT NULL COMMENT 'ip地址',
  `bl_datetime` datetime NOT NULL COMMENT '记录时间',
  `bl_is_mobile` int(1) NOT NULL DEFAULT '0' COMMENT '1移动端 0默认pc',
  PRIMARY KEY (`bl_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='信息访问日志';

-- ----------------------------
-- Records of basic_log
-- ----------------------------
INSERT INTO `basic_log` VALUES ('1', '178', '192.168.1.165', '2016-05-31 15:33:33', '0');
INSERT INTO `basic_log` VALUES ('2', '74', '192.168.1.165', '2016-05-31 15:33:36', '0');
INSERT INTO `basic_log` VALUES ('3', '179', '192.168.1.165', '2016-05-31 15:33:44', '0');
INSERT INTO `basic_log` VALUES ('4', '63', '192.168.1.165', '2016-05-31 17:49:01', '0');
INSERT INTO `basic_log` VALUES ('5', '70', '192.168.1.165', '2016-05-31 17:53:37', '0');
INSERT INTO `basic_log` VALUES ('6', '58', '192.168.1.165', '2016-05-31 17:54:59', '0');
INSERT INTO `basic_log` VALUES ('7', '59', '192.168.1.165', '2016-05-31 17:55:09', '0');
INSERT INTO `basic_log` VALUES ('8', '56', '192.168.1.165', '2016-05-31 17:55:13', '0');
INSERT INTO `basic_log` VALUES ('9', '62', '192.168.1.165', '2016-05-31 17:55:38', '0');
INSERT INTO `basic_log` VALUES ('10', '61', '192.168.1.165', '2016-05-31 17:55:40', '0');
INSERT INTO `basic_log` VALUES ('11', '57', '192.168.1.165', '2016-05-31 17:56:21', '0');
INSERT INTO `basic_log` VALUES ('12', '177', '192.168.1.165', '2016-06-03 17:41:32', '0');
INSERT INTO `basic_log` VALUES ('13', '73', '192.168.1.165', '2016-06-12 11:31:11', '0');
INSERT INTO `basic_log` VALUES ('14', '73', '192.168.1.152', '2016-06-13 19:53:50', '0');

-- ----------------------------
-- Table structure for `basic_type`
-- ----------------------------
DROP TABLE IF EXISTS `basic_type`;
CREATE TABLE `basic_type` (
  `bt_basic_id` int(11) NOT NULL DEFAULT '0' COMMENT '基础信息',
  `bt_type` int(11) NOT NULL DEFAULT '0' COMMENT '属性',
  UNIQUE KEY `st_basic_id` (`bt_basic_id`,`bt_type`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='通用信息属性';

-- ----------------------------
-- Records of basic_type
-- ----------------------------

-- ----------------------------
-- Table structure for `category`
-- ----------------------------
DROP TABLE IF EXISTS `category`;
CREATE TABLE `category` (
  `CATEGORY_ID` int(22) NOT NULL AUTO_INCREMENT COMMENT '类别ID',
  `CATEGORY_TITLE` varchar(50) DEFAULT NULL COMMENT '类别标题',
  `CATEGORY_SORT` int(10) DEFAULT NULL COMMENT '类别排序',
  `CATEGORY_DATETIME` datetime DEFAULT NULL COMMENT '类别发布时间',
  `CATEGORY_MANAGERID` int(22) DEFAULT NULL COMMENT '发布用户ID',
  `CATEGORY_MODELID` int(11) DEFAULT NULL COMMENT '所属模块ID',
  `CATEGORY_CATEGORYID` int(22) DEFAULT NULL COMMENT '父类别编号',
  `CATEGORY_SMALLIMG` varchar(120) DEFAULT NULL COMMENT '略缩图',
  `CATEGORY_APPID` int(11) DEFAULT NULL COMMENT '应用编号',
  `CATEGORY_DESCRIPTION` varchar(45) DEFAULT NULL COMMENT '栏目描述',
  PRIMARY KEY (`CATEGORY_ID`),
  KEY `CATEGORY_APPID` (`CATEGORY_APPID`),
  KEY `CATEGORY_MANAGERID` (`CATEGORY_MANAGERID`),
  KEY `CATEGORY_MODELID` (`CATEGORY_MODELID`),
  KEY `CATEGORY_CATEGORYID` (`CATEGORY_CATEGORYID`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 COMMENT='分类表';

-- ----------------------------
-- Records of category
-- ----------------------------
INSERT INTO `category` VALUES ('19', '联系我们', '0', '2015-09-01 15:31:30', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('23', '常见问题', '0', '2015-09-01 15:33:54', '50', '87', '0', null, '1', null);
INSERT INTO `category` VALUES ('33', '投资', '0', '2015-09-02 00:32:02', '50', '87', '0', null, '1', null);
INSERT INTO `category` VALUES ('52', '招商加盟', '0', '2016-03-15 17:35:38', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('53', '关于我们', '0', '2016-03-16 17:16:11', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('59', '新闻中心', '0', '2016-03-26 13:18:53', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('61', '客户案例', '0', '2016-03-26 13:26:34', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('62', '新闻', '0', '2016-03-26 13:27:39', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('63', '服务', '0', '2016-03-26 13:29:07', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('65', '网站设计', '3', '2016-03-26 14:34:49', '50', '7', '61', null, '1', null);
INSERT INTO `category` VALUES ('66', '手机应用', '1', '2016-03-26 14:35:49', '50', '7', '61', null, '1', null);
INSERT INTO `category` VALUES ('67', '平面设计', '2', '2016-03-26 14:36:15', '50', '7', '61', null, '1', null);
INSERT INTO `category` VALUES ('68', '公司新闻', '3', '2016-03-27 09:39:22', '50', '7', '59', null, '1', null);
INSERT INTO `category` VALUES ('69', '行业新闻', '2', '2016-03-27 09:39:48', '50', '7', '59', null, '1', null);
INSERT INTO `category` VALUES ('70', '最新动态', '1', '2016-03-27 09:40:22', '50', '7', '59', null, '1', null);
INSERT INTO `category` VALUES ('83', '研发团队', '2', '2016-03-28 16:51:31', '50', '7', '62', null, '1', null);
INSERT INTO `category` VALUES ('84', '研发成果', '1', '2016-03-28 16:54:29', '50', '7', '62', null, '1', null);
INSERT INTO `category` VALUES ('87', '客户的声音', '0', '2016-03-30 10:27:42', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('93', '关于我们', '0', '2016-04-11 19:52:30', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('94', '主营业务', '5', '2016-04-11 19:54:05', '50', '7', '93', null, '1', null);
INSERT INTO `category` VALUES ('95', '企业文化', '4', '2016-04-11 19:54:43', '50', '7', '93', null, '1', null);
INSERT INTO `category` VALUES ('96', '资质荣誉', '0', '2016-04-11 19:55:18', '50', '7', '93', null, '1', null);
INSERT INTO `category` VALUES ('97', '合作伙伴', '0', '2016-04-11 19:55:41', '50', '7', '93', null, '1', null);
INSERT INTO `category` VALUES ('98', '企业优势', '0', '2016-04-11 19:56:04', '50', '7', '93', null, '1', null);
INSERT INTO `category` VALUES ('99', '服务项目', '0', '2016-04-11 20:32:40', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('100', '首页幻灯', '0', '2016-04-11 20:56:40', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('101', ' 全案设计', '3', '2016-04-11 21:04:41', '50', '7', '99', null, '1', null);
INSERT INTO `category` VALUES ('102', '企业形象设计', '4', '2016-04-11 21:05:11', '50', '7', '99', null, '1', null);
INSERT INTO `category` VALUES ('103', '产品包装设计', '2', '2016-04-11 21:05:42', '50', '7', '99', null, '1', null);
INSERT INTO `category` VALUES ('104', '连锁店设计', '0', '2016-04-11 21:05:57', '50', '7', '99', null, '1', null);
INSERT INTO `category` VALUES ('106', '产品列表', '0', '2016-04-11 21:15:27', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('107', '产品一类', '2', '2016-04-11 21:15:43', '50', '7', '106', null, '1', null);
INSERT INTO `category` VALUES ('108', '产品二类', '1', '2016-04-11 21:16:21', '50', '7', '106', null, '1', null);
INSERT INTO `category` VALUES ('115', '专家研究院', '0', '2016-04-11 21:29:24', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('133', '网站优化', '3', '2016-04-17 18:32:05', '50', '7', '53', null, '1', null);
INSERT INTO `category` VALUES ('134', '网络营销', '2', '2016-04-17 18:33:01', '50', '7', '53', null, '1', null);
INSERT INTO `category` VALUES ('135', '域名注册', '1', '2016-04-17 18:33:47', '50', '7', '53', null, '1', null);
INSERT INTO `category` VALUES ('136', '优化报价', '0', '2016-04-17 21:13:17', '50', '7', '52', null, '1', null);
INSERT INTO `category` VALUES ('138', '服务中心', '0', '2016-04-29 17:15:49', '50', '7', '63', null, '1', null);
INSERT INTO `category` VALUES ('141', '联系我们', '2', '2016-05-04 14:42:07', '50', '7', '19', null, '1', null);
INSERT INTO `category` VALUES ('142', '在线留言', '1', '2016-05-04 14:42:31', '50', '7', '19', null, '1', null);
INSERT INTO `category` VALUES ('146', '人才招聘', '0', '2016-05-19 17:49:37', '50', '7', '0', null, '1', null);
INSERT INTO `category` VALUES ('147', '长图', '0', '2016-06-02 17:23:49', '50', '7', '100', null, '1', null);
INSERT INTO `category` VALUES ('148', '短图', '0', '2016-06-02 17:24:21', '50', '7', '100', null, '1', null);

-- ----------------------------
-- Table structure for `cms_article`
-- ----------------------------
DROP TABLE IF EXISTS `cms_article`;
CREATE TABLE `cms_article` (
  `ARTICLE_BASICID` int(20) NOT NULL DEFAULT '0' COMMENT '文章ID',
  `ARTICLE_AUTHOR` varchar(20) DEFAULT NULL COMMENT '文章作者',
  `ARTICLE_CONTENT` longtext COMMENT '文章内容',
  `ARTICLE_TYPE` varchar(100) DEFAULT NULL COMMENT '文章类型',
  `ARTICLE_SOURCE` varchar(300) DEFAULT NULL COMMENT '文章来源',
  `ARTICLE_URL` varchar(200) DEFAULT NULL COMMENT '文章跳转链接地址',
  `ARTICLE_KEYWORD` varchar(300) DEFAULT NULL COMMENT '文章关键字',
  `ARTICLE_FREEORDER` int(255) DEFAULT NULL COMMENT '文章自定义显示顺序',
  `ARTICLE_WEBID` int(11) DEFAULT NULL COMMENT '文章管理的应用id',
  PRIMARY KEY (`ARTICLE_BASICID`),
  UNIQUE KEY `ARTICLE_BASICID` (`ARTICLE_BASICID`) USING BTREE,
  KEY `ARTICLE_WEBID` (`ARTICLE_WEBID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='文章表';

-- ----------------------------
-- Records of cms_article
-- ----------------------------
INSERT INTO `cms_article` VALUES ('2', '铭飞科技', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">本课程为清华大学人文素质核心课程。自从地球上有了人类，工艺美术也就开始产生了。<br style=\"box-sizing: border-box;\"/>一部工艺美术史，实际上也是人类文明不断发展、演变和进步历程的形象记录。上下百万年，人们创造的分布在世界各地、难以数计的工艺美术作品，无一不是人类文明高容量的载体。<br style=\"box-sizing: border-box;\"/>外国工艺美术史研究是人文学科中的重要环节。它对培养国人的文化素质，提高我国综合素质教育质量，完善人文学科，树立学术形象，提升综合学术地位，皆有重要意义。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">课程章节</span></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第一章 古代埃及工艺美术<br style=\"box-sizing: border-box;\"/>1.1 古代埃及概述<br style=\"box-sizing: border-box;\"/>1.2 古代埃及陶工艺<br style=\"box-sizing: border-box;\"/>1.3 古代埃及石工艺<br style=\"box-sizing: border-box;\"/>1.4 古代埃及金属工艺<br style=\"box-sizing: border-box;\"/>1.5 古代埃及玻璃工艺<br style=\"box-sizing: border-box;\"/>1.6 古代埃及木工艺、小结<br style=\"box-sizing: border-box;\"/>第1周作业</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第二章 古代两河流域工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第三章 古代波斯工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第四章 古代印度工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第五章 古代日本工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第六章 古代地中海区域工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第七章 古代希腊工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第八章 埃特鲁里亚工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第九章 古代罗马工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十章 古代伊斯兰工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十一章 欧洲中世纪工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十二章 文艺复兴时期工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十三章 巴洛克时期工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十四章 洛可可时期工艺美术</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第十五章 新古典主义时期工艺美术</p><p><br/></p>', '', '铭飞科技', '/48\\2.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('3', '铭飞科技', '<p>讲授甲骨、金文、战国古文等古代文字的课程。</p><p>本课程主要讲授汉字的起源、发展及不同历史时期的文字面貌，涉及甲骨文、金文、小篆、战国古文、早期隶书、《说文》部首等，使学生对于中国文字的形态及文字学历史有一个概貌性的认识，并初步掌握识读古文字的方法。另外，通过讲授古文字学的基本理论（如古文字学的性质、任务，汉字起源，古文字的考释方法，古文字的演变规律等）和各种古文字原材料（如甲骨文、金文、简帛、玺印、货币文字等），开拓学生视野，熟悉古文字遗产，掌握有关古文字的基础知识，具有阅读和钻研古文字原材料的初步能力，为进一步学习和研究古代的语言文字打下基础，进而初步具备整理古籍文献及出土文献的方法及进一步从事古文字研究、比较文字学研究的能力。</p><p>证书要求<br style=\"box-sizing: border-box;\"/>本课程非常重视平时练习，平时成绩占二分之一。考试范围原则上不超出教材及课堂所讲述的内容。成绩合格率一般在95%左右，优秀比例视平时成绩而定，总数不限。</p><p>预备知识<br style=\"box-sizing: border-box;\"/>古代汉语、训诂学、文献学</p><p><br style=\"box-sizing: border-box;\"/></p><p>授课大纲<br style=\"box-sizing: border-box;\"/>大致以五分之一的课时讲授基本理论，以五分之四的课时讲授甲骨文、金文、战国文字等各类古文字原材料。课程内容与每周内容分配：<br style=\"box-sizing: border-box;\"/>隶变与古文字源起，占1周；<br style=\"box-sizing: border-box;\"/>甲骨文，2周；<br style=\"box-sizing: border-box;\"/>金文，2周；<br style=\"box-sizing: border-box;\"/>战国古文，3周；<br style=\"box-sizing: border-box;\"/>秦及汉初文字，1周；<br style=\"box-sizing: border-box;\"/>古文字文化解读与解秘，3周。</p><p><br style=\"box-sizing: border-box;\"/>参考资料<br style=\"box-sizing: border-box;\"/>陈炜湛、唐钰明《古文字学纲要》，中山大学出版社1988年初版，2009年12月第二版。陈世辉、汤余惠《古文字学概要》，福建人民出版社2011年4月。<br style=\"box-sizing: border-box;\"/>裘锡圭《文字学概要》，商务印书馆1988年版。<br style=\"box-sizing: border-box;\"/>张桂光《汉字学简论》广东高等教育出版社2004年版。<br style=\"box-sizing: border-box;\"/>唐兰《中国文字学》，商务印书馆1930年代排印本，1986年上海古籍出版社据开明书店1949年3月版重印本。<br style=\"box-sizing: border-box;\"/>高明《古文字类编》增订本，上海古籍出版社2011年版。</p><p><br/></p>', '', '铭飞科技', '/48\\3.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('23', '铭飞科技', '<p>门槛最低，功能最全最灵活，利润最大，支撑最大！</p><p>支撑优势</p><p>甩单支撑产品培训销售培训迟训升级</p><p>远程咨询地区保护落地支撑奖金激励</p><p><br/></p><p>最大利润空间</p><p>超低折扣报价有效营销指导灵活报价策略免费现场支撑</p><p><br/></p><p>功能优势</p><p>海量，可快速定制化的、灵活化功能模块供客户选择：</p><p>在线支付在线预约购物车消息推送</p><p>灵活桌面LBS地图导航分享问卷调查</p><p>3d全景一键拨号后台分级更多功能</p><p><br/></p><p>行业覆盖</p><p><br/></p><p>\r\n			<!-- about_rproject_desc --></p>', '', '铭飞科技', '/18\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('24', '铭飞科技', '<p>&nbsp; 公司于2012年3月8日，已正式向《景德镇市工商行政管理局》领取营业 &nbsp; 执照。</p><p>&nbsp; 公司名称：景德镇铭飞科技有限公司</p><p>&nbsp; 经营范围：计算机系统服务及技术开发、咨询服务</p><p><br/></p>', 'c,', '铭飞科技', '/19\\index.html', '公司于2012年3月8日，已正式向《景德镇市工商行政管理局》领取营业   执照。\r\n  公司名称：景德镇铭飞科技有限公司\r\n  经营范围：计算机系统服务及技术开发、咨询服务', '0', '1');
INSERT INTO `cms_article` VALUES ('4', '铭飞科技', '<p>这门课程的教学目标如下：<br style=\"box-sizing: border-box;\"/></p><ul style=\"box-sizing: border-box; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\" class=\" list-paddingleft-2\"><li><p>认清数据收集的重要性，认清数据收集方法的局限，认清这些因素是如何影响推断的。使用数据软件（R）来在数字上和在视觉上总结数据，并且呈现对数据的分析。</p></li><li><p>对统计推断的本质有一个概念上的理解。利用评估和测试方法（置信区间和假说测试）来分析单一变量和两个变量之间的关系，以便于理解自然现象的本质以及做出基于数据的决策。利用回归框架做模型来研究两个或更多数据之间的关系。</p></li><li><p>用通俗易懂的语言在具体环境中正确、高效地讲解结果。</p></li><li><p>评价基于数据做出的声明和决策。</p></li><li><p>用简单的数据推断和模型方法完成一个调查项目。</p></li></ul><p><br style=\"box-sizing: border-box;\"/></p><p>课程大纲<br style=\"box-sizing: border-box;\"/>第1周：第一单元 - 介绍数据<br style=\"box-sizing: border-box;\"/>第一部分 - 设计研究<br style=\"box-sizing: border-box;\"/>第二部分 - 探索数据分析<br style=\"box-sizing: border-box;\"/>第三部分 - 介绍通过仿真推断</p><p>第2周：第二单元 - 概率和分布<br style=\"box-sizing: border-box;\"/>第一部分 - 定义概率<br style=\"box-sizing: border-box;\"/>第二部分 - 条件概率<br style=\"box-sizing: border-box;\"/>第三部分 - 正态分布<br style=\"box-sizing: border-box;\"/>第四部分 - 二项分布</p><p>第3周：第三单元 - 推断基础<br style=\"box-sizing: border-box;\"/>第一部分 - 估值可变性和中心极限理论<br style=\"box-sizing: border-box;\"/>第二部分 - 置信区间<br style=\"box-sizing: border-box;\"/>第三部分 - 假设测试</p><p>第4周：完成第三单元 + 期中<br style=\"box-sizing: border-box;\"/>第四部分 - 其他估计量的推断<br style=\"box-sizing: border-box;\"/>第五部分 - 判断的错误、重要性和可信度</p><p>第5周：第四单元 - 数字变量的推断<br style=\"box-sizing: border-box;\"/>第一部分 - 比较两种方法<br style=\"box-sizing: border-box;\"/>第二部分 - 另解<br style=\"box-sizing: border-box;\"/>第三部分 - t分布推断<br style=\"box-sizing: border-box;\"/>第四部分 - 比较三种或更多方法（ANOVA）</p><p>第6周：第五单元 - 明确变量推断<br style=\"box-sizing: border-box;\"/>第一部分 - 单比例<br style=\"box-sizing: border-box;\"/>第二部分 - 两比例对比<br style=\"box-sizing: border-box;\"/>第三部分 - 通过仿真比例推断<br style=\"box-sizing: border-box;\"/>第四部分 - 比较三种或更多比例（Chi-square）</p><p>第7周：第六单元 - 介绍线性回归<br style=\"box-sizing: border-box;\"/>第一部分 - 两个数字变量之间的关系<br style=\"box-sizing: border-box;\"/>第二部分 - 单一预测的线性回归<br style=\"box-sizing: border-box;\"/>第三部分 - 线性回归中的异常值<br style=\"box-sizing: border-box;\"/>第四部分 - 线性回归中的推断</p><p>第8周：第七单元 - 多重线性回归<br style=\"box-sizing: border-box;\"/>第一部分 - 多预测的线性回归<br style=\"box-sizing: border-box;\"/>第二部分 - 多重线性回归推断<br style=\"box-sizing: border-box;\"/>第三部分 - 模型选择<br style=\"box-sizing: border-box;\"/>第四部分 - 模型诊断</p><p>第9周：复习/答疑周<br style=\"box-sizing: border-box;\"/>贝叶斯推论 vs. 概率推论</p><p>第10周：期末考试</p><p><br style=\"box-sizing: border-box;\"/>先修知识<br style=\"box-sizing: border-box;\"/>基础数学，不需要编程经验。对数据分析的真心热爱是附加条件！</p><p><br style=\"box-sizing: border-box;\"/>参考资料<br style=\"box-sizing: border-box;\"/>这门课设计成自我包含所有内容的形式。但是我们建议学生参考《OpenIntro Statistics》（第七版）。这门课紧跟这本书，所以书中内容可以作为视频材料的补充。除此之外，练习题会从这本书中出。本书是公开资源，可以在网站openintro.org上免费在线阅读。</p><p><br style=\"box-sizing: border-box;\"/>授课形式<br style=\"box-sizing: border-box;\"/>这门课会包括视频课程，5到10分钟的长度，每个视频会有几个视频内测试。家庭作业包括评分的选择题测试、不计分的书中问题、数据计算分析作业、一个数据分析项目、期中和期末考试。</p><p><br style=\"box-sizing: border-box;\"/>常见问题解答<br style=\"box-sizing: border-box;\"/>完成这门课程后能获得证书吗？<br style=\"box-sizing: border-box;\"/>能。只要你依据评分规则成功完成了这门课，就能得到证书。</p><p>这门课是免费的吗？<br style=\"box-sizing: border-box;\"/>是的！你免费上这门课，并且获得免费的证书。<br style=\"box-sizing: border-box;\"/>不过，如果你想要认证证书，你需要支付费用。你可以在这里阅读更多的认证证书信息，来看看有没有你感兴趣的地方。除此之外，如果你想要获得推理论证、数据分析和写作的系列课程认证，你就需要认证证书。你可以点击这里了解更多关于系列课程的信息。</p><p>上这门课需要之前学习编程知识吗？<br style=\"box-sizing: border-box;\"/>这门课不需要编程背景。所有你需要学习的这门课都已经包括了。</p><p>这门课需要什么资源？<br style=\"box-sizing: border-box;\"/>你需要稳定的网络连接以便观看视频，得到推荐的阅读材料，完成测试和考试。为了完成实验和大作业，你需要能够运行R（一个免费的数据计算和图形化软件）和RStudio（一个以R作为用户接口的集成开发环境）。<br style=\"box-sizing: border-box;\"/>或者，你可以选择在DataCamp.com搭建实验环境（不是项目），这是一个在线的交互学习平台。这个平台提供这门课所用到的交互版的R实验环境，它提供提示和安装反馈，可以促进学习过程。这些提示就像是对你的一个引导，及时反馈帮助你避免很多因为学习新的编程语言猜测隐晦的报错信息带来的沮丧。</p><p>R/RStudio可以在任何系统上运行吗？<br style=\"box-sizing: border-box;\"/>R可以在Windows、Mac Os和Ubuntu上运行。你可以在http://www.r-project.org下载R，在http://www.rstudio.com/上下载RStudio。一旦这门课开始，我们会提供怎么安装启动R和RStudio的视频。</p><p>完成这门课我需要学习R吗？<br style=\"box-sizing: border-box;\"/>你可以顺利通过某些课程内容而不需要使用R，但是你需要用R来做实验和大作业来争取获得优秀证书。</p><p>R可以在智能手机或者平板上运行吗？<br style=\"box-sizing: border-box;\"/>R可以在智能手机和平板上运行（看这里），但是这需要权限接触RStudio服务器，本门课不提供这些。RStudio服务器安装教程在RStudio的网站上提供，点击这里。</p><p><br/></p>', '', '铭飞科技', '/48\\4.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('5', '铭飞科技', '<p>课程介绍<br style=\"box-sizing: border-box;\"/>这门课程不仅适合考虑参加英语语言考试的学习者，也适合正在学习英语的学习者。本课程专注于雅思考试。雅思是全球最普及的为出国学习或者生活做准备的语言考试。全世界有9000个包括大学，公司，移民机构，职业机构等组织承认雅思考试。去年全球雅思考试数量超过了2百万。这门关于雅思的课程将引导你进入每一个雅思考试阶段：从阅读，写作，口语到听力。每阶段我们的老师和经验丰富的雅思辅导者都会提供考试指导。本课程开始时间为9月21日。</p><p><br style=\"box-sizing: border-box;\"/>课程目标<br style=\"box-sizing: border-box;\"/>课程结束后，你将<br style=\"box-sizing: border-box;\"/>(1) 熟悉所有的雅思考试部分<br style=\"box-sizing: border-box;\"/>(2) 获得一些有用的贴士，帮助你实现理想的<br style=\"box-sizing: border-box;\"/>雅思考试目标<br style=\"box-sizing: border-box;\"/>(3) 理解雅思考试的评估标准</p><p><br style=\"box-sizing: border-box;\"/>课程特色<br style=\"box-sizing: border-box;\"/>本课程由雅思考试机构－ 英国文化协会教授。英国文化协会在英语语言教学和评估方面有超过80年的历史。</p><p><br style=\"box-sizing: border-box;\"/>课程目标学习者<br style=\"box-sizing: border-box;\"/>本课程针对母语为非英语的学习者，难度在中级左右。</p><p><br style=\"box-sizing: border-box;\"/>关于课程更多信息<br style=\"box-sizing: border-box;\"/>我们的免费课程 &#39;了解雅思&#39; 目标在于给你更多的自信。通过了解雅思考试需要的核心语言技能，学习者能够清晰的了解雅思考试，同时在学习的过程中提高英语水平。我们希望这个六周的课程能够帮助你们建立对于雅思考试的信心。课程结束后，你们能在考试中发挥最好的水平。我们的视频课程介绍了雅思考试，提供准备考试的资料。这门课程对任何想学习英语，在国外工作或学习，准备英语语言考试的学习者都有帮助，特别是如果你想参加雅思考试的话。这门课程集中在考试的每一个部分（听力，阅读，口语和书写），以给你提供最好的机会获得最理想的雅思成绩。</p><p><br/></p>', '', '铭飞科技', '/48\\5.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('6', '铭飞科技', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">社会网络渗透于我们社会和经济生活的每一个角落。他们在传递就业机会信息中发挥了核心作用，对很多商品和服务的贸易也至关重要。他们在决定我们购买的何种产品、我们讲述何种语言、我们如何投票、我们是否决定犯罪、我们受到多少教育、我们获得专业成功的可能性。网络结构通过无数方式影响我们的生活，因此，理解下述问题就显得至关重要：社会网络结构如何影响行为，何种网络结构更容易在社会中出现，为何我们时常组织起来。借鉴社会学家、经济学家、计算机科学家、物理学家和数学家的研究成果，本门课程提供了社会和经济网络的一个概述和综合性研究。<br style=\"box-sizing: border-box;\"/>课程刚开始时，将是一些社会网络分析的经验背景、以及一些用于描述和度量网络概念的概述。接下来，课程将介绍一些网络如何形成的模型，包括随机网络模型（random network models）、战略形成模型（strategic formation models）和混合模型。然后我们讨论一些列网络如何影响行为的模型，包括传染（contagion）、扩散（diffusion）、学习（learning）、同行影响（peer influences）。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">课程大纲</span><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第一周：介绍、经验背景和定义</span><br style=\"box-sizing: border-box;\"/>社会网络的例子，以及他们的影响、定义、度量和属性——包括点度（Degrees）、半径（Diameters）、小世界（Small Worlds），弱联系和强联系（Weak and Strong Ties），点度分布（Degree Distributions）。【注1】<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第二周：背景、定义、度量（续）</span><br style=\"box-sizing: border-box;\"/>同质性（Homophily），动态（Dynamics），中心性度量：点度（Degree），中介中心性（Betweenness），接近中心性（Closeness），特征中心性（Eigenvector），Bonacich中心性（Katz-Bonacich的理论），E-R随机网络（Erdos and Renyi Random Networks）——阈值和相变。【注2】<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第三周：随机网络</span><br style=\"box-sizing: border-box;\"/>泊松随机网络（Poisson Random Networks），指数随机图模型（Exponential Random Graph Models），成长性随机网络（Growing Random Networks），优先连接（Preferential Attachment）和幂律（Power Laws），网络形成的混合模型。【注3】<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第四周：战略网络形成</span><br style=\"box-sizing: border-box;\"/>网络形成的博弈模型，连接模型（The Connections Model），激励与效率之间的冲突，动态分析，有向网络（Directed Networks），选择与机会的混合模型。【注4】<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第五周：网络的扩散</span><br style=\"box-sizing: border-box;\"/>经验背景，Bass模型，随机网络的传染，SIS模型，模拟网络拟合实际数据。<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第六周：网络的学习</span><br style=\"box-sizing: border-box;\"/>贝叶斯学习网络（Bayesian Learning on Networks），DeGroot学习模型，意见的趋同（Convergence of Beliefs），群体的智慧，网络位置的影响。【注5】<br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">第七周：网络的博弈</span><br style=\"box-sizing: border-box;\"/>网络博弈，同行影响：战略性补充与替代，网络结构与行为的关系，线性二次博弈，重复相互作用与网络结构。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">推荐背景</span><br style=\"box-sizing: border-box;\"/>本课程需要以下前置技能（^_^）:数学Lv1和统计学Lv1。我们假定参加的学生都已经非常熟悉相关的一些基本概念，包括线性代数，概率论（概率分布、期望、贝叶斯法则），统计学（假设检验），和一些简单计算（偏微分和积分）。除此以外，课程内都已包含。<br style=\"box-sizing: border-box;\"/>【注6】</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">推荐阅读</span><br style=\"box-sizing: border-box;\"/>所有解答测验和考试所需的定义概念都在视频课程中包含了。大部分课堂材料都包含在授课教授的书中（Jackson M O. Social and economic networks[M]. Princeton University Press, 2010. ），但这本书不是课堂必读读物。进一步的背景阅读，包括研究论文和课程中几个主题的综述，都在授课人的主页上（打开即可看见那张大脸：）。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">课程形式</span><br style=\"box-sizing: border-box;\"/>课程持续8周，每周会有视频提供，以及独立的问题集和数据练习。课程结束时，参加期末考试才可以拿到课程认证。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">问答：</span><br style=\"box-sizing: border-box;\"/>Q：完成课程后，能获得结课证书吗？<br style=\"box-sizing: border-box;\"/>A：能，成功完成课程的学习者将获得有教师签名的结课证明。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">============<br style=\"box-sizing: border-box;\"/>译注1：专有名词在国内有多种翻译，此处使用中文文献中使用最广的译法。参考：[英]约翰•斯科特,刘军译.社会网络分析法[M].重庆:重庆大学出版社,2007<br style=\"box-sizing: border-box;\"/>译注2：关于复杂网络的发展，1960提出随机网络模型（ER网络），1998年提出小世界模型，1999年提出无标度网络（Scale-free）模型（BA模型）。复杂网络分为随机网络、小世界网络和自相似网络。<br style=\"box-sizing: border-box;\"/>译注3：随机网络模型这章解决的是计算机模拟的网络与现实世界网络的不一致。通过不断改进模型来贴近现实。<br style=\"box-sizing: border-box;\"/>译注4：本章的内容是个体的收益成本随着网络连接的不同而不同。如Connection Model是一种成本与直接联系有关而网络间接收益依照连接距离增加而递减的算法。<br style=\"box-sizing: border-box;\"/>译注5：学习模型，即通过观察周围人是怎么做的，来调整自己的行为。<br style=\"box-sizing: border-box;\"/>译注6：本课程以社会网络建模为主要内容，即第二部分网络形式和第三部分网络与行为。在第一部分仅仅是简要介绍了后续建模所必须的简单概念，而缺乏对社会网络特征分析的介绍。推荐在社会网络有一定基础的社会学科高年级学生进行深入研究模型、或对数学模型熟悉的同学了解实际应用。本课程的简介（需翻墙）有说明，课程教授的是网络分析研究的方法，针对群体是硕士到博士，但是对感兴趣的同学入门也不难。</p><p><br/></p>', '', '铭飞科技', '/48\\6.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('7', '铭飞科技', '<p>科技和网络给我们生活、文化、社会带来的影响不断增强。最有利的证明就是你可以在世界各地上这门课，你需要的是过去的六十个年头依赖被设计、创造的科技工具，我们应理解网络科技是怎么运作的。这门课在互联网上公开，向你展示它是如何创造，谁创造的，以及它怎样运作。展示的过程中，我们将带领你采访开发互联网和网络技术的领军人物。</p><p><br style=\"box-sizing: border-box;\"/>你将学到什么？<br style=\"box-sizing: border-box;\"/>这门课程之后你会意识到Internet 和Web的出现并不是理所应当的。你会更好地了解现代社会面对的技术问题。还可以了解到Internet 和Web是个创新空间，在这里如何创新。如果你对课程材料很感兴趣，那么这对Web设计，Web开发、编程，甚至是网络管理是个不错的引入。至少，你会成为一个更聪明的网民。</p><p><br style=\"box-sizing: border-box;\"/>课程大纲<br style=\"box-sizing: border-box;\"/>Week 1:课程导论和电子计算的黎明（1940-1960）<br style=\"box-sizing: border-box;\"/>Week 2: 第一个因特网<br style=\"box-sizing: border-box;\"/>Week 3: 万维网<br style=\"box-sizing: border-box;\"/>Week 4:社会化和经济增长（1995-2000）<br style=\"box-sizing: border-box;\"/>Week 5: 因特网和数据包<br style=\"box-sizing: border-box;\"/>Week 6: 传输和安全<br style=\"box-sizing: border-box;\"/>Week 7: 网络应用<br style=\"box-sizing: border-box;\"/>Week 8: 信息保护<br style=\"box-sizing: border-box;\"/>Week 9: 同一认定<br style=\"box-sizing: border-box;\"/>期末考试</p><p><br style=\"box-sizing: border-box;\"/>背景知识<br style=\"box-sizing: border-box;\"/>这门课不需要什么提前准预备知识，也不要求变成。所以任何人都能来学，大家都应该学这门课。</p><p><br style=\"box-sizing: border-box;\"/>推荐阅读<br style=\"box-sizing: border-box;\"/>这门课提供所有需要的材料。<br style=\"box-sizing: border-box;\"/>Katie Hafner写的Where Wizards Stay Up Late: The Origins Of The Internet&nbsp;<br style=\"box-sizing: border-box;\"/>Tim Berners-Lee和Tim Berners-Lee写的Weaving the Web: The Original Design and Ultimate Destiny of the World Wide Web<br style=\"box-sizing: border-box;\"/>Robert Cailliau写的How the Web was Born: The Story of the World Wide Web&nbsp;<br style=\"box-sizing: border-box;\"/>这些有趣的补充材料从不同角度看发展历史。在课程中我们也会不断扩充阅读材料。</p><p><br style=\"box-sizing: border-box;\"/>课程形式<br style=\"box-sizing: border-box;\"/>这门课由5-20分钟的课程视频组成，其中包含互联网先驱的采访。课程视频将嵌入测试，这样可以帮助学生检测自己的学习。每周有家庭作业式的测验，同样帮助学生检测所学，深入探索。历史部分结束后有一个期中考试，课程最后有一个期末考试。</p><p>问答<br style=\"box-sizing: border-box;\"/>为什么要介绍历史？<br style=\"box-sizing: border-box;\"/>历史不只记录时间、地点、人名，那些考试中的答案。互联网和万维网的历史远不这么肤浅。这段历史中有英雄，也有恶棍。有亟待解决的工程难题。从创建者那里直接聆听这段历史中发生了什么，我们也将了解到人类怎样一起解决复杂、未知的难题。<br style=\"box-sizing: border-box;\"/>课程形式是什么样的？<br style=\"box-sizing: border-box;\"/>这门课由60%的课程和40%的网络领军人物的视频采访组成。视频在10-30分钟左右，在最后还提供评估材料。每周需要2-5个小时看这些材料，做补充阅读，和其他同学一起讨论，做作业。<br style=\"box-sizing: border-box;\"/>我需要课本吗？<br style=\"box-sizing: border-box;\"/>不需要。我们在网上提供所有需要的材料。<br style=\"box-sizing: border-box;\"/>我需要编程吗？<br style=\"box-sizing: border-box;\"/>不需要。<br style=\"box-sizing: border-box;\"/>有关时间，我可以自己分配吗？<br style=\"box-sizing: border-box;\"/>在一定程度上可以。在任何一周的课程里，你都可以看所有材料和评估，不管你在哪个时区。但是你需要和这门课同步，并在截止时间钱提交作业。所以你不能再最后一周补上所有的东西。我们希望你每周都能抽出时间学习这门课。<br style=\"box-sizing: border-box;\"/>在Twitter上这门课的标签是什么？<br style=\"box-sizing: border-box;\"/>#IHTS，搜索它，你可以看到大家对于这门课的讨论。<br style=\"box-sizing: border-box;\"/>我们可以联系到教授吗？<br style=\"box-sizing: border-box;\"/>教授一直在关注这门课。如果出现问题，在线办公时间或者及时解决大多数同学都遇到的问题。讨论区也是课程的重要部分，那里的学生可以解答大部分问题。课程指导也将在讨论区和大家交流。你可以在Twitter上关注指导老师@ drchuck 。<br style=\"box-sizing: border-box;\"/>我需要了解HTML吗？<br style=\"box-sizing: border-box;\"/>不需要。不过上过这门课后，希望你有学习HTML的打算。<br style=\"box-sizing: border-box;\"/>完成这门课后我可以获得证书吗？<br style=\"box-sizing: border-box;\"/>可以。凡是顺利完成这门课的学生都可以获得证书。</p><p><br/></p>', '', '铭飞科技', '/48\\7.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('8', '铭飞科技', '<p>学会如何像数学家那样思考——一种在几千年来慢慢形成的强大的认知方式。</p><p>这个课程的目标是帮助你培养一种有价值的思维能力—— 一种我们祖先在这3000年来慢慢培养出来的强大的思维方式。数学思维和做数学题不一样——至少和学校里学的数学不一样。在学校里，学数学主要是学习如何解决一些来自日常生活，科学，或者数学本身的有固定模式的题目。在学校数学中成功的关键是学会用固定的方法思考。与之相反，数学思维的关键之一是创造性思维——现代社会中一个很重要的能力。这个课程帮助学生养成这种重要的思维习惯。课程的主要对象是想以数学或者需要数学的学科为专业的大学一年级学生，和想学这些专业的高中三年级学生（对于美国来说是高中四年级）。这些人需要数学思维来成功的学好他们的专业。但是，数学思维也是一个很有价值的生活技能，任何17岁以上的人都可以从本课程中获益。</p><p><br style=\"box-sizing: border-box;\"/>课程大纲<br style=\"box-sizing: border-box;\"/>教师的欢迎和简介<br style=\"box-sizing: border-box;\"/></p><ol style=\"box-sizing: border-box; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\" class=\" list-paddingleft-2\"><li><p>入门材料</p></li><li><p>语言分析——逻辑连词</p></li><li><p>语言分析——暗示</p></li><li><p>语言分析——等价</p></li><li><p>语言分析——量词</p></li><li><p>处理量词</p></li><li><p>证明</p></li><li><p>有量词的证明</p></li><li><p>数论的基本原则</p></li><li><p>开始真正的分析</p></li></ol><p><br style=\"box-sizing: border-box;\"/></p><p>知识背景<br style=\"box-sizing: border-box;\"/>高中数学就够了。</p><p><br style=\"box-sizing: border-box;\"/>推荐阅读<br style=\"box-sizing: border-box;\"/>课程开始时会有一个阅读任务，提供一些背景知识。<br style=\"box-sizing: border-box;\"/>会有一个额外的阅读单元介绍基础的集合论，以方便那些不了解的学生。<br style=\"box-sizing: border-box;\"/>课程推荐一本教科书，Keith Devlin写的数学思维导论（《Introduction to Mathematical Thinking》），你可以在Amazon上以10美元（约61-62人民币）以下的低价买到实体书或者Kindle版本，但是这不是必需的。如果你想要了解大概的数学背景和数学在现代世界中所扮演的角色，可以看一看2012斯坦福秋季学期Devlin老师的数学概要课程（“Mathematics: Making the Invisible Visible&quot;)。你可以从iTunes University(Stanford)免费下载，也可以在YouTube上看（共五集），尤其可以关注讲座1和讲座4的前半部分。</p><p><br style=\"box-sizing: border-box;\"/>课程形式<br style=\"box-sizing: border-box;\"/>这个课持续十周，包括八周的讲座和两周的讨论与小组合作和一个需要在倒数第二周完成，在最后一周通过同学互评来打分的开卷的期末考试。教师会在指导视频中讲解上一周的作业。</p><p><br style=\"box-sizing: border-box;\"/>常见问题解答<br style=\"box-sizing: border-box;\"/>完成这个课程我能拿到证书吗？<br style=\"box-sizing: border-box;\"/>如果你完成了这个课程，你能拿到证书。那些在课程和期末考试中表现出色的学生能拿到表现出色证书。但是你无法通过这个课程获得斯坦福的学分。</p><p>课程的作业是什么呢？<br style=\"box-sizing: border-box;\"/>每个讲座之后，都会有一个作业（可下载的PDF格式，和讲座一同放出）。作业的目的是引导你理解你学的东西。作业的解答会在下一周指导视频中由教师给出。你可以在解答的指导下，综合其他学生的信息，为自己作业的打分。这些作业的目的是让你更好的理解和发展，而不是获得分数。我们强烈建议你和其他同学一起在任何时候讨论你的作业。这些作业（和自评分数）是本课程的核心。学习如何以数学的思维思考问题的唯一方法是不停试着这么做，把你的结果和专家的结果相比较并且和同学们一起讨论。</p><p>这个课程会有期末考试吗？<br style=\"box-sizing: border-box;\"/>在倒数第二周的开始，会有一个那一周要完成的开卷期末考试。完成的考试作业要用图片（或者扫描的PDF）上传。如果你足够熟悉Tex，你可以在网站上直接用键盘输入。最后一周会通过同学互评的方式评分。</p><p>这个课程有哪些等级？<br style=\"box-sizing: border-box;\"/>有两个：“完成”和“优异地完成”。你需要看所有的讲座并且完成所有的测试（包括讲座内嵌入的测试和每周测试）来获取“完成”的等级。能否获取”优异的完成：取决于你在每周测试中所拿到的分数和期末考试的结果。</p><p><br/></p>', '', '铭飞科技', '/49\\8.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('9', '铭飞科技', '<p>课程介绍<br style=\"box-sizing: border-box;\"/>这门课程不仅适合考虑参加英语语言考试的学习者，也适合正在学习英语的学习者。本课程专注于雅思考试。雅思是全球最普及的为出国学习或者生活做准备的语言考试。全世界有9000个包括大学，公司，移民机构，职业机构等组织承认雅思考试。去年全球雅思考试数量超过了2百万。这门关于雅思的课程将引导你进入每一个雅思考试阶段：从阅读，写作，口语到听力。每阶段我们的老师和经验丰富的雅思辅导者都会提供考试指导。本课程开始时间为9月21日。</p><p><br style=\"box-sizing: border-box;\"/>课程目标<br style=\"box-sizing: border-box;\"/>课程结束后，你将<br style=\"box-sizing: border-box;\"/>(1) 熟悉所有的雅思考试部分<br style=\"box-sizing: border-box;\"/>(2) 获得一些有用的贴士，帮助你实现理想的<br style=\"box-sizing: border-box;\"/>雅思考试目标<br style=\"box-sizing: border-box;\"/>(3) 理解雅思考试的评估标准</p><p><br style=\"box-sizing: border-box;\"/>课程特色<br style=\"box-sizing: border-box;\"/>本课程由雅思考试机构－ 英国文化协会教授。英国文化协会在英语语言教学和评估方面有超过80年的历史。</p><p><br style=\"box-sizing: border-box;\"/>课程目标学习者<br style=\"box-sizing: border-box;\"/>本课程针对母语为非英语的学习者，难度在中级左右。</p><p><br style=\"box-sizing: border-box;\"/>关于课程更多信息<br style=\"box-sizing: border-box;\"/>我们的免费课程 &#39;了解雅思&#39; 目标在于给你更多的自信。通过了解雅思考试需要的核心语言技能，学习者能够清晰的了解雅思考试，同时在学习的过程中提高英语水平。我们希望这个六周的课程能够帮助你们建立对于雅思考试的信心。课程结束后，你们能在考试中发挥最好的水平。我们的视频课程介绍了雅思考试，提供准备考试的资料。这门课程对任何想学习英语，在国外工作或学习，准备英语语言考试的学习者都有帮助，特别是如果你想参加雅思考试的话。这门课程集中在考试的每一个部分（听力，阅读，口语和书写），以给你提供最好的机会获得最理想的雅思成绩。</p><p><br/></p>', '', '铭飞科技', '/49\\9.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('10', '铭飞科技', '<p>这门课程介绍了起源于硅谷并在全世界出现的高科技企业的基础知识。你将会学习高科技企业家建立公司的过程。内容包括产生创意，寻找商业机会，收集人才资金资源，研究如何推销及策划创意及控制公司快速发展。在学习过程中学生组织成小组并以小组为单位研究创业项目。<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>这是第二次公开授课，上次有来自全世界的大约40000名学生参与了课程并进行了小组合作。表现优异的小组将会配备硅谷的导师，最好的小组的创意将会被推荐给投资者。上次课程的许多学生都建立了自己的创业公司并被定期指导。<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>根据课程内容，我们希望你学会如何<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>1。对如何从产生创意到寻找商业机会（高水平(high performing)学生将能够讨论替代方案模型的优缺点)<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>2。建立并验证一个寻找人才和资本的方案。<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>3。建立并验证一个如何推销及策划创业创意的商业模型。<br style=\"box-sizing: border-box; color: rgb(102, 102, 102); font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-size: 14px; line-height: 22.000020980835px; white-space: normal; background-color: rgb(255, 255, 255);\"/>4。建立一个在创业过程中如何将问题转化成机会的思维过程，这种思维模式也适用于大型公司及其他环境。</p>', '', '铭飞科技', '/49\\10.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('11', '铭飞科技', '<p>环境工程、市政工程等专业的主干专业课，主要讲述水和废水处理中主要的物化和生物处理方法的基本原理、工艺构成、运行特点、工艺计算方法以及部分工程实例。该课程是从事水处理技术研究、设计以及运行管理人员的必修课。</p><p>课程简介<br style=\"box-sizing: border-box;\"/>《水处理工程》是环境工程、环境科学、市政工程等相关专业的主干专业课。本课程旨在向学生全面讲授水和废水处理中主要的物化和生物处理技术单元的基本原理和特点、工艺的基本计算方法和应用范围、主要构筑物的构成和运行特点、典型的水与废水处理工艺以及相关技术的国内外最新研究进展。整个课程分为两篇：第一篇—水与废水物化处理的原理与工艺，主要介绍各种物化处理单元，包括：混凝、沉淀与澄清、气浮、过滤、消毒、氧化还原、膜分离和离子交换；第二篇为废水生物处理的原理与工艺，主要讲述废水的好氧和厌氧生物处理工艺、生物脱氮除磷工艺、废水的天然处理工艺以及污泥的处理与处置。</p><p><br style=\"box-sizing: border-box;\"/>【FAQ】<br style=\"box-sizing: border-box;\"/>请问教材和参考书是什么？<br style=\"box-sizing: border-box;\"/>教材：1. 张晓健、黄霞：水与废水物化处理的原理与工艺，清华大学出版社, 2011；2. 张自杰：排水工程（下册）（第四版），中国建筑工业出版社，2000；参考书：1. 严煦世、范瑾初：给水工程（第四版），中国建筑工业出版社，1999；2. Wastewater Engineering: Treatment and Reuse. Fourth Edition. Metcalf &amp; Eddy, Inc., 2003(清华大学出版社影印版)。</p><p><br/></p>', '', '铭飞科技', '/49\\11.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('12', '铭飞科技', '<p>好奇心是人类最重要的特征之一。它使我们能够把未知变成已知，打破壁垒，启发和阐明生活的各个方面，包括日常爱好，也包括对天空中的星星的解释。我们获得的许多值得骄傲的成就，都归因于我们与生俱来的探索欲望。本课程将帮助你培养自己的好奇心，并利用它来以学术的方式开始自己的研究项目。</p><p><br style=\"box-sizing: border-box;\"/>本课程是面向正在进行或计划进行某项学术研究的任何人员，你的研究内容可以是专题项目资格，国际文凭专题论文，课件，或者某项独立奖学金。<br style=\"box-sizing: border-box;\"/>本课程由热衷研究的学者开发、讲授，将支持你研究过程的每一步，从提出假设、寻找资源，到撰写论文、发表自己的研究成果。<br style=\"box-sizing: border-box;\"/>课程注重实际动手能力，你将有机会与来自世界各地的其他研究人员分享你的想法，收到学习同伴关于你的研究议案的反馈，审查和评论其他研究人员的工作，从而建立一个支持志同道合的充满好奇的学习者的社区。<br style=\"box-sizing: border-box;\"/>如果你想加入参与课程，并通过社交网络加入关于本课程的讨论</p><p><br style=\"box-sizing: border-box;\"/>先修要求<br style=\"box-sizing: border-box;\"/>没有特别的课程要求，只需要好奇心，以及展开一些学术研究的热情。<br style=\"box-sizing: border-box;\"/>值得注意的是，参加本次课程，你将有机会让其他学习者评审你的工作内容，同样的，你也将评审他人的作业。虽然不强制要求参与这类活动，积极参与无疑将增强你的体验。</p><p><br/></p>', '', '铭飞科技', '/37\\12.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('13', '铭飞科技', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">推理是非常重要的。这门课程将教会你如何正确推理。你将会学到如何理解并评断他人的论据，以及如何基于感兴趣的话题构造自己的论据。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">课程大纲</span><br style=\"box-sizing: border-box;\"/>第一部分：如何分析论据（即确定论据，并将其简化、归纳以便突出联系彼此的结构）<br style=\"box-sizing: border-box;\"/>第一周：如何确认一条论据<br style=\"box-sizing: border-box;\"/>第二周：如何分解一条论据<br style=\"box-sizing: border-box;\"/>第三周：如何重塑一条论据</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第二部分：演绎论证的评断（即其前提与结论之间是否存在有效关联）<br style=\"box-sizing: border-box;\"/>第四周：命题逻辑及真值表<br style=\"box-sizing: border-box;\"/>第五周：分类逻辑及三段论</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第三部分：归纳论证的评断（即其前提是否提供了结论所需要的足够证据）<br style=\"box-sizing: border-box;\"/>第六周：归纳论证论据的定义<br style=\"box-sizing: border-box;\"/>第七周：因果论证<br style=\"box-sizing: border-box;\"/>第八周：归纳概率与决断</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\">第四部分：一团糟的论据（即常见的容易犯的错误）<br style=\"box-sizing: border-box;\"/>第九周：谬误之模糊与歧义<br style=\"box-sizing: border-box;\"/>第十周：谬误之相关性谬论及空白性谬论<br style=\"box-sizing: border-box;\"/>第十一周：如何反驳一条论据<br style=\"box-sizing: border-box;\"/>第十二周：联系日常的学以致用</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">先修知识</span><br style=\"box-sizing: border-box;\"/>这门课非常适合大学新生或者高年级中学生，或者（事实上是）任何对此感兴趣的人。因而我们除了要求学生具备相关的英语知识，再无其他。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">课程相关教材</span><br style=\"box-sizing: border-box;\"/>注册该课程的学生将能在课程期间免费阅读相关章节，这些都是由授课教师为课程精心选择的。你可以通过Chegg网站上的电子阅读器来阅读教材的Coursera精简电子版。如果你选择了“购买此书”，你可以买到这本教材的完整版，而不限于本课程中涉及的章节。这是由Coursera与出版商及Chegg联合发起的。<br style=\"box-sizing: border-box;\"/>圣智优选：掌握论据<br style=\"box-sizing: border-box;\"/>作者：Sinnott-Armstrong, Walter, Sinnott-Armstrong, Walter (WalterSinnott-Armstrong), Fogelin, Robert J.<br style=\"box-sizing: border-box;\"/>出版商：圣智学习出版集团</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">推荐阅读</span><br style=\"box-sizing: border-box;\"/>期望学习更多详细例子和附加练习，或是进一步深入了解这些话题的学生可以参看《掌握论据：非正式逻辑导论》<br style=\"box-sizing: border-box;\"/>你可以在这里找到电子版。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">授课形式</span><br style=\"box-sizing: border-box;\"/>每一周的课程将会提供一些教学视频，这些视频可以独立观看亦可以当作三个关联讲座。每段视频后会要求学生完成小测验（确保你理解了课程内容），另外还有长些中期测验。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">常见问</span><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: 700; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\">题解答</span><br style=\"box-sizing: border-box;\"/>1. 完成这门课后能获得证书吗？<br style=\"box-sizing: border-box;\"/>是的。成功完成这门课的学生将会收到授课教师署名的认证证书。<br style=\"box-sizing: border-box;\"/>2. 这门课需要我做什么准备？<br style=\"box-sizing: border-box;\"/>一台能上网的电脑。<br style=\"box-sizing: border-box;\"/>3. 这门课将带给我最酷的事？<br style=\"box-sizing: border-box;\"/>用“说话模棱两可的人”这样的添堵称呼来代表那些企图用糟糕的论据来愚弄你的人。<br style=\"box-sizing: border-box;\"/>4. 别人怎么评价这门课？<br style=\"box-sizing: border-box;\"/>这里有一些来自于已经学过这门课的学生的评语：<br style=\"box-sizing: border-box;\"/>“我很感谢这门课的两位老师。这课相当有趣，具有启发性，并且我非常喜欢世界各地不同观点、不同背景人们的加入。”<br style=\"box-sizing: border-box;\"/>“课程刚开始的一两周内，我一度沉浸在不知是对某些概念还是对某次家庭作业的思考中；然后我突然意识到：‘也许这才是真正的思考？’。事实上，我来自一个思考氛围浓厚的家庭；我自己也一直在思考关于人生和职业的事…但是不知为何我意识到，尽管我过去一直在思考，但类似这类的思考还真是不怎么多见…所以，非常感谢！”<br style=\"box-sizing: border-box;\"/>“Dr. Sinott-Armstrong和Dr. Neta之间的融洽关系以及他们的幽默感使得这门课引人入胜，趣味横生。他们毫不吝啬地展现了对这个话题的激情，并且在解释时充满耐心。”</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\"><br style=\"box-sizing: border-box;\"/>另外还有一些近期的文章和新闻提到了这门课，请戳链接：<br style=\"box-sizing: border-box;\"/>1.Raleigh News and Observer Article - January 20, 2013<br style=\"box-sizing: border-box;\"/>（）<br style=\"box-sizing: border-box;\"/>2.&quot;How Free Online Courses are Changing the Traditional Liberal Arts Education&quot; PBS Newshour - January 8, 2013（）</p><p><br/></p>', '', '铭飞科技', '/37\\13.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('14', '铭飞科技', '<p>* 本课程全部视频可直接在站内播放，感谢@YC创业课中文社区&nbsp;提供资源，及课程视频中文翻译工作</p><p><br style=\"box-sizing: border-box;\"/>通过本课程，免费跟随世界级专家那里学习如何开始创业。<br style=\"box-sizing: border-box;\"/>CS183B是斯坦福大学的一门课，这是专门为想创业的人设计的一门独立的商业课程，一共有20个课程视频，有的是由一个讲师讲授，有的是两个讲师，还有的是一个小组，所有课程视频总长为1000分钟。</p><p><br style=\"box-sizing: border-box;\"/>课程内容包括：如何提出想法并对其进行评价，如何得到用户并扩大用户人数，如何做销售和市场营销，如何聘请人才，如何筹集资金，以及公司的文化、运作与管理，企业策略等等。</p><p><br style=\"box-sizing: border-box;\"/>我们不能教给创业者使其成功创业的所有知识，但我认为我们可以教给其很大一部分知识帮助其成功创业。经过一番努力，我们请来了过去9年中在Y Combinator晚宴上最好的演说家，并以最有可能产生效果的方式对其进行安排。</p><p><br style=\"box-sizing: border-box;\"/>我们这样做是因为我们相信帮助更多人更好地创业对每个人都有利。这即使是对那些不想创业的人来说也是非常有价值的。</p><p><br style=\"box-sizing: border-box;\"/>这样的谈话确实帮助了YCombinator的建立者创建了他们的公司，希望你也能在此获得有价值的东西！</p><p><br style=\"box-sizing: border-box;\"/></p><p>课程安排<br style=\"box-sizing: border-box;\"/>作业在该网站上提交。<br style=\"box-sizing: border-box;\"/>你可以在Q&amp;A板块向特邀嘉宾提问问题。<br style=\"box-sizing: border-box;\"/>从iTunes U上下载该课程视频将要延迟2至3天。<br style=\"box-sizing: border-box;\"/></p><table><tbody style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\" class=\"firstRow\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">演讲者<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">主题<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Sam Altman,&nbsp;President, Y Combinator<br style=\"box-sizing: border-box;\"/>Dustin Moskovitz,&nbsp;Cofounder, Facebook, Cofounder, Asana, Cofounder, Good Ventures<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle; word-break: break-all;\">欢迎词<br style=\"box-sizing: border-box;\"/>理念，产品，团队和管理（一）<br style=\"box-sizing: border-box;\"/>为什么要创业？<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Sam Altman,&nbsp;President, Y Combinator<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">理念，产品，团队和管理（二）<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Paul Graham,&nbsp;Founder, Y Combinator<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">创业中的反直觉，以及<br style=\"box-sizing: border-box;\"/>如何获得想法<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Adora Cheung,&nbsp;Founder, Homejoy<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">产品构建，与用户交谈，并获得越来越多的用户<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Peter Thiel,&nbsp;Founder, Paypal, Founder, Palantir, and Founder, Founders Fund<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">企业战略与垄断理论<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Alex Schultz,&nbsp;VP Growth, Facebook<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">实现增长<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Kevin Hale,&nbsp;Founder, Wufoo and Partner, Y Combinator<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">如何构建用户喜爱的产品（一）<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">TBA<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Marc Andreessen,&nbsp;Founder, Andreessen Horowitz and Founder, Netscape<br style=\"box-sizing: border-box;\"/>Ron Conway,&nbsp;Founder, SV Angel<br style=\"box-sizing: border-box;\"/>Parker Conrad,&nbsp;Founder, Zenefits<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">如何筹集资金<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Alfred Lin,&nbsp;Former COO, Zappos and Partner, Sequoia Capital<br style=\"box-sizing: border-box;\"/>Brian Chesky,&nbsp;Founder, Airbnb<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">企业文化与建立团队（一）<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Patrick and John Collison,&nbsp;Founders, Stripe<br style=\"box-sizing: border-box;\"/>Ben Silbermann,&nbsp;Founder &amp; CEO, Pinterest<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">企业文化与建立团队（二）<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Aaron Levie,&nbsp;Founder, Box<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">销售与市场营销<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Reid Hoffman,&nbsp;Partner, Greylock Ventures and Founder, LinkedIn<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">待定<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Keith Rabois,&nbsp;Partner, Khosla Ventures<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">如何运行公司<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Ben Horowitz,&nbsp;Founder, Andreessen Horowitz, and Founder, and Opsware<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">如何管理公司<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Marissa Mayer,&nbsp;CEO, Yahoo<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">待定<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Hosain Rahman,&nbsp;Founder, Jawbone<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">如何构建用户喜爱的产品（二）<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Kirsty Nathoo and Carolynn Levy,&nbsp;Partners, Y Combinator<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">运行机制—法律，财务，人力资源等<br style=\"box-sizing: border-box;\"/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">TBA<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td></tr><tr style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-weight: inherit; font-stretch: inherit; line-height: inherit; vertical-align: baseline;\"><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\"><br/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">Sam Altman,&nbsp;President, Y Combinator<br style=\"box-sizing: border-box;\"/></td><td style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; font-family: inherit; font-style: inherit; font-variant: inherit; font-stretch: inherit; line-height: inherit; vertical-align: middle;\">最终思考及后期咨询<br/><br style=\"box-sizing: border-box;\"/></td></tr></tbody></table><p><br/></p>', '', '铭飞科技', '/37\\14.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('15', '铭飞科技', '<p>数学的重要特征是它的抽象性，这一特征是令人生畏的。但也正是这一特征可以使人们在繁杂的世界中逐步懂得宇宙深处伟大设计图的语言；可以用理性的思维达到超出人类感官所及的宇宙的根本。而这一切正是数学的魅力所在，也是数学在人类历史上起着其它科学不可替代作用的重要原因。但这也是很多学生畏惧数学或学习数学的困难所在。</p><p>本课程针对这一情况，试图和学生一起从思想上重走一遍前辈们走过的路，作一次轻松的数学之旅。在这一旅途中我们不断揭示一些概念和数学思想形成的过程和历史，理解数学抽象的必要性和魅力，真实体会数学抽象所表现出的人类心智的荣耀，潜移默化地从中培养数学抽象的能力。并试图就一些简单的数学例子介绍数学抽象的一些特点，并试图就学习数学时，如何克服抽象带来的困难谈一些看法。主讲人有信心使这门课程成为一次轻松的“抽象”旅游。并希望对学生的数学课程的学习和数学思维的形成，在心理和心智上都有所帮助。<br style=\"box-sizing: border-box;\"/>好的旅游不是旅游点的累积，而是心与自然、心与心的交流。我们的“数学之旅”不期待你知道了多少数学概念，而期待你开始对数学的抽象有了体会，意识到数学的抽象其实不“抽象”，感受到数学思维所表现出的人类心智的荣耀。</p><p><br style=\"box-sizing: border-box;\"/>授课大纲<br style=\"box-sizing: border-box;\"/>第1周<br style=\"box-sizing: border-box;\"/>第一章数学是什么<br style=\"box-sizing: border-box;\"/>第一章数学思维<br style=\"box-sizing: border-box;\"/>第一章 数学学习<br style=\"box-sizing: border-box;\"/>第一章知识点复习、作业、习题等</p><p>第2周<br style=\"box-sizing: border-box;\"/>第二章从圆的面积谈起<br style=\"box-sizing: border-box;\"/>第二章牛顿和莱布尼兹的微积分<br style=\"box-sizing: border-box;\"/>第二章分析的严格化<br style=\"box-sizing: border-box;\"/>第二章知识点复习、作业、习题等</p><p>第3周<br style=\"box-sizing: border-box;\"/>第三章距离与范数<br style=\"box-sizing: border-box;\"/>第三章线性结构<br style=\"box-sizing: border-box;\"/>第三章空间种种<br style=\"box-sizing: border-box;\"/>第三章知识点复习、作业、习题等</p><p>第4周<br style=\"box-sizing: border-box;\"/>第四章布劳威尔不动点原理<br style=\"box-sizing: border-box;\"/>第四章无穷维的不动点原理<br style=\"box-sizing: border-box;\"/>第四章经济学的应用<br style=\"box-sizing: border-box;\"/>第四章知识点复习、作业、习题等</p><p>第5周<br style=\"box-sizing: border-box;\"/>第五章 Fourier定理<br style=\"box-sizing: border-box;\"/>第五章 Fourier分析的应用<br style=\"box-sizing: border-box;\"/>第五章 Fourier分析的发展<br style=\"box-sizing: border-box;\"/>第五章知识点复习、作业、习题等</p><p>第6周<br style=\"box-sizing: border-box;\"/>第六章混沌<br style=\"box-sizing: border-box;\"/>第六章分形<br style=\"box-sizing: border-box;\"/>第六章“混沌的游戏”<br style=\"box-sizing: border-box;\"/>第六章 知识点复习、作业、习题等</p><p><br style=\"box-sizing: border-box;\"/>先修知识<br style=\"box-sizing: border-box;\"/>有一定的微积分和线性代数基础的大学生。</p><p><br style=\"box-sizing: border-box;\"/>参考资料<br style=\"box-sizing: border-box;\"/>1. 数学及其历史，John Stillwell（袁向东，冯绪宁译），高等教育出版社，ISBN：<br style=\"box-sizing: border-box;\"/>2. 现代世界中的数学，Morris Kline（齐民友译）上海教育出版社, ISBN：<br style=\"box-sizing: border-box;\"/>3. 数学与文化，齐民友, 湖南教育出版社, ISBN：<br style=\"box-sizing: border-box;\"/>4. 混沌，开创新科学，詹姆斯 格莱克，（张淑誉译），上海译文出版社<br style=\"box-sizing: border-box;\"/>5. 诺贝尔经济学奖与数学，史树中，清华大学出版社, ISBN：</p><p><br style=\"box-sizing: border-box;\"/>授课形式<br style=\"box-sizing: border-box;\"/>学生通过观看教学视频、学习教材课件（PPT），结合完成作业练习以及测试的形式进行自学。<br style=\"box-sizing: border-box;\"/>鼓励学生通过论坛与同学和老师积极交流学习经验和体会，帮助其掌握和巩固所学知识。</p><p><br style=\"box-sizing: border-box;\"/>【FAQ】<br style=\"box-sizing: border-box;\"/>Q:课程评分标准是什么？<br style=\"box-sizing: border-box;\"/>A：期末考试成绩占总成绩的70%；作业及测验占总成绩的30%。<br style=\"box-sizing: border-box;\"/>Q:课程通过标准是什么？<br style=\"box-sizing: border-box;\"/>A:总成绩 60 分以上者，满分为100分</p><p>这门课曾于2013年12月在Coursera开课，课程链接：https://www.coursera.org/course/sjtuma153</p><p><br/></p>', '', '铭飞科技', '/37\\15.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('16', 'ARCHITECTURAL DESIGN', '<p style=\"box-sizing: border-box; font-family: novecento_sans_widenormal, HiraginoSansGB-W3, STHeiti, &#39;Microsoft JhengHei&#39;, &#39;Microsoft YaHei&#39;, tahoma; color: rgb(102, 102, 102); position: relative; font-size: 14px; margin-top: 0px; margin-bottom: 24px; line-height: 25.2px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"line-height: 25.2px;\">对于一个空间来说，设计的生命力不仅体现在当下，更孕育着未来的成长。</span><br/></p><p style=\"box-sizing: border-box; font-family: novecento_sans_widenormal, HiraginoSansGB-W3, STHeiti, &#39;Microsoft JhengHei&#39;, &#39;Microsoft YaHei&#39;, tahoma; color: rgb(102, 102, 102); position: relative; font-size: 14px; margin-top: 0px; margin-bottom: 24px; line-height: 25.2px; white-space: normal; background-color: rgb(255, 255, 255);\">筑邦臣把建筑设计看作是体现人类精神的一面镜子。<br style=\"box-sizing: border-box;\"/>一个好的设计可以经受起时间的考验，与它的主人相伴、成长，这样的建筑才是有“生命”的建筑。</p><p style=\"box-sizing: border-box; position: relative; margin-top: 0px; margin-bottom: 24px;\">出于对设计的热爱及对内心价值观的遵循，筑邦臣公司对每一件作品都致力于追求完美。筑邦臣能够为您提供原创、富有创意的建筑设计方案，不论是其建筑作品还是产品设计，都很有文化气息。建筑的灵魂,是人与环境的联系,是人类艺术与物质文明的结合。建筑设计中挑战人们既定的建筑价值观和被捆缚的想象力，在有限中创造无限，寻找变化的可能性。</p><p style=\"box-sizing: border-box; position: relative; margin-top: 0px; margin-bottom: 24px;\">筑邦臣力求“打造智能建筑”，在中国空间设计界享誉盛名，设计中将全智能化系统融入，运用科技手段勾勒出全新的建筑文化，带给人们绿色、便捷的空间享受。成功作品有BRI高层办公、方圆集团小区、TEDA公寓建筑、金隅嘉业楼盘、中粮地产小区、慧能纪念馆、金科地产小区景观等。</p><p><br/></p>', 'f,', '超越了传统的建筑领域划分，涵盖了建筑设计、室内设计、工程管理、陈设设计、照明设计及导视设计专业。</br> 					我们相信成功一定源于紧密的交流与协作。', '/50\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('17', '', null, 'f,', '', '/51\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('18', '', null, 'f,', '', '/15\\18.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('19', '铭飞科技', '<p>了解生命的起源和演化，寻找地球以外的生物。</p><p><br style=\"box-sizing: border-box;\"/>课程概述<br style=\"box-sizing: border-box;\"/>两千年多以前，古希腊人曾探究过宇宙中是否存在其他世界。现在，人们正通过实验来验证这个问题。这门课程由英国爱丁堡大学的天体生物学中心提供，旨在介绍天体生物学，也是MOOC首次探索此类课题。这门课程将探讨地球上生物的起源和演化，以及地球以外存在生命的可能性。</p><p>“天体生物学”解答了人们普遍感兴趣和十分关注的问题，如：地球上的生命从何而来？生命的出现是一个必然过程吗，宇宙中到处存在生命吗？天体生物学是一门跨学科的科学，涉及到如天体物理学、生物学、地学和化学等不同领域。</p><p>这门课程中，我们将探讨我们所了解的有关生命在地球极端环境中的存活能力。我们将着眼于生命起源的不同假设，以及一些探寻我们所在的太阳系中和环绕遥远恒星旋转的行星上生命的使命。我们将讨论地球上的一些极端环境，这有助于我们理解生命的极限以及生命如何适应这些极端条件。我们将探索外星智能生物存在的可能性以及相关探测的影响。这门课程将为天体生物学提供学习基础，并向学生介绍不同科学领域的相关概念。</p><p><br style=\"box-sizing: border-box;\"/>课程大纲<br style=\"box-sizing: border-box;\"/>第一周：生命是什么，以及生命该如何定义？我们对生命的起源了解哪些内容，以及对于地球上生命的起源，当下存在哪些假设？<br style=\"box-sizing: border-box;\"/>第二周：在生命诞生时，早期地球的环境是怎样的，以及我们对于地球形成初期的生命了解哪些内容？生命是如何演化以适应极端环境存活的？地球上生命的主要演化转变时期是什么？<br style=\"box-sizing: border-box;\"/>第三周：对于我们太阳系中的其他行星上的生命有哪些展望，以及我们如何去寻找？一颗行星宜居的必要条件有哪些？<br style=\"box-sizing: border-box;\"/>第四周：我们如何寻找环绕遥远恒星旋转的类地行星，以及我们如何探测其上的生命？<br style=\"box-sizing: border-box;\"/>第五周：地球以外存在智能生物的可能性有多大？我们如何与地外文明接触，以及这将对社会造成什么影响？谁将代表地球？</p><p><br style=\"box-sizing: border-box;\"/>先修知识<br style=\"box-sizing: border-box;\"/>无任何专业背景要求。</p><p><br style=\"box-sizing: border-box;\"/>参考资料<br style=\"box-sizing: border-box;\"/>关于天体生物学的书籍种类繁多。这些书籍不是课程的必读书目，而且并非课程专用。这仅是我们建议阅读的有用书籍中的一部分。<br style=\"box-sizing: border-box;\"/></p><ul style=\"box-sizing: border-box; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\" class=\" list-paddingleft-2\"><li><p>《<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9781421400969\">天体生物学：简介</a>》（<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9781421400969\">Astrobiology: A Brief Introduction</a>），作者为Kevin W. Plaxco和Michael Gross。很好地介绍了天体生物学的基本内容。</p></li><li><p>《天体生物学的简短介绍》（A Short Introduction to Astrobiology），作者为David Catling；</p></li><li><p>《宇宙中的生命：基础教程》（Life in the Universe: A Beginners Guide），作者为Lewis Dartnell，这两本书籍也是很好的阅读选择。</p></li><li><p>《<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780521531023\">行星和生命：新兴的天体生物学</a>》（<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780521531023\">Planets and Life: The Emerging Science of Astrobiology</a>），作者为W. Sullivan和J. Baross，剑桥大学出版社。价格稍贵，但对天体生物学内容覆盖相当全面</p></li><li><p>《<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9781107600935\">天体生物学入门</a>》（<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9781107600935\">An Introduction to Astrobiology</a>），作者为D. A. Rothery、I. Gilmour和M.A. Sephton，Open University。很好的总结了天体生物学中的很多课题。</p></li></ul><p>这门课程的授课教师也创作了若干与天体生物学相关的书籍，你可以选择性阅读，不做硬性要求。<br style=\"box-sizing: border-box;\"/></p><ul style=\"box-sizing: border-box; padding: 0px; border: 0px; font-family: &#39;Microsoft YaHei&#39;, &#39;WenQuanYi Micro Hei&#39;, SimHei, tahoma, sans-serif; font-stretch: inherit; line-height: 22.000020980835px; font-size: 14px; vertical-align: baseline; color: rgb(102, 102, 102); white-space: normal; background-color: rgb(255, 255, 255);\" class=\" list-paddingleft-2\"><li><p>《<a href=\"http://www.amazon.com/Impossible-Extinction-Catastrophes-Supremacy-Microbial/dp/0521817366/ref=sr_1_1?ie=UTF8&qid=1357244398&sr=8-1&keywords=impossible%2Bextinction&tag=coursera-course98-20\">不可能的灭绝：自然灾难和微生物世界的统治地位</a>》（<a href=\"http://www.amazon.com/Impossible-Extinction-Catastrophes-Supremacy-Microbial/dp/0521817366/ref=sr_1_1?ie=UTF8&qid=1357244398&sr=8-1&keywords=impossible%2Bextinction&tag=coursera-course98-20\">Impossible Extinction: Natural Catastrophes and the Supremacy of the Microbial World</a>），作者为C S Cockell。一本介绍地球上微生物的顽强生命力的书籍。</p></li><li><p>《<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780521729536\">地球生命系统导论</a>》（<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780521729536\">An Introduction to the Earth-Life System</a>），作者为CS Cockell、R Corfield、N. Edwards和N. Harris。一本讲述生命和行星地球的共同演化过程的教科书。</p></li><li><p>《<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780230007529\">地球上的太空：寻找外星生物，拯救我们的世界</a>》（<a href=\"http://chggtrx.com/click.track?CID=267582&AFID=301076&ADID=1088031&SID=astrobio&isbn_ean=9780230007529\">Space on Earth: Saving Our World by Seeking Others</a>），作者为C S Cockell。一本介绍地球环境和太空探索之间联系的书籍。</p></li></ul><p><br style=\"box-sizing: border-box;\"/></p><p>授课形式<br style=\"box-sizing: border-box;\"/>这门课程包含一系列教学视频，时长为10至15分钟，每周共计1至1.5小时。</p><p><br style=\"box-sizing: border-box;\"/>常见问题解答<br style=\"box-sizing: border-box;\"/>-&nbsp;完成这门课程后，我会获得证书吗？<br style=\"box-sizing: border-box;\"/>是的。凡是顺利修完这门课程的学生将获得授课教师签署的完成声明。</p><p>-&nbsp;完成这门课程，我会获得爱丁堡大学的学分吗？<br style=\"box-sizing: border-box;\"/>不会。完成声明不包含在大学的正式认证中。但是，这门课程有助于你向高等教育机构或潜在雇主展示你在所学专业中的先前学习成果和兴趣所在。</p><p>-&nbsp;我需要为这门课程准备什么？<br style=\"box-sizing: border-box;\"/>无需做准备。</p><p>-&nbsp;这门课程的学习收获是什么，我为什么要修读？<br style=\"box-sizing: border-box;\"/>你将了解对地球以外生命的探寻过程。</p><p><br/></p>', '', '铭飞科技', '/22\\19.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('20', '铭飞科技', '<p>中国考古学是以往100年中发展最为迅速的领域之一，大批珍贵文物的出土，不断刷新人们对文化中国的认识。本课程以4-6件（组）精品文物作引子，将学术界探索中华文明的过程作为线索，介绍古代中国在造船、玉器等诸多领域的杰出成就，其中不乏学术前沿的考古发现与研究成果，内容精彩纷呈，雅俗共赏，学生可以藉此获得对文化中国全方位的、直观而深入的认识。</p><p>课程章节<br style=\"box-sizing: border-box;\"/>泉州宋船与中国古代造船技术<br style=\"box-sizing: border-box;\"/>文献所见原始渡河工具<br style=\"box-sizing: border-box;\"/>绰墩山出土的渡河浮木<br style=\"box-sizing: border-box;\"/>我国古代舟船的遗迹<br style=\"box-sizing: border-box;\"/>中国古船制造的原创性技术<br style=\"box-sizing: border-box;\"/>泉州宋船的基本情况<br style=\"box-sizing: border-box;\"/>宋船上的遗物<br style=\"box-sizing: border-box;\"/>船的主体结构<br style=\"box-sizing: border-box;\"/>多层船板叠合工艺<br style=\"box-sizing: border-box;\"/>宋船上的水密隔舱<br style=\"box-sizing: border-box;\"/>宋船的建造<br style=\"box-sizing: border-box;\"/>宋明航海史小结<br style=\"box-sizing: border-box;\"/>作业</p><p>良渚“琮王”与中国史前时代的玉文化<br style=\"box-sizing: border-box;\"/>玉的定义<br style=\"box-sizing: border-box;\"/>新石器时代的中国古玉<br style=\"box-sizing: border-box;\"/>古玉王国良渚<br style=\"box-sizing: border-box;\"/>鬼斧神工的良渚玉器<br style=\"box-sizing: border-box;\"/>良渚“神徽”解读<br style=\"box-sizing: border-box;\"/>良渚典型器介绍<br style=\"box-sizing: border-box;\"/>含山玉器：史前制玉的又一奇迹<br style=\"box-sizing: border-box;\"/>中国古代的玉文化<br style=\"box-sizing: border-box;\"/>作业</p><p>贾湖骨笛与中国古代七声音阶的起源<br style=\"box-sizing: border-box;\"/>先秦文献所见七声音阶<br style=\"box-sizing: border-box;\"/>史前陶埙的音阶序列<br style=\"box-sizing: border-box;\"/>周代有七声音阶：曾侯乙编钟作证<br style=\"box-sizing: border-box;\"/>河南舞阳贾湖遗址概况<br style=\"box-sizing: border-box;\"/>贾湖骨笛的鉴定<br style=\"box-sizing: border-box;\"/>贾湖骨笛的年代与分期<br style=\"box-sizing: border-box;\"/>贾湖骨笛的制作技巧<br style=\"box-sizing: border-box;\"/>贾湖骨笛的未解之谜<br style=\"box-sizing: border-box;\"/>上古时代为何偏爱五声音阶<br style=\"box-sizing: border-box;\"/>作业</p><p>正统针灸铜人与中国古代的经络学说<br style=\"box-sizing: border-box;\"/>针、灸、经络溯源<br style=\"box-sizing: border-box;\"/>扁鹊与仓公的针灸医术<br style=\"box-sizing: border-box;\"/>《内经》与针灸<br style=\"box-sizing: border-box;\"/>马王堆帛书、张家山汉简中的经络文献<br style=\"box-sizing: border-box;\"/>明代正统针灸铜人<br style=\"box-sizing: border-box;\"/>针灸对当今世界的影响<br style=\"box-sizing: border-box;\"/>作业</p><p>殷墟甲骨与中国早期的文字<br style=\"box-sizing: border-box;\"/>甲骨的发现<br style=\"box-sizing: border-box;\"/>殷墟甲骨的发掘与研究<br style=\"box-sizing: border-box;\"/>甲骨占卜与刻辞<br style=\"box-sizing: border-box;\"/>甲骨文中的六书<br style=\"box-sizing: border-box;\"/>作业</p><p><br style=\"box-sizing: border-box;\"/>磁山石磨盘与中国古代农业文明<br style=\"box-sizing: border-box;\"/>农业文明起源诸学说<br style=\"box-sizing: border-box;\"/>磁山遗址所见粟遗存<br style=\"box-sizing: border-box;\"/>磁山遗址中的石磨盘与石磨棒<br style=\"box-sizing: border-box;\"/>磁山遗址中的陶器<br style=\"box-sizing: border-box;\"/>亚洲稻系起源诸说<br style=\"box-sizing: border-box;\"/>河姆渡遗址的发现<br style=\"box-sizing: border-box;\"/>河姆渡遗址中的稻谷遗存<br style=\"box-sizing: border-box;\"/>河姆渡遗址所出土的农具<br style=\"box-sizing: border-box;\"/>太湖流域稻作农业<br style=\"box-sizing: border-box;\"/>中国是否有作为栽培稻基础的野生稻<br style=\"box-sizing: border-box;\"/>作业<br style=\"box-sizing: border-box;\"/>作业</p><p>妇好偶方彝与中国古代礼乐文化<br style=\"box-sizing: border-box;\"/>青铜器的定义<br style=\"box-sizing: border-box;\"/>青铜器的滥觞期与鼎盛期<br style=\"box-sizing: border-box;\"/>妇好偶方彝<br style=\"box-sizing: border-box;\"/>青铜器的颓败期、中兴期与衰落期<br style=\"box-sizing: border-box;\"/>何谓礼文化<br style=\"box-sizing: border-box;\"/>何谓乐文化<br style=\"box-sizing: border-box;\"/>中国古代的青铜礼器<br style=\"box-sizing: border-box;\"/>青铜食器<br style=\"box-sizing: border-box;\"/>青铜酒器<br style=\"box-sizing: border-box;\"/>青铜盥洗器<br style=\"box-sizing: border-box;\"/>青铜礼器的组合<br style=\"box-sizing: border-box;\"/>青铜乐器（上）<br style=\"box-sizing: border-box;\"/>青铜乐器（中）<br style=\"box-sizing: border-box;\"/>青铜乐器（下）<br style=\"box-sizing: border-box;\"/>作业<br style=\"box-sizing: border-box;\"/>作业</p><p>《周易》《周礼》与故宫北京城<br style=\"box-sizing: border-box;\"/>《周易》其书<br style=\"box-sizing: border-box;\"/>《周礼》其书<br style=\"box-sizing: border-box;\"/>《周礼》建国之制的实行<br style=\"box-sizing: border-box;\"/>北京城的中轴线<br style=\"box-sizing: border-box;\"/>故宫、北京城的阴阳思想<br style=\"box-sizing: border-box;\"/>故宫、北京城的五行思想<br style=\"box-sizing: border-box;\"/>重檐庑殿<br style=\"box-sizing: border-box;\"/>九种屋顶<br style=\"box-sizing: border-box;\"/>屋顶装饰<br style=\"box-sizing: border-box;\"/>故宫的空间处理<br style=\"box-sizing: border-box;\"/>太和殿及其周围<br style=\"box-sizing: border-box;\"/>作业</p><p>曾侯乙墓漆箱星宿图与二十八宿<br style=\"box-sizing: border-box;\"/>羲和四子敬受民时<br style=\"box-sizing: border-box;\"/>上古天文观测仪器<br style=\"box-sizing: border-box;\"/>中国上古的四分历<br style=\"box-sizing: border-box;\"/>北极、北斗和二十八宿<br style=\"box-sizing: border-box;\"/>恒星体系为何取“二十八”之数<br style=\"box-sizing: border-box;\"/>二十八宿体系起源于巴比伦？<br style=\"box-sizing: border-box;\"/>二十八宿体系起源于中国<br style=\"box-sizing: border-box;\"/>关于中国二十八宿形成时间的考证<br style=\"box-sizing: border-box;\"/>曾侯乙墓漆箱盖主星图解读<br style=\"box-sizing: border-box;\"/>曾侯乙墓漆箱侧立面星图解读<br style=\"box-sizing: border-box;\"/>濮阳西水坡45号墓：远古时代的北斗二宫图<br style=\"box-sizing: border-box;\"/>西水坡45号墓墓主身份之谜<br style=\"box-sizing: border-box;\"/>作业</p><p>曾侯乙墓均钟与中国古代的律吕<br style=\"box-sizing: border-box;\"/>三分损益法与隔八相生法<br style=\"box-sizing: border-box;\"/>中国古代的十二不平均律<br style=\"box-sizing: border-box;\"/>曾侯乙编钟的乐律体系<br style=\"box-sizing: border-box;\"/>钟的调音问题<br style=\"box-sizing: border-box;\"/>五弦琴乎？筑乎?<br style=\"box-sizing: border-box;\"/>均钟！湮没千年的均钟！<br style=\"box-sizing: border-box;\"/>雨台山律管：又一种战国调音器<br style=\"box-sizing: border-box;\"/>作业</p><p>越王勾践剑与吴越地区的冶铸技术<br style=\"box-sizing: border-box;\"/>中国古剑的几大谱系<br style=\"box-sizing: border-box;\"/>文献中的吴越之剑<br style=\"box-sizing: border-box;\"/>剑与先秦社会<br style=\"box-sizing: border-box;\"/>吴王夫差剑，出土知多少？<br style=\"box-sizing: border-box;\"/>楚地所出越王剑<br style=\"box-sizing: border-box;\"/>浙江省博物馆购藏越王剑<br style=\"box-sizing: border-box;\"/>吴越之剑的菱形暗格纹技术<br style=\"box-sizing: border-box;\"/>吴越之剑的薄壁同心圆剑首技术<br style=\"box-sizing: border-box;\"/>吴越之剑的双色剑制作技术<br style=\"box-sizing: border-box;\"/>青铜剑的发展与衰落<br style=\"box-sizing: border-box;\"/>作业</p><p>河姆渡蚕纹杖饰与先秦服饰文化<br style=\"box-sizing: border-box;\"/>中国蚕桑起源的传说与考古发现<br style=\"box-sizing: border-box;\"/>蚕桑起源的地域分布<br style=\"box-sizing: border-box;\"/>中国纺织业起源的考古发现<br style=\"box-sizing: border-box;\"/>粘附在铜锈上的商代丝织品<br style=\"box-sizing: border-box;\"/>成为国家行为的周代蚕桑业<br style=\"box-sizing: border-box;\"/>东周时代丝织品概观<br style=\"box-sizing: border-box;\"/>马山一号墓的丝织品<br style=\"box-sizing: border-box;\"/>先秦时代的服饰文化<br style=\"box-sizing: border-box;\"/>作业</p><p>秦陵铜车马与先秦时代造车技术<br style=\"box-sizing: border-box;\"/>先秦文献所见交通用车<br style=\"box-sizing: border-box;\"/>先秦文献所见战车<br style=\"box-sizing: border-box;\"/>田野考古所见的商周车辆<br style=\"box-sizing: border-box;\"/>《考工记》记载的造车工艺<br style=\"box-sizing: border-box;\"/>秦陵铜车马概说<br style=\"box-sizing: border-box;\"/>秦陵铜车马的学术价值<br style=\"box-sizing: border-box;\"/>秦陵铜车马的精湛工艺<br style=\"box-sizing: border-box;\"/>期中考试<br style=\"box-sizing: border-box;\"/>考试公告<br style=\"box-sizing: border-box;\"/>期中考试<br style=\"box-sizing: border-box;\"/>期中考试成绩查询</p><p>上家村寨舞蹈纹盆与甘青地区的彩陶文化<br style=\"box-sizing: border-box;\"/>妇好墓象牙杯与先秦时期的生态环境<br style=\"box-sizing: border-box;\"/>殷墟妇好墓概述<br style=\"box-sizing: border-box;\"/>妇好墓象牙杯诸细节<br style=\"box-sizing: border-box;\"/>殷墟中与象相关的文物<br style=\"box-sizing: border-box;\"/>“殷人服象”的文字与文献根据<br style=\"box-sizing: border-box;\"/>史前时代华北地区的生态环境<br style=\"box-sizing: border-box;\"/>先秦社会生活中的象牙<br style=\"box-sizing: border-box;\"/>青铜器中象的造型<br style=\"box-sizing: border-box;\"/>解读吉美象尊<br style=\"box-sizing: border-box;\"/>象逐步南移与消失的原因之一<br style=\"box-sizing: border-box;\"/>象逐步南移与消失的原因之二<br style=\"box-sizing: border-box;\"/>象逐步南移与消失的原因之三<br style=\"box-sizing: border-box;\"/>象逐步南移与消失的原因之四</p><p>四羊方尊与长江流域的商代文明<br style=\"box-sizing: border-box;\"/>注：本课程原来分为文物精品与文化中国（上）与（下）两门，现在已合并成一门课。</p><p><br/></p>', '', '铭飞科技', '/22\\20.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('21', '铭飞科技', '<p>数千年的中国历史上，曾出现了很多伟大的城市，汉长安、北魏洛阳、隋唐长安和洛阳、北宋开封、元大都，都是当时世界上最繁华的大都市。这些城市虽已星光黯淡，却留下了一座座优美壮丽的建筑杰作，令人叹为观止。中国的宫殿、宗教建筑、佛塔、陵寝和园林等建筑类型，无论建造技术还是美学追求，都达到了很高的水平。中国古代的建筑有着自成体系的一套营造方法，以木结构为主，也有不少砖石结构的佛塔和陵寝。历史上建造了大量宫殿建筑，北京故宫是现存世界上最大宫殿建筑群。自南北朝至唐，出现了大批佛教寺院与石窟寺。南北朝以来各地建造的砖石塔，也使中国砖石建筑达到很高水平。唐、辽、宋、金时期留下了一大批宗教建筑遗存，包括大型殿堂，多层楼阁，与高度达67米的高层木塔。明清时期坛壝、祠庙、陵墓与民居，有了高度发展，北京天坛，曲阜孔庙、明十三陵，北京四合院等，是这一时期重要建筑实例。北京颐和园、承德避暑山庄是古代皇家园林代表，明清私家园林则是数千年中国园林艺术的结晶。宋《营造法式》和清《工部工程做法则例》是中国官式建筑两部重要文本，对于理解中国建筑有着重要的意义。课程资料中也将包括这两部著作的电子版。</p><p>课程章节<br style=\"box-sizing: border-box;\"/>1 中国建筑概说<br style=\"box-sizing: border-box;\"/>中国建筑特征<br style=\"box-sizing: border-box;\"/>中国建筑历史分期<br style=\"box-sizing: border-box;\"/>中国建筑类型学讨论<br style=\"box-sizing: border-box;\"/>古代城市的规划思想与两种规划理念<br style=\"box-sizing: border-box;\"/>古代建筑原则<br style=\"box-sizing: border-box;\"/>古代建筑思想</p><p>2 史前至秦汉时期的中国建筑<br style=\"box-sizing: border-box;\"/>早期文明和建筑形态<br style=\"box-sizing: border-box;\"/>夏商时期建筑<br style=\"box-sizing: border-box;\"/>周代的建筑<br style=\"box-sizing: border-box;\"/>秦汉时期的中国文明与城市<br style=\"box-sizing: border-box;\"/>秦汉时期的宫室<br style=\"box-sizing: border-box;\"/>秦汉时期的住宅、墓葬和其它建筑类型</p><p>3 三国、两晋、南北朝时期的中国建筑<br style=\"box-sizing: border-box;\"/>三国、两晋、南北朝时期的城市和宫殿<br style=\"box-sizing: border-box;\"/>佛教的发展及佛教建筑的繁荣<br style=\"box-sizing: border-box;\"/>南北朝时期的佛教建筑遗迹<br style=\"box-sizing: border-box;\"/>南北朝时期的佛教石窟寺<br style=\"box-sizing: border-box;\"/>石窟寺建筑形象反映的木结构建筑发展过程<br style=\"box-sizing: border-box;\"/>秦汉至南北朝时期的园林</p><p>4 隋唐时期的城市、住宅、宫殿与园林<br style=\"box-sizing: border-box;\"/>隋唐时期的中国文明<br style=\"box-sizing: border-box;\"/>隋唐两京城<br style=\"box-sizing: border-box;\"/>隋唐两京里坊与住宅<br style=\"box-sizing: border-box;\"/>隋唐宫殿中的重要建筑<br style=\"box-sizing: border-box;\"/>隋唐园林</p><p>5 隋唐时期的宗教建筑与主要遗存，建筑技术与艺术<br style=\"box-sizing: border-box;\"/>隋唐时期的宗教建筑<br style=\"box-sizing: border-box;\"/>隋唐时期的木结构佛教殿堂建筑遗存<br style=\"box-sizing: border-box;\"/>隋唐时期的砖石塔幢遗存<br style=\"box-sizing: border-box;\"/>隋唐时期的建筑风格与设计方法<br style=\"box-sizing: border-box;\"/>隋唐时期的木结构建筑技术<br style=\"box-sizing: border-box;\"/>隋唐时期的砖石结构建筑技术<br style=\"box-sizing: border-box;\"/>建筑技术的进步和艺术的发展</p><p>6 五代、两宋、辽、金时期的城市，宫殿与苑囿<br style=\"box-sizing: border-box;\"/>五代、两宋、辽、金、西夏历史<br style=\"box-sizing: border-box;\"/>北宋汴梁城<br style=\"box-sizing: border-box;\"/>南宋临安府、南宋平江府、辽南京与金中都<br style=\"box-sizing: border-box;\"/>北宋汴梁与南宋临安宫殿<br style=\"box-sizing: border-box;\"/>金中都宫殿<br style=\"box-sizing: border-box;\"/>两宋辽金时的园林</p><p>7 五代、两宋、辽、金建筑遗存<br style=\"box-sizing: border-box;\"/>九开间大型木构殿堂遗存<br style=\"box-sizing: border-box;\"/>七开间木构殿堂遗存<br style=\"box-sizing: border-box;\"/>五开间木构殿堂遗存<br style=\"box-sizing: border-box;\"/>三开间木构殿堂遗存<br style=\"box-sizing: border-box;\"/>单层重檐殿堂遗存<br style=\"box-sizing: border-box;\"/>两宋、辽、金木构楼阁<br style=\"box-sizing: border-box;\"/>两宋、辽、金时期的佛塔建筑</p><p>8《营造法式》与小结<br style=\"box-sizing: border-box;\"/>宋《营造法式》介绍<br style=\"box-sizing: border-box;\"/>两宋、辽、金建筑总结<br style=\"box-sizing: border-box;\"/>两宋、辽、金建筑讨论</p><p>期中考试</p><p>9 元代的城市与建筑<br style=\"box-sizing: border-box;\"/>元代的城市与建筑综述<br style=\"box-sizing: border-box;\"/>元上都与元大都<br style=\"box-sizing: border-box;\"/>元大都宫殿<br style=\"box-sizing: border-box;\"/>元代宗教建筑<br style=\"box-sizing: border-box;\"/>元代科技建筑</p><p>10 明代的城市与建筑<br style=\"box-sizing: border-box;\"/>明代制度重建及其城市与建筑综述<br style=\"box-sizing: border-box;\"/>明代北京城<br style=\"box-sizing: border-box;\"/>明代地方城市<br style=\"box-sizing: border-box;\"/>明代北京紫禁城<br style=\"box-sizing: border-box;\"/>明代北京皇家坛庙<br style=\"box-sizing: border-box;\"/>明代曲阜孔庙<br style=\"box-sizing: border-box;\"/>明代南京孝陵与昌平十三陵<br style=\"box-sizing: border-box;\"/>明代佛教建筑<br style=\"box-sizing: border-box;\"/>明代道教建筑<br style=\"box-sizing: border-box;\"/>明代教育建筑</p><p>11 清代建筑概述与紫禁城<br style=\"box-sizing: border-box;\"/>清代建筑概述<br style=\"box-sizing: border-box;\"/>紫禁城<br style=\"box-sizing: border-box;\"/>陵寝建筑</p><p>12 城乡生活与建筑类型<br style=\"box-sizing: border-box;\"/>清代城市<br style=\"box-sizing: border-box;\"/>律制生活与衙署类建筑<br style=\"box-sizing: border-box;\"/>信仰生活与礼制宗教建筑等<br style=\"box-sizing: border-box;\"/>工商行业与与商业、会馆建筑<br style=\"box-sizing: border-box;\"/>娱乐生活与演出建筑</p><p>13 清代建筑技术与艺术<br style=\"box-sizing: border-box;\"/>中国与世界：艺术和科学&amp;工程做法<br style=\"box-sizing: border-box;\"/>“准”建筑师<br style=\"box-sizing: border-box;\"/>建筑匠<br style=\"box-sizing: border-box;\"/>案例赏析<br style=\"box-sizing: border-box;\"/>期中测试：动手画图</p><p>14 明清时期古典园林<br style=\"box-sizing: border-box;\"/>中国古典园林概述<br style=\"box-sizing: border-box;\"/>明清时期皇家园林<br style=\"box-sizing: border-box;\"/>江南私家园林<br style=\"box-sizing: border-box;\"/>岭南私家园林<br style=\"box-sizing: border-box;\"/>北方私家园林</p><p>15 中国传统民居建筑<br style=\"box-sizing: border-box;\"/>中国民居建筑发展简史<br style=\"box-sizing: border-box;\"/>北方合院式民居<br style=\"box-sizing: border-box;\"/>江南厅井式民居<br style=\"box-sizing: border-box;\"/>南方厅井式民居<br style=\"box-sizing: border-box;\"/>东南客家土楼<br style=\"box-sizing: border-box;\"/>黄土高原窑洞民居<br style=\"box-sizing: border-box;\"/>中国传统民居建筑设计成就</p><p>16 中国多民族的建筑<br style=\"box-sizing: border-box;\"/>回族建筑<br style=\"box-sizing: border-box;\"/>满族、朝鲜族民居建筑<br style=\"box-sizing: border-box;\"/>蒙古族建筑<br style=\"box-sizing: border-box;\"/>新疆维吾尔族建筑<br style=\"box-sizing: border-box;\"/>西藏地区的藏族建筑<br style=\"box-sizing: border-box;\"/>西南地区多民族建筑艺术<br style=\"box-sizing: border-box;\"/>民族建筑小结</p><p><br style=\"box-sizing: border-box;\"/>期末考试<br style=\"box-sizing: border-box;\"/>考试说明与题目</p><p>【FAQ】</p><p>这门课需要教科书吗？<br style=\"box-sizing: border-box;\"/>这门课没有指定的教科书，但为了更好的学习效果，建议参考刘敦桢著，中国建筑工业出版社出版的《中国古代建筑史》。另外，每节课的内容中也会包含老师指定的参考书目，上课前会上传到课程文件当中，同学们可以自行下载。</p><p>这门课曾经被分成了中国建筑史（1）和中国建筑史（2）两门，现在合并成了一门课~之前课程的传送门：中国建筑史</p><p><br/></p>', '', '铭飞科技', '/22\\21.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('22', '铭飞科技', '<p>本课程主要探讨新媒体与社会之间的互动关系，一方面关注各种社会力量对新媒体的塑造，另一方面讨论新媒体对社会各个层面的影响。课程在探讨新媒体的概念、特征、形式、内容和历史的基础上，同时关注新媒体的采纳、扩散、伦理和法制，以及新媒体在政治、经济、文化和社会结构上对社会的影响。本课程有助于学生掌握新媒体的相关概念和理论，理解新媒体在社会控制和社会变迁中的重要角色，成为新媒体时代具有批判能力和责任意识的现代公民。</p><p><br style=\"box-sizing: border-box;\"/>证书要求<br style=\"box-sizing: border-box;\"/>本课程的评价分为以下四个部分：<br style=\"box-sizing: border-box;\"/>1、课程讨论（10％）：获取满分学生需要在指定的“课堂讨论”中发帖和回帖的数量总共达50条及以上。需要参加在课件中作为教学内容的讨论，才能计算成绩。本课程每一小节都会指定讨论题目，学生可根据兴趣选择参与。<br style=\"box-sizing: border-box;\"/>2、章节测验（30％）：每次测验包括5个单选题和5个判断题，每题1分，共10分。每次测验需要在60分钟内完成，允许尝试2次，有效得分为平均分值。本课程一共有8次章节测验。<br style=\"box-sizing: border-box;\"/>3、家庭作业（30％）：要求学生在观看教学视频和阅读延伸文献的基础上，经过调研和分析，撰写书面作业。具体要求参见每次作业说明。家庭作业采取学生互评的方式评分，作业互评最少个数为6个。互评完成度的奖惩计分规则为，未参与互评的学生将获0分，未完成互评的学生将给与所得分数的50%，全部完成互评的学生将给与所得分数的100%。系统默认互评下的学生作业成绩，每个得分项去掉最低最高分取平均分，然后相加。本课程一共有3次家庭作业。<br style=\"box-sizing: border-box;\"/>4、期末考试（30％）：包括15个单选题和15个判断题，每题1分，共30分。需要在60分钟内完成，只允许尝试1次。<br style=\"box-sizing: border-box;\"/>总成绩60分及以上合格，90分及以上优秀，并可申请相应证书。</p><p>预备知识<br style=\"box-sizing: border-box;\"/>作为一门概论课程，本课程无特殊要求的先修课程。欢迎所有对新媒体感兴趣的同学选修。</p><p><br style=\"box-sizing: border-box;\"/>授课大纲<br style=\"box-sizing: border-box;\"/>第1周：新媒体导论<br style=\"box-sizing: border-box;\"/>1.1 什么是新媒体<br style=\"box-sizing: border-box;\"/>1.2 新媒体的历史<br style=\"box-sizing: border-box;\"/>第2周：新媒体与社会的关系<br style=\"box-sizing: border-box;\"/>2.1 技术决定论<br style=\"box-sizing: border-box;\"/>2.2 社会决定论<br style=\"box-sizing: border-box;\"/>2.3 技术社会互动论<br style=\"box-sizing: border-box;\"/>第3周：新媒体的采纳与扩散<br style=\"box-sizing: border-box;\"/>3.1 社会学习论<br style=\"box-sizing: border-box;\"/>3.1 创新扩散论<br style=\"box-sizing: border-box;\"/>3.1 技术接受论<br style=\"box-sizing: border-box;\"/>第4周：新媒体的伦理与法制<br style=\"box-sizing: border-box;\"/>4.1 新媒体伦理<br style=\"box-sizing: border-box;\"/>4.2 新媒体法制<br style=\"box-sizing: border-box;\"/>4.2 其他控制手段<br style=\"box-sizing: border-box;\"/>第5周：新媒体的社会结构影响<br style=\"box-sizing: border-box;\"/>5.1 网络社会<br style=\"box-sizing: border-box;\"/>5.2 阶层结构<br style=\"box-sizing: border-box;\"/>5.3 数字鸿沟<br style=\"box-sizing: border-box;\"/>第6周：新媒体的政治影响<br style=\"box-sizing: border-box;\"/>6.1 电子政务<br style=\"box-sizing: border-box;\"/>6.2 网络参与<br style=\"box-sizing: border-box;\"/>6.3 网络治理<br style=\"box-sizing: border-box;\"/>第7周：新媒体的经济影响<br style=\"box-sizing: border-box;\"/>7.1 电子商务<br style=\"box-sizing: border-box;\"/>7.2 创意产业<br style=\"box-sizing: border-box;\"/>7.3 信息经济<br style=\"box-sizing: border-box;\"/>第8周：新媒体的文化影响<br style=\"box-sizing: border-box;\"/>8.1 网络身份<br style=\"box-sizing: border-box;\"/>8.2 网络社区<br style=\"box-sizing: border-box;\"/>8.3 网络文化</p><p><br style=\"box-sizing: border-box;\"/>【FAQ】</p><p>1、本课程所有视频一般都有标清、高清、超清三种格式，大家可以根据自己的网速进行选择。<br style=\"box-sizing: border-box;\"/>2、建议大家根据教师设置的课件内容顺序进行学习，以达到最佳学习效果。<br style=\"box-sizing: border-box;\"/>3、请大家在进行测验和作业之前，务必仔细阅读评分标准，以避免不必要的失分。<br style=\"box-sizing: border-box;\"/>4、我的博士生谢点同学将担任本课程助教，为大家提供各种必要的协助。<br style=\"box-sizing: border-box;\"/>5、由于选课人数众多，对于大家的疑问，我们会通过公告的形式统一回复，请大家注意公告内容更新。</p><p><br/></p>', '', '铭飞科技', '/22\\22.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('185', '', '<p>联系电话：888888<br/></p><p>QQ：1391265900</p><p>邮箱：1391265900@qq.com</p><p>地址：来自火星的程序猿</p><p><br/></p>', '', '', '/19/141\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('186', '', '<p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">1、<a target=\"_blank\" href=\"http://git.oschina.net/jfinal/jfinal\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">JFinal</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项 目简介：JFinal 是基于 Java 语言的极速 WEB + ORM 框架，其核心设计目标是开发迅速、代码量少、学习简单、功能强大、轻量级、易扩展、Restful。在拥有Java语言所有优势的同时再拥有ruby、 python、php等动态语言的开发效率！为您节约更多时间，去陪恋人、家人和朋友 :)</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">2、<a target=\"_blank\" href=\"http://git.oschina.net/jeecg/jeewx\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jeewx</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：免费开源JAVA微信管家平台，实现了微信平台的基础功能，便于用户二次开发。JEEWX支持微信第三方平台全网发布、支持微信插件开发机制，可轻松集成微信H5插件。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">3、<a target=\"_blank\" href=\"http://git.oschina.net/tinyframework/tiny\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">tiny</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：值得拥有的企业级j2ee应用开发框架套件，专业团队开发，完整的生态体系，活跃的社区氛围，无限的水平扩展能力，7*24不间断运维能力。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">4、<a target=\"_blank\" href=\"http://git.oschina.net/shishuo/CMS\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">CMS</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">一款使用Java语言开发的CMS，使用了Spring MVC,Spring,MyBatis等流行框架，提供首页大图管理、目录管理、文章管理和管理员管理等功能。是学习和二次开发的首选。</p><p><br/></p>', '', '', '/16/143/145\\186.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('187', '', '<p><br/></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">5、<a target=\"_blank\" href=\"http://git.oschina.net/jeecg/jeecg\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jeecg</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项 目推荐：JEECG是一款J2EE企业级快速智能开发平台，开源界“小普元”超越传统商业企业级开发平台。基于代码生成器，引领新的开发模式 (Online Coding模式(自定义表单)-&gt;代码生成器模式-&gt;手工MERGE智能开发)， 可以帮助解决Java项目60%的重复工作，让开发更多关注业务逻辑。既能快速提高开发效率，帮助公司节省人力成本，同时又不失灵活性。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">6、<a target=\"_blank\" href=\"http://git.oschina.net/free/Mybatis_PageHelper\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">Mybatis_PageHelper</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：Mybatis_PageHelper 是 Mybatis 分页插件，支持任何复杂的单表、多表分页。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">7、<a target=\"_blank\" href=\"http://git.oschina.net/thinkgem/jeesite\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">JeeSite</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：JeeSite 是一个企业信息化开发基础平台，Java EE（J2EE）快速开发框架，使用经典技术组合（Spring、Spring MVC、Apache Shiro、MyBatis、Bootstrap UI），包括核心模块如：组织机构、角色用户、权限授权、数据权限、内容管理、工作流等。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">8、<a target=\"_blank\" href=\"http://git.oschina.net/ligerui/LigerUI\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">LigerUI</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：基于jQuery的UI框架，包括表单、布局、表格等等常用UI控件，使用LigerUI可以快速轻松地创建风格统一的界面效果。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">9、<a target=\"_blank\" href=\"http://git.oschina.net/9miao/CrossApp\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">CrossApp</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：一款完全开源、免费、跨平台的移动应用开发引擎，开发者可以完全免费、毫无顾虑的使用CrossApp开发任何项目。本引擎基于C++语言编写，OpenGl ES2.0图形渲染。拥有丰富的UI控件、丰富的第三方库、集成各种系统接口。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">10、<a target=\"_blank\" href=\"http://git.oschina.net/liu21st/thinkphp\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">thinkphp</a></p><p><br/></p>', '', '糊盒机在线混料视觉检测', '/16/143/146\\187.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('188', '', '<p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">10、<a target=\"_blank\" href=\"http://git.oschina.net/liu21st/thinkphp\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">thinkphp</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：ThinkPHP 是一个免费开源的，快速、简单的面向对象的 轻量级PHP开发框架 ，创立于2006年初，遵循Apache2开源协议发布，是为了敏捷WEB应用开发和简化企业应用开发而诞生的。ThinkPHP从诞生以来一直秉承简洁 实用的设计原则，在保持出色的性能和至简的代码的同时，也注重易用性。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">11、<a target=\"_blank\" href=\"http://git.oschina.net/kymjs/KJFrameForAndroid\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">KJFrameForAndroid</a></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：KJFrameForAndroid的设计思想是通过封装Android原生SDK中复杂的复杂操作而达到简化Android应用级开发，最终实现快速而又安全高效的开发APP。我们的目标是用最少的代码，完成最多的操作，用最高的效率，完成最复杂的功能。</p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">12、<a target=\"_blank\" href=\"http://git.oschina.net/rushmore/zbus\" rel=\"nofollow\" style=\"color: rgb(62, 98, 166); text-decoration: none; box-sizing: border-box; transition: all 0.5s; -webkit-transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">zbus</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"margin-top: 0px; margin-bottom: 15pt; padding: 0px; color: rgb(102, 102, 102); text-indent: 24px; font-family: Verdana, sans-serif, 宋体; line-height: 22.4px; white-space: normal; box-sizing: border-box; font-size: 14px; background-color: rgb(255, 255, 255);\">项目简介：ZBUS=MQ+RPC+PROXY 服务总线 &nbsp;1)支持消息队列, 发布订阅, RPC, 代理（TCP/DMZ） &nbsp; 2)亿级消息堆积能力、支持HA高可用 &nbsp;3)无依赖单个Jar包 ~300K &nbsp; 4)丰富的API--JAVA/C/C++/C#/Python/Node.JS多语言接入，支持HTTP/Thrift等协议接入</p><p><br/></p>', '', '', '/16/144\\188.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('36', '', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站整体策划</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">企业网站建设目的何在？如何充分挖掘互联网络的资源和优势，如何合理地组织网站内容与功能从而达到客户的需求？<br style=\"padding: 0px; margin: 0px;\"/>我们将根据市场分析、客户产品及服务的优势、竞争对手分析等等，有效的确立网站定位。根据相关需求分析获得相应网站运营策略，在网站建立之初我们就网站VI形象、网站营销手段、运营模式、网站发展前景等等进行定位。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站设计&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">DESIGN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">网络媒体不同于传统媒体，如果在网站设计的时候仅仅是将文字和图片做一个简单堆积和展示的话，这样的网站跟一片丢落在街头的破旧宣传资料没有任何区别。客户往往通过企业网站就留下了对企业的第一印象，这个第一印象是决定客户是否与你合作的重要因素。<br style=\"padding: 0px; margin: 0px;\"/>所以在浏览者的角度，我们分析企业特点和品牌内涵，完美的通过网站体现企业形象，并严格采用W3C国际标准进行网站设计，采用DIV+CSS构 架，不但使您的网站具备足够的扩展性，您网站的速度、兼容性、友好性也都会显著提高，更主要的是，代码和表现分离的方式让您的网站改版变得更容易，而针对 SEO搜索引擎优化的工作也变得更加的畅通。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站建设售后服务&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">SALES</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">网站建设专家致力于为客户提供优质的产品及服务。为了多渠道的了解客户的需求，快速响应个性化需要，不断完善售后服务工作，我们客户服务管理部在此为您搭建了这个沟通的平台，我们希望通过网络加强与客户的交流。<br style=\"padding: 0px; margin: 0px;\"/>完善的售后服务是公司信誉的保障和服务趋于完善与成熟的象征，因此，我们在这一方面投入了较大的精力，确保每一位客户的利益得到充分的保障，从而提高企业信誉，发展长期友好的合作。<br style=\"padding: 0px; margin: 0px;\"/>对于享受我公司建站服务的客户，我们提供免费一年售后服务。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站全程维护&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">MAINTAIN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">网页制作好了以后并不是就没事了？其实日后的更新维护才是最重要的！如果参观网站的访问者每次看到的网站都是一样的，那么它们日后还会来吗？这时候，您的网页要由谁来维护呢？<br style=\"padding: 0px; margin: 0px;\"/>严格来说，每一个站点都应该由专业人员定期更新维护。互联网络的最大优势就是信息的实时性，只有快速的反映，准确的报道，才能吸引更多的浏览者。<br style=\"padding: 0px; margin: 0px;\"/>目前很多站点人气很旺，应该和定期更新分不开的。也有很多站点由于种种原因，数月才更新一次，这样就违背了网路最基本的商业目的。网站不是购买一件商品，随着时间的推移而贬值陈旧，只有不断的溶入企业发展动向，推陈出新，才会具有创造力，发挥网路商业潜能。<br style=\"padding: 0px; margin: 0px;\"/>更新维护不仅仅只局限于简单的更换文字稿，应该是将企业的商业动态和发展方向充分考虑进去， 再结合现有的网站规划结构，迅速作出相应的改进。企业的每一个新项目的推广和价格的浮动、内部结构调整， 不应该只是在报纸、电视等媒体做宣传而忽略网路这个最具有潜力的市场。 这也是我们一直强调的商业网站 CIS 策略。<br style=\"padding: 0px; margin: 0px;\"/>鉴于目前大多数网站不具有专业维护的技术力量，网站建设公司可为广大客户提供专业服务。每一个企业可根据自身的商业特征制定不同的维护方案，并保证在最短的时间内迅速完成。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网页改版&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">REVISED</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">企业上网已成趋势，企业网站犹如雨后春笋般地拔起，试问：<br style=\"padding: 0px; margin: 0px;\"/>您的企业通过互联网进行了巨额的投入，但网站到底给您带来了多大的效益？<br style=\"padding: 0px; margin: 0px;\"/>您的网站从建立到现在，更新过几次、改版过几次？<br style=\"padding: 0px; margin: 0px;\"/>功能不全、设计不美观、布局不合理、几乎从不更新的网站会给企形象带来多大的负面影响？<br style=\"padding: 0px; margin: 0px;\"/>选择网站建站专家，帮您重新审视和构架您的网站系统，我们提供八项全能服务，全面改善您的网站系统，专为您解决企业上网后顾之忧。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">培训解决方案&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">TRAIN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">为了更好地做好企业外部门户网站的技术培训工作，将选派具有丰富技术培训和实施经验的技术人员组成培训小组，编写详尽实用的培训教材，并且制定切实有效的培训方案。技术培训的工作为应用软件系统管理和使用培训。<br style=\"padding: 0px; margin: 0px;\"/>在软件产品实践培训中，采用集中培训的方式，由的培训师针对本系统的技术特点，为企业技术人员提供全面培训，培训内容涵盖了本此系统建设过程中使用的主要技术理论和产品实践。<br style=\"padding: 0px; margin: 0px;\"/>在应用软件系统管理和使用培训中，我们会组织项目开发小组的主要人员针对管理和使用人员的不同需求，提供不同层次的培训课程。</p><p><br/></p>', '', '', '/53\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('37', '火星猿', '<p class=\"font_b font_14\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-weight: bold; font-size: 14px; color: rgb(51, 51, 51); font-family: 微软雅黑; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">*&nbsp;&nbsp;以人为本，人尽其才&quot;的原则<br/>*&nbsp;&nbsp;德才兼备,德为先&nbsp;<br/>*&nbsp;&nbsp;内部提拔,给员工一个上升的空间<br/>*&nbsp;&nbsp;绩效考核制度,倡导&quot;能者上，庸者下&quot;的淘汰机制</p><p class=\"font_b font_14\" style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-weight: bold; font-size: 14px; color: rgb(51, 51, 51); font-family: 微软雅黑; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">一个企业的竞争力归结到底是人才的竞争力。荣超物业本着&quot;以人为本，人尽其才&quot;的原则，为有志于物业管理行业发展的人才提供一个发展的舞台。在人才招聘中，结合每位应聘者的素质、品格、经验进行综合评价，遵循公平、平等、竞争、择优以及双向选择的原则。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">企业内部的竞聘、晋升机制，为员工提供了公平竞争的机会。通过挖掘企业内部的人才，调动内部人员的潜力和积极性，促进了优秀人才脱颖而出，实现人力资源的合理配置，把&quot;合适的人放在合适的地方&quot;。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">建立客观公正的考核制度，是人才使用的一个重要人力资源措施。考核突出对每位员工的工作绩效、工作态度和工作能力进行考评，以提高团队的整体绩效和提高企业的管理服务水平，并倡导&quot;能者上，庸者下&quot;的淘汰机制。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 12px; line-height: 21px; white-space: normal; background-repeat: no-repeat;\">企业致力于创造一个员工于企业共同发展的空间和平台，荣超物业期待您的加盟，企业的发展将为您的加入而更为精彩！</p><p><br/></p>', '', 'MS', '/54\\37.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('38', '拾荒至尊宝', '<p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\"><a href=\"http://www.duwenzhang.com/huati/pengyou/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">朋友</a>S是个精力旺盛的人，他的朋友圈里几乎没有单人照，每天都是与互不相同的密友自拍。S确实像是生来就具有调动气氛的天赋，无论是一起唱歌还是聚餐，他总能迅速暖场，中途还能救冷场于无形。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　前段<a href=\"http://www.duwenzhang.com/huati/shijian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">时间</a>，福州办青运会。他去做了志愿者，认识了一帮新朋友，穿着小青果的衣服在赛场边上蹿下跳。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　在这个并不能算是一线的城市，凡是有大型活动，必活跃着S的身影。他的朋友圈俨然已经成为某个都市报的活动版块，实时播报着这个城市的各种动态。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　每每将他的朋友圈一一扫过，我都会产生一种“不配和他在同在一个城市”的自惭形愧。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　贰</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　朋友L截然不同。L少言寡语，不爱热闹，不议是非，平日里一副形单影只的<a href=\"http://www.duwenzhang.com/huati/gudu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">孤独</a>模样。上学的时候，人人都在竞争班长、团支书过过官瘾，唯独他挑了个“劳动委员”的苦差。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我们交情不深，因为同选了一门选修课，才一周一会。课间<a href=\"http://www.duwenzhang.com/huati/wuliao/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">无聊</a>，也会时常有一搭没一搭地聊点私事。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　毕业后我们鲜少联系，直到有一天，我接到他的电话，他让我猜猜他在哪儿。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　还没等我开口，他就一声坏笑着抢白了我的话：“啊哈，就知道到你猜不到，我在贝加尔湖畔！”</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　然后他就自顾自地说起，<a href=\"http://www.duwenzhang.com/wenzhang/xiaoyuanwenzhang/daxueshenghuo/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">大学</a>的时候，网络上有个帖子流传很广，说人一辈子一定要坐一次通往俄罗斯的铁路。那时选修<a href=\"http://www.duwenzhang.com/huati/laoshi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">老师</a>正唾沫横飞地讲着糖代谢，我一脸兴奋地拿给他看，结果老师写满黑板的糖代谢示意图他没记住，反倒记住了这一路山峦、草原、白桦林、贝加尔湖，就心心念念地想来一趟。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　老掉牙的少年往事，他连各种细节都记得比我清楚。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　他说，俄罗斯的<a href=\"http://www.duwenzhang.com/huati/nvren/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">女人</a>比你还要壮硕，哈哈哈。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我说，滚。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　嘴上不饶，却心里一暖。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　叁</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有段时间，朋友圈流行集赞的活动，S君一连发了许多个，然后恭恭敬敬地群发给好友，要大家帮忙点赞。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　那阵子，我工作并不忙，稿子也写得不多，可就连手一滑点进他朋友圈的<a href=\"http://www.duwenzhang.com/huati/yuwang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">欲望</a>都没有。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有一天，去了个大饭局，S君正巧也在，忙不迭地向我抱怨，怎么朋友圈的集赞人数总是不够。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我大吃一惊：“以你的人脉，我以为你早在第一天就攒齐了呢。”</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　他苦笑道：“哪儿啊，每次集赞我都群发了两三遍，最后都不好意思再发了，可还是没攒够。”</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我心虚地没回应，生怕他提起几次点赞我都没有参与的事，甚至怀疑他是不是旁敲侧击地来影射我。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　倒是L偶尔发来的“求点赞、求转发”，等我点开的时候，下面都早已有了他的留言：谢谢各位朋友帮忙，我的赞已经够啦！</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　肆</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　从关系的亲疏来说，我无疑是和S君更熟悉一些。大学时代，我们共同策划了无数大大小小的社团活动，一起通宵夜战，写策划，拉赞助，熬得双眼通红。一起在散场后，喝着大酒，分享<a href=\"http://www.duwenzhang.com/huati/chenggong/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成功</a>的<a href=\"http://www.duwenzhang.com/huati/xiyue/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">喜悦</a>。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　但S君似乎与整个世界都熟稔，他的世界并不缺我一个。和他挑灯夜战过的，不止我一个；和他喝过大酒的，也不止我一个。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　他发的状态里，永远都是我不认识的人，我没见过的风景。他跟新朋友出去玩，拍出来的照片里那一张张笑脸，也全都是我不认识的人。他的喜怒哀乐多么丰富，却没有一丝一毫关于我的痕迹。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　S君让我感受不到自己的存在感，哪怕只是非常微弱与渺小的存在。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有时候我们不得不承认，人类潜藏在<a href=\"http://www.duwenzhang.com/huati/neixin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">内心</a>深处的对爱与关注的占有欲就是这样偏激自私。也不得不承认，除了<a href=\"http://www.duwenzhang.com/wenzhang/aiqingwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">爱情</a>，<a href=\"http://www.duwenzhang.com/wenzhang/youqingwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">友情</a>也同样具有排他性。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　这不值得大肆宣扬，成为任何一种抢占或犯罪的原因。却也不应被口诛笔伐，顶多算是上帝造人时，不小心做下的恶作剧。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我们都<a href=\"http://www.duwenzhang.com/huati/xiwang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">希望</a>自己成为别人的the only one，如果不能，就希望自己至少要比别人特别一点。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　就像L对我：当我看到贝加尔湖的时候，突然就想到了你。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　那一刻，我觉得自己在L心中，比起别人，多了一弯月牙形的湖泊。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　笼络人心有时候很简单：甜言蜜语不用多，就一句微弱的在乎，就是最笃定的<a href=\"http://www.duwenzhang.com/huati/youyi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">友谊</a>见证。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　伍</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我也犯过S的错误，误以为经营好朋友圈、频频获得他人的点赞就是社交皇后。其实那些点赞的意义不过是“你的<a href=\"http://www.duwenzhang.com/wenzhang/shenghuosuibi/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">生活</a>过得很不错”或者“朕已阅”，而不是“你过得好吗”“我好想你”。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　多用心给朋友一点在乎、贴心地送去问候，两个人<a href=\"http://www.duwenzhang.com/huati/yongyou/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">拥有</a>的独家记忆，远比一方摇曳生姿的朋友圈来得珍贵</p><p><br/></p>', '', '文章阅读网', '/55\\38.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('39', '1320053376', '<p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">轻声细语缠绵了时光，轻弹浅唱黯淡了流年。那些明灭相随的离合悲欢，都在这一季里化作一纸云烟。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　不知不觉，已到了初夏。伴随着惊雷和雨滴的声音，才想起当时是自己把<a href=\"http://www.duwenzhang.com/huati/shijian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">时间</a>想的过于仁慈，其实，不然。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　突然想要写点什么，来纪念自己即将逝去的<a href=\"http://www.duwenzhang.com/wenzhang/xiaoyuanwenzhang/daxueshenghuo/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">大学</a>四年时光，借机过度一下自己此时此刻莫可名状的<a href=\"http://www.duwenzhang.com/wenzhang/xinqingriji/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">心情</a>；突然想要说点什么，来缅怀一下自己当初万丈豪情遗失的时光和所谓的<a href=\"http://www.duwenzhang.com/huati/qingchun/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">青春</a>年华。不知道是骨子里的性情使然，还是<a href=\"http://www.duwenzhang.com/huati/neixin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">内心</a>深处想要特意地煽情？</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　毕业论文完成了心也空了，毕业照照了笑了也哭了，毕业聚餐聚了也散了，课程再没有了。想要再安安静静地坐在教室里听一堂课，也许已不再可能，室友同窗一个个整理好行囊离校而去，为了工作，为了<a href=\"http://www.duwenzhang.com/wenzhang/shenghuosuibi/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">生活</a>，为了自己的将来各奔天涯，各奔前程。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　想起四年里，我们闹过，笑过，憋屈过的点点滴滴，原来那是我们<a href=\"http://www.duwenzhang.com/huati/meihao/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">美好</a>的时光，一切恍若人世，顷刻间涌到眼前而又顷刻间飘远，来回往复。曾经不太在乎的人和事，即使当初彼此没说过多少话，没有多少相同的言语，甚至没有打过照面，没有同时毕业，可一切都在一瞬间让我们感到弥足珍贵，毕竟我们已有四年的同窗之谊和离校后的校友之情。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　一个一个地送他们离去，一路无话，一路<a href=\"http://www.duwenzhang.com/huati/chenmo/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">沉默</a>，一路看着，一路听着，半抹余阳，心照不宣。周围的热闹与喧嚣，更突兀地让心里莫名地徒增<a href=\"http://www.duwenzhang.com/huati/shanggan/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">伤感</a>，心里的落差，天南地北难以言说，只能硬生生地挤出几抹别扭的<a href=\"http://www.duwenzhang.com/huati/weixiao/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">微笑</a>挂在脸庞，握手拥抱，互祝“安好”，可看着他们远去的背影，车窗里彼此眼里噙着的泪水，强忍着就差冲破心底最后的一道防线夺眶而出，招手作别，列车离去，心情终究还是崩溃了。也许，三五年我们再相聚，也许有的人我们天涯两隔一生从此难再相见。想到这里，心底莫名地抽痛起来。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　送走他们，独自一人默默地往回走，身体与<a href=\"http://www.duwenzhang.com/huati/linghun/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">灵魂</a>已不在同一防线，内心的凄楚与离愁一点一点地跃上心头。拖着落寞的躯壳独自一人回到曾经熟悉的<a href=\"http://www.duwenzhang.com/wenzhang/xiaoyuanwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">校园</a>，校园里，学弟学妹照常热闹着，照常忙碌着，这一切都是毕业前的狂欢，一如昨天对未来不太着急的我们自己，我看到了那时我们的影子就在他们的身上若隐若现，一切仿佛什么都从未发生过一样，可一切确切已然发生，我们已然疼痛过，这一切真实地在我们的心底深处留下鲜红的痕迹。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　深一脚浅一脚地挪回曾经<a href=\"http://www.duwenzhang.com/huati/wenxin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">温馨</a>的寝室，熟悉的人却已不再，曾经热闹的空间早已被冷清覆盖得令人胆寒，那些收拾得干干净净的空床位，赫然醒目，心底最后的一丝<a href=\"http://www.duwenzhang.com/huati/jianqiang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">坚强</a>落荒而逃。忆起往昔的点点滴滴，<a href=\"http://www.duwenzhang.com/huati/gudu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">孤独</a>和冷清的气息侵蚀着身体的每一根神经和每一个毛细血孔，悲怆之感不言而喻，满心的离愁别绪在所难逃，有同学<a href=\"http://www.duwenzhang.com/huati/pengyou/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">朋友</a>离去的不舍之情，也有为自己明天四处奔波为了生活找寻工作的压迫之感和深深的担忧之愁。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　空荡荡的房间，一如自己空空如也的心房，平时热闹惯了，没觉得<a href=\"http://www.duwenzhang.com/wenzhang/renshengzheli/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">人生</a>有多么的突兀和不寻常，所有人真正地<a href=\"http://www.duwenzhang.com/huati/likai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">离开</a>，才觉得原来我们在一起已经四年，时光过得真快，转眼四年已如指尖沙，随风扬灭，或许是因为之前看不到<a href=\"http://www.duwenzhang.com/huati/libie/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">离别</a>，连同时光也走的慢慢悠悠。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　<a href=\"http://www.duwenzhang.com/wenzhang/shenghuosuibi/chengzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成长</a>带给我们的疼痛越来越清晰可见，离别不仅仅是说说而已，有时足以让人撕心裂肺。忧思在我的心里慢慢地平静下去，正如暮色降临在寂静的山林之中。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　守着夜，一直想找个时间，好好看看所谓的花开不败和一起度过的锦绣年华，搁浅在时空里的<a href=\"http://www.duwenzhang.com/huati/huaijiu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">怀念</a>，累积成了今日今时的匆匆别离，淡化成了一纸云烟扶摇直上万里长空。未断的<a href=\"http://www.duwenzhang.com/huati/sinian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">思念</a>焚烧了离别的愁绪，夜来的太仓促，街头的风来来往往，恍恍惚惚就无声无息地刮过了四年大学时光。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　曲水流觞，沧海踏歌，唱一段一羽清尘，直到曲终人散。站在街头迎风的位置，我感到怅然若失，<a href=\"http://www.duwenzhang.com/huati/xiwang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">希望</a>离别后的我们一切安好！</p><p><br/></p>', '', '文章阅读网', '/55\\39.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('40', '梦境守望者', '<p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">高考以后我们才懂，有很多事情我们真的无能为力</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，也许<a href=\"http://www.duwenzhang.com/huati/nvhai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">女孩</a>子吸引人的首先还是容貌与身材，<a href=\"http://www.duwenzhang.com/huati/xingge/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">性格</a>与智慧人真不一定稀罕</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，有些<a href=\"http://www.duwenzhang.com/wenzhang/aiqingwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">爱情</a>在高考面前卑微了</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，有些<a href=\"http://www.duwenzhang.com/wenzhang/youqingwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">友情</a>在高考面前依然不屈</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，<a href=\"http://www.duwenzhang.com/huati/fumu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">父母</a>永远不离不弃，即使我隐藏自己的<a href=\"http://www.duwenzhang.com/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">故事</a>，冷落他们的关心</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，如胶似漆的友情，毕业后不联系，依然刻骨铭心</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，友情是自己付出一定有回报的，但爱情不是，<a href=\"http://www.duwenzhang.com/wenzhang/qinqingwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">亲情</a>却不需要我们付出</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，高中生涯真的很<a href=\"http://www.duwenzhang.com/huati/nanwang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">难忘</a>，我很爱我们的集体</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，高一高二玩一玩其实没关系的，高三的玩更重要</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，除了高中的<a href=\"http://www.duwenzhang.com/huati/laoshi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">老师</a>和同学，我还<a href=\"http://www.duwenzhang.com/huati/xiangnian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">想念</a>我的初中我的小学</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，考上清华北大也没什么了不起，考试<a href=\"http://www.duwenzhang.com/huati/shibai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">失败</a>甚至落榜 天也没有塌下来</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，名校和大专，大家都是一条起跑线，<a href=\"http://www.duwenzhang.com/huati/chenggong/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成功</a>也讲运气</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，总以为高考是<a href=\"http://www.duwenzhang.com/huati/zhongdian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">终点</a>，其实是新的起点</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂， 对有些人高四之所以刻骨铭心，除了要高考的事实，还承受着别的事情</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，男<a href=\"http://www.duwenzhang.com/huati/haizi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">孩子</a>最重要的是才华与<a href=\"http://www.duwenzhang.com/huati/zeren/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">责任</a>心，女孩子们对帅哥从来都没有热情</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，毕业后，我们还在一起是种<a href=\"http://www.duwenzhang.com/huati/xingfu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">幸福</a>，我的好<a href=\"http://www.duwenzhang.com/huati/pengyou/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">朋友</a></p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，毕业后，我们还在一起是种奢望，我的……</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，少做一张卷子真的没关系，<a href=\"http://www.duwenzhang.com/huati/xintai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">心态</a>是很重要的</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，公平是相对的，不公平是绝对的</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，没有最好，只有更好，不<a href=\"http://www.duwenzhang.com/huati/wanmei/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">完美</a>才完美</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，<a href=\"http://www.duwenzhang.com/huati/xianshi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">现实</a>会让自己不安与恐惧，前所未有的那种</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，高三的时候自己可以更加<a href=\"http://www.duwenzhang.com/huati/nuli/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">努力</a>一点</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，一分耕耘一分收获</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，一分耕耘一分收获是假的有时候</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，高考算什么</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，有些人变得更亲了</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，更多的人长大了，<a href=\"http://www.duwenzhang.com/huati/chengshu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成熟</a>了</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，毕业后的聚会真的很重要，完全可以没有压力，没有冲突。大家的笑靥如花，多好！</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　高考以后我们才懂，承诺不再随口说说了</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　但如果你承诺，我就<a href=\"http://www.duwenzhang.com/huati/xiangxin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">相信</a>你</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal;\">　　此文谨献给2014年高考毕业班的朋友们收起</p><p><br/></p>', '', '毕业六月，高三回首', '/55\\40.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('41', '文章阅读网', '<p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">321十七岁的天空没有<a href=\"http://www.duwenzhang.com/huati/yanlei/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">眼泪</a>，只有苦涩的<a href=\"http://www.duwenzhang.com/huati/huiyi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">回忆</a>。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　一转眼初中三年就要过去了，看的黑板上的倒计时，一天一天的减少，初中三年的所有的回忆都在我脑海中慢慢的浮现出来了啊。班主任刘<a href=\"http://www.duwenzhang.com/huati/laoshi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">老师</a>是教数学的啊！教学还可以吧！是一个比较好的老师，她每天早上会在黑板上写五道题，每天把题做完，交上去她还会批改。有一回我们同学把一张标签，当老师给别的同学讲题时，贴在她的身上了，她没有发觉。我们也没告诉她，第二天早上老师就发火了，在教室里嗷嗷喊，问到底是谁干的啊！没有人理她。在初中我很少去辅导，就辅导过数学和<a href=\"http://www.duwenzhang.com/wenzhang/yingyuwenzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">英语</a>，因为英语辅导不要钱，数学只收我一半钱，剩下那些科，我同学有辅导的啊！我和他非常要好，可以说是哥们，我就和他借他的辅导资料，抄在一个本上，然后，在把他的辅导资料返给他。这样我不去辅导，我也知道他们辅导什么了，我自然也就会了一些啊！。初中这几年，我基本都抄他的学习质料啊。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有一天，美术老师让同学从家里拿来鸡蛋，不管用什么方法，让鸡蛋在一米以上的高度往下丢鸡蛋不碎就行。我从家里带来了，吃剩下的碗糕盒，在中间挖个洞，然后在用纸卷个筒，把鸡蛋放在纸筒中间，纸筒两边我还放上了两个大纸风筝，来减少装鸡蛋的盒落下的速度。我看见别的组，都<a href=\"http://www.duwenzhang.com/huati/shibai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">失败</a>了啊！轮到我们组了，糟糕我忘拿鸡蛋了，正好我组有个女生拿鸡蛋了，她把鸡蛋放在桌子上来回滚的玩。我说鸡蛋借我用一下，她却说别把它的鸡蛋弄碎了，我说碎了，我给你买一个行了吧！最后她把鸡蛋给了我，我照我的想法去做了，我<a href=\"http://www.duwenzhang.com/huati/chenggong/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成功</a>了，鸡蛋没碎，我们组赢了啊！这时我们组的成员给我鼓掌，然后全班都给我鼓掌，这是我第一次有人为我鼓掌，并且我们组的成员还有女生，有女生为你鼓掌，可以激发你的斗志，那时的<a href=\"http://www.duwenzhang.com/huati/ganjue/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">感觉</a>无法用语言来表达啊。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　初中老师经常说：早恋就像一棵枣树上的枣子，不过它是一个虽然外表红了，但是它内部却有虫子，最好别那么早搞对象，因为你们都没<a href=\"http://www.duwenzhang.com/huati/chengshu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成熟</a>。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　这句话根深地步的印在我的心里了啊！因为我想高中可能会有适合我的啊。可是却发生一件戏剧性的事情，就像电视里演的那样，我遇见了她，我的世界里又多了一个人。那天我回家正好遇见了她，我就和她闲聊天。我看见她手里拿个本子，我就问这个是什么啊！她说这个是什么啊！她说这是信纸，我说道信纸！她说就是信纸吗？我说给我一张吧！她说好啊！咱俩做笔友啊！</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　笔友！什么是笔友啊！她说就是彼此写信呗！哦！原来是这样啊！。我看见这上还有歌词啊！你会唱吗？她说好啊！我们一边推的自行车，她一边唱，虽然没有白灵鸟的歌声好听，但也能听懂唱什么，我说：大姐人家唱歌要钱，你唱歌要命啊！。我推车就跑，她推车就在后面追，一边追一边唱。到家之后，就在那张信纸上飞快的写上了一整篇字，晚上，我出去玩，顺便把那张信带上了。在外面遛达，正好碰见了她。她和我一个<a href=\"http://www.duwenzhang.com/huati/meimei/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">妹妹</a>在一棵槐树下，看见了我就叫我过去，我走到去，槐树花落了下来，落到了我的身上。一阵轻风吃来，淡淡的花香扑鼻而来。她给了我一封信。我刚要想看，她非让我回家看，我当场就打开了，说我是黄瓜。给我起了个笔名，好像叫什么瘦黄瓜，我有那么瘦吗？我对她说：“我瘦吗”她说恩啊！有点瘦。然后我又说那也不至于把我比喻成瘦黄瓜啊！你看这个字你还写错了啊！她在旁边嘻嘻的笑。然后我把先前写好的信给了她，然后对她说：“你回家看”我那个小妹就和她抢信，她俩就在那儿抢，我就回家了。第二天，晚上我又出来遛达，又看见了她。我们又聊会天，她竟然说：“明天一起走啊！我说：“好啊！几点”她说6：30，哦！那好，明天见。我静静的进了屋，轻轻的把门关上。自从有了<a href=\"http://www.duwenzhang.com/huati/didi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">弟弟</a>，<a href=\"http://www.duwenzhang.com/huati/fumu/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">父母</a>就不怎么管我了，我在小屋地下的床上睡，看会书，然后就把灯关了，开始睡觉了。第二天我起来的很早，吃完早餐都以经6：00了然后，我就骑车到道口等她，不一会她就来了，我们就骑着小车向学校飞快跑去。她的乌黑的头发在风中不停着随风摇摆，那样美，一种说不出来的美。初三有作不完的试卷，每天都要不停止的作题，一道数学题能讲到两节课，一看见数学题，我脑袋都大了。可一想到晚上放学，能看见她。心里就特别兴奋，我们之间好像有说不完的话，和她在一起，有一种特殊的感觉，无法用语言来表达。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　晚上我们手牵着手在黑色的夜里慢慢的走。黑夜好像一个黑色无形的囚牢把我们俩人的心，紧紧的关在了一起，使两个人彼此都关心的对方。坐在一块石头上，我们仰望星空，谈论自己的<a href=\"http://www.duwenzhang.com/huati/mengxiang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">梦想</a>与<a href=\"http://www.duwenzhang.com/huati/lixiang/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">理想</a>。有时她会坐在我的腿上，我轻轻着抱着她，生怕她从我怀中遛走。那次我去参加考试，她竟然在家里画了一幅画，画了一个大油桶，后面写着加油。还写祝我考试顺利，这些都是我考试回来时听他们告诉我的。那天我在屋里看书，她跑到我家门口喊我，我出去了，她给了我一件东西。那上面还有一条龙，我说：“这个是什么啊！”她说：“这个是情侣链。”然后她又把她那块拿了出来，她那块上面竟然是一只凤凰。我两把两块合在一起，竟然是一个心形，这个是玉的吧！我说道，她说：“恩啊！我姐给我买的”晚上我又出去，碰见了她，她以经在那里等我呢。走过去轻轻拍她一下，笑着说是不是等我了啊！嘻嘻！你猜呢？这个嘛可不好猜啊！你心里怎么想着我怎么能知道啊！我说着对吧！嘻嘻！你说着也有道理啊！手牵着手走在田野里的小路上，路边草丛里有蟋蟀的叫声，那声音忽远忽近，今夜是那么寂静。看！快看！流星！我向她手指的方向看过去。果然是流星啊！拖着长长着尾吧！在星空中划出一条<a href=\"http://www.duwenzhang.com/huati/wanmei/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">完美</a>的轨迹。我问她许愿了吗？恩啊！我许愿了，她说道。快！对我说说，你都许什么愿了啊！她小嘴一翘，嘘！<a href=\"http://www.duwenzhang.com/huati/mimi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">秘密</a>！不告诉你。那好吧！我就不问了，我们又走了几步，哇！快看！又有两颗流星。我心想：今天的流星为什么这么多啊！会不会有流星雨啊！可是后来不知道怎么了，我晚上在找她，她不理我了。并且晚上在也不出来了，我不明白到底我那里作错了，导致她不理我了。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有一晚上我遇见她，她给了我一张小纸条，让我回家再看，我没有说什么，我就回家了。正如我想像中的那样，小纸条只写了五个字：咱俩<a href=\"http://www.duwenzhang.com/huati/fenshou/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">分手</a>吧！我看完……我想不明白，为什么会分。都以经这样了，无法改变<a href=\"http://www.duwenzhang.com/huati/xianshi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">现实</a>了。我把小纸条点燃，看那红色的火焰静静着燃烧，我的心隐约有点痛。我躺在床上不一会就睡着了，梦里又出现了她<a href=\"http://www.duwenzhang.com/huati/keai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">可爱</a>的<a href=\"http://www.duwenzhang.com/huati/xiaorong/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">笑容</a>，她那双眼睛不停的瞅着我，一句话也不说。突然，她在我眼前消失了。我一下子就醒了过来，哦！原来是一个梦啊！早上！我像往常一样在老地方等她上学，等好常<a href=\"http://www.duwenzhang.com/huati/shijian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">时间</a>她也没来，我突然想起来了，我们分手了吗？她一定先走了。在学校里，我须要作很多的卷纸。初三有作不完的试卷，不停止的写，大大小小的考试，都压着你喘不过气来。黑板上着倒计时就剩下两天了，时间老人当你一不留神时，他就以经从你身边遛走了。唉呀！时间过的真快啊！马上就要中考了。我还没准备好了啊！晚上，我坐在窗前，仰望星河。思索着，突然一只飞蛾飞过我的眼前，我眼光一闪。我要成为一只勇敢的飞蛾，不管是火焰还是岩浆我敢飞过去，为梦想加油，中考，我现在准备好了，就等着考试了。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　中考前一天，老师给我们压了几道题，然后班主任又给我们买了一些杏，还洗好了。说道吃杏吉历，考试一定能过。我们男生基本上每人都抢两个杏，而女生有抢着一个杏，还有一个都没抢着的啊！这时老师发言了，你们男生也太不像话了，给女生几个，一人一个，要有绅士风范吗？……晚上回家吃完饭，才六点多钟。<a href=\"http://www.duwenzhang.com/huati/fuqin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">父亲</a>就让我去睡觉去，好好睡一觉，明天好好考啊！父亲拍拍我的肩膀对我说道。我答应了一声，恩！我会的。那夜是那么的静！都能听见窗外虫儿的叫声。我眯上眼睛很久也不能进入梦境中，可能是时间钟在作怪，导致我很久都不能进入梦乡。我静静的眯着眼睛躺在床上一动不动，就是那么躺着。不久，我终于睡着了。早上，父亲把我叫醒了。<a href=\"http://www.duwenzhang.com/huati/muqin/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">母亲</a>一大早就把早餐做好了，还给我煮了几个菏包蛋。我就吃了一个荷包蛋，我就去考试去了，父亲陪我一起去。在考场外有很多家长，他们都在为自己的子女加油！鼓励！他们的<a href=\"http://www.duwenzhang.com/huati/yanshen/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">眼神</a>和我父亲的眼神都很相似，都是那种渴望自己的子女在这次考试中能考一个好成绩。我看了看表，8：00了。我对父亲说道我进去了，马上快考试了。我走进大门，我向大门外看了看，父亲再向我招手，对我说道好好考，不会的题先别做，捡会做得做。我点了点头，表示知道了。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　第一科考语文，我把前面很快就答完了，看了看作文，有一段话，让你自己拟题。还有就是一个题目，让你以这个题目写一篇作文。我看了看题目，《你心中的一朵浪花》我就用这个题目开始写作文了，这时外面下起了大雨，我一想到父亲还在外面了，我的<a href=\"http://www.duwenzhang.com/huati/xinling/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">心灵</a>受到了震憾。我提笔飞书就把作文写完了。最后一段我写到：父亲您就像灯塔里的照明灯，指引我<a href=\"http://www.duwenzhang.com/wenzhang/renshengzheli/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">人生</a>前进的方向。您又好像是一棵大树，我是树下的一棵小草，您为我遮风挡雨，我在您的庇护下茁壮<a href=\"http://www.duwenzhang.com/wenzhang/shenghuosuibi/chengzhang/\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">成长</a>。您不就是我心中的一朵浪花吗？考完语文，我走出考场，此时雨以经停了，在考场外面的家长都在门口盼望自己的<a href=\"http://www.duwenzhang.com/huati/haizi/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">孩子</a>从考场出来。我看见了父亲，父亲看见我就问道考的怎么样啊！我说：“还可以吧”然后就去吃点饭。剩下的那几科都考完了，我父亲问我你感觉你能考上高中吗？自我感觉良好。我差不多吧！不出意外应该能考上。中考完后，在家帮父母干一些活，又给父亲当了几天小工。父亲问我这活怎么样啊！我摇了摇头说道不好，你以后不好好学习就这干这活。我抹了抹脸上的汗，说道好的。没过多久我的录取通知书下来了，我拿着录取通知书给父亲看，我笑的说道父亲您看，我考上了吧！我父亲说道：你要能考上二中该多好啊！我说道：这个也不一样吗？考上就行了呗。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　有一天，我在外面乘凉，我一个妹妹走了过来，手里还拿的一件东西。对我说道：杨杨让我把这个东西给你，我一看这不是她那块的情侣链吗？我问她：“她没和你说什么嘛！她什么都没说，就说让我给你。”哦！没过多久，她突然找我，借我初二的语文书用。我把书给她找了出来，给了她。在家里我没事干，就把自己关在屋里看书。母亲不知道从哪里给我借了几本高中的教科书，母亲对我说道：“儿啊！你可要好好学啊！为了给你借书，我都跑了好几家，才给你借到的啊！你要是不好好学习。都对不起，我给你借的这几本书”。之后，我天天就在家看高中教材，又把高中语文要求背的课文，我背了几篇。数学我也看了一遍，把里面的定律背了背。化学，物理我也看了一遍。那天我出去溜达，她看见了我，说道你等会，我把书给你，我说：“你用完了吗？要不在放你那里几天，反正我也不用啊！不啦！我不用了。说完她就跑回家了，没多会她就回来了，手里还拿着一本书，那本书就是我借给她的啊！她没有直接把书给我，反而把书皮给撕了下来。我有点不明白，她为什么这样做。她说：“我在书皮写了一段话，不想让你知道。”我心想不想让我知道，还写在我书上。我拿起书一看，我书上写了很多对不起。我又翻了翻书，在一页上竟然还写道：“我爱你。”我正想问她这些是什么意思时，她却不知道什么时侯走了。</p><p style=\"font-family: Simsun; font-size: 14px; line-height: 21px; white-space: normal; text-align: center;\">　　我回到家里，在我脑海中浮现中这样几句话：一个是天空中飞翔的鸟，一个是水里畅游的鱼，根本无法在一起。虽然我们在水边相遇，我们彼此都欣赏对方。可是我们无法在一起，天空才是我翱翔的地方，我不能为了自己的<a href=\"http://www.duwenzhang.com/huati/kuaile/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">快乐</a>，使她<a href=\"http://www.duwenzhang.com/huati/likai/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">离开</a>水域，那样她可能会不快乐。我不能，我做不到。就在我将要上高中的那天晚上，她找到了我问我是选择她还是学习。我问是否两者都可以选择，她说：“只能选择其一，我想两者在我心中都很重要，可是这让我如何选择啊！我抿了抿嘴说道；&quot;我!我!我选择学习。”她听了这句话后，就向家的方向跑去，我一直看的她的背影消失在黑夜中，我才回家。告别了，我的<a href=\"http://www.duwenzhang.com/huati/chulian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">初恋</a>。告别了，我的<a href=\"http://www.duwenzhang.com/huati/tongnian/index1.html\" style=\"color: rgb(51, 51, 51); text-decoration: none;\">童年</a>。</p><p><br/></p>', '', '文章阅读网', '/55\\41.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('42', '梦境守望者', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p>&lt;p style=&quot;box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; &gt;<span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MStore主页：</span></p><p><br/></p>', '', '文章阅读网', '/55\\42.html', 'MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。', '0', '1');
INSERT INTO `cms_article` VALUES ('43', '', '<p>&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Transitional//EN&quot; &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd&quot;&gt;</p><p>&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;</p><p>&nbsp; &lt;head&gt;</p><p>&nbsp; &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot; /&gt;</p><p>&nbsp; &lt;title&gt;新闻动态 | MicroPort - Where the Patient Always Comes First&lt;/title&gt;</p><p>&nbsp; &lt;link href=&quot;{ms:globalskin.url/}/css/video_1.css&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot; /&gt;</p><p>&nbsp; &lt;!--[if lte IE 6]&gt;</p><p>&nbsp;&nbsp;</p><p>&lt;style type=&quot;text/css&quot;&gt;</p><p>body { behavior:url(&quot;css/csshover.htc&quot;); }</p><p>&lt;/style&gt;</p><p>&nbsp;&nbsp;</p><p>&lt;![endif]--&gt;</p><p>&nbsp; &lt;/head&gt;</p><p><br/></p><p>&nbsp; &lt;body&gt;</p><p><br/></p><p>&lt;script&gt;</p><p>var userAgentInfo = navigator.userAgent;</p><p>var Agents = new Array(&quot;Android&quot;, &quot;iPhone&quot;, &quot;SymbianOS&quot;, &quot;Windows Phone&quot;, &quot;iPod&quot;);</p><p>var flag = false;</p><p>var v=0</p><p>for ( v = 0; v &lt; Agents.length; v++)</p><p>{</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>if (userAgentInfo.indexOf(Agents[v]) &gt; 0) { flag = true; break; }</p><p>}</p><p>if(flag){window.location=&#39;http://m.microport.com.cn&#39;;</p><p>}</p><p>&lt;/script&gt;</p><p><br/></p><p>&lt;div id=&quot;header&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;container&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;logo_nav&quot;&gt;&lt;a href=&quot;index.php&quot;&gt;&lt;img src=&quot;{ms:globalskin.url/}/images/logo.gif&quot; id=&quot;logo&quot; /&gt;&lt;/a&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;top_nav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;search_box&quot;&gt;&lt;input type=&quot;text&quot; class=&quot;search_txt&quot; id=&quot;search_txt&quot; /&gt;&lt;input type=&quot;button&quot; class=&quot;search_btn&quot; id=&quot;button&quot; /&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;lang_box&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;dl&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;dt&gt;中文&lt;/dt&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;dd&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;../en/&quot; class=&quot;en&quot;&gt;ENGLISH&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;###&quot; class=&quot;cn&quot;&gt;中文&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/dd&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/dl&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;contact.php?curr_page=contact&quot;&gt;联系我们&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;ten.php?curr_page=fifteen&quot;&gt;微创&amp;reg;年轮&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://www.microport.com/cn/careers&quot;&gt;人才中心&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;top_side_nav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=video&quot; class=&quot;video_link&quot;&gt;视频&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;rss_media.php&quot; target=&quot;_blank&quot; class=&quot;share_link&quot;&gt;分享&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;https://mail.microport.com.cn&quot; class=&quot;mail_link&quot; target=&quot;_blank&quot;&gt;邮箱&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;main_nav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;homeNav&quot;&gt;&lt;a href=&quot;index.php&quot; class=&quot;nav &quot;&gt;首页&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;aboutNav&quot;&gt;&lt;a href=&quot;about.php?curr_page=company&quot; class=&quot;nav &quot;&gt;关于我们&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=company&quot;&gt;简介&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=about_enterprise&quot;&gt;文化精要&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=about_responsibility&quot;&gt;社会责任&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=core_business&quot;&gt;核心业务&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=management&quot;&gt;经营管理&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=milestone&quot;&gt;里程碑&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=awards&quot;&gt;奖项和荣誉&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=about_control2&quot;&gt;企业治理&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;!--&lt;li class=&quot;last&quot;&gt;&lt;a href=&quot;about.php?curr_page=about_subsidiary&quot;&gt;子公司&lt;/a&gt;&lt;/li&gt;--&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;productNav&quot;&gt;&lt;a href=&quot;product.php&quot; class=&quot;nav &quot;&gt;产品介绍&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot; id=&quot;product_sub&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_1&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=1&quot;&gt;心血管&lt;br /&gt;介入产品&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_6&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=6&quot;&gt;骨科&lt;br /&gt;医疗器械&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_2&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=3&quot;&gt;大动脉及外周&lt;br /&gt;血管介入产品&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_5&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=5&quot;&gt;电生理&lt;br /&gt;医疗器械&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_3&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=2&quot;&gt;神经&lt;br /&gt;介入产品&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_4&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=4&quot;&gt;糖尿病及内分泌&lt;br /&gt;医疗器械&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;product_nav_7&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=7&quot;&gt;外科&lt;br /&gt;医疗器械&lt;/a&gt;&lt;/li&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;li class=&quot;product_nav_8&quot;&gt;&lt;a href=&quot;product.php?curr_page=product_list&amp;id=8&quot;&gt;介入&lt;br /&gt;配件&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;medicaNav&quot;&gt;&lt;a href=&quot;media.php?curr_page=news&quot; class=&quot;nav current&quot;&gt;传媒中心&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=news&quot;&gt;新闻动态&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=activity&quot;&gt;专题活动&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=video&quot;&gt;视频中心&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=journal&quot;&gt;内刊&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;last&quot;&gt;&lt;a href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;patientNav&quot;&gt;&lt;a href=&quot;http://health.microport.com&quot; target=&quot;_blank&quot; class=&quot;nav &quot;&gt;患者园地&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://health.microport.com/tests&quot; target=&quot;_blank&quot;&gt;自我检测&lt;/a&gt;&lt;/li&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;li&gt;&lt;a href=&quot;http://health.microport.com/healthcare&quot; target=&quot;_blank&quot;&gt;健康保健&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://health.microport.com/chronic&quot; target=&quot;_blank&quot;&gt;慢病管理&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://health.microport.com/course&quot; target=&quot;_blank&quot;&gt;名医课堂&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://health.microport.com/search-for-doc&quot; target=&quot;_blank&quot;&gt;寻医问病&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;last&quot;&gt;&lt;a href=&quot;http://health.microport.com.cn/wardmate-stroy&quot; target=&quot;_blank&quot;&gt;病友故事&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;doctorNav&quot;&gt;&lt;a href=&quot;http://doctor.microport.com&quot; target=&quot;_blank&quot; class=&quot;nav &quot;&gt;医生天地&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://doctor.microport.com/a/cardiovascular/&quot; target=&quot;_blank&quot;&gt;心血管&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://doctor.microport.com/a/orthopedics/&quot; target=&quot;_blank&quot;&gt;骨科&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://doctor.microport.com/a/endovascular/&quot; target=&quot;_blank&quot;&gt;外周血管&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://doctor.microport.com/a/neurovascular/&quot; target=&quot;_blank&quot;&gt;脑血管&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;last&quot;&gt;&lt;a href=&quot;http://doctor.microport.com&quot; target=&quot;_blank&quot;&gt;其他&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;investorNav&quot;&gt;&lt;a href=&quot;investor.php?curr_page=investor&quot; class=&quot;nav &quot;&gt;投资者关系&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;subNav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_bg&quot;&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;sub_inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;about.php?curr_page=company&quot;&gt;公司资料&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_control&quot;&gt;公司治理&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_service&quot;&gt;股东服务&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_finance&quot;&gt;财务信息&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_event&quot;&gt;重要事件&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_stock&quot;&gt;股票信息&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;investor.php?curr_page=investor_bulletin&quot;&gt;公告&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;last&quot;&gt;&lt;a href=&quot;investor.php?curr_page=investor_contact&quot;&gt;投资者关系联络服务&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;&lt;div id=&quot;wrapper&quot;&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;div id=&quot;inner_img&quot;&gt;&lt;div class=&quot;pagination_bg pngfix&quot;&gt;&lt;/div&gt;&lt;img src=&quot;{ms:globalskin.url/}/images/about_bg_02.jpg&quot; /&gt;&lt;/div&gt;</p><p>&nbsp; &nbsp; &lt;div id=&quot;container&quot; class=&quot;pngfix&quot;&gt;</p><p>&nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;div class=&quot;page_nav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;a href=&quot;rss_media.php&quot; target=&quot;_blank&quot; class=&quot;rss&quot;&gt;RSS订阅&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;###&quot; class=&quot;print&quot; onclick=&quot;window.print()&quot;&gt;打印此页&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;a href=&quot;index.php&quot;&gt;首页&lt;/a&gt;　&gt;　&lt;a href=&quot;media.php?curr_page=news&quot;&gt;传媒中心&lt;/a&gt;　&lt;span&gt;&gt;　新闻动态&lt;/span&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p>&nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;div id=&quot;inner_banner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;dl class=&quot;pngfix&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;dd&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=journal&quot;&gt;内刊&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=video&quot;&gt;视频中心&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=activity&quot;&gt;专题活动&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;media.php?curr_page=news&quot; class=&quot;current&quot;&gt;新闻动态&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/dd&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;dt&gt;传媒中心&lt;/dt&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/dl&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;img src=&quot;{ms:globalskin.url/}/images/banner_news.jpg&quot; /&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;inner&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;h3 class=&quot;title&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;a href=&quot;media.php?curr_page=news&quot; class=&quot;back&quot;&gt;返回&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;a href=&quot;###&quot; title=&quot;特大号字体&quot; id=&quot;extra_size&quot;&gt;A&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;###&quot; title=&quot;大号字体&quot; id=&quot;large_size&quot;&gt;A&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;###&quot; title=&quot;常规字体&quot; id=&quot;normal_size&quot;&gt;A&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;em&gt;字体大小&lt;/em&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;contact.php?curr_page=feedback&quot; class=&quot;mail&quot;&gt;电子邮件通知&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;span&gt;&lt;/span&gt;新闻动态&lt;/h3&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;!--startprint--&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&lt;h4 style=&quot;margin:30px 0 0 39px; font-size:18px; color:#004280; font-weight:normal;&quot;&gt;微创&lt;sup&gt;®&lt;/sup&gt;集团与北京唯迈医疗设备有限公司举行战略合作签约仪式&lt;/h4&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;p style=&quot;text-align:right;&quot;&gt;[2016-03-21]　&lt;a href=&quot;media.php?curr_page=news_print&amp;id=1462&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;{ms:globalskin.url/}/images/print.gif&quot; style=&quot;position:relative; top:3px;&quot; /&gt;&lt;/a&gt;&lt;/p&gt;</p><p>&lt;div class=&quot;activity3&quot;&gt;</p><p>&lt;div class=&quot;detail&quot;&gt;</p><p><br/></p><p>&lt;p&gt;&lt;div&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 中国，上海&amp;mdash;&amp;mdash;近日，上海微创医疗器械（集团）有限公司（以下简称&amp;ldquo;微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团&amp;rdquo;）与TCL医疗集团北京唯迈医疗设备有限公司战略合作签约仪式在微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团总部举行，TCL医疗集团董事、首席科学家曹红光、北京唯迈医疗设备有限公司总经理杨贺等人员出席，微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团首席营销官彭博等出席了本次签约仪式。&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp;&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团与北京唯迈医疗设备有限公司此次战略合作旨在响应2015年发布的《国务院办公厅关于推进分级诊疗制度建设的指导意见》中扩大分级诊疗开展的区域和病种数，实现县（市、区）全覆盖、县域内就诊率达到90%左右的政策，利用双方现有的优势资源进行互补，达成战略同盟，从而达到共同开拓目标市场、提高效益、共同发展的目的。&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp;&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 北京唯迈医疗设备有限公司作为TCL医疗集团下属专注于介入设备的创新型企业，拥有高端介入设备研发和生产能力，深耕介入领域市场，为市场提供一系列高品质介入产品及解决方案。&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp;&lt;/div&gt;</p><p>&lt;div&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团首席营销官彭博在签约仪式上表示，双方的此次合作是在产品属性、渠道资源上的互补，希望能够带来采购机会上的共享、利益上的共赢，最终能让这个项目落地，造福更多基层医疗机构，使更多患者能够享受到高质量的医疗资源和服务。&lt;/div&gt;&lt;/p&gt;</p><p>&lt;p&gt;&lt;span&gt;关于微创集团&lt;/span&gt;&lt;br /&gt;&lt;i&gt;&lt;span style=&quot;font-size:11px&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;微创医疗科学有限公司起源于1998年成立的上海微创医疗器械（集团）有限公司，是一家中国领先的高端医疗器械集团，业务覆盖心血管介入产品、骨科医疗器械、大动脉及外周血管介入产品、电生理医疗器械、神经介入产品、心律管理产品、糖尿病及内分泌医疗器械和外科手术等十大领域。&lt;br&gt;</p><p>&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;微创&amp;reg;医疗的产品已进入全球逾5,000家医院。平均每18秒左右，就有一个产品用于救治患者生命或改善其生活品质或用于帮助其催生新的生命。微创&amp;reg;医疗始终以创建“一个属于患者和医生的品牌”为己任，坚持以人为本在以微创伤为代表的高科技医学领域建设一个属于患者的全球化领先医疗集团。</p><p><br/></p><p>&lt;br&gt;</p><p>&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;更多信息，敬请造访公司网站：&lt;/span&gt;&lt;span class=&quot;link&quot; style=&quot;font-size:11px&quot;&gt;&lt;a href=&quot;http://www.microport.com/cn/&quot;&gt;www.microport.com&lt;/a&gt;&lt;br&gt;&lt;/span&gt;&lt;/i&gt;&lt;/p&gt;</p><p>&lt;p&gt;&lt;span&gt;前瞻性陈述&lt;/span&gt;&lt;br /&gt;&lt;i&gt;&lt;span style=&quot;font-size:11px&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;本网站所发布的信息中可能会包含某些预测性的陈述。这些陈述本质上具有相当风险和不确定性。这类预测性陈述包括但不限于：关于本公司业务经营策略的陈述；关于业务扩建计划（包括与之有关的拟作出的资本投资）的陈述；关于计划研发的新一代医疗器械产品和其他技术及其相关应用的陈述；关于政策和市场变动对本公司经营业绩的预期影响的陈述；关于竞争对本公司经营业绩的影响的陈述；关于中国医疗器械产业未来发展（包括行业结构调整及政府政策变化）的陈述；以及与本公司未来业务发展及经营业绩有关的其他陈述。在使用&quot;预期&quot;、&quot;相信&quot;、&quot;预测&quot;、&quot;预计&quot;、&quot;估计&quot;、&quot;期望&quot;、&quot;打算&quot;、&quot;计划&quot;、&quot;推测&quot;、&quot;深信&quot;、&quot;抱有信心&quot;及其他类似词语进行陈述时，凡与本公司有关的，目的均是要指明其属预测性陈述。本公司并不打算不断地更新这些预测性陈述。这些预测性陈述是反映本公司对将来事件的目前看法，而并非关于将来业务表现的保证。实际业绩可能会因许多因素而与预测性陈述中所述的有重大的出入，这些因素包括但不限于：中国内地医疗器械产业结构的进一步调整；对所需的政府批准及许可、国家食品药品监督管理总局（CFDA）相关政策的调整等有影响的有关政府部门的监管政策的变化；竞争所带来的对本公司医疗器械产品的需求和对价格的影响；会影响本公司医疗器械产品的生存能力和竞争能力的医疗器械产品及相关技术的变化；本公司执行其业务策略的能力，包括进行业务合并、策略投资及收购的能力；以及中国内地的政治、经济、法律及社会各方面情况的变化。另外，本公司未来的业务多元化发展以及其他资本投资和发展计划，均取决于多种因素，包括但不限于是否能以可接受的条款获得足量融资；我们发展和获得新技术及其应用的能力；以及是否有合资格的管理及技术人员等许多因素。&lt;br&gt;</p><p>&nbsp; &nbsp; &nbsp; &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;版权和免责声明&lt;br&gt;</p><p>&nbsp; &nbsp; &nbsp; &amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;版权&amp;#169;2016 微创&amp;reg;医疗。本公司保留一切版权。&lt;/span&gt;&lt;/i&gt;&lt;/p&gt;</p><p>&lt;p&gt;</p><p>&lt;span&gt;欲了解更多详情，敬请联系：&lt;/span&gt;</p><p>&lt;table width=&quot;100%&quot; border=&quot;0&quot; cellspacing=&quot;0&quot; cellpadding=&quot;0&quot;&gt;</p><p>&nbsp; &lt;tr&gt;</p><p>&nbsp; &nbsp; &lt;td width=&quot;35%&quot; valign=&quot;top&quot;&gt;&lt;strong&gt;李香梅&lt;/strong&gt; &lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; 股东与证券事务经理&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; 上海微创医疗器械（集团）有限公司&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; Tel: (86)(21) 38954600-6958&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; Email: &lt;a href=&quot;mailto:ir@microport.com&quot;&gt;ir@microport.com&lt;/a&gt;&lt;/td&gt;</p><p>&nbsp; &nbsp; &lt;td width=&quot;65%&quot; valign=&quot;top&quot;&gt;&lt;strong&gt;张 烨&lt;/strong&gt;&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; 公司发言人&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; 上海微创医疗器械（集团）有限公司&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; Tel: (86)(21) 38954600-6985&lt;br /&gt;</p><p>&nbsp; &nbsp; &nbsp; Email: &lt;a href=&quot;mailto:spokesperson@microport.com&quot;&gt;spokesperson@microport.com&lt;/a&gt;&lt;/td&gt;</p><p>&nbsp; &lt;/tr&gt;</p><p>&lt;/table&gt;</p><p>&lt;/p&gt;</p><p><br/></p><p><br/></p><p><br/></p><p>&lt;/div&gt;</p><p>&lt;br /&gt;</p><p>[下一篇]：&lt;a href=&quot;media.php?curr_page=news_details&amp;type=1&amp;id=1461&quot;&gt;微创&lt;sup&gt;®&lt;/sup&gt;电生理亮相第十三届国际死海研讨会（IDSS 2016）&lt;/a&gt;</p><p>&lt;/div&gt;</p><p>&lt;div style=&quot;clear:both;&quot;&gt;&lt;/div&gt; &nbsp; &nbsp;</p><p><br/></p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;div class=&quot;footer_nav&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;a href=&quot;#&quot; class=&quot;top&quot;&gt;&lt;/a&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;span class=&quot;know_more_outter&quot;&gt;&lt;a href=&quot;media.php?curr_page=video&quot; class=&quot;know_more&quot;&gt;&lt;span&gt;了解视频中心&lt;/span&gt;&lt;/a&gt;&lt;/span&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;div class=&quot;footer_bg&quot; style=&quot;height:2px;&quot;&gt;</p><p>&nbsp; &nbsp; &lt;/div&gt;&lt;/div&gt;</p><p>&lt;script src=&quot;{ms:globalskin.url/}/js/jquery.js&quot;&gt;&lt;/script&gt;&nbsp;</p><p>&lt;script src=&quot;{ms:globalskin.url/}/js/jquery.backstretch.js&quot;&gt;&lt;/script&gt;&nbsp;</p><p>&nbsp;&nbsp;</p><p>&lt;script&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span> &nbsp; &nbsp;$.backstretch([&quot;&quot;]);</p><p>&nbsp; &nbsp; &nbsp; $(&quot;.banner&quot;).backstretch(&quot;images/about_bg_02.jpg&quot;);</p><p>&nbsp; &lt;/script&gt;</p><p>&nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp;</p><p>&nbsp; &nbsp; &lt;div id=&quot;footer&quot;&gt;</p><p>&nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;div class=&quot;container&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>&lt;li class=&quot;first&quot;&gt;&lt;a href=&quot;legal.php?curr_page=legal&quot; class=&quot;dot&quot;&gt;法律声明&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;!--&lt;li&gt;|&lt;/li&gt;--&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://microport.zhiye.com/&quot; target=&quot;_blank&quot; &nbsp;class=&quot;dot&quot;&gt;招贤纳士&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;!--&lt;li&gt;|&lt;/li&gt;--&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;legal.php?curr_page=sitemap&quot; &nbsp;class=&quot;dot&quot;&gt;网站地图&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a class=&quot;dot&quot; style=&quot;color:#6c6c6c&quot;&gt;关注我们&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://weibo.com/microportchina&quot; target=&quot;_blank&quot; class=&quot;weibo_link&quot; &gt;&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;###&quot; class=&quot;weixin_link&quot;&gt;&lt;/a&gt;&lt;img src=&quot;{ms:globalskin.url/}/images/weixin_code.png&quot; id=&quot;weixin_code&quot; /&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://i.youku.com/microport&quot; target=&quot;_blank&quot; class=&quot;video_link&quot;&gt;&lt;/a&gt;&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;!--&lt;li&gt;|&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li class=&quot;mail_bar&quot;&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;input type=&quot;text&quot; name=&quot;textfield2&quot; class=&quot;mail_txt&quot; /&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;input name=&quot;&quot; type=&quot;image&quot; id=&quot;mail_btn&quot; src=&quot;images/common/index_262.jpg&quot; /&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/li&gt;&lt;li&gt;|&lt;/li&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;li&gt;&lt;a href=&quot;http://weibo.com/microportchina&quot; target=&quot;_blank&quot; class=&quot;weibo_link&quot;&gt;微创微博&lt;/a&gt;&lt;/li&gt;--&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;/ul&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;p&gt;&amp;copy;Copyright 1998-2016, MicroPort Scientific Corporation. All rights reserved. &lt;/p&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;p&gt;互联网药品信息服务资格证书编号：（沪）- 非经营性 - 2011-0128&lt;/p&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &lt;img src=&quot;{ms:globalskin.url/}/images/bottom_logo.gif&quot; id=&quot;bottom_logo&quot; /&gt;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp; &lt;/div&gt;</p><p>&nbsp; &nbsp;&nbsp;</p><p>&lt;script language=&quot;javascript&quot; type=&quot;text/javascript&quot; src=&quot;{ms:globalskin.url/}/js/menu.js&quot;&gt;&lt;/script&gt; &nbsp;</p><p>&nbsp;&nbsp;</p><p>&nbsp;&nbsp;</p><p>&lt;!--&lt;script type=&quot;text/javascript&quot;&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>var gaJsHost = ((&quot;https:&quot; == document.location.protocol) ? &quot;https://ssl.&quot; : &quot;http://www.&quot;);</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>document.write(unescape(&quot;%3Cscript src=&#39;&quot; + gaJsHost + &quot;google-analytics.com/ga.js&#39; type=&#39;text/javascript&#39;%3E%3C/script%3E&quot;));</p><p>&lt;/script&gt;</p><p>&lt;script type=&quot;text/javascript&quot;&gt;</p><p>try {</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>var pageTracker = _gat._getTracker(&quot;UA-10503690-1&quot;);</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>pageTracker._trackPageview();</p><p>} catch(err) {}</p><p>&lt;/script&gt;--&gt;</p><p>&lt;script&gt;</p><p>&nbsp; (function(i,s,o,g,r,a,m){i[&#39;GoogleAnalyticsObject&#39;]=r;i[r]=i[r]||function(){</p><p>&nbsp; (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),</p><p>&nbsp; m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)</p><p>&nbsp; })(window,document,&#39;script&#39;,&#39;//www.google-analytics.com/analytics.js&#39;,&#39;ga&#39;);</p><p><br/></p><p>&nbsp; ga(&#39;create&#39;, &#39;UA-10503690-1&#39;, &#39;microport.com.cn&#39;);</p><p>&nbsp; ga(&#39;send&#39;, &#39;pageview&#39;);</p><p><br/></p><p>&lt;/script&gt;</p><p><br/></p><p><br/></p><p>&nbsp; &lt;script type=&quot;text/javascript&quot; src=&quot;jquery-1.9.1.min.js&quot;&gt;&lt;/script&gt;</p><p>&lt;script type=&quot;text/javascript&quot; src=&quot;{ms:globalskin.url/}/js/common.js&quot;&gt;&lt;/script&gt;</p><p>&lt;script type=&quot;text/javascript&quot; src=&quot;{ms:globalskin.url/}/js/jquery.jcarousel.js&quot;&gt;&lt;/script&gt;</p><p>&nbsp;&nbsp;</p><p>&lt;script&gt;</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&#39;.journal_content&#39;).eq(0).show();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&#39;.journal li&#39;).click(function(){</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>var currLi = $(this).index();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&#39;.journal_content&#39;).hide().eq(currLi).show();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&#39;.journal li&#39;).removeClass(&#39;now&#39;);</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(this).addClass(&#39;now&#39;);</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;#normal_size&quot;).click(function(e){</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>e.preventDefault();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 .detail&quot;).css({&quot;fontSize&quot;:&quot;12px&quot;,lineHeight:&quot;20px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 span&quot;).css({&quot;fontSize&quot;:&quot;14px&quot;,lineHeight:&quot;20px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;#large_size&quot;).click(function(e){</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>e.preventDefault();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 .detail&quot;).css({&quot;fontSize&quot;:&quot;14px&quot;,lineHeight:&quot;22px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 span&quot;).css({&quot;fontSize&quot;:&quot;16px&quot;,lineHeight:&quot;20px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;#extra_size&quot;).click(function(e){</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>e.preventDefault();</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 .detail&quot;).css({&quot;fontSize&quot;:&quot;18px&quot;,lineHeight:&quot;25px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>$(&quot;.activity3 span&quot;).css({&quot;fontSize&quot;:&quot;20px&quot;,lineHeight:&quot;20px&quot;});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span>});</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p>function preview()</p><p>{</p><p>&nbsp; &nbsp; bdhtml=window.document.body.innerHTML;</p><p>&nbsp; &nbsp; sprnstr=&quot;&lt;!--startprint--&gt;&quot;;</p><p>&nbsp; &nbsp; eprnstr=&quot;&lt;!--endprint--&gt;&quot;;</p><p>&nbsp; &nbsp; prnhtml=bdhtml.substr(bdhtml.indexOf(sprnstr)+17);</p><p>&nbsp; &nbsp; prnhtml=prnhtml.substring(0,prnhtml.indexOf(eprnstr));</p><p>&nbsp; &nbsp; window.document.body.innerHTML=prnhtml;</p><p>&nbsp; &nbsp; window.print();</p><p>}</p><p><span class=\"Apple-tab-span\" style=\"white-space:pre\"></span></p><p>&lt;/script&gt;</p><p>&nbsp;&nbsp;</p><p>&lt;!--[if IE 6 ]&gt;</p><p>&lt;script language=&quot;javascript&quot; type=&quot;text/javascript&quot; src=&quot;js/png.js&quot;&gt;&lt;/script&gt;</p><p><br/></p><p>&lt;script&gt;&nbsp;</p><p>DD_belatedPNG.fix(&#39;.pngfix&#39;);</p><p>document.execCommand(&quot;BackgroundImageCache&quot;,false,true);</p><p>&lt;/script&gt;</p><p>&lt;![endif]--&gt;</p><p><br/></p><p>&lt;/body&gt;</p><p>&lt;/html&gt;</p><p><br/></p>', '', '', '/57\\43.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('172', '', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站整体策划</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">企业网站建设目的何在？如何充分挖掘互联网络的资源和优势，如何合理地组织网站内容与功能从而达到客户的需求？<br style=\"padding: 0px; margin: 0px;\"/>我们将根据市场分析、客户产品及服务的优势、竞争对手分析等等，有效的确立网站定位。根据相关需求分析获得相应网站运营策略，在网站建立之初我们就网站VI形象、网站营销手段、运营模式、网站发展前景等等进行定位。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;<span style=\"padding: 0px; margin: 0px; font-size: 14px;\"></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站设计&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">DESIGN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">网络媒体不同于传统媒体，如果在网站设计的时候仅仅是将文字和图片做一个简单堆积和展示的话，这样的网站跟一片丢落在街头的破旧宣传资料没有任何区别。客户往往通过企业网站就留下了对企业的第一印象，这个第一印象是决定客户是否与你合作的重要因素。<br style=\"padding: 0px; margin: 0px;\"/>所以站在浏览者的角度，我们分析企业特点和品牌内涵，完美的通过网站体现企业形象，并严格采用W3C国际标准进行网站设计，采用DIV+CSS构 架，不但使您的网站具备足够的扩展性，您网站的速度、兼容性、友好性也都会显著提高，更主要的是，代码和表现分离的方式让您的网站改版变得更容易，而针对 SEO搜索引擎优化的工作也变得更加的畅通。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站建设售后服务&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">SALES</span></span></p><p>&lt;p style=&quot;padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; &gt;网站建设专家致力于为客户提供优质的产品及服务。为了多渠道的了解客户的需求，快速响应个性化需要，不断完善售后服务工作，我们客户服务管理部在此为您搭建了这个沟通的平台，我们希望通过网络加强与客户的交流。<br style=\"padding: 0px; margin: 0px;\"/>完善的售后服务是公司信誉的保障和服务趋于完善与成熟的象征，因此，我们在这一方面投入了较大的精力，确保每一位客户的利益得到充分的保障，从而提高企业信誉，发展长期友好的合作。<br style=\"padding: 0px; margin: 0px;\"/>对于享受我公司建站服务的客户，我们提供免费一年售后服务。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网站全程维护&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">MAINTAIN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">网页制作好了以后并不是就没事了？其实日后的更新维护才是最重要的！如果参观网站的访问者每次看到的网站都是一样的，那么它们日后还会来吗？这时候，您的网页要由谁来维护呢？<br style=\"padding: 0px; margin: 0px;\"/>严格来说，每一个站点都应该由专业人员定期更新维护。互联网络的最大优势就是信息的实时性，只有快速的反映，准确的报道，才能吸引更多的浏览者。<br style=\"padding: 0px; margin: 0px;\"/>目前很多站点人气很旺，应该和定期更新分不开的。也有很多站点由于种种原因，数月才更新一次，这样就违背了网路最基本的商业目的。网站不是购买一件商品，随着时间的推移而贬值陈旧，只有不断的溶入企业发展动向，推陈出新，才会具有创造力，发挥网路商业潜能。<br style=\"padding: 0px; margin: 0px;\"/>更新维护不仅仅只局限于简单的更换文字稿，应该是将企业的商业动态和发展方向充分考虑进去， 再结合现有的网站规划结构，迅速作出相应的改进。企业的每一个新项目的推广和价格的浮动、内部结构调整， 不应该只是在报纸、电视等媒体做宣传而忽略网路这个最具有潜力的市场。 这也是我们一直强调的商业网站 CIS 策略。<br style=\"padding: 0px; margin: 0px;\"/>鉴于目前大多数网站不具有专业维护的技术力量，网站建设公司可为广大客户提供专业服务。每一个企业可根据自身的商业特征制定不同的维护方案，并保证在最短的时间内迅速完成。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网页改版&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">REVISED</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">企业上网已成趋势，企业网站犹如雨后春笋般地拔起，试问：<br style=\"padding: 0px; margin: 0px;\"/>您的企业通过互联网进行了巨额的投入，但网站到底给您带来了多大的效益？<br style=\"padding: 0px; margin: 0px;\"/>您的网站从建立到现在，更新过几次、改版过几次？<br style=\"padding: 0px; margin: 0px;\"/>功能不全、设计不美观、布局不合理、几乎从不更新的网站会给企形象带来多大的负面影响？<br style=\"padding: 0px; margin: 0px;\"/>选择网站建站专家，帮您重新审视和构架您的网站系统，我们提供八项全能服务，全面改善您的网站系统，专为您解决企业上网后顾之忧。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">培训解决方案&nbsp;<span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\">TRAIN</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">为了更好地做好企业外部门户网站的技术培训工作，将选派具有丰富技术培训和实施经验的技术人员组成培训小组，编写详尽实用的培训教材，并且制定切实有效的培训方案。技术培训的工作为应用软件系统管理和使用培训。<br style=\"padding: 0px; margin: 0px;\"/>在软件产品实践培训中，采用集中培训的方式，的培训师针对本系统的技术特点，为企业技术人员提供全面培训，培训内容涵盖了本此系统建设过程中使用的主要技术理论和产品实践。<br style=\"padding: 0px; margin: 0px;\"/>在应用软件系统管理和使用培训中，我们会组织项目开发小组的主要人员针对管理和使用人员的不同需求，提供不同层次的培训课程。</p><p><br/></p>', 'p,', '', '/53/133\\index.html', '网络媒体不同于传统媒体，如果在网站设计的时候仅仅是将文字和图片做一个简单堆积和展示的话，这样的网站跟一片丢落在街头的破旧宣传资料没有任何区别。客户往往通过企业网站就留下了对企业的第一印象，这个第一印象是决定客户是否与你合作的重要因素。', '0', '1');
INSERT INTO `cms_article` VALUES ('184', '', '<p><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">光学镜头是机器视觉系统中必不可少的部件，按焦距可分为短焦镜头、中焦镜头，长焦镜头；按视场大分为广角、标准，远摄镜头；按结构分为固定光圈定焦镜头，手动光圈定焦镜头，自动光圈定焦镜头，手动变焦镜头、自动变焦镜头，自动光圈电动变焦镜头，电动三可变（光圈、焦距、聚焦均可变）镜头等。按接口类型可分为C型镜头、CS型镜头、U型镜头和特殊镜头。</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">1、C型镜头</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">　　&nbsp;C型镜头法兰焦距是安装法兰到入射镜头平行光的汇聚点之间的距离。法兰焦距为17.526mm或0.690in。安装罗纹为：直径1in，32牙.in。镜头可以用在长度为0.512in (13mm)以内的线阵传感器。但是，由于几何变形和市场角特性，必须鉴别短焦镜头是否合用。如焦距为12.6mm的镜头不应该用长度大于6.5mm的线阵。如果利用法兰焦距尺寸确定了镜头到列阵的距离，则对于物方放大倍数小于20倍时需增加镜头接圈。接圈加在镜头后面，以增加镜头到像的距离，以为多数镜头的聚焦范围位 5－10％。镜头接长距离为焦距/物方放大倍数。加一个5mm接圈，一个C口镜头可以接CS口的相机。</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">2、CS型镜头</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">　　&nbsp;CS型镜头可以直接接在CS口的相机上，但是即CS mount镜头不能与C mount相机一起使用。</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">3、U型镜头</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">　　&nbsp;U型镜头为一种可变焦距的镜头，其法兰焦距为47.526mm或1.7913in，安装罗纹为M42×1。主要设计作35mm照片应用，可用于任何长度小于 1.25in(38.1mm)的列阵。</span><br style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: Arial, Verdana, Helvetica, sans-serif; font-size: 12px; line-height: 24px;\">　　&nbsp;在数字图像处理领域，有一套含有两种接口规格（C mount和CS mount）的标准镜头装配。由此产生了四种组合方式，如下图所示。其中之一不匹配：即CS mount镜头不能与C mount相机一起使用。</span></p>', '', '', '/120/122\\184.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('45', '', '<p>&nbsp;中国，上海——近日，上海微创医疗器械（集团）有限公司（以下简称“微创<sup style=\"margin: 0px; padding: 0px; outline: none;\">®</sup>集团”）与TCL医疗集团北京唯迈医疗设备有限公司战略合作签约仪式在微创<sup style=\"margin: 0px; padding: 0px; outline: none;\">®</sup>集团总部举行，TCL医疗集团董事、首席科学家曹红光、北京唯迈医疗设备有限公司总经理杨贺等人员出席，微创<sup style=\"margin: 0px; padding: 0px; outline: none;\">®</sup>集团首席营销官彭博等出席了本次签约仪式。</p><p>&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; 微创<sup style=\"margin: 0px; padding: 0px; outline: none;\">®</sup>集团与北京唯迈医疗设备有限公司此次战略合作旨在响应2015年发布的《国务院办公厅关于推进分级诊疗制度建设的指导意见》中扩大分级诊疗开展的区域和病种数，实现县（市、区）全覆盖、县域内就诊率达到90%左右的政策，利用双方现有的优势资源进行互补，达成战略同盟，从而达到共同开拓目标市场、提高效益、共同发展的目的。</p><p>&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; 北京唯迈医疗设备有限公司作为TCL医疗集团下属专注于介入设备的创新型企业，拥有高端介入设备研发和生产能力，深耕介入领域市场，为市场提供一系列高品质介入产品及解决方案。</p><p>&nbsp;</p><p>&nbsp; &nbsp; &nbsp; &nbsp; 微创<sup style=\"margin: 0px; padding: 0px; outline: none;\">®</sup>集团首席营销官彭博在签约仪式上表示，双方的此次合作是在产品属性、渠道资源上的互补，希望能够带来采购机会上的共享、利益上的共赢，最终能让这个项目落地，造福更多基层医疗机构，使更多患者能够享受到高质量的医疗资源和服务。</p><p style=\"margin-top: 0px; margin-bottom: 20px; padding: 0px 0px 20px; outline: none; font-size: 12px; border-bottom-width: 1px; border-bottom-style: dashed; border-bottom-color: rgb(229, 229, 229); color: rgb(112, 112, 112); font-family: Arial, &#39;5FAE软雅黑&#39;, 微软雅黑, &#39;Microsoft Yahei&#39;, Helvetica, sans-serif; line-height: 20px; white-space: normal; widows: 1;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 20px; padding: 0px 0px 20px; outline: none; font-size: 12px; border-bottom-width: 1px; border-bottom-style: dashed; border-bottom-color: rgb(229, 229, 229); color: rgb(112, 112, 112); font-family: Arial, &#39;5FAE软雅黑&#39;, 微软雅黑, &#39;Microsoft Yahei&#39;, Helvetica, sans-serif; line-height: 20px; white-space: normal; widows: 1;\"><span style=\"margin: 0px; padding: 0px; outline: none; color: rgb(152, 152, 152); font-size: 14px;\">关于微创集团</span><br style=\"margin: 0px; padding: 0px; outline: none;\"/><em style=\"margin: 0px; padding: 0px; outline: none;\"><span style=\"margin: 0px; padding: 0px; outline: none; color: rgb(152, 152, 152); font-size: 11px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;微创医疗科学有限公司起源于1998年成立的上海微创医疗器械（集团）有限公司，是一家中国领先的高端医疗器械集团，业务覆盖心血管介入产品、骨科医疗器械、大动脉及外周血管介入产品、电生理医疗器械、神经介入产品、心律管理产品、糖尿病及内分泌医疗器械和外科手术等十大领域。<br style=\"margin: 0px; padding: 0px; outline: none;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;微创®医疗的产品已进入全球逾5,000家医院。平均每18秒左右，就有一个产品用于救治患者生命或改善其生活品质或用于帮助其催生新的生命。微创®医疗始终以创建“一个属于患者和医生的品牌”为己任，坚持以人为本在以微创伤为代表的高科技医学领域建设一个属于患者的全球化领先医疗集团。&nbsp;<br style=\"margin: 0px; padding: 0px; outline: none;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;更多信息，敬请造访公司网站：</span><span class=\"link\" style=\"margin: 0px; padding: 0px; outline: none; color: rgb(152, 152, 152); font-size: 11px;\"><a href=\"http://www.microport.com/cn/\" style=\"margin: 0px; padding: 0px; outline: none; color: rgb(0, 66, 128);\">www.microport.com</a><br style=\"margin: 0px; padding: 0px; outline: none;\"/></span></em></p><p style=\"margin-top: 0px; margin-bottom: 20px; padding: 0px 0px 20px; outline: none; font-size: 12px; border-bottom-width: 1px; border-bottom-style: dashed; border-bottom-color: rgb(229, 229, 229); color: rgb(112, 112, 112); font-family: Arial, &#39;5FAE软雅黑&#39;, 微软雅黑, &#39;Microsoft Yahei&#39;, Helvetica, sans-serif; line-height: 20px; white-space: normal; widows: 1;\"><span style=\"margin: 0px; padding: 0px; outline: none; color: rgb(152, 152, 152); font-size: 14px;\">前瞻性陈述</span><br style=\"margin: 0px; padding: 0px; outline: none;\"/><em style=\"margin: 0px; padding: 0px; outline: none;\"><span style=\"margin: 0px; padding: 0px; outline: none; color: rgb(152, 152, 152); font-size: 11px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;本网站所发布的信息中可能会包含某些预测性的陈述。这些陈述本质上具有相当风险和不确定性。这类预测性陈述包括但不限于：关于本公司业务经营策略的陈述；关于业务扩建计划（包括与之有关的拟作出的资本投资）的陈述；关于计划研发的新一代医疗器械产品和其他技术及其相关应用的陈述；关于政策和市场变动对本公司经营业绩的预期影响的陈述；关于竞争对本公司经营业绩的影响的陈述；关于中国医疗器械产业未来发展（包括行业结构调整及政府政策变化）的陈述；以及与本公司未来业务发展及经营业绩有关的其他陈述。在使用&quot;预期&quot;、&quot;相信&quot;、&quot;预测&quot;、&quot;预计&quot;、&quot;估计&quot;、&quot;期望&quot;、&quot;打算&quot;、&quot;计划&quot;、&quot;推测&quot;、&quot;深信&quot;、&quot;抱有信心&quot;及其他类似词语进行陈述时，凡与本公司有关的，目的均是要指明其属预测性陈述。本公司并不打算不断地更新这些预测性陈述。这些预测性陈述是反映本公司对将来事件的目前看法，而并非关于将来业务表现的保证。实际业绩可能会因许多因素而与预测性陈述中所述的有重大的出入，这些因素包括但不限于：中国内地医疗器械产业结构的进一步调整；对所需的政府批准及许可、国家食品药品监督管理总局（CFDA）相关政策的调整等有影响的有关政府部门的监管政策的变化；竞争所带来的对本公司医疗器械产品的需求和对价格的影响；会影响本公司医疗器械产品的生存能力和竞争能力的医疗器械产品及相关技术的变化；本公司执行其业务策略的能力，包括进行业务合并、策略投资及收购的能力；以及中国内地的政治、经济、法律及社会各方面情况的变化。另外，本公司未来的业务多元化发展以及其他资本投资和发展计划，均取决于多种因素，包括但不限于是否能以可接受的条款获得足量融资；我们发展和获得新技术及其应用的能力；以及是否有合资格的管理及技术人员等许多因素。<br style=\"margin: 0px; padding: 0px; outline: none;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;版权和免责声明<br style=\"margin: 0px; padding: 0px; outline: none;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;版权©2016 微创®医疗。本公司保留一切版权。</span></em></p><p><br/></p>', '', '', '/57\\45.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('44', '', '<pre class=\"brush:html;toolbar:false\">&lt;!DOCTYPE&nbsp;html&nbsp;PUBLIC&nbsp;&quot;-//W3C//DTD&nbsp;XHTML&nbsp;1.0&nbsp;Transitional//EN&quot;&nbsp;&quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd&quot;&gt;\r\n&lt;html&nbsp;xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;\r\n&nbsp;&nbsp;&lt;head&gt;\r\n&nbsp;&nbsp;&lt;meta&nbsp;http-equiv=&quot;Content-Type&quot;&nbsp;content=&quot;text/html;&nbsp;charset=utf-8&quot;&nbsp;/&gt;\r\n&nbsp;&nbsp;&lt;title&gt;新闻动态&nbsp;|&nbsp;MicroPort&nbsp;-&nbsp;Where&nbsp;the&nbsp;Patient&nbsp;Always&nbsp;Comes&nbsp;First&lt;/title&gt;\r\n&nbsp;&nbsp;&lt;link&nbsp;href=&quot;{ms:globalskin.url/}/css/video_1.css&quot;&nbsp;rel=&quot;stylesheet&quot;&nbsp;type=&quot;text/css&quot;&nbsp;/&gt;&nbsp;\r\n&nbsp;&nbsp;&lt;!--[if&nbsp;lte&nbsp;IE&nbsp;6]&gt;\r\n&nbsp;&nbsp;\r\n&lt;style&nbsp;type=&quot;text/css&quot;&gt;\r\nbody&nbsp;{&nbsp;behavior:url(&quot;css/csshover.htc&quot;);&nbsp;}\r\n&lt;/style&gt;\r\n&nbsp;&nbsp;\r\n&lt;![endif]--&gt;\r\n&nbsp;&nbsp;&lt;/head&gt;\r\n\r\n&nbsp;&nbsp;&lt;body&gt;\r\n\r\n&lt;script&gt;\r\nvar&nbsp;userAgentInfo&nbsp;=&nbsp;navigator.userAgent;\r\nvar&nbsp;Agents&nbsp;=&nbsp;new&nbsp;Array(&quot;Android&quot;,&nbsp;&quot;iPhone&quot;,&nbsp;&quot;SymbianOS&quot;,&nbsp;&quot;Windows&nbsp;Phone&quot;,&nbsp;&quot;iPod&quot;);\r\nvar&nbsp;flag&nbsp;=&nbsp;false;\r\nvar&nbsp;v=0\r\nfor&nbsp;(&nbsp;v&nbsp;=&nbsp;0;&nbsp;v&nbsp;&lt;&nbsp;Agents.length;&nbsp;v++)\r\n{\r\nif&nbsp;(userAgentInfo.indexOf(Agents[v])&nbsp;&gt;&nbsp;0)&nbsp;{&nbsp;flag&nbsp;=&nbsp;true;&nbsp;break;&nbsp;}\r\n}\r\nif(flag){window.location=&#39;http://m.microport.com.cn&#39;;\r\n}\r\n&lt;/script&gt;\r\n\r\n&lt;div&nbsp;id=&quot;header&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;container&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;logo_nav&quot;&gt;&lt;a&nbsp;href=&quot;index.php&quot;&gt;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/logo.gif&quot;&nbsp;id=&quot;logo&quot;&nbsp;/&gt;&lt;/a&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;top_nav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;search_box&quot;&gt;&lt;input&nbsp;type=&quot;text&quot;&nbsp;class=&quot;search_txt&quot;&nbsp;id=&quot;search_txt&quot;&nbsp;/&gt;&lt;input&nbsp;type=&quot;button&quot;&nbsp;class=&quot;search_btn&quot;&nbsp;id=&quot;button&quot;&nbsp;/&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;lang_box&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dl&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dt&gt;中文&lt;/dt&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dd&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;../en/&quot;&nbsp;class=&quot;en&quot;&gt;ENGLISH&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;###&quot;&nbsp;class=&quot;cn&quot;&gt;中文&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/dd&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/dl&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;contact.php?curr_page=contact&quot;&gt;联系我们&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;ten.php?curr_page=fifteen&quot;&gt;微创&amp;reg;年轮&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://www.microport.com/cn/careers&quot;&gt;人才中心&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;top_side_nav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=video&quot;&nbsp;class=&quot;video_link&quot;&gt;视频&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;rss_media.php&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;share_link&quot;&gt;分享&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;https://mail.microport.com.cn&quot;&nbsp;class=&quot;mail_link&quot;&nbsp;target=&quot;_blank&quot;&gt;邮箱&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;main_nav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;homeNav&quot;&gt;&lt;a&nbsp;href=&quot;index.php&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;首页&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;aboutNav&quot;&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=company&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;关于我们&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=company&quot;&gt;简介&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=about_enterprise&quot;&gt;文化精要&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=about_responsibility&quot;&gt;社会责任&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=core_business&quot;&gt;核心业务&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=management&quot;&gt;经营管理&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=milestone&quot;&gt;里程碑&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=awards&quot;&gt;奖项和荣誉&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=about_control2&quot;&gt;企业治理&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!--&lt;li&nbsp;class=&quot;last&quot;&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=about_subsidiary&quot;&gt;子公司&lt;/a&gt;&lt;/li&gt;--&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;productNav&quot;&gt;&lt;a&nbsp;href=&quot;product.php&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;产品介绍&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&nbsp;id=&quot;product_sub&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_1&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=1&quot;&gt;心血管&lt;br&nbsp;/&gt;介入产品&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_6&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=6&quot;&gt;骨科&lt;br&nbsp;/&gt;医疗器械&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_2&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=3&quot;&gt;大动脉及外周&lt;br&nbsp;/&gt;血管介入产品&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_5&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=5&quot;&gt;电生理&lt;br&nbsp;/&gt;医疗器械&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_3&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=2&quot;&gt;神经&lt;br&nbsp;/&gt;介入产品&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_4&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=4&quot;&gt;糖尿病及内分泌&lt;br&nbsp;/&gt;医疗器械&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;product_nav_7&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=7&quot;&gt;外科&lt;br&nbsp;/&gt;医疗器械&lt;/a&gt;&lt;/li&gt;\r\n&lt;li&nbsp;class=&quot;product_nav_8&quot;&gt;&lt;a&nbsp;href=&quot;product.php?curr_page=product_list&amp;id=8&quot;&gt;介入&lt;br&nbsp;/&gt;配件&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;medicaNav&quot;&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=news&quot;&nbsp;class=&quot;nav&nbsp;current&quot;&gt;传媒中心&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=news&quot;&gt;新闻动态&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=activity&quot;&gt;专题活动&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=video&quot;&gt;视频中心&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=journal&quot;&gt;内刊&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;last&quot;&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;patientNav&quot;&gt;&lt;a&nbsp;href=&quot;http://health.microport.com&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;患者园地&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://health.microport.com/tests&quot;&nbsp;target=&quot;_blank&quot;&gt;自我检测&lt;/a&gt;&lt;/li&gt;\r\n&lt;li&gt;&lt;a&nbsp;href=&quot;http://health.microport.com/healthcare&quot;&nbsp;target=&quot;_blank&quot;&gt;健康保健&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://health.microport.com/chronic&quot;&nbsp;target=&quot;_blank&quot;&gt;慢病管理&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://health.microport.com/course&quot;&nbsp;target=&quot;_blank&quot;&gt;名医课堂&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://health.microport.com/search-for-doc&quot;&nbsp;target=&quot;_blank&quot;&gt;寻医问病&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;last&quot;&gt;&lt;a&nbsp;href=&quot;http://health.microport.com.cn/wardmate-stroy&quot;&nbsp;target=&quot;_blank&quot;&gt;病友故事&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;doctorNav&quot;&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;医生天地&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com/a/cardiovascular/&quot;&nbsp;target=&quot;_blank&quot;&gt;心血管&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com/a/orthopedics/&quot;&nbsp;target=&quot;_blank&quot;&gt;骨科&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com/a/endovascular/&quot;&nbsp;target=&quot;_blank&quot;&gt;外周血管&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com/a/neurovascular/&quot;&nbsp;target=&quot;_blank&quot;&gt;脑血管&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;last&quot;&gt;&lt;a&nbsp;href=&quot;http://doctor.microport.com&quot;&nbsp;target=&quot;_blank&quot;&gt;其他&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;investorNav&quot;&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor&quot;&nbsp;class=&quot;nav&nbsp;&quot;&gt;投资者关系&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;subNav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_bg&quot;&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;sub_inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;about.php?curr_page=company&quot;&gt;公司资料&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_control&quot;&gt;公司治理&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_service&quot;&gt;股东服务&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_finance&quot;&gt;财务信息&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_event&quot;&gt;重要事件&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_stock&quot;&gt;股票信息&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_bulletin&quot;&gt;公告&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;last&quot;&gt;&lt;a&nbsp;href=&quot;investor.php?curr_page=investor_contact&quot;&gt;投资者关系联络服务&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;&lt;div&nbsp;id=&quot;wrapper&quot;&gt;\r\n&lt;div&nbsp;id=&quot;inner_img&quot;&gt;&lt;div&nbsp;class=&quot;pagination_bg&nbsp;pngfix&quot;&gt;&lt;/div&gt;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/about_bg_02.jpg&quot;&nbsp;/&gt;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;id=&quot;container&quot;&nbsp;class=&quot;pngfix&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;page_nav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;rss_media.php&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;rss&quot;&gt;RSS订阅&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;###&quot;&nbsp;class=&quot;print&quot;&nbsp;onclick=&quot;window.print()&quot;&gt;打印此页&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;index.php&quot;&gt;首页&lt;/a&gt;　&gt;　&lt;a&nbsp;href=&quot;media.php?curr_page=news&quot;&gt;传媒中心&lt;/a&gt;　&lt;span&gt;&gt;　新闻动态&lt;/span&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;id=&quot;inner_banner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dl&nbsp;class=&quot;pngfix&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dd&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=enterprise&quot;&gt;图集&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=journal&quot;&gt;内刊&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=video&quot;&gt;视频中心&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=activity&quot;&gt;专题活动&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=news&quot;&nbsp;class=&quot;current&quot;&gt;新闻动态&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/dd&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;dt&gt;传媒中心&lt;/dt&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/dl&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/banner_news.jpg&quot;&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;inner&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;h3&nbsp;class=&quot;title&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;media.php?curr_page=news&quot;&nbsp;class=&quot;back&quot;&gt;返回&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;###&quot;&nbsp;title=&quot;特大号字体&quot;&nbsp;id=&quot;extra_size&quot;&gt;A&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;###&quot;&nbsp;title=&quot;大号字体&quot;&nbsp;id=&quot;large_size&quot;&gt;A&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;###&quot;&nbsp;title=&quot;常规字体&quot;&nbsp;id=&quot;normal_size&quot;&gt;A&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;em&gt;字体大小&lt;/em&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;contact.php?curr_page=feedback&quot;&nbsp;class=&quot;mail&quot;&gt;电子邮件通知&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;span&gt;&lt;/span&gt;新闻动态&lt;/h3&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!--startprint--&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;h4&nbsp;style=&quot;margin:30px&nbsp;0&nbsp;0&nbsp;39px;&nbsp;font-size:18px;&nbsp;color:#004280;&nbsp;font-weight:normal;&quot;&gt;微创&lt;sup&gt;®&lt;/sup&gt;集团与北京唯迈医疗设备有限公司举行战略合作签约仪式&lt;/h4&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;p&nbsp;style=&quot;text-align:right;&quot;&gt;[2016-03-21]　&lt;a&nbsp;href=&quot;media.php?curr_page=news_print&amp;id=1462&quot;&nbsp;target=&quot;_blank&quot;&gt;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/print.gif&quot;&nbsp;style=&quot;position:relative;&nbsp;top:3px;&quot;&nbsp;/&gt;&lt;/a&gt;&lt;/p&gt;\r\n&lt;div&nbsp;class=&quot;activity3&quot;&gt;\r\n&lt;div&nbsp;class=&quot;detail&quot;&gt;\r\n\r\n&lt;p&gt;&lt;div&gt;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;中国，上海&amp;mdash;&amp;mdash;近日，上海微创医疗器械（集团）有限公司（以下简称&amp;ldquo;微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团&amp;rdquo;）与TCL医疗集团北京唯迈医疗设备有限公司战略合作签约仪式在微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团总部举行，TCL医疗集团董事、首席科学家曹红光、北京唯迈医疗设备有限公司总经理杨贺等人员出席，微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团首席营销官彭博等出席了本次签约仪式。&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团与北京唯迈医疗设备有限公司此次战略合作旨在响应2015年发布的《国务院办公厅关于推进分级诊疗制度建设的指导意见》中扩大分级诊疗开展的区域和病种数，实现县（市、区）全覆盖、县域内就诊率达到90%左右的政策，利用双方现有的优势资源进行互补，达成战略同盟，从而达到共同开拓目标市场、提高效益、共同发展的目的。&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;北京唯迈医疗设备有限公司作为TCL医疗集团下属专注于介入设备的创新型企业，拥有高端介入设备研发和生产能力，深耕介入领域市场，为市场提供一系列高品质介入产品及解决方案。&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&lt;/div&gt;\r\n&lt;div&gt;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;&amp;nbsp;&nbsp;微创&lt;sup&gt;&amp;reg;&lt;/sup&gt;集团首席营销官彭博在签约仪式上表示，双方的此次合作是在产品属性、渠道资源上的互补，希望能够带来采购机会上的共享、利益上的共赢，最终能让这个项目落地，造福更多基层医疗机构，使更多患者能够享受到高质量的医疗资源和服务。&lt;/div&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;span&gt;关于微创集团&lt;/span&gt;&lt;br&nbsp;/&gt;&lt;i&gt;&lt;span&nbsp;style=&quot;font-size:11px&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;微创医疗科学有限公司起源于1998年成立的上海微创医疗器械（集团）有限公司，是一家中国领先的高端医疗器械集团，业务覆盖心血管介入产品、骨科医疗器械、大动脉及外周血管介入产品、电生理医疗器械、神经介入产品、心律管理产品、糖尿病及内分泌医疗器械和外科手术等十大领域。&lt;br&gt;\r\n&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;微创&amp;reg;医疗的产品已进入全球逾5,000家医院。平均每18秒左右，就有一个产品用于救治患者生命或改善其生活品质或用于帮助其催生新的生命。微创&amp;reg;医疗始终以创建“一个属于患者和医生的品牌”为己任，坚持以人为本在以微创伤为代表的高科技医学领域建设一个属于患者的全球化领先医疗集团。\r\n\r\n&lt;br&gt;\r\n&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;更多信息，敬请造访公司网站：&lt;/span&gt;&lt;span&nbsp;class=&quot;link&quot;&nbsp;style=&quot;font-size:11px&quot;&gt;&lt;a&nbsp;href=&quot;http://www.microport.com/cn/&quot;&gt;www.microport.com&lt;/a&gt;&lt;br&gt;&lt;/span&gt;&lt;/i&gt;&lt;/p&gt;\r\n&lt;p&gt;&lt;span&gt;前瞻性陈述&lt;/span&gt;&lt;br&nbsp;/&gt;&lt;i&gt;&lt;span&nbsp;style=&quot;font-size:11px&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;本网站所发布的信息中可能会包含某些预测性的陈述。这些陈述本质上具有相当风险和不确定性。这类预测性陈述包括但不限于：关于本公司业务经营策略的陈述；关于业务扩建计划（包括与之有关的拟作出的资本投资）的陈述；关于计划研发的新一代医疗器械产品和其他技术及其相关应用的陈述；关于政策和市场变动对本公司经营业绩的预期影响的陈述；关于竞争对本公司经营业绩的影响的陈述；关于中国医疗器械产业未来发展（包括行业结构调整及政府政策变化）的陈述；以及与本公司未来业务发展及经营业绩有关的其他陈述。在使用&quot;预期&quot;、&quot;相信&quot;、&quot;预测&quot;、&quot;预计&quot;、&quot;估计&quot;、&quot;期望&quot;、&quot;打算&quot;、&quot;计划&quot;、&quot;推测&quot;、&quot;深信&quot;、&quot;抱有信心&quot;及其他类似词语进行陈述时，凡与本公司有关的，目的均是要指明其属预测性陈述。本公司并不打算不断地更新这些预测性陈述。这些预测性陈述是反映本公司对将来事件的目前看法，而并非关于将来业务表现的保证。实际业绩可能会因许多因素而与预测性陈述中所述的有重大的出入，这些因素包括但不限于：中国内地医疗器械产业结构的进一步调整；对所需的政府批准及许可、国家食品药品监督管理总局（CFDA）相关政策的调整等有影响的有关政府部门的监管政策的变化；竞争所带来的对本公司医疗器械产品的需求和对价格的影响；会影响本公司医疗器械产品的生存能力和竞争能力的医疗器械产品及相关技术的变化；本公司执行其业务策略的能力，包括进行业务合并、策略投资及收购的能力；以及中国内地的政治、经济、法律及社会各方面情况的变化。另外，本公司未来的业务多元化发展以及其他资本投资和发展计划，均取决于多种因素，包括但不限于是否能以可接受的条款获得足量融资；我们发展和获得新技术及其应用的能力；以及是否有合资格的管理及技术人员等许多因素。&lt;br&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;版权和免责声明&lt;br&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;版权&amp;#169;2016&nbsp;微创&amp;reg;医疗。本公司保留一切版权。&lt;/span&gt;&lt;/i&gt;&lt;/p&gt;\r\n&lt;p&gt;\r\n&lt;span&gt;欲了解更多详情，敬请联系：&lt;/span&gt;\r\n&lt;table&nbsp;width=&quot;100%&quot;&nbsp;border=&quot;0&quot;&nbsp;cellspacing=&quot;0&quot;&nbsp;cellpadding=&quot;0&quot;&gt;\r\n&nbsp;&nbsp;&lt;tr&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;td&nbsp;width=&quot;35%&quot;&nbsp;valign=&quot;top&quot;&gt;&lt;strong&gt;李香梅&lt;/strong&gt;&nbsp;&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;股东与证券事务经理&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;上海微创医疗器械（集团）有限公司&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tel:&nbsp;(86)(21)&nbsp;38954600-6958&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Email:&nbsp;&lt;a&nbsp;href=&quot;mailto:ir@microport.com&quot;&gt;ir@microport.com&lt;/a&gt;&lt;/td&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;td&nbsp;width=&quot;65%&quot;&nbsp;valign=&quot;top&quot;&gt;&lt;strong&gt;张&nbsp;烨&lt;/strong&gt;&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;公司发言人&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;上海微创医疗器械（集团）有限公司&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Tel:&nbsp;(86)(21)&nbsp;38954600-6985&lt;br&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Email:&nbsp;&lt;a&nbsp;href=&quot;mailto:spokesperson@microport.com&quot;&gt;spokesperson@microport.com&lt;/a&gt;&lt;/td&gt;\r\n&nbsp;&nbsp;&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/p&gt;\r\n\r\n\r\n\r\n&lt;/div&gt;\r\n&lt;br&nbsp;/&gt;\r\n[下一篇]：&lt;a&nbsp;href=&quot;media.php?curr_page=news_details&amp;type=1&amp;id=1461&quot;&gt;微创&lt;sup&gt;®&lt;/sup&gt;电生理亮相第十三届国际死海研讨会（IDSS&nbsp;2016）&lt;/a&gt;\r\n&lt;/div&gt;\r\n&lt;div&nbsp;style=&quot;clear:both;&quot;&gt;&lt;/div&gt;&nbsp;&nbsp;&nbsp;&nbsp;\r\n\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;footer_nav&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;a&nbsp;href=&quot;#&quot;&nbsp;class=&quot;top&quot;&gt;&lt;/a&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;span&nbsp;class=&quot;know_more_outter&quot;&gt;&lt;a&nbsp;href=&quot;media.php?curr_page=video&quot;&nbsp;class=&quot;know_more&quot;&gt;&lt;span&gt;了解视频中心&lt;/span&gt;&lt;/a&gt;&lt;/span&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;footer_bg&quot;&nbsp;style=&quot;height:2px;&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;&lt;/div&gt;\r\n&lt;script&nbsp;src=&quot;{ms:globalskin.url/}/js/jquery.js&quot;&gt;&lt;/script&gt;&nbsp;\r\n&lt;script&nbsp;src=&quot;{ms:globalskin.url/}/js/jquery.backstretch.js&quot;&gt;&lt;/script&gt;&nbsp;\r\n&nbsp;&nbsp;\r\n&lt;script&gt;\r\n&nbsp;&nbsp;&nbsp;$.backstretch([&quot;&quot;]);\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$(&quot;.banner&quot;).backstretch(&quot;images/about_bg_02.jpg&quot;);\r\n&nbsp;&nbsp;&lt;/script&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;id=&quot;footer&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;div&nbsp;class=&quot;container&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;first&quot;&gt;&lt;a&nbsp;href=&quot;legal.php?curr_page=legal&quot;&nbsp;class=&quot;dot&quot;&gt;法律声明&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!--&lt;li&gt;|&lt;/li&gt;--&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://microport.zhiye.com/&quot;&nbsp;target=&quot;_blank&quot;&nbsp;&nbsp;class=&quot;dot&quot;&gt;招贤纳士&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!--&lt;li&gt;|&lt;/li&gt;--&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;legal.php?curr_page=sitemap&quot;&nbsp;&nbsp;class=&quot;dot&quot;&gt;网站地图&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;class=&quot;dot&quot;&nbsp;style=&quot;color:#6c6c6c&quot;&gt;关注我们&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://weibo.com/microportchina&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;weibo_link&quot;&nbsp;&gt;&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;###&quot;&nbsp;class=&quot;weixin_link&quot;&gt;&lt;/a&gt;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/weixin_code.png&quot;&nbsp;id=&quot;weixin_code&quot;&nbsp;/&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://i.youku.com/microport&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;video_link&quot;&gt;&lt;/a&gt;&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;!--&lt;li&gt;|&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&nbsp;class=&quot;mail_bar&quot;&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;input&nbsp;type=&quot;text&quot;&nbsp;name=&quot;textfield2&quot;&nbsp;class=&quot;mail_txt&quot;&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;input&nbsp;name=&quot;&quot;&nbsp;type=&quot;image&quot;&nbsp;id=&quot;mail_btn&quot;&nbsp;src=&quot;images/common/index_262.jpg&quot;&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/li&gt;&lt;li&gt;|&lt;/li&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;li&gt;&lt;a&nbsp;href=&quot;http://weibo.com/microportchina&quot;&nbsp;target=&quot;_blank&quot;&nbsp;class=&quot;weibo_link&quot;&gt;微创微博&lt;/a&gt;&lt;/li&gt;--&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/ul&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;p&gt;&amp;copy;Copyright&nbsp;1998-2016,&nbsp;MicroPort&nbsp;Scientific&nbsp;Corporation.&nbsp;All&nbsp;rights&nbsp;reserved.&nbsp;&lt;/p&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;p&gt;互联网药品信息服务资格证书编号：（沪）-&nbsp;非经营性&nbsp;-&nbsp;2011-0128&lt;/p&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;img&nbsp;src=&quot;{ms:globalskin.url/}/images/bottom_logo.gif&quot;&nbsp;id=&quot;bottom_logo&quot;&nbsp;/&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;&lt;/div&gt;\r\n&nbsp;&nbsp;&nbsp;&nbsp;\r\n&lt;script&nbsp;language=&quot;javascript&quot;&nbsp;type=&quot;text/javascript&quot;&nbsp;src=&quot;{ms:globalskin.url/}/js/menu.js&quot;&gt;&lt;/script&gt;&nbsp;&nbsp;\r\n&nbsp;&nbsp;\r\n&nbsp;&nbsp;\r\n&lt;!--&lt;script&nbsp;type=&quot;text/javascript&quot;&gt;\r\nvar&nbsp;gaJsHost&nbsp;=&nbsp;((&quot;https:&quot;&nbsp;==&nbsp;document.location.protocol)&nbsp;?&nbsp;&quot;https://ssl.&quot;&nbsp;:&nbsp;&quot;http://www.&quot;);\r\ndocument.write(unescape(&quot;%3Cscript&nbsp;src=&#39;&quot;&nbsp;+&nbsp;gaJsHost&nbsp;+&nbsp;&quot;google-analytics.com/ga.js&#39;&nbsp;type=&#39;text/javascript&#39;%3E%3C/script%3E&quot;));\r\n&lt;/script&gt;\r\n&lt;script&nbsp;type=&quot;text/javascript&quot;&gt;\r\ntry&nbsp;{\r\nvar&nbsp;pageTracker&nbsp;=&nbsp;_gat._getTracker(&quot;UA-10503690-1&quot;);\r\npageTracker._trackPageview();\r\n}&nbsp;catch(err)&nbsp;{}\r\n&lt;/script&gt;--&gt;\r\n&lt;script&gt;\r\n&nbsp;&nbsp;(function(i,s,o,g,r,a,m){i[&#39;GoogleAnalyticsObject&#39;]=r;i[r]=i[r]||function(){\r\n&nbsp;&nbsp;(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new&nbsp;Date();a=s.createElement(o),\r\n&nbsp;&nbsp;m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n&nbsp;&nbsp;})(window,document,&#39;script&#39;,&#39;//www.google-analytics.com/analytics.js&#39;,&#39;ga&#39;);\r\n\r\n&nbsp;&nbsp;ga(&#39;create&#39;,&nbsp;&#39;UA-10503690-1&#39;,&nbsp;&#39;microport.com.cn&#39;);\r\n&nbsp;&nbsp;ga(&#39;send&#39;,&nbsp;&#39;pageview&#39;);\r\n\r\n&lt;/script&gt;\r\n\r\n\r\n&nbsp;&nbsp;&lt;script&nbsp;type=&quot;text/javascript&quot;&nbsp;src=&quot;jquery-1.9.1.min.js&quot;&gt;&lt;/script&gt;\r\n&lt;script&nbsp;type=&quot;text/javascript&quot;&nbsp;src=&quot;{ms:globalskin.url/}/js/common.js&quot;&gt;&lt;/script&gt;\r\n&lt;script&nbsp;type=&quot;text/javascript&quot;&nbsp;src=&quot;{ms:globalskin.url/}/js/jquery.jcarousel.js&quot;&gt;&lt;/script&gt;\r\n&nbsp;&nbsp;\r\n&lt;script&gt;\r\n$(&#39;.journal_content&#39;).eq(0).show();\r\n$(&#39;.journal&nbsp;li&#39;).click(function(){\r\nvar&nbsp;currLi&nbsp;=&nbsp;$(this).index();\r\n$(&#39;.journal_content&#39;).hide().eq(currLi).show();\r\n$(&#39;.journal&nbsp;li&#39;).removeClass(&#39;now&#39;);\r\n$(this).addClass(&#39;now&#39;);\r\n});\r\n$(&quot;#normal_size&quot;).click(function(e){\r\ne.preventDefault();\r\n$(&quot;.activity3&nbsp;.detail&quot;).css({&quot;fontSize&quot;:&quot;12px&quot;,lineHeight:&quot;20px&quot;});\r\n$(&quot;.activity3&nbsp;span&quot;).css({&quot;fontSize&quot;:&quot;14px&quot;,lineHeight:&quot;20px&quot;});\r\n});\r\n$(&quot;#large_size&quot;).click(function(e){\r\ne.preventDefault();\r\n$(&quot;.activity3&nbsp;.detail&quot;).css({&quot;fontSize&quot;:&quot;14px&quot;,lineHeight:&quot;22px&quot;});\r\n$(&quot;.activity3&nbsp;span&quot;).css({&quot;fontSize&quot;:&quot;16px&quot;,lineHeight:&quot;20px&quot;});\r\n});\r\n$(&quot;#extra_size&quot;).click(function(e){\r\ne.preventDefault();\r\n$(&quot;.activity3&nbsp;.detail&quot;).css({&quot;fontSize&quot;:&quot;18px&quot;,lineHeight:&quot;25px&quot;});\r\n$(&quot;.activity3&nbsp;span&quot;).css({&quot;fontSize&quot;:&quot;20px&quot;,lineHeight:&quot;20px&quot;});\r\n});\r\nfunction&nbsp;preview()\r\n{\r\n&nbsp;&nbsp;&nbsp;&nbsp;bdhtml=window.document.body.innerHTML;\r\n&nbsp;&nbsp;&nbsp;&nbsp;sprnstr=&quot;&lt;!--startprint--&gt;&quot;;\r\n&nbsp;&nbsp;&nbsp;&nbsp;eprnstr=&quot;&lt;!--endprint--&gt;&quot;;\r\n&nbsp;&nbsp;&nbsp;&nbsp;prnhtml=bdhtml.substr(bdhtml.indexOf(sprnstr)+17);\r\n&nbsp;&nbsp;&nbsp;&nbsp;prnhtml=prnhtml.substring(0,prnhtml.indexOf(eprnstr));\r\n&nbsp;&nbsp;&nbsp;&nbsp;window.document.body.innerHTML=prnhtml;\r\n&nbsp;&nbsp;&nbsp;&nbsp;window.print();\r\n}\r\n&lt;/script&gt;\r\n&nbsp;&nbsp;\r\n&lt;!--[if&nbsp;IE&nbsp;6&nbsp;]&gt;\r\n&lt;script&nbsp;language=&quot;javascript&quot;&nbsp;type=&quot;text/javascript&quot;&nbsp;src=&quot;js/png.js&quot;&gt;&lt;/script&gt;\r\n\r\n&lt;script&gt;&nbsp;\r\nDD_belatedPNG.fix(&#39;.pngfix&#39;);\r\ndocument.execCommand(&quot;BackgroundImageCache&quot;,false,true);\r\n&lt;/script&gt;\r\n&lt;![endif]--&gt;\r\n\r\n&lt;/body&gt;\r\n&lt;/html&gt;</pre><p><br/></p>', '', '', '/57\\44.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('46', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">　你是否想要一个响应和触摸友好的音频播放器？Osvaldas Valutis 已经为大家创建了一个取代&lt;audio&gt;元素的&nbsp;<a href=\"http://www.cnblogs.com/lhb25/category/277997.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><strong style=\"box-sizing: border-box; color: rgb(255, 94, 82);\">jQuery</strong></a>&nbsp;插件。通过添加一些&nbsp;<a href=\"http://www.cnblogs.com/lhb25/category/146075.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><strong style=\"box-sizing: border-box; color: rgb(255, 94, 82);\">CSS</strong></a>，你就能得到一个全新的音乐播放器。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">　　它已经过在最新的 Safari、Chrome、Firefox 和 Opera 浏览器测试通过，同时支持 Mac 和 Windows版本。该播放器在 IE9 和 IE10 也能很好的工作，并能优雅的降级到早期版本上使用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">　　这款播放器同时也可以在 iOS 6、Windows Phone 7 和 Android 4.2 的默认浏览器中使用。更早的 Android 版本不支持&lt;audio&gt;和&lt;embed&gt;元素，所以不能使用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://osvaldas.info/examples/audio-player-responsive-and-touch-friendly/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://images.cnitblog.com/blog/36987/201305/25135131-70886e7351784a99beb51227f0de699b.jpg\" alt=\"jQuery 插件：用于移动项目的响应式音频播放器\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px auto; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><strong>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; <a href=\"http://osvaldas.info/examples/audio-player-responsive-and-touch-friendly/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; text-align: center; text-indent: 30px; white-space: normal; background: rgb(255, 255, 255);\">效果演示</a><span style=\"color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; text-align: center; text-indent: 30px; background-color: rgb(255, 255, 255);\">&nbsp;&nbsp; &nbsp; &nbsp;</span><a title=\"Download\" href=\"http://osvaldas.info/audio-player-responsive-and-touch-friendly\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; text-align: center; text-indent: 30px; white-space: normal; background: rgb(255, 255, 255);\">插件主页</a></strong><br/></p><p><br/></p>', '', '来自火星的程序猿', '/58\\46.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('47', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">如何向其他人呈现你自己和你的作品呢？关于页面的设计是非常重要的，以让你的观众更多地了解你，你的工作和你的想法。这是一个很好的方式来获得更加个性化的展示效果。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">　　设计一个漂亮的关于页面是具有挑战性的。出于这个原因，我们聚集了一些鼓舞人心的例子来激励你。你会发现所有的这些例子都是以自己独特的的方式，但都具有出色的排版和恰到好处的图像的使用。Enjoy!</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mostlyserious.io/team\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Mostly Serious</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mostlyserious.io/team\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about05.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mostlyserious.io/team\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about05a.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.the-neighbourhood.com/people/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">The Neighbourhood</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.the-neighbourhood.com/people/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about06.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.the-neighbourhood.com/people/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about06a.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.knormal.com/profile/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Knormal</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.knormal.com/profile/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about07.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://forty.co/company\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Forty</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://forty.co/company\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about08.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://grainandmortar.com/about/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Grain &amp; Mortar</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://grainandmortar.com/about/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about01.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://grainandmortar.com/about/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about01a.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mr-president.co.uk/mr-president/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Mr. President</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mr-president.co.uk/mr-president/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about02.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://creativemarket.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Creative Market</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://creativemarket.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about03.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"https://creativemarket.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about03a.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://playgroundinc.com/company/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Playground</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://playgroundinc.com/company/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about04.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://bigbitecreative.com/studio/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Big Bite Creative</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://bigbitecreative.com/studio/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about09.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.themeskingdom.com/about/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Themes Kingdom</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.themeskingdom.com/about/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about10.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mikekus.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Mike Kus</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mikekus.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about11.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://twoarmsinc.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Two Arms Inc</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://twoarmsinc.com/about\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about12.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://weareadaptable.com/studio/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">adaptable</a></h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://weareadaptable.com/studio/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about13.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://weareadaptable.com/studio/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://webdesignledger.com/wp-content/uploads/2014/03/about13a.jpg\" alt=\"13个风格独特的关于页面（About Pages）设计\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p>&nbsp;</p><p><br/></p>', '', '来自火星的程序猿', '/58\\47.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('48', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">2012年对于网页设计领域来说是非常有趣的一年，响应式设计的流行孕育了辉煌的重新设计：巧妙的布局、清晰的排版和强烈的色彩对比。下面分享一组独特的网页设计作品，这并不是一个完整的集合，只是众多优秀网页作品的代表。这组优秀网页作品向你展示的对于未来网页设计发展的想法会让你倍感兴奋。</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">您可能感兴趣的相关文章</h3><ul style=\"box-sizing: border-box; margin-bottom: 16px;\" class=\" list-paddingleft-2\"><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/29/stunning-big-backgrounds.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个以全屏照片为背景的精美网页作品</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/19/10-free-html-admin-templates.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">10套精美的免费网站后台管理系统模板</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/11/15/20-trendy-contact-form-designs-to-inspire.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">20个与众不同的网页联系表单设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/08/04/really-cool-and-creative-404-error-pages.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">让人惊叹的国外创意404错误页面设计</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/25/blurred-backgrounds-in-web-design.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">20个模糊背景在网站中的经典应用案例</a></p></li></ul><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://supereightstudio.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Supereight Studio</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://supereightstudio.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn2.tympanus.net/codrops/wp-content/uploads/2012/12/supereightstudio.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.like-there-is-no-tomorrow.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Like There Is No Tomorrow</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.like-there-is-no-tomorrow.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/likethereisnotomorrow1.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://hipstamatic.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Hipstamatic</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://hipstamatic.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/hipstamatic.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://craftingtype.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Crafting Type</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://craftingtype.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn4.tympanus.net/codrops/wp-content/uploads/2012/12/crafting1.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://2012.buildconf.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Build 2012</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://2012.buildconf.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/build2012.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.danielhopwood.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Daniel Hopwood</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.danielhopwood.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/danielhopwood.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.philiphousenyc.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Philip House</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.philiphousenyc.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn.tympanus.net/codrops/wp-content/uploads/2012/12/philiphouse.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.ginlanemedia.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Gin Lane Media</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.ginlanemedia.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn4.tympanus.net/codrops/wp-content/uploads/2012/12/ginlanemedia.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; font-size: 12px;\">前端里博客关注<a href=\"http://www.yyyweb.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">前端开发</a>技术，展示最新<a href=\"http://www.yyyweb.com/tag/HTML5/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">HTML5</a>和<a href=\"http://www.cnblogs.com/lhb25/category/146075.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">CSS3</a>应用，分享实用的<a href=\"http://www.cnblogs.com/lhb25/category/277997.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">jQuery</a>插件，推荐<a href=\"http://www.cnblogs.com/lhb25/category/279316.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">网页设计</a>案例。</span></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://manoscrafted.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Manos</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://manoscrafted.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/manos.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://builtbybuffalo.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Buffalo</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://builtbybuffalo.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/buffalo.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.themealings.com.au/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">The Mealings</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://www.themealings.com.au/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn2.tympanus.net/codrops/wp-content/uploads/2012/12/themealings.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://elliotjaystocks.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Elliot Jay Stocks</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://elliotjaystocks.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn.tympanus.net/codrops/wp-content/uploads/2012/12/elliot.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h4 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 10px; margin-bottom: 10px; font-size: 15px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://finethought.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">Fine Thought</a></h4><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://finethought.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img title=\"\" src=\"http://cdn3.tympanus.net/codrops/wp-content/uploads/2012/12/finethought.jpg?84cd58\" alt=\"前端视界：2012年度最独特的网页设计作品展示《上篇》\" width=\"600\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">您可能感兴趣的相关文章</h3><ul style=\"box-sizing: border-box; margin-bottom: 16px;\" class=\" list-paddingleft-2\"><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/29/stunning-big-backgrounds.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个以全屏照片为背景的精美网页作品</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/12/16/30-well-designed-website.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">30个与众不同的国外优秀网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/08/04/really-cool-and-creative-404-error-pages.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">让人惊叹的国外创意404错误页面设计</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/10/30/html5-portfolio-great-examples.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">16个精美的HTML5作品集网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/19/10-free-html-admin-templates.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">10套精美的免费网站后台管理系统模板</a></p></li></ul><p><br/></p>', '', '来自火星的程序猿', '/58\\48.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('49', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">这似乎有点奇怪，设计单品电子商务网站有什么特别的吗？不过，例如像 Kickstarter，制造商机芯，3D打印等等，这些使得任何人都可以更容易创建一个新的产品的新东西，你就会明白为什么有单品电子商务的设计需求。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">　　有些公司不希望成为一个在线零售商，他们只是想推销自己的发明（通常只有一个单一的产品，拥有不同颜色）。因此，这篇文章挑选了16个单品电子商务设计，你可以从中借鉴和获得启示。</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">您可能感兴趣的相关文章</h3><ul style=\"box-sizing: border-box; margin-bottom: 16px;\" class=\" list-paddingleft-2\"><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/19/10-free-html-admin-templates.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">10套精美的免费网站后台管理系统模板</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/07/21/restaurant-websites-inspiration.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个国外优秀的餐饮网站设计案例欣赏</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/07/23/ecommerce-website-designs.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个国外优秀的电子商务网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/07/08/showcase-of-html5-powered-sites.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">12个优秀的 HTML5 网站设计案例欣赏</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/05/06/2021398.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">分享35个非常漂亮的单页网站设计案例</a></p></li></ul><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#1: Sweetestevia.gr</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://sweetestevia.gr/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://images.cnitblog.com/blog/36987/201401/101519179572.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#2: Dangelicoguitars.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://dangelicoguitars.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://images.cnitblog.com/blog/36987/201401/101519341139.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#3: Julianabicycles.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://julianabicycles.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://images.cnitblog.com/blog/36987/201401/101519502388.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#4:Hicural.con</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://hicural.con/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-4.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#5: Makefac.es</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://makefac.es/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-5.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#6: Tricycleterror.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://tricycleterror.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-6-1024x504.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#7: Pomonastreet.co.uk</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://pomonastreet.co.uk/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-7.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"602\" height=\"331\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#8: Samson-brewery.positivezero.co.uk</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://samson-brewery.positivezero.co.uk/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-8.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#9: Catnaptree.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://catnaptree.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-3.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#10: Moto.oakley.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://moto.oakley.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-10.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#11: Versatiletrolley.co.uk</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://versatiletrolley.co.uk/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-1.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#12: Mightymatcha.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://mightymatcha.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-2-1024x514.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#13: Vool.me</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://vool.me/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-13.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#14: Windsonic.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://windsonic.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-14.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#15: Muffin-manufaktur-berlin.de</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://muffin-manufaktur-berlin.de/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://smashinghub.com/wp-content/uploads/2013/09/single-page-ecommerce-design-15-1024x508.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" width=\"600\" height=\"300\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">#16: Unioncraftbrewing.com</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"><a href=\"http://unioncraftbrewing.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://images.cnitblog.com/blog/36987/201401/04133937-aee4332239fb457f9908603097badb43.png\" alt=\"16个销售单个商品的电子商务网站设计示例\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; background-color: rgb(255, 255, 255);\">您可能感兴趣的相关文章</h3><ul style=\"box-sizing: border-box; margin-bottom: 16px;\" class=\" list-paddingleft-2\"><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2013/01/14/top-branded-shoes-ecommerce-website-designs.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">分享20个销售顶级名鞋的电子商务网站</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/05/28/2055018.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">分享50个优秀的电子商务网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/02/15/excellent-e-commerce-websites-inspiration-two.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">60佳优秀的国外电子商务网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2011/07/23/ecommerce-website-designs.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个国外优秀的电子商务网站设计案例</a></p></li><li><p><a href=\"http://www.cnblogs.com/lhb25/archive/2012/12/05/20-fresh-inspirational-ecommerce-websites.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">12个优秀的电子商务网站设计作品案例</a></p></li></ul><p><br/></p>', '', '来自火星的程序猿', '/58\\49.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('50', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    如今，一个网站只在桌面屏幕上好看是远远不够的，同时也要在平板电脑和智能手机中能够良好呈现。响应式的网站是指它能够适应客户端的屏幕尺寸，自动响应客户端尺寸变化。在这篇文章中，我将向您展示在任何设备上都完美的30个华丽的响应式网站。\r\n</p>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    &nbsp;\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    TRÜF Creative\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://trufcreative.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/1.-responsive-web-design-600x332.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"332\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    MVA\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://mva.jp/byc.html\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/2.-responsive-web-design-600x293.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"293\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Substrakt\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://substrakt.co.uk/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/3.-responsive-web-design-600x354.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"354\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    My Provence Festival 2013\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://www.myprovence.fr/en#p_home\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/4.-responsive-web-design-600x344.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"344\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Shun Cutlery\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://shun.kaiusaltd.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/5.-responsive-web-design-600x323.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"323\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    The Brooklyn Soap Company\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    <a href=\"http://www.bklynsoap.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/6.-responsive-web-design-600x280.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"280\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Moominvalley\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://muumilaakso.tampere.fi/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/7.-responsive-web-design-600x304.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"304\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Eden\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://www.eden-made.de/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/8.-responsive-web-design-600x331.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"331\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Atmosphere Maps\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://www.atmospheremaps.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/9.-responsive-web-design-600x302.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"302\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    The Pete Design\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://www.thepetedesign.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/10.-responsive-web-design-600x370.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"370\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    I-Creativ Studio\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    <a href=\"http://i-creativ.net/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/11.-responsive-web-design-600x319.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"319\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</h3>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Rimmel London\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; \">\r\n    <a href=\"http://uk.rimmellondon.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/12.-responsive-web-design-600x322.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"322\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <span style=\"box-sizing: border-box; font-size: 12px;\">前端里（jizhula.com）关注<a href=\"http://www.yyyweb.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">前端开发</a>技术，展示<a href=\"http://www.yyyweb.com/tag/HTML5/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">HTML5</a>和<a href=\"http://www.cnblogs.com/lhb25/category/146075.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">CSS3</a>应用，分享<a href=\"http://www.cnblogs.com/lhb25/category/277997.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">jQuery</a>插件，推荐<a href=\"http://www.cnblogs.com/lhb25/category/279316.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">网页设计</a>案例。</span>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    P. Studio\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://pierrickcalvez.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/13.-responsive-web-design-600x319.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"319\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Quodis Layers\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://layers.quodis.com/#set=1-2,2-11,3-16,4-14,5-9\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/14.-responsive-web-design-600x322.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"322\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    The Handytest\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; \">\r\n    <a href=\"http://handytesten.usedtobe.no/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/15.-responsive-web-design-600x336.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"336\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    All-new Santa Fe\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://archive.your-majesty.com/hyundai_santa_fe/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/16.-responsive-web-design-600x281.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"281\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Sergio Pedercini Portfolio\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://sergiopedercini.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/17.-responsive-web-design-600x295.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"295\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    CoolApps(e)\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.coolappse.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/18.-responsive-web-design-600x323.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"323\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Scandinavian Design Group\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://sdg.no/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/19.-responsive-web-design-600x313.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"313\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Mr. Adam Hayes\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://mrahayes.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/20.-responsive-web-design-600x309.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"309\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Eat Drink Inc\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://eatdrinkinc.com/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/21.-responsive-web-design-600x319.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"319\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Stepto &amp; Son Design\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.steptoandson.co.uk/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/22.-responsive-web-design-600x339.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"339\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    CreativePeople\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal; \">\r\n    <a href=\"http://cpeople.ru/#start\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/23.-responsive-web-design-600x309.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"309\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Julie Lavergne\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.julie-lavergne.com/#!home\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/24.-responsive-web-design-600x385.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"385\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <span style=\"box-sizing: border-box; font-size: 12px;\">前端里（jizhula.com）关注<a href=\"http://www.yyyweb.com/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">前端开发</a>技术，展示<a href=\"http://www.yyyweb.com/tag/HTML5/\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">HTML5</a>和<a href=\"http://www.cnblogs.com/lhb25/category/146075.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">CSS3</a>应用，分享<a href=\"http://www.cnblogs.com/lhb25/category/277997.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">jQuery</a>插件，推荐<a href=\"http://www.cnblogs.com/lhb25/category/279316.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">网页设计</a>案例。</span>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal; \">\r\n    Al Taglio\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.altaglio.fr/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/25.-responsive-web-design-600x299.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"299\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 36px; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-weight: 500; line-height: 1.1; color: rgb(68, 68, 68); white-space: normal;\">\r\n    DIM\r\n</h1>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.dim.hr/home.htm\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/26.-responsive-web-design-600x289.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"289\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    UKHÖM\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a title=\"Webdev Tip: How To Test Your Website’s Performance Load\" href=\"http://ukhom.com/#/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/27.-responsive-web-design-600x376.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"376\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    Carlaine\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://carlaine.com/en\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/28.-responsive-web-design-600x293.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"293\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    The Kitchen Project\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://kitchen.hi-res.net/\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/29.-responsive-web-design-600x308.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"308\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; line-height: 1.1; color: rgb(68, 68, 68); margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px; white-space: normal;\">\r\n    SilkTricky\r\n</h3>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    <a href=\"http://www.silktricky.com/#/home\" rel=\"nofollow\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\"><img src=\"http://www.topdesignmag.com/wp-content/uploads/2013/02/30.-responsive-web-design-600x306.png\" alt=\"在任何设备上都完美呈现的30个华丽的响应式网站\" width=\"600\" height=\"306\" data-tag=\"bdshare\" data-bd-imgshare-binded=\"1\" style=\"box-sizing: border-box; border: 0px; vertical-align: middle; margin: 5px 0px; display: block; max-width: 100%; height: auto;\"/></a>\r\n</p>\r\n<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 16px; text-indent: 2em; color: rgb(68, 68, 68); font-family: &#39;Microsoft Yahei&#39;, &#39;Helvetica Neue&#39;, Helvetica, Arial, sans-serif; font-size: 15px; line-height: 25px; white-space: normal;\">\r\n    &nbsp;\r\n</p>\r\n<h3 style=\"box-sizing: border-box; font-family: inherit; line-height: 1.1; margin-top: 20px; margin-bottom: 16px; font-size: 22px; border-bottom-color: rgb(238, 238, 238); border-bottom-width: 1px; border-bottom-style: solid; padding-bottom: 0px;\">\r\n    您可能感兴趣的相关文章\r\n</h3>\r\n<ul style=\"box-sizing: border-box; margin-bottom: 16px;\" class=\" list-paddingleft-2\">\r\n    <li>\r\n        <p>\r\n            <a href=\"http://www.cnblogs.com/lhb25/archive/2011/08/22/inspiring-examples-of-single-page-websites.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">带给你灵感的20个漂亮的单页网站作品</a>\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <p>\r\n            <a href=\"http://www.cnblogs.com/lhb25/archive/2012/10/23/20-fresh-single-pages-website-designs.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">20个非常经典的国外单页网站作品示例</a>\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <p>\r\n            <a href=\"http://www.cnblogs.com/lhb25/archive/2011/05/06/2021398.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">分享35个非常漂亮的单页网站设计案例</a>\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <p>\r\n            <a href=\"http://www.cnblogs.com/lhb25/archive/2012/01/13/25-outstanding-single-page-website-designs.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">25个优秀的国外单页网站设计作品欣赏</a>\r\n        </p>\r\n    </li>\r\n    <li>\r\n        <p>\r\n            <a href=\"http://www.cnblogs.com/lhb25/archive/2011/03/17/1986401.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">分享</a><a href=\"http://www.cnblogs.com/lhb25/archive/2011/03/17/1986401.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">最新</a><a href=\"http://www.cnblogs.com/lhb25/archive/2011/03/17/1986401.html\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(66, 139, 202); background: transparent;\">30个漂亮的单页网站设计案例</a>\r\n        </p>\r\n    </li>\r\n</ul>\r\n<p>\r\n    <br/>\r\n</p>', '', '来自火星的程序猿', '/58\\50.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('52', 'MS', '<p>响应式web设计对于解决多类型屏幕问题来说是个不错方案，但从印刷的角度来看，其却存在着很多的困难。没有固定的页面尺寸、没有毫米或英寸，没有任何物 理限制，让人感到无从下手。随着建立网站可用的各种小工具越来越多，像素设计局限于桌面和移动端也已经成为历史。因此，现在就让我们来说明一下如何运用响 应式web设计的各项基本原则来实现，而不是抗拒流畅的网页体验。为了简单起见，我们将着重讲布局</p>', 'f,', '来自火星的程序猿', '/61/65\\52.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('53', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><strong style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\">Gmai</strong>就 是单页应用的一个很好的例子，其将多项操作融入了一个单独的“页面”中。单页设计的趋势是这一UI模式中相对不太高端的一种实现方式，在这一设计模式下， 所有内容均可通过同一页面访问。这一模式可以让浏览变得更快、响应更迅速，从而让桌面与web应用之间的界限不再如此分明。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">对于Spotify等web应用，考虑到用户有时会在背景播放音乐的同时浏览其他音乐，这时单页应用模式的重要性就愈发凸显，通过使用单页应用，用户就无需对页面进行重新加载，也不会造成音乐停止播放。</p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">在 使用单页应用时需要考虑的一个问题就是URL结构。由于内容使用JavaScript动态加载，URL会失去作用，如果设计不当，还会造成无法访问特定视 图。Gmail和Twitter等应用通过为每个视图生成专门的URL来克服这一问题，这一方法还能够解决浏览器后退按钮失效的问题。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', 'c,', '来自火星的程序猿', '/61/65\\53.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('54', 'MS', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(51, 51, 51); background: transparent;\"><span style=\"font-family:Verdana, 宋体;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\">用 户体验只有在渗透入从创意到开发测试等产品开发的各个阶段时才能发挥最佳效果。当通常来说事情没这么简单，用户体验专家需要反复对已经完成的产品进行优化 才能使其达到我们口中所说的“用户友好”水平。但是，亡羊补牢，为时未晚。对现有网站进行用户体验优化也有自己的好处和缺点。好处是你可以获得更多真实用 户数据和统计信息方便进行用户调研，但另一方面，也会遇到很多变革的阻力，特别是在你要换掉用户“心爱的宝贝”的时候。</span></span></span></p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(127, 127, 127); background: rgb(255, 255, 255);\"><span style=\"font-family:微软雅黑,;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 16px; vertical-align: baseline; background: transparent;\">作为用户体验专家，你可以自由选择调研的方法，甚至可以使用超越传统工具的方法，但是今天，我想回归简单，谈一谈启发式评估方法。</span></span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', '', '来自火星的程序猿', '/61/67\\54.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('55', 'MS', '<p><span style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\">想象一下走进一个狭小拥挤，遍地垃圾的商店。店员不停怂恿你买自己不想要的东西。在这种情况下，你肯定会马上转身离开去别家。如果有人给你压力，逼迫你在充满敌意的环境下快速做出抉择，你会自然而然的失去信任感。这一点也适用于网络。</span><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><span style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\">网上充满着向你推销各种服务和产品的人。用户要先信任你，才能考虑从你那购买产品或服务。下面列出了10个比较流行的让用户相信、信任你登陆页面的方法。你可以借鉴或者干脆照搬这些方法为你的网上业务建立起值得信赖的网站。</span><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; white-space: normal; background: rgb(255, 255, 255);\">1.快速表现价值</strong><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><span style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\">每个来到你登陆页面的用户都会问同一个问题：你能给我带来什么好处？你需要让他们立刻看到你所能提供的价值。使用显眼的标题说明你所能提供的内容，以及你 与竞争对手的不同之处在哪。但是不要太过于强调你自己和你的公司，否则可能会让用户反感而离开。应当着重强调你如何满足用户的需求。</span></p>', 'h,', '来自火星的程序猿', '/61/67\\55.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('56', 'MS', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">最小的分辨率是320x480，我们把这个尺寸定为基准界面尺寸（baseline），基准尺寸所用的图标定为1倍图（1x）。</span></span></span></p><p><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">在 实际设计过程中，为了降低设计成本，一般拿设备最高的分辨率作为设计稿的原始尺寸，拿iphone来说就是iphone5或5s的640x1136啦，当 然也可以用iphone4或4s的640x960，因为宽度都是640px，他们切图的标准是一样的。显然，以1倍图的基准尺寸（宽320px）为相对的 参考依据，宽640px的设计稿，以原始尺寸切出来的图标称为2倍图（2x）。</span></span></span></p><p>&nbsp;</p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">有人可能会问：为什么不拿320px作为设计稿的原始尺寸呢？因为1倍图放大成为2倍图远比2倍图缩小成1倍图来得模糊！</span></span></span></p><p>&nbsp;</p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">于是，在不考虑iphone6和iphone 6 plus的情况下，为了适配iphone，每个图标需要切两份。</span></span></span></p><p>&nbsp;</p><p><strong style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; white-space: normal; background: rgb(255, 255, 255);\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\">Android - 更为繁多的界面尺寸</span></strong><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">Android开源自由的代价就是设备规范的不可控，市面上充斥着各种品牌的android手机，有着各种各样的尺寸和分辨率，为了适配各种不同分辨率的设备，同一个图标需要切成N份，每一份对应一个尺寸。</span></span></span></p><p>&nbsp;</p><p><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; color: rgb(120, 120, 120); background: transparent;\"><span style=\"font-family:Tahoma, simsun;margin: 0px; padding: 0px; border: 0px; outline: 0px; vertical-align: baseline; background: transparent;\"><span style=\"margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 12px; vertical-align: baseline; background: transparent;\">另外需要注意的是，Android里面开发用的尺寸单位是dp或sp（dp为元素表现尺寸，sp为字体尺寸）而不是iphone中的px。。。</span></span></span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', '', '来自火星的程序猿', '/61/66\\56.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('57', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 24px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">感到自己深陷千篇一律的设计泥潭无法自拔？</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 24px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">Stylorouge的Rob O’Connor为你送上下面几条建议帮助你解放自己的想象力。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 26px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">找不到设计灵感？项目在眼前却不知道如何着手或者找不到合适的入手角度？挣扎着想克服阻拦创意的屏障？</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 26px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">别着急，哪怕是最优秀的设计师也会碰上这些问题。你只需要找到方法让大脑重回战斗状态，创意就会源源不断滚滚而来。下面，我们为你整理了一系列能帮助你有效进行头脑风暴的小建议，另外还有五个绝妙的应用协助你捋清头脑风暴的流程。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', 'p,h,', '来自火星的程序猿', '/61/65\\57.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('58', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\">在这个简短的移动端设计模式系列文章的前几篇中，我为大家介绍了几个能够解决开发期间所产生问题的常见设计模式，大家也学到了什么是设计模式，其基本组成 部分有什么，使用它们解决问题的最佳方法都有哪些，以及表单、图片集架构、搜索功能和交互建议等各种问题。另外，大家应该还了解了避免<br/>作为本系列的终篇，我将为大家概括性地介绍5种流行移动应用中常见的界面设计模式以供大家在自己的项目中参考。这些设计模式有助于大家提高设计的可用性，让界面变得更加直观。文章将侧重介绍能够帮助大家进行下列各方面设计的模式：<br/>· 社交分享<br/>· 通知<br/>· 弹窗<br/>· 内容更新<br/>· 用户互动（滑动、点击等）</p><p><br/></p>', '', '来自火星的程序猿', '/61/65\\58.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('59', 'MS', '<p>网页中的柔和色调的使用，不止是近来的趋势，这是一项设计师使用多年的技巧，用来创造有冲击力的视觉效果。</p><p><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p>当你听到“柔和”一词，想到的可能是淡粉色、淡蓝色、淡黄色，不过这种配色远不止这些颜色。柔和并不一定要感觉像新生儿一样。通过某些适当的方式，配合其他元素，这些色调也可以相当鲜明。</p><p><br style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; white-space: normal; background-color: rgb(255, 255, 255);\"/></p><p>下面我们从优秀的案例网站出发，了解10种在网页设计中运用柔和色调的方法。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', '', '来自火星的程序猿', '/61/65\\59.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('60', 'MS', '<p><span style=\"color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\">随着苹果ios8的发布，可以看到App store货架上，众多主流App迫不及待地向人们展示产品视频预览，接下去会是被设计师、市场宣传相继关注的焦点，产品宣传的下一轮引爆点。作为能在 App store上先发触达地形成前期推广的视频预览，又会否影响到App安装完毕后的引导页呈现？我们不得而知。鉴于两者形式的展现，间隔于安装App前后， 多少会规避重复性。不管怎样，趁着手机App和扁平风热潮，一起来细数归纳下对手机引导页的所见所想。 早期我们会见到比较多成熟的PC软件或者网页产品的产品安装包或新特性指引页。近几年在移动端平台上兴起了各种门类，形式精彩纷呈的引导页。</span></p>', '', '来自火星的程序猿', '/61/65\\60.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('61', 'MS', '<p>一幅好照片要把观众的注意力吸引到趣味中心&amp;mdash;&amp;mdash;被摄主体上。无论是拍什么 类型的照片，都会有一个主体你喜欢拍人物，拍生态，这些都不是问题，但是一旦主体被模糊，欣赏照片时就会忽略照片的主体，这样的照片是不失败不完美的，因 为真正想让观众看的东西并没有一眼看到。例如婚纱照，主体肯定是人物新娘和新郎。如果目光都被新娘后面的景色吸引，而不是新娘，这肯定不会是我们想照的。</p><p>&nbsp;</p><p>&nbsp; &nbsp;&nbsp;&nbsp;网页设计师的重要任务不是根据内容做出网页，而是根据用户需求设计出让用户喜欢并积极使用的网页，能够让用户知道并去使用网站的新产品or关键点 or有价值的信息，那么如何突出这些点？如何让用户看到网页的&amp;ldquo;G点&amp;rdquo;，有让用户点击或者传播的欲望？突出设计 的重点就如同突出摄影的被摄主体一样，把控视觉的重点，你的设计一定会非常精彩。</p><p>&nbsp;</p><p>&nbsp; &nbsp;&nbsp;&nbsp;下面我将通过几种突出被摄重点的摄影方法来诠释设计与摄影的微妙关系。</p><p>&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; font-stretch: normal; font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; color: rgb(114, 114, 114); white-space: normal; background: rgb(255, 255, 255);\"><br/></p><p><br/></p>', '', '来自火星的程序猿', '/61/65\\61.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('62', 'MS', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MStore主页：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\"><a href=\"http://static.oschina.net/uploads/space/2015/1124/231902_VsUz_2501041.jpg\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于学习JAVA开发的工程师来说这无疑是最好的学习项目,并且最大的优势在于整个系统的结构非常清晰,使用的都是当下JAVA最常用最热门的技术,由于MCMS是全部开源并且作为MS的技术架构在使用这也就说明在学习MCMS的同时也学会了相应的框架使用方法。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS结构图解：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的群站解决方案和模块式的开发架构，让我们管理项目非常方便。不仅很好的解决了因为项目过多而导致的管理紊乱现象，而且还在一定程度上使服务器的资源得到最大化的利用，也避免同时维护多套系统的繁杂。由于是纯JAVA系统这里安全性完全可以放心。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">由于MS平台采用的是模块和插件式的开发,这又进一步从代码层面上提升了我们维护简便性和针对性，而不是像传统项目那样需要维护整套代码。比如：短信插件出问题了那么我们只需要单独的去维护端短信插件即可，其他插件模块不会因为短信插件在维护而受到影响。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台采用模块式开发，严格的说MCMS只是属于MS平台中的一个基础模块。这给定向业务和第三方平台的接入提供了很好的结构支持，从另一个角度来说MCMS严格的遵循了开闭原则，是支持无限拓展的。并且每一次拓展都不会伤害到原有的代码。不仅从结构上保障了系统的开发速度而且不会因为系统的升级或者是插件影响到系统的稳定性。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">同时MCMS将底层复杂的前端代码和第三方接口以及JDK中常用的方法做了很完善的二次封装，从代码角度来讲也大大的节省的开发时间。做到了真正的让代码飞起来！而且更为难得的是这些封装都具有极强规律性，和易用性这里简单的给大家举几个例子：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装的freemarker</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装表单</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装的上传图片插件</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装的分页</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><br/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台中有大量的插件和模版可以使用资源非常丰富，目前已经发布或者计划发布的官方模版有八套，开发者提交并且还在审核中的有162套，并且还在以每天10套左右的速度增加。目前已经发布或者准备发布的官方插件有：BBS(论坛)，商城，微信，分期，短信，淘宝，支付等由于数量众多这里就不一一列举。开发者提交的有短信模版插件、邮件模版插件、淘宝开放平台插件等其中大部分还在审核阶段。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台的资源之所以如此丰富插件和模块。一方面除了系统从结构上支持无缝对接之外，MS平台还拥有一大批优质的开发者。开发者在平台提交优质插件之后定价权在自己手中，这又从另外一个角度上大大刺激了海量优质插件的诞生。</span></p><p><br/></p>', '', '来自火星的程序猿', '/61/65\\62.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('63', 'MS', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过多年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MStroe主页：</span></p><p><br/></p>', 'h,', '来自火星的程序猿', '/61/65\\63.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('70', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">自 Git@OSC 上线以来受到广大开源作者的喜爱。值此新年之际，开源中国整理出 Git@OSC 最热门开源项目 Top50，对 Git@OSC 的发展至今所取得的成绩进行总结。此榜单主要通过开源项目的 Watch、Star、Fork 数量来评定，项目类型不尽相同，难免有纰漏，如有遗漏或者不妥之处，希望大家批评指正。若您对 Git@OSC 未来的发展有何意见或者建议，也欢迎在评论区留言告诉我们。<br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\"><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px;\">下面是项目列表：</strong></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">1、<a target=\"_blank\" href=\"http://git.oschina.net/jfinal/jfinal\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">JFinal</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项 目简介：JFinal 是基于 Java 语言的极速 WEB + ORM 框架，其核心设计目标是开发迅速、代码量少、学习简单、功能强大、轻量级、易扩展、Restful。在拥有Java语言所有优势的同时再拥有ruby、 python、php等动态语言的开发效率！为您节约更多时间，去陪恋人、家人和朋友 :)</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">2、<a target=\"_blank\" href=\"http://git.oschina.net/jeecg/jeewx\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jeewx</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：免费开源JAVA微信管家平台，实现了微信平台的基础功能，便于用户二次开发。JEEWX支持微信第三方平台全网发布、支持微信插件开发机制，可轻松集成微信H5插件。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">3、<a target=\"_blank\" href=\"http://git.oschina.net/tinyframework/tiny\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">tiny</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体\">项目简介：值得拥有的企业级j2ee应用开发框架套件，专业团队开发，完整的生态体系，活跃的社区氛围，无限的水平扩展能力，7*24不间断运维能力。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">4、<a target=\"_blank\" href=\"http://git.oschina.net/shishuo/CMS\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">CMS</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">一款使用Java语言开发的CMS，使用了Spring MVC,Spring,MyBatis等流行框架，提供首页大图管理、目录管理、文章管理和管理员管理等功能。是学习和二次开发的首选。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">5、<a target=\"_blank\" href=\"http://git.oschina.net/jeecg/jeecg\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jeecg</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项 目推荐：JEECG是一款J2EE企业级快速智能开发平台，开源界“小普元”超越传统商业企业级开发平台。基于代码生成器，引领新的开发模式 (Online Coding模式(自定义表单)-&gt;代码生成器模式-&gt;手工MERGE智能开发)， 可以帮助解决Java项目60%的重复工作，让开发更多关注业务逻辑。既能快速提高开发效率，帮助公司节省人力成本，同时又不失灵活性。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">6、<a target=\"_blank\" href=\"http://git.oschina.net/free/Mybatis_PageHelper\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">Mybatis_PageHelper</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：Mybatis_PageHelper 是 Mybatis 分页插件，支持任何复杂的单表、多表分页。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">7、<a target=\"_blank\" href=\"http://git.oschina.net/thinkgem/jeesite\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">JeeSite</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：JeeSite 是一个企业信息化开发基础平台，Java EE（J2EE）快速开发框架，使用经典技术组合（Spring、Spring MVC、Apache Shiro、MyBatis、Bootstrap UI），包括核心模块如：组织机构、角色用户、权限授权、数据权限、内容管理、工作流等。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">8、<a target=\"_blank\" href=\"http://git.oschina.net/ligerui/LigerUI\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">LigerUI</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：基于jQuery的UI框架，包括表单、布局、表格等等常用UI控件，使用LigerUI可以快速轻松地创建风格统一的界面效果。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">9、<a target=\"_blank\" href=\"http://git.oschina.net/9miao/CrossApp\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">CrossApp</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：一款完全开源、免费、跨平台的移动应用开发引擎，开发者可以完全免费、毫无顾虑的使用CrossApp开发任何项目。本引擎基于C++语言编写，OpenGl ES2.0图形渲染。拥有丰富的UI控件、丰富的第三方库、集成各种系统接口。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">10、<a target=\"_blank\" href=\"http://git.oschina.net/liu21st/thinkphp\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">thinkphp</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：ThinkPHP 是一个免费开源的，快速、简单的面向对象的 轻量级PHP开发框架 ，创立于2006年初，遵循Apache2开源协议发布，是为了敏捷WEB应用开发和简化企业应用开发而诞生的。ThinkPHP从诞生以来一直秉承简洁 实用的设计原则，在保持出色的性能和至简的代码的同时，也注重易用性。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">11、<a target=\"_blank\" href=\"http://git.oschina.net/kymjs/KJFrameForAndroid\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">KJFrameForAndroid</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：KJFrameForAndroid的设计思想是通过封装Android原生SDK中复杂的复杂操作而达到简化Android应用级开发，最终实现快速而又安全高效的开发APP。我们的目标是用最少的代码，完成最多的操作，用最高的效率，完成最复杂的功能。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">12、<a target=\"_blank\" href=\"http://git.oschina.net/rushmore/zbus\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">zbus</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：ZBUS=MQ+RPC+PROXY 服务总线 &nbsp;1)支持消息队列, 发布订阅, RPC, 代理（TCP/DMZ） &nbsp; 2)亿级消息堆积能力、支持HA高可用 &nbsp;3)无依赖单个Jar包 ~300K &nbsp; 4)丰富的API--JAVA/C/C++/C#/Python/Node.JS多语言接入，支持HTTP/Thrift等协议接入</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">13、<a target=\"_blank\" href=\"http://git.oschina.net/loyin/ECP\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">ECP</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：ECP&nbsp; 是基于jfinal、avalon、bootstrap、jqGrid、snaker工作流开发的客户关系及进销存财务系统。支持多企业使用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">14、<a target=\"_blank\" href=\"http://git.oschina.net/jfinal/jfinal-weixin\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jfinal-weixin</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：JFinal Weixin 是基于 JFinal 的微信公众号极速开发 SDK，只需浏览 Demo 代码即可进行极速开发，自 JFinal Weixin 1.2 版本开始已添加对多公众号支持。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">15、<a target=\"_blank\" href=\"http://git.oschina.net/farsunset/cim\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">cim</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：基于apache&nbsp; mina 的 java即时通讯服务端。与android 客户端完美结合，同时支持其他语言(ios,c,ActionScript，.net等)客户端的即时通信。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">16、<a target=\"_blank\" href=\"http://git.oschina.net/flashsword20/webmagic\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">webmagic</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：webmagic的是一个无须配置、便于二次开发的爬虫框架，它提供简单灵活的API，只需少量代码即可实现一个爬虫。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">17、<a target=\"_blank\" href=\"http://git.oschina.net/free/Mapper\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">Mapper</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：极其方便的使用Mybatis单表的增删改查。通用Mapper都可以极大的方便开发人员。可以随意的按照自己的需要选择通用方法，还可以很方便的开发自己的通用方法。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">18、<a target=\"_blank\" href=\"http://git.oschina.net/huangyong/smart-framework\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">smart-framework</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：轻量级 Java Web 开发框架，内置 IOC、AOP、ORM、DAO、MVC 等特性，基于 Servlet 3.0 规范，使用 Java 注解取代 XML 配置。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">19、<a target=\"_blank\" href=\"http://git.oschina.net/wzw/git-quick-start\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">git-quick-start</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：这是一个git的快速入门项目，使用一些gif图片来播放一些基础的git命令使用方法。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">20、<a target=\"_blank\" href=\"http://git.oschina.net/easypr/EasyPR\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">EasyPR</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：EasyPR是一个中文的开源车牌识别系统，其目标是成为一个简单、高效、准确的车牌识别引擎。 相比于其他的车牌识别系统，EasyPR有如下特点： * 它基于openCV这个开源库。这意味着你可以获取全部源代码，并且移植到java等平台。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">21、<a target=\"_blank\" href=\"http://git.oschina.net/dockerf/docker-training\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">docker-training</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：此次课程是：希云cSphere免费为国内docker爱好者进行docker培训。希云cSphere致力于为企业提供专业的docker管理平台，和paas平台！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">22、<a target=\"_blank\" href=\"http://git.oschina.net/wenshao/fastjson\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">fastjson</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：fastjson 是一个性能很好的 Java 语言实现的 JSON 解析器和生成器，来自阿里巴巴的工程师开发。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">23、<a target=\"_blank\" href=\"http://git.oschina.net/chunanyong/springrain\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">springrain</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：springrain是spring的极简封装,spring一站式开发的范例。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">24、<a target=\"_blank\" href=\"http://git.oschina.net/jueyue/easypoi\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">easypoi</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：POI 工具类,Excel的快速导入导出,Excel模板导出,Word模板导出,可以仅仅5行代码就可以完成Excel的导入导出,修改导出格式简单粗暴,快速有效,easypoi值得你尝试。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">25、<a target=\"_blank\" href=\"http://git.oschina.net/xautlx/s2jh\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">s2jh</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：基于SSH的企业Web应用开发框架。集结最新主流时尚开源技术的面向企业级Web应用的基础开发框架，提供一个J2EE相关主流开源技术架构整合及一些企业应用基础通用功能和组件的设计实现的最佳实践和原型参考。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">26、<a target=\"_blank\" href=\"http://git.oschina.net/eova/eova\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">eova</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：J2EE快速开发平台，master 为最新代码，稳定版-&gt;请下载最新的Tag版本，Eova仅兼容webkit 内核浏览器，IE和火狐是不兼容的，推荐使用谷歌浏览器。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">27、<a target=\"_blank\" href=\"http://git.oschina.net/wwccss/zentaopms\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">zentaopms</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：禅道是第一款国产的开源项目管理软件。它集产品管理、项目管理、质量管理、文档管理、组织管理和事务管理于一体，是一款专业的研发项目管理软件，完整地覆 盖了项目管理的核心流程。注重实效，合软件架构合理，操作简洁高效，扩展灵活，多语言支持，多风格支持，搜索功能，统计功能——这一切，您通过禅道，都可 以拥有！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">28、<a target=\"_blank\" href=\"http://git.oschina.net/kuiyu/dotnetcodes\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">DotNetCodes</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：一些常用的功能性代码,可以减少许多开发时间,而且类与类之间没有什么依赖,每个类都可以单独拿出来使用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">29、<a target=\"_blank\" href=\"http://git.oschina.net/xknaan/B-JUI\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">B-JUI</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：B-JUI（Best jQuery UI） 前端框架，轻松开发，专注您的业务，从B-JUI开始。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">30、<a target=\"_blank\" href=\"http://git.oschina.net/duxcms/DuxCms-2.0\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">DuxCms 2.0</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：DUXCMS是一款针对于中小网站与二次开发平台的一款管理系统，基于canphp3框架，后台采用拼图UI，更加利于多平台使用于开发者快速开发。开发版基于正式版进行的部分优化于实验性功能，不建议作为正式建站使用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">31、<a target=\"_blank\" href=\"http://git.oschina.net/cynthia/Cynthia\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">Cynthia</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：Cynthia提供了一个基于Web的、开源的、跨平台的软件项目管理和问题管理的解决方案。通过极大的灵活度，实现了特殊性和普遍性的统一。 它提供了强大的自定义配置功能，用户能够根据自己的实际情况配置问题的流转和数据模板，它同时内置了强大的Cache模块提高数据的访问效率。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">32、<a target=\"_blank\" href=\"http://git.oschina.net/anycmd/anycmd\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">anycmd</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：一个完全开源的，完整支持rbac的，将会支持xacml、javascript的通用的权限框架、引擎、中间件、解决方案。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">33、<a target=\"_blank\" href=\"http://git.oschina.net/yhtt2020/OpenCenter\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">OpenCenter</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：基于Apache2.0 开源通用 用户及后台管理框架，提供了注册登录、头像裁剪、单点登录、权限管理、扩展资料管理、等级头衔、自定义积分管理、用户行为日志机制、模块装卸、插件机制，提供建议的安装程序。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">34、<a target=\"_blank\" href=\"http://git.oschina.net/dogstar/PhalApi\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">PhalApi</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：PHP轻量级开源接口框架，专注于后台接口的快速开发。在移动互联网时代的这十年，希望此框架能对各接口开发有实际的帮助，欢迎使用！我们致力于将PhalApi维护成像恒星一样：不断更新，保持生气；为接口负责，为开源负责！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">35、<a target=\"_blank\" href=\"http://git.oschina.net/zftlive/zftlive\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">zftlive</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">项目简介：这是一个集成目前Android主流优秀第三方组件、优秀好用的自定义控件、实用工具类封装、以及一些APP共通模块（比如：版本更新、意见反馈、引导界面等等）的开发包，帮助程序员快速开发自己的APP。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">36、<a target=\"_blank\" href=\"http://git.oschina.net/284520459/commonrpc\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">commonrpc</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项 目简介：还在羡慕BAT等公司的大流量的架构吗？让你的java系统引用解耦，互相独立,commonrpc 就可以办到。commonrpc 是一个以netty 传输协议框架为基础， 自定义 spring shcema标签的rpc框架,不侵入任何业务代码，插件模式，即插即用；一个高性能分布式rpc框架，支持tcp，http协议，扩展性强。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">37、<a target=\"_blank\" href=\"http://git.oschina.net/ITdos/Dos.ORM\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">Dos.ORM</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：Dos.ORM（原Hxj.Data）于2009年发布，并发布实体生成工具。在开发过程参考了多个ORM框架，特别是NBear，MySoft、EF、Dapper等。吸取了他们的一些精华，加入自己的新思想。该组件已在上百个成熟企业项目中应用。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">38、<a target=\"_blank\" href=\"http://git.oschina.net/crm8000/PSI\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">PSI</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：PSI是开源进销存系统。PSI是希腊字母Ψ的读音。产品寓意：PSI本身不完美，但追求的是不断改进的品质，距离终极产品就一步之遥(因为在希腊字母表中，Ψ之后是Ω，Ω有终极的意思)。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">39、<a target=\"_blank\" href=\"http://git.oschina.net/loyin/jecp\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">JECP</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">JECP 集合了easyui +jfinal +druid+freemarker，非常方便开发。目前只完成了系统管理模块，属于开发整合。具体功能本人时间不多，未能实现。工作流采用的是activiti，目前已在另外的项目中采用。等应用成熟后会后续添加到JECP中。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">40、<a target=\"_blank\" href=\"http://git.oschina.net/mingSoft/MCMS\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">MCMS</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：免费开源铭飞MCMS系统完整J2EE代码,提供商城、微信、论坛等更多丰富插件，每月28更新新版本。快的不像JAVA系统。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">41、<a target=\"_blank\" href=\"http://git.oschina.net/X5OK/WeX5\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">WeX5</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：WeX5是跨端移动快速开发框架；只需一次开发，即可发布、运行于各种前端平台上；支持iOS ipa、android apk、微信服务号/企业号应用、web app和其他轻应用的快速开发。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">42、<a target=\"_blank\" href=\"http://git.oschina.net/kyyblabla/QQLikeUI\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">QQLikeUI</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：Qt实现的高仿QQ6.x UI，登录窗体与主窗体已经部分实现，窗体目前还不能自由改变大小，但是可以随意拖动。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">43、<a target=\"_blank\" href=\"http://git.oschina.net/thinkcmf/ThinkCMFX\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">ThinkCMFX</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：ThinkCMF 是一款高速PHP内容管理框架，扩展性良好可高程度的提高开发者的开发效率，节省开发成本。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">44、<a target=\"_blank\" href=\"http://git.oschina.net/jeecg/jeewx-api\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jeewx-api</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：现在微信越来越火，基于微信的公众号和服务号越来越丰富，虽然微信帮助文档已经提供了相关的接口，但是接口比较多，通过代码自己调用比较麻烦，所以为减轻开发者独自创造轮子，将微信API进行了统一封装！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">45、<a target=\"_blank\" href=\"http://git.oschina.net/20110516/jfinalbbs\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">jfinalbbs</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：使用PHP开发的论坛遍地都是，但使用JAVA来开发社区基本上没有，朋也使用JFinal框架开发了一个属于JAVA语言的社区软件，在这开源供大家借鉴使用，大神勿喷。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">46、<a target=\"_blank\" href=\"http://git.oschina.net/osbzr/openerp-china\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">openerp-china</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：OpenERP中国版，降低OpenERP中国社区项目的参与门槛。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; \">47、<a target=\"_blank\" href=\"http://git.oschina.net/beyonehu/manual_dota\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">manual_dota</a><br style=\"box-sizing: border-box; margin: 0px; padding: 0px;\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">项目简介：《刀塔传奇》开源项目，服务器+客户端，蛮牛主办深圳玩贝科技组织。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体;\">48、<a target=\"_blank\" href=\"http://git.oschina.net/ocelot/examxx\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">examxx</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\">项目简介：Exam++是国内首款基于JAVA与MYSQL开发的网络考试系统。它可以稳定、顺畅的运行在Windows与Linux平台上。您可以通过它快捷方便的创建试题和题库，发布试卷，组织考试，系统自动批改。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\">49、<a target=\"_blank\" href=\"http://git.oschina.net/wangt/webbase\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">webbase</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\">项目简介：务系统框架,包括员工管理,组织机构,请假出差申请,流程审批,信息汇总,excel导出等基础功能。</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\">50、<a target=\"_blank\" href=\"http://git.oschina.net/mkk/HeartBeat\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(62, 98, 166); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; margin: 0px; padding: 0px; outline: 0px; background-color: transparent;\">HeartBeat</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 15pt; font-size: 14px; color: rgb(102, 102, 102); line-height: 22.4px; white-space: normal; padding: 0px; font-family: Verdana, sans-serif, 宋体; background-color: rgb(255, 255, 255);\">项目简介：心跳检测各类应用服务器(如Tomcat,Jetty),WEB服务器(如 Apache,Nginx) 的JAVA WEB应用程序。</p><p><br/></p>', 'c,', '来自火星的程序猿', '/59\\70.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('71', 'MS', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过多年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MStroe主页：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-align: center; \"><img src=\"/upload/editor/1569/1461658200683.jpg\" title=\"1461658200683.jpg\" alt=\"1461658200683.jpg\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/><img src=\"/upload/editor/1569/1461658233757.jpg\" title=\"1461658233757.jpg\" alt=\"1461658233757.jpg\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/><img src=\"/upload/editor/1569/1461658203315.png\" title=\"1461658203315.png\" alt=\"1461658203315.png\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/></p><p><br/></p>', '', '来自火星的程序猿', '/59\\71.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('72', 'MS', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; \"><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">首先还是介绍一下什么是CMS。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">CMS（Content Management System),中文叫作整站系统、文章系统。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">大概2004以前，如果想进行网站内容管理,基本上都是靠手工维护,但千变万化的信息流，但没有好的程序支持，还继续靠手工完成是不可能的事。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">如果有一个好的系统来支撑你的网站，那将节省大量的人力物力，开发者就可能给客户一个软件包，可以用它定期人工修改网站。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">只要你配置安装好，你的编辑，在线记者，更新员只要定期更新数据，剩下的事就交给CMS去处理。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/></p><h3 style=\"box-sizing: border-box; font-family: 微软雅黑; font-weight: 500; line-height: 28px; color: rgb(37, 37, 37); margin: 0px; font-size: 24px; white-space: normal; padding: 0px; \">铭飞CMS(MCMS)</h3><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><img src=\"/upload/editor/1569/1461658172067.jpg\" title=\"1461658172067.jpg\" alt=\"1461658172067.jpg\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">特点:</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">&nbsp;</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">Java领域唯一完全免费开源的系统，值得点个赞！在2015年开源中国排名第40位，铭飞cms系统也采用模块化开发，功能可扩展更方便。铭飞还提供了MStore资源平台，提供更多的模版与插件源码，这给整个系统来说增加了很多想象的空间。</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">免费完整开源：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">基于MIT协议，源代码完全开源，无商业限制,MS开发团队承诺将MCMS内容系统永久完整开源；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">标签化建站：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">不需要专业的后台开发技能，只要使用系统提供的标签，就能轻松建设网站；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">html静态化：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">系统支持全站静态化；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">跨终端：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">站点同时支持PC与移动端访问，同时会自动根据访问的终端切换到对应的界面，数据由系统统一管理；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">海量模版：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">铭飞通过MStore（MS商城）分享更多免费、精美的企业网站模版，降低建站成本；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">丰富插件：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">为了让MCms适应更多的业务场景，在MStore用户可以下载对应的插件，如：站群插件、微信插件、商城插件等；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">每月更新：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">铭飞团队承诺每月28日为系统升级日，分享更多好用等模版与插件；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">文档丰富：</strong><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">为了让用户更快速的使用MCms系统进行开发，铭飞团队持续更新开发相关文档，如标签文档、使用文档、视频教程等；</span><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><strong style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">评价:</strong><br style=\"box-sizing: border-box; margin: 0px; padding: 0px; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\"/><span style=\"box-sizing: border-box; color: rgb(37, 37, 37); font-family: 微软雅黑; font-size: 14px; line-height: 28px;\">算是Java领域开源的新星吧，框架的选型都很用心。对一个java程序猿来说二次开发很轻松。小编感觉铭飞并不是一个简单cms系统，从铭飞官方提供的MStore来看，系统可以实现各种业务模块，例如商城、分期系统、淘宝API、微信API等都有提供，同时也关注官方的MS平台，相信这是Java领域的福音。</span></p><p><br/></p>', '', '来自火星的程序猿', '/59\\72.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('73', 'MS', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MStore主页：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体;\"><img src=\"/upload/editor/1569/1461658043545.jpg\" title=\"1461658043545.jpg\" alt=\"1461658043545.jpg\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于学习JAVA开发的工程师来说这无疑是最好的学习项目,并且最大的优势在于整个系统的结构非常清晰,使用的都是当下JAVA最常用最热门的技术,由于MCMS是全部开源并且作为MS的技术架构在使用这也就说明在学习MCMS的同时也学会了相应的框架使用方法。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS结构图解：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\"><a href=\"http://static.oschina.net/uploads/space/2015/1124/231956_5q0R_2501041.png\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"><img src=\"/upload/editor/1569/1461658055795.png\" title=\"1461658055795.png\" alt=\"1461115606898073191.png\"/></a></span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的群站解决方案和模块式的开发架构，让我们管理项目非常方便。不仅很好的解决了因为项目过多而导致的管理紊乱现象，而且还在一定程度上使服务器的资源得到最大化的利用，也避免同时维护多套系统的繁杂。由于是纯JAVA系统这里安全性完全可以放心。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">由于MS平台采用的是模块和插件式的开发,这又进一步从代码层面上提升了我们维护简便性和针对性，而不是像传统项目那样需要维护整套代码。比如：短信插件出问题了那么我们只需要单独的去维护端短信插件即可，其他插件模块不会因为短信插件在维护而受到影响。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台采用模块式开发，严格的说MCMS只是属于MS平台中的一个基础模块。这给定向业务和第三方平台的接入提供了很好的结构支持，从另一个角度来说MCMS严格的遵循了开闭原则，是支持无限拓展的。并且每一次拓展都不会伤害到原有的代码。不仅从结构上保障了系统的开发速度而且不会因为系统的升级或者是插件影响到系统的稳定性。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">同时MCMS将底层复杂的前端代码和第三方接口以及JDK中常用的方法做了很完善的二次封装，从代码角度来讲也大大的节省的开发时间。做到了真正的让代码飞起来！而且更为难得的是这些封装都具有极强规律性，和易用性这里简单的给大家举几个例子：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装的freemarker</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><a href=\"http://static.oschina.net/uploads/space/2015/1124/232023_95Ky_2501041.png\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"><img src=\"/upload/editor/1569/1461658065646.png\" title=\"1461658065646.png\" alt=\"1461115607308036067.png\"/></a></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">封装表单</span><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">：</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><a href=\"http://static.oschina.net/uploads/space/2015/1124/232050_rWXe_2501041.png\" target=\"_blank\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"><img src=\"/upload/editor/1569/1461658076477.png\" title=\"1461658076477.png\" alt=\"1461115607472060206.png\"/></a></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台中有大量的插件和模版可以使用资源非常丰富，目前已经发布或者计划发布的官方模版有八套，开发者提交并且还在审核中的有162套，并且还在以每天10套左右的速度增加。目前已经发布或者准备发布的官方插件有：BBS(论坛)，商城，微信，分期，短信，淘宝，支付等由于数量众多这里就不一一列举。开发者提交的有短信模版插件、邮件模版插件、淘宝开放平台插件等其中大部分还在审核阶段。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台的资源之所以如此丰富插件和模块。一方面除了系统从结构上支持无缝对接之外，MS平台还拥有一大批优质的开发者。开发者在平台提交优质插件之后定价权在自己手中，这又从另外一个角度上大大刺激了海量优质插件的诞生。</span></p><p><br/></p>', 'h,', '来自火星的程序猿', '/59\\73.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('74', 'MS', '<h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; \">铭飞MCMS内容管理系统完整开源版J2EE代码</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">当前版本:5.4.2 铭飞MS官网:http://ms.mingsoft.net官网同时提供一键运行版本下载，请步移官网....</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><span id=\"OSC_h1_2\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px;\"><a href=\"http://git.oschina.net/mingSoft/MCMS#特点\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>特点</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">免费开源:纯Java开发，MS开发团队承诺将MCMS内容系统永久完整开源;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">终端统一: 铭飞MCMS支持PC与MOBILE皮肤定制,同时使用MS团队移动JS插件,轻松实现手机多屏幕适配,想想看你发布的信息第一时间在PC上展示又能在手机上展示,这是件多么幸福的事情,数据统一、平台统一、终端统一是MS团队一直在努力的方向;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">扩展性:以铭飞MCMS为核心,MS官网提供第三方插件安装,最新的插件用户可以通过更新功能获得,同时MS也鼓励并支持第三方开发人员发布优质的插件;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">更新升级: 铭飞MCMS提供了行业内最完美的升级方案,从此升级无需手动下载复制粘贴,一切完全由MS升级插件无缝完成;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">文档手册:铭飞不断向外部公布最新文档，如二次开发手册、标签使用手册,减轻用户学习成本;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">站群：MCMS支持站群，只需在服务器上架设一套铭飞MCMS就可以创建多个个网站，并且网站之间的数据是独立存在，很大程度降低了维护成本，与服务器资源的开销；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">其他：html静态生成、标签式建站</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">技术支持:提永久升级服务技术交流群,不定期会升级系统，开发可以关注后台的更新板块；</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; \"><span id=\"OSC_h1_3\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px;\"><a href=\"http://git.oschina.net/mingSoft/MCMS#面向对象\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>面向对象</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MCMS是企业在创立初期很好的技术基础框架，加快公司项目开发进度，当然也可以对现有的系统进行升级；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">个人开发者也可以使用MCMS承接外包项目；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">初学JAVA的同学可以下载源代码来进行学习交流；</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><span id=\"OSC_h1_4\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px;\"><a href=\"http://git.oschina.net/mingSoft/MCMS#开发框及语言\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>开发框及语言</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MCMS(铭飞内容管理系统)是一款支持不同平台、不同终端并且支持多站点的内容管理系统，</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· SpringMVC4+Spring4+MyBatis3+Freemarker技术架构</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 基于java技术开发，继承其强大、稳定、安全、高效、跨平台等多方面的优点；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 标签化建站，只要你懂html就能建站；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 完全生成全站静态页面；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 可自定义路径结构，全面提高页面访问速度；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">有人说铭飞MCMS是全国唯一完整开源的J2EE版本系统！团队希望看到更多的优秀好用的开源系统，我们一直会努力下去！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; \"><span id=\"OSC_h1_5\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; \"><a href=\"http://git.oschina.net/mingSoft/MCMS#运行环境\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>运行环境</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">原则上支持全系列JAVA运行环境；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">WEB服务器：Weblogic、Tomcat、WebSphere、JBoss 等</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库服务器：Mysql等</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">操作系统：Windows、Linux、Unix 等</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><span id=\"OSC_h1_6\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px;\"><a href=\"http://git.oschina.net/mingSoft/MCMS#开发环境\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>开发环境</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">建议开发者使用一下环境，这样避免版本带来的冲突</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">IDE:eclipse、MyEclise</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">DB:Mysql5.5</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">JDK:JAVA 7、J2EE6</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal;\"><span id=\"OSC_h1_7\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px;\"><a href=\"http://git.oschina.net/mingSoft/MCMS#重要文件说明\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>重要文件说明</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库连接文件: config.properties</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库文件：doc/db-mcms-open.sql</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库编码：UTF-8</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">模板文件：templets/1549/mooc</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">后台访问路径：</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">http://+ip地址（或localhost）+tomcat端口+项目发布名/ms/login.do</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">如果出现无法访问的情况输入</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">http://+ip地址（或localhost）+tomcat端口+项目发布名/initApp进行初始化</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">账号:msopen</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">密码:msopen</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; \"><span id=\"OSC_h1_8\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; \"><a href=\"http://git.oschina.net/mingSoft/MCMS#代码部署与常见问题\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>代码部署与常见问题</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MS官方开发社区文档&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/12998/detail.do\" target=\"_self\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\">http://ms.mingsoft.net/mbbs/12998/detail.do</a></p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; \"><span id=\"OSC_h1_9\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; \">系统美图</h1><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; \"><img src=\"/upload/editor/1569/1461657686925.jpg\" title=\"1461657686925.jpg\" alt=\"1461657686925.jpg\" width=\"700\" height=\"375\" style=\"width: 700px; height: 375px;\" border=\"0\" vspace=\"0\"/></p><p><br/></p>', '', '来自火星的程序猿', '/59\\74.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('75', '', '<p>织梦猫成立于2000年</p>', '', '', '/71\\75.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('76', '', '<p>2001年织梦猫会员数突破10000人</p>', '', '', '/71\\76.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('77', '', '<p>2002年织梦猫官网进行了一次大的改版</p>', '', '', '/71\\77.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('78', '', '<p>&nbsp;2004年织梦猫全新改版，更关注模板的质量</p>', '', '', '/71\\78.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('79', '', '<p>&nbsp;2004年织梦猫已经成为模板行业第一分享平台</p>', '', '', '/71\\79.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('80', '', '<p>2005年织梦猫开通网站建设在线培训视频课程</p>', '', '', '/71\\80.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('81', '', '<p>我们一直在努力，期待得到大家的支持</p>', '', '', '/71\\81.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('82', '模板下载', null, '', '网站建设培训', '/72/73\\82.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('83', '', null, '', '建站资源共享平台', '/72/74\\83.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('84', '', null, '', '', '/72/75\\84.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('85', '网站模板', null, '', '网站建设培训', '/72/75\\85.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('86', '', null, '', '', '/72/76\\86.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('87', '', null, 'f,', '', '/72/78\\87.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('88', '', null, 'c,', '', '/72/78\\88.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('89', '', null, 'p,', '', '/72/78\\89.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('90', '', null, 'h,', '', '/72/78\\90.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('91', '建站资源共享平台', null, '', 'www.dedemao.cn ', '/72/79\\91.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('191', '铭飞', '<p><span style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px;\">日前，公司成功中标杭州市民中心G楼约18000多平方米四层公共区域装饰工程，这是继杭州钱江新城国际会议中心之后的又一城市标志性建筑工程。</span><br style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px;\">在该项目施工过程中，公司始终将“绿色装饰”理念融入其中。“绿色装饰”是指在设计、装修选材、施工等整个过程都符合绿色环保的理念，把对环 境造成的危害降低到最小，让市民享受到真正的绿色生活。随着社会的不断发展，“绿色装饰”日趋成为广大建筑装饰企业努力的方向。</span><br style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px;\">公司项目部在杭州市民中心G楼工程中，严格按照健康、环保、安全的施工标准，精心施工，力争达到“浙江省建筑安全文明标化工地”的要求。在原 材料的选用上精挑细选，大量运用了玻璃、大理石材等绿色环保和高品质的装饰材料，突显出了简约、明快、自然的设计风格，创造出宽阔、绿色、实用的公共空 间。</span><br style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px;\">此外项目部还非常注重采取新工艺、新方法，不仅提高了工程的整体美观性和实用性，而且加快了施工进度，提升了工作效率。由于本工程是圆型结构的楼层施 工，特别是石材在圆弧和圆柱造型上用量大，大大增加了工程的施工难度。因此，项目部按工程施工位置的不同分别采用了石材干挂施工工艺和石材湿贴与灌浆施工 工艺。通过这两种施工工艺铺出来的石材平整、洁净、色泽一致，无裂痕和缺损，既美观又方便今后日常护理。</span><br style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px; white-space: normal;\"/><span style=\"color: rgb(102, 102, 102); font-family: 微软雅黑; font-size: 12px; line-height: 24px;\">作为杭州市重点工程，杭州市民中心G楼公共区域装饰工程得到了公司领导的高度重视。总经理高利明亲自坐镇指挥，组建了一支强有力的项目领导管 理班子，采用矩阵式组织管理体系，即采取以项目经理为第一责任人，分解项目绿色施工指标，形成完善的绿色施工组织、责任体系，在保证质量、安全等基本要求 的前提下，通过科学管理和技术进步，最大限度地节约资源与减少对环境负面影响，实现四位一体的绿色环保施工，打造“绿色装饰”精品工程。</span></p>', 'h,', '铭飞', '/62/84\\191.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('99', '', null, 'f,h,', '&#xe77f;', '/62/85\\99.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('100', '', null, 'f,', '&#xe6ee;', '/62/85\\100.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('101', '', null, 'f,', '', '/62/85\\101.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('102', '', null, 'f,h,', '&#xe640;', '/62/85\\102.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('103', '', null, 'c,p,', '&#xe62f;', '/62/85\\103.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('104', '', null, 'c,', '', '/62/85\\104.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('105', '', null, 'c,', '', '/62/85\\105.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('106', '', null, 'c,p,', '&#xe780;', '/62/85\\106.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('109', '&#xe746;', null, '', 'left', '/62/86\\109.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('110', '&#xe696;', null, '', 'center active', '/62/86\\110.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('111', '&#xe682;', '<p>last</p>', '', 'right', '/62/86\\111.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('112', '', '<p><strong>主营品牌车型：</strong>奔驰、宝马、奥迪、路虎、保时捷、宾利、劳斯莱斯、北京现代、上海大众斯柯达、东风标致、东风悦达起亚、东风雪铁龙、东风本田雪弗兰、上海大众、进口大众、道奇、吉普、雷诺、别克、马自达、中华、福特、海南马自达等各种中高档进口和国产轿车。在汽车销售行业里有着较高的知名度和良好的信誉。</p><p>经营业务：除了销售各种品牌车外，还经营汽车保险、汽车装潢、汽车按揭、二手车评估、二手车收购、二手车置换，并免费为您提供上牌等一条龙服务。</p><p>&nbsp;</p><p><strong>郑重承诺：</strong>保证您从我公司购买的车是全市场上最低的价格，让您购的放心， 我公司所售车辆均为各品牌4S店的车，选车、交钱、提车、开发票、售后保养，一切的一切都在4S店办理，我们就相当于是4S店的跑量销售员（批发价）。 说白了，就是您在4S店买车我们帮您还价。 您在我公司定了车以后，我们会安排4S店的销售员和你联系。</p><p><strong>经营宗旨：</strong>减少成本和跑量给消费者带来最大的实惠！金杯银杯不如客户的口碑！只要您买过就会介绍朋友来买！</p><p>宝诚导购流程：我公司为了让大家更放心的购买汽车，现进行经营模式调整，较以前更加灵活、更加方便、更具备人性化。如果有客户觉得我们的价格比较实惠，但又担心车的来源，在这种情况下，我公司对有顾虑的客户，我们帮您排除这个疑虑。在我们公司签定车合同后，我们安排4S店销售员和您联系，办理所有相关手续。具体导购流程如下：</p><p><strong>第一步：</strong>您可以先到您所需品牌的任何一家4S店看车，选车，然后决定要什么车型。</p><p><strong>第二步：</strong>决定好所需车型，在某品牌4S店进行砍价，和销售员谈个最低价，但切忌不要交定金。</p><p><strong>第三步：</strong>拨打我们公司电话，告诉我们您需要的车型和颜色，以及哪家4S店。和我们谈好您觉得的满意的价格，我们觉得有钱可赚（少赚点没关系，不亏就行），意见达成一致。</p><p><strong>第四步：</strong>直接到我们公司签定车合同并交付定金。<br/><strong>第五步：</strong>我公司安排销售人员陪同客户去4S店提车并办理相关手续。</p><p><br/></p>', 'h,', '公关前台', '/61/87\\112.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('113', '', '<p><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">&nbsp;</span><strong style=\"font-size: 14px; white-space: normal; font-family: 宋体; line-height: 22px; padding: 0px; margin: 0px; background-color: rgb(255, 255, 255);\">1、特色服务</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\"></span></p><p>1.1 提供专业的危险品一条龙服务，从专业的危险品取样，代做报告（化工报告和商检报告危包证），及提供报关单证，报关，申报，交接危险品货物，至货物安全的到达目的港，全方位的D/D TO D/D 服务；</p><p>1.2 东航，国泰，阿联酋，汉莎4GV包装使用备案免检企业，可采用4GV作为货物外包装，免于检验；</p><p>1.3 能够协助客户用MSDS 来代替化工报告的业务。</p><p>&nbsp;</p><p><strong style=\"padding: 0px; margin: 0px;\">2、&nbsp;常规服务</strong></p><p>2.1 订舱：快捷、顺畅、全面快捷</p><p>便捷多样的订舱渠道（EK，MU，CX，LH，KL，AF，FM，CA等）顺畅：熟悉各航空公司危险品订舱要求及操作流程。全面：承接全球各航空公司航线化工品、危险品运输</p><p>2.2 仓库 运输</p><p>提供全方位专业的打托、包装、唛头、标签及更换外包装等服务；公司自备各类具有危险品资质的车辆，满足客户上门提货的需求。</p><p>2.3 报关、报检</p><p>代办空运危险品的报关报检,上海化工院鉴定，IMI鉴定证书，代做危包证等服务。</p><p>2.4 货物查询</p><p>E-SERVICE：自助式网上查询系统，方便客户跟踪、查询货物状态。</p><p>&nbsp;</p><p><strong style=\"padding: 0px; margin: 0px;\">3、 实力资质</strong></p><p>3.1 专业人员</p><p>资深的客户服务人员、订舱操作人员、危险品货物交接人员，拥有丰富的化工品、危险品专业知识和具有良好的沟通能力，熟悉各航空公司对危险品的操作流程。</p><p>3.2 完善系统</p><p>专业的流程化订舱体系ERP操作系统，从接单、订舱、货物包装商检、报关交接等一系列货物运输环节，R-Q HSE安全控制体系，监控并确保货物安全规范运输。</p><p>3.3 资质及设施</p><p>中国外经贸部批准的一级货运代理证书，中国航空运输协会批准颁发的一级货运代理证书，中国货代百强企业；</p><p>操作人员拥有中国航协ITAT 颁发的危险品操作人员证书和DGM 及浦东机场货栈颁发的危险品资质证书；</p><p>在机场内拥有6000平方米的普通仓库，4000 平方米的专业危险品仓库，齐备叉车，打包机等专业的仓储设备，120辆专用危险品运输车辆为客户提供专业、安全、便捷、快速的仓储及配送服务。</p><p><br/></p>', 'c,', '总经理', '/61/87\\113.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('114', '', null, 'f,', '站长', '/71/88\\114.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('115', '', null, 'f,', '副站长', '/71/88\\115.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('116', '', '', 'f,', '设计师', '/71/88\\116.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('117', 'last', null, 'f,', '支持', '/71/88\\117.html', 'last', '0', '1');
INSERT INTO `cms_article` VALUES ('118', '', null, 'h,', '&#xe605;', '/89\\118.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('119', '', null, 'h,', '&#xe677', '/89\\119.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('120', '', null, 'f,', '&#xe7cd;', '/89\\120.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('121', '', null, 'f,', '&#xe643;', '/89\\121.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('122', '', null, '', '&#xe605;', '/62/90\\122.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('123', '', null, '', '&#xe6f9;', '/62/90\\123.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('124', '', null, '', '&#xe70e;', '/62/90\\124.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('125', '', null, '', '&#xe688;', '/62/90\\125.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('126', 'last', null, '', '&#xe64a;', '/62/90\\126.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('127', '', null, '', '', '/62/91\\127.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('128', '', null, '', '', '/62/92\\128.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('166', '', null, '', '65', '/63\\166.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('167', '', '<p><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">公司为危化客户提供危化行业危化车辆销售、金融支持、服务、二维检测、罐体检测与清洗、紧急救援、从业人员培训、二手车置换、危化物流信息平台、事故车维修理赔等多功能于一体的服务中心，提供专业的产品与服务，保障危化车辆运输安全。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">全天候服务：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">本公司在周末、节假日均提供正常服务。在夜间，公司设有值班人员。客户遇险可及时打电话到公司，相关人员将在最短的时间内提供救援服务。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">送服务上门：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">客户无论是租车、修车、保养或其它相关问题，如客户不便来我公司办理，公司可派相关专业人员上门提供服务。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">替换车辆：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">客户所租车辆遇险或发生故障，在车辆修理期间，公司可提供临时替换车辆。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">定时保养：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">本公司按时给租赁车辆实施保养，以保障客户所租车辆处于正常运转状态。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">车辆保险：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">本公司为全部租赁车辆办理保险，并负责出险索赔。客户可以放心地驾驶所租车辆。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">自驾租赁：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">不论您是家庭出行、商务往来、公务出行、出外旅行还是短期替换车，我们都能向您提供符合您需求的租赁车辆。多样的车型、专业的服务、低廉的价格使您体验便捷舒适的汽车租赁服务。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">代驾租赁：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">本公司拥有一支经过严格训练，高素质、熟悉长春及周边地区道路情况的驾驶员队伍，随时可以根据您的需要提供代驾租赁服务。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">商旅服务：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">为客户提供机场单程、往返的接送服务，面向长期客户的定向购车租赁服务。</span><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><strong style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\">职业驾驶员的代驾服务：</strong><br style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; white-space: normal; background-color: rgb(255, 255, 255);\"/><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">汽车租赁商务车队拥有宝马、别克商务、奥迪、帕萨特、桑塔纳志俊等数十种品牌的商务车型，及一支文化素质高、配置合理并经过专业培训的司机队伍。商务车队秉承良好&quot;高效、快速、品质、服务于人&quot;的服务宗旨，以过硬的专业技术，快速的反应，高标准的服务,为客户提供全天候汽车代驾服务。</span></p>', 'h,', '66', '/63\\167.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('168', '', '<p><strong style=\"font-size: 14px; white-space: normal; font-family: 宋体; line-height: 22px; padding: 0px; margin: 0px; background-color: rgb(255, 255, 255);\">1、特色服务：</strong><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\"></span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">1.1&nbsp;</span>承接各类化学品、危险品的进出口的贸易代理业务</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">1.2&nbsp;</span>承接样品、修理物品、暂时进出口等特殊贸易方式的进出口代理业务</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">1.3&nbsp;</span>代办两用物项进出口许可证：包括电子钥匙的申领、进出口经营登记申请及进出口许可证的办理</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">1.4&nbsp;</span>承接黄磷、硝化棉的贸易采购业务</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">&nbsp;</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><strong style=\"padding: 0px; margin: 0px;\"><span style=\"padding: 0px; margin: 0px;\">2、</span>常规服务：</strong></span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">2.1&nbsp;</span>接单：专业的客服人员和完善的操作流程，提供贸易代理的咨询和操作服务</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">2.2&nbsp;</span>制单：全套进出口单证的制作</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">2.3&nbsp;</span>外汇结算：及时准确的安排收付外汇，保证外贸义务的及时履行</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">&nbsp;</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><strong style=\"padding: 0px; margin: 0px;\"><span style=\"padding: 0px; margin: 0px;\">3、</span>实力资质：</strong></span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">3.1&nbsp;</span>专业人员</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">资深客户服务及管理人员，拥有丰富的化工品、危险品专业知识和贸易操作经验，为客户提供化学品、危险品进出口贸易代理服务。</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">3.2&nbsp;</span>完善体系</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">1）&nbsp;专业的一体化<span style=\"padding: 0px; margin: 0px;\">ERP系统，从接单到代理合同、单证制作、交付货代、结算货款、出口退税，严格控制贸易代理的每一个环节。</span></span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">2）&nbsp;RQHSE安全控制体系，监控并确保货物安全规范的操作。</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">3.3<span style=\"padding: 0px; margin: 0px;\">&nbsp;</span></span>采购资源</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">与国内多家大型能源型企业为长期合作伙伴关系，可为境外的黄磷、硝化棉需求商稳定供货。</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\"><span style=\"padding: 0px; margin: 0px;\">3.4&nbsp;</span>相关资质</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">1）外经贸核准的进出口经营许可</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">2）海关核准的企业报关资质</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">3）商检局核准的出入境检验检疫报检资质</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">4）外汇管理局核准的企业进出口外汇经营资质</span></p><p><span style=\"line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; color: rgb(0, 0, 0);\">5）安监局审核的危险化学品经营许可<span style=\"padding: 0px; margin: 0px;\">&nbsp;&nbsp;</span></span></p><p><span style=\"font-size: 14px; line-height: 22px; font-family: 宋体; padding: 0px; margin: 0px; background-color: rgb(255, 255, 255);\">6）健全的服务网络：在国内主要港口如上海、天津、青岛等设有分支机构，国内代理网络齐全。</span></p><p><br/></p>', 'c,', '67', '/63\\168.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('169', '', '<p><br/></p><p style=\"padding: 0px 0px 0px 20px; margin-top: 0px; margin-bottom: 0px; line-height: 32px; color: rgb(95, 180, 4); font-size: 14px; font-weight: bold; background-color: rgb(242, 241, 241);\">关于我们</p><p><br style=\"padding: 0px; margin: 0px;\"/></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp; &nbsp; 我们的宗旨是为您量身打造互联网一站式解决方案。提供网站建设、网站设计、网站优化、网站维护、网站推广、seo优化、营销策划、网络营销等一系列专业服务。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 日新月异的互联网，已使得各行各业的生存方式与运作模式发生了根本性的变化。行业间的界限变得越来越模糊，竞争越来越激烈，企业的新兴型服务需求也源源不断地诞生，而传统单一的行业服务显然已满足不了今天互联网时代企业与时俱进的发展要求。<br style=\"padding: 0px; margin: 0px;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 因此，这种集网站建设、网站设计、网站优化、seo优化、网站策划、营销策划、网络营销、域名注册、虚拟主机、企业邮局等互联网服务综合优势于一体的新型网络互动服务商便应运而生。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp; &nbsp; &nbsp; 凭借资深的网络营销顾问、强大的调研队伍、专业的WEB美工设计、优秀的数据库及程序开发、敬业的客户服务经理等专业团队，以及多年来对互联网络的持续深入研究、对各行业客户的理解、对项目的整体策划控制、对国际化标准和流行趋势的掌握、对客户形象的视觉传递、对应用系统的完美结合等，我们能快速的为企、事业单位提供一站式顾问服务。我们的理念是根据其不同客户的商业发展目标与需求，定制最佳的解决方案开发出最大“价值化”的产品，帮助他们从同行业中脱颖而出。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;</p><p style=\"padding: 0px 0px 0px 20px; margin-top: 0px; margin-bottom: 0px; line-height: 32px; color: rgb(95, 180, 4); font-size: 14px; font-weight: bold; background-color: rgb(242, 241, 241);\">优势</p><p><br style=\"padding: 0px; margin: 0px;\"/></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 让案例说话<br style=\"padding: 0px; margin: 0px;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 只有对客户进行深入透彻的了解，才能明白客户的需求所在，才能建设一个合乎客户需要的网站和提供一整套完善的解决方案。因此对每一个项目的客户都会进行详细的需求分析调研。一方面了解项目以及整个所属行业的的各方面情况，另一方面了解客户的需求。网站包含两重点部分，一是给人们展现的形象，另一部分是人性化的使用（功能）。我们提倡 “一切靠作品说话”，只有作品才能最直观地反映一家服务及开发公司的能力。客户的利益是通过案例来体现的，在商业设计的前提下，成功案例是最好的说服力。我们向客户展示了大量的成功案例，这些案例非常直观，客户完全可以从这些直观的案例中了解我们的开发能力对他们来说是否有价值，以及考虑是否需要我们的服务。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 技术，是我们生存与发展的保障<br style=\"padding: 0px; margin: 0px;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 领先的技术是为客户提供优质的互联网服务及技术开发的基础。网络行业是一个新兴而且发展迅速的行业，需要不断更新的技术，才能对应时代的脚步！我们凭借长期在行业发展的经验和精诚合作的高效团队，充分发挥每一个工程师的潜力，使他们感受到一种良好的氛围，才能设计开发出具有代表性的案例或适合企业应用的产品，从而，帮助您的企业在同行竞争中获得信息化支持。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 完善的服务体系<br style=\"padding: 0px; margin: 0px;\"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 根据客户具体情况制定系列专业和规范的客户服务和保障体系，提供专业的服务，保证售后的服务质量，达到双赢的合作效果我们自信能充分满足您现今与将来的需求，并建立长久合作关系。使客户在后期的服务上无后顾之忧！</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">&nbsp;</p><p style=\"padding: 0px 0px 0px 20px; margin-top: 0px; margin-bottom: 0px; line-height: 32px; color: rgb(95, 180, 4); font-size: 14px; font-weight: bold; background-color: rgb(242, 241, 241);\">原则</p><p><br style=\"padding: 0px; margin: 0px;\"/></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px;\">诚信专一<br style=\"padding: 0px; margin: 0px;\"/>做人要诚信、做事情要专一、这是做好事情的第一步。<br style=\"padding: 0px; margin: 0px;\"/>尊重策略<br style=\"padding: 0px; margin: 0px;\"/>正确的策略可以成就一副好的作品，策略是为销售服务的。<br style=\"padding: 0px; margin: 0px;\"/>谦虚务实<br style=\"padding: 0px; margin: 0px;\"/>我们坚信:只有抓住老鼠的猫，才是好猫，我们喜欢用作品说话。<br style=\"padding: 0px; margin: 0px;\"/>讲究效率<br style=\"padding: 0px; margin: 0px;\"/>时间是金钱，效率是生命。<br style=\"padding: 0px; margin: 0px;\"/>追求精品<br style=\"padding: 0px; margin: 0px;\"/>我们每一幅作品都是精品，自己满意，更让客户满意。<br style=\"padding: 0px; margin: 0px;\"/>团队协作<br style=\"padding: 0px; margin: 0px;\"/>我们只有为客户目标而奋斗的团队，没有精通百般武艺的个人英雄。</p><p><br/></p>', '', '', '/56\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('130', '', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州城市规划设计有限公司是中欧国际旅游规划设计研究院（Sino-Europe Academy of Tourism Planning and Design）旗下之专业机构，公司专注于城市规划、旅游规划设计与商业综合体设计，构建了从规划设计、品牌营销、资本运作到管理咨询等全产品链集成一体化服务，提供从总体策划、建筑景观设计、资源引进、战略实施、平台搭建到运营管理等全程、专业化解决方案。</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br style=\"margin: 0px; padding: 0px; border: 0px;\"/>广州规划设计以“产业联动、搭建平台、金融孵化”为经营哲学，推动旅游业与民俗艺术、饮食、地产、绿色农业及金融业的融合发展，同时依托中欧国际旅游规划设计研究院的学术背景与国际资源，搭建行业交互平台，提供切合旅游企业需要的一揽子专业协同服务。<br style=\"margin: 0px; padding: 0px; border: 0px;\"/><br style=\"margin: 0px; padding: 0px; border: 0px;\"/>广州规划设计秉持“文化开发与生态保护相结合”的规划设计理念，切实将“因地制宜、以人为本、市场引导、经济可行、体验为怀、低碳环保”的精神贯穿于每一个项目之中，倡导空间与艺术相结合、经济与美学相融合、历史文明与现代时尚相调和，力求每个作品都能达到人文景观与大自然的和谐完美融合。<br style=\"margin: 0px; padding: 0px; border: 0px;\"/><br style=\"margin: 0px; padding: 0px; border: 0px;\"/>广州规划设计与国际行业组织、海内外同行及国内知名高等院校如香港大学、中山大学、同济大学、广东财经大学等建立和保持着密切的合作与互动关系，致力于整合行业高端智慧，引进行业优质资源，推动中国旅游业迈向更高的竞争层次。</p><p><br/></p>', 'h,', '关于我们', '/93\\130.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('131', '', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州规划设计在为客户提供市场分析和战略规划服务的基础上，确保初步规划和概念逐渐成形最终落地运营的产品。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">规划设计的业务范畴主要集中在旅游规划、城市规划、建筑设计与景观设计，构筑了策划、规划、设计、营销、资本引进与管理咨询等全程服务。同时，帮助客户了解市场行情、评估风险、厘清发展计划、商业战略和公共政策内在的不确定因素。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">规划设计在打造景区特色、建立生态系统、营造文化环境等多领域都有着不可撼动的行业地位，规划业务服务集中在总体规划、城市规划、区域规划、旅游商业模式策划、生态环境规划、城市战略规划等。根据项目的不同尺度和背景，有选择地搭配合适的各项专业人才团队，为客户提供全面而合理的解决方案</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br style=\"margin: 0px; padding: 0px; border: 0px;\"/>广州规划设计与国际行业组织、海内外同行及国内知名高等院校如香港大学、中山大学、同济大学、广东财经大学等建立和保持着密切的合作与互动关系，致力于整合行业高端智慧，引进行业优质资源，推动中国旅游业迈向更高的竞争层次。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><h1 style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; color: rgb(51, 51, 51); font-family: 微软雅黑; line-height: 25px; text-align: justify; white-space: normal;\">经营哲学：</h1><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">用智慧与资本描摹设计蓝图</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">中国旅游业已经跨入互联网时代的大门中，互联网正在彻底颠覆传统咨询业的知识架构和业务模式，CEDAR站在互联网大潮的浪尖上，以高瞻的视角描摹着旅游行业的发展蓝图。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp; &nbsp; &nbsp; ●&nbsp;产业联动</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">互联网时代正在颠覆旅游业传统的商业模式。CEDAR积极应对这种变革，依托中欧国际旅游规划设计研究院（SEATPD）的资源优势，推动文化、地产与旅游业的横向联合发展，以此延伸到移动互联、绿色农业、金融资本、现代物流业等产业领域。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp; &nbsp; &nbsp; ●&nbsp;搭建平台</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">互联网时代的行业生态系统也在发生着改变。以往单一、专业式的服务模式不再为客户所青睐，CEDAR创新构建协同式、交互式、大数据、系统服务式的行业平台，整合行业各专业领域的优势资源，基于共同的平台进行专业协作，为旅游业提供一揽子系统化的解决方案。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp; &nbsp; &nbsp; ●&nbsp;金融孵化</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">大平台的背后是高度的智慧与资源整合，更是金融资本的有效支撑。CEDAR协助旅游企业开发设计植入性产品，做好定制化产品的孵化，开展引资融资服务，帮助客户在产业版图拓展中淘金。同时，以规划设计为撬动点，通过小资本或技术入股，撬动大资本大产业。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/></p><h1 style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; color: rgb(51, 51, 51); font-family: 微软雅黑; line-height: 25px; text-align: justify; white-space: normal;\">服务能力：</h1><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp; &nbsp; &nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp; &nbsp; &nbsp;</p><h1 style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; color: rgb(51, 51, 51); font-family: 微软雅黑; line-height: 25px; text-align: justify; white-space: normal;\">产业咨询：</h1><p><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">CEDAR专家以宏观、战略、系统、科学、可操作性的视角，为客户提供产业整体发展咨询，服务涉及项目的前期市场研究、战略定位、产品开发、空间结构规划、区域规划、旅游品牌营销到景区的企业管理、企业文化、人力资源等全方位一揽子主导整合服务。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><strong style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">规划设计</strong><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">CEDAR规划设计包括旅游区及城市商业综合体的景观设计、建筑设计及环境文化设计。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">我们主张设计创新，试图对每一处场景赋予独一无二的精神，并合理地对景观建筑、规划资源进行配置与优化，加强景观、建筑与规划领域的互动，为客户提供从城市规划、建筑设计到景观设计的全程化、一体化、专业化解决方案。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><strong style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">品牌营销</strong><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp;CEDAR依托团队丰富的品牌管理与营销策划能力，为旅游品牌提供从市场研究、品牌形象策划、整合营销传播、公共关系到节事会展营销等整合系统服务。</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><strong style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">资本运作</strong><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">CEDAR不仅推动规划设计的科学前瞻，更愿意借助中欧国际旅游规划设计研究院（SEATPD）的国际背景、宽厚人脉及资源整合力，打造旅游企业的金融孵化平台，通过“咨询管理+ 资本运作”的模式，为旅游业发展引进资本、人才、管理体系、商业模式、企业文化、市场营销等综合支撑。</span></p><p><br/></p>', 'f,', '关于我们', '/93/94\\131.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('132', 'CORPORATE PART', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">全心全力，美善相随，</span><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">这个世代不缺技艺超群之才，</span><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">却匮乏尽心尽力之士，</span><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">CEDAR信实守约</span></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">捧着一颗心来，不带半根草去，竭力置身于客户的立场换位思考，除去一切不利于客户利益的自我私欲</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">精诚坦荡，肝胆相照，将自己的专业本色全意展现，为客户创造超值的服务体验 &nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br/></p>', 'h,', 'CORPORATE CULTURE', '/93/95\\132.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('216', '', '<p>锐诚PPT创始人，资深PPT设计师、培训师、品牌策划师，任全国知名地产公司高级策划师，大型教育集团品牌运营总监；创办锐诚PPT后，为中原演示设计领域带来全新标准，帮助数百家企业定制演示精品，让演示创造更多价值。精通各种高端PPT设计、 精通版式、配色、文字逻辑和动画，设计案例上百件。擅长在实战中为学员点拨，让学员快速提升美感，做出更漂亮的作品。</p><p><br/></p>', 'h,', '', '/115\\216.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('217', '', '<p>锐诚PPT特邀首席技术专家，连续五年荣获美国微软公司评出的全球最有价值专家奖（简称MVP），通过微软办公专家国际认证（简称MOS）。出版专业PPT书籍《PPT高效设计-5分钟完美打造PPT课件》，在历届网络PPT大赛中做评委。阿瑛老师从事PPT设及教学十余年，PPT公开课上千场，经验极其丰富，授课轻松风趣，让0基础的学员都可以快速提升技能，做出漂亮的PPT。</p>', 'p,', '', '/115\\217.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('133', '张三', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 13px; line-height: 25px; text-align: justify; color: rgb(134, 134, 134); font-family: &#39;Microsoft YaHei&#39;;\">广州规划设计，立足于互联网思潮下商业模式创新的宏大视野，以科学的规划设计为基点，以战略执行、资源导入、品牌营销、管理咨询为后续深度服务，联袂海内外卓越专业机构，构筑行业智慧高地，并搭建行业性交互式平台，推动旅游业持续稳健地发展。&nbsp;</span><br style=\"margin: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"/><br style=\"margin: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">战略学术联盟：</span></strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"><br/>&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(102, 102, 102); font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">战略设计联盟：</span></strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; color: rgb(134, 134, 134);\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">MORMANFOSTER</span><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span></strong></span><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">乐昂国际设计集团</span><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></span></strong></span></span><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">香港郑中设计师事务所</span><strong style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5;\"><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</strong></span></strong><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 1.5; font-size: 12px; font-family: &#39;Microsoft YaHei&#39;;\">中国建筑装饰集团</span></p><p>&nbsp;</p><p><br/></p>', 'p,', 'THE MEANING OF THE DESIGN IS TO SEEK HARMONY BETWEEN PEOPLEOTHER/, ARCHITECTUREOTHER/, NATURAL AND OF WISDOM', '/93/97\\133.html', '设计的意义在于寻求人、建筑、自然之间相融与相生的智慧', '0', '1');
INSERT INTO `cms_article` VALUES ('134', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-family: Arial, 宋体, SimSun, HELVETICA, &#39;Hiragino Sans GB&#39;; font-size: 14px; line-height: 26px; text-indent: 28px;\">2009年12月13日由中国民族建筑研究会与中国</span>房地产<span style=\"margin: 0px; padding: 0px; border: 0px; font-family: Arial, 宋体, SimSun, HELVETICA, &#39;Hiragino Sans GB&#39;; font-size: 14px; line-height: 26px; text-indent: 28px;\">及住宅研究会共同主办，“2009•第六届中国人居典范建筑规划设计方案竞赛”颁奖大会在北京•京都信苑饭店隆重召开。经过九个多月来的精心组织与评选，全国共有241个方案获奖。通过本届竞赛，在全国建设领域树立一批人居规划设计典范，对促进全国建筑规划设计和建设水平的提高起到示范推动作用。</span></p><p><br/></p>', '', '关于我们', '/93/96\\134.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('135', '', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); text-align: justify; font-family: Arial, 宋体, SimSun, HELVETICA, &#39;Hiragino Sans GB&#39;; font-size: 14px; line-height: 26px; text-indent: 28px;\">2009年12月13日由中国民族建筑研究会与中国</span><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">房地产</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); text-align: justify; font-family: Arial, 宋体, SimSun, HELVETICA, &#39;Hiragino Sans GB&#39;; font-size: 14px; line-height: 26px; text-indent: 28px;\">及住宅研究会共同主办，“2009•第六届中国人居典范建筑规划设计方案竞赛”颁奖大会在北京•京都信苑饭店隆重召开。经过九个多月来的精心组织与评选，全国共有241个方案获奖。通过本届竞赛，在全国建设领域树立一批人居规划设计典范，对促进全国建筑规划设计和建设水平的提高起到示范推动作用。</span></p>', 'h,', '关于我们', '/93/96\\135.html', '最佳设计方案', '0', '1');
INSERT INTO `cms_article` VALUES ('136', '1', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州规划设计以金融资本为支撑，以规划设计为撬动点，协助旅游业开发高潜力项目，推动项目融资，帮助客户在产业版图拓展中淘金入市。</span></p>', '', '关于我们', '/93/98\\136.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('137', '', null, '', '', '/100\\137.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('138', '', null, '', '', '/100\\138.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('139', '', null, 'f,', '', '/100\\139.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('140', '', null, '', '首页幻灯', '/100\\140.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('141', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: left; white-space: normal;\"><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;城市商业综合体规划&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;新城（新区）规划&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;温城市更新与旧城改造</span><br style=\"margin: 0px; padding: 0px; border: 0px;\"/><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;小城镇建设规划&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;历史文化名城/镇保护研究与规划&nbsp;</span><span style=\"margin: 0px; padding: 0px; border: 0px;\">-&nbsp;产业园区规划</span></p><p style=\"text-align: left;\"><span style=\"margin: 0px; padding: 0px; border: 0px;\"><br/></span></p><p style=\"text-align: center;\"><br/></p>', '', '专业服务', '/99/101\\141.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('142', '', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">CEDAR以美学与生态的双重视野开展环境艺术的探索与实践，营造健康、高雅、舒适、美观的现代生态环境，以此提升城市及旅游景区的软环境。</span></p>', 'c,', '专业服务', '/99/102\\142.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('143', '', '<p>在把握好旅游地的地脉（地理根据）、文脉（文化根据）和商脉（市场根据）的基础上，为旅游地做好旅游形象定位，并开展理念基础（MI）、行为准则（BI）、视觉形象（VI）的系统策...</p>', 'p,', '专业服务', '/99/103\\143.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('144', '', '<p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 24px;text-indent: 2em\">目的地与景区管理：</p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 24px;text-indent: 2em\"><span style=\"line-height: 27px; text-indent: 2em;\">-&nbsp;发展战略规划</span><span style=\"line-height: 27px; text-indent: 2em;\">-&nbsp;营销管理体系咨询</span><span style=\"line-height: 27px; text-indent: 2em;\">-&nbsp;品牌管理体系咨询</span></p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 27px;text-indent: 2em\">-&nbsp;组织架构与流程再造<span style=\"text-indent: 2em;\">-&nbsp;投资运营与管理</span><span style=\"text-indent: 2em;\">-&nbsp;资源与环境保护</span></p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 27px;text-indent: 2em\">&nbsp;</p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 24px;text-indent: 2em\"><span style=\";padding: 0px;border: 0px;line-height: 25px;text-indent: 28px\">酒店管理：</span></p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 27px;text-indent: 2em\">-&nbsp;酒店运营管理<span style=\"text-indent: 2em;\">-&nbsp;酒店物业管理</span><span style=\"text-indent: 2em;\">-&nbsp;酒店产品与服务管理</span></p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 27px;text-indent: 2em\">-&nbsp;酒店人力资源管理<span style=\"text-indent: 2em;\">-&nbsp;酒店投资与财务管理</span><span style=\"text-indent: 2em;\">-&nbsp;酒店危机管理</span></p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 24px;text-indent: 2em\">&nbsp;</p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 24px;text-indent: 2em\">住宿业管理：&nbsp;&nbsp;</p><p style=\"margin-top: 0;margin-bottom: 0;padding: 0px;border: 0px;font-family: 微软雅黑;text-align: justify;white-space: normal;color: rgb(178, 178, 178);font-size: 14px;line-height: 27px;text-indent: 2em\">为酒楼、茶楼、旅馆、非星级宾馆等住宿接待业提供经营管理咨询服务。</p><p><br/></p>', 'h,', '专业服务', '/99/104\\144.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('145', '', '<p><span style=\"color: rgb(178, 178, 178); font-family: 微软雅黑; font-size: 14px; line-height: 24px; text-align: justify;\">为旅游企业引进投资机构，代理或协助开展融资商务谈判，推动融资项目签约。</span></p>', '', '专业服务', '/99/105\\145.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('146', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">项目地址：广东梅州市雁洋镇 规划面积：1，281，863平方米 项目委托：广东梅州市人民政府</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">全世界客家人的首都，客家文化的遗产中心</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">雁洋的自然环境、人文历史以及作为世界自然度假胜地门户的地理位置，与梅州市的城市特色和资源形成互补，为当地居民及国内外游客提供一种轻松的绿色体验。我们试图通过推广建筑、农业、文化资源的保护，把现有的文化基础设施开发成为世界级别的旅游胜地。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/13015313Q-0.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1301531A9-1.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1301531L5-2.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1301531937-3.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p><br/></p>', '', '来自火星的程序猿', '/106/107\\146.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('147', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">项目地址：海南省海口市北部海口湾西部滨海地区</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">总用地面积：47957.1平方米</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">总建筑面积：116154.65平方米</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">总地上建筑面积：94523.55平方米</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">总地下建筑面积：21631.1平方米</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">委托单位：某地产集团海南公司&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">海口湾时尚度假新平台</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">设计定位：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">功能定位-----&nbsp;提供度假体验的产权式酒店，并引入购物、娱乐、餐饮等多元复合功能；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">形象定位-----&nbsp;海口城市形象的名片，塑造融入城市环境的建筑形象，与滨海景观相协调。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">设计策略：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">区域融合与区域发展融为一体；功能复合，丰富海口湾岸线景观。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">建筑设计策略：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">商业集中布局；景观视线保障；建筑退台设计；绿色节能规划。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152SJ546-0.png\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152SKH7-1.png\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152SL340-2.png\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152SK302-3.png\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p><br/></p>', 'h,', '来自火星的程序猿', '/106/108\\147.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('148', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">周庄拥有丰富的自然资源、人文资源及极具优势的地理位置，区域发展潜力巨大，古镇旅游品牌价值大，区域发展热点已经形成，旅游经济的发展为房地产市场提供了巨大的想象空间。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">我们的项目研判与理解：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">-&nbsp;天生丽质，但区域发展态势不明朗；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">-&nbsp;以前瞻性的眼光，组合运营多元化地产运营模式，与周边项目形成错位，整合旅游、休闲、度假、商务、商业与投资资源，方可突出重围。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">项目总体概念定位：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">液体周庄-------&nbsp;未来水乡</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“未来水乡概念”·&nbsp;复合型旅游休闲港湾&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">功能定位：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">复合型旅游休闲港湾&nbsp;-------</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">集中于“休闲”功能，满足“在家度假”的生活梦想。以“液态生活”为主题，用原生态的景观，再现原汁原味的水乡生活。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">水乡生活体验基地&nbsp;---&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">其功能主要集中在“体验”上，营造休闲的氛围，形成与都市截然不同的氛围，创造一种江南文化的现代体验。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">商业空间规划：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">&nbsp;</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152I12344-0.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/152I16160-1.jpg\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">由沿路商街和船概念水街构成&nbsp;</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">沿路商街的主题：渔人码头</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 主要经营特色餐饮、新派江南菜；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 手工艺品，生活气息浓郁为特色；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 江南古董店。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">船概念水街的主题：在水一坊</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 茶坊、咖啡店；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 鱼、蟹、虾等特色水产品；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">- 菱角等水产植物。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><ul style=\"list-style-type: none;\" class=\" list-paddingleft-2\"><li><p><strong style=\"margin: 0px; padding: 0px; border: 0px;\">项目推广：</strong></p></li></ul><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">总体定位&nbsp;-------&nbsp;品质派旅游地产商</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">Slogan：江南液上海，休闲水乡情</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br/></p>', '', '来自火星的程序猿', '/106/109\\148.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('149', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">项目地址：浙江杭州、苏州</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">项目委托：杭州市旅游局、苏州市旅游局</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">运河文化，吴地风情</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">在现代旅游业的发展当中，旅游形象设计正在发挥着越来越重要的作用。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">旅游形象设计能使旅游地政府和公众对本地旅游的资源核心、产品定位和发展目标有更清楚地认识，使旅游地在众多的同类产品中以鲜明的姿态出现在旅游者面前。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">本次苏杭大运河旅游形象策划，我们是在大运河杭州、苏州段旅游市场和旅游资源分析的基础上，结合对规划区域地方性的研究和受众特征的调查分析，提出了明确的区域旅游形象的核心理念和外在界面。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">地方性研究：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">前期我们开展地方性研究、受众调查和分析、形象替代性分析等，同时，主要讨论和创建旅游形象的具体表达，如理念、传播口号、视觉符号等。对京杭段古运河旅游形象构成的背景要素、地方性特征要素、形象修正要素进行了详细的分析，并对游客认知特征进行了调查研究，为进一步旅游形象设计奠定了基础。后面主要根据前期研究成果，创建旅游形象的具体表达体系。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">策划思路：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">古运河旅游形象的设计采用“用形象口号作为形象定位的精辟表达”的方法。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">主要有两种设计思路：</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">第一，采取资源导向型旅游形象口号的设计模式，或者运用白描、比喻、夸张等表现手法自我阐释自己的资源优势，或者采用领先、比附、衬托等表现手法比较阐释自己的资源优势；</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">第二，采取游客导向型旅游形象口号的设计模式，或者运用感情、借势、公关、悬念等表现手段来刺激旅游需求，或者运用距离、时间、心理、承诺等表现手段来克服潜在旅游者的出游阻力&nbsp;。&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\">整体形象定位：</strong></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“清名运河图，江南绝版地”&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">运河形象体系构建：&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">1、品牌标识系统设计；&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">2、宣传口号提炼；&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">3、品牌音乐符号：&nbsp;&nbsp;以运河音为体，创作出适合各种乐器弹奏的曲目，并请知名词作家为之谱词。&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">4、吴地运河宣传片、专题片、微电影整体策划拍摄制作。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br/></p>', 'h,', '来自火星的程序猿', '/106/110\\149.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('150', 'MS', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1530011938-0.jpg\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/>&nbsp;<img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/15300121b-1.jpg\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/15300154Q-2.jpg\" width=\"45%\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/></p><p><br/></p>', 'f,', '来自火星的程序猿', '/106/111\\150.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('151', '', '<p><span style=\"font-family: 宋体; font-size: 14px; line-height: 25px; text-align: justify; text-indent: 26px;\">北京师范大学教授、画家、艺术评论家，中国文物学会书画雕塑专业委员会会长，《艺术》杂志社社长、总编，艺术市场经济学创建者，中国艺术科技研究所艺术品鉴定评估中心专家，中欧国际旅游规划设计研究院高级顾问</span></p>', '', '专家智囊', '/112/113\\151.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('152', '', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; line-height: 25px; text-align: justify; text-indent: 26px; font-family: 宋体; font-size: 10.5pt;\">章明</span><span style=\"margin: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; line-height: 25px; text-align: justify; text-indent: 26px; font-size: 10.5pt;\">，同济大学建筑与城市规划学院建筑系副主任、教授、博导，国家一级注册建筑师，中欧旅游规划设计研究院研究员、首席建筑设计师。</span></p>', '', '专家智囊', '/112/114\\152.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('212', '', '<ol class=\"list-ol list-paddingleft-2\" style=\"list-style-type: square;\"><li><p>创造价值，提供优质的产品和服务，赢得用户的喜爱和尊敬。</p></li><li><p>利益均沾，让公司的每一成员都获得满意的回报。</p></li><li><p>合作共赢，与合作伙伴共同成长，赢得行业尊敬。</p></li><li><p>注重企业责任，关爱社会、回馈社会，赢得社会尊敬。</p></li></ol><p><br/></p>', 'h,', '', '/93/95\\212.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('155', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">近日，民盟湖南省委办公室主任傅小松来穗，兴致勃勃地参观和考察了中欧旅游规划设计研究院。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">我院董事副总裁李君遐先生向傅主任一行详细介绍了中欧研究院的发展历史、研究成果、独特理念及服务模式，以及中欧研究院未来五年在中国市场的发展愿景。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">傅小松主任对我院将欧洲思想与中国智慧积极融合服务国内市场的做法表示出极大的兴趣，并充分肯定了我院在产学研发展模式上的创新与积极探索，并对我院“中国智慧，欧洲思想”的经营哲学给予了高度的评价。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">傅小松先生是中国楹联学会《楹联天地》杂志副主编、中国楹联教育联谊会副秘书长、中国毛泽东诗词研究会会员、湖南省作家协会会员、湖南省科普作家协会会员、湖南省楹联学会常务理事。在旅游文化研究方面，傅小松先生也颇有兴趣与成绩。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">恒大地产集团董事副总裁彭建军先生全程陪同傅小松主任参观考察。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"></p><p><br/></p>', '', '新闻中心', '/120/121\\155.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('156', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">高性价比的旅游专列</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">旅游专列，是旅行社委派专业人员制定旅游线路、行程及旅游计划，向铁路主管专列审批部门申请车次，满足游客特殊需求和要求的旅游方式。专列旅游可以一线多游，集自行游、经典游为一体，被称为当下最绿色、最低碳、最享受的旅游方式。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">据旅游业内人士分析，专列游产品经过20多年的发展，曾经走过一段从高潮到低谷的曲折道路，近三年来又逐步红火起来的。“旅游专列的迅速发展，一方面是国家 政策的大力支持，另外一方面是迎合了市场的需求。还有就是价格的吸引力。如同样景点的行程线路，飞机团价格至少是专列团的2倍以上。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">中国铁道旅行社集团是这场“专列游”热潮中的排头兵，其经营旅游专列已经有20多年。据中国铁道旅行社集团副总经理于淑华介绍：“旅游专列以组团人数多、价 格经济实惠、时间利用最优（夜行昼游）等特点，得到了旅游团队的普遍认同，并成为中国铁道旅行社集团为广大游客精心烹制的一道‘招牌菜’。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">据笔者调查，旅游专列能获得比较优惠的车票价格，因此在线路价格上要比普通火车团更低。如宁夏空调专列7日游最低3660元/人，齐齐哈尔—五大连池—满洲 里专列10日游最低4380元/人，阿尔山专列6日游3080元/人，云台山4日游仅960元/人。也正是基于以上优势，许多时间相对充裕的市民和一些老 年游客，更加青睐乘坐专列出游。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">中国铁道旅行社集团综合部负责人邢海涛对笔者说：“与乘坐普通列车出行的旅游团队相比，管理旅游专列的游客要省心很多，旅游专列整列火车都是游客，可以统一行动，便于管理。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">中老年人看好旅游专列</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">记者走访北京数家旅行社发现，火车“慢游”受到中老年人等时间充裕群体的追捧。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">邢海涛表示，中老年人在时间上比较充裕，不受法定假期的限制，同时他们又比较喜欢慢节奏的出游方式，因此选择长线旅游专列的人会很多。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">“近年来，随着中老年出游需求的释放，旅游淡季也不再‘淡’。旅行社针对中老年人的特点推出专列游行程，线路长、游玩景点多、价格还便宜，最适合中老年人这一群体了。”中国铁道旅行社集团副总经理于淑华表示，专列游产品收客情况良好。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">“坐飞机速度更快，但考虑到价格等因素，我们还是选择火车。乘火车旅游，是另一种体验。”已经退休的一位老年人提到，“火车一路行驶，其实本身就是一个难忘的旅程。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">“孩子们极力劝我们去，说旅行社的专列线路玩得舒服还不累，而且价格不贵。”北京游客马先生夫妇告诉笔者。当下，孩子们表达孝心的方式已经不再局限于送吃送喝，送老人去旅游，感受不曾有过的生活已经成为一种孝敬老年人的新时尚。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">正在为父母咨询专列线路的李先生直言：“和别的旅游团比，这种专列旅游虽然时间长，但不会很劳累，队友们的年龄也都相近，还有队医和导游照顾着，我觉得更放心些。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">据了解，截至目前选择旅游专列的游客人数与去年同期相比有增长态势。笔者从中国铁道旅行社集团了解到，目前从北京出发，去往港、澳、台湾等地的长线旅游专列产品非常受中老年游客的青睐。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">列车旅游的一次革命</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">据了解，目前，旅游专列市场鱼龙混杂，部分旅行社做一些低价专列团，游客体验并不理想。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">另外，旅游专列在运行过程中还面临着各种各样的问题。据业内相关人士分析：“我国铁路运力不足现状也影响了旅游专列的发展，导致旅游专列运行速度无法满足现代游客‘快行慢游’需求。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">邢海涛向笔者透露：“专列需要事先与铁路专列主管审批部门进行协调，提前多天上报主管部门由其规定确定计划，大规模的出团，在协调上困难较大，环节较多。”旅游专列还面临着一个问题是，由于旅游专列是非常规开行，它要为按常规运行的列车让道。由此一来，会导致错车、让车等临时性停车，而且停车时间往往会比常 规列车长一些。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">为此，旅游专列下一站的出口在哪里，是当下值得思考的命题。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">邢海涛告诉笔者，为探索旅游专列发展的新思路，中国铁道旅行社集团做出了很大努力。首先，中国铁道旅行社集团旗下的旅游专列摒弃了传统的绿皮车，首次采用了 德国的小包车、空调软卧车、新型国际空调车三种不同档次的列车以满足不同旅客漫长旅程的需求。其次，旅游专列在一些细节安排上，会更注重游客体验，比如安 排入住特色民居、体验旅游目的地的特色美食等。另外，可根据游客的需要，量身定制旅游线路。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">采用新型列车车体作为旅游专列的载客专列，这也是未来旅游专列发展的方向之一。据了解，目前，部分旅游专列正在尝试在列车上安装3D放映设备，力争使游客实现“看着大片，吃着火锅就到达目的地”。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">经过多年的运行，中国铁道旅行社集团在旅游专列方面，具有领头军的位置，于淑华告诉笔者，他们一直致力于努力提高自身硬件和服务水平，已经在旅游列车上配置 了WIFI，契合受众对网络的需求，通过列车WIFI，游客可以随时查看沿途风光的介绍、旅游常识的介绍、自身品质的介绍以及看电影等。于淑华还表示，未 来要在确保车辆性能良好，卧具整洁舒适，保证冷热水供应等方面做好表率。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\">据了解，今年年初，为进一步促进旅游专列市场有序发展，中铁旅成立了旅游专列管理委员会，负责对北京铁路局管内所有申报的专列计划进行统一指导、审核与协调，这对于旅游专列的规范化发展将起到积极作用。</p><p><br/></p>', '', '新闻中心', '/120/123\\156.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('157', 'MS', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;区域旅游发展规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;历史文化区旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;风景名胜区旅游开发规划</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;生态旅游区开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;温泉滨海度假区旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;旅游地产开发规划</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;乡村旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;主题公园开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;城市旅游开发规划</span></p>', '', '来自火星的程序猿', '/106/107\\157.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('158', '', '<p><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;区域旅游发展规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;历史文化区旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;风景名胜区旅游开发规划</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;生态旅游区开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;温泉滨海度假区旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;旅游地产开发规划</span><br style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"/><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;乡村旅游开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;主题公园开发规划</span><span style=\"margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">-&nbsp;城市旅游开发规划</span></p>', 'f,', '专业服务', '/99/101\\158.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('192', '铭飞', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑, Arial; line-height: 34px; background-color: rgb(255, 255, 255);\">对于时尚达人而言，包袋与衣服的混搭也是一种必杀技。休闲手提包可以搭配不同的造型，而搭配运动裤就是更加直接地表现出时尚休闲风的最佳配搭方案。 宽松舒适的运动裤相信是不少男士最爱，但却很难搭出时尚感，更一不小心就给人过于随便的印象。而手提包在款式、颜色、材质及图案方面层出不穷，再搭配不同款式的运动裤，打造半运动化的时装搭配，让运动休闲和时尚文化完美结合，塑造出运动感的摩登简约风，让整体穿着随意且舒适。</span></p>', 'p,', '铭飞', '/62/84\\192.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('159', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">2014年5月22日，为对安徽舒城万佛湖景区中的三江景区开展概念性规划，中欧研究院专家组深入万佛湖地区开展实地考察调研。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1513252352-0.png\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\">图1：万佛湖国际森林体育公园项目实地考察</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1513253207-1.png\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\">图2：中欧研究院专家组与舒城县部分领导合影</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1513253M1-2.png\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\">图3：中欧研究院专家组成员乘船游万佛湖前留影纪念（左：李君遐；右：秦学）</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\"><img alt=\"\" src=\"http://m286.dedemao.net/uploads/allimg/151112/1513255S8-3.png\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\">图4：中欧研究院专家组成员乘船游万佛湖前留影纪念（张明明）</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br/></p>', '', '', '/124/126\\159.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('160', '', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">近日，中国十大古城镇联盟在山东淄博周村古商城景区成立，周庄、南浔、周村、阆中、呈坎、平遥、襄阳、同里、西塘、洪江等十大古城镇聚首，针对古建筑保护修复、古城镇管理体制创新、古城镇旅游发展方向等方面的问题进行了深入交流探讨，并最终发布八条联盟宣言。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">宣言就古城镇旅游保护开发过程中自觉依法保护历史文化遗产，杜绝“拆真名城、建假古董”的现象，注重保护古城镇的原生态生活和原住民利益等进行了阐述。在这些方面，周村古商城积累了不少经验。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 14px;\">老建筑能不动就不动</span></strong></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\"></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">周村古商城位于山东淄博周村区，现有保存完好的明清古建筑5万余平方米，且仍在发挥其商业功能，被中国古建筑保护委员会的专家誉为“中国活着的古商业建筑博物馆群”。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“有些开发商热衷于复建古镇，为什么要把真的历史遗存拆掉再建假的呢，总觉得不对劲，那种文化不是内生的，而是外加的。”周村区旅游局局长尚志胜说，老辈子留下来的物质文化遗产和非物质文化遗产越来越少了，有责任保护好，“能保留就保留，能不动就不动。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">据了解，现在的周村古商城规模只是明清时期的百分之一，大部分毁于抗日战争年代，剩下的部分曾经规划拆掉，但是因为缺乏资金而没有动工，保留了下来。从2001年到周村古商城，尚志胜已经在这里工作了十三年，对老建筑一直坚持“能不动就不动”的理念。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">周村对老建筑的修复也坚持保留原味。“老建筑每过十几年就要修一次，不准修也是不行的，容易塌掉，但在维护过程中，要是把一些木结构的部件换成混凝土的，就 失去了原有的味道。几十年没动的老房子不漏，有的一修，过一两年就漏雨，因为没有使用传统的工艺。”曾经在建设部门工作过的尚志胜介绍，以前要用水将石灰 块化开，在池里蓄积石灰浆，这石灰浆没有杂质，而现在是用机器将石灰磨碎，里面就会有很多杂质，石灰凝固后，内部就会有很多缝隙，导致渗漏。以前的古街 上，青石板应该是纵向铺砌的，而不是横向的，因为纵向是车轮碾压的方向，石板可以承重，横向铺砌，石板的受力面小，容易被碾碎。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“现在要维修，都是从外地收旧石材、旧的砖和旧木头，再请曲阜、临朐等地的专业队伍，也会用现代的材料，像水泥，也比过去的灰好用得多，不过要想办法做旧，这方面周村有成熟的经验。”尚志胜说。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">有些过去很好的房子，像四合院，因历史变迁被拆，或有人搭建了风格不协调的建筑。为了恢复原有的肌理，周村会将其拆掉，再根据老人的回忆和历史资料，使用旧 材料和旧工艺，尽量复原。据了解，周村古商城是省级文物保护单位，当地政府在拆建过程中都会严格执行相关规定。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“周村和洪江都是因商而兴的古商城，周村的古城保护做得更好些，古建筑很周正，体现了鲁商的人文特点。”洪江古商城总经理文奇在接受采访时表示。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 14px;\">要游客更要有生气</span></strong></p><p><img alt=\"\" height=\"338\" src=\"http://m286.dedemao.net/uploads/allimg/151112/15121M601-1.jpg\" title=\"\" width=\"450\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“有些地方古镇开发，把原住民全部迁出去，建仿古的，只有游客，没有生气。”尚志胜说，古城镇要保持适当的容量，要考虑怎么让原住民生活，“毕竟他们的生活条件不舒适，没有暖气、天然气，也没有公厕，木质门窗，也不像铝制门窗那样密封。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">13年前，周村古商城里住了1600多户，密密麻麻的，一个小院就挤下十几户，周村把一部分居民搬迁出去，由当地政府为居民租房子或者买房子，同时，适当地留一部分居民在古城继续生活，政府改造自来水、网络、公厕等基础设施，改善居民生活条件。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“让居民也成为景区的重要组成部分，现在古城里的居民有三四百户，经商和居住的各占一半，”尚志胜说。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">瑞蚨祥是响当当的字号，新中国成立后里面一直被经营成饭馆，周村政府出资租过来，恢复瑞蚨祥的布局，并且卖回丝绸制品。有些老房子居民没钱修，又不卖，由政 府租赁，出资维修后，再对外出租，投资收益归政府。“好多户都是这样的，强拆不行，这是一种和谐的方式。”尚志胜告诉笔者。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">今年87岁的解玉兰老人在周村古商城这条街道上工作生活了40多年了。做了一辈子煮锅的解玉兰在退休后又在古商城里面开了一家属于自己的“丁家煮锅”。老人对 古商城的变化很是感慨，她说当年的街道是电线交叉乱接，旱厕林立，很多老旧的古建筑年久失修，随时都有可能倒塌，一到夏天，街道上污水横流，十几家人拥挤在一条小巷里，苦不堪言。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">现在政府不仅把她们居住的老建筑修缮了，还上了相应的配套设施，和解玉兰老人一样的原住居民都借着打造旅游景区的机会做起了旅游配套的小生意，解玉兰经营的“丁家煮锅”也成了古商城内代表周村美食的一块金字招牌。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">如今，年事已高的解玉兰将煮锅店交给儿子来打理，身体依然矍铄的她坚持着每天来店里帮忙，算账、收款丝毫不含糊，有游客问起煮锅的来历，老人还会热情地讲述那段不被人熟知的往事，游客听得津津有味，老人也乐在其中。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">&nbsp;</p><p style=\"text-align:left;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal; text-indent: 2em;\"><strong style=\"margin: 0px; padding: 0px; border: 0px;\"><span style=\"margin: 0px; padding: 0px; border: 0px; font-size: 14px;\">深挖历史文化发展休闲</span></strong></p><p style=\"text-align:center;margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; white-space: normal;\"><img alt=\"\" height=\"297\" src=\"http://m286.dedemao.net/uploads/allimg/151112/15121LP2-2.jpg\" title=\"\" width=\"450\" style=\"margin: 0px; padding: 0px; border: 0px; vertical-align: top;\"/></p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">在周村的老街上，笔者看到一处复古的建筑即将竣工。尚志胜介绍，这是一处铜响乐器博物馆，“鲁东牌乐器，过去非常有名，民国四大名旦用的锣、磬都是这个厂生产的，第一颗卫星播放的《东方红》演奏时所用的编钟也是这里生产的。这个厂已不存在了，现在通过博物馆把这个挖掘出来，再把产品做起来。”</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">此外，周村还计划建设福王红木艺术馆，王村醋博物馆，“要拉动地方经济的发展，得把周村的食品，甚至工业产品变成旅游商品。”尚志胜说。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">经多年抢救性恢复，周村目前已形成了千佛寺庙群、三益堂印刷展馆、谦祥益、瑞蚨祥、民俗展览馆、英美烟草公司展览馆、今日无税碑、状元府、票号展览馆、杨家 大院、大染坊、魁星阁庙群、淄博艺术博物馆等10多处具有较强的知识性和趣味性的景点。周村烧饼博物馆是非常吸引人的地方，在这里，游客不仅可以了解烧饼 的历史、制作工具、过程，还可以品尝刚出炉香喷喷的烧饼。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">在古街上，周末可见抬花轿的、卖糖葫芦的、拉人力车的，重要的节日，还有周村芯子、花灯、周村婚礼、鸣锣开市、五音戏等表演。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">“古城镇的开发应该注重对历史文化的研究，古城镇在形成过程中必然有自己的原因，会积淀自己的文化特色，要挖掘出来，让游客去感受、体验，不能千篇一律，”尚志胜表示，过去都是观光游，下一步是休闲旅游，让游客在一个地方住两三天，体验文化与生活方式。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal; text-indent: 2em;\">目前，周村古商城在调整经营业态，计划引入十几家小吃、特色餐饮、茶楼、书吧、民宿、咖啡、酒吧等，“让游客坐下来，”尚志胜说。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify; white-space: normal;\"><br/></p><p><br/></p>', '', '热门专题', '/128/129\\160.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('189', '', '<p><span style=\"font-family: 微软雅黑; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\">&nbsp; ●&nbsp;搭建平台</span><br style=\"font-family: 微软雅黑; white-space: normal; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\"/><span style=\"font-family: 微软雅黑; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\">互联网时代的行业生态系统也在发生着改变。以往单一、专业式的服务模式不再为客户所青睐，CEDAR创新构建协同式、交互式、大数据、系统服务式的行业平台，整合行业各专业领域的优势资源，基于共同的平台进行专业协作，为旅游业提供一揽子系统化的解决方案。</span><br style=\"font-family: 微软雅黑; white-space: normal; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\"/><span style=\"font-family: 微软雅黑; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\">&nbsp; &nbsp; &nbsp; ●&nbsp;金融孵化</span><br style=\"font-family: 微软雅黑; white-space: normal; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\"/><span style=\"font-family: 微软雅黑; margin: 0px; padding: 0px; border: 0px; color: rgb(51, 51, 51); font-size: 13px; line-height: 25px; text-align: justify; background-color: rgb(255, 255, 255);\">大平台的背后是高度的智慧与资源整合，更是金融资本的有效支撑。CEDAR协助旅游企业开发设计植入性产品，做好定制化产品的孵化，开展引资融资服务，帮助客户在产业版图拓展中淘金。同时，以规划设计为撬动点，通过小资本或技术入股，撬动大资本大</span></p>', '', '', '/128/130\\189.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('161', '', null, '', '', '/124/127\\161.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('162', '', null, '', '联系我们', '/124/127\\162.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('163', '', '<p><span style=\"color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; line-height: 24px; background-color: rgb(255, 255, 255);\">凭借专业的网站策划队伍、专业的美工设计师、一流的程序开发人员，丰富的制作经验和高超的创意水平，根据您的企业的行业类型和产品特点度身定制品 牌网站。精益求精的网页制作人员、严谨的应用程序开发人员、尽善尽美的售后服务人员。这一切，是我们为您提供专业网站建设服务，也是让你在同行业中傲视群 雄</span></p>', 'f,', '', '/99\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('164', '2', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州规划设计麾下聚集了众多从美国旧金山艺术大学、奥本大学、香港理工大学毕业的海派旅游规划与建筑、景观设计高端人才，其国际化视野和开放创新的风格，将确保香柏领先的、卓越的规划设计水平和创造超出客户预期的服务效果。</span></p>', '', '', '/93/98\\164.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('165', '3', '<p><span style=\"color: rgb(51, 51, 51); font-family: 微软雅黑; font-size: 13px; line-height: 25px; text-align: justify;\">广州规划设计创新构建协同式、交互式、大数据及系统式行业服务平台，整合企业管理、金融、互联网、媒介各领域专业资源，为旅游行业提供一揽子系统化解决方</span></p>', 'c,', '', '/93/98\\165.html', '高质量行业交互平台', '0', '1');
INSERT INTO `cms_article` VALUES ('170', '22222', '<p><span style=\"padding: 0px; margin: 0px; list-style-type: none; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, 微软雅黑, &#39;Microsoft JhengHei&#39;, 宋体, Verdana, Arial, Tahoma; font-size: 11px; line-height: 24px;\"><span style=\"padding: 0px; margin: 0px; list-style-type: none; color: rgb(105, 105, 105);\"><strong style=\"padding: 0px; margin: 0px; list-style-type: none;\"><span style=\"padding: 0px; margin: 0px; list-style-type: none; font-family: tahoma, geneva, sans-serif;\">电 话：123456789</span><br style=\"padding: 0px; margin: 0px; list-style-type: none;\"/><span style=\"padding: 0px; margin: 0px; list-style-type: none; font-family: tahoma, geneva, sans-serif;\">地 址：银河系 地球<br style=\"padding: 0px; margin: 0px; list-style-type: none;\"/>微 信：123456789</span></strong></span><br style=\"padding: 0px; margin: 0px; list-style-type: none;\"/><span style=\"padding: 0px; margin: 0px; list-style-type: none; font-family: tahoma, geneva, sans-serif;\"><strong style=\"padding: 0px; margin: 0px; list-style-type: none;\"><span style=\"padding: 0px; margin: 0px; list-style-type: none; color: rgb(105, 105, 105);\">Q&nbsp;&nbsp; Q：12345678<br style=\"padding: 0px; margin: 0px; list-style-type: none;\"/>E-mail：</span></strong></span></span><br style=\"white-space: normal; padding: 0px; margin: 0px; list-style-type: none; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, 微软雅黑, &#39;Microsoft JhengHei&#39;, 宋体, Verdana, Arial, Tahoma; font-size: 12px; line-height: 24px;\"/><br style=\"white-space: normal; padding: 0px; margin: 0px; list-style-type: none; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, 微软雅黑, &#39;Microsoft JhengHei&#39;, 宋体, Verdana, Arial, Tahoma; font-size: 12px; line-height: 24px;\"/><br/></p>', '', '1111', '/56/131\\170.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('180', '', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS(http://ms.mingsoft.net)是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过三年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; text-indent: 28px; background-color: rgb(255, 255, 255);\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能</span></p><p><br/></p>', '', '', '/35\\180.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('181', '2222', '<h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\">铭飞MCMS内容管理系统完整开源版J2EE代码</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">当前版本:5.4.2 铭飞MS官网:http://ms.mingsoft.net官网同时提供一键运行版本下载，请步移官网....</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_2\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#特点\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>特点</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">免费开源:纯Java开发，MS开发团队承诺将MCMS内容系统永久完整开源;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">终端统一: 铭飞MCMS支持PC与MOBILE皮肤定制,同时使用MS团队移动JS插件,轻松实现手机多屏幕适配,想想看你发布的信息第一时间在PC上展示又能在手机上展示,这是件多么幸福的事情,数据统一、平台统一、终端统一是MS团队一直在努力的方向;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">扩展性:以铭飞MCMS为核心,MS官网提供第三方插件安装,最新的插件用户可以通过更新功能获得,同时MS也鼓励并支持第三方开发人员发布优质的插件;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">更新升级: 铭飞MCMS提供了行业内最完美的升级方案,从此升级无需手动下载复制粘贴,一切完全由MS升级插件无缝完成;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">文档手册:铭飞不断向外部公布最新文档，如二次开发手册、标签使用手册,减轻用户学习成本;</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">站群：MCMS支持站群，只需在服务器上架设一套铭飞MCMS就可以创建多个个网站，并且网站之间的数据是独立存在，很大程度降低了维护成本，与服务器资源的开销；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">其他：html静态生成、标签式建站</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">技术支持:提永久升级服务技术交流群,不定期会升级系统，开发可以关注后台的更新板块；</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_3\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#面向对象\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>面向对象</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MCMS是企业在创立初期很好的技术基础框架，加快公司项目开发进度，当然也可以对现有的系统进行升级；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">个人开发者也可以使用MCMS承接外包项目；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">初学JAVA的同学可以下载源代码来进行学习交流；</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_4\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#开发框及语言\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>开发框及语言</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MCMS(铭飞内容管理系统)是一款支持不同平台、不同终端并且支持多站点的内容管理系统，</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· SpringMVC4+Spring4+MyBatis3+Freemarker技术架构</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 基于java技术开发，继承其强大、稳定、安全、高效、跨平台等多方面的优点；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 标签化建站，只要你懂html就能建站；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 完全生成全站静态页面；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">· 可自定义路径结构，全面提高页面访问速度；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">有人说铭飞MCMS是全国唯一完整开源的J2EE版本系统！团队希望看到更多的优秀好用的开源系统，我们一直会努力下去！</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_5\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#运行环境\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>运行环境</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">原则上支持全系列JAVA运行环境；</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">WEB服务器：Weblogic、Tomcat、WebSphere、JBoss 等</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库服务器：Mysql等</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">操作系统：Windows、Linux、Unix 等</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_6\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#开发环境\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>开发环境</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">建议开发者使用一下环境，这样避免版本带来的冲突</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">IDE:eclipse、MyEclise</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">DB:Mysql5.5</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">JDK:JAVA 7、J2EE6</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_7\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#重要文件说明\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>重要文件说明</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库连接文件: config.properties</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库文件：doc/db-mcms-open.sql</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">数据库编码：UTF-8</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">模板文件：templets/1549/mooc</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">后台访问路径：</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">http://+ip地址（或localhost）+tomcat端口+项目发布名/ms/login.do</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">如果出现无法访问的情况输入</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">http://+ip地址（或localhost）+tomcat端口+项目发布名/initApp进行初始化</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">账号:msopen</p><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">密码:msopen</p><p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 10px; font-size: 0.95em; color: rgb(102, 102, 102); line-height: 1.8em; font-family: 微软雅黑, &#39;Open Sans&#39;, sans-serif; white-space: normal; background-color: rgb(255, 255, 255);\"><span id=\"OSC_h1_8\" style=\"box-sizing: border-box; padding: 0px; margin: 0px; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span><span style=\"box-sizing: border-box; color: rgb(51, 51, 51); font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-size: 12.5px; line-height: 22.5px;\"></span></p><h1 style=\"box-sizing: border-box; margin: 20px 0px 10px; font-size: 24px; font-family: &#39;Microsoft YaHei&#39;, Verdana, sans-serif, 宋体; font-weight: 500; line-height: 43.2px; color: rgb(51, 51, 51); white-space: normal; padding: 0px; background-color: rgb(255, 255, 255);\"><a href=\"http://git.oschina.net/mingSoft/MCMS#代码部署与常见问题\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\"></a>代码部署与常见问题</h1><p style=\"box-sizing: inherit; margin-top: 0px; margin-bottom: 15px; font-size: 15px; color: rgba(0, 0, 0, 0.8); line-height: 1.33; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Lato, &#39;Helvetica Neue&#39;, &#39;Microsoft YaHei&#39;, Arial, Helvetica, sans-serif; background-color: rgb(250, 250, 250);\">铭飞MS官方开发社区文档&nbsp;<a href=\"http://ms.mingsoft.net/mbbs/12998/detail.do\" target=\"_self\" rel=\"nofollow\" style=\"box-sizing: border-box; color: rgb(255, 131, 115); text-decoration: none; -webkit-transition: all 0.5s; transition: all 0.5s; padding: 0px; margin: 0px; outline: 0px; font-size: 12px; background-color: transparent;\">http://ms.mingsoft.net/mbbs/12998/detail.do</a></p><p><br/></p>', '', '111', '/35\\181.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('171', '22222', '<p><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><strong style=\"white-space: normal; box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">MStore离不开您的参与，<br style=\"box-sizing: border-box;\"/>如果您是开发者（前端&amp;后台）</strong><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">：</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">1.要分享自己的得意模板、插件、教程？欢迎您来这里，找到需要她、欣赏她的人。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">2.想找个网络模板收藏夹存放自己喜爱的模板？ 这里就是您的选择。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">3.想结交更多热爱模板、插件的朋友？那就快来展示您的作品，寻找志趣相投的朋友吧。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><strong style=\"white-space: normal; box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">如果您是企业：</strong><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">1.这里有一群精力旺盛有着代码执着追求的开发者分享的模版与插件，相信他们肯定为您提供更好的服务。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">2.更多Java coder分享的更多插件，满足您各种项目需求，降低开发与维护成本。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">3.这里有专业设计人员提供的更多精美模版，帮您省去设计投入成本。</span><br style=\"white-space: normal; box-sizing: border-box; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; background-color: rgb(255, 255, 255);\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; background: rgb(255, 255, 255);\">4.同时也希望您为分享者点个赞。</span></p>', '', '1111', '/56/132\\171.html', 'MStore（铭飞商城）', '0', '1');
INSERT INTO `cms_article` VALUES ('173', '', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">互联网品牌推广怎么做？</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">互联网品牌推广有个新鲜名词叫数字营销，数字营销是新发展起来的一种营销模式，是利用互联网特性和技术，更加有效、高性价比地完成整合营销计划，达到传统 的IMC不能达到的高效客户关系管理等，从而精准地实施营销策略，实现企业营销的高效率、低成本、大影响。可以按两种意思来理解：网络整合营销是利用网络 技术和网络特性最大化、最快速、最有效、最精准的进行整合营销；网络整合营销是以为客户提供有价值的信息为基础，由客户创造、传播为主导的整合营销理念进 行的网络营销。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">目前品牌在推广上遇到什么问题？</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">作为品牌主，你是否有这样的困惑？<br style=\"padding: 0px; margin: 0px;\"/>● 很早就有了互联网品牌网站，可是却不知如何利用，网络也没有给你创造任何经济效益！<br style=\"padding: 0px; margin: 0px;\"/>● 希望通过网络推广获得效益，但面对市场上纷繁复杂、层出不穷的网络推广概念和方式让人眼花缭乱，却无从下手！<br style=\"padding: 0px; margin: 0px;\"/>● 花了很多钱做网站推广，却没什么效果，也不知道问题出在哪里？<br style=\"padding: 0px; margin: 0px;\"/>● 看到竞争对手迅速壮大，却不知道他们究竟如何利用好网络营销的秘诀？</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">是怎么做的？</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">当我们的客户确定需要进行数字营销传播时，我们将提供以下服务：<br style=\"padding: 0px; margin: 0px;\"/>营销型网站建设，网络调研，搜索引擎营销(SEO和SEM)，软文营销(博客营销、论坛营销、SNS营销、新闻营销、许可邮件营销)，口碑互动营销(圈子 营销、社区营销、博客营销)，群营销(网络广告、论坛营销、SNS营销、IM和QQ群营销)。将以上传播进行有机的整合营销推广，制定传播营销方案。</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">一、提供推广资料和目标，提供报价。<br style=\"padding: 0px; margin: 0px;\"/>二、提供营销型网站方案。<br style=\"padding: 0px; margin: 0px;\"/>三、确定传播关键字。<br style=\"padding: 0px; margin: 0px;\"/>四、确定搜索引擎营销策略，进行关键词甩选。<br style=\"padding: 0px; margin: 0px;\"/>五、进行后台数据分析，确定网络广告文案。<br style=\"padding: 0px; margin: 0px;\"/>六、制定病毒式营销计划，确定博客营销、论坛营销、SNS营销载体。<br style=\"padding: 0px; margin: 0px;\"/>七、确定新闻营销、博客营销、论坛营销的整体方案。<br style=\"padding: 0px; margin: 0px;\"/>八、制定网络整合营销传播计划。<br style=\"padding: 0px; margin: 0px;\"/>九、效果评估。<br style=\"padding: 0px; margin: 0px;\"/>十、提供传播报告。</p><p><br/></p>', 'h,', '', '/53/134\\index.html', '营销型网站建设', '0', '1');
INSERT INTO `cms_article` VALUES ('205', '', null, '', '', '/100/148\\205.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('206', '', null, '', '', '/100/148\\206.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('207', '', null, '', '', '/100/148\\207.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('208', '', null, '', '', '/100/148\\208.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('209', '', null, '', '园林绿化二级资质企业', '/100/148\\209.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('210', '', null, '', '园林绿化二级资质企业', '/100/147\\210.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('211', '', null, '', '园林绿化二级资质企业', '/100/147\\211.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('174', '', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">域名?</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">Internet这个信息时代的宠儿，已经走出了襁褓，为越来越多的人所认识，电子商务、网上销售、网络广告已成为商界关注的热点。&quot;上网&quot;已成为不少人的口头禅。但是，要想在网上建立服务器发布信息，则必须首先注册自己的域名，只有有了自己的域名才能让别人访问到自己。所以，域名注册是在互联网上建立任何服务的基础。同时，由于域名的唯一性，尽早注册又是十分必要的。</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\">&nbsp;</p><hr style=\"padding: 0px; margin: 0px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \"/><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal;\"><span style=\"padding: 0px; margin: 0px; color: rgb(255, 0, 0);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">国际域名注册</span></span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; \">&nbsp;</p><table bgcolor=\"#cccccc\" cellpadding=\"0\" cellspacing=\"1\" class=\"yh_z\" width=\"100%\"><tbody style=\"padding: 0px; margin: 0px;\"><tr style=\"padding: 0px; margin: 0px;\" class=\"firstRow\"><th bgcolor=\"#f2f2f2\" height=\"25\" width=\"20%\" style=\"padding: 0px; margin: 0px;\"><strong style=\"padding: 0px; margin: 0px;\">域名价格</strong></th><th bgcolor=\"#f2f2f2\" width=\"20%\" style=\"padding: 0px; margin: 0px;\"><strong style=\"padding: 0px; margin: 0px;\">域名价格</strong></th><th bgcolor=\"#f2f2f2\" width=\"60%\" style=\"padding: 0px; margin: 0px;\"><strong style=\"padding: 0px; margin: 0px;\">域名说明</strong></th></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">CN英文域名注册</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">80&nbsp;元/年</h5></td><td align=\"left\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名类型：.cn/ .com.cn/ .net.cn/ .org.cn等</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">国际域名注册</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">80&nbsp;元/年<br style=\"padding: 0px; margin: 0px;\"/>(多年购买优惠)</h5></td><td align=\"left\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名类型：.com/ .net/ .org/ .biz</td></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文.ASIA</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">159&nbsp;元/年</h5></td><td align=\"left\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：表示亚洲</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">顶级域名.MOBI</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">168&nbsp;元/年<br style=\"padding: 0px; margin: 0px;\"/>(多年购买优惠)</h5></td><td align=\"left\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：手机域名，WAP网站首要之选</td></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">新顶级域名TEL</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">158&nbsp;元/年</h5></td><td align=\"left\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：电话，网络名片</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文.TRAVEL</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">1800&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：旅游域名，国际域名</td></tr><tr bgcolor=\"#fffde5\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">香港域名.HK</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">215&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名类型：.hk/ .com.hk</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">新顶级域名.NAME</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">100&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：<strong style=\"padding: 0px; margin: 0px;\">国际顶级</strong>域名，<strong style=\"padding: 0px; margin: 0px;\">个人域名</strong>的标志</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">新顶级域名.INFO</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">100&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：<strong style=\"padding: 0px; margin: 0px;\">国际域名</strong>，表示网络信息服务组织</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文.CC</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">298&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：商业公司，中国公司</td></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文.TV</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">330&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：表示电视,宽频时代的主流域名</td></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文名.IN</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">580&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：India（印度）的国家域名</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文.LA</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">880&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：表示洛杉矶</td></tr><tr bgcolor=\"#ffffff\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文 .JOBS</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">2800&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：国际顶级域名，主要面向招聘和求职市场</td></tr><tr bgcolor=\"#f2f2f2\" style=\"padding: 0px; margin: 0px;\"><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">英文 .ME</h5></td><td align=\"center\" style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\"><h5 style=\"padding: 0px; margin: 0px;\">315&nbsp;元/年</h5></td><td style=\"padding-right: 5px; padding-left: 5px; margin: 0px;\">域名意义：国际顶级域名，.Me代表“我”，属于你！</td></tr></tbody></table><p><br/></p>', 'c,', '', '/53/135\\index.html', 'Internet这个信息时代的宠儿', '0', '1');
INSERT INTO `cms_article` VALUES ('182', '', '<p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">网络营销是以互联网络为基础，通过数字化的信息和网络媒体的交互性来辅助营销目标实现的一种新型的市场营销方式。</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 据统计，在国外，80%的个人和企业都选择网络媒介进行营销推广，并从中获得了极好的效果。而在中国，选择网络营销的企业和个人只有7-8%，不到国外的十分之一。</span></p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\">&nbsp;</p><p style=\"padding: 0px; margin-top: 0px; margin-bottom: 0px; line-height: 24px; color: rgb(68, 68, 68); font-family: Verdana, Arial, Tahoma; font-size: 12px; white-space: normal; background-color: rgb(255, 255, 255);\"><span style=\"padding: 0px; margin: 0px; font-size: 14px;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 随着网络影响的进一步扩大，随着人们对于网络营销理解的进一步加深，以及越来越多出现的网络营销推广的成功案例，人们已经开始意识到网络营销的诸多优点，越来越多的企业和个人通过网络进行营销推广</span></p><p><br/></p>', '', '', '/52\\index.html', '网络营销是以互联网络为基础', '0', '1');
INSERT INTO `cms_article` VALUES ('183', '', '<p><img src=\"/upload/editor/1580/1461912560218.jpg\" title=\"1461912560218.jpg\" alt=\"1-1203302131502F.jpg\"/><img src=\"/upload/editor/1580/1461912562754.jpg\" title=\"1461912562754.jpg\" alt=\"1-120330213210F7.jpg\"/><img src=\"/upload/editor/1580/1461912555214.jpg\" title=\"1461912555214.jpg\" alt=\"1-12033021312C17.jpg\"/></p>', '', '', '/52/136\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('177', 'MS', '<p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS是企业创立初期很好的基础框架，不仅可以实现和现有系统的对接而且有大量的插件模版可以使用。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台开发团队承诺MCMS内容管理系统永久完整开源免费(这真是极好的)！下面就简单的给大家介绍一下MS平台和MCMS为什么如此之快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MS平台是铭飞团队经过多年的研发，最终以MCMS为基础，集商城、论坛、分期、会员、支付、积分、微信等系统于一体的插件式系统。并实现了淘宝、京东、苏宁、国美等第三方电商平台数据接口的统一。平台中的小插件如：邮件推送、短信接口、定时任务、促销活动、数据采集等非常丰富。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">MCMS的模版采用标签式开发，上手非常快。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px;\"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于技术小白来说不仅避开了学习复杂的高级开发语言,而且MStore有大量成熟的模版直接下载之后换换图片和内容就可以使用,要是需要调整只需要写简单的标签就可以。</span></p><p style=\"box-sizing: border-box; margin-top: 8px; margin-bottom: 8px; font-size: 12.5px; color: rgb(51, 51, 51); line-height: 22.5px; white-space: normal; padding: 0px; letter-spacing: 0.5px; word-wrap: break-word; word-break: break-all; font-family: Verdana, sans-serif, 宋体; text-indent: 28px; \"><span style=\"box-sizing: border-box; padding: 0px; margin: 0px; font-family: 微软雅黑; font-size: 14px;\">对于前端工程师来说只需要写好页面样式并在页面内容部分套上标签，就可以做出一套优美的动态网站。并且还可以实现留言板、用户登录等数据交互功能。</span></p><p><br/></p>', 'h,', '来自火星的程序猿', '/59/70\\177.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('178', 'MS', '<p><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">MStore离不开您的参与，<br style=\"box-sizing: border-box;\"/>如果您是开发者（前端&amp;后台）</strong><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">：</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">1.要分享自己的得意模板、插件、教程？欢迎您来这里，找到需要她、欣赏她的人。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">2.想找个网络模板收藏夹存放自己喜爱的模板？ 这里就是您的选择。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">3.想结交更多热爱模板、插件的朋友？那就快来展示您的作品，寻找志趣相投的朋友吧。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">如果您是企业：</strong><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">1.这里有一群精力旺盛有着代码执着追求的开发者分享的模版与插件，相信他们肯定为您提供更好的服务。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">2.更多Java coder分享的更多插件，满足您各种项目需求，降低开发与维护成本。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">3.这里有专业设计人员提供的更多精美模版，帮您省去设计投入成本。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">4.同时也希望您为分享者点个赞。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">铭飞已经上路，我们将为此不懈努力，期待得到您的支持！</strong></p>', '', '来自火星的程序猿', '/59/68\\178.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('179', 'MS', '<p><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">MStore（铭飞商城）是铭飞（MS）平台为开发者提供模版与插件作品分享平台,为企业提供优质产品和服务我们致力于打造一个优秀的Java资源共享学习平台。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">MStore离不开您的参与，<br style=\"box-sizing: border-box;\"/>如果您是开发者（前端&amp;后台）</strong><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">：</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">1.要分享自己的得意模板、插件、教程？欢迎您来这里，找到需要她、欣赏她的人。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">2.想找个网络模板收藏夹存放自己喜爱的模板？ 这里就是您的选择。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">3.想结交更多热爱模板、插件的朋友？那就快来展示您的作品，寻找志趣相投的朋友吧。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">如果您是企业：</strong><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">1.这里有一群精力旺盛有着代码执着追求的开发者分享的模版与插件，相信他们肯定为您提供更好的服务。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">2.更多Java coder分享的更多插件，满足您各种项目需求，降低开发与维护成本。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">3.这里有专业设计人员提供的更多精美模版，帮您省去设计投入成本。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><span style=\"box-sizing: border-box; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px;\">4.同时也希望您为分享者点个赞。</span><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px; \"/><br style=\"box-sizing: border-box; white-space: normal; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; font-size: 14px; line-height: 23px;\"/><strong style=\"box-sizing: border-box; white-space: normal; margin: 0px; padding: 0px; border: 0px; outline: 0px; font-size: 14px; vertical-align: baseline; color: rgb(114, 114, 114); font-family: &#39;Open Sans&#39;, sans-serif; line-height: 23px; \">铭飞已经上路，我们将为此不懈努力，期待得到您的支持！</strong></p>', 'h,', '来自火星的程序猿', '/59/68\\179.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('204', '', null, '', '', '/100/148\\204.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('190', '', null, '', '', '/19/142\\index.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('193', '铭飞', '<p>市委副书记、市长宋朝华率队前往贵州省贵阳市，实地考察由中铁贵旅公司投资开发建设的中铁国际生态城项目，并与公司高层进行了深入友好座谈，洽谈推进重大项目落户我市仁寿县相关事宜。</p><p>&nbsp;</p><p>中国中铁旗下子公司——中铁贵旅公司开发建设的中铁国际生态城项目位于贵阳市龙洞堡空港经济区，总投资500亿元，占地面积约20平方公里，打造集旅游、休闲、度假、运动、文化、养老、养生和居住等多种功能于一体的世界级旅游度假目的地，2011年被列为“贵州省十二五旅游发展规划十大旅游项目”之一，是贵州省的重点项目。在中铁贵旅公司董事长张敏的陪同下，宋朝华一行参观考察了中铁国际生态城展示中心、中铁国际生态旅游城市综合体项目、安纳塔拉度假酒店和巫山香杏小镇等旅游开发项目，认真听取了项目规划建设有关情况介绍，对中铁国际生态城项目规划理念新、设计水平高、推进速度快表示由衷赞赏，对中铁贵旅公司有意来我市仁寿县投资发展表示热烈欢迎。</p><p>&nbsp;</p><p>座谈会上，双方就推进项目落户事宜进行了深入友好会谈。宋朝华指出，中铁贵旅公司实力强、品牌响、理念新，对公司投资开发黑龙滩休闲旅游度假中心项目充满信心。通过深入考察和友好洽谈，双方就项目投资有关事宜达成了共识，并将于近期正式签署合作协议。张敏表示，天府眉山交通区位优越，旅游资源独特，发展潜力巨大，集团拟投资200亿元以上开发建设黑龙滩旅游项目。该项目将按照国际化水准，坚持以游为主、高举高打，紧紧围绕“吃、住、行、游、购、娱”六要素，走产业高端、高端产业的路线，全力打造5a级景区，为发展旅游产业和造福眉山人民作出央企应有的贡献。</p><p><br/></p>', '', '铭飞', '/62/84\\193.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('194', '铭飞', '<p>森和汽车城，位于广州市天河北路，是一家高端品牌汽车的城市综合展厅，本来是全方位展示豪华新车的地方。上周，突然在门口拉上了横幅——东阳红木清货大甩卖。记者于日前一探，吓了一跳。门口的广场上停着几辆大货车，不断有红木家具被抬出来打包装车。走进去视觉更混乱，当庭摆着一套五件鹿角椅，旁边是满雕龙的金丝楠木顶箱柜，内庭中央还展示着一辆豪华轿车，而周边则摆满红木家具，完全没有红木家具应该有的意境。更令人瞠目结舌的是，里面人流熙熙攘攘，整个场景可以让你直接穿越到上世纪八十年代中期一个小县城的展销会。</p><p>&nbsp;</p><p>　　“销售情况非常可观，首日已经突破100万元销售，周末差不多也是这个数。”东阳红木销售负责人穆延东告诉记者，这次的清货周四开始，周日结束，下周同样如此，中间的时间会对产品进行调整，再销售一次就结束了。记者在店内粗略看了一下，产品以清式家具为主，材质则以金丝楠木、微凹黄檀、缅甸花梨、南美酸枝、东南亚酸枝为主，大红酸枝和明式风格的产品不多，就连在今年APEC上出现的大红酸枝交椅的完整复刻版，也随便被摆在了角落。从做工和风格以及雕刻工艺来看，这些货物并非出自一家工厂。“此次清货的红木家具，来自东阳红木家具六家工厂，这些货基本是这些厂家去年接的订单直接生产的，但今年有很多客户取消了订单，加上市场环境变化，代理商出货也很慢。工厂不像经销商，可以囤货，它必须保持周转，否则就得停工待产坐以待毙。所以几家厂子就联合起来，将厂里现有的产品变现，自谋生路。”穆延东告诉记者，他们在北京、上海也有此类清货会，销售情况都不错，相对而言，广州的销售情况不如北京、上海。“可能是产品材质的问题，微凹黄檀和缅甸花梨的产品比较畅销，但南美酸枝和东南亚酸枝的产品不太被认可。有很多消费者直接询问有没有大红酸枝的产品，也有很多消费者询问有没有明式风格的产品。”他透露，下周销售的产品将会进行调整，还是针对普通消费者，以老挝大红酸枝(交趾黄檀)、缅甸花梨的材质为主，增加明式风格家具的品类，但还是以清式风格为主。</p><p><br/></p>', '', '铭飞', '/62/83\\194.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('195', '铭飞', '<p>海南黄花梨圆包脚罗汉床、小叶紫檀云龙纹镶理石圆桌、富贵满堂多宝阁……昨日（12月13日）上午，第三届中国（江门）传统家具精品鉴赏会暨2014中国（江门）红木家具经销大会在五邑华侨广场会展中心正式开幕，众多国宝级古典家具作品以及海南黄花梨等珍贵木材亮相。</p><p>&nbsp;</p><p>　　此次活动由江门市古典家具行业协会主办，江门市新会区古典家具行业协会、台山市大江古典家具商会共同协办，会期为12月13日至16日，有来自我市新会、台山的50家代表性企业参展，云集了20多个省市经销商、行业精英，这是我市古典家具行业促进交流合作，展示广作精品，推广“江门红木”的重要平台。</p><p>&nbsp;</p><p>　　出席展会开幕式的有关嘉宾有：中国家具协会副理事长、传统家具专业委员会主席团常设主席陈宝光，故宫博物院常务副院长、故宫博物院研究员王亚民，中国家具协会传统家具专业委员会主席、江门市古典家具行业协会会长伍炳亮，省家具协会会长王克，省工艺美术协会会长舒海波等。</p><p>&nbsp;</p><p>　　我市是红木广作工艺的发源地之一，也是全国红木家具重要的生产基地，拥有深厚的文化和精妙的技艺，人才云集。借助这次展会，伍炳亮认为，一方面，“将有利于增加广大爱好者对传统家具的了解，在提升自己的审美观和鉴赏力，领略艺术魅力的同时，享受艺术带来的美好生活”；另一方面，这将成为我市对外展示的窗口，“展示我市优秀传统家具作品和设计，引领当代仿古家具健康发展”。</p><p>&nbsp;</p><p>　　王亚民在致辞中说：“江门在传统家具制作方面有很长的历史，涌现出了一批家具行业的企业家，对传统家具的继承创新与发展都做出了自己的探索和非常令人鼓舞的成就，在全国形成影响。”</p><p>&nbsp;</p><p>　　陈宝光则希望：“江门红木家具企业能够借这次展会，进一步推动行业良性发展，为全国红木家具发展作出贡献。”</p><p><br/></p>', 'f,', '铭飞', '/62/83\\195.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('196', '铭飞', '<p>有人说，成都，是一个让人来了就不想离开的地方，是一座悠远的文化名城，它用睿智和远见，让每一个人共享一座城市的幸福，因此被评为“最具幸福感的城市”。</p><p>&nbsp;</p><p>那么，当中国国粹文化的传承者、追求幸福感的红木家具知名品牌——东莞市弘开实业有限公司（以下简称戴为红木）与成都邂逅，必能为广大成都市民增添更多新的幸福感。<br/><br/></p><p>近期，出于对中国传统文化的热爱，以及对红木艺术的执着、深情和追求，戴为红木携带“幸福之家”主题活动礼遇成都，使其鸿儒红木家居艺术馆隆重开业，为已进入寒冬的成都燃起了一把火，掀起了中式红木家具热潮！</p><p>&nbsp;</p><p>据了解，戴为红木成都鸿儒红木家居艺术馆在锦江区三色路，展馆面积达500多平方米。艺术馆整体宏伟大气，装修精致，馆内的精品极富特色设计，尤其是第四层展示了戴为红木的代表性设计风格，不仅拥有宁静致远的品茶茶室，静心悟道之香道品香室，古色古香的贵宾区，休闲娱乐之棋牌室等高端居室，而且居室采用了鸿儒家居VIP会员制度。这意味着，在这里，不仅可以享受国粹文化的熏陶，还能尊享贵宾待遇的幸福感。</p><p><br/></p>', 'h,', '铭飞', '/62/83\\196.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('197', '铭飞', '<p>今年以来，质检总局执法督查司按照网上发现、源头追溯、落地查处的要求，组织开展电子商务产品专项执法打假活动，积极构建适应电子商务执法打假的全国执法协查工作机制，推动属地查处工作的开展，全国共查处电商产品质量违法案件400余件。</p><p>2014年6月，江苏省淮安市质监局根据总局执法司统一部署，对江苏杰翔羽绒有限公司进行了执法检查。经查，该公司涉嫌生产并通过“天猫商城”和“京东商城”等电子商务平台销售以假充真蚕丝被。目前，江苏省淮安市淮安质监局已对该案立案查处。</p><p><br/></p>', '', '铭飞', '/62/83\\197.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('198', '铭飞', '<p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑, Arial; line-height: 34px; white-space: normal; background-color: rgb(255, 255, 255);\">巴黎时装周许晴倾力助阵，当天许晴身着黑色拼接装头排看秀，大秀美腿，加上干净利落的妆容，整体造型简洁率性，绿色的刺绣手包更添俏皮，银色的尖头高跟鞋成点睛之笔，许晴此次看秀的装扮可谓彰显了至纯至简主义。</p><p style=\"margin-top: 0px; margin-bottom: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 微软雅黑, Arial; line-height: 34px; white-space: normal; background-color: rgb(255, 255, 255);\">对于此次的装扮许晴表示：“这次的服装都是看似简单其实细节之处非常打动我，像这件是硬朗的皮质与柔软的丝绵材质的拼接，好比是一刚一柔，代表女子都有柔软和刚强的两面，刚柔并济。”许晴和MirandaKerr在头牌看秀时不时凑在一起交流，时而发出会心微笑时而一起鼓掌，成为现场最闪耀的亮点，很多时尚博主达人都纷纷夸赞二人拥有最甜美的笑脸。</p><p><br/></p>', '', '铭飞', '/62/83\\198.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('199', '铭飞', '<p>市委副书记、市长宋朝华率队前往贵州省贵阳市，实地考察由中铁贵旅公司投资开发建设的中铁国际生态城项目，并与公司高层进行了深入友好座谈，洽谈推进重大项目落户我市仁寿县相关事宜。</p><p>&nbsp;</p><p>中国中铁旗下子公司——中铁贵旅公司开发建设的中铁国际生态城项目位于贵阳市龙洞堡空港经济区，总投资500亿元，占地面积约20平方公里，打造集旅游、休闲、度假、运动、文化、养老、养生和居住等多种功能于一体的世界级旅游度假目的地，2011年被列为“贵州省十二五旅游发展规划十大旅游项目”之一，是贵州省的重点项目。在中铁贵旅公司董事长张敏的陪同下，宋朝华一行参观考察了中铁国际生态城展示中心、中铁国际生态旅游城市综合体项目、安纳塔拉度假酒店和巫山香杏小镇等旅游开发项目，认真听取了项目规划建设有关情况介绍，对中铁国际生态城项目规划理念新、设计水平高、推进速度快表示由衷赞赏，对中铁贵旅公司有意来我市仁寿县投资发展表示热烈欢迎。</p><p>&nbsp;</p><p>座谈会上，双方就推进项目落户事宜进行了深入友好会谈。宋朝华指出，中铁贵旅公司实力强、品牌响、理念新，对公司投资开发黑龙滩休闲旅游度假中心项目充满信心。通过深入考察和友好洽谈，双方就项目投资有关事宜达成了共识，并将于近期正式签署合作协议。张敏表示，天府眉山交通区位优越，旅游资源独特，发展潜力巨大，集团拟投资200亿元以上开发建设黑龙滩旅游项目。该项目将按照国际化水准，坚持以游为主、高举高打，紧紧围绕“吃、住、行、游、购、娱”六要素，走产业高端、高端产业的路线，全力打造5a级景区，为发展旅游产业和造福眉山人民作出央企应有的贡献。</p><p><br/></p>', 'c,', '铭飞', '/62/83\\199.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('200', 'MS', '<p>斯宾特系列(Sprinter)系列技术领先，动力强劲。座位数从10座到20座均可选择，跟据配置不同,价格也从95.8万——178万可以选择。为您带来不同的商务体验。下面为您带来的就是斯宾特A3-9座旗舰型，号称移动总裁办公室的豪华商务房车。</p><p>从看到斯宾特的第一眼，您就会喜欢上他，不仅仅因为他豪华大气的外观，更得益于梅赛德斯-奔驰精湛造车技艺的极致发挥和处处以人为本的至臻理念，时刻让您感受到其中极高的舒适和享受。车门电动滑动装置，配合智能化遥控车钥匙开启，您可以轻而易举的开合车门，体现无微不至的尊荣享受。尽显豪华大气本色！</p><p><br/>后轮双胎配置使车身的承载能力更加强大，更加稳定、安全。奔驰商务车秉承了梅赛德斯-奔驰品牌百年的造车传统，奔驰商务车中斯宾特以豪华大气的外观、卓尔不凡的品质、坚实可靠的性能，再一次演绎了梅赛德斯-奔驰对至善臻美的不懈追求。新一代梅赛德斯-奔驰商务车斯宾特技术更上一层楼，为高级商务车行业树立新标杆。外观造型气度恢弘、浑然天成；细节设计周密严谨、精益求精。梅赛德斯-奔驰造车专家独运匠心，精心打造，为客户带来具有更大空间、更强动力和更高安全保障的斯宾特。</p><p>&nbsp;</p><p>车内中控隔屏、BOSE顶级KTV系统及酒柜吧台。高大的车身设计带来无与伦比的车内空间，车内净高1.98米。这使您进出车仓无需弯腰低头，也喻示着此车的拥有者在生意场上的强势，无需向任何人低头。车内后仓配备阿尔卑斯小牛皮手工订制的豪华航空座椅，尽显商务头等仓本色，两个可以360度旋转的座椅和侧置沙发可以让车内座椅布局自由组合。带来超乎想像的谈判空间！</p><p><br/>隔屏上集成了一台来自三星的40英寸3D液晶电视，配合卫星电视接收器可以接收国内100多个电视频道，DVD庭影院系统也可以播放高清视频。让您在旅途中不再无聊。来自瑞士的水晶杯在酒柜的LED灯光照射下晶莹剔透，更显皇家风范。</p><p><br/></p>', 'p,', '来自火星的程序猿', '/106/107\\200.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('201', 'MS', '<p><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">其实商务车在人们眼里就是普通的客车，没有人会花时间去研究它，欣赏它。商务车给人的印象，就是整体的一箱车，发动机不是在驾驶与副驾驶的座椅下边，就是在车子的后面。没有前发动机舱，很少有人会把普通的商务车与“霸气”这个词汇文明发言在一起。而作为一款纯正的“美国”商务车，GMC3500完全打破中国人传统意识里的对商务车的形象。&nbsp;</span></p>', '', '来自火星的程序猿', '/106/107\\201.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('202', 'MS', '<p><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">对于这样一款外观霸气，承载性高的原装进口商务车和它实在的销售价格，都让这款车的性价比大大提升了不少。对于市场上一些追求个性的客户群来讲，GMC3500恰恰就是一款能够让他们体现出个性化的座驾，留有足够改装想象和个性发展的空间，体验生活品味，从GMC开始。新款GMC Savana 3500 舒适版商务车是您一个很不错的选择。</span></p>', '', '来自火星的程序猿', '/106/107\\202.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('203', 'MS', '<p><span style=\"color: rgb(102, 102, 102); font-family: &#39;Microsoft Yahei&#39;, Verdana, Geneva, sans-serif; font-size: 14px; line-height: 25px; background-color: rgb(255, 255, 255);\">奔驰斯宾特系列礼宾车在豪华商务车系中，一向是高端、舒适的代名词。在秉承了奔驰的贵族气质的同时，其全新定制的奢华内饰让人感觉犹如进入了高档的商务会所。定位为大型集团公司商务接待用车。其超高端的豪华配置能够很好的提升用车企业的自身品质，给来访者一种最高礼遇，是对商务洽谈活动的一种实质推动和提升。&nbsp;</span></p>', 'c,', '来自火星的程序猿', '/106/107\\203.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('213', '', '<ol class=\"list-ol list-paddingleft-2\" style=\"list-style-type: square;\"><li><p>创造价值：一切工作围绕为用户价值展开，不做任何对用户没有价值的面子工作。</p></li><li><p>积极主动：在做好本职工作的前提下，积极主动为公司解决问题，推动公司发展。</p></li><li><p>踏实奋进：不报幻想，实事求是，锐意进取。不把“运气”当作成事的前提，抱美好的梦想，作最坏的打算。</p></li><li><p>合作共赢：抱着共赢的心态，积极与企业内外合作，充分利用各方优势，创造价值。</p></li></ol><p><br/></p>', 'p,', '', '/93/95\\213.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('214', '', '<ol class=\"list-ol list-paddingleft-2\" style=\"list-style-type: square;\"><li><p>注重长远发展，不因商业利益伤害用户价值。</p></li><li><p>关注并深刻理解用户需求，不断以卓越的产品和服务满足用户需求。</p></li><li><p>重视与用户的情感沟通，尊重用户感受，与用户共成长。</p></li><li><p>合作共赢：抱着共赢的心态，积极与企业内外合作，充分利用各方优势，创造价值。</p></li></ol><p><br/></p>', 'f,', '', '/93/95\\214.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('215', '', '<ol class=\"list-ol list-paddingleft-2\" style=\"list-style-type: square;\"><li><p>努力为员工提供良好的工作环境和科学的激励机制。</p></li><li><p>努力让适合的人干适合的事，为员工提供丰富的培训和晋升机会，使员工和公司共同成长。</p></li><li><p>尊重和信任员工，鼓励员工充分发挥聪明才智，使其在自己的领域获得成功。</p></li></ol><p><br/></p>', 'c,', '', '/93/95\\215.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('218', '', '<p>锐诚PPT培训部总监，17年PPT研究积淀，5年网络教室的教学经验。2013年获得全国振兴杯多媒体制作员比赛第7名 。多次获得省市局级办公软件技术大赛奖，独撰《PPT高效设计—6招完美打造工作型PPT》全国发行。曾任中国石化干部管理学院担任“PPT高级制作技巧”课程授课讲师。幽默，轻松的授课方式，快乐中传授高效快捷的实用技术。</p><p><br/></p>', 'c,', '', '/115\\218.html', '', '0', '1');
INSERT INTO `cms_article` VALUES ('219', '', '<p>锐诚PPT金牌设计师，毕业于上海美术学院视觉传达专业，曾在国内某知名4A广告公司任职，五年动画和PPT设计经验，拥有丰富的高端定制设计经验，专注于企业展示/工作汇报/品牌宣讲/竞聘/路演等高端PPT设计，设计理念：创意是设计的灵魂！在动画、质感和版式的设计上力求完美。</p><p><br/></p>', 'f,', '', '/115\\219.html', '', '0', '1');

-- ----------------------------
-- Table structure for `cms_class_50`
-- ----------------------------
DROP TABLE IF EXISTS `cms_class_50`;
CREATE TABLE `cms_class_50` (
  `basicId` int(11) NOT NULL,
  `school` varchar(220) DEFAULT NULL,
  `platform` varchar(220) DEFAULT NULL,
  PRIMARY KEY (`basicId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of cms_class_50
-- ----------------------------
INSERT INTO `cms_class_50` VALUES ('2', '1', '2');
INSERT INTO `cms_class_50` VALUES ('3', '3', '2');
INSERT INTO `cms_class_50` VALUES ('4', '1', '4');
INSERT INTO `cms_class_50` VALUES ('5', '2', '1');
INSERT INTO `cms_class_50` VALUES ('6', '2', '1');
INSERT INTO `cms_class_50` VALUES ('7', '1', '1');

-- ----------------------------
-- Table structure for `cms_column`
-- ----------------------------
DROP TABLE IF EXISTS `cms_column`;
CREATE TABLE `cms_column` (
  `COLUMN_CATEGORYID` int(22) NOT NULL DEFAULT '0' COMMENT '关联category表（类别表ID）',
  `COLUMN_KEYWORD` varchar(300) DEFAULT NULL COMMENT '栏目简介',
  `COLUMN_DESCRIP` varchar(500) DEFAULT NULL COMMENT '栏目关键字的扩展',
  `COLUMN_TYPE` int(2) DEFAULT NULL COMMENT '1,代表最终列表栏目。2，代表频道封面。3，带表外部链接',
  `COLUMN_URL` varchar(50) DEFAULT NULL COMMENT '如果是外部链接，则保持外部链接地址。如果为最终列表栏目，就保存文章显示列表',
  `COLUMN_LISTURL` varchar(50) DEFAULT NULL COMMENT '最终列表栏目的列表模板地址',
  `COLUMN_TENTMODELID` int(22) DEFAULT NULL COMMENT '栏目类型,直接影响栏目发布的表单样式',
  `COLUMN_WEBSITEID` int(22) DEFAULT NULL COMMENT '栏目所属站点ID',
  `COLUMN_PATH` varchar(150) DEFAULT NULL COMMENT '栏目路径',
  `COLUMN_CONTENTMODELID` int(11) DEFAULT '0' COMMENT '栏目管理的内容模型id',
  PRIMARY KEY (`COLUMN_CATEGORYID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='栏目表';

-- ----------------------------
-- Records of cms_column
-- ----------------------------
INSERT INTO `cms_column` VALUES ('19', '', '', '2', 'contact.htm', 'contact.htm', null, '1', '/19', '0');
INSERT INTO `cms_column` VALUES ('23', '', '', '1', 'about.htm', 'liebiao.htm', null, '1', '/23', '0');
INSERT INTO `cms_column` VALUES ('33', '', '', '1', 'detail.htm', 'list.htm', null, '1', '/33', '0');
INSERT INTO `cms_column` VALUES ('52', '', '', '2', 'product.htm', 'about.htm', null, '1', '/52', '0');
INSERT INTO `cms_column` VALUES ('53', '', '', '2', 'about.htm', 'about.htm', null, '1', '/53', '0');
INSERT INTO `cms_column` VALUES ('59', '', '您可以通过以下新闻与公司动态进一步了解我们。我们所签约的客户，无论他们的项目是大或者是小，我们都将提供100%的服务', '1', 'news-show.htm', 'news-list.htm', null, '1', '/59', '0');
INSERT INTO `cms_column` VALUES ('61', '', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'case-show.htm', 'case-list.htm', null, '1', '/61', '0');
INSERT INTO `cms_column` VALUES ('62', '', '您可以通过以下新闻与公司动态进一步了解我们。我们所签约的客户，无论他们的项目是大或者是小，我们都将提供100%的服务', '1', 'news-show.htm', 'news-list.htm', null, '1', '/62', '0');
INSERT INTO `cms_column` VALUES ('63', '建站资源共享学习平台!', '我们为您提供网站策划、网页设计、程序开发、网站推广、域名注册、虚拟主机、企业邮箱等网站建设相关服务；为您提供iOS/Android/Windows Phone等移动平台的APP应用开发；为您提供办公系统、客户关系管理系统、电子政务系统等行业应用系统的开发；为您提供软件定制开发和系统集成服务。', '2', 'service.htm', 'service.htm', null, '1', '/63', '0');
INSERT INTO `cms_column` VALUES ('65', '精选案例展示', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'case-show.htm', 'case-list.htm', null, '1', '/61/65', '0');
INSERT INTO `cms_column` VALUES ('66', '精选案例展示', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'case-show.htm', 'case-list.htm', null, '1', '/61/66', '0');
INSERT INTO `cms_column` VALUES ('67', '精选案例展示', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'case-show.htm', 'case-list.htm', null, '1', '/61/67', '0');
INSERT INTO `cms_column` VALUES ('68', '', '您可以通过以下新闻与公司动态进一步了解我们。我们所签约的客户，无论他们的项目是大或者是小，我们都将提供100%的服务', '1', 'news-show.htm', 'news-list.htm', null, '1', '/59/68', '0');
INSERT INTO `cms_column` VALUES ('69', '', '', '1', 'news-show.htm', 'news-list.htm', null, '1', '/59/69', '0');
INSERT INTO `cms_column` VALUES ('70', '', '新闻中心', '1', 'news-show.htm', 'news-list.htm', null, '1', '/59/70', '0');
INSERT INTO `cms_column` VALUES ('83', '', '您可以通过以下新闻与公司动态进一步了解我们。我们所签约的客户，无论他们的项目是大或者是小，我们都将提供100%的服务', '1', 'news-show.htm', 'news-list.htm', null, '1', '/62/83', '0');
INSERT INTO `cms_column` VALUES ('84', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。我们致力于打造一个优秀的建站资源共享学习平台！', '专业提供网站模板，网页模板，教程培训，程序插件，网站素材等建站资源。设计者：如果您是模板设计师，插件制作者。我们致力于打造一个优秀的建站资源共享学习平台！您可以在这里放心出售您的模板和插件，我们提供版权保护。购买者：购买本站资源，我们提供“三重保障”(担保交易+人工介入+售后服务)，保障购买者的合法权益。织梦猫已经上路，我们将为此不懈努力，期待得到您的支持！', '1', 'news-show.htm', 'news-list.htm', null, '1', '/62/84', '0');
INSERT INTO `cms_column` VALUES ('87', '', '', '2', 'solution.htm', 'about.htm', null, '1', '/87', '0');
INSERT INTO `cms_column` VALUES ('93', '关于我们', '关于我们', '2', 'about.htm', 'about.htm', null, '1', '/93', '0');
INSERT INTO `cms_column` VALUES ('94', '关于我们', '关于我们', '2', 'about.htm', 'about.htm', null, '1', '/93/94', '0');
INSERT INTO `cms_column` VALUES ('95', '关于我们', '关于我们', '2', 'about.htm', 'about-list.htm', null, '1', '/93/95', '0');
INSERT INTO `cms_column` VALUES ('96', '', '', '2', 'about.htm', 'news-list.htm', null, '1', '/93/96', '0');
INSERT INTO `cms_column` VALUES ('97', '', '', '2', 'about.htm', 'about.htm', null, '1', '/93/97', '0');
INSERT INTO `cms_column` VALUES ('98', '关于我们', '生态农庄', '2', 'about.htm', 'about.htm', null, '1', '/93/98', '0');
INSERT INTO `cms_column` VALUES ('99', '', '', '2', 'service.htm', 'product.htm', null, '1', '/99', '0');
INSERT INTO `cms_column` VALUES ('100', '', '', '1', 'about.htm', 'about.htm', null, '1', '/100', '0');
INSERT INTO `cms_column` VALUES ('101', '专业服务', '品牌策划年度服务是岳派品牌机构的主要服务方式之一，以一年或更长时间作为服务周期，为企业进行有计划、有步骤的策划、设计、执行等，进行一体化品牌策划推广服务。', '2', 'servise.htm', 'about-list.htm', null, '1', '/99/101', '0');
INSERT INTO `cms_column` VALUES ('102', '专业服务', 'LOGO 标志设计 VIS设计 宣传物料设计视觉是人们接受外部信息的最重要和最主要的通道。设计科学、实施有利的视觉识别，是传播企业经营理念、建立企业知名度、塑造企业形象的快速便捷之途', '2', 'servise.htm', 'about-list.htm', null, '1', '/99/102', '0');
INSERT INTO `cms_column` VALUES ('103', '专业服务', '竞争的优势不仅在于产品，也源于产品包装的设计，一个产品的包装直接影响顾客购买心理，产品的包装是最直接的广告 ,由表及里是自然界认识事物不变的定律。', '2', 'servise.htm', 'news-list.htm', null, '1', '/99/103', '0');
INSERT INTO `cms_column` VALUES ('104', '专业服务', '连锁店的CI和一般企业的作法有相当大的差异，最主要的因素就是与目标接触的场合不同。连锁店与消费者之间最常发生的接触就是在门店，创造视觉的个性化与标准化，来\r\n加深人们的印象', '2', 'servise.htm', 'news-list.htm', null, '1', '/99/104', '0');
INSERT INTO `cms_column` VALUES ('106', '我们的作品', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'product-show.htm', 'product-list.htm', null, '1', '/106', '0');
INSERT INTO `cms_column` VALUES ('107', '我们的作品', '新颖的设计方案，大胆的革新思想，灵活的运用最新技术，是品网视觉的特点，我们只做有灵魂的设计', '1', 'product-show.htm', 'product-list.htm', null, '1', '/106/107', '0');
INSERT INTO `cms_column` VALUES ('108', '', '', '1', 'product-show.htm', 'product-list.htm', null, '1', '/106/108', '0');
INSERT INTO `cms_column` VALUES ('115', '', '', '1', 'show.htm', 'service.htm', null, '1', '/115', '0');
INSERT INTO `cms_column` VALUES ('133', '网站设计 网站制作 网站维护 网站改版', '关于我们', '2', 'about.htm', null, null, '1', '/53/133', '0');
INSERT INTO `cms_column` VALUES ('134', '网站整站优化 网页结构优化 网站关键词优化', '', '2', 'about.htm', null, null, '1', '/53/134', '0');
INSERT INTO `cms_column` VALUES ('135', '英文国际域名 英文国内域名 中文国际域名 中文国内域名', '关于我们', '2', 'about.htm', null, null, '1', '/53/135', '0');
INSERT INTO `cms_column` VALUES ('136', '', '联系我们', '2', 'about.htm', 'about.htm', null, '1', '/52/136', '0');
INSERT INTO `cms_column` VALUES ('138', '', '我们为您提供网站策划、网页设计、程序开发、网站推广、域名注册、虚拟主机、企业邮箱等网站建设相关服务；为您提供iOS/Android/Windows Phone等移动平台的APP应用开发；为您提供办公系统、客户关系管理系统、电子政务系统等行业应用系统的开发；为您提供软件定制开发和系统集成服务。', '2', 'service.htm', 'service.htm', null, '1', '/63/138', '0');
INSERT INTO `cms_column` VALUES ('141', '', '', '2', 'contact.htm', 'contact.htm', null, '1', '/19/141', '0');
INSERT INTO `cms_column` VALUES ('142', '', '', '2', 'advice.htm', null, null, '1', '/19/142', '0');
INSERT INTO `cms_column` VALUES ('146', '', '', '2', 'advertises.htm', 'about.htm', null, '1', '/146', '0');
INSERT INTO `cms_column` VALUES ('147', '', '', '1', 'index.html', 'index.html', null, '1', '/100/147', '0');
INSERT INTO `cms_column` VALUES ('148', '', '', '1', 'index.html', 'index.html', null, '1', '/100/148', '0');

-- ----------------------------
-- Table structure for `comment`
-- ----------------------------
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (
  `COMMENT_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '评论ID（主键）',
  `COMMENT_COMMENTID` int(11) NOT NULL COMMENT '父评论ID',
  `COMMENT_CONTENT` text NOT NULL COMMENT '评论的内容',
  `COMMENT_PICTURE` varchar(300) DEFAULT NULL COMMENT '评论时发布的图片，可上传多张图片',
  `COMMENT_TIME` datetime NOT NULL COMMENT '评论时间',
  `COMMENT_TYPE` int(11) NOT NULL DEFAULT '2' COMMENT '评论的类型：1 匿名，2 公开，默认为公开',
  `COMMENT_PEOPLEID` int(11) DEFAULT '0' COMMENT '评论者ID，默认为非会员用户（即游客）',
  `COMMENT_POINTS` int(11) DEFAULT '0' COMMENT '评价打分（-1至5分）',
  `COMMENT_BASICID` int(11) NOT NULL COMMENT '（文章、商品...）绑定basicId（外键）',
  `COMMENT_APPID` int(11) DEFAULT NULL COMMENT '(文章、商品）绑定的应用编号',
  `COMMENT_FILE_NAME` varchar(255) DEFAULT NULL COMMENT '附件文件名称',
  `COMMENT_FILE_PATH` varchar(255) DEFAULT NULL COMMENT '附件文件路径',
  PRIMARY KEY (`COMMENT_ID`),
  KEY `index2` (`COMMENT_BASICID`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8 COMMENT='评论表';

-- ----------------------------
-- Records of comment
-- ----------------------------

-- ----------------------------
-- Table structure for `diy_form`
-- ----------------------------
DROP TABLE IF EXISTS `diy_form`;
CREATE TABLE `diy_form` (
  `DF_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id',
  `DF_TIPSNAME` varchar(30) NOT NULL COMMENT '自定义表单提示文字',
  `DF_TABLENAME` varchar(20) NOT NULL COMMENT '自定义表单表名',
  `DF_MANAGERID` int(11) NOT NULL COMMENT '自定义表单关联的关联员id',
  `DF_APPID` int(11) DEFAULT NULL COMMENT '自定义表单关联的应用编号',
  PRIMARY KEY (`DF_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义表单表';

-- ----------------------------
-- Records of diy_form
-- ----------------------------

-- ----------------------------
-- Table structure for `diy_form_field`
-- ----------------------------
DROP TABLE IF EXISTS `diy_form_field`;
CREATE TABLE `diy_form_field` (
  `DFF_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '字段自增长id',
  `DFF_TIPSNAME` varchar(30) DEFAULT NULL COMMENT '字段提示文字',
  `DFF_FIELDNAME` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `DFF_TYPE` int(11) DEFAULT NULL COMMENT '字段类型（如1.单行，2.多行，3.图片，等）',
  `DFF_DEFAULT` varchar(250) DEFAULT NULL COMMENT '字段的默认值',
  `DFF_ISNULL` int(11) DEFAULT NULL COMMENT '字段是否为空',
  `DFF_SORT` int(11) DEFAULT NULL COMMENT '自定义表单的排序',
  `DFF_FORMID` int(11) DEFAULT NULL COMMENT '字段管理的表单id',
  PRIMARY KEY (`DFF_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义表单字段表';

-- ----------------------------
-- Records of diy_form_field
-- ----------------------------

-- ----------------------------
-- Table structure for `manager`
-- ----------------------------
DROP TABLE IF EXISTS `manager`;
CREATE TABLE `manager` (
  `MANAGER_ID` bigint(22) NOT NULL AUTO_INCREMENT COMMENT '管理员ID(主键)',
  `MANAGER_NAME` varchar(15) DEFAULT NULL COMMENT '管理员用户名',
  `MANAGER_NICKNAME` varchar(15) DEFAULT NULL COMMENT '管理员昵称',
  `MANAGER_PASSWORD` varchar(45) DEFAULT NULL COMMENT '管理员密码',
  `MANAGER_ROLEID` bigint(22) DEFAULT NULL COMMENT '角色编号',
  `MANAGER_PEOPLEID` bigint(22) DEFAULT '0' COMMENT '用户编号即商家编号',
  `MANAGER_TIME` datetime DEFAULT NULL COMMENT '管理员创建时间',
  PRIMARY KEY (`MANAGER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8 COMMENT='管理员表';

-- ----------------------------
-- Records of manager
-- ----------------------------
INSERT INTO `manager` VALUES ('50', 'msopen', 'msopen', '9d8622060de5f24937b60585c3f4d66b', '48', '0', '2015-09-18 11:54:36');

-- ----------------------------
-- Table structure for `manager_model_page`
-- ----------------------------
DROP TABLE IF EXISTS `manager_model_page`;
CREATE TABLE `manager_model_page` (
  `mmp_managerID` int(11) DEFAULT NULL COMMENT '自增长id',
  `mmp_modelID` int(11) DEFAULT NULL COMMENT '模块编号',
  `mmp_url` varchar(255) DEFAULT NULL COMMENT '默认后台显示的主界面'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='后台主界面管理表';

-- ----------------------------
-- Records of manager_model_page
-- ----------------------------

-- ----------------------------
-- Table structure for `mdiy_content_model`
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_content_model`;
CREATE TABLE `mdiy_content_model` (
  `CM_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id',
  `CM_TIPSNAME` varchar(30) NOT NULL COMMENT '表单提示文字',
  `CM_TABLENAME` varchar(20) NOT NULL COMMENT '表单名称',
  `CM_MANAGERID` int(11) NOT NULL COMMENT '表单管理员ID',
  `CM_MODEL_ID` int(11) DEFAULT NULL COMMENT '模块编号',
  PRIMARY KEY (`CM_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义模型表';

-- ----------------------------
-- Records of mdiy_content_model
-- ----------------------------
INSERT INTO `mdiy_content_model` VALUES ('1', '茶叶', 'mdiy_tea_2', '2', '0');
INSERT INTO `mdiy_content_model` VALUES ('2', '商品品牌', 'mdiy_brand_2', '2', '0');
INSERT INTO `mdiy_content_model` VALUES ('3', '自定义', 'mdiy_mooc_50', '50', '0');

-- ----------------------------
-- Table structure for `mdiy_content_mode_field`
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_content_mode_field`;
CREATE TABLE `mdiy_content_mode_field` (
  `FIELD_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '字段自增长id',
  `FIELD_TIPSNAME` varchar(30) DEFAULT NULL COMMENT '字段提示文字',
  `FIELD_FIELDNAME` varchar(20) DEFAULT NULL COMMENT '字段名称',
  `FIELD_TYPE` int(11) DEFAULT NULL COMMENT '字段类型（如1.单行，2.多行，3.图片，等）',
  `FIELD_DEFAULT` varchar(250) DEFAULT NULL COMMENT '字段默认值',
  `FIELD_ISNULL` int(11) DEFAULT NULL COMMENT '字段是否为空 0:必填 1:可选',
  `FIELD_CMID` int(11) DEFAULT NULL COMMENT '关联内容模型表id',
  `FIELD_SORT` int(11) DEFAULT NULL COMMENT '字段排序',
  `FIELD_ISSEARCH` int(255) DEFAULT NULL COMMENT '字段是否支持后台搜索0：不支持，1：支持',
  `FIELD_LENGTH` int(11) DEFAULT '1' COMMENT '字段长度',
  PRIMARY KEY (`FIELD_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='自定义内容模型关联字段表';

-- ----------------------------
-- Records of mdiy_content_mode_field
-- ----------------------------
INSERT INTO `mdiy_content_mode_field` VALUES ('8', '描述1', 'descripone', '2', null, '1', '3', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('9', '描述2', 'descriptwo', '2', null, '1', '3', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('6', '商品栏目ID', 'BI', '1', null, '1', '2', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('10', '描述3', 'descripTh', '2', null, '1', '3', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('12', '描述5', 'descripFi', '2', null, '1', '3', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('5', '产品参数', 'detail', '2', null, '1', '1', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('11', '描述4', 'descripFo', '2', null, '1', '3', null, '0', '1');
INSERT INTO `mdiy_content_mode_field` VALUES ('7', '多图', 'images', '7', null, '1', '3', null, '0', '1');

-- ----------------------------
-- Table structure for `mdiy_search`
-- ----------------------------
DROP TABLE IF EXISTS `mdiy_search`;
CREATE TABLE `mdiy_search` (
  `SEARCH_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `SEARCH_NAME` varchar(20) NOT NULL COMMENT '搜索名称',
  `SEARCH_TEMPLETS` varchar(50) NOT NULL COMMENT '搜索结果模版',
  `SEARCH_WEBSITEID` int(11) NOT NULL COMMENT '搜索管理的应用id',
  PRIMARY KEY (`SEARCH_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8 COMMENT='自定义搜索表';

-- ----------------------------
-- Records of mdiy_search
-- ----------------------------
INSERT INTO `mdiy_search` VALUES ('1', '头部', 'search.htm', '1');
INSERT INTO `mdiy_search` VALUES ('9', '列表页面搜索', 'search-list.htm', '1');

-- ----------------------------
-- Table structure for `model`
-- ----------------------------
DROP TABLE IF EXISTS `model`;
CREATE TABLE `model` (
  `MODEL_ID` int(22) NOT NULL AUTO_INCREMENT COMMENT '模块自增长id',
  `MODEL_TITLE` varchar(150) DEFAULT NULL COMMENT '模块标题',
  `MODEL_CODE` varchar(255) DEFAULT NULL COMMENT '模块编码',
  `MODEL_MODELID` int(22) DEFAULT NULL COMMENT '模块的父模块id',
  `MODEL_URL` varchar(255) DEFAULT NULL COMMENT '模块连接地址',
  `MODEL_DATETIME` datetime DEFAULT NULL,
  `MODEL_ICON` varchar(120) DEFAULT NULL COMMENT '模块图标',
  `MODEL_MODELMANAGERID` int(11) DEFAULT NULL COMMENT '模块关联的关联员id',
  `MODEL_SORT` int(11) DEFAULT NULL COMMENT '模块的排序',
  `MODEL_ISMENU` int(1) DEFAULT NULL COMMENT '模块是否是菜单',
  PRIMARY KEY (`MODEL_ID`),
  UNIQUE KEY `SYS_C009201` (`MODEL_ID`),
  KEY `MODEL_MODELID` (`MODEL_MODELID`),
  KEY `model_code` (`MODEL_CODE`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8 COMMENT='模块表';

-- ----------------------------
-- Records of model
-- ----------------------------
INSERT INTO `model` VALUES ('1', '内容管理', '02000000', '0', '', '2014-08-01 16:19:50', '&#xe77a;', '0', null, null);
INSERT INTO `model` VALUES ('4', '管理员管理', '01020000', '23', 'manager/queryList.do', '2014-08-03 09:15:02', '', '0', null, null);
INSERT INTO `model` VALUES ('5', '角色管理', '01010000', '23', 'role/queryList.do', '2014-08-03 09:15:14', '', '0', null, null);
INSERT INTO `model` VALUES ('7', '栏目管理', '02990000', '1', 'cms/column/list.do', '2014-08-03 09:16:29', '', '0', null, null);
INSERT INTO `model` VALUES ('8', '文章管理', '02980000', '1', 'cms/article/index.do', '2014-08-03 09:17:10', '', '0', null, null);
INSERT INTO `model` VALUES ('22', '会员中心', '07000000', '0', '', '2014-09-08 08:11:28', '&#xe6b6;', '0', null, '1');
INSERT INTO `model` VALUES ('23', '权限管理', '01000000', '0', '', '2014-09-08 08:12:22', '&#xe950;', '0', null, null);
INSERT INTO `model` VALUES ('35', '自定义模型', '02060000', '84', 'mdiy/contentModel/list.do', '2014-10-13 18:27:23', '', '0', null, null);
INSERT INTO `model` VALUES ('36', '自定义搜索', '02050000', '84', 'mdiy/search/list.do', '2014-10-13 18:28:34', '', '0', null, null);
INSERT INTO `model` VALUES ('79', '生成器', '11000000', '0', '', '2014-12-18 11:36:16', '&#xe6cc;', '0', null, null);
INSERT INTO `model` VALUES ('80', '生成主页', '11010000', '79', 'cms/generate/index.do', '2014-12-18 11:37:15', '', '0', null, null);
INSERT INTO `model` VALUES ('81', '生成栏目', '11020000', '79', 'cms/generate/column.do', '2014-12-18 11:37:53', '', '0', null, null);
INSERT INTO `model` VALUES ('82', '生成文章', '11030000', '79', 'cms/generate/article.do', '2014-12-18 11:38:38', '', '0', null, null);
INSERT INTO `model` VALUES ('84', '系统管理', '12000000', '0', '', '2014-12-18 18:30:24', '&#xe71f;', '0', null, null);
INSERT INTO `model` VALUES ('86', '应用设置', '12010000', '84', 'app/-1/edit.do', '2014-12-18 18:31:59', '', '0', null, null);
INSERT INTO `model` VALUES ('88', '用户管理', '07020100', '22', 'people/user/list.do', '2015-09-18 11:44:54', '', '0', null, '1');
INSERT INTO `model` VALUES ('89', '自定义页面', '12030100', '84', 'mdiy/modeltemplate/list.do', '2015-09-18 17:32:04', null, '0', null, null);
INSERT INTO `model` VALUES ('90', '自定义表单', '12050000', '84', 'mdiy/diyForm/form/list.do', '2015-09-18 22:06:02', null, null, null, null);
INSERT INTO `model` VALUES ('91', '模板管理', '12020000', '84', 'template/queryTemplateSkin.do', null, null, null, null, null);

-- ----------------------------
-- Table structure for `model_template`
-- ----------------------------
DROP TABLE IF EXISTS `model_template`;
CREATE TABLE `model_template` (
  `mt_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长id',
  `mt_modelID` int(11) DEFAULT NULL COMMENT '模块id',
  `mt_appID` int(11) DEFAULT NULL COMMENT '应用id',
  `mt_path` varchar(255) DEFAULT NULL COMMENT '自定义页面绑定模板的路径',
  `mt_title` varchar(255) DEFAULT NULL COMMENT '自定义页面标题',
  `mt_key` varchar(255) DEFAULT NULL COMMENT '自定义页面访问路径',
  PRIMARY KEY (`mt_id`),
  KEY `mt_key` (`mt_key`) USING BTREE,
  KEY `mt_appID` (`mt_appID`),
  KEY `mt_modelID` (`mt_modelID`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='自定义页面表';

-- ----------------------------
-- Records of model_template
-- ----------------------------
INSERT INTO `model_template` VALUES ('1', '0', '1', 'register.htm', '注册', 'register');
INSERT INTO `model_template` VALUES ('2', '0', '1', 'login.htm', '登录', 'login');
INSERT INTO `model_template` VALUES ('3', '0', '1', 'userCenter.htm', '个人中心', 'people/userCenter');
INSERT INTO `model_template` VALUES ('4', '0', '1', 'changePassWord.htm', '修改密码', 'changePassWord');

-- ----------------------------
-- Table structure for `people`
-- ----------------------------
DROP TABLE IF EXISTS `people`;
CREATE TABLE `people` (
  `PEOPLE_ID` int(11) NOT NULL AUTO_INCREMENT COMMENT '增长自ID',
  `PEOPLE_PHONE` varchar(30) DEFAULT NULL COMMENT '手机号码',
  `PEOPLE_NAME` varchar(30) DEFAULT NULL COMMENT '陆登账号',
  `PEOPLE_PASSWORD` varchar(50) DEFAULT NULL COMMENT '陆登密码',
  `PEOPLE_DATETIME` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '注册时间',
  `PEOPLE_APP_ID` int(11) NOT NULL COMMENT '用户所属用户ID',
  `PEOPLE_MAIL` varchar(120) DEFAULT NULL COMMENT '用户邮箱',
  `PEOPLE_STATE` int(2) DEFAULT '0' COMMENT '用户状态',
  `PEOPLE_CODE` varchar(15) DEFAULT NULL COMMENT '随机验证码',
  `PEOPLE_CODESENDDATE` datetime DEFAULT NULL,
  `PEOPLE_PHONECHECK` int(1) DEFAULT NULL,
  `PEOPLE_MAILLCHECK` int(1) DEFAULT NULL,
  PRIMARY KEY (`PEOPLE_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='户用基础表';

-- ----------------------------
-- Records of people
-- ----------------------------

-- ----------------------------
-- Table structure for `people_user`
-- ----------------------------
DROP TABLE IF EXISTS `people_user`;
CREATE TABLE `people_user` (
  `PU_PEOPLE_ID` int(11) NOT NULL COMMENT '用户ID关联people表的（people_id）',
  `PU_REAL_NAME` varchar(50) DEFAULT NULL COMMENT '用户真实名称',
  `PU_ADDRESS` varchar(200) DEFAULT NULL COMMENT '用户地址',
  `PU_ICON` varchar(200) DEFAULT NULL COMMENT '用户头像图标地址',
  `PU_NICKNAME` varchar(50) DEFAULT NULL COMMENT '用户昵称',
  `PU_SEX` int(2) DEFAULT NULL COMMENT '用户性别(0.未知、1.男、2.女)',
  `PU_BIRTHDAY` date DEFAULT NULL COMMENT '用户出生年月日',
  `PU_CARD` varchar(255) DEFAULT NULL COMMENT '身份证',
  `PU_APP_ID` int(11) NOT NULL COMMENT '用户所属应用ID',
  `PU_PROVINCE` int(11) DEFAULT '0' COMMENT '省',
  `PU_CITY` int(11) DEFAULT '0' COMMENT '城市',
  `PU_DISTRICT` int(11) DEFAULT '0' COMMENT '区',
  `PU_STREET` int(11) DEFAULT '0' COMMENT '街道',
  PRIMARY KEY (`PU_PEOPLE_ID`),
  KEY `PU_PEOPLE_ID` (`PU_PEOPLE_ID`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户基础信息表';

-- ----------------------------
-- Records of people_user
-- ----------------------------

-- ----------------------------
-- Table structure for `role`
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `ROLE_ID` bigint(22) NOT NULL AUTO_INCREMENT COMMENT '角色ID，自增长',
  `ROLE_NAME` varchar(30) DEFAULT NULL COMMENT '角色名',
  `ROLE_MANAGERID` bigint(22) DEFAULT '0' COMMENT '角色管理员编号',
  PRIMARY KEY (`ROLE_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES ('48', 'msopen', '50');

-- ----------------------------
-- Table structure for `role_model`
-- ----------------------------
DROP TABLE IF EXISTS `role_model`;
CREATE TABLE `role_model` (
  `RM_MODELID` int(22) DEFAULT NULL COMMENT '模块编号',
  `RM_ROLEID` int(22) DEFAULT NULL COMMENT '角色编号',
  UNIQUE KEY `index` (`RM_MODELID`,`RM_ROLEID`) USING BTREE,
  KEY `RM_MODELID` (`RM_MODELID`) USING BTREE,
  CONSTRAINT `role_model_ibfk_1` FOREIGN KEY (`RM_MODELID`) REFERENCES `model` (`MODEL_ID`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色模块关联表';

-- ----------------------------
-- Records of role_model
-- ----------------------------
INSERT INTO `role_model` VALUES ('1', '48');
INSERT INTO `role_model` VALUES ('4', '48');
INSERT INTO `role_model` VALUES ('5', '48');
INSERT INTO `role_model` VALUES ('7', '48');
INSERT INTO `role_model` VALUES ('8', '48');
INSERT INTO `role_model` VALUES ('22', '48');
INSERT INTO `role_model` VALUES ('23', '48');
INSERT INTO `role_model` VALUES ('35', '48');
INSERT INTO `role_model` VALUES ('36', '48');
INSERT INTO `role_model` VALUES ('79', '48');
INSERT INTO `role_model` VALUES ('80', '48');
INSERT INTO `role_model` VALUES ('81', '48');
INSERT INTO `role_model` VALUES ('82', '48');
INSERT INTO `role_model` VALUES ('84', '48');
INSERT INTO `role_model` VALUES ('86', '48');
INSERT INTO `role_model` VALUES ('88', '48');
INSERT INTO `role_model` VALUES ('89', '48');
INSERT INTO `role_model` VALUES ('90', '48');
INSERT INTO `role_model` VALUES ('91', '48');

-- ----------------------------
-- Table structure for `system_main_page`
-- ----------------------------
DROP TABLE IF EXISTS `system_main_page`;
CREATE TABLE `system_main_page` (
  `smp_appID` int(11) DEFAULT NULL COMMENT '自增长ID',
  `smp_url` varchar(255) DEFAULT NULL COMMENT '默认后台显示的主界面',
  `smp_modelID` int(11) DEFAULT NULL COMMENT '模块编号',
  `smp_managerID` int(11) DEFAULT NULL COMMENT '管理员编号'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='后台主界面管理界面';

-- ----------------------------
-- Records of system_main_page
-- ----------------------------

-- ----------------------------
-- Table structure for `system_skin`
-- ----------------------------
DROP TABLE IF EXISTS `system_skin`;
CREATE TABLE `system_skin` (
  `ss_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '自增长ID',
  `ss_loginpage` varchar(255) DEFAULT NULL COMMENT '登陆页面',
  `ss_backgroundimg` varchar(255) DEFAULT NULL COMMENT '背景图片',
  `ss_color` varchar(255) DEFAULT NULL COMMENT '字体颜色',
  `ss_css` varchar(255) DEFAULT NULL COMMENT '样式',
  `ss_datetime` datetime DEFAULT NULL COMMENT '生成时间',
  `ss_appID` int(11) DEFAULT NULL COMMENT '0后台发布大于０表示是应用自定义',
  `ss_categoryID` int(11) DEFAULT NULL COMMENT '主题分类',
  PRIMARY KEY (`ss_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='后台皮肤管理表';

-- ----------------------------
-- Records of system_skin
-- ----------------------------

-- ----------------------------
-- Table structure for `system_skin_manager`
-- ----------------------------
DROP TABLE IF EXISTS `system_skin_manager`;
CREATE TABLE `system_skin_manager` (
  `ssm_managerID` int(11) NOT NULL DEFAULT '0' COMMENT '系统管理员编号',
  `ssm_system_skin_ID` int(11) DEFAULT NULL COMMENT '系统皮肤管理员编号',
  PRIMARY KEY (`ssm_managerID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='系统皮肤与管理员关联表';

-- ----------------------------
-- Records of system_skin_manager
-- ----------------------------

-- ----------------------------
-- View structure for `v_article`
-- ----------------------------
DROP VIEW IF EXISTS `v_article`;
CREATE  VIEW `v_article` AS select `cms_article`.`ARTICLE_BASICID` AS `ARTICLE_BASICID`,`basic`.`BASIC_ID` AS `BASIC_ID`,`basic`.`BASIC_CATEGORYID` AS `BASIC_CATEGORYID`,`basic`.`BASIC_TITLE` AS `BASIC_TITLE`,`basic`.`BASIC_DESCRIPTION` AS `BASIC_DESCRIPTION`,`basic`.`BASIC_THUMBNAILS` AS `BASIC_THUMBNAILS`,`basic`.`BASIC_HIT` AS `BASIC_HIT`,`basic`.`BASIC_DATETIME` AS `BASIC_DATETIME`,`basic`.`BASIC_UPDATETIME` AS `BASIC_UPDATETIME`,`basic`.`BASIC_PEOPLEID` AS `BASIC_PEOPLEID`,`cms_article`.`ARTICLE_AUTHOR` AS `ARTICLE_AUTHOR`,`cms_article`.`ARTICLE_CONTENT` AS `ARTICLE_CONTENT`,`cms_article`.`ARTICLE_TYPE` AS `ARTICLE_TYPE`,`cms_article`.`ARTICLE_SOURCE` AS `ARTICLE_SOURCE`,`cms_article`.`ARTICLE_URL` AS `ARTICLE_URL`,`cms_article`.`ARTICLE_KEYWORD` AS `ARTICLE_KEYWORD`,`cms_article`.`ARTICLE_FREEORDER` AS `ARTICLE_FREEORDER`,`cms_article`.`ARTICLE_WEBID` AS `ARTICLE_WEBID`,`cms_column`.`COLUMN_KEYWORD` AS `COLUMN_KEYWORD`,`cms_column`.`COLUMN_DESCRIP` AS `COLUMN_DESCRIP`,`cms_column`.`COLUMN_TYPE` AS `COLUMN_TYPE`,`cms_column`.`COLUMN_URL` AS `COLUMN_URL`,`cms_column`.`COLUMN_LISTURL` AS `COLUMN_LISTURL`,`cms_column`.`COLUMN_TENTMODELID` AS `COLUMN_TENTMODELID`,`cms_column`.`COLUMN_WEBSITEID` AS `COLUMN_WEBSITEID`,`cms_column`.`COLUMN_PATH` AS `column_path`,`cms_column`.`COLUMN_CONTENTMODELID` AS `COLUMN_CONTENTMODELID`,`category`.`CATEGORY_TITLE` AS `CATEGORY_TITLE`,`category`.`CATEGORY_APPID` AS `CATEGORY_APPID`,`cms_column`.`COLUMN_CATEGORYID` AS `COLUMN_CATEGORYID`,`category`.`CATEGORY_ID` AS `CATEGORY_ID`,`basic`.`BASIC_SORT` AS `BASIC_SORT` from (((`basic` join `cms_article` on((`basic`.`BASIC_ID` = `cms_article`.`ARTICLE_BASICID`))) join `cms_column` on((`basic`.`BASIC_CATEGORYID` = `cms_column`.`COLUMN_CATEGORYID`))) join `category` on((`cms_column`.`COLUMN_CATEGORYID` = `category`.`CATEGORY_ID`))) ;

-- ----------------------------
-- View structure for `v_people_user`
-- ----------------------------
DROP VIEW IF EXISTS `v_people_user`;
CREATE  VIEW `v_people_user` AS select `people`.`PEOPLE_ID` AS `PEOPLE_ID`,`people`.`PEOPLE_PHONE` AS `PEOPLE_PHONE`,`people`.`PEOPLE_NAME` AS `PEOPLE_NAME`,`people`.`PEOPLE_PASSWORD` AS `PEOPLE_PASSWORD`,`people`.`PEOPLE_DATETIME` AS `PEOPLE_DATETIME`,`people`.`PEOPLE_APP_ID` AS `PEOPLE_APP_ID`,`people`.`PEOPLE_MAIL` AS `PEOPLE_MAIL`,`people`.`PEOPLE_STATE` AS `PEOPLE_STATE`,`people`.`PEOPLE_CODE` AS `PEOPLE_CODE`,`people`.`PEOPLE_CODESENDDATE` AS `PEOPLE_CODESENDDATE`,`people`.`PEOPLE_PHONECHECK` AS `PEOPLE_PHONECHECK`,`people`.`PEOPLE_MAILLCHECK` AS `PEOPLE_MAILLCHECK`,`people_user`.`PU_PEOPLE_ID` AS `PU_PEOPLE_ID`,`people_user`.`PU_REAL_NAME` AS `PU_REAL_NAME`,`people_user`.`PU_ADDRESS` AS `PU_ADDRESS`,`people_user`.`PU_ICON` AS `PU_ICON`,`people_user`.`PU_NICKNAME` AS `PU_NICKNAME`,`people_user`.`PU_SEX` AS `PU_SEX`,`people_user`.`PU_BIRTHDAY` AS `PU_BIRTHDAY`,`people_user`.`PU_CARD` AS `PU_CARD`,`people_user`.`PU_APP_ID` AS `PU_APP_ID` from (`people` left join `people_user` on((`people`.`PEOPLE_ID` = `people_user`.`PU_PEOPLE_ID`))) ;

-- ----------------------------
-- Procedure structure for `p_getAllChildren`
-- ----------------------------
DROP PROCEDURE IF EXISTS `p_getAllChildren`;
DELIMITER ;;
CREATE  PROCEDURE `p_getAllChildren`(`pId` int,`appId`int,`modelId` int)
BEGIN
	
   declare lev int;
   set lev=1;
   drop TEMPORARY table if exists tmp_category;    
   drop TEMPORARY table if exists tmp_category_child;    
   CREATE  TEMPORARY TABLE  tmp_category(category_id int(40),category_title varchar(50),category_categoryid varchar(40) ,lev INT) engine=memory;    
   CREATE  TEMPORARY TABLE  tmp_category_child(category_id int(40),category_title varchar(50),category_categoryid varchar(40) ,lev INT) engine=memory;    
   INSERT tmp_category SELECT category_id,category_title,category_categoryid,1 FROM `category` WHERE category_categoryid=pid and category_appid=appId and category_modelId=modelId;    
   INSERT tmp_category_child SELECT category_id,category_title,category_categoryid,1 FROM `category` WHERE category_categoryid=pid and category_appid=appId and category_modelId=modelId;   
  while ROW_COUNT()>0 
    do     set lev=lev+1; 
     INSERT tmp_category SELECT c.category_id,c.category_title,c.category_categoryid,lev  from category c  join tmp_category_child a on c.category_categoryid = a.category_id AND a.lev=lev-1 and c.category_appid=appId and c.category_modelId=modelId;
     INSERT tmp_category_child SELECT c.category_id,c.category_title,c.category_categoryid,lev  from category c  join tmp_category a on c.category_categoryid = a.category_id AND a.lev=lev-1 and c.category_appid=appId and c.category_modelId=modelId;
  end while ;    
  INSERT tmp_category SELECT c.category_id,c.category_title,c.category_categoryid,0 FROM category  c WHERE c.category_id=pid and c.category_appid=appId and c.category_modelId=modelId;   
  SELECT * FROM tmp_category;
END
;;
DELIMITER ;
